import { Vec2,Node, Vec3 } from "cc";
import { cameraCtrl, } from "../globle/cameraCtrl";
import { preloadRes } from "../globle/preloadRes";
import { tonyInfo } from "../globle/tonyInfo";
import { towerCtrl } from "../globle/towerCtrl";
import { BezierF } from "./BezierF";

export class bullet 
{
    private m_beClear:number = 0; //= 1表示可以被删除
    private m_meshID:number = 0; // 动画类型 1 序列帧 2 = spine
    private m_meshState:number = 0; // 0 = 不显示 1 = 显示
    private m_targetRoomID:number = 0;//攻击对象
    private m_type:number = 0 ; //0=不需要碰撞检查 1 = 需要碰撞检查
    private m_targetPosX:number = 0;
    private m_targetPosY:number = 0;
    private m_speed:number = 0;
    private m_dir:Vec2 = new Vec2(0,0);//行走的分量
    private m_moveState:number = 0;
    private m_angle:number = 0;
    private m_linePathIndex:number = 0;
    private m_linePathX = [];
    private m_linePathY = [];
    private m_roomID:number = 0;
    private m_bulletID:number = 0;
    private m_posX:number = 0 ;
    private m_posY:number = 0;
    private m_meshNode:Node = null;
    private m_bezierF:BezierF = null;
    private m_nextPosX:number = 0;
    private m_nextPosY:number = 0;
    private m_bezierCurTime:number = 0;
    private m_power:number = 5;
    private m_clearTime:number = 2;
    private m_fromObj = null;
    private m_show:number = 0;//1 = 不显示//是否显示子弹
    private m_bulletType:number = 0;//1 = 实时检查碰撞， 2 = 实时检查碰撞，加穿透

    constructor()
    {
        
    }
    public initData(_data:any)
    {
        this.resetData();
        this.m_bezierCurTime = 0;
        this.m_beClear = 1;
        this.m_clearTime = 2;
        let roomID = _data.roomID;
        this.m_roomID = roomID;
        this.m_posX = _data.posX;
        this.m_posY = _data.posY;
        this.m_meshID = _data.meshID;
        this.m_speed = _data.speed;
        this.m_bulletType = 0;
        if(_data.bulletType)
        {
            this.m_bulletType = _data.bulletType;
        }
        if(_data.showState)
        {
            this.m_show = _data.showState;
        }
        
        // this.m_linePathX = _data.bulletLinePathX;
        // this.m_linePathY = _data.bulletLinePathY;
        this.m_targetPosX = _data.targetPosX;
        this.m_targetPosY = _data.targetPosY;
        this.m_nextPosX = this.m_targetPosX;
        this.m_nextPosY = this.m_targetPosY;
        this.m_fromObj = _data.acter;
        //console.log("初始化自动==",_data,this.m_targetPosX,this.m_targetPosY);
        this.m_linePathIndex = 0;

       // this.initBezier();
        this.getMoveDir();
        
    }
    initBezier()
    {
        let bezierStartPos = new Vec3(this.m_posX,this.m_posY,0);
        let bezierEndPos = new Vec3(this.m_targetPosX,this.m_targetPosY,0);
        let tmpHeight = 100;

        let czY = (bezierStartPos.y+bezierEndPos.y)/2+tmpHeight;
        let czX = bezierStartPos.x-bezierEndPos.x;

        let ctrlPosY = czY;
        let ctrlPosX = bezierStartPos.x-czX/2;
        let ctrlPos = new Vec2(ctrlPosX,ctrlPosY);

        let bezierArr = [];

        bezierArr.push(bezierStartPos,ctrlPos,bezierEndPos);
        let bezierCurve = null;
        if(!this.m_bezierF)
        {
            bezierCurve = new BezierF(bezierArr,2);
            this.m_bezierF = bezierCurve;
        }
        else
        {
            this.m_bezierF.initFunc(bezierArr,2);
            bezierCurve = this.m_bezierF;
        }
        let points = bezierCurve.getPoints();
        let len=bezierCurve.getTotalLen();
        let distance = len;
        let needTime = distance / this.m_speed;
        bezierCurve.setRunTime(needTime);


     
       

        let tmpPos=this.m_bezierF.getCurPointByTime(0.1);
        // this.m_posX =tmpPos.x;
        // this.m_posY = tmpPos.y;
        this.m_nextPosX = tmpPos.x;
        this.m_nextPosY = tmpPos.y;
        // this.m_nextPos = new cc.Vec2(tmpPos.x,tmpPos.y);
        // let dir = this.m_nextPos.sub(this.m_curPos).normalize();
        // let angle=Math.atan2(dir.y,dir.x);
        // let degre=angle*180/Math.PI;
        // this.updateNodeAngle(degre);

    }
    public getMeshID()
    {
        return this.m_meshID;
    }
    public destoryState()//对象被标记为可以删除
    {
        this.m_beClear = 1000;
       // console.log("准备删除对象==");
        
    }
    public setState(_state)
    {
        this.m_beClear = _state;
    }
    public resetData()//重置数据
    {
        this.m_beClear = 0;
        this.m_show = 0;
    }
    public getDestoryState()
    {
        return this.m_beClear;
    }
    public getMeshNode():Node
    {
        return this.m_meshNode;
    }
    public setMeshNode(_node)
    {
        this.m_meshNode = _node;
    }
    public getMeshState()
    {

        return this.m_meshState ; 
    }
    public getPosX()
    {
        return this.m_posX;
    }
    public getPosY()
    {
        return this.m_posY;
    }
    public getID()
    {
        return this.m_roomID;
    }
    public checkIsOutOfCamera()//检查是否在可视范围内
    {
        let outState = 0;
        this.m_meshState = 0;
        if(this.m_show == 0)
        {
            outState = cameraCtrl.instance().checkIsOutOfView(this.m_posX,this.m_posY);
            this.m_meshState = outState;
        }
    }
    public atPlayerRange()//在玩家附近
    {
        let cameraX = cameraCtrl.instance().getCameraX();
        let cameraY = cameraCtrl.instance().getCameraY();
        let limitX = 3000;
        let tmpState = 0;//0 不在玩家范围内 不做多余的逻辑  2 = 在范围内需要做逻辑
        if(this.m_posX > (cameraX-limitX) && this.m_posX <(cameraX + limitX))
        {
            tmpState = 1;
        }
        if(tmpState == 1)
        {
            if(this.m_posY > (cameraY - limitX) && this.m_posY <(cameraY + limitX))
            {
                tmpState = 2;
            }
        }
        return tmpState ; 
    }
    public checkResult()//子弹到达终点 计算结果
    {
        if(this.m_targetRoomID > 0)
        {
            
        }
        else
        {
            console.log("没有攻击目标");
        }
    }
    public isMoveGoal()//是否移动到目标点
    {
       let point1 = new Vec2(this.m_posX,this.m_posY);
       let point2 = new Vec2(this.m_targetPosX,this.m_targetPosY);
       let len = tonyInfo.instance().distance(point1,point2);
       //console.log("是否到总店==",len,this.m_roomID,this.m_targetPosX,this.m_targetPosY);
       let offsetN = 20;
       if(len <= offsetN )
       {
            if(this.m_bulletType == 0)
            {
                this.checkCollid(len);
            }
            else
            {
                this.m_moveState = 0;
                this.destoryState();
            }
       }

       
    }
    public getMoveDir()
    {
        let curPos:Vec2 = new Vec2(this.m_posX,this.m_posY);
        // let tmpTargetX = this.m_linePathX[this.m_linePathIndex];
        // let tmpTargetY = this.m_linePathY[this.m_linePathIndex];
        // this.m_targetPosX = tmpTargetX;
        // this.m_targetPosY = tmpTargetY;

        let targetPos:Vec2 = new Vec2(this.m_nextPosX,this.m_nextPosY);
        let point = targetPos.subtract(curPos);
        let dir = point.normalize();
        this.m_dir = dir;
        this.m_moveState = 1;
        
        let angle=Math.atan2(dir.y,dir.x);
        let degre=angle*180/Math.PI;
        this.m_angle = degre;

    }
    public getAngle()
    {
        return this.m_angle;
    }
    public move(_dt)
    {
        this.m_bezierCurTime  += _dt;
        this.getMoveDir();
        if(this.m_bezierF)
        {
            let tmpPos = this.m_bezierF.getCurPointByTime(this.m_bezierCurTime);
            if(tmpPos.state == 0)
            {
                this.m_posX = tmpPos.x;
                this.m_posY = tmpPos.y;
                tmpPos=this.m_bezierF.getCurPointByTime(this.m_bezierCurTime+0.05);
                this.m_nextPosX = tmpPos.x;
                this.m_nextPosY = tmpPos.y;
            }
            else
            {
                this.m_bezierF.resetData();
            }
            
        }
        this.m_posX += this.m_dir.x*this.m_speed*_dt;
        this.m_posY += this.m_dir.y*this.m_speed*_dt;

      
        if(this.m_bulletType == 1)
        {
            this.checkCollid(100);
        }
        this.isMoveGoal();
    }
    public checkCollid(_len:number = 0)
    {
        let isClear = 0;
        let curBlockIndex = tonyInfo.instance().getBlockIndexByPos(this.m_posX,this.m_posY);

        if(tonyInfo.instance().m_mapMTLayerArr[curBlockIndex])
        {
            //let tmpType = tonyInfo.instance().m_mapMTLayerArr[curBlockIndex].getMTType();
            let dynamicArr = tonyInfo.instance().m_mapMTLayerArr[curBlockIndex].getAllCollid();
            for(let item in dynamicArr)
            {
                let campID = dynamicArr[item].getCampID();
                let tmpRoomID = dynamicArr[item].getRoomID();
                let fromRoomID = this.m_fromObj.getRoomID();
                let fromCampID = this.m_fromObj.getCampID();
                if(fromRoomID == tmpRoomID)
                {
                    
                    continue;
                }
                //console.log("TestCmaID==",campID);
                if(campID >= 100)
                {
                    let targetPosX = dynamicArr[item].getPosX();
                    let targetPosY = dynamicArr[item].getPosY();
                    let rectW = dynamicArr[item].getActRectW();
                    let rectH = dynamicArr[item].getActRectH();
                    let name = dynamicArr[item].getName();
                    let roomID = dynamicArr[item].getRoomID();
                    
                    let rect = tonyInfo.instance().pointToRect(this.m_posX,this.m_posY,targetPosX,targetPosY,rectW,rectH);
                    let hp = dynamicArr[item].getHP();
                   // console.log("是否碰撞==",rect,hp,rectW,rectH,name,roomID);
                    if(rect == 2 && hp > 0)
                    {
                        dynamicArr[item].beAttack(this.m_fromObj)
                        isClear  =1;
                        //console.log("碰撞到了怪物==");
                        break;
                    }
                }
                
            }
            if(isClear == 0)
            {
                
                // if(tmpType > 0)
                // {
                //     let mtCfg = preloadRes.instance().getMTCfgByID(tmpType);
                //     if(mtCfg)
                //     {
                //         if(mtCfg.type = 12)
                //         {
                //             let tmpTower = towerCtrl.instance().getTowerByIndex(curBlockIndex);
                //             if(tmpTower)
                //             {
                //                 let campID = tmpTower.getCampID();
                //                 let tmpRoomID = tmpTower.getRoomID();
                //                 let fromRoomID = this.m_fromObj.getRoomID();
                //                 let fromCampID = this.m_fromObj.getCampID();
                //                 let isUpdate = 0;
                //                 if(fromRoomID == tmpRoomID||fromCampID == campID)
                //                 {
                //                     //console.log("自己人==");
                //                     isUpdate = 1;
                //                 }
                //                 if(isUpdate == 0)
                //                 {
                //                     let hp  = tmpTower.getHP();
                //                     tmpTower.beAttack(this.m_fromObj);
                //                 }
                //             }
                    
                //         }
                //     }
                // }
            }
            
        }
        
        if(_len <= 10)
        {
            isClear = 1;
        }
        if(isClear == 1)
        {
            this.m_moveState = 0;
            this.destoryState();
        }
    }
    public update(_dt:number)
    {
        if(this.m_moveState == 1)
        {
            this.move(_dt);
        }
        // if(this.m_beClear == 1)
        // {
            
        // }
        // else if(this.m_beClear == 3)//箭插地上不消失
        // {
        //     this.m_clearTime -=_dt;

        //     if(this.m_clearTime <= 0)
        //     {
        //         this.destoryState();
        //     }
        // }
        
        this.checkIsOutOfCamera();
        
    }
}