import { instantiate,Node,Vec3, Prefab } from "cc";
import { preloadRes } from "../globle/preloadRes";
import { bullet } from "./bullet";
import { BulletUI } from "./bulletUI";

export class bulletManager {

    public m_bulletArr :Array<bullet>= [];
    private m_bulletMeshPool = [];
    private m_parent:Node = null;
    private m_bulletPrefab:Prefab = null;

    private static ince:bulletManager;
    public static instance(): bulletManager{
        if(this.ince == undefined){
            this.ince = new bulletManager();
        }
        return this.ince;
    }
    initBulletManager(_parent:Node)
    {
        
        this.m_parent = _parent;
    }
    public setBulletPrefab(_bullet:Prefab)
    {
        this.m_bulletPrefab = _bullet;
    }
    getBulletMesh():Node
    {
        let tmpBullet = null;
        let poolSize = this.m_bulletMeshPool.length;
        
        if(poolSize <= 0)
        {
            tmpBullet = instantiate(this.m_bulletPrefab);
            tmpBullet.parent = this.m_parent;
            tmpBullet.x = 0;
            tmpBullet.y = 0;
        }
        else
        {
            tmpBullet = this.m_bulletMeshPool.pop();
            tmpBullet.parent = this.m_parent;
            tmpBullet.x = 0;
            tmpBullet.y = 0;
            //console.log("getBulletMeshFromCache");
        }
        return tmpBullet;
    }
    createBullet(_bulletData:any = null)
    {
        
        let tmpBullet:bullet = null;
      
        for(let i = 0 ; i< this.m_bulletArr.length ; i++)
        {
            let tmpState = this.m_bulletArr[i].getDestoryState();
            if(tmpState == 1001)
            {
                tmpBullet = this.m_bulletArr[i];
                break;
            }
        }
        if(!tmpBullet)
        {
            tmpBullet = new bullet();
            this.m_bulletArr.push(tmpBullet);
            //console.log("createBulletFromPrefab");
        }
        //console.log("CreateBullet==",_bulletData);
        tmpBullet.initData(_bulletData);
        //let id = _monsterData.id;
       
    }
  
    updateBullet(_dt:number)
    {
        let len = this.m_bulletArr.length;
        for(let i =0  ; i < len; i++)
        {
            if(this.m_bulletArr[i])
            {
                let tmpState = this.m_bulletArr[i].getDestoryState();
                let roomID = this.m_bulletArr[i].getID();
                if(tmpState < 1000)
                {
                    this.m_bulletArr[i].update(_dt);
                    let showMesh = this.m_bulletArr[i].getMeshState();
                    let meshNode = this.m_bulletArr[i].getMeshNode();
                    //console.log("showBulletMesh==",showMesh);
                    if(showMesh == 1)
                    {
                        let posX = this.m_bulletArr[i].getPosX();
                        let posY = this.m_bulletArr[i].getPosY();
                        let meshID = this.m_bulletArr[i].getMeshID();
                        let roomID = this.m_bulletArr[i].getID();
                        let angle = this.m_bulletArr[i].getAngle();
                        let tmpData2 = 
                        {
                            "meshID":meshID,
                            "roomID":roomID,
                            "id":1,
                            "posX":posX,
                            "posY":posY,
                            "angle":angle
                        };
                        //let bulletUI = meshNode.get
                        if(!meshNode)
                        {
                            meshNode = this.getBulletMesh();
                            this.m_bulletArr[i].setMeshNode(meshNode);
                        }
                        meshNode.active  = true;
                        meshNode.setPosition(new Vec3(posX,posY,0));
                        meshNode.angle = angle;
                    }
                    else
                    {
                        if(meshNode)
                        {
                            meshNode.active = false;
                            this.m_bulletMeshPool.push(meshNode);
                            this.m_bulletArr[i].setMeshNode(null);
                        }
                        
                        
                        //this.collectBulletMesh(roomID);
                    }
                }
                else if(tmpState == 1000)
                {
                    //this.collectBulletMesh(roomID);
                    let meshNode = this.m_bulletArr[i].getMeshNode();
                    if(meshNode)
                    {
                        meshNode.active = false;
                        this.m_bulletMeshPool.push(meshNode);
                        this.m_bulletArr[i].setMeshNode(null);
                    }
                    this.m_bulletArr[i].setState(1001);
                }
            }
            
        }
    }
    update(_dt:number)
    {
        this.updateBullet(_dt);   
    }
}