// LoadingFish.ts
import { _decorator, Component, Node, v2, v3, UITransform, tween, Vec3, EventTouch, director } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('LoadingFish')
export class LoadingFish extends Component {
    @property
    reward: number = 1;

    @property
    minJumpHeight: number = 200;

    @property
    maxJumpHeight: number = 800;

    onLoad () {
        this.node.on(Node.EventType.TOUCH_START, this.onTouch, this);
    }

    onTouch (event: EventTouch) {
        console.log('Fish clicked! Reward: ' + this.reward);
        director.emit('loading-fish-caught', { reward: this.reward });
        this.scheduleOnce(() => this.node.destroy(), 0.1);
    }

    startJump () {
        const jumpHeight = Math.random() * (this.maxJumpHeight - this.minJumpHeight) + this.minJumpHeight;
        const jumpDuration = 1;

        const startPosition = this.node.position.clone();
        const peakPosition = v3(startPosition.x, startPosition.y + jumpHeight, startPosition.z);
        const endPosition = v3(startPosition.x, startPosition.y, startPosition.z);

        tween(this.node)
            .to(jumpDuration, { position: peakPosition }, { easing: 'cubicOut' })
            .to(jumpDuration, { position: endPosition }, { easing: 'cubicIn' })
            .call(() => this.node.destroy())
            .start();
    }
}
