/*
 * @Author: Hex
 * @Date: 2024-06-04 14:03:37
 * @LastEditors: Hex
 * @LastEditTime: 2024-06-04 16:10:55
 * @Description: file content
 */
import { _decorator, Component, Node, v3, tween, Vec3, EventTouch, director, Vec2 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('LoadingFishRotate')
export class LoadingFishRotate extends Component {
    @property
    reward: number = 1;

    @property
    minJumpHeight: number = 200;

    @property
    maxJumpHeight: number = 800;

    @property
    minHorizontalDistance: number = 100;

    @property
    maxHorizontalDistance: number = 300;

    onLoad() {
        this.node.on(Node.EventType.TOUCH_START, this.onTouch, this);
        console.log('LoadingFishRotate onLoad');
        
    }

    onTouch(event: EventTouch) {
        console.log('Fish clicked! Reward: ' + this.reward);
        director.emit('loading-fish-caught', { reward: this.reward });
        this.scheduleOnce(() => this.node.destroy(), 0.1);
    }

    startJump() {
        const jumpHeight = Math.random() * (this.maxJumpHeight - this.minJumpHeight) + this.minJumpHeight;
        const jumpDuration = 1;

        const startPosition = this.node.position.clone();
        const peakPosition = v3(startPosition.x, startPosition.y + jumpHeight, startPosition.z);

        const horizontalDistance = Math.random() * (this.maxHorizontalDistance - this.minHorizontalDistance) + this.minHorizontalDistance;
        const endPosition = v3(startPosition.x + horizontalDistance, startPosition.y, startPosition.z);

        const jumpRight = horizontalDistance > 0;
        this.node.scale = new Vec3(jumpRight ? 1 : -1, 1);
        // const rotateRight = jumpRight ? 1 : -1;

        // // 确定鱼的水平速度
        // const horizontalSpeed = horizontalDistance / (2 * jumpDuration);

        // const upTween = tween(this.node)
        //     .to(jumpDuration, { position: peakPosition }, {
        //         easing: 'cubicOut',
        //         onUpdate: (target?: object | undefined, ratio?: number | undefined) => {
        //             if (target) {
        //                 (target as Node).position = v3(
        //                     startPosition.x + horizontalSpeed * jumpDuration * ratio!,
        //                     (target as Node).position.y,
        //                     (target as Node).position.z
        //                 );
        //                 (target as Node).angle = 90 * rotateRight - 90 * ratio! * rotateRight;  // 旋转角度：从 0 到 -45 度
        //             }
        //         }
        //     });

        // const downTween = tween(this.node)
        //     .to(jumpDuration, { position: endPosition }, {
        //         easing: 'cubicIn',
        //         onUpdate: (target?: object | undefined, ratio?: number | undefined) => {
        //             if (target) {
        //                 (target as Node).position = v3(
        //                     peakPosition.x + horizontalSpeed * jumpDuration * (ratio! +1),
        //                     (target as Node).position.y,
        //                     (target as Node).position.z
        //                 );
        //                 (target as Node).angle = 0 - 90 * ratio! * rotateRight;  // 旋转角度：从 -45 度到 45 度
        //             }
        //         }
        //     });

        // tween(this.node)
        //     .sequence(upTween, downTween)
        //     .call(() => this.node.destroy())
        //     .start();
    }
}
