/*
 * @Author: Hex
 * @Date: 2024-06-04 12:22:43
 * @LastEditors: Hex
 * @LastEditTime: 2024-06-04 16:05:16
 * @Description: file content
 */
// LoadingGameController.ts
import { _decorator, Component, Prefab, instantiate, Vec3, Node, Label, director, v3 } from 'cc';
import { LoadingFish } from './LoadingFish';
import { LoadingFishRotate } from './LoadingFishRotate';
const { ccclass, property } = _decorator;

@ccclass('LoadingGameController')
export class LoadingGameController extends Component {
    @property(Prefab)
    loadingFishPrefab: Prefab = null!;


    @property
    spawnInterval: number = 3;

    @property
    maxReward: number = 3;

    @property(Label)
    coinLabel: Label = null!;

    private currentReward: number = 1;
    private totalCoins: number = 0;
    private maxSpawnTime : number = 2;
    private minSpawnTime: number = 0.5;

    private rewardTimer: number = 0;
    private spawnTimer: number = 0;
    private fishReward = 1;

    onLoad () {
        this.schedule(this.spawnFish, this.spawnInterval);
        director.on('loading-fish-caught', this.onFishCaught, this);
    }

    spawnFish () {
        const fish = instantiate(this.loadingFishPrefab);
        fish.setPosition(this.getRandomPosition());
        this.node.addChild(fish);

        const fishScript = fish.getComponent(LoadingFish) as LoadingFish;
        if(fishScript) {
            fishScript.reward = this.currentReward;
            fishScript.startJump();
        }
        else {
            const fishRotateScript = fish.getComponent(LoadingFishRotate) as LoadingFishRotate;
            fishRotateScript.reward = this.currentReward;
            fishRotateScript.startJump();
        }

        // 生成随机spawn时间
        const randomSpawnTime = Math.random() * (this.maxSpawnTime - this.minSpawnTime) + this.minSpawnTime;
        this.spawnTimer = randomSpawnTime
    }

    getRandomPosition (): Vec3 {
        const x = Math.random() * 600 - 300;
        const y = -400;
        return v3(x, y, 0);
    }

    onFishCaught (event: { reward: any; }) {
        const reward = event.reward;
        this.totalCoins += reward;
        this.coinLabel.string = 'Coins: ' + this.totalCoins;
    }

    protected update(dt: number): void {
        this.rewardTimer += dt;

        if(this.rewardTimer >= 2) {
            this.currentReward = 2;
        }
        else if(this.rewardTimer >= 4) {
            this.currentReward = 3;

        }

        this.spawnTimer -= dt;
        if(this.spawnTimer <= 0) {
            this.spawnFish();
        }
    }
}
