import { _decorator, Component, EventTouch, Input, Node, Sprite, Vec2, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('SteeringWheel')
export class SteeringWheel extends Component {

    steeringWheelPressed : boolean = false;

    steeringWheelTouchPos : Vec2;
    steeringWheelCenter : Vec2;

    steeringWheelRect : Sprite;

    steeringWheelTempAngle : number;
    steeringWheelNewAngle : number;
    steeringWheelAngle : number = 0;
    steeringWheelCenterDeadZoneRadius : number = 5;
    steeringWheelMaximumsteerAngle : number = 150;
    steeringWheelResetPosSpeed:number = 20;
    start() {
        this.node.on(Input.EventType.TOUCH_START,this.TouchStart,this);
        this.node.on(Input.EventType.TOUCH_MOVE,this.TouchMove,this);
        this.node.on(Input.EventType.TOUCH_END,this.TouchEnd,this);
        this.node.on(Input.EventType.TOUCH_CANCEL,this.TouchCancel,this);

        this.steeringWheelRect = this.node.getComponent(Sprite);

        this.steeringWheelCenter = new Vec2(this.steeringWheelRect.node.getWorldPosition().x,this.steeringWheelRect.node.getWorldPosition().y);
    }

    update(deltaTime: number) {
        this.SteeringWheelControlling();
    }

    TouchStart(event:EventTouch)
    {
        console.log("Touch_Start");
        this.steeringWheelPressed = true;
        this.steeringWheelTouchPos = event.getUILocation();

        var vec2Dis = new Vec2(event.getUILocation().x - this.steeringWheelCenter.x,event.getUILocation().y - this.steeringWheelCenter.y);
        this.steeringWheelTempAngle = Vec2.angle(new Vec2(0,1), vec2Dis) / Math.PI * 180;

        console.log(new Vec3 (0, 0, -this.steeringWheelTempAngle));

    }
    TouchMove(event:EventTouch)
    {
        console.log("Touch_Move");
        this.steeringWheelTouchPos = event.getUILocation();
    }
    TouchEnd(event:EventTouch)
    {
        console.log("Touch_End");
        this.steeringWheelPressed = false;
    }
    TouchCancel(event:EventTouch)
    {
        console.log("Touch_Cancel");
        this.steeringWheelPressed = false;
    }

    SteeringWheelControlling()
    {
        if(this.steeringWheelPressed)
        {
            var vec2Dis = new Vec2(this.steeringWheelTouchPos.x - this.steeringWheelCenter.x,this.steeringWheelTouchPos.y - this.steeringWheelCenter.y);

            this.steeringWheelNewAngle =  Vec2.angle(new Vec2(0,1), vec2Dis) / Math.PI * 180;

            console.log(new Vec3 (0, 0, this.steeringWheelNewAngle));

            if(Vec2.distance( this.steeringWheelTouchPos, this.steeringWheelCenter ) > this.steeringWheelCenterDeadZoneRadius){

				if(this.steeringWheelTouchPos.x > this.steeringWheelCenter.x)
					this.steeringWheelAngle += this.steeringWheelNewAngle - this.steeringWheelTempAngle;
				else
                    this.steeringWheelAngle -= this.steeringWheelNewAngle - this.steeringWheelTempAngle;
			}

            if(this.steeringWheelAngle > this.steeringWheelMaximumsteerAngle)
				this.steeringWheelAngle = this.steeringWheelMaximumsteerAngle;
			else if(this.steeringWheelAngle < - this.steeringWheelMaximumsteerAngle)
				this.steeringWheelAngle = -this.steeringWheelMaximumsteerAngle;
			
			this.steeringWheelTempAngle = this.steeringWheelNewAngle;

            console.log(new Vec3 (0, 0, -this.steeringWheelAngle));
        }
        else
        {
            if(Math.abs(this.steeringWheelAngle) > 0.01){

				var deltaAngle = this.steeringWheelResetPosSpeed;
				
				if(Math.abs(deltaAngle) > Math.abs(this.steeringWheelAngle)){
					this.steeringWheelAngle = 0;
					return;
				}
				
				if(this.steeringWheelAngle > 0)
					this.steeringWheelAngle -= deltaAngle;
				else
					this.steeringWheelAngle += deltaAngle;

			}
        }

        this.steeringWheelRect.node.eulerAngles = new Vec3 (0, 0, -this.steeringWheelAngle);
    }
}


