import { _decorator, Component, EventKeyboard, EventTarget, find, input, Input, instantiate, KeyCode, Node, PhysicsSystem, RigidBody, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('CarController')
export class CarController extends Component {

    @property(Node)
    rigidBody!: Node

    @property([Node])
    wheels: Node[]=[]

    vehicle:CANNON.RaycastVehicle;

    canMove = false;
    start() {
        //input.on(Input.EventType.KEY_DOWN,this.onKeyDown,this);
        //input.on(Input.EventType.KEY_UP, this.onKeyUp, this);

        PhysicsSystem.instance.enable = true;

        this.rigidBody.active =true;
        //初始化车辆引擎
        this.vehicle = new CANNON.RaycastVehicle({
            chassisBody: this.rigidBody.getComponent(RigidBody)!.body?.impl
        });

        var options:CANNON.IWheelInfoOptions = {
            radius: 0.5,
            directionLocal: new CANNON.Vec3(0, -1, 0),
            suspensionStiffness: 30,
            suspensionRestLength: 0.3,
            frictionSlip: 1,
            dampingRelaxation: 2.3,
            dampingCompression: 4.4,
            maxSuspensionForce: 100000,
            rollInfluence:  0.01,
            axleLocal: new CANNON.Vec3(1, 0, 0),
            chassisConnectionPointLocal: new CANNON.Vec3(1, 0, 1),
            maxSuspensionTravel: 0.3,
            customSlidingRotationalSpeed: -30,
            useCustomSlidingRotationalSpeed: true
        };
        options.chassisConnectionPointLocal.set(1, 0, 1);
        this.vehicle.addWheel(options);

        options.chassisConnectionPointLocal.set(1, 0, -1);
        this.vehicle.addWheel(options);

        options.chassisConnectionPointLocal.set(-1, 0, 1);
        this.vehicle.addWheel(options);

        options.chassisConnectionPointLocal.set(-1, 0, -1);
        this.vehicle.addWheel(options);

        //通过addToWorld方法将将车辆及其约束添加到世界上。
        this.vehicle.addToWorld(PhysicsSystem.instance.physicsWorld._world);

        console.log(this.vehicle);

        this.rigidBody.getComponent(RigidBody).useGravity = true;
        this.scheduleOnce(()=>{
            console.log(this.vehicle);
            this.canMove = true;
        },1);
    }

    update(deltaTime: number) {

        if(this.canMove)
        {
            console.log(this.vehicle);

            console.log(this.rigidBody.position);
            console.log(this.rigidBody.eulerAngles);
        }
        

        // this.vehicle.applyEngineForce(50,2);
        // this.vehicle.applyEngineForce(50,3);
        // this.vehicle.applyEngineForce(10,3);

        
        //this.vehicle.setSteeringValue(0.5,0);
        //this.vehicle.setSteeringValue(0.5,1);
        // console.log(this.vehicle.chassisBody.position);
    }

    protected lateUpdate(dt: number): void {
        this.vehicle.applyEngineForce(-1000,2);
        this.vehicle.applyEngineForce(-1000,3);
    }

    onKeyDown(event: EventKeyboard)
    {
        console.log(event.keyCode);
        
        this.vehicle.setBrake(0, 0);
        this.vehicle.setBrake(0, 1);
        this.vehicle.setBrake(0, 2);
        this.vehicle.setBrake(0, 3);

        switch(event.keyCode) {
            case KeyCode.KEY_W:
                this.vehicle.applyEngineForce(-1000,2);
                this.vehicle.applyEngineForce(-1000,3);

                console.log(this.vehicle);

                break;
            case KeyCode.KEY_S:

                this.vehicle.applyEngineForce(-1000,2);
                this.vehicle.applyEngineForce(-1000,3);

                console.log(this.vehicle);

                break;
            case KeyCode.KEY_D:
                this.vehicle.setSteeringValue(-0.5,0);
                this.vehicle.setSteeringValue(-0.5,1);

                console.log(this.vehicle);

                break;
            case KeyCode.KEY_A:
                this.vehicle.setSteeringValue(0.5,0);
                this.vehicle.setSteeringValue(0.5,1);

                console.log(this.vehicle);

                break;
            case KeyCode.KEY_B:
                this.vehicle.setSteeringValue(0,0);
                this.vehicle.setSteeringValue(0,1);
                this.vehicle.setSteeringValue(0,2);
                this.vehicle.setSteeringValue(0,3);

                this.vehicle.setBrake(1000000, 0);
                this.vehicle.setBrake(1000000, 1);
                this.vehicle.setBrake(1000000, 2);
                this.vehicle.setBrake(1000000, 3);

                this.scheduleOnce(()=>{
                    this.rigidBody.getComponent(RigidBody).setAngularVelocity(new Vec3(0,0,0));
                    this.rigidBody.getComponent(RigidBody).setLinearVelocity(new Vec3(0,0,0));
                },0.5);

                console.log(this.vehicle);
                break;
        }
    }

    onKeyUp(event: EventKeyboard)
    {
        /*this.vehicle.setBrake(0, 0);
        this.vehicle.setBrake(0, 1);
        this.vehicle.setBrake(0, 2);
        this.vehicle.setBrake(0, 3);

        switch(event.keyCode) {
            case KeyCode.KEY_W:
                this.vehicle.applyEngineForce(0,2);
                this.vehicle.applyEngineForce(0,3);

                console.log(this.vehicle);

                break;
            case KeyCode.KEY_S:

                this.vehicle.applyEngineForce(0,2);
                this.vehicle.applyEngineForce(0,3);

                console.log(this.vehicle);

                break;
            case KeyCode.KEY_D:
                this.vehicle.setSteeringValue(0,0);
                this.vehicle.setSteeringValue(0,1);

                console.log(this.vehicle);

                break;
            case KeyCode.KEY_A:
                this.vehicle.setSteeringValue(0,0);
                this.vehicle.setSteeringValue(0,1);

                console.log(this.vehicle);

                break;
            case KeyCode.KEY_B:
                this.vehicle.setSteeringValue(0,0);
                this.vehicle.setSteeringValue(0,1);
                this.vehicle.setSteeringValue(0,2);
                this.vehicle.setSteeringValue(0,3);

                this.vehicle.setBrake(1000000, 0);
                this.vehicle.setBrake(1000000, 1);
                this.vehicle.setBrake(1000000, 2);
                this.vehicle.setBrake(1000000, 3);

                this.scheduleOnce(()=>{
                    this.rigidBody.getComponent(RigidBody).setAngularVelocity(new Vec3(0,0,0));
                    this.rigidBody.getComponent(RigidBody).setLinearVelocity(new Vec3(0,0,0));
                },0.5);

                console.log(this.vehicle);
                break;
        }*/
    }
}


