const { ccclass, property, executeInEditMode } = cc._decorator;

@ccclass
@executeInEditMode()
export default class FlowLight extends cc.Component {
    @property(cc.Sprite)
    target: cc.Sprite = null;
    @property({ type: cc.Float, tooltip: '宽度[0-1]' })
    width: number = 0.1;
    @property({ type: cc.Float, tooltip: "倾斜角度" })
    angle: number = 10;
    @property({ type: cc.Float, tooltip: '刷新一次时长(秒)' })
    totalTime: number = 2;
    @property({ type: cc.Float, tooltip: '反射强化值(应大于1)' })
    strengthen: number = 1.2;

    private _mat: cc.Material = null;
    private _time: number = 0;
    private _tiemSpace: number = 0;

    onLoad() {
        this._mat = this.target.getMaterial(0);
        this._mat.setProperty('width', this.width);
        this._mat.setProperty('angle', this.angle);
        this._mat.setProperty('strengthen', this.strengthen);
        this._tiemSpace = this.getMaxPx() - this.getMinPx();
        this._time = this.getMinPx();
    }

    start() {

    }

    update(dt: number) {
        this._time += dt * this._tiemSpace / this.totalTime;
        /**
         * @px是时间轴线 同时也是扫光矩形的x方向的中心点，相当于锚点(0.5,0)的位置
         * @因为扫光的宽度和倾斜问题所以这个取值范围不是 [0,1]
         */
        this._mat && this._mat.setProperty('px', this._time);
        if (this._time > this.getMaxPx()) {
            this._time = this.getMinPx();
        }
    }

    /**
     * @获取左边界
     * @保证倾斜后的扫光部分的X小于零
     * @returns 
     */
    getMinPx() {
        /**@角度转弧度 */
        let rad = Math.PI * this.angle / 180.0;
        /**
         * @width/2是扫光宽度的一半
         * @假设倾斜后投影到X轴上的部分为x
         * @tan(rad)=x/1 @注 @因为opengl坐标的y取值是0到1 此处取1
         * @所以x等于 tan(rad)
         */
        return -this.width / 2 - Math.tan(rad);
    }
    /**
     * @x方向右边界
     * @returns 
     */
    getMaxPx() {
        return 1 + this.width / 2;
    }

    btnClose(event) {
        this.node.destroy();
    }
}
