"use strict";
cc._RF.push(module, 'efc1fc7srhLGqxg+scejWT2', 'FlowLight');
// resources/flowLight/FlowLight.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, executeInEditMode = _a.executeInEditMode;
var FlowLight = /** @class */ (function (_super) {
    __extends(FlowLight, _super);
    function FlowLight() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.target = null;
        _this.width = 0.1;
        _this.angle = 10;
        _this.totalTime = 2;
        _this.strengthen = 1.2;
        _this._mat = null;
        _this._time = 0;
        _this._tiemSpace = 0;
        return _this;
    }
    FlowLight.prototype.onLoad = function () {
        this._mat = this.target.getMaterial(0);
        this._mat.setProperty('width', this.width);
        this._mat.setProperty('angle', this.angle);
        this._mat.setProperty('strengthen', this.strengthen);
        this._tiemSpace = this.getMaxPx() - this.getMinPx();
        this._time = this.getMinPx();
    };
    FlowLight.prototype.start = function () {
    };
    FlowLight.prototype.update = function (dt) {
        this._time += dt * this._tiemSpace / this.totalTime;
        /**
         * @px是时间轴线 同时也是扫光矩形的x方向的中心点，相当于锚点(0.5,0)的位置
         * @因为扫光的宽度和倾斜问题所以这个取值范围不是 [0,1]
         */
        this._mat && this._mat.setProperty('px', this._time);
        if (this._time > this.getMaxPx()) {
            this._time = this.getMinPx();
        }
    };
    /**
     * @获取左边界
     * @保证倾斜后的扫光部分的X小于零
     * @returns
     */
    FlowLight.prototype.getMinPx = function () {
        /**@角度转弧度 */
        var rad = Math.PI * this.angle / 180.0;
        /**
         * @width/2是扫光宽度的一半
         * @假设倾斜后投影到X轴上的部分为x
         * @tan(rad)=x/1 @注 @因为opengl坐标的y取值是0到1 此处取1
         * @所以x等于 tan(rad)
         */
        return -this.width / 2 - Math.tan(rad);
    };
    /**
     * @x方向右边界
     * @returns
     */
    FlowLight.prototype.getMaxPx = function () {
        return 1 + this.width / 2;
    };
    FlowLight.prototype.btnClose = function (event) {
        this.node.destroy();
    };
    __decorate([
        property(cc.Sprite)
    ], FlowLight.prototype, "target", void 0);
    __decorate([
        property({ type: cc.Float, tooltip: '宽度[0-1]' })
    ], FlowLight.prototype, "width", void 0);
    __decorate([
        property({ type: cc.Float, tooltip: "倾斜角度" })
    ], FlowLight.prototype, "angle", void 0);
    __decorate([
        property({ type: cc.Float, tooltip: '刷新一次时长(秒)' })
    ], FlowLight.prototype, "totalTime", void 0);
    __decorate([
        property({ type: cc.Float, tooltip: '反射强化值(应大于1)' })
    ], FlowLight.prototype, "strengthen", void 0);
    FlowLight = __decorate([
        ccclass,
        executeInEditMode()
    ], FlowLight);
    return FlowLight;
}(cc.Component));
exports.default = FlowLight;

cc._RF.pop();