/*
 * @Author: yansixing
 * @Date: 2021-03-01 10:15:07
 * @Github: https://github.com/yansixing
 * @LastEditTime: 2021-04-19 11:20:46
 */

import { Camera, geometry, Node, Vec3, view } from "cc";


declare module "cc" {
    interface Camera {
        convertToUINodeWithTexture(worldPos: Vec3, uiNode: Node, out?: Vec3): Vec3;
        screenPointToRayWithTexture(x: number, y: number, out?: geometry.Ray): geometry.Ray;
    }
}
Camera.prototype.convertToUINodeWithTexture = function (worldPos: Vec3, uiNode: Node, out?: Vec3) {
    !out && (out = new Vec3());
    const self = this as Camera;
    self.convertToUINode(worldPos, uiNode, out);
    out.y = -out.y;
    out.x *= view.getScaleX();
    out.y *= view.getScaleY();
    return out;
}

Camera.prototype.screenPointToRayWithTexture = function (x: number, y: number, out?: geometry.Ray) {
    !out && (out = new geometry.Ray());
    const viewPortHeight = view.getViewportRect().height;
    const self = this as Camera;

    self.screenPointToRay(x / view.getScaleX(), (viewPortHeight - y) / view.getScaleY(), out);
    return out;
}

export default {};