declare module "cc" {
    /**
     * @en
     * Predefined constants, see [[Macro]] for detailed contents.
     * @zh
     * 预定义常量，具体内容参考 [[Macro]] 文档。
     */
    export const macro: Macro;
    /**
     * @en
     * Predefined constants, see [[Macro]] for detailed contents.
     * @zh
     * 预定义常量，具体内容参考 [[Macro]] 文档。
     */
    /**
     * @en Interface declaration for predefined constants, for usage you should be importing [[macro]] directly.
     * @zh 预定义常量的接口声明，实际使用应该直接导入 [[macro]]。
     */
    export interface Macro {
        /**
         * @en
         * The image format supported by the engine, the actual supported formats may differ in different build platforms and device types.
         * Currently contains ['.astc', '.pkm', '.pvr', '.webp', '.jpg', '.jpeg', '.bmp', '.png'].
         * @zh
         * 引擎默认支持的图片格式，实际运行时支持的格式可能在不同的构建平台和设备类型上有所差别。
         * 目前包含的格式有 ['.astc', '.pkm', '.pvr', '.webp', '.jpg', '.jpeg', '.bmp', '.png']。
         */
        SUPPORT_TEXTURE_FORMATS: string[];
        /**
         * @en Key map for keyboard event
         * @zh 键盘事件的按键值。
         * @example {@link cocos/core/platform/CCCommon/KEY.js}
         * @deprecated since v3.3 please use [[KeyCode]] instead
         */
        KEY: typeof __private._cocos_core_platform_macro__KEY;
        /**
         * @en One angle in radian, equals to PI / 180
         * @zh 弧度制中的单位角度，等同于 PI / 180
         */
        RAD: number;
        /**
         * @en One radian in angle, equals to 180 / PI
         * @zh 角度制中的单位弧度，等同于 180 / PI
         */
        DEG: number;
        /**
         * @en A maximum value of number representing infinity repeat times
         * @zh 重复执行的最大值，实际取值为数字的最大值
         */
        REPEAT_FOREVER: number;
        /**
         * @en A float value for representing a minimum error in comparison
         * @zh 用于比较时可忽略的浮点误差值
         */
        FLT_EPSILON: number;
        /**
         * @en Oriented vertically
         * @zh 竖屏朝向
         */
        ORIENTATION_PORTRAIT: number;
        /**
         * @en Inverted portrait orientation, with the device bottom facing upward.
         * @zh 倒置竖屏，设备底部朝上
         */
        ORIENTATION_PORTRAIT_UPSIDE_DOWN: number;
        /**
         * @en Oriented horizontally. Users cannot directly listen to this value; they need to listen for ORIENTATION_LANDSCAPE_LEFT or ORIENTATION_LANDSCAPE_RIGHT.
         * @zh 横屏朝向, 外部不能直接监听该值，需要监听 ORIENTATION_LANDSCAPE_LEFT 或 ORIENTATION_LANDSCAPE_RIGHT
         */
        ORIENTATION_LANDSCAPE: number;
        /**
         * @en Oriented horizontally, top side facing to the left. Supported only on mobile devices.
         * @zh 水平方向，顶部朝向左侧;仅移动端支持
         */
        ORIENTATION_LANDSCAPE_LEFT: number;
        /**
         * @en Oriented horizontally, top side facing to the right. Supported only on mobile devices.
         * @zh 水平方向，顶部朝向右侧;仅移动端支持
         */
        ORIENTATION_LANDSCAPE_RIGHT: number;
        /**
         * @en Oriented automatically
         * @zh 自动适配朝向
         */
        ORIENTATION_AUTO: number;
        /**
         * @en
         * Whether or not enabled tiled map auto culling. If you set the TiledMap skew or rotation,
         * then need to manually disable this, otherwise, the rendering will be wrong.
         * Currently not used in 3D engine
         * @zh
         * 是否开启瓦片地图的自动裁减功能。瓦片地图如果设置了 skew, rotation 的话，需要手动关闭，否则渲染会出错。
         * 在 3D 引擎中暂时无效。
         * @default true
         * @deprecated since v3.0
         */
        ENABLE_TILEDMAP_CULLING: boolean;
        /**
         * @en
         * The timeout to determine whether a touch is no longer active and should be removed.
         * The reason to add this timeout is due to an issue in X5 browser core,
         * when X5 is presented in wechat on Android, if a touch is glissed from the bottom up, and leave the page area,
         * no touch cancel event is triggered, and the touch will be considered active forever.
         * After multiple times of this action, our maximum touches number will be reached and all new touches will be ignored.
         * So this new mechanism can remove the touch that should be inactive if it's not updated during the last 5000 milliseconds.
         * Though it might remove a real touch if it's just not moving for the last 5 seconds,
         * which is not easy with the sensibility of mobile touch screen.
         * You can modify this value to have a better behavior if you find it's not enough.
         * @zh
         * 用于甄别一个触点对象是否已经失效并且可以被移除的延时时长
         * 添加这个时长的原因是 X5 内核在微信浏览器中出现的一个 bug。
         * 在这个环境下，如果用户将一个触点从底向上移出页面区域，将不会触发任何 touch cancel 或 touch end 事件，而这个触点会被永远当作停留在页面上的有效触点。
         * 重复这样操作几次之后，屏幕上的触点数量将达到我们的事件系统所支持的最高触点数量，之后所有的触摸事件都将被忽略。
         * 所以这个新的机制可以在触点在一定时间内没有任何更新的情况下视为失效触点并从事件系统中移除。
         * 当然，这也可能移除一个真实的触点，如果用户的触点真的在一定时间段内完全没有移动（这在当前手机屏幕的灵敏度下会很难）。
         * 你可以修改这个值来获得你需要的效果，默认值是 5000 毫秒。
         * @default 5000
         */
        TOUCH_TIMEOUT: number;
        /**
         * @en
         * Boolean that indicates if the canvas contains an alpha channel, default sets to false for better performance.
         * Though if you want to make your canvas background transparent and show other dom elements at the background,
         * you can set it to true before [[game.init]].
         * Web only.
         * @zh
         * 用于设置 Canvas 背景是否支持 alpha 通道，默认为 false，这样可以有更高的性能表现。
         * 如果你希望 Canvas 背景是透明的，并显示背后的其他 DOM 元素，你可以在 [[game.init]] 之前将这个值设为 true。
         * 仅支持 Web
         * @default false
         */
        ENABLE_TRANSPARENT_CANVAS: boolean;
        /**
         * @en
         * Boolean that indicates if the GL context is created with `antialias` option turned on, default value is false.
         * Set it to true could make your game graphics slightly smoother, like texture hard edges when rotated.
         * Whether to use this really depend on your game design and targeted platform,
         * device with retina display usually have good detail on graphics with or without this option,
         * you probably don't want antialias if your game style is pixel art based.
         * Also, it could have great performance impact with some browser / device using software MSAA.
         * You can set it to true before [[game.init]].
         * Only affect OpenGL ES and WebGL backend
         * @zh
         * 用于设置在创建 GL Context 时是否开启抗锯齿选项，默认值是 false。
         * 将这个选项设置为 true 会让你的游戏画面稍稍平滑一些，比如旋转硬边贴图时的锯齿。是否开启这个选项很大程度上取决于你的游戏和面向的平台。
         * 在大多数拥有 retina 级别屏幕的设备上用户往往无法区分这个选项带来的变化；如果你的游戏选择像素艺术风格，你也多半不会想开启这个选项。
         * 同时，在少部分使用软件级别抗锯齿算法的设备或浏览器上，这个选项会对性能产生比较大的影响。
         * 你可以在 [[game.init]] 之前设置这个值，否则它不会生效。
         * 仅影响 WebGL 后端
         * @default true
         */
        ENABLE_WEBGL_ANTIALIAS: boolean;
        /**
         * @en
         * Used to set float output render target, more accurate multiple light sources, fog, and translucent effects, custom pipeline only, the default value is false.
         * @zh
         * 用于开启浮点格式的RT输出, 更精确的多光源、雾化和半透明效果, 仅用于自定义管线, 默认值为 false。
         * @default false
         */
        ENABLE_FLOAT_OUTPUT: boolean;
        /**
         * @en
         * Whether to clear the original image cache after uploaded a texture to GPU.
         * If cleared, [Dynamic Atlas](https://docs.cocos.com/creator/manual/en/advanced-topics/dynamic-atlas.html) will not be supported.
         * Normally you don't need to enable this option on the web platform, because Image object doesn't consume too much memory.
         * But on Wechat Game platform, the current version cache decoded data in Image object, which has high memory usage.
         * So we enabled this option by default on Wechat, so that we can release Image cache immediately after uploaded to GPU.
         * Currently not useful in 3D engine
         * @zh
         * 是否在将贴图上传至 GPU 之后删除原始图片缓存，删除之后图片将无法进行 [动态合图](https://docs.cocos.com/creator/manual/zh/advanced-topics/dynamic-atlas.html)。
         * 在 Web 平台，你通常不需要开启这个选项，因为在 Web 平台 Image 对象所占用的内存很小。
         * 但是在微信小游戏平台的当前版本，Image 对象会缓存解码后的图片数据，它所占用的内存空间很大。
         * 所以我们在微信平台默认开启了这个选项，这样我们就可以在上传 GL 贴图之后立即释放 Image 对象的内存，避免过高的内存占用。
         * 在 3D 引擎中暂时无效。
         * @default false
         */
        CLEANUP_IMAGE_CACHE: boolean;
        /**
         * @en
         * Whether to enable multi-touch.
         * @zh
         * 是否开启多点触摸
         * @default true
         */
        ENABLE_MULTI_TOUCH: boolean;
        /**
         * @en
         * The maximum size of the canvas pool used by Label, please adjust according to the number of label component in the same scene of the project
         * @zh
         * Label 使用的 canvas pool 的最大大小，请根据项目同场景的 label 数量进行调整
         * @default 20
         */
        MAX_LABEL_CANVAS_POOL_SIZE: number;
        /**
         * @en
         * Boolean that indicates if enable highp precision data in structure with fragment shader.
         * Enable this option will make the variables defined by the HIGHP_VALUE_STRUCT_DEFINE macro in the shader more accurate, such as position.
         * Enable this option can avoid some distorted lighting effects. That depends on whether your game has abnormal lighting effects on this platform.
         * There will be a slight performance loss if enable this option, but the impact is not significant.
         * Only affect WebGL backend
         * @zh
         * 用于设置是否在片元着色器中使用结构体的时候，允许其中的数据使用highp精度
         * 将这个选项设置为 true 会让shader中使用HIGHP_VALUE_STRUCT_DEFINE宏定义的变量精度更高，比如位置信息等，避免出现一些失真的光照效果。是否开启这个选项很大程度上取决于你的游戏在此平台上是否出现了异常的表现。
         * 开启后会有轻微的性能损失，但影响不大。
         * 仅影响 WebGL 后端
         * @default false
         */
        ENABLE_WEBGL_HIGHP_STRUCT_VALUES: boolean;
        /**
         * @zh Batcher2D 中内存增量的大小（KB）
         * 这个值决定了当场景中存在的 2d 渲染组件的顶点数量超过当前 batcher2D 中可容纳的顶点数量时，内存扩充的增加量
         * 这个值越大，共用同一个 meshBuffer 的 2d 渲染组件数量会更多，但每次扩充所占用的内存也会更大
         * 默认值在标准格式（[[VertexFormat.vfmtPosUvColor]]）下可容纳 4096 个顶点（4096*9*4/1024），你可以增加容量来提升每个批次可容纳的元素数量
         * @en The MeshBuffer chunk size in Batcher2D (KB)
         * This value determines the increase in memory expansion,
         * when the number of vertices of 2d rendering components present in the scene exceeds the number of vertices,
         * that can be accommodated in the current batcher2D.
         * The larger this value is, the more 2d rendering components will share the same meshBuffer, but the more memory will be used for each expansion
         * The default size can contain 4096 standard vertex ([[VertexFormat.vfmtPosUvColor]]) in one buffer,
         * you can user larger buffer size to increase the elements count per 2d draw batch.
         * @default 144 KB
         */
        BATCHER2D_MEM_INCREMENT: number;
        /**
         * @zh 自定义渲染管线的名字（实验性）
         * 引擎会根据名字创建对应的渲染管线（仅限Web平台）。如果名字为空，则不启用自定义渲染管线。
         * 目前仅支持'Forward', 'Deferred'两种。
         * @en The name of custom rendering pipeline (experimental)
         * Engine will use the name to create the custom pipeline (Web only). If the name is empty, custom pipeline will be disabled.
         * Currently only 'Forward' and 'Deferred' are supported.
         */
        CUSTOM_PIPELINE_NAME: string;
        /**
         * @internal
         */
        init(): void;
    }
    /**
     * @en JS Implementation of MurmurHash2. Original implementation is http://github.com/garycourt/murmurhash-js.
     * @zh MurmurHash2 的 JS 实现。原始实现是 http://github.com/garycourt/murmurhash-js 。
     * @param input @en ASCII string or a Uint8Array to be hashed. @zh 希望被哈希的 ASCII 字符串或者 Uint8Array.
     * @param seed @en Hash seed. Should be a positive integer. @zh 哈希种子。必须是个正整数。
     * @returns @en 32-bit positive integer hash. @zh 32位正整数哈希值。
     */
    export function murmurhash2_32_gc(input: string | Uint8Array, seed: number): number;
    export class ReflectionProbeManager {
        static probeManager: ReflectionProbeManager;
        /**
         * @en Set and get whether to detect objects leaving or entering the reflection probe's bounding box at runtime.
         * @zh 设置和获取是否在运行时检测物体离开或者进入反射探针的包围盒。
         */
        set updateForRuntime(val: boolean);
        get updateForRuntime(): boolean;
        /**
         * @en Refresh all reflection probe.
         * @zh 刷新所有反射探针。
         */
        onUpdateProbes(): void;
        /**
         * @en filter models that use planar reflection.
         * @zh 筛选使用平面反射的模型
         */
        filterModelsForPlanarReflection(): void;
        /**
         * @en Get all reflection probes in the scene.
         * @zh 获取场景中所有的反射探针
         */
        getProbes(): renderer.scene.ReflectionProbe[];
        /**
         * @en Get reflection probe by id.
         * @zh 根据id获取反射探针
         */
        getProbeById(probeId: number): renderer.scene.ReflectionProbe | null;
        /**
         * @en Update the cubemap captured by the reflection probe.
         * @zh 更新反射探针捕获的cubemap
         * @param probe update the texture for this probe
         */
        updateBakedCubemap(probe: renderer.scene.ReflectionProbe): void;
        /**
         * @en Update the plane reflection map for reflection probe render.
         * @zh 更新反射探针渲染的平面反射贴图
         * @param probe update the texture for this probe
         */
        updatePlanarMap(probe: renderer.scene.ReflectionProbe, texture: gfx.Texture | null): void;
        /**
         * @en Selecting the appropriate reflection probe for the model, it will use the closest one based on distance.
         * @zh 为模型选择适用的反射探针，会使用距离最近的。
         * @param model select for this model
         */
        selectReflectionProbe(model: renderer.scene.Model): void;
        /**
         * @en Update the preview sphere of the Reflection Probe cube mode.
         * @zh 更新反射探针cube模式的预览球
         */
        updatePreviewSphere(probe: renderer.scene.ReflectionProbe): void;
        /**
         * @en Update the preview plane of the Reflection Probe planar mode.
         * @zh 更新反射探针预览平面
         */
        updatePreviewPlane(probe: renderer.scene.ReflectionProbe): void;
        /**
         * @en Update reflection probe data of model bind.
         * @zh 更新模型绑定的反射探针数据。
         */
        updateProbeData(): void;
        /**
         * @en get max value of probe id.
         * @zh 获取反射探针id的最大值。
         */
        getMaxProbeId(): number;
        /**
         * @en Get the reflection probe used by the model.
         * @zh 获取模型使用的反射探针。
         */
        getUsedReflectionProbe(model: renderer.scene.Model, planarReflection: boolean): renderer.scene.ReflectionProbe | null | undefined;
        /**
         * @en Set reflection probe used by the model.
         * @zh 手动设置模型使用的反射探针。
         * @param model set the probe for this model
         * @param probe reflection probe to be set
         * @param blendProbe reflection probe for blend
         */
        setReflectionProbe(model: renderer.scene.Model, probe: renderer.scene.ReflectionProbe, blendProbe?: renderer.scene.ReflectionProbe | null): void;
    }
    /**
     * @en Mesh buffer used for 2d rendering, used internally and not of concern to the user.
     * @zh 2d 渲染使用的网格缓冲数据，内部使用，用户不须关心。
     * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
     */
    export class MeshBuffer {
        /**
         * @en The vertex attributes of the buffer.
         * @zh buffer 的顶点属性。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get attributes(): gfx.Attribute[];
        /**
         * @en Number of bytes in vertex format.
         * @zh 顶点格式的字节数。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get vertexFormatBytes(): number;
        protected _byteOffset: number;
        /**
         * @en byte offset.
         * @zh 字节偏移量。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get byteOffset(): number;
        set byteOffset(val: number);
        protected _vertexOffset: number;
        /**
         * @en Vertexes offset.
         * @zh 顶点数偏移。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get vertexOffset(): number;
        set vertexOffset(val: number);
        protected _indexOffset: number;
        /**
         * @en Indices offset.
         * @zh 索引偏移。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get indexOffset(): number;
        set indexOffset(val: number);
        protected _dirty: boolean;
        /**
         * @en Dirty flag.
         * @zh 脏标记。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get dirty(): boolean;
        set dirty(val: boolean);
        protected _floatsPerVertex: number;
        /**
         * @en Float numbers per vertex.
         * @zh 每顶点的浮点数长度。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get floatsPerVertex(): number;
        set floatsPerVertex(val: number);
        protected _vData: Float32Array;
        /**
         * @en Vertexes data.
         * @zh 顶点数据。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get vData(): Float32Array;
        set vData(val: Float32Array);
        protected _iData: Uint16Array;
        /**
         * @en Indices data.
         * @zh 索引数据。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get iData(): Uint16Array;
        set iData(val: Uint16Array);
        protected _nativeObj: __private._cocos_2d_renderer_native_2d__NativeUIMeshBuffer;
        /**
         * @en Native object.
         * @zh 原生对象。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get nativeObj(): __private._cocos_2d_renderer_native_2d__NativeUIMeshBuffer;
        protected _sharedBuffer: Uint32Array;
        /**
         * @en Native shared buffer.
         * @zh 原生共享缓冲。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get sharedBuffer(): Uint32Array;
        /**
         * @en Initial native shared buffer.
         * @zh 初始化原生共享缓冲。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        initSharedBuffer(): void;
        /**
         * @en Synchronized native shared buffer.
         * @zh 同步原生共享缓冲。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        syncSharedBufferToNative(): void;
        constructor();
        /**
         * @en Initialize mesh buffer.
         * @zh 初始化对象。
         * @param device @en The GFX device. @zh GFX设备。
         * @param attrs @en The vertex attributes of the buffer. @zh 缓冲区的顶点属性。
         * @param vFloatCount @en The vertexes float count. @zh 每顶点所需的 float 数量。
         * @param iCount @en The indices count. @zh 索引数量。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        initialize(device: gfx.Device, attrs: gfx.Attribute[], vFloatCount: number, iCount: number): void;
        /**
         * @en Reset state.
         * @zh 重置状态。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        reset(): void;
        destroy(): void;
        /**
         * @en Set dirty flag.
         * @zh 设置脏标签。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setDirty(): void;
        /**
         * @deprecated since v3.4.0, please use BufferAccessor's request
         * @see [[BufferAccessor.request]]
         */
        request(vertexCount: number, indexCount: number): boolean;
        /**
         * @en require Free input assembler.
         * @zh 请求可用的输入汇集器。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        requireFreeIA(device: gfx.Device): gfx.InputAssembler;
        /**
         * @en recycle input assembler.
         * @zh 回收输入汇集器。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        recycleIA(ia: gfx.InputAssembler): void;
        /**
         * @en check capacity.
         * @zh 检查可分配余量。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        checkCapacity(vertexCount: number, indexCount: number): boolean;
        /**
         * @en Upload and update buffers data.
         * @zh 上传更新缓冲内容。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        uploadBuffers(): void;
    }
    /**
     * @en Stencil state manager.
     * @zh 模板状态管理器。
     * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
     */
    export class StencilManager {
        static sharedManager: StencilManager | null;
        /**
         * @en Stencil stage.
         * @zh 模板缓冲阶段。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get stage(): __private._cocos_2d_renderer_stencil_manager__Stage;
        set stage(val: __private._cocos_2d_renderer_stencil_manager__Stage);
        /**
         * @en Stencil pattern.
         * @zh 模板缓冲样式。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get pattern(): {
            stencilTest: boolean;
            func: gfx.ComparisonFunc;
            stencilMask: number;
            writeMask: number;
            failOp: gfx.StencilOp;
            zFailOp: gfx.StencilOp;
            passOp: gfx.StencilOp;
            ref: number;
        };
        /**
         * @en Add mask nesting.
         * @zh 添加mask嵌套。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        pushMask(mask: any): void;
        /**
         * @en clear stencil stage.
         * @zh 清空模板状态。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        clear(comp: UIRenderer | UIMeshRenderer): __private._cocos_2d_renderer_stencil_manager__Stage;
        /**
         * @en Open stencil stage to enabled.
         * @zh 开启模板状态。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        enableMask(): void;
        /**
         * @en exit stencil.
         * @zh 退出模板状态。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        exitMask(): void;
        /**
         * @en Get write mask count.
         * @zh 获取写入模板缓冲的位数。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        getWriteMask(): number;
        /**
         * @en Get write mask count when exit.
         * @zh 获取退出时模板缓冲的位数。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        getExitWriteMask(): number;
        /**
         * @en Get mask nesting count.
         * @zh 获取mask嵌套数量。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        getMaskStackSize(): number;
        /**
         * @en Reset stencil stage.
         * @zh 重置模板状态。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        reset(): void;
        destroy(): void;
        /**
         * @en Get stencil stage.
         * @zh 获取模板状态。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        getStencilStage(stage: __private._cocos_2d_renderer_stencil_manager__Stage, mat?: Material): gfx.DepthStencilState;
        /**
         * @en Get stencil hash.
         * @zh 获取模板状态的哈希值。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        getStencilHash(stage: __private._cocos_2d_renderer_stencil_manager__Stage): number;
    }
    export const spriteAssembler: IAssemblerManager;
    export const labelAssembler: IAssemblerManager;
    export const graphicsAssembler: IAssemblerManager;
    /**
     * @en
     * Class for sprite atlas handling.
     * @zh
     * 精灵图集资源类。
     */
    export class SpriteAtlas extends Asset {
        /**
         * @en All sprite frames in the sprite atlas.
         * @zh 精灵图集中的所有精灵。
         */
        spriteFrames: __private._cocos_2d_assets_sprite_atlas__ISpriteFrameList;
        constructor();
        /**
         * @en Get the [[Texture2D]] asset of the atlas.
         * @zh 获取精灵图集的贴图。
         * @returns @en The texture2d asset. @zh 二维贴图资源。
         */
        getTexture(): __private._cocos_asset_assets_texture_base__TextureBase | null;
        /**
         * @en Gets the [[SpriteFrame]] correspond to the given key in sprite atlas.
         * @zh 根据键值获取精灵。
         *
         * @param key @en The SpriteFrame name. @zh 精灵名字。
         * @returns @en The SpriteFrame asset. @zh 精灵资源。
         */
        getSpriteFrame(key: string): SpriteFrame | null;
        /**
         * @en Returns all sprite frames in the sprite atlas.
         * @zh 获取精灵图集所有精灵。
         * @returns @en All sprite frames. @zh 所有的精灵资源。
         */
        getSpriteFrames(): (SpriteFrame | null)[];
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _serialize(ctxForExporting: any): any;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _deserialize(serializeData: any, handle: any): void;
    }
    /**
     * @en Class for TTFFont asset.
     * @zh TTF 字体资源类。
     */
    export class TTFFont extends Font {
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _fontFamily: string | null;
        constructor();
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _nativeAsset(): string | null;
        set _nativeAsset(value: string | null);
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _nativeDep(): {
            uuid: string;
            __nativeName__: string;
            ext: string;
            __isNative__: boolean;
        };
        /**
         * @en default init.
         * @zh 默认初始化。
         * @param uuid @en Asset uuid. @zh 资源 uuid。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        initDefault(uuid?: string): void;
    }
    /**
     * @en Class for LabelAtlas handling.
     * @zh 艺术数字字体资源类。
     *
     */
    export class LabelAtlas extends BitmapFont {
    }
    /**
     * @en Class for BitmapFont handling.
     * @zh 位图字体资源类。
     */
    export class BitmapFont extends Font {
        /**
         * @deprecated since v3.7.0, Useless Code.
         */
        fntDataStr: string;
        /**
         * @en [[SpriteFrame]] of the bitmap font.
         * @zh 位图字体所使用的精灵。
         */
        spriteFrame: SpriteFrame | null;
        /**
         * @en The font size.
         * @zh 文字尺寸。
         */
        fontSize: number;
        /**
         * @en Font configuration.
         * @zh 字体配置。
         */
        fntConfig: __private._cocos_2d_assets_bitmap_font__IConfig | null;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        fontDefDictionary: __private._cocos_2d_assets_bitmap_font__FontAtlas;
        constructor();
        onLoaded(): void;
    }
    /**
     * @en Class for Font handling.
     * @zh 字体资源类。
     */
    export class Font extends Asset {
    }
    /**
     * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
     */
    export interface IUV {
        u: number;
        v: number;
    }
    /**
     * @en Information object interface for initialize a [[SpriteFrame]] asset.
     * @zh 用于初始化 [[SpriteFrame]] 资源的对象接口描述。
     */
    export interface ISpriteFrameInitInfo {
        /**
         * @en The texture of the sprite frame, could be `TextureBase`.
         * @zh 贴图对象资源，可以是 `TextureBase` 类型。
         */
        texture?: __private._cocos_asset_assets_texture_base__TextureBase;
        /**
         * @en The original size of the sprite frame.
         * @zh 精灵帧原始尺寸。
         */
        originalSize?: math.Size;
        /**
         * @en The rect of the sprite frame in atlas texture.
         * @zh 精灵帧裁切矩形。
         */
        rect?: math.Rect;
        /**
         * @en The offset of the sprite frame center from the original center of the original rect.
         * Sprite frame in an atlas texture could be trimmed for clipping the transparent pixels, so the trimmed rect is smaller than the original one,
         * the offset defines the distance from the original center to the trimmed center.
         * @zh 精灵帧偏移量。
         * 在图集中的精灵帧可能会被剔除透明像素以获得更高的空间利用李，剔除后的矩形尺寸比剪裁前更小，偏移量指的是从原始矩形的中心到剪裁后的矩形中心的距离。
         */
        offset?: math.Vec2;
        /**
         * @en Top side border for sliced 9 frame.
         * @zh 九宫格精灵帧的上边界。
         * @default 0
         */
        borderTop?: number;
        /**
         * @en Bottom side border for sliced 9 frame.
         * @zh 九宫格精灵帧的下边界。
         * @default 0
         */
        borderBottom?: number;
        /**
         * @en Left side border for sliced 9 frame.
         * @zh 九宫格精灵帧的左边界。
         * @default 0
         */
        borderLeft?: number;
        /**
         * @en Right side border for sliced 9 frame.
         * @zh 九宫格精灵帧的右边界。
         * @default 0
         */
        borderRight?: number;
        /**
         * @en Whether the content of sprite frame is rotated.
         * @zh 是否旋转。
         */
        isRotate?: boolean;
        /**
         * @en Whether the uv is flipped.
         * @zh 是否转置 UV。
         */
        isFlipUv?: boolean;
    }
    export enum SpriteFrameEvent {
        UV_UPDATED = "uv_updated"
    }
    /**
     * @en
     * A `SpriteFrame` support several types.
     *  1. Rectangle sprite frame
     *  2. Sliced 9 sprite frame
     *  3. Mesh sprite frame
     * It mainly contains:<br/>
     *  - texture: A `TextureBase` that will be used by render process.<br/>
     *  - rectangle: A rectangle of the texture.
     *  - Sliced 9 border insets: The distance of each side from the internal rect to the sprite frame rect.
     *  - vertices: Vertex list for the mesh type sprite frame.
     *  - uv: The quad uv.
     *  - uvSliced: The sliced 9 uv.
     *
     * @zh
     * 精灵帧资源。
     * 一个 SpriteFrame 支持多种类型
     *  1. 矩形精灵帧
     *  2. 九宫格精灵帧
     *  3. 网格精灵帧
     * 它主要包含下列数据：<br/>
     *  - 纹理：会被渲染流程使用的 `TextureBase` 资源。<br/>
     *  - 矩形：在纹理中的矩形区域。
     *  - 九宫格信息：九宫格的内部矩形四个边距离 SpriteFrame 外部矩形的距离。
     *  - 网格信息：网格类型精灵帧的所有顶点列表。
     *  - uv: 四边形 UV。
     *  - uvSliced: 九宫格 UV。
     * 可通过 `SpriteFrame` 获取该组件。
     *
     * @example
     * ```ts
     * import { resources } from 'cc';
     * // First way to use a SpriteFrame
     * const url = "assets/PurpleMonster/icon/spriteFrame";
     * resources.load(url, (err, spriteFrame) => {
     *   const node = new Node("New Sprite");
     *   const sprite = node.addComponent(Sprite);
     *   sprite.spriteFrame = spriteFrame;
     *   node.parent = self.node;
     * });
     *
     * // Second way to use a SpriteFrame
     * const self = this;
     * const url = "test_assets/PurpleMonster";
     * resources.load(url, (err, imageAsset) => {
     *  if(err){
     *    return;
     *  }
     *
     *  const node = new Node("New Sprite");
     *  const sprite = node.addComponent(Sprite);
     *  const spriteFrame = new SpriteFrame();
     *  const tex = imageAsset._texture;
     *  spriteFrame.texture = tex;
     *  sprite.spriteFrame = spriteFrame;
     *  node.parent = self.node;
     * });
     *
     * // Third way to use a SpriteFrame
     * const self = this;
     * const cameraComp = this.getComponent(Camera);
     * const renderTexture = new RenderTexture();
     * renderTexture.reset({
     *   width: 512,
     *   height: 512,
     *   depthStencilFormat: RenderTexture.DepthStencilFormat.DEPTH_24_STENCIL_8
     * });
     *
     * cameraComp.targetTexture = renderTexture;
     * const spriteFrame = new SpriteFrame();
     * spriteFrame.texture = renderTexture;
     * ```
     */
    export class SpriteFrame extends Asset {
        /**
         * @en Create a SpriteFrame object by an image asset or an native image asset.
         * @zh 通过 Image 资源或者平台相关 Image 对象创建一个 SpriteFrame 资源。
         * @param imageSourceOrImageAsset @en ImageAsset or ImageSource, ImageSource could be HTMLCanvasElement, HTMLImageElement, IMemoryImageSource.
         *                                @zh 图像资源或图像原始图像源，图像原始图像源支持 HTMLCanvasElement HTMLImageElement IMemoryImageSource 三种资源。
         * @returns @en SpriteFrame asset. @zh 精灵资源。
         */
        static createWithImage(imageSourceOrImageAsset: __private._cocos_asset_assets_image_asset__ImageSource | ImageAsset): SpriteFrame;
        /**
         * @en uv update event.
         * @zh uv 更新事件。
         */
        static EVENT_UV_UPDATED: SpriteFrameEvent;
        static MeshType: typeof __private._cocos_2d_assets_sprite_frame__MeshType;
        /**
         * @en Top border distance of sliced 9 rect.
         * @zh 九宫格内部矩形顶部边框距离 SpriteFrame 矩形的距离。
         */
        get insetTop(): number;
        set insetTop(value: number);
        /**
         * @en Bottom border distance of sliced 9 rect.
         * @zh 九宫格内部矩形底部边框距离 SpriteFrame 矩形的距离。
         */
        get insetBottom(): number;
        set insetBottom(value: number);
        /**
         * @en Left border distance of sliced 9 rect.
         * @zh 九宫格内部矩形左边框距离 SpriteFrame 矩形的距离。
         */
        get insetLeft(): number;
        set insetLeft(value: number);
        /**
         * @en Right border distance of sliced 9 rect.
         * @zh 九宫格内部矩形右边框距离 SpriteFrame 矩形的距离。
         */
        get insetRight(): number;
        set insetRight(value: number);
        /**
         * @en Returns the rect of the sprite frame in the texture.
         * If it's an atlas texture, a transparent pixel area is proposed for the actual mapping of the current texture.
         * @zh 获取 SpriteFrame 的纹理矩形区域。
         * 如果是一个 atlas 的贴图，则为当前贴图的实际剔除透明像素区域。
         */
        get rect(): math.Rect;
        set rect(value: math.Rect);
        /**
         * @en The original size before trimmed.
         * @zh 修剪前的原始大小。
         */
        get originalSize(): math.Size;
        set originalSize(value: math.Size);
        /**
         * @en The offset of the sprite frame center.
         * Sprite frame in an atlas texture could be trimmed for clipping the transparent pixels, so the trimmed rect is smaller than the original one,
         * the offset defines the distance from the original center to the trimmed center.
         * @zh 精灵帧偏移量。
         * 在图集中的精灵帧可能会被剔除透明像素以获得更高的空间利用李，剔除后的矩形尺寸比剪裁前更小，偏移量指的是从原始矩形的中心到剪裁后的矩形中心的距离。
         */
        get offset(): math.Vec2;
        set offset(value: math.Vec2);
        /**
         * @en Whether the content of sprite frame is rotated.
         * @zh 是否旋转。
         */
        get rotated(): boolean;
        set rotated(rotated: boolean);
        /**
         * @en The texture of the sprite frame, could be `TextureBase`.
         * @zh 贴图对象资源，可以是 `TextureBase` 类型。
         */
        get texture(): __private._cocos_asset_assets_texture_base__TextureBase;
        set texture(value: __private._cocos_asset_assets_texture_base__TextureBase);
        /**
         * @en The uuid of the atlas asset, if exists.
         * @zh 图集资源的 uuid。
         */
        get atlasUuid(): string;
        set atlasUuid(value: string);
        /**
         * @en The pixel width of the sprite frame.
         * @zh 精灵帧的像素宽度。
         */
        get width(): number;
        /**
         * @en The pixel height of the sprite frame.
         * @zh 精灵帧的像素高度。
         */
        get height(): number;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        set _textureSource(value: __private._cocos_asset_assets_texture_base__TextureBase);
        /**
         * @en Whether flip the uv in X direction.
         * @zh 沿 X 轴方向, 翻转 UV。
         */
        get flipUVX(): boolean;
        set flipUVX(value: boolean);
        /**
         * @en Whether flip the uv in Y direction.
         * @zh 沿 Y 轴方向, 翻转 UV。
         */
        get flipUVY(): boolean;
        set flipUVY(value: boolean);
        /**
         * @en Sets whether sprite can be packed into dynamic atlas.
         * @zh 设置精灵是否允许参与自动合图。
         */
        get packable(): boolean;
        set packable(value: boolean);
        /**
         * @en Original information before packed to dynamic atlas, includes texture, width, height. It's null before being packed to dynamic atlas.
         * @zh 精灵自动合图之前的原始 texture 和宽高信息。在参与自动合图之前此值为 null。
         */
        get original(): {
            _texture: __private._cocos_asset_assets_texture_base__TextureBase;
            _x: number;
            _y: number;
        } | null;
        /**
         * @en Number of pixels corresponding to unit size in world space (pixels per unit).
         * @zh 世界空间中的单位大小对应的像素数量（像素每单位）。
         */
        get pixelsToUnit(): number;
        /**
         * @en Local origin position when generating the mesh.
         * @zh 生成 mesh 时本地坐标原点位置。
         */
        get pivot(): math.Vec2;
        /**
         * @en mesh information, you should call the [[ensureMeshData]] function before using it.
         * @zh mesh 信息，你应该在使用它之前调用 [[ensureMeshData]] 函数来确保其可用。
         */
        get mesh(): Mesh | null;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get trimmedBorder(): math.Vec4;
        /**
         * @en Vertex list for the mesh type sprite frame.
         * @zh 网格类型精灵帧的所有顶点列表。
         */
        vertices: __private._cocos_2d_assets_sprite_frame__IVertices | null;
        /**
         * @en UV for quad vertices.
         * @zh 矩形的顶点 UV。
         */
        uv: number[];
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        unbiasUV: number[];
        /**
         * @en UV for sliced 9 vertices.
         * @zh 九宫格的顶点 UV。
         */
        uvSliced: IUV[];
        protected _rect: math.Rect;
        protected _trimmedBorder: math.Vec4;
        protected _offset: math.Vec2;
        protected _originalSize: math.Size;
        protected _rotated: boolean;
        protected _capInsets: number[];
        protected _atlasUuid: string;
        protected _texture: __private._cocos_asset_assets_texture_base__TextureBase;
        protected _isFlipUVY: boolean;
        protected _isFlipUVX: boolean;
        protected _original: {
            _texture: __private._cocos_asset_assets_texture_base__TextureBase;
            _x: number;
            _y: number;
        } | null;
        protected _packable: boolean;
        protected _pixelsToUnit: number;
        protected _pivot: math.Vec2;
        protected _meshType: __private._cocos_2d_assets_sprite_frame__MeshType;
        protected _extrude: number;
        protected _customOutLine: never[];
        protected _mesh: Mesh | null;
        protected _minPos: math.Vec3;
        protected _maxPos: math.Vec3;
        constructor();
        /**
         * @en
         * Returns whether the texture have been loaded.
         * @zh
         * 返回是否已加载精灵帧。
         *
         * @deprecated since v3.3, Useless Code.
         */
        textureLoaded(): boolean;
        /**
         * @en
         * Returns whether the sprite frame is rotated in the texture.
         * @zh
         * 获取 SpriteFrame 是否旋转。
         * @deprecated since v1.2, please use [[rotated]] instead.
         */
        isRotated(): boolean;
        /**
         * @en
         * Set whether the sprite frame is rotated in the texture.
         * @zh
         * 设置 SpriteFrame 是否旋转。
         * @param rotated @en rotated.  @zh 是否旋转。
         * @deprecated since v1.2, please use [[rotated]] instead.
         */
        setRotated(rotated: boolean): void;
        /**
         * @en Returns the rect of the sprite frame in the texture.
         * If it's an atlas texture, a transparent pixel area is proposed for the actual mapping of the current texture.
         * @zh 获取 SpriteFrame 的纹理矩形区域。
         * 如果是一个 atlas 的贴图，则为当前贴图的实际剔除透明像素区域。
         * @param out @en The output rect. @zh 输出的矩形区域。
         * @returns @en The rect. @zh 矩形区域。
         * @deprecated since v1.2, please use [[rect]].
         */
        getRect(out?: math.Rect): math.Rect;
        /**
         * @en Sets the rect of the sprite frame in the texture.
         * @zh 设置 SpriteFrame 的纹理矩形区域。
         * @param rect @en The new rect. @zh 想要设置的 rect。
         * @deprecated since v1.2, please use [[rect]].
         */
        setRect(rect: math.Rect): void;
        /**
         * @en Returns the original size before trimmed.
         * @zh 获取修剪前的原始大小。
         * @param out @en The output original size. @zh 输出的原始大小。
         * @returns @en The original size. @zh 原始大小。
         * @deprecated since v1.2, please use [[originalSize]].
         */
        getOriginalSize(out?: math.Size): math.Size;
        /**
         * @en Sets the original size before trimmed.
         * @zh 设置修剪前的原始大小。
         * @param size @en The new original size. @zh 新设置的原始大小。
         * @deprecated since v1.2, please use [[originalSize]].
         */
        setOriginalSize(size: math.Size): void;
        /**
         * @en Gets the offset of the frame.
         * @zh 获取偏移量。
         * @param out @en The output offset object. @zh 输出的偏移量。
         * @returns @en The offset object. @zh 偏移量。
         * @deprecated since v1.2, please use [[offset]]
         */
        getOffset(out?: math.Vec2): math.Vec2;
        /**
         * @en Sets the offset of the frame.
         * @zh 设置偏移量。
         * @param offset @en The new offset. @zh 新设置的偏移量。
         * @deprecated since v1.2, please use [[offset]]
         */
        setOffset(offset: math.Vec2): void;
        /**
         * @en Gets the related GFX [[gfx.Texture]] resource.
         * @zh 获取渲染贴图的 GFX 资源。
         * @returns @en Gfx Texture resource. @zh GFX 贴图资源。
         */
        getGFXTexture(): gfx.Texture | null;
        /**
         * @en Gets the GFX sampler of its texture.
         * @zh 贴图资源的采样器。
         * @returns @en The GFX sampler resource. @zh GFX贴图采样器。
         */
        getGFXSampler(): gfx.Sampler;
        /**
         * @en Gets the hash of its texture.
         * @zh 贴图资源的哈希值。
         * @returns @en Texture`s hash. @zh 贴图哈希值。
         */
        getHash(): number;
        /**
         * @en Gets the sampler hash of its texture.
         * @zh 贴图资源的采样器哈希值。
         * @returns @en Sampler`s hash. @zh 采样器哈希值。
         */
        getSamplerInfo(): Readonly<gfx.SamplerInfo>;
        /**
         * @en Resets the sprite frame data.
         * @zh 重置 SpriteFrame 数据。
         * @param info @en SpriteFrame initialization information. @zh SpriteFrame 初始化信息。
         * @param clearData @en Clear Data before initialization. @zh 是否在初始化前清空原有数据。
         */
        reset(info?: ISpriteFrameInitInfo, clearData?: boolean): void;
        /**
         * @en Check whether the rect of the sprite frame is out of the texture boundary.
         * @zh 判断精灵计算的矩形区域是否越界。
         * @param texture @en Texture resources for sprite frame. @zh SpriteFrame 的贴图资源。
         * @returns @en Out of the texture boundary or not. @zh 矩形区域是否越界。
         */
        checkRect(texture: __private._cocos_asset_assets_texture_base__TextureBase): boolean;
        /**
         * @en Make sure the mesh is available, you should call it before using the mesh.
         * @zh 确保 mesh 可用，你应该在使用 mesh 之前调用它。
         */
        ensureMeshData(): void;
        destroy(): boolean;
        /**
         * Calculate UV for sliced
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _calculateSlicedUV(): void;
        /**
         * Calculate UV
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _calculateUV(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _setDynamicAtlasFrame(frame: any): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _resetDynamicAtlasFrame(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _checkPackable(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _serialize(ctxForExporting: any): any;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _deserialize(serializeData: any, handle: any): void;
        /**
         * @en clone a sprite frame.
         * @zh 克隆当前 sprite frame。
         */
        clone(): SpriteFrame;
        protected _refreshTexture(texture: __private._cocos_asset_assets_texture_base__TextureBase): void;
        /**
         * @en complete loading callback.
         * @zh 加载完成回调。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        onLoaded(): void;
        /**
         * @en default init.
         * @zh 默认初始化。
         * @param uuid @en Asset uuid. @zh 资源 uuid。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        initDefault(uuid?: string): void;
        /**
         * @en Check whether the sprite frame is validate.
         * @zh 检查当前 sprite frame 对象是否是有效的。
         * @returns @en validate or not. @zh 是否有效。
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        validate(): boolean;
        protected _initVertices(): void;
        protected _updateMeshVertices(): void;
        protected _createMesh(): void;
        protected _updateMesh(): void;
    }
    /**
     * @en
     * The root node of UI.
     * Provide an aligned window for all child nodes, also provides ease of setting screen adaptation policy interfaces from the editor.
     * Line-of-sight range is -999 to 1000.
     *
     * @zh
     * 作为 UI 根节点，为所有子节点提供对齐视窗，另外提供屏幕适配策略接口，方便从编辑器设置。
     * 注：由于本节点的尺寸会跟随屏幕拉伸，所以 anchorPoint 只支持 (0.5, 0.5)，否则适配不同屏幕时坐标会有偏差。
     * UI 的视距范围是 -999 ～ 1000.
     */
    export class Canvas extends RenderRoot2D {
        /**
         * @en
         * The render mode of Canvas.
         * When you choose the mode of INTERSPERSE, You can specify the rendering order of the Canvas with the camera in the scene.
         * When you choose the mode of OVERLAY, the builtin camera of Canvas will render after all scene cameras are rendered.
         * NOTE: The cameras in the scene (including the Canvas built-in camera) must have a ClearFlag selection of SOLID_COLOR,
         * otherwise a splash screen may appear on the mobile device.
         *
         * @zh
         * Canvas 渲染模式。
         * intersperse 下可以指定 Canvas 与场景中的相机的渲染顺序，overlay 下 Canvas 会在所有场景相机渲染完成后渲染。
         * 注意：场景里的相机（包括 Canvas 内置的相机）必须有一个的 ClearFlag 选择 SOLID_COLOR，否则在移动端可能会出现闪屏。
         *
         * @deprecated since v3.0, please use [[Camera.priority]] to control overlapping between cameras.
         */
        get renderMode(): number;
        set renderMode(val: number);
        /**
         * @en The camera component that will be aligned with this canvas
         * @zh 将与此 canvas 对齐的相机组件
         */
        get cameraComponent(): Camera | null;
        set cameraComponent(value: Camera | null);
        /**
         * @en Align canvas with screen
         * @zh 是否使用屏幕对齐画布
         */
        get alignCanvasWithScreen(): boolean;
        set alignCanvasWithScreen(value: boolean);
        protected _cameraComponent: Camera | null;
        protected _alignCanvasWithScreen: boolean;
        protected _thisOnCameraResized: () => void;
        protected fitDesignResolution_EDITOR: (() => void) | undefined;
        constructor();
        __preload(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        protected _onResizeCamera(): void;
    }
    /**
     * @en Legacy 2D base class for rendering component, please use [[UIRenderer]] instead.
     * This component will setup NodeUIProperties.uiComp in its owner [[Node]].
     * @zh 旧的 2D 渲染组件基类，请使用 [[UIRenderer]] 替代。
     * 这个组件会设置 [[Node]] 上的 NodeUIProperties.uiComp。
     * @deprecated since v3.4.1, please use [[UIRenderer]] instead.
     */
    export class UIComponent extends Component {
        protected _lastParent: Node | null;
        constructor();
        __preload(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en Post render data submission procedure, it's executed after assembler updated for all children.
         * It may assemble some extra render data to the geometry buffers, or it may only change some render states.
         * Don't call it unless you know what you are doing.
         * @zh 后置渲染数据组装程序，它会在所有子节点的渲染数据组装完成后被调用。
         * 它可能会组装额外的渲染数据到顶点数据缓冲区，也可能只是重置一些渲染状态。
         * 注意：不要手动调用该函数，除非你理解整个流程。
         * @deprecated since v3.4.1, please use [[UIRenderer]] instead.
         */
        postUpdateAssembler(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        /**
         * @deprecated since v3.4.1, please use [[UIRenderer]] instead.
         */
        markForUpdateRenderData(enable?: boolean): void;
        /**
         * @deprecated since v3.4.1, please use [[UIRenderer]] instead.
         */
        stencilStage: __private._cocos_2d_renderer_stencil_manager__Stage;
        /**
         * @deprecated since v3.4.1, please use [[UIRenderer]] instead.
         */
        setNodeDirty(): void;
        /**
         * @deprecated since v3.4.1, please use [[UIRenderer]] instead.
         */
        setTextureDirty(): void;
    }
    /**
     * @en
     * The shader property type of the material after instantiation.
     *
     * @zh
     * 实例后的材质的着色器属性类型。
     */
    export enum InstanceMaterialType {
        /**
         * @en
         * The shader only has color properties.
         *
         * @zh
         * 着色器只带颜色属性。
         */
        ADD_COLOR = 0,
        /**
         * @en
         * The shader has color and texture properties.
         *
         * @zh
         * 着色器带颜色和贴图属性。
         */
        ADD_COLOR_AND_TEXTURE = 1,
        /**
         * @en
         * The shader has color and texture properties and uses grayscale mode.
         *
         * @zh
         * 着色器带颜色和贴图属性,并使用灰度模式。
         */
        GRAYSCALE = 2,
        /**
         * @en
         * The shader has color and texture properties and uses embedded alpha mode.
         *
         * @zh
         * 着色器带颜色和贴图属性,并使用透明通道分离贴图。
         */
        USE_ALPHA_SEPARATED = 3,
        /**
         * @en
         * The shader has color and texture properties and uses embedded alpha and grayscale mode.
         *
         * @zh
         * 着色器带颜色和贴图属性,并使用灰度模式。
         */
        USE_ALPHA_SEPARATED_AND_GRAY = 4
    }
    /**
     * @en Base class for UI components which supports rendering features.
     * This component will setup NodeUIProperties.uiComp in its owner [[Node]]
     *
     * @zh 所有支持渲染的 UI 组件的基类。
     * 这个组件会设置 [[Node]] 上的 NodeUIProperties.uiComp。
     */
    export class UIRenderer extends Renderer {
        /**
         * @en The blend factor enums
         * @zh 混合模式枚举类型
         * @see [[gfx.BlendFactor]]
         * @internal
         */
        static BlendState: typeof gfx.BlendFactor;
        /**
         * @en The render data assembler
         * @zh 渲染数据组装器
         * @internal
         */
        static Assembler: IAssemblerManager;
        /**
         * @en The post render data assembler
         * @zh 后置渲染数据组装器
         * @internal
         */
        static PostAssembler: IAssemblerManager | null;
        constructor();
        get sharedMaterials(): (Material | null)[];
        set sharedMaterials(val: (Material | null)[]);
        /**
         * @en The customMaterial
         * @zh 用户自定材质
         */
        get customMaterial(): Material | null;
        set customMaterial(val: Material | null);
        /**
         * @en Main color for rendering, it normally multiplies with texture color.
         * @zh 渲染颜色，一般情况下会和贴图颜色相乘。
         */
        get color(): Readonly<math.Color>;
        set color(value: Readonly<math.Color>);
        protected _renderData: RenderData | null;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get renderData(): RenderData | null;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get useVertexOpacity(): boolean;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         * @en The component stencil stage (please do not any modification directly on this object)
         * @zh 组件模板缓冲状态 (注意：请不要直接修改它的值)
         */
        get stencilStage(): __private._cocos_2d_renderer_stencil_manager__Stage;
        set stencilStage(val: __private._cocos_2d_renderer_stencil_manager__Stage);
        protected _materials: (Material | null)[];
        protected _customMaterial: Material | null;
        protected _srcBlendFactor: gfx.BlendFactor;
        protected _dstBlendFactor: gfx.BlendFactor;
        protected _color: math.Color;
        protected _stencilStage: __private._cocos_2d_renderer_stencil_manager__Stage;
        protected _assembler: IAssembler | null;
        protected _postAssembler: IAssembler | null;
        protected _renderDataFlag: boolean;
        protected _renderFlag: boolean;
        protected _renderEntity: __private._cocos_2d_renderer_render_entity__RenderEntity;
        protected _instanceMaterialType: number;
        protected _srcBlendFactorCache: gfx.BlendFactor;
        protected _dstBlendFactorCache: gfx.BlendFactor;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        _dirtyVersion: number;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        _internalId: number;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get batcher(): UI;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get renderEntity(): __private._cocos_2d_renderer_render_entity__RenderEntity;
        /**
         * @en Marks for calculating opacity per vertex
         * @zh 标记组件是否逐顶点计算透明度
         */
        protected _useVertexOpacity: boolean;
        protected _lastParent: Node | null;
        onLoad(): void;
        __preload(): void;
        onEnable(): void;
        onRestore(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en Marks the render data of the current component as modified so that the render data is recalculated.
         * @zh 标记当前组件的渲染数据为已修改状态，这样渲染数据才会重新计算。
         * @param enable Marked necessary to update or not
         */
        markForUpdateRenderData(enable?: boolean): void;
        /**
         * @en Request new render data object.
         * @zh 请求新的渲染数据对象。
         * @return @en The new render data. @zh 新的渲染数据。
         */
        requestRenderData(drawInfoType?: __private._cocos_2d_renderer_render_draw_info__RenderDrawInfoType): RenderData;
        /**
         * @en Destroy current render data.
         * @zh 销毁当前渲染数据。
         */
        destroyRenderData(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        updateRenderer(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        fillBuffers(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        /**
         * @en Post render data submission procedure, it's executed after assembler updated for all children.
         * It may assemble some extra render data to the geometry buffers, or it may only change some render states.
         * Don't call it unless you know what you are doing.
         * @zh 后置渲染数据组装程序，它会在所有子节点的渲染数据组装完成后被调用。
         * 它可能会组装额外的渲染数据到顶点数据缓冲区，也可能只是重置一些渲染状态。
         * 注意：不要手动调用该函数，除非你理解整个流程。
         */
        postUpdateAssembler(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        protected _render(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        protected _postRender(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        protected _canRender(): boolean;
        protected _postCanRender(): void;
        protected _updateColor(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        static setEntityColorDirtyRecursively(node: Node, dirty: boolean): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setEntityColor(color: math.Color): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setEntityOpacity(opacity: number): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setEntityEnabled(enabled: boolean): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _updateBlendFunc(): void;
        protected _nodeStateChange(transformType: TransformBit): void;
        protected _colorDirty(): void;
        protected _onMaterialModified(idx: number, material: Material | null): void;
        protected _updateBuiltinMaterial(): Material;
        protected _flushAssembler?(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setNodeDirty(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setTextureDirty(): void;
        protected createRenderEntity(): __private._cocos_2d_renderer_render_entity__RenderEntity;
    }
    /**
     * @en
     * The component of transform in UI.
     *
     * @zh
     * UI 变换组件。
     */
    export class UITransform extends Component {
        constructor();
        /**
         * @en
         * Size of the UI node.
         *
         * @zh
         * 内容尺寸。
         */
        get contentSize(): Readonly<math.Size>;
        set contentSize(value: Readonly<math.Size>);
        /**
         * @en
         * component width.
         * @zh
         * 组件宽度。
         */
        get width(): number;
        set width(value: number);
        /**
         * @en
         * component height.
         * @zh
         * 组件高度。
         */
        get height(): number;
        set height(value: number);
        /**
         * @en
         * Anchor point of the UI node.
         *
         * @zh
         * 锚点位置。
         */
        get anchorPoint(): Readonly<math.Vec2>;
        set anchorPoint(value: Readonly<math.Vec2>);
        /**
         * @en
         * The x-axis anchor of the node.
         *
         * @zh
         * 锚点位置的 X 坐标。
         */
        get anchorX(): number;
        set anchorX(value: number);
        /**
         * @en
         * The y-axis anchor of the node.
         *
         * @zh
         * 锚点位置的 Y 坐标。
         */
        get anchorY(): number;
        set anchorY(value: number);
        /**
         * @en
         * Render sequence.
         * Note: UI rendering is only about priority.
         *
         * @zh
         * 渲染先后顺序，按照广度渲染排列，按同级节点下进行一次排列。
         * @deprecated Since v3.1
         */
        get priority(): number;
        set priority(value: number);
        protected _priority: number;
        /**
         * @en Get the visibility bit-mask of the rendering camera
         * @zh 查找被渲染相机的可见性掩码。
         * @deprecated since v3.0
         */
        get visibility(): number;
        /**
         * @en Get the priority of the rendering camera
         * @zh 查找被渲染相机的渲染优先级。
         */
        get cameraPriority(): number;
        static EventType: typeof NodeEventType;
        protected _contentSize: math.Size;
        protected _anchorPoint: math.Vec2;
        __preload(): void;
        onLoad(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en
         * Sets the untransformed size of the ui transform.<br/>
         * The contentSize remains the same no matter if the node is scaled or rotated.<br/>
         * @zh
         * 设置节点 UI Transform 的原始大小，不受该节点是否被缩放或者旋转的影响。
         *
         * @param size @en The size of the UI transform. @zh UI Transform 的 Size 大小。
         * @example
         * ```ts
         * import { Size } from 'cc';
         * node.setContentSize(new Size(100, 100));
         * ```
         */
        setContentSize(size: math.Size): void;
        /**
         * @en
         * Sets the untransformed size of the ui transform.<br/>
         * The contentSize remains the same no matter if the node is scaled or rotated.<br/>
         * @zh
         * 设置节点 UI Transform 的原始大小，不受该节点是否被缩放或者旋转的影响。
         *
         * @param width  @en The width of the UI transform. @zh UI Transform 的宽。
         * @param height @en The height of the UI transform. @zh UI Transform 的高。
         * @example
         * ```ts
         * import { Size } from 'cc';
         * node.setContentSize(100, 100);
         * ```
         */
        setContentSize(width: number, height: number): void;
        /**
         * @en
         * Sets the anchor point in percent. <br/>
         * anchor point is the point around which all transformations and positioning manipulations take place. <br/>
         * It's like a pin in the node where it is "attached" to its parent. <br/>
         * The anchorPoint is normalized, like a percentage. (0,0) means the bottom-left corner and (1,1) means the top-right corner.<br/>
         * But you can use values higher than (1,1) and lower than (0,0) too.<br/>
         * The default anchor point is (0.5,0.5), so it starts at the center of the node.
         *
         * @zh
         * 设置锚点的百分比。<br>
         * 锚点应用于所有变换和坐标点的操作，它就像在节点上连接其父节点的大头针。<br>
         * 锚点是标准化的，就像百分比一样。(0，0) 表示左下角，(1，1) 表示右上角。<br>
         * 但是你可以使用比（1，1）更高的值或者比（0，0）更低的值。<br>
         * 默认的锚点是（0.5，0.5），因此它开始于节点的中心位置。<br>
         * 注意：Creator 中的锚点仅用于定位所在的节点，子节点的定位不受影响。
         *
         * @param point @en Node anchor point or node x-axis anchor.
         *              @zh 节点锚点或节点 x 轴锚。
         * @param y @en The y-axis anchor of the node.
         *          @zh 节点 y 轴锚。
         * @example
         * ```ts
         * import { Vec2 } from 'cc';
         * node.setAnchorPoint(new Vec2(1, 1));
         * node.setAnchorPoint(1, 1);
         * ```
         */
        setAnchorPoint(point: math.Vec2 | Readonly<math.Vec2> | number, y?: number): void;
        /**
         * @zh UI 空间中的点击测试。
         * @en Hit test with point in UI Space.
         *
         * @param uiPoint point in UI Space.
         * @deprecated since v3.5.0, please use `uiTransform.hitTest(screenPoint: Vec2)` instead.
         */
        isHit(uiPoint: math.Vec2): boolean;
        /**
         * @zh 屏幕空间中的点击测试。
         * @en Hit test with point in Screen Space.
         *
         * @param screenPoint @en point in Screen Space. @zh 屏幕坐标中的点。
         */
        hitTest(screenPoint: math.Vec2, windowId?: number): boolean;
        /**
         * @en
         * Converts a Point to node (local) space coordinates.
         *
         * @zh
         * 将一个 UI 节点世界坐标系下点转换到另一个 UI 节点 (局部) 空间坐标系，这个坐标系以锚点为原点。
         * 非 UI 节点转换到 UI 节点(局部) 空间坐标系，请走 Camera 的 `convertToUINode`。
         *
         * @param worldPoint @en Point in world space.
         *                   @zh 世界坐标点。
         * @param out @en Point in local space.
         *            @zh 转换后坐标。
         * @returns @en Return the relative position to the target node.
         *          @zh 返回与目标节点的相对位置。
         * @example
         * ```ts
         * const newVec3 = uiTransform.convertToNodeSpaceAR(cc.v3(100, 100, 0));
         * ```
         */
        convertToNodeSpaceAR(worldPoint: math.Vec3, out?: math.Vec3): math.Vec3;
        /**
         * @en
         * Converts a Point in node coordinates to world space coordinates.
         *
         * @zh
         * 将距当前节点坐标系下的一个点转换到世界坐标系。
         *
         * @param nodePoint @en Point in local space.
         *                  @zh 节点坐标。
         * @param out @en Point in world space.
         *            @zh 转换后坐标。
         * @returns @en Returns the coordinates in the UI world coordinate system.
         *          @zh 返回 UI 世界坐标系。
         * @example
         * ```ts
         * const newVec3 = uiTransform.convertToWorldSpaceAR(3(100, 100, 0));
         * ```
         */
        convertToWorldSpaceAR(nodePoint: math.Vec3, out?: math.Vec3): math.Vec3;
        /**
         * @en
         * Returns an axis aligned bounding box of this node in local space coordinate.
         * The returned box is relative only to its parent, and it doesn't contain any child nodes.
         * The behavior is slightly different with [[getBoundingBoxToWorld]] and [[getBoundingBoxTo]].
         *
         * @zh
         * 返回父节坐标系下的轴向对齐的包围盒。
         * 返回的包围盒仅仅只包含当前节点的轴向对齐包围盒，不包含子节点。
         * 这个 API 的行为和 [[getBoundingBoxToWorld]] 和 [[getBoundingBoxTo]] 略有不同。
         *
         * @returns @en An axis aligned bounding box of this node in local space coordinate.  @zh 本地坐标系下的包围盒。
         * @example
         * ```ts
         * const boundingBox = uiTransform.getBoundingBox();
         * ```
         */
        getBoundingBox(): math.Rect;
        /**
         * @en
         * Returns an axis aligned bounding box of this node in world space coordinate.
         * The bounding box contains self and active children's world bounding box, and it will eliminate all zero sized nodes.
         * @zh
         * 返回节点在世界坐标系下的对齐轴向的包围盒（AABB）。
         * 该边框包含自身和已激活的子节点的世界边框，但会剔除所有零大小的节点。
         * @returns @en An axis aligned bounding box of this node in world space coordinate. @zh 世界坐标系下包围盒。
         * @example
         * ```ts
         * const newRect = uiTransform.getBoundingBoxToWorld();
         * ```
         */
        getBoundingBoxToWorld(): math.Rect;
        /**
         * @en
         * Returns the minimum bounding box in the coordinate system of the target node.
         * The result contains the current node and its child node tree, and it will eliminates all zero size nodes.
         * E.g. passing an identical matrix will return the world bounding box of the current node tree.
         * @zh
         * 返回在目标节点坐标系下包含当前包围盒及其子节点包围盒的最小总包围盒，但会剔除所有零大小的节点。
         * 如果传入单位矩阵，将得到世界坐标系下的包围盒。
         *
         * @param targetMat @en The target node's world matrix representing its coordinate system.
         *                  @zh 表示目标节点坐标系的世界矩阵。
         * @returns @en The minimum bounding box containing the current bounding box and its child nodes.
         *          @zh 包含当前节点包围盒及其子节点包围盒的最小包围盒。
         */
        getBoundingBoxTo(targetMat: math.Mat4): math.Rect;
        /**
         * @en
         * Compute the corresponding aabb in world space for raycast.
         * @zh
         * 计算出此 UI_2D 节点在世界空间下的 aabb 包围盒。
         * @param out @en The out object of aabb bounding box of the node in world space.  @zh 输出节点在世界空间下的 aabb 包围盒。
         * @returns @en The aabb bounding box of the node in world space. @zh 节点在世界空间下的 aabb 包围盒。
         */
        getComputeAABB(out?: geometry.AABB): geometry.AABB;
        protected _selfBoundingBox(out: math.Rect): math.Rect;
        protected _parentChanged(node: Node): void;
    }
    /**
     * @en The entry node for 2D object data collection, all 2D rendering objects need to be rendered under the RenderRoot node.
     * @zh 2D 对象数据收集的入口节点，所有的 2D渲染对象需在 RenderRoot 节点下才可以被渲染。
     */
    export class RenderRoot2D extends Component {
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
    }
    /**
     * @en 2D rendering component that provides the ability to render sprite in 3D space.
     * @zh 2D 渲染基础组件，提供精灵渲染在 3D 空间中的能力。
     */
    export class SpriteRenderer extends ModelRenderer {
        constructor();
        /**
         * @en The spriteFrame that the component should render.
         * @zh 该组件应渲染的 spriteFrame。
         */
        get spriteFrame(): SpriteFrame | null;
        set spriteFrame(value: SpriteFrame | null);
        /**
         * @en Rendering model of the component.
         * @zh 该组件的渲染模型。
         */
        get model(): renderer.scene.Model | null;
        protected _spriteFrame: SpriteFrame | null;
        protected _mode: __private._cocos_2d_framework_sprite_renderer__SpriteMode;
        protected _color: math.Color;
        protected _flipX: boolean;
        protected _flipY: boolean;
        protected _size: math.Vec2;
        onLoad(): void;
        onRestore(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        protected _updateModels(): void;
        protected _createModel(): void;
        protected _updateModelParams(): void;
        protected _getBuiltinMaterial(): Material;
        protected _onMaterialModified(idx: number, material: Material | null): void;
        protected _onUpdateLocalDescriptorSet(): void;
        protected _attachToScene(): void;
    }
    /**
     * @en
     * The Mask Component.
     *
     * @zh
     * 遮罩组件。
     */
    export class Mask extends Component {
        /**
         * @en The type for mask.
         *
         * @zh 遮罩组件类型。
         */
        static Type: typeof __private._cocos_2d_components_mask__MaskType;
        constructor();
        /**
         * @en
         * The mask type.
         *
         * @zh
         * 遮罩类型。
         */
        get type(): __private._cocos_2d_components_mask__MaskType;
        set type(value: __private._cocos_2d_components_mask__MaskType);
        /**
         * @en
         * Reverse mask.
         * @zh
         * 反向遮罩。
         */
        get inverted(): boolean;
        set inverted(value: boolean);
        /**
         * @en
         * The segments for ellipse mask.
         *
         * TODO: remove segments, not supported by graphics
         * @zh
         * 椭圆遮罩的曲线细分数。
         */
        get segments(): number;
        set segments(value: number);
        /**
         * @en
         * The mask image.
         *
         * @zh
         * 遮罩所需要的贴图。
         * @deprecated since v3.6.1
         */
        get spriteFrame(): SpriteFrame | null;
        set spriteFrame(value: SpriteFrame | null);
        /**
         * @en
         * The alpha threshold.(Not supported Canvas Mode) <br/>
         * The content is drawn only where the stencil have pixel with alpha greater than the alphaThreshold. <br/>
         * Should be a float between 0 and 1. <br/>
         * This default to 0.1.
         * When it's set to 1, the stencil will discard all pixels, nothing will be shown.
         * @zh
         * Alpha 阈值（不支持 Canvas 模式）<br/>
         * 只有当模板的像素的 alpha 大于等于 alphaThreshold 时，才会绘制内容。<br/>
         * 该数值 0 ~ 1 之间的浮点数，默认值为 0.1
         * 当被设置为 1 时，会丢弃所有蒙版像素，所以不会显示任何内容
         */
        get alphaThreshold(): number;
        set alphaThreshold(value: number);
        /**
         * @en Rendering component for providing stencil buffer information.
         * @zh 用于提供 stencil buffer 信息的渲染组件。
         */
        get subComp(): Sprite | Graphics | null;
        protected _type: __private._cocos_2d_components_mask__MaskType;
        protected _inverted: boolean;
        protected _segments: number;
        protected _alphaThreshold: number;
        protected _sprite: Sprite | null;
        protected _graphics: Graphics | null;
        protected _stencilStage: __private._cocos_2d_renderer_stencil_manager__Stage;
        onLoad(): void;
        onEnable(): void;
        onRestore(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en Hit test with point in World Space.
         * @zh 世界空间中的点击测试。
         * @param worldPt @en point in World Space. @zh 世界空间中的点击点。
         */
        isHit(worldPt: math.Vec2): boolean;
        protected _nodeStateChange(type: TransformBit): void;
        protected _createSprite(): void;
        protected _createGraphics(): void;
        protected _updateGraphics(): void;
        protected _enableRender(): void;
        protected _disableRender(): void;
        protected _removeMaskNode(): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        get customMaterial(): Material | null;
        set customMaterial(val: Material | null);
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        get color(): math.Color | null;
        set color(value: math.Color | null);
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        markForUpdateRenderData(enable?: boolean): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        requestRenderData(any: any): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        destroyRenderData(): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        updateRenderer(): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        fillBuffers(render: any): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        postUpdateAssembler(render: any): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        setNodeDirty(): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        setTextureDirty(): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        get sharedMaterial(): Material | null;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        get sharedMaterials(): (Material | null)[] | null;
        set sharedMaterials(val: (Material | null)[] | null);
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        get material(): any;
        set material(val: any);
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        get materials(): (any)[];
        set materials(val: (any)[]);
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        getMaterial(idx: number): any;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        setMaterial(material: Material | renderer.MaterialInstance | null, index: number): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        getMaterialInstance(idx: number): any;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        setMaterialInstance(matInst: Material | renderer.MaterialInstance | null, index: number): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        getRenderMaterial(index: number): any;
    }
    /**
     * @en
     * The RichText Component.
     *
     * @zh
     * 富文本组件。
     */
    export class RichText extends Component {
        /**
         * @en
         * Content string of RichText.
         *
         * @zh
         * 富文本显示的文本内容。
         */
        get string(): string;
        set string(value: string);
        /**
         * @en
         * Horizontal Alignment of each line in RichText.
         *
         * @zh
         * 文本内容的水平对齐方式。
         */
        get horizontalAlign(): HorizontalTextAlignment;
        set horizontalAlign(value: HorizontalTextAlignment);
        /**
         * @en
         * Vertical Alignment of each line in RichText.
         *
         * @zh
         * 文本内容的竖直对齐方式。
         */
        get verticalAlign(): VerticalTextAlignment;
        set verticalAlign(value: VerticalTextAlignment);
        /**
         * @en
         * Font size of RichText.
         *
         * @zh
         * 富文本字体大小。
         */
        get fontSize(): number;
        set fontSize(value: number);
        /**
         * @en
         * Font color of RichText. Works when the text content does not have a color parameter set. Transparency cascade is not supported.
         *
         * @zh
         * 富文本默认文字颜色。在文本内容没有设置颜色参数时生效。暂不支持颜色级联。
         */
        get fontColor(): math.Color;
        set fontColor(value: math.Color);
        /**
         * @en
         * Custom System font of RichText.
         *
         * @zh
         * 富文本定制系统字体。
         */
        get fontFamily(): string;
        set fontFamily(value: string);
        /**
         * @en
         * Custom System font of RichText.
         *
         * @zh
         * 富文本定制字体。
         */
        get font(): TTFFont | null;
        set font(value: TTFFont | null);
        /**
         * @en
         * Whether to use system font name or not.
         *
         * @zh
         * 是否使用系统字体。
         */
        get useSystemFont(): boolean;
        set useSystemFont(value: boolean);
        /**
         * @en
         * The cache mode of label. This mode only supports system fonts.
         *
         * @zh
         * 文本缓存模式, 该模式只支持系统字体。
         */
        get cacheMode(): CacheMode;
        set cacheMode(value: CacheMode);
        /**
         * @en
         * The maximize width of the RichText.
         *
         * @zh
         * 富文本的最大宽度。
         */
        get maxWidth(): number;
        set maxWidth(value: number);
        /**
         * @en
         * Line Height of RichText.
         *
         * @zh
         * 富文本行高。
         */
        get lineHeight(): number;
        set lineHeight(value: number);
        /**
         * @en
         * The image atlas for the img tag. For each src value in the img tag, there should be a valid spriteFrame in the image atlas.
         *
         * @zh
         * 对于 img 标签里面的 src 属性名称，都需要在 imageAtlas 里面找到一个有效的 spriteFrame，否则 img tag 会判定为无效。
         */
        get imageAtlas(): SpriteAtlas | null;
        set imageAtlas(value: SpriteAtlas | null);
        /**
         * @en
         * Once checked, the RichText will block all input events (mouse and touch) within
         * the bounding box of the node, preventing the input from penetrating into the underlying node.
         *
         * @zh
         * 选中此选项后，RichText 将阻止节点边界框中的所有输入事件（鼠标和触摸），从而防止输入事件穿透到底层节点。
         */
        get handleTouchEvent(): boolean;
        set handleTouchEvent(value: boolean);
        /**
         * @en Enum for horizontal text alignment.
         *
         * @zh 文本横向对齐类型。
         */
        static HorizontalAlign: typeof HorizontalTextAlignment;
        /**
         * @en Enum for vertical text alignment.
         *
         * @zh 文本垂直对齐类型。
         */
        static VerticalAlign: typeof VerticalTextAlignment;
        protected _lineHeight: number;
        protected _string: string;
        protected _horizontalAlign: HorizontalTextAlignment;
        protected _verticalAlign: VerticalTextAlignment;
        protected _fontSize: number;
        protected _fontColor: math.Color;
        protected _maxWidth: number;
        protected _fontFamily: string;
        protected _font: TTFFont | null;
        protected _isSystemFontUsed: boolean;
        protected _userDefinedFont: TTFFont | null;
        protected _cacheMode: CacheMode;
        protected _imageAtlas: SpriteAtlas | null;
        protected _handleTouchEvent: boolean;
        protected _textArray: IHtmlTextParserResultObj[];
        protected _segments: __private._cocos_2d_components_rich_text__ISegment[];
        protected _labelSegmentsCache: __private._cocos_2d_components_rich_text__ISegment[];
        protected _linesWidth: number[];
        protected _lineCount: number;
        protected _labelWidth: number;
        protected _labelHeight: number;
        protected _layoutDirty: boolean;
        protected _lineOffsetX: number;
        protected _updateRichTextStatus: () => void;
        protected _labelChildrenNum: number;
        constructor();
        onLoad(): void;
        onEnable(): void;
        onDisable(): void;
        onRestore(): void;
        onDestroy(): void;
        protected _addEventListeners(): void;
        protected _removeEventListeners(): void;
        protected _updateLabelSegmentTextAttributes(): void;
        protected _createFontLabel(str: string): __private._cocos_2d_components_rich_text__ISegment;
        protected _createImage(spriteFrame: SpriteFrame): __private._cocos_2d_components_rich_text__ISegment;
        protected _onTTFLoaded(): void;
        protected _measureText(styleIndex: number, string?: string): number | ((s: string) => number);
        protected _onTouchEnded(event: EventTouch): void;
        protected _containsTouchLocation(label: __private._cocos_2d_components_rich_text__ISegment, point: math.Vec2): boolean;
        protected _resetState(): void;
        protected _activateChildren(active: any): void;
        protected _addLabelSegment(stringToken: string, styleIndex: number): __private._cocos_2d_components_rich_text__ISegment;
        protected _updateRichTextWithMaxWidth(labelString: string, labelWidth: number, styleIndex: number): void;
        protected _isLastComponentCR(stringToken: any): boolean;
        protected _updateLineInfo(): void;
        protected _needsUpdateTextLayout(newTextArray: IHtmlTextParserResultObj[]): boolean;
        protected _addRichTextImageElement(richTextElement: IHtmlTextParserResultObj): void;
        protected _updateTextDefaultColor(): void;
        protected _updateRichText(): void;
        protected _getFirstWordLen(text: string, startIndex: number, textLen: number): number;
        protected _updateRichTextPosition(): void;
        protected _convertLiteralColorValue(color: string): math.Color;
        protected _applyTextAttribute(labelSeg: __private._cocos_2d_components_rich_text__ISegment): void;
        protected _applyLayer(): void;
        protected _resetLabelState(label: Label): void;
    }
    /**
     * @en
     * Renders a sprite in the scene.
     *
     * @zh
     * 渲染精灵组件。
     */
    export class Sprite extends UIRenderer {
        constructor();
        /**
         * @en
         * The sprite atlas where the sprite is.
         *
         * @zh
         * 精灵的图集。
         */
        get spriteAtlas(): SpriteAtlas | null;
        set spriteAtlas(value: SpriteAtlas | null);
        /**
         * @en
         * The sprite frame of the sprite.
         *
         * @zh
         * 精灵的精灵帧。
         */
        get spriteFrame(): SpriteFrame | null;
        set spriteFrame(value: SpriteFrame | null);
        /**
         * @en
         * The sprite render type.
         *
         * @zh
         * 精灵渲染类型。
         *
         * @example
         * ```ts
         * import { Sprite } from 'cc';
         * sprite.type = Sprite.Type.SIMPLE;
         * ```
         */
        get type(): __private._cocos_2d_components_sprite__SpriteType;
        set type(value: __private._cocos_2d_components_sprite__SpriteType);
        /**
         * @en
         * The fill type, This will only have any effect if the "type" is set to “Sprite.Type.FILLED”.
         *
         * @zh
         * 精灵填充类型，仅渲染类型设置为 Sprite.Type.FILLED 时有效。
         *
         * @example
         * ```ts
         * import { Sprite } from 'cc';
         * sprite.fillType = Sprite.FillType.HORIZONTAL;
         * ```
         */
        get fillType(): __private._cocos_2d_components_sprite__FillType;
        set fillType(value: __private._cocos_2d_components_sprite__FillType);
        /**
         * @en
         * The fill Center, This will only have any effect if the "type" is set to “Sprite.Type.FILLED”.
         *
         * @zh
         * 填充中心点，仅渲染类型设置为 Sprite.Type.FILLED 时有效。
         *
         * @example
         * ```ts
         * import { Vec2 } from 'cc';
         * sprite.fillCenter = new Vec2(0, 0);
         * ```
         */
        get fillCenter(): math.Vec2;
        set fillCenter(value: math.Vec2);
        /**
         * @en
         * The fill Start, This will only have any effect if the "type" is set to “Sprite.Type.FILLED”.
         *
         * @zh
         * 填充起始点，仅渲染类型设置为 Sprite.Type.FILLED 时有效。
         *
         * @example
         * ```ts
         * // -1 To 1 between the numbers
         * sprite.fillStart = 0.5;
         * ```
         */
        get fillStart(): number;
        set fillStart(value: number);
        /**
         * @en
         * The fill Range, This will only have any effect if the "type" is set to “Sprite.Type.FILLED”.
         *
         * @zh
         * 填充范围，仅渲染类型设置为 Sprite.Type.FILLED 时有效。
         *
         * @example
         * ```ts
         * // -1 To 1 between the numbers
         * sprite.fillRange = 1;
         * ```
         */
        get fillRange(): number;
        set fillRange(value: number);
        /**
         * @en
         * specify the frame is trimmed or not.
         *
         * @zh
         * 是否使用裁剪模式。
         *
         * @example
         * ```ts
         * sprite.trim = true;
         * ```
         */
        get trim(): boolean;
        set trim(value: boolean);
        /**
         * @en Grayscale mode.
         * @zh 是否以灰度模式渲染。
         */
        get grayscale(): boolean;
        set grayscale(value: boolean);
        /**
         * @en
         * Specify the size tracing mode.
         *
         * @zh
         * 精灵尺寸调整模式。
         *
         * @example
         * ```ts
         * import { Sprite } from 'cc';
         * sprite.sizeMode = Sprite.SizeMode.CUSTOM;
         * ```
         */
        get sizeMode(): __private._cocos_2d_components_sprite__SizeMode;
        set sizeMode(value: __private._cocos_2d_components_sprite__SizeMode);
        /**
         * @en Enum for fill type.
         * @zh 填充类型。
         */
        static FillType: typeof __private._cocos_2d_components_sprite__FillType;
        /**
         * @en Enum for sprite type.
         * @zh Sprite 类型。
         */
        static Type: typeof __private._cocos_2d_components_sprite__SpriteType;
        /**
         * @en Sprite's size mode, including trimmed size, raw size, and none.
         * @zh 精灵尺寸调整模式。
         */
        static SizeMode: typeof __private._cocos_2d_components_sprite__SizeMode;
        /**
         * @en Event types for sprite.
         * @zh sprite 的事件类型。
         */
        static EventType: typeof __private._cocos_2d_components_sprite__SpriteEventType;
        protected _spriteFrame: SpriteFrame | null;
        protected _type: __private._cocos_2d_components_sprite__SpriteType;
        protected _fillType: __private._cocos_2d_components_sprite__FillType;
        protected _sizeMode: __private._cocos_2d_components_sprite__SizeMode;
        protected _fillCenter: math.Vec2;
        protected _fillStart: number;
        protected _fillRange: number;
        protected _isTrimmedMode: boolean;
        protected _useGrayscale: boolean;
        protected _atlas: SpriteAtlas | null;
        __preload(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en
         * Quickly switch to other sprite frame in the sprite atlas.
         * If there is no atlas, the switch fails.
         *
         * @zh
         * 选取使用精灵图集中的其他精灵。
         * @param name @en Name of the spriteFrame to switch. @zh 要切换的 spriteFrame 名字。
         */
        changeSpriteFrameFromAtlas(name: string): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        changeMaterialForDefine(): void;
        protected _updateBuiltinMaterial(): Material;
        protected _render(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        protected _canRender(): boolean;
        protected _flushAssembler(): void;
    }
    /**
     * @en
     * The component of model.
     * When you place particles or models in the UI, you must add this component to render.
     * The component must be placed on a node with the [[MeshRenderer]] or the [[ParticleSystem]].
     *
     * @zh
     * UI 模型基础组件。
     * 当你在 UI 中放置模型或者粒子的时候，必须添加该组件才能渲染。该组件必须放置在带有 [[MeshRenderer]] 或者 [[ParticleSystem]] 组件的节点上。
     * @deprecated This component is not recommended to be used, please use Render Texture instead.
     * See [UIMeshRenderer Reference](https://docs.cocos.com/creator/manual/en/ui-system/components/editor/ui-model.html)
     */
    export class UIMeshRenderer extends Component {
        constructor();
        /**
         * @en Get the model component on this node
         * @zh 获取同节点的 model 组件
         */
        get modelComponent(): ModelRenderer | null;
        protected _renderEntity: __private._cocos_2d_renderer_render_entity__RenderEntity;
        _dirtyVersion: number;
        _internalId: number;
        __preload(): void;
        onEnable(): void;
        onDisable(): void;
        onLoad(): void;
        onDestroy(): void;
        /**
         * @en Render data submission procedure, it update and assemble the render data to 2D data buffers before all children submission process.
         * Usually called each frame when the ui flow assemble all render data to geometry buffers.
         * Don't call it unless you know what you are doing.
         * @zh 渲染数据组装程序，这个方法会在所有子节点数据组装之前更新并组装当前组件的渲染数据到 UI 的顶点数据缓冲区中。
         * 一般在 UI 渲染流程中调用，用于组装所有的渲染数据到顶点数据缓冲区。
         * 注意：不要手动调用该函数，除非你理解整个流程。
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        _render(render: __private._cocos_2d_renderer_i_batcher__IBatcher): boolean;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        fillBuffers(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        updateRenderer(): void;
        /**
         * @en Post render data submission procedure, it's executed after assembler updated for all children.
         * It may assemble some extra render data to the geometry buffers, or it may only change some render states.
         * Don't call it unless you know what you are doing.
         * @zh 后置渲染数据组装程序，它会在所有子节点的渲染数据组装完成后被调用。
         * 它可能会组装额外的渲染数据到顶点数据缓冲区，也可能只是重置一些渲染状态。
         * 注意：不要手动调用该函数，除非你理解整个流程。
         */
        postUpdateAssembler(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        update(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        markForUpdateRenderData(enable?: boolean): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        stencilStage: __private._cocos_2d_renderer_stencil_manager__Stage;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setNodeDirty(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setTextureDirty(): void;
        protected _canRender(): boolean;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get renderEntity(): __private._cocos_2d_renderer_render_entity__RenderEntity;
        protected _renderData: RenderData | null;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get renderData(): RenderData | null;
    }
    /**
     * @en
     * Outline effect used to change the display, only for system fonts or TTF fonts.
     *
     * @zh
     * 描边效果组件,用于字体描边,只能用于系统字体。
     *
     * @deprecated since v3.8.2, please use [[Label.enableOutline]] instead.
     */
    export class LabelOutline extends Component {
        /**
         * @en
         * Outline color.
         *
         * @zh
         * 改变描边的颜色。
         *
         * @deprecated since v3.8.2, please use [[Label.outlineColor]] instead.
         */
        get color(): Readonly<math.Color>;
        set color(value: Readonly<math.Color>);
        /**
         * @en
         * Change the outline width.
         *
         * @zh
         * 改变描边的宽度。
         *
         * @deprecated since v3.8.2, please use [[Label.outlineWidth]] instead.
         */
        get width(): number;
        set width(value: number);
        /**
         * @deprecated since v3.8.2, please use [[Label.enableOutline]] instead.
         */
        onEnable(): void;
        /**
         * @deprecated since v3.8.2, please use [[Label.enableOutline]] instead.
         */
        onDisable(): void;
    }
    /**
     * @en
     * Graphics component.
     *
     * @zh
     * 自定义图形类。
     */
    export class Graphics extends UIRenderer {
        /**
         * @en
         * Current line width.
         *
         * @zh
         * 当前线条宽度。
         */
        get lineWidth(): number;
        set lineWidth(value: number);
        /**
         * @en
         * Determines how two connecting segments (of lines, arcs or curves) with non-zero lengths in a shape are joined together.
         *
         * @zh
         * 用来设置2个长度不为0的相连部分（线段，圆弧，曲线）如何连接在一起的属性。
         */
        get lineJoin(): __private._cocos_2d_assembler_graphics_types__LineJoin;
        set lineJoin(value: __private._cocos_2d_assembler_graphics_types__LineJoin);
        /**
         * @en
         * Determines how the end points of every line are drawn.
         *
         * @zh
         * 指定如何绘制每一条线段末端。
         */
        get lineCap(): __private._cocos_2d_assembler_graphics_types__LineCap;
        set lineCap(value: __private._cocos_2d_assembler_graphics_types__LineCap);
        /**
         * @en
         * Brush stroke color.
         *
         * @zh
         * 笔触的颜色。
         */
        get strokeColor(): Readonly<math.Color>;
        set strokeColor(value: Readonly<math.Color>);
        /**
         * @en
         * Fill paint color.
         *
         * @zh
         * 填充绘画的颜色。
         */
        get fillColor(): Readonly<math.Color>;
        set fillColor(value: Readonly<math.Color>);
        /**
         * @en
         * Set the miter limit ratio.
         *
         * @zh
         * 设置斜接面限制比例。
         */
        get miterLimit(): number;
        set miterLimit(value: number);
        get color(): math.Color;
        set color(value: math.Color);
        static LineJoin: typeof __private._cocos_2d_assembler_graphics_types__LineJoin;
        static LineCap: typeof __private._cocos_2d_assembler_graphics_types__LineCap;
        impl: __private._cocos_2d_assembler_graphics_webgl_impl__Impl | null;
        /**
         * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
         */
        model: renderer.scene.Model | null;
        protected _lineWidth: number;
        protected _strokeColor: math.Color;
        protected _lineJoin: __private._cocos_2d_assembler_graphics_types__LineJoin;
        protected _lineCap: __private._cocos_2d_assembler_graphics_types__LineCap;
        protected _fillColor: math.Color;
        protected _miterLimit: number;
        protected _isDrawing: boolean;
        protected _isNeedUploadData: boolean;
        protected _graphicsNativeProxy: __private._cocos_2d_renderer_native_2d__NativeUIModelProxy;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get graphicsNativeProxy(): __private._cocos_2d_renderer_native_2d__NativeUIModelProxy;
        constructor();
        onRestore(): void;
        onLoad(): void;
        onEnable(): void;
        onDestroy(): void;
        /**
         * @en
         * Move path start point to (x,y).
         *
         * @zh
         * 移动路径起点到坐标(x, y)。
         *
         * @param x @en The x-axis coordinate of the target position.
         *          @zh 目标位置的 X 轴坐标。
         * @param y @en The y-axis coordinate of the target position.
         *          @zh 目标位置的 y 轴坐标。
         */
        moveTo(x: number, y: number): void;
        /**
         * @en
         * Adds a straight line to the path.
         *
         * @zh
         * 绘制直线路径。
         *
         * @param x @en The x-axis coordinate of the target position.
         *          @zh 目标位置的 x 轴坐标。
         * @param y @en The x-axis coordinate of the target position.
         *          @zh 目标位置的 y 轴坐标。
         */
        lineTo(x: number, y: number): void;
        /**
         * @en
         * Adds a cubic Bézier curve to the path.
         *
         * @zh
         * 绘制三次贝赛尔曲线路径。
         *
         * @param c1x @en The x-axis coordinate of the first control point.
         *            @zh 第一个控制点的 x 轴坐标。
         * @param c1y @en The y-axis coordinate of the first control point.
         *            @zh 第一个控制点的 y 轴坐标。
         * @param c2x @en The x-axis coordinate of the second control point.
         *            @zh 第二个控制点的 x 轴坐标。
         * @param c2y @en The y-axis coordinate of the second control point.
         *            @zh 第二个控制点的 y 轴坐标。
         * @param x @en The x-axis coordinate of the last control point.
         *          @zh 最后一个控制点的 x 轴坐标。
         * @param y @en The y-axis coordinate of the last control point.
         *          @zh 最后一个控制点的 y 轴坐标。
         */
        bezierCurveTo(c1x: number, c1y: number, c2x: number, c2y: number, x: number, y: number): void;
        /**
         * @en
         * Adds a quadratic Bézier curve to the path.
         *
         * @zh
         * 绘制二次贝赛尔曲线路径。
         *
         * @param cx @en The x-axis coordinate of the starting control point.
         *           @zh 起始控制点的 x 轴坐标。
         * @param cy @en The y-axis coordinate of the starting control point.
         *           @zh 起始控制点的 y 轴坐标。
         * @param x @en The x-axis coordinates of the endpoint control point.
         *          @zh 终点控制点的 x 轴坐标。
         * @param y @en The y-axis coordinates of the endpoint control point.
         *          @zh 终点控制点的 x 轴坐标。
         */
        quadraticCurveTo(cx: number, cy: number, x: number, y: number): void;
        /**
         * @en
         * Adds an arc to the path which is centered at (cx, cy) position with radius r starting at startAngle
         * and ending at endAngle going in the given direction by counterclockwise (defaulting to false).
         *
         * @zh
         * 绘制圆弧路径。圆弧路径的圆心在 (cx, cy) 位置，半径为 r ，根据 counterclockwise （默认为false）指定的方向从 startAngle 开始绘制，到 endAngle 结束。
         *
         * @param cx @en The coordinate x-axis of the central control point.
         *           @zh 中心控制点的坐标 x 轴。
         * @param cy @en The coordinate y-axis of the central control point.
         *           @zh 中心控制点的坐标 y 轴。
         * @param r @en Angle in Radian.
         *          @zh 圆弧弧度。
         * @param startAngle @en The starting angle in radian, measured clockwise from the positive x-axis.
         *                   @zh 弧度起点，从正 x 轴顺时针方向测量。
         * @param endAngle @en The ending angle in radian, measured clockwise from the positive x-axis.
         *                 @zh 弧度终点，从正 x 轴顺时针方向测量。
         * @param counterclockwise @en If true, draws counterclockwise between the two angles. Default is clockwise.
         *                         @zh 如果为真，在两个角度之间逆时针绘制。默认顺时针。
         */
        arc(cx: number, cy: number, r: number, startAngle: number, endAngle: number, counterclockwise: boolean): void;
        /**
         * @en
         * Adds an ellipse to the path.
         *
         * @zh
         * 绘制椭圆路径。
         *
         * @param cx @en The x-axis coordinates of the center point.
         *           @zh 中心点的 x 轴坐标。
         * @param cy @en The y-axis coordinates of the center point.
         *           @zh 中心点的 y 轴坐标。
         * @param rx @en The radius of the x-axis of the ellipse.
         *           @zh 椭圆 x 轴半径。
         * @param ry @en The radius of the y-axis of the ellipse.
         *           @zh 椭圆 y 轴半径。
         */
        ellipse(cx: number, cy: number, rx: number, ry: number): void;
        /**
         * @en
         * Adds a circle to the path.
         *
         * @zh
         * 绘制圆形路径。
         *
         * @param cx @en The x-axis coordinates of the center point.
         *           @zh 中心点的 x 轴坐标。
         * @param cy @en The y-axis coordinates of the center point.
         *           @zh 中心点的 y 轴坐标。
         * @param r @en Radius.
         *          @zh 圆半径。
         */
        circle(cx: number, cy: number, r: number): void;
        /**
         * @en
         * Adds a rectangle to the path.
         *
         * @zh
         * 绘制矩形路径。
         *
         * @param x @en The x-axis coordinate of the top left point of the rectangle.
         *          @zh 矩形起始 x 轴坐标。
         * @param y @en The y-axis coordinate of the top left point of the rectangle.
         *          @zh 矩形起始 y 轴坐标。
         * @param w @en The width of the rectangle.
         *          @zh 矩形宽度。
         * @param h @en The height of the rectangle.
         *          @zh 矩形高度。
         */
        rect(x: number, y: number, w: number, h: number): void;
        /**
         * @en
         * Adds a round corner rectangle to the path.
         *
         * @zh
         * 绘制圆角矩形路径。
         *
         * @param x @en The x-axis coordinate of the top left point of the rectangle.
         *          @zh 矩形起始 x 轴坐标。
         * @param y @en The y-axis coordinate of the top left point of the rectangle.
         *          @zh 矩形起始 y 轴坐标。
         * @param w @en The width of the rectangle.
         *          @zh 矩形宽度。
         * @param h @en The height of the rectangle.
         *          @zh 矩形高度。
         * @param r @en Radius of rectangular rounded corners.
         *          @zh 矩形圆角半径。
         */
        roundRect(x: number, y: number, w: number, h: number, r: number): void;
        /**
         * @en
         * Draws a filled rectangle.
         *
         * @zh
         * 绘制填充矩形。
         *
         * @param x @en The x-axis coordinate of the top left point of the rectangle.
         *          @zh 矩形起始 x 轴坐标。
         * @param y @en The y-axis coordinate of the top left point of the rectangle.
         *          @zh 矩形起始 y 轴坐标。
         * @param w @en The width of the rectangle.
         *          @zh 矩形宽度。
         * @param h @en The height of the rectangle.
         *          @zh 矩形高度。
         */
        fillRect(x: number, y: number, w: number, h: number): void;
        /**
         * @en
         * Erasing any previously drawn content.
         *
         * @zh
         * 擦除之前绘制的所有内容的方法。
         */
        clear(): void;
        /**
         * @en
         * Causes the point of the pen to move back to the start of the current path.
         * It tries to add a straight line from the current point to the start.
         *
         * @zh
         * 将笔点返回到当前路径起始点的。它尝试从当前点到起始点绘制一条直线。
         */
        close(): void;
        /**
         * @en
         * Strokes the current or given path with the current stroke style.
         *
         * @zh
         * 根据当前的画线样式，绘制当前或已经存在的路径。
         */
        stroke(): void;
        /**
         * @en
         * Fills the current or given path with the current fill style.
         *
         * @zh
         * 根据当前的画线样式，填充当前或已经存在的路径。
         */
        fill(): void;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        activeSubModel(idx: number): void;
        protected _uploadData(): void;
        protected _render(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        protected _flushAssembler(): void;
        protected _canRender(): boolean;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        updateRenderer(): void;
        protected createRenderEntity(): __private._cocos_2d_renderer_render_entity__RenderEntity;
    }
    /**
     * @en
     * Static batch component of UI.
     * This component is placed on the root node of all node objects that need to be batch.
     * Only sprites and label participate in the batch.
     * Static batch must be enabled manually, otherwise dynamic batch is still used.
     * Note: Do not place mask, Graphics, and objects such as UI models or particles under child nodes,
     * otherwise rendering will be skipped after static batching is enabled.
     *
     * @zh
     * UI 静态合批组件。
     * 该组件放在所有需要被静态合批的节点对象的根节点上，子节点放置对象必须是精灵和文本，其余对象不参与静态合批。
     * 用户必须通过手动方式启用收集静态合批数据[[markAsDirty]]，否则合批方式仍然采用动态合批（采集数据的流程相同）。此后渲染的内容是采用收集到的合批渲染数据，子节点的任何修改将不再有效。
     * 注意：子节点下不要放置 Mask，Graphics，以及 UI 模型或者粒子之类对象，否则会在启用完静态合批后跳过渲染。
     *
     * @deprecated Since v3.4.1, We have adopted a new rendering batching policy in v3.4.1,
     * which will result in an effective performance improvement for normal dynamic batching components,
     * so manual management with the UIStaticBatch component is no longer recommended and will be removed in the future
     */
    export class UIStaticBatch extends UIRenderer {
        constructor();
        get color(): Readonly<math.Color>;
        set color(value: Readonly<math.Color>);
        get drawBatchList(): __private._cocos_2d_renderer_draw_batch__DrawBatch2D[];
        protected _init: boolean;
        protected _bufferAccessor: __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor | null;
        protected _dirty: boolean;
        postUpdateAssembler(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        /**
         * @en
         * Recollect data tags.
         * The render data will be recollected during the render phase of the current frame, and the next frame will be rendered using fixed data.
         * Note: 尽量不要频繁调用此接口, 会有一定内存损耗.
         *
         * @zh
         * 重新采集数据标记，会在当前帧的渲染阶段重新采集渲染数据，下一帧开始将会使用固定数据进行渲染。
         * 注意：尽量不要频繁调用此接口，因为会清空原先存储的 ia 数据重新采集，会有一定内存损耗。
         */
        markAsDirty(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _requireDrawBatch(): __private._cocos_2d_renderer_draw_batch__DrawBatch2D;
        protected _clearData(): void;
        protected _getBatcher(): UI | null;
    }
    /**
     * @en Shadow effect for Label component, only for system fonts or TTF fonts.
     * @zh 用于给 Label 组件添加阴影效果，只能用于系统字体或 ttf 字体。
     *
     * @deprecated since v3.8.2, please use [[Label.enableShadow]] instead.
     */
    export class LabelShadow extends Component {
        /**
         * @en
         * Shadow color.
         *
         * @zh
         * 阴影的颜色。
         *
         * @deprecated since v3.8.2, please use [[Label.shadowColor]] instead.
         */
        get color(): Readonly<math.Color>;
        set color(value: Readonly<math.Color>);
        /**
         * @en
         * Offset between font and shadow.
         *
         * @zh
         * 字体与阴影的偏移。
         *
         * @deprecated since v3.8.2, please use [[Label.shadowOffset]] instead.
         */
        get offset(): math.Vec2;
        set offset(value: math.Vec2);
        /**
         * @en
         * A non-negative float specifying the level of shadow blur.
         *
         * @zh
         * 阴影的模糊程度。
         *
         * @deprecated since v3.8.2, please use [[Label.shadowBlur]] instead.
         */
        get blur(): number;
        set blur(value: number);
        /**
         * @deprecated since v3.8.2, please use [[Label.enableShadow]] instead.
         */
        onEnable(): void;
        /**
         * @deprecated since v3.8.2, please use [[Label.enableShadow]] instead.
         */
        onDisable(): void;
    }
    /**
     * @en
     * Set the UI transparency component.
     * This component can be used to influence subsequent render nodes.
     * Nodes that already have a rendering component can modify the alpha channel of color directly.
     *
     * @zh
     * UI 透明度设置组件。可以通过该组件设置透明度来影响后续的渲染节点。已经带有渲染组件的节点可以直接修改 color 的 alpha 通道。
     */
    export class UIOpacity extends Component {
        constructor();
        /**
         * @en
         * The transparency value of the impact.
         *
         * @zh
         * 透明度。
         */
        get opacity(): number;
        set opacity(value: number);
        /**
         * @en
         * Recursively sets localopacity.
         *
         * @zh
         * 递归设置localopacity。
         *
         * @param node @en recursive node.
         *             @zh 递归的节点。
         * @param dirty @en Is the color dirty.
         *              @zh color是否dirty。
         * @param parentOpacity @en The parent node's opacity.
         *                      @zh 父节点的opacity。
         * @param stopRecursiveIfHasOpacity @en Stop recursion if UiOpacity component exists.
         *                                  @zh 如果存在UiOpacity组件则停止递归。
         */
        static setEntityLocalOpacityDirtyRecursively(node: Node, dirty: boolean, parentOpacity: number, stopRecursiveIfHasOpacity: boolean): void;
        protected _opacity: number;
        protected _getParentOpacity(node: Node): number;
        protected _parentChanged(): void;
        protected _setEntityLocalOpacityRecursively(opacity: number): void;
        onEnable(): void;
        onDisable(): void;
    }
    /**
     * @en Enum for horizontal text alignment.
     *
     * @zh 文本横向对齐类型。
     */
    export enum HorizontalTextAlignment {
        /**
         * @en Alignment left for text.
         *
         * @zh 左对齐。
         */
        LEFT = 0,
        /**
         * @en Alignment center for text.
         *
         * @zh 中心对齐。
         */
        CENTER = 1,
        /**
         * @en Alignment right for text.
         *
         * @zh 右对齐。
         */
        RIGHT = 2
    }
    /**
     * @en Enum for vertical text alignment.
     *
     * @zh 文本垂直对齐类型。
     */
    export enum VerticalTextAlignment {
        /**
         * @en Alignment top for text.
         *
         * @zh 上对齐。
         */
        TOP = 0,
        /**
         * @en Alignment center for text.
         *
         * @zh 中心对齐。
         */
        CENTER = 1,
        /**
         * @en Alignment bottom for text.
         *
         * @zh 下对齐。
         */
        BOTTOM = 2
    }
    /**
     * @en Enum for Overflow.
     *
     * @zh 文本溢出行为类型。
     */
    export enum Overflow {
        /**
         * @en None.
         *
         * @zh 不做任何限制。
         */
        NONE = 0,
        /**
         * @en In CLAMP mode, when label content goes out of the bounding box, it will be clipped.
         *
         * @zh CLAMP 模式中，当文本内容超出边界框时，多余的会被截断。
         */
        CLAMP = 1,
        /**
         * @en In SHRINK mode, the font size will change dynamically to adapt the content size.
         * This mode may takes up more CPU resources when the label is refreshed.
         *
         * @zh SHRINK 模式，字体大小会动态变化，以适应内容大小。这个模式在文本刷新的时候可能会占用较多 CPU 资源。
         */
        SHRINK = 2,
        /**
         * @en In RESIZE_HEIGHT mode, you can only change the width of label and the height is changed automatically.
         *
         * @zh 在 RESIZE_HEIGHT 模式下，只能更改文本的宽度，高度是自动改变的。
         */
        RESIZE_HEIGHT = 3
    }
    /**
     * @en Enum for cache mode.
     *
     * @zh 文本图集缓存类型。
     */
    export enum CacheMode {
        /**
         * @en Do not do any caching.
         *
         * @zh 不做任何缓存。
         */
        NONE = 0,
        /**
         * @en In BITMAP mode, cache the label as a static image and add it to the dynamic atlas for batch rendering,
         * and can batching with Sprites using broken images.
         *
         * @zh BITMAP 模式，将 label 缓存成静态图像并加入到动态图集，以便进行批次合并，可与使用碎图的 Sprite 进行合批。
         * （注：动态图集在 Chrome 以及微信小游戏暂时关闭，该功能无效）。
         */
        BITMAP = 1,
        /**
         * @en In CHAR mode, split text into characters and cache characters into a dynamic atlas which the size of 1024 * 1024.
         *
         * @zh CHAR 模式，将文本拆分为字符，并将字符缓存到一张单独的大小为 1024 * 1024 的图集中进行重复使用，不再使用动态图集。
         * （注：当图集满时将不再进行缓存，暂时不支持 SHRINK 自适应文本尺寸（后续完善））。
         */
        CHAR = 2
    }
    /**
     * @en
     * The Label Component.
     *
     * @zh
     * 文字标签组件。
     */
    export class Label extends UIRenderer {
        /**
         * @en Enum for horizontal text alignment.
         *
         * @zh 文本横向对齐类型。
         */
        static HorizontalAlign: typeof HorizontalTextAlignment;
        /**
         * @en Enum for vertical text alignment.
         *
         * @zh 文本垂直对齐类型。
         */
        static VerticalAlign: typeof VerticalTextAlignment;
        /**
         * @en Enum for label overflow mode.
         *
         * @zh 文本溢出行为类型。
         */
        static Overflow: typeof Overflow;
        /**
         * @en Enum for cache mode.
         *
         * @zh 文本图集缓存类型。
         */
        static CacheMode: typeof CacheMode;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        static _canvasPool: __private._cocos_2d_assembler_label_font_utils__CanvasPool;
        /**
         * @en
         * Content string of label.
         *
         * @zh
         * 标签显示的文本内容。
         */
        get string(): string;
        set string(value: string);
        /**
         * @en
         * Horizontal Alignment of label.
         *
         * @zh
         * 文本内容的水平对齐方式。
         */
        get horizontalAlign(): HorizontalTextAlignment;
        set horizontalAlign(value: HorizontalTextAlignment);
        /**
         * @en
         * Vertical Alignment of label.
         *
         * @zh
         * 文本内容的垂直对齐方式。
         */
        get verticalAlign(): VerticalTextAlignment;
        set verticalAlign(value: VerticalTextAlignment);
        /**
         * @en
         * The actual rendering font size in shrink mode.
         *
         * @zh
         * SHRINK 模式下面文本实际渲染的字体大小。
         */
        get actualFontSize(): number;
        set actualFontSize(value: number);
        /**
         * @en
         * Font size of label.
         *
         * @zh
         * 文本字体大小。
         */
        get fontSize(): number;
        set fontSize(value: number);
        /**
         * @en
         * Line Height of label.
         *
         * @zh
         * 文本行高。
         */
        get lineHeight(): number;
        set lineHeight(value: number);
        /**
         * @en
         * The spacing between text characters, only available in BMFont.
         *
         * @zh
         * 文本字符之间的间距。仅在使用 BMFont 位图字体时生效。
         */
        get spacingX(): number;
        set spacingX(value: number);
        /**
         * @en
         * Overflow of label.
         *
         * @zh
         * 文字显示超出范围时的处理方式。
         */
        get overflow(): Overflow;
        set overflow(value: Overflow);
        /**
         * @en
         * Whether auto wrap label when string width is large than label width.
         *
         * @zh
         * 是否自动换行。
         */
        get enableWrapText(): boolean;
        set enableWrapText(value: boolean);
        /**
         * @en
         * Whether use system font name or not.
         *
         * @zh
         * 是否使用系统字体。
         */
        get useSystemFont(): boolean;
        set useSystemFont(value: boolean);
        /**
         * @en
         * Font family of label, only take effect when useSystemFont property is true.
         *
         * @zh
         * 文本字体名称, 只在 useSystemFont 属性为 true 的时候生效。
         */
        get fontFamily(): string;
        set fontFamily(value: string);
        /**
         * @en
         * The font of label.
         *
         * @zh
         * 文本字体。
         */
        get font(): Font | null;
        set font(value: Font | null);
        /**
         * @en
         * The cache mode of label. This mode only supports system fonts.
         *
         * @zh
         * 文本缓存模式, 该模式只支持系统字体。
         */
        get cacheMode(): CacheMode;
        set cacheMode(value: CacheMode);
        /**
         * @en
         * Whether the font is bold.
         *
         * @zh
         * 字体是否加粗。
         */
        get isBold(): boolean;
        set isBold(value: boolean);
        /**
         * @en
         * Whether the font is italic.
         *
         * @zh
         * 字体是否倾斜。
         */
        get isItalic(): boolean;
        set isItalic(value: boolean);
        /**
         * @en
         * Whether the font is underline.
         *
         * @zh
         * 字体是否加下划线。
         */
        get isUnderline(): boolean;
        set isUnderline(value: boolean);
        /**
         * @en The height of underline.
         * @zh 下划线高度。
         */
        get underlineHeight(): number;
        set underlineHeight(value: number);
        /**
         ** @en
         ** Outline effect used to change the display, only for system fonts or TTF fonts.
         **
         ** @zh
         ** 描边效果组件,用于字体描边,只能用于系统字体或 ttf 字体。
         **/
        get enableOutline(): boolean;
        set enableOutline(value: boolean);
        /**
         * @en
         * Outline color.
         *
         * @zh
         * 改变描边的颜色。
         */
        get outlineColor(): math.Color;
        set outlineColor(value: Readonly<math.Color>);
        /**
         * @en
         * Change the outline width.
         *
         * @zh
         * 改变描边的宽度。
         */
        get outlineWidth(): number;
        set outlineWidth(value: number);
        /**
         * @en Shadow effect for Label component, only for system fonts or TTF fonts. Disabled when cache mode is char.
         * @zh 用于给 Label 组件添加阴影效果，只能用于系统字体或 ttf 字体。在缓存模式为 char 时不可用。
         */
        get enableShadow(): boolean;
        set enableShadow(value: boolean);
        /**
         * @en
         * Shadow color.
         *
         * @zh
         * 阴影的颜色。
         */
        get shadowColor(): math.Color;
        set shadowColor(value: Readonly<math.Color>);
        /**
         * @en
         * Offset between font and shadow.
         *
         * @zh
         * 字体与阴影的偏移。
         */
        get shadowOffset(): math.Vec2;
        set shadowOffset(value: math.Vec2);
        /**
         * @en
         * A non-negative float specifying the level of shadow blur.
         *
         * @zh
         * 阴影的模糊程度。
         */
        get shadowBlur(): number;
        set shadowBlur(value: number);
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get spriteFrame(): SpriteFrame | __private._cocos_2d_assembler_label_font_utils__LetterRenderTexture | null;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get ttfSpriteFrame(): SpriteFrame | null;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get assemblerData(): __private._cocos_2d_assembler_label_font_utils__ISharedLabelData | null;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get fontAtlas(): __private._cocos_2d_assets_bitmap_font__FontAtlas | null;
        set fontAtlas(value: __private._cocos_2d_assets_bitmap_font__FontAtlas | null);
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _bmFontOriginalSize(): number;
        protected _string: string;
        protected _horizontalAlign: HorizontalTextAlignment;
        protected _verticalAlign: VerticalTextAlignment;
        protected _actualFontSize: number;
        protected _fontSize: number;
        protected _fontFamily: string;
        protected _lineHeight: number;
        protected _overflow: Overflow;
        protected _enableWrapText: boolean;
        protected _font: Font | null;
        protected _isSystemFontUsed: boolean;
        protected _spacingX: number;
        protected _isItalic: boolean;
        protected _isBold: boolean;
        protected _isUnderline: boolean;
        protected _underlineHeight: number;
        protected _cacheMode: CacheMode;
        protected _enableOutline: boolean;
        protected _outlineColor: math.Color;
        protected _outlineWidth: number;
        protected _enableShadow: boolean;
        protected _shadowColor: math.Color;
        protected _shadowOffset: math.Vec2;
        protected _shadowBlur: number;
        protected _N$file: Font | null;
        protected _texture: SpriteFrame | __private._cocos_2d_assembler_label_font_utils__LetterRenderTexture | null;
        protected _ttfSpriteFrame: SpriteFrame | null;
        protected _userDefinedFont: Font | null;
        protected _assemblerData: __private._cocos_2d_assembler_label_font_utils__ISharedLabelData | null;
        protected _fontAtlas: __private._cocos_2d_assets_bitmap_font__FontAtlas | null;
        protected _letterTexture: __private._cocos_2d_assembler_label_font_utils__LetterRenderTexture | null;
        protected _contentWidth: number;
        protected _textStyle: __private._cocos_2d_assembler_label_text_style__TextStyle | null;
        protected _textLayout: __private._cocos_2d_assembler_label_text_layout__TextLayout | null;
        protected _textRenderData: __private._cocos_2d_assembler_label_text_output_data__TextOutputRenderData | null;
        protected _textLayoutData: __private._cocos_2d_assembler_label_text_output_data__TextOutputLayoutData | null;
        constructor();
        onEnable(): void;
        _onPreDestroy(): void;
        onDestroy(): void;
        /**
         * @en update render data.
         * @zh 更新渲染相关数据。
         * @param force @en Whether to force an immediate update. @zh 是否立马强制更新渲染数据。
         */
        updateRenderData(force?: boolean): void;
        protected _render(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        protected _updateColor(): void;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setEntityColor(color: math.Color): void;
        protected _canRender(): boolean;
        protected _flushAssembler(): void;
        protected _applyFontTexture(): void;
        protected changeMaterialForDefine(): void;
    }
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export interface IRenderData {
        x: number;
        y: number;
        z: number;
        u: number;
        v: number;
        color: math.Color;
    }
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export class BaseRenderData {
        get vertexCount(): number;
        get indexCount(): number;
        get stride(): number;
        get floatStride(): number;
        get vertexFormat(): gfx.Attribute[];
        get drawInfoType(): __private._cocos_2d_renderer_render_draw_info__RenderDrawInfoType;
        set drawInfoType(type: __private._cocos_2d_renderer_render_draw_info__RenderDrawInfoType);
        chunk: __private._cocos_2d_renderer_static_vb_accessor__StaticVBChunk;
        protected _renderDrawInfo: __private._cocos_2d_renderer_render_draw_info__RenderDrawInfo;
        get renderDrawInfo(): __private._cocos_2d_renderer_render_draw_info__RenderDrawInfo;
        protected _material: Material | null;
        get material(): Material | null;
        set material(val: Material | null);
        protected _dataHash: number;
        get dataHash(): number;
        set dataHash(val: number);
        _isMeshBuffer: boolean;
        protected _vc: number;
        protected _ic: number;
        protected _floatStride: number;
        protected _vertexFormat: gfx.Attribute[];
        protected _drawInfoType: __private._cocos_2d_renderer_render_draw_info__RenderDrawInfoType;
        protected _multiOwner: boolean;
        get multiOwner(): boolean;
        set multiOwner(val: boolean);
        protected _batcher: UI | null;
        get batcher(): UI;
        constructor(vertexFormat?: gfx.Attribute[]);
        isValid(): false | __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor;
        initRenderDrawInfo(comp: UIRenderer, drawInfoType?: __private._cocos_2d_renderer_render_draw_info__RenderDrawInfoType): void;
        removeRenderDrawInfo(comp: UIRenderer): void;
        protected setRenderDrawInfoAttributes(): void;
    }
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export class RenderData extends BaseRenderData {
        static add(vertexFormat?: gfx.Attribute[], accessor?: __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor | null): RenderData;
        static remove(data: RenderData): void;
        get dataLength(): number;
        set dataLength(length: number);
        get data(): IRenderData[];
        _vertDirty: boolean;
        get vertDirty(): boolean;
        set vertDirty(val: boolean);
        protected _textureHash: number;
        get textureHash(): number;
        set textureHash(val: number);
        indices: Uint16Array | null;
        set frame(val: SpriteFrame | __private._cocos_asset_assets_texture_base__TextureBase | null);
        get frame(): SpriteFrame | __private._cocos_asset_assets_texture_base__TextureBase | null;
        layer: number;
        nodeDirty: boolean;
        passDirty: boolean;
        textureDirty: boolean;
        hashDirty: boolean;
        protected _accessor: __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor;
        get accessor(): __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor;
        vertexRow: number;
        vertexCol: number;
        constructor(vertexFormat?: gfx.Attribute[], accessor?: __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor | null);
        resize(vertexCount: number, indexCount: number): void;
        protected setRenderDrawInfoAttributes(): void;
        /**
         * @internal
         */
        fillDrawInfoAttributes(drawInfo: __private._cocos_2d_renderer_render_draw_info__RenderDrawInfo): void;
        protected syncRender2dBuffer(): void;
        resizeAndCopy(vertexCount: number, indexCount: number): void;
        getMeshBuffer(): MeshBuffer | null;
        updateNode(comp: UIRenderer): void;
        updatePass(comp: UIRenderer): void;
        updateTexture(frame: SpriteFrame | __private._cocos_asset_assets_texture_base__TextureBase): void;
        updateHash(): void;
        updateRenderData(comp: UIRenderer, frame: SpriteFrame | __private._cocos_asset_assets_texture_base__TextureBase): void;
        clear(): void;
        static createStaticVBAccessor(attributes: gfx.Attribute[], vCount?: number, iCount?: number): __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor;
    }
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export class MeshRenderData extends BaseRenderData {
        static add(vertexFormat?: gfx.Attribute[]): MeshRenderData;
        static remove(data: MeshRenderData): void;
        /**
         * @deprecated
         */
        set formatByte(value: number);
        get formatByte(): number;
        get floatStride(): number;
        /**
         * Index of Float32Array: vData
         */
        get vDataOffset(): number;
        _isMeshBuffer: boolean;
        vData: Float32Array;
        iData: Uint16Array;
        /**
         * First vertex used in the current IA
         */
        vertexStart: number;
        /**
         * Vertex count used in the current IA
         */
        vertexRange: number;
        /**
         * First index used in the current IA
         */
        indexStart: number;
        /**
         * Index count used in the current IA
         */
        indexRange: number;
        lastFilledIndex: number;
        lastFilledVertex: number;
        frame: SpriteFrame | null;
        constructor(vertexFormat?: gfx.Attribute[]);
        request(vertexCount: number, indexCount: number): boolean;
        reserve(vertexCount: number, indexCount: number): boolean;
        resize(vertexCount: number, indexCount: number): void;
        updateRange(vertOffset: number, vertexCount: number, indexOffset: number, indexCount: number): void;
        requestIA(device: gfx.Device): gfx.InputAssembler;
        uploadBuffers(): void;
        freeIAPool(): void;
        reset(): void;
        clear(): void;
        protected _initIAInfo(device: gfx.Device): void;
        protected _reallocBuffer(vCount: number, iCount: number): void;
        setRenderDrawInfoAttributes(): void;
        particleInitRenderDrawInfo(entity: __private._cocos_2d_renderer_render_entity__RenderEntity): void;
    }
    /**
     * @internal
     */
    export interface IAssembler {
        [key: string]: any;
    }
    /**
     * @internal
     */
    export interface IAssemblerManager {
        getAssembler(component: UIRenderer): IAssembler;
    }
    export namespace UIVertexFormat {
        /**
         * @en Get total components count for all attributes per vertex.
         * @zh 获取每个顶点上所有属性的分量数总和
         * @param attrs All attributes of the vertex format
         * @returns Total components count
         */
        export function getComponentPerVertex(attrs: gfx.Attribute[]): number;
        /**
         * @en Get total stride for all attributes per vertex.
         * @zh 获取每个顶点上所有属性的总步进
         * @param attrs All attributes of the vertex format
         * @returns Total stride
         */
        export function getAttributeStride(attrs: gfx.Attribute[]): number;
        /**
         * @en Vertex format with vector 3 position attribute
         * @zh 包含三维位置属性的顶点格式
         */
        export const vfmt: gfx.Attribute[];
        /**
         * @en Vertex format with the following layout.
         * 1. Vector 3 position attribute (Float32)
         * 2. Vector 4 color attribute (Float32)
         * @zh 包含以下数据的顶点格式
         * 1. 三维位置属性（Float32）
         * 2. RGBA 颜色属性（Float32）
         */
        export const vfmtPosColor: gfx.Attribute[];
        /**
         * @en Vertex format with the following layout
         * 1. Vector 3 position attribute (Float32)
         * 2. Vector 2 uv attribute (Float32)
         * 3. Vector 4 color attribute (Float32)
         * @zh 包含以下数据的顶点格式
         * 1. 三维位置属性（Float32）
         * 2. 二维贴图 UV 属性（Float32）
         * 3. RGBA 颜色属性（Float32）
         */
        export const vfmtPosUvColor: gfx.Attribute[];
        /**
         * @en Vertex format with the following layout
         * 1. Vector 3 position attribute (Float32)
         * 2. Vector 2 uv attribute (Float32)
         * 3. Byte 4 color attribute (Byte)
         * @zh 包含以下数据的顶点格式
         * 1. 三维位置属性（Float32）
         * 2. 二维贴图 UV 属性（Float32）
         * 3. RGBA 颜色属性（Byte）
         */
        export const vfmtPosUvColor4B: gfx.Attribute[];
        /**
         * @en Vertex format with the following layout
         * 1. Vector 3 position attribute (Float32)
         * 2. Vector 2 uv attribute (Float32)
         * 3. First vector 4 color attribute (Float32)
         * 4. Second vector 4 color attribute (Float32)
         * @zh 包含以下数据的顶点格式
         * 1. 三维位置属性（Float32）
         * 2. 二维贴图 UV 属性（Float32）
         * 3. 第一套 RGBA 颜色属性（Float32）
         * 4. 第二套 RGBA 颜色属性（Float32）
         */
        export const vfmtPosUvTwoColor: gfx.Attribute[];
        /**
         * @en Vertex format with the following layout
         * 1. Vector 3 position attribute (Float32)
         * 2. Vector 2 uv attribute (Float32)
         * 3. First byte 4 color attribute (Byte)
         * 4. Second byte 4 color attribute (Byte)
         * @zh 包含以下数据的顶点格式
         * 1. 三维位置属性（Float32）
         * 2. 二维贴图 UV 属性（Float32）
         * 3. 第一套 RGBA 颜色属性（Byte）
         * 4. 第二套 RGBA 颜色属性（Byte）
         */
        export const vfmtPosUvTwoColor4B: gfx.Attribute[];
    }
    /**
     * @en UI rendering process
     * @zh UI 渲染流程
     */
    export class UI implements __private._cocos_2d_renderer_i_batcher__IBatcher {
        protected _nativeObj: __private._cocos_2d_renderer_native_2d__NativeBatcher2d;
        get nativeObj(): __private._cocos_2d_renderer_native_2d__NativeBatcher2d;
        get currBufferAccessor(): __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor;
        get batches(): memop.CachedArray<__private._cocos_2d_renderer_draw_batch__DrawBatch2D>;
        set currStaticRoot(value: UIStaticBatch | null);
        set currIsStatic(value: boolean);
        device: gfx.Device;
        constructor(_root: Root);
        initialize(): boolean;
        destroy(): void;
        /**
         * @en
         * Add the managed Canvas.
         *
         * @zh
         * 添加屏幕组件管理。
         *
         * @param comp @en The render root of 2d.
         *             @zh 2d 渲染入口组件。
         */
        addScreen(comp: RenderRoot2D): void;
        /**
         * @zh
         * Removes the Canvas from the list.
         *
         * @param comp @en The target to removed.
         *             @zh 被移除的屏幕。
         */
        removeScreen(comp: RenderRoot2D): void;
        sortScreens(): void;
        getFirstRenderCamera(node: Node): renderer.scene.Camera | null;
        update(): void;
        uploadBuffers(): void;
        reset(): void;
        /**
         * @zh 如果有必要，为相应的顶点布局切换网格缓冲区。
         * @en Switch the mesh buffer for corresponding vertex layout if necessary.
         * @param attributes use VertexFormat.vfmtPosUvColor by default
         */
        switchBufferAccessor(attributes?: gfx.Attribute[]): __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor;
        registerBufferAccessor(key: number, accessor: __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor): void;
        updateBuffer(attributes: gfx.Attribute[], bid: number): void;
        /**
         * @en
         * Render component data submission process of UI.
         * The submitted vertex data is the UI for world coordinates.
         * For example: The UI components except Graphics and UIModel.
         *
         * @zh
         * UI 渲染组件数据提交流程（针对提交的顶点数据是世界坐标的提交流程，例如：除 Graphics 和 UIModel 的大部分 ui 组件）。
         * 此处的数据最终会生成需要提交渲染的 model 数据。
         *
         * @param comp - The committed renderable component
         * @param renderData - The render data being committed
         * @param frame - Texture or sprite frame related to the draw batch, could be null
         * @param assembler - The assembler for the current component, could be null
         * @param transform - Node type transform, if passed, then batcher will consider it's using model matrix, could be null
         */
        commitComp(comp: UIRenderer, renderData: BaseRenderData | null, frame: __private._cocos_asset_assets_texture_base__TextureBase | SpriteFrame | null, assembler: IAssembler, transform: Node | null): void;
        /**
         * @en
         * Render component data submission process for individual [[gfx.InputAssembler]]
         * @zh
         * 渲染组件中针对独立 [[gfx.InputAssembler]] 的提交流程
         * 例如：Spine 和 DragonBones 等包含动态数据和材质的组件在内部管理 IA 并提交批次
         * @param comp - The committed renderable component
         * @param ia - The committed [[gfx.InputAssembler]]
         * @param tex - The texture used
         * @param mat - The material used
         * @param [transform] - The related node transform if the render data is based on node's local coordinates
         * @deprecated since v3.6.2, please use [[commitMiddleware]] instead
         */
        commitIA(renderComp: UIRenderer, ia: gfx.InputAssembler, tex?: __private._cocos_asset_assets_texture_base__TextureBase, mat?: Material, transform?: Node): void;
        /**
         * @en
         * Render component data submission process for middleware2d components
         * @zh
         * 渲染组件中针对2D中间件组件渲染数据的提交流程
         * 例如：Spine 和 DragonBones 包含动态数据和材质的组件
         * @param comp - The committed renderable component
         * @param meshBuffer - The MeshBuffer used
         * @param indexOffset - indices offset
         * @param indexCount - indices count
         * @param tex - The texture used
         * @param mat - The material used
         * @param enableBatch - component support multi draw batch or not
         */
        commitMiddleware(comp: UIRenderer, meshBuffer: MeshBuffer, indexOffset: number, indexCount: number, tex: __private._cocos_asset_assets_texture_base__TextureBase, mat: Material, enableBatch: boolean): void;
        /**
         * @en
         * Render component data submission process of UI.
         * The submitted vertex data is the UI for local coordinates.
         * For example: The UI components of Graphics and UIModel.
         *
         * @zh
         * UI 渲染组件数据提交流程（针对例如： Graphics 和 UIModel 等数据量较为庞大的 ui 组件）。
         *
         * @param comp - The committed renderable component
         * @param model - The committed model
         * @param mat - The material used, could be null
         */
        commitModel(comp: UIMeshRenderer | UIRenderer, model: renderer.scene.Model | null, mat: Material | null): void;
        setupStaticBatch(staticComp: UIStaticBatch, bufferAccessor: __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor): void;
        endStaticBatch(): void;
        /**
         * @en
         * Submit separate render data.
         * This data does not participate in the batch.
         *
         * @zh
         * 提交独立渲染数据.
         * @param comp @en The UIStaticBatch component.
         *             @zh 静态组件
         */
        commitStaticBatch(comp: UIStaticBatch): void;
        /**
         * @en
         * End a section of render data and submit according to the batch condition.
         *
         * @zh
         * 根据合批条件，结束一段渲染数据并提交。
         */
        autoMergeBatches(renderComp?: UIRenderer): void;
        /**
         * @en
         * Force changes to current batch data and merge
         *
         * @zh
         * 强行修改当前批次数据并合并。
         *
         * @param material @en The material of the current batch.
         *                 @zh 当前批次的材质。
         * @param sprite @en Sprite frame of current batch.
         *               @zh 当前批次的精灵帧。
         */
        forceMergeBatches(material: Material, frame: __private._cocos_asset_assets_texture_base__TextureBase | SpriteFrame | null, renderComp: UIRenderer): void;
        resetRenderStates(): void;
        /**
         * @en
         * Forced to merge the data of the previous batch to start a new batch.
         *
         * @zh
         * 强制合并上一个批次的数据，开启新一轮合批。
         */
        finishMergeBatches(): void;
        /**
         * @en
         * Force to change the current material.
         *
         * @zh
         * 强制刷新材质。
         */
        flushMaterial(mat: Material): void;
        walk(node: Node, level?: number): void;
        syncMeshBuffersToNative(accId: number, buffers: MeshBuffer[]): void;
    }
    /**
     * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
     * @internal
     */
    export class UIDrawBatch extends __private._cocos_2d_renderer_draw_batch__DrawBatch2D {
    }
    export class QuadRenderData extends MeshRenderData {
        constructor(vertexFormat: gfx.Attribute[]);
    }
    export class Atlas {
        constructor(width: number, height: number);
        /**
         * @en
         * Append a sprite frame into the dynamic atlas.
         *
         * @zh
         * 添加碎图进入动态图集。
         *
         * @method insertSpriteFrame
         * @param spriteFrame  the sprite frame that will be inserted in the atlas.
         */
        insertSpriteFrame(spriteFrame: SpriteFrame): {
            x: number;
            y: number;
            texture: __private._cocos_2d_utils_dynamic_atlas_atlas__DynamicAtlasTexture;
        } | null;
        removeSpriteFrame(spriteFrame: SpriteFrame): void;
        /**
         * @en
         * Delete a texture from the atlas.
         *
         * @zh
         * 从动态图集中删除某张纹理。
         *
         * @method deleteAtlasTexture
         * @param texture  the texture that will be removed from the atlas.
         */
        deleteInnerTexture(texture: Texture2D): void;
        /**
         * @en
         * Whether the atlas is empty.
         *
         * @zh
         * 图集是否为空图集。
         *
         * @method isEmpty
         */
        isEmpty(): boolean;
        /**
         * @en
         * Reset the dynamic atlas.
         *
         * @zh
         * 重置该动态图集。
         *
         * @method reset
         */
        reset(): void;
        /**
         * @en
         * Reset the dynamic atlas, and destroy the texture of the atlas.
         *
         * @zh
         * 重置该动态图集，并销毁该图集的纹理。
         *
         * @method destroy
         */
        destroy(): void;
    }
    /**
     * @en A utils class for parsing HTML texts. The parsed results will be an object array.
     * @zh 一个用于解析HTML文本的工具类。解析后的结果将是一个对象数组。
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export interface IHtmlTextParserResultObj {
        text?: string;
        style?: IHtmlTextParserStack;
    }
    /**
     * @en Html Text Parser Stack interface
     * @zh Html 文本解析器接口
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export interface IHtmlTextParserStack {
        color?: string;
        size?: number;
        event?: {
            [k: string]: string;
        };
        isNewLine?: boolean;
        isImage?: boolean;
        src?: string;
        imageWidth?: number;
        imageHeight?: number;
        imageOffset?: string;
        imageAlign?: string;
        underline?: boolean;
        italic?: boolean;
        bold?: boolean;
        outline?: {
            color: string;
            width: number;
        };
    }
    /**
     * @en Html Text Parser Stack
     * @zh Html 文本解析器
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export class HtmlTextParser {
        constructor();
        parse(htmlString: string): IHtmlTextParserResultObj[];
    }
    export function getBaselineOffset(): number;
    /**
     * @deprecated since v3.7.2, this is an engine private interface that will be removed in the future.
     */
    export function isUnicodeCJK(ch: string): boolean;
    /**
     * @deprecated since v3.7.2, this is an engine private interface that will be removed in the future.
     */
    export function isUnicodeSpace(ch: string): boolean;
    /**
     * @deprecated since v3.7.2, this is an engine private interface that will be removed in the future.
     */
    export function safeMeasureText(ctx: CanvasRenderingContext2D, string: string, desc?: string): number;
    export function getSymbolLength(str: string): number;
    export function getSymbolAt(str: string, index: number): string;
    export function getSymbolCodeAt(str: string, index: number): string;
    /**
     * @deprecated since v3.7.2, this is an engine private interface that will be removed in the future.
     */
    export function fragmentText(stringToken: string, allWidth: number, maxWidth: number, measureText: (string: string) => number): string[];
    export const BASELINE_RATIO = 0.26;
    export const MIDDLE_RATIO: number;
    export class LRUCache {
        constructor(size: any);
        moveToHead(node: any): void;
        put(key: any, value: any): void;
        remove(node: any): void;
        get(key: any): number | null;
        clear(): void;
        has(key: any): boolean;
        delete(key: any): void;
    }
    /**
     * @en The dynamic atlas manager which manages all runtime dynamic packed atlas texture for UI rendering.
     * It generates a maximum of [[maxAtlasCount]] atlas texture, all atlas texture have the size of [[textureSize]].
     * Normally the [[Root.batcher2D]] is in charge of submitting sprite frames to the dynamic atlas manager, the process is transparent to user.
     * Note that the first committed sprite frame will define the filter settings of the atlas textures,
     * only sprite frame with the same setting will be accepted afterward.
     * @zh 动态合图的管理器，管理所有运行时动态合成的图集，主要用于 UI 渲染。
     * 该管理器支持生成 [[maxAtlasCount]] 张动态合图，并且所有合图都有同样的 [[textureSize]] 像素尺寸。
     * 一般来说 [[Root.batcher2D]] 负责提交 [[SpriteFrame]] 到动态合图管理器中，这个过程对于开发者是透明的。
     * 需要注意的是，第一个提交的 [[SpriteFrame]] 会决定图集的过滤器参数，在此之后只有同样参数的贴图才会被管理器接受。
     */
    export class DynamicAtlasManager extends System {
        static instance: DynamicAtlasManager;
        constructor();
        /**
         * @en
         * Enable or disable the dynamic atlas.
         *
         * @zh
         * 开启或关闭动态图集。
         */
        get enabled(): boolean;
        set enabled(value: boolean);
        /**
         * @en
         * The maximum number of atlases that can be created.
         *
         * @zh
         * 可以创建的最大图集数量。
         */
        get maxAtlasCount(): number;
        set maxAtlasCount(value: number);
        /**
         * @en
         * Get the current created atlas count.
         *
         * @zh
         * 获取当前已经创建的图集数量。
         */
        get atlasCount(): number;
        /**
         * @en
         * Whether to enable textureBleeding.
         *
         * @zh
         * 是否开启 textureBleeding。
         */
        get textureBleeding(): boolean;
        set textureBleeding(enable: boolean);
        /**
         * @en
         * The size of the created atlas.
         *
         * @zh
         * 创建的图集的宽高。
         */
        get textureSize(): number;
        set textureSize(value: number);
        /**
         * @en
         * The maximum size of the picture that can be added to the atlas.
         *
         * @zh
         * 可以添加进图集的图片的最大尺寸。
         */
        get maxFrameSize(): number;
        set maxFrameSize(value: number);
        /**
         * @internal
         */
        init(): void;
        /**
         * @en
         * Append a sprite frame into the dynamic atlas.
         *
         * @zh
         * 添加碎图进入动态图集。
         *
         * @method insertSpriteFrame
         * @param spriteFrame  the sprite frame that will be inserted in the atlas.
         */
        insertSpriteFrame(spriteFrame: SpriteFrame): {
            x: number;
            y: number;
            texture: __private._cocos_2d_utils_dynamic_atlas_atlas__DynamicAtlasTexture;
        } | null;
        /**
         * @en
         * Reset all dynamic atlases, and all existing ones will be destroyed.
         *
         * @zh
         * 重置所有动态图集，已有的动态图集会被销毁。
         *
         * @method reset
         */
        reset(): void;
        /**
         * @en
         * Delete a sprite from the atlas.
         *
         * @zh
         * 从动态图集中删除某张碎图。
         *
         * @method deleteAtlasSpriteFrame
         * @param spriteFrame  the sprite frame that will be removed from the atlas.
         */
        deleteAtlasSpriteFrame(spriteFrame: SpriteFrame): void;
        /**
         * @en
         * Delete a texture from the atlas.
         *
         * @zh
         * 从动态图集中删除某张纹理。
         *
         * @method deleteAtlasTexture
         * @param texture  the texture that will be removed from the atlas.
         */
        deleteAtlasTexture(texture: __private._cocos_asset_assets_texture_base__TextureBase): void;
        /**
         * @en
         * Pack the sprite in the dynamic atlas and update the atlas information of the sprite frame.
         *
         * @zh
         * 将图片打入动态图集，并更新该图片的图集信息。
         *
         * @method packToDynamicAtlas
         * @param frame  the sprite frame that will be packed in the dynamic atlas.
         */
        packToDynamicAtlas(comp: any, frame: SpriteFrame | null): void;
    }
    /**
     * @en The singleton instance of [[DynamicAtlasManager]], please use [[DynamicAtlasManager.instance]] instead.
     * @zh [[DynamicAtlasManager]] 的单例对象，请直接使用 [[DynamicAtlasManager.instance]]。
     * @deprecated since v3.7
     */
    export const dynamicAtlasManager: DynamicAtlasManager;
    export namespace utils {
        /**
         * @en Finds a node by hierarchy path, the path is case-sensitive.
         * It will traverse the hierarchy by splitting the path using '/' character.
         * This function will still returns the node even if it is inactive.
         * It is recommended to not use this function every frame instead cache the result at startup.
         * @zh 通过路径从节点树中查找节点的方法，路径是大小写敏感的，并且通过 `/` 来分隔节点层级。
         * 即使节点的状态是未启用的也可以找到，建议将结果缓存，而不是每次需要都去查找。
         * @param path The path of the target node
         * @param referenceNode If given, the search will be limited in the sub node tree of the reference node
         */
        export function find(path: string, referenceNode?: Node): Node | null;
        /**
         * @en
         * save a color buffer to a PPM file
         * @zh
         * 保存一个颜色缓冲到 PPM 文件中
         * @param buffer color buffer
         * @param w width
         * @param h height
         */
        export function toPPM(buffer: Uint8Array, w: number, h: number): string;
        export function readMesh(mesh: Mesh, iPrimitive?: number): primitives.IGeometry;
        /**
         * @deprecated
         */
        export function createMesh(geometry: primitives.IGeometry, out?: Mesh, options?: primitives.ICreateMeshOptions): Mesh;
        export namespace createMesh {
            /**
             * @deprecated
             */
            export interface IOptions {
                /**
                 * @en calculate mesh's aabb or not
                 * @zh 是否计算模型的包围盒。
                 */
                calculateBounds?: boolean;
            }
        }
        /**
         * @en mesh utility class, use to create mesh.
         * @zh 网格工具类，用于创建网格。
         */
        export class MeshUtils {
            /**
             * @en create a static mesh.
             * @zh 创建一个静态网格。
             * @param geometry @en geometry data use for creating @zh 用于创建的几何数据
             * @param out @en output static mesh @zh 输出的静态网格
             * @param options @en options of creating @zh 创建选项
             * @return @en The created static mesh, which is same as out @zh 新创建的静态网格，同 out 参数
             */
            static createMesh(geometry: primitives.IGeometry, out?: Mesh, options?: primitives.ICreateMeshOptions): Mesh;
            /**
             * @en create a dynamic mesh.
             * @zh 创建一个动态网格。
             * @param primitiveIndex @en sub mesh index @zh 子网格索引
             * @param geometry @en geometry data use for creating @zh 用于创建的几何数据
             * @param out @en output dynamic mesh @zh 输出的动态网格
             * @param options @en options of creating @zh 创建选项
             * @return @en The created dynamic mesh, which is same as out @zh 新创建的动态网格，同 out 参数
             */
            static createDynamicMesh(primitiveIndex: number, geometry: primitives.IDynamicGeometry, out?: Mesh, options?: primitives.ICreateDynamicMeshOptions): Mesh;
        }
        export function readBuffer(target: DataView, format?: gfx.Format, offset?: number, length?: number, stride?: number, out?: number[]): number[];
        export function writeBuffer(target: DataView, data: number[], format?: gfx.Format, offset?: number, stride?: number): void;
        export function mapBuffer(target: DataView, callback: (cur: number, idx: number, view: DataView) => number, format?: gfx.Format, offset?: number, length?: number, stride?: number, out?: DataView): DataView;
    }
    /**
     * @en Utility for 3d model static batching
     * @zh 服务于 3D 模型静态合批的工具类
     */
    export class BatchingUtility {
        /**
         * @en
         * Collect the Models under `staticModelRoot`,
         * merge all the meshes statically into one (while disabling each component),
         * and attach it to a new Model on `batchedRoot`.
         * The world transform of each model is guaranteed to be preserved.
         *
         * For a more fine-grained control over the process, use `Mesh.merge` directly.
         * @zh
         * 在`staticModelRoot`下收集模型。
         * 将所有的网格静态地合并成一个（同时禁用每个组件）。
         * 并将其附加到 `batchedRoot` 上的一个新模型。
         * 每个模型的世界变换都被保证保留下来。
         * 如果要对这个过程进行更精细的控制，可以直接使用 `Mesh.merge`。
         * @param staticModelRoot root of all the static models to be batched
         * @param batchedRoot the target output node
         */
        static batchStaticModel(staticModelRoot: Node, batchedRoot: Node): boolean;
        /**
         * @en
         * Undoes everything `batchStaticModel` did.
         * @zh
         * 回退 `batchStaticModel` 做的工作
         *
         * @param staticModelRoot root of all the static models to be batched
         * @param batchedRoot the target output node
         */
        static unbatchStaticModel(staticModelRoot: Node, batchedRoot: Node): boolean;
    }
    /**
     * @en A representation of a mesh asset
     * A mesh can contain multiple sub-mesh resources. The mesh mainly provides data such as vertices and indices for model instances.
     * @zh 代表一个网格资源
     * 一个网格可包含多个子网格资源，网格主要为模型实例提供顶点，索引等数据
     */
    export class Mesh extends Asset {
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _nativeAsset(): ArrayBuffer;
        set _nativeAsset(value: ArrayBuffer);
        /**
         * @en The sub meshes count of the mesh.
         * @zh 此网格的子网格数量。
         * @deprecated Please use [[renderingSubMeshes.length]] instead
         */
        get subMeshCount(): number;
        /**
         * @en The minimum position of all vertices in the mesh
         * @zh （各分量都）小于等于此网格任何顶点位置的最大位置。
         * @deprecated Please use [[struct.minPosition]] instead
         */
        get minPosition(): Readonly<math.Vec3> | undefined;
        /**
         * @en The maximum position of all vertices in the mesh
         * @zh （各分量都）大于等于此网格任何顶点位置的最大位置。
         * @deprecated Please use [[struct.maxPosition]] instead
         */
        get maxPosition(): Readonly<math.Vec3> | undefined;
        /**
         * @en The struct of the mesh
         * @zh 此网格的结构。
         */
        get struct(): Mesh.IStruct;
        /**
         * @en The actual data of the mesh
         * @zh 此网格的数据。
         */
        get data(): Uint8Array;
        /**
         * @en The hash of the mesh
         * @zh 此网格的哈希值。
         */
        get hash(): number;
        /**
         * @en The index of the joint buffer of all sub meshes in the joint map buffers
         * @zh 所有子网格的关节索引集合
         */
        get jointBufferIndices(): number[];
        /**
         * @en The sub meshes for rendering. Mesh could be split into different sub meshes for rendering.
         * @zh 此网格创建的渲染网格。
         */
        get renderingSubMeshes(): RenderingSubMesh[];
        /**
         * @en morph rendering data
         * @zh 变形渲染数据
         */
        morphRendering: __private._cocos_3d_assets_morph_rendering__MorphRendering | null;
        constructor();
        /**
         * @en complete loading callback
         * @zh 加载完成回调
         */
        onLoaded(): void;
        /**
         * @en mesh init
         * @zh 网格初始化函数
         */
        initialize(): void;
        /**
         * @en update dynamic sub mesh geometry
         * @zh 更新动态子网格的几何数据
         * @param primitiveIndex @en sub mesh index @zh 子网格索引
         * @param dynamicGeometry @en sub mesh geometry data @zh 子网格几何数据
         */
        updateSubMesh(primitiveIndex: number, dynamicGeometry: primitives.IDynamicGeometry): void;
        /**
         * @en Destroy the mesh and release all related GPU resources
         * @zh 销毁此网格，并释放它占有的所有 GPU 资源。
         */
        destroy(): boolean;
        /**
         * @en Release all related GPU resources
         * @zh 释放此网格占有的所有 GPU 资源。
         */
        destroyRenderingMesh(): void;
        /**
         * @en Reset the struct and data of the mesh
         * @zh 重置此网格的结构和数据。
         * @param struct @en The new struct @zh 新结构
         * @param data @en The new data @zh 新数据
         * @deprecated Will be removed in v3.0.0, please use [[reset]] instead
         */
        assign(struct: Mesh.IStruct, data: Uint8Array): void;
        /**
         * @en Reset the mesh with mesh creation information
         * @zh 重置此网格。
         * @param info @en Mesh creation information including struct and data @zh 网格创建信息，包含结构及数据
         */
        reset(info: Mesh.ICreateInfo): void;
        /**
         * @en Get [[geometry.AABB]] bounds in the skeleton's bone space
         * @zh 获取骨骼变换空间内下的 [[geometry.AABB]] 包围盒
         * @param skeleton @en skeleton data @zh 骨骼信息
         * @param skeleton @en skeleton data @zh 骨骼信息
         */
        getBoneSpaceBounds(skeleton: Skeleton): (geometry.AABB | null)[];
        /**
         * @en Merge the given mesh into the current mesh
         * @zh 合并指定的网格到此网格中。
         * @param mesh @en The mesh to be merged @zh 要合并的网格
         * @param worldMatrix @en The world matrix of the given mesh @zh 给定网格的模型变换矩阵
         * @param validate @en Whether to validate the mesh @zh 是否验证网格顶点布局
         * @returns @en whether the merging was successful or not @zh 返回合并成功与否
         */
        merge(mesh: Mesh, worldMatrix?: math.Mat4, validate?: boolean): boolean;
        /**
         * @en Validation for whether the given mesh can be merged into the current mesh.
         * To pass the validation, it must satisfy either of these two requirements:
         * - When the current mesh have no data
         * - When the two mesh have the same vertex bundle count, the same sub meshes count, and the same sub mesh layout.
         *
         * Same mesh layout means:
         * - They have the same primitive type and reference to the same amount vertex bundle with the same indices.
         * - And they all have or don't have index view
         * @zh 验证指定网格是否可以合并至当前网格。
         *
         * 当满足以下条件之一时，指定网格可以合并至当前网格：
         *  - 当前网格无数据而待合并网格有数据；
         *  - 它们的顶点块数目相同且对应顶点块的布局一致，并且它们的子网格数目相同且对应子网格的布局一致。
         *
         * 两个顶点块布局一致当且仅当：
         *  - 它们具有相同数量的顶点属性且对应的顶点属性具有相同的属性格式。
         *
         * 两个子网格布局一致，当且仅当：
         *  - 它们具有相同的图元类型并且引用相同数量、相同索引的顶点块；并且，
         *  - 要么都需要索引绘制，要么都不需要索引绘制。
         * @param mesh @en The other mesh to be validated @zh 待验证的网格
         */
        validateMergingMesh(mesh: Mesh): boolean;
        /**
         * @en Read the requested attribute of the given sub mesh
         * @zh 读取子网格的指定属性。
         * @param primitiveIndex @en Sub mesh index @zh 子网格索引
         * @param attributeName @en Attribute name @zh 属性名称
         * @returns @en Return null if not found or can't read, otherwise, will create a large enough typed array to contain all data of the attribute,
         * the array type will match the data type of the attribute. @zh 读取失败返回 null， 否则返回对应的类型数组
         */
        readAttribute(primitiveIndex: number, attributeName: gfx.AttributeName): __private.__types_globals__TypedArray | null;
        /**
         * @en Read the requested attribute of the given sub mesh and fill into the given buffer.
         * @zh 读取子网格的指定属性到目标缓冲区中。
         * @param primitiveIndex @en Sub mesh index @zh 子网格索引
         * @param attributeName @en Attribute name @zh 属性名称
         * @param buffer @en The target array buffer @zh 目标缓冲区
         * @param stride @en attribute stride @zh 属性跨距
         * @param offset @en The offset of the first attribute in the target buffer @zh 第一个属性在目标缓冲区的偏移
         * @returns @en false if failed to access attribute, true otherwise @zh 是否成功拷贝
         */
        copyAttribute(primitiveIndex: number, attributeName: gfx.AttributeName, buffer: ArrayBuffer, stride: number, offset: number): boolean;
        /**
         * @en Read the indices data of the given sub mesh
         * @zh 读取子网格的索引数据。
         * @param primitiveIndex @en Sub mesh index @zh 子网格索引
         * @returns @en Return null if not found or can't read, otherwise, will create a large enough typed array to contain all indices data,
         * the array type will use the corresponding stride size. @zh 读取失败返回 null，否则返回索引数据
         */
        readIndices(primitiveIndex: number): Uint8Array | Uint16Array | Uint32Array | null;
        /**
         * @en Read the indices data of the given sub mesh and fill into the given array
         * @zh 读取子网格的索引数据到目标数组中。
         * @param primitiveIndex @en Sub mesh index @zh 子网格索引
         * @param outputArray @en The target output array @zh 目标索引数组
         * @returns @en Return false if failed to access the indices data, return true otherwise. @zh 拷贝失败返回 false， 否则返回 true
         */
        copyIndices(primitiveIndex: number, outputArray: number[] | ArrayBufferView): boolean;
        /**
         * @en Read the format by attributeName of submesh
         * @zh 根据属性名读取子网格的属性信息。
         * @param primitiveIndex @en Sub mesh index @zh 子网格索引
         * @param attributeName @en Attribute name @zh 属性名称
         * @returns @en Return null if failed to read format, return the format otherwise. @zh 读取失败返回 null， 否则返回 format
         */
        readAttributeFormat(primitiveIndex: number, attributeName: gfx.AttributeName): gfx.FormatInfo | null;
        /**
         * @en default init
         * @zh 默认初始化
         * @param uuid @en asset uuid @zh 资源 uuid
         */
        initDefault(uuid?: string): void;
        /**
         * @en Set whether the data of this mesh could be accessed (read or wrote), it could be used only for static mesh
         * @zh 设置此网格的数据是否可被存取，此接口只针对静态网格资源生效
         * @param allowDataAccess @en Indicate whether the data of this mesh could be accessed (read or wrote) @zh 是否允许存取网格数据
         */
        set allowDataAccess(allowDataAccess: boolean);
        /**
         * @en Get whether the data of this mesh could be read or wrote
         * @zh 获取此网格的数据是否可被存取
         * @return @en whether the data of this mesh could be accessed (read or wrote) @zh 此网格的数据是否可被存取
         */
        get allowDataAccess(): boolean;
    }
    export namespace Mesh {
        export interface IBufferView {
            offset: number;
            length: number;
            count: number;
            stride: number;
        }
        /**
         * @en Vertex bundle, it describes a set of interleaved vertex attributes and their values.
         * @zh 顶点块。顶点块描述了一组**交错排列**（interleaved）的顶点属性并存储了顶点属性的实际数据。<br>
         * 交错排列是指在实际数据的缓冲区中，每个顶点的所有属性总是依次排列，并总是出现在下一个顶点的所有属性之前。
         */
        export interface IVertexBundle {
            /**
             * @en The actual value for all vertex attributes.
             * You must use DataView to access the data.
             * Because there is no guarantee that the starting offsets of all properties are byte aligned as required by TypedArray.
             * @zh 所有顶点属性的实际数据块。
             * 你必须使用 DataView 来读取数据。
             * 因为不能保证所有属性的起始偏移都按 TypedArray 要求的字节对齐。
             */
            view: IBufferView;
            /**
             * @en All attributes included in the bundle
             * @zh 包含的所有顶点属性。
             */
            attributes: gfx.Attribute[];
        }
        export interface IMeshCluster {
            clusterView: IBufferView;
            triangleView: IBufferView;
            vertexView: IBufferView;
            coneView?: IBufferView;
        }
        /**
         * @en Sub mesh contains a list of primitives with the same type (Point, Line or Triangle)
         * @zh 子网格。子网格由一系列相同类型的图元组成（例如点、线、面等）。
         */
        export interface ISubMesh {
            /**
             * @en The vertex bundle references used by the sub mesh.
             * @zh 此子网格引用的顶点块，索引至网格的顶点块数组。
             */
            vertexBundelIndices: number[];
            /**
             * @en The primitive mode of the sub mesh
             * @zh 此子网格的图元类型。
             */
            primitiveMode: gfx.PrimitiveMode;
            /**
             * @en The index data of the sub mesh
             * @zh 此子网格使用的索引数据。
             */
            indexView?: IBufferView;
            /**
             * @en The joint map index in [[IStruct.jointMaps]]. Could be absent
             * @zh 此子网格使用的关节索引映射表在 [[IStruct.jointMaps]] 中的索引。
             * 如未定义或指向的映射表不存在，则默认 VB 内所有关节索引数据直接对应骨骼资源数据。
             */
            jointMapIndex?: number;
            /**
             * @en The cluster data of the sub mesh
             */
            cluster?: IMeshCluster;
        }
        /**
         * @en dynamic info used to create dyanmic mesh
         * @zh 动态信息，用于创建动态网格
         */
        export interface IDynamicInfo {
            /**
             * @en max submesh count
             * @zh 最大子模型个数。
             */
            maxSubMeshes: number;
            /**
             * @en max submesh vertex count
             * @zh 子模型最大顶点个数。
             */
            maxSubMeshVertices: number;
            /**
             * @en max submesh index count
             * @zh 子模型最大索引个数。
             */
            maxSubMeshIndices: number;
        }
        /**
         * @en dynamic struct
         * @zh 动态结构体
         */
        export interface IDynamicStruct {
            /**
             * @en dynamic mesh info
             * @zh 动态模型信息。
             */
            info: IDynamicInfo;
            /**
             * @en dynamic submesh bounds
             * @zh 动态子模型包围盒。
             */
            bounds: geometry.AABB[];
        }
        /**
         * @en The structure of the mesh
         * @zh 描述了网格的结构。
         */
        export interface IStruct {
            /**
             * @en All vertex bundles of the mesh
             * @zh 此网格所有的顶点块。
             */
            vertexBundles: IVertexBundle[];
            /**
             * @en All sub meshes
             * @zh 此网格的所有子网格。
             */
            primitives: ISubMesh[];
            /**
             * @en The minimum position of all vertices in the mesh
             * @zh （各分量都）小于等于此网格任何顶点位置的最大位置。
             */
            minPosition?: math.Vec3;
            /**
             * @en The maximum position of all vertices in the mesh
             * @zh （各分量都）大于等于此网格任何顶点位置的最小位置。
             */
            maxPosition?: math.Vec3;
            /**
             * @en The joint index map list.
             * @zh 此网格使用的关节索引映射关系列表，数组长度应为子模型中实际使用到的所有关节，
             * 每个元素都对应一个原骨骼资源里的索引，按子模型 VB 内的实际索引排列。
             */
            jointMaps?: number[][];
            /**
             * @en The morph information of the mesh
             * @zh 网格的形变数据
             */
            morph?: Morph;
            /**
             * @en The specific data of the dynamic mesh
             * @zh 动态网格特有数据
             */
            dynamic?: IDynamicStruct;
            /**
             * @en Whether the mesh data is quantized to reduce memory usage
             * @zh 此网格数据是否经过量化以减少内存占用。
             */
            quantized?: boolean;
            /**
             * @en Whether the mesh data is encoded to reduce memory usage
             * @zh
             */
            encoded?: boolean;
            /**
             * @en Whether the mesh data is compressed to reduce memory usage
             * @zh 此网格数据是否经过压缩以减少内存占用。
             */
            compressed?: boolean;
            /**
             * @en Whether the mesh contains cluster data
             * @zh 此网格是否包含 cluster 数据。
             */
            cluster?: boolean;
        }
        /**
         * @en The create info of the mesh
         * @zh 网格创建信息
         */
        export interface ICreateInfo {
            /**
             * @en Mesh structure
             * @zh 网格结构。
             */
            struct: Mesh.IStruct;
            /**
             * @en Mesh binary data
             * @zh 网格二进制数据。
             */
            data: Uint8Array;
        }
    }
    /**
     * @en The skeleton asset. It stores the path related to [[SkinnedMeshRenderer.skinningRoot]] of all bones and its bind pose matrix.
     * @zh 骨骼资源。骨骼资源记录了每个关节（相对于 [[SkinnedMeshRenderer.skinningRoot]]）的路径以及它的绑定姿势矩阵。
     */
    export class Skeleton extends Asset {
        constructor();
        /**
         * @en The path of all bones, the length always equals the length of [[bindposes]]
         * @zh 所有关节的路径。该数组的长度始终与 [[bindposes]] 的长度相同。
         */
        get joints(): string[];
        set joints(value: string[]);
        /**
         * @en The bind poses matrix of all bones, the length always equals the length of [[joints]]
         * @zh 所有关节的绑定姿势矩阵。该数组的长度始终与 [[joints]] 的长度相同。
         */
        get bindposes(): math.Mat4[];
        set bindposes(value: math.Mat4[]);
        /**
         * @en Gets the inverse bind poses matrix
         * @zh 获取反向绑定姿势矩阵
         */
        get inverseBindposes(): math.Mat4[];
        /**
         * @en Gets the hash of the skeleton asset
         * @zh 获取骨骼资源的哈希值
         */
        get hash(): number;
        destroy(): boolean;
        /**
         * @en Check whether the skeleton is validate which means it has both joints and bindposes data.
         * @zh 检查当前骨骼对象是否是有效的，取决于它是否包含关节路径和绑定姿势数据。
         * @returns @en Whether the skeleton is valid or not @zh 此骨骼是否有效
         */
        validate(): boolean;
    }
    /**
     * @en Mesh morph data structure to describe the sub meshes data of all sub meshes,
     * it also contains all sub mesh morphs, global weights configuration and target names.
     * Normally the global weights configuration should be identical to the sub mesh morph weights,
     * but if not, the global weights in morph is less prioritized.
     * @zh 网格的形变数据结构，包含所有子网格形变数据，全局的权重配置和所有形变目标名称。
     * 一般来说，全局权重配置和子网格形变数据中保持一致，但如果有差异，以子网格形变数据中的权重配置为准。
     */
    export interface Morph {
        /**
         * Morph data of each sub-mesh.
         */
        subMeshMorphs: (SubMeshMorph | null)[];
        /**
         * Common initial weights of each sub-mesh.
         */
        weights?: number[];
        /**
         * Name of each target of each sub-mesh morph.
         * This field is only meaningful if every sub-mesh has the same number of targets.
         */
        targetNames?: string[];
    }
    /**
     * @en Morph target contains all displacements data of each vertex attribute like position and normal.
     * @zh 形变目标数据包含网格顶点属性在形变下的变化值，可能包含位移、法线等属性
     */
    export interface MorphTarget {
        /**
         * Displacement of each target attribute.
         */
        displacements: Mesh.IBufferView[];
    }
    /**
     * @en Sub mesh morph data describes all morph targets for one sub mesh,
     * including attributes in each morph target, morph targets data and weights corresponding each targets.
     * @zh 子网格形变数据描述一个子网格下所有的形变目标数据，包含顶点形变属性，形变目标数据和对应每个形变目标的权重。
     */
    export interface SubMeshMorph {
        /**
         * Attributes to morph.
         */
        attributes: gfx.AttributeName[];
        /**
         * Targets.
         */
        targets: MorphTarget[];
        /**
         * Initial weights of each target.
         */
        weights?: number[];
    }
    /**
     * @en Mesh renderer component for general 3d model rendering, it generates and link to a Model in the render scene.
     * It supports real time lighting and shadow, baked light map, and morph rendering.
     * @zh 用于通用模型渲染的网格渲染器组件，会创建并关联一个渲染场景中的模型对象。
     * 该组件支持实时光照和阴影，预烘焙光照贴图和形变网格渲染。
     */
    export class MeshRenderer extends ModelRenderer {
        /**
         * @en Shadow projection mode enumeration.
         * @zh 阴影投射方式枚举。
         */
        static ShadowCastingMode: {
            /**
             * @en Disable shadow projection.
             * @zh 不投射阴影。
             */
            OFF: number;
            /**
             * @en Enable shadow projection.
             * @zh 开启阴影投射。
             */
            ON: number;
        };
        /**
         * @en Shadow receive mode enumeration.
         * @zh 阴影接收方式枚举。
         */
        static ShadowReceivingMode: {
            /**
             * @en Disable shadow receiving.
             * @zh 不接收阴影。
             */
            OFF: number;
            /**
             * @en Enable shadow receiving.
             * @zh 开启阴影投射。
             */
            ON: number;
        };
        /**
         * @en The settings for GI baking, it was called lightmapSettings before
         * @zh 全局光照烘焙的配置，以前名称为lightmapSettings
         */
        bakeSettings: __private._cocos_3d_framework_mesh_renderer__ModelBakeSettings;
        protected _mesh: Mesh | null;
        protected _shadowCastingMode: number;
        protected _shadowReceivingMode: number;
        protected _shadowBias: number;
        protected _shadowNormalBias: number;
        protected _reflectionProbeId: number;
        protected _reflectionProbeBlendId: number;
        protected _reflectionProbeBlendWeight: number;
        protected _enabledGlobalStandardSkinObject: boolean;
        protected _reflectionProbeDataMap: Texture2D | null;
        /**
         * @en Local shadow bias for real time lighting.
         * @zh 实时光照下模型局部的阴影偏移。
         */
        get shadowBias(): number;
        set shadowBias(val: number);
        /**
         * @en local shadow normal bias for real time lighting.
         * @zh 实时光照下模型局部的阴影法线偏移。
         */
        get shadowNormalBias(): number;
        set shadowNormalBias(val: number);
        /**
         * @en Shadow projection mode.
         * @zh 实时光照下阴影投射方式。
         */
        get shadowCastingMode(): number;
        set shadowCastingMode(val: number);
        get shadowCastingModeForInspector(): boolean;
        set shadowCastingModeForInspector(val: boolean);
        /**
         * @en Is received direction Light.
         * @zh 是否接收平行光光照。
         * @param visibility @en direction light visibility. @zh 方向光的可见性。
         */
        onUpdateReceiveDirLight(visibility: number, forceClose?: boolean): void;
        /**
         * @en receive shadow.
         * @zh 实时光照下是否接受阴影。
         */
        get receiveShadow(): number;
        set receiveShadow(val: number);
        get receiveShadowForInspector(): boolean;
        set receiveShadowForInspector(val: boolean);
        /**
         * @en Gets or sets the mesh of the model.
         * Note, when set, all morph targets' weights would be reset to zero.
         * @zh 获取或设置模型的网格数据。
         * 注意，设置时，所有形变目标的权重都将归零。
         */
        get mesh(): Mesh | null;
        set mesh(val: Mesh | null);
        /**
         * @en Gets the model in [[RenderScene]].
         * @zh 获取渲染场景 [[RenderScene]] 中对应的模型。
         */
        get model(): renderer.scene.Model | null;
        /**
         * @en Whether to enable morph rendering.
         * @zh 是否启用形变网格渲染。
         */
        get enableMorph(): boolean;
        set enableMorph(value: boolean);
        /**
         * @en Set the Separable-SSS skin standard model component.
         * @zh 设置是否是全局的4s标准模型组件
         */
        get isGlobalStandardSkinObject(): boolean;
        set isGlobalStandardSkinObject(val: boolean);
        protected _modelType: typeof renderer.scene.Model;
        protected _model: renderer.scene.Model | null;
        constructor();
        onLoad(): void;
        onRestore(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        onGeometryChanged(): void;
        /**
         * @zh 获取子网格指定形变目标的权重。
         * @en Gets the weight at specified morph target of the specified sub mesh.
         * @param subMeshIndex Index to the sub mesh.
         * @param shapeIndex Index to the morph target of the sub mesh.
         * @returns The weight.
         */
        getWeight(subMeshIndex: number, shapeIndex: number): number;
        /**
         * @zh
         * 设置子网格所有形变目标的权重。
         * `subMeshIndex` 是无效索引或 `weights` 的长度不匹配子网格的形变目标数量时，此方法不会生效。
         * @en
         * Sets weights of each morph target of the specified sub mesh.
         * If takes no effect if `subMeshIndex` is out of bounds or if `weights` has a different length with morph targets count of the sub mesh.
         * @param weights The weights.
         * @param subMeshIndex Index to the sub mesh.
         */
        setWeights(weights: number[], subMeshIndex: number): void;
        /**
         * @zh
         * 设置子网格指定外形的权重。
         * `subMeshIndex` 或 `shapeIndex` 是无效索引时，此方法不会生效。
         * @en
         * Sets the weight at specified shape of specified sub mesh.
         * If takes no effect if
         * `subMeshIndex` or `shapeIndex` out of bounds.
         * @param weight The weight.
         * @param subMeshIndex Index to the sub mesh.
         * @param shapeIndex Index to the shape of the sub mesh.
         */
        setWeight(weight: number, subMeshIndex: number, shapeIndex: number): void;
        setInstancedAttribute(name: string, value: ArrayLike<number>): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _updateLightmap(lightmap: Texture2D | null, uOff: number, vOff: number, scale: number, lum: number): void;
        /**
         * @zh
         * 更新反射探针烘焙的cubemap。
         * @en
         * Updat cubemap baked with reflection probes.
         * @param cubeMap baked cubemap.
         * @param useDefaultTexture if the reflection probe has not been baked, is the skybox used instead.
         */
        updateProbeCubemap(cubeMap: TextureCube | null): void;
        /**
         * @zh
         * 更新用于混合的反射探针烘焙的cubemap。
         * @en
         * Updat cubemap baked with reflection probes for blending.
         * @param cubeMap baked cubemap.
         */
        updateProbeBlendCubemap(cubeMap: TextureCube | null): void;
        /**
         * @zh
         * 更新平面反射渲染纹理。
         * @en
         * Update the reflection rendering texture.
         * @param planarMap render texture.
         */
        updateProbePlanarMap(planarMap: gfx.Texture | null): void;
        /**
         * @zh
         * 更新反射探针的数据贴图。
         * @en
         * Update the data mapping of the reflection probe.
         * @param dataMap data mapping with data saved all reflection probe data.
         */
        updateReflectionProbeDataMap(dataMap: Texture2D | null): void;
        /**
         * @zh
         * 更新反射探针的id。
         * @en
         * Update the id of the reflection probe.
         * @param probeId probe id.
         */
        updateReflectionProbeId(probeId: number): void;
        /**
         * @zh
         * 更新用于混合的反射探针的id。
         * @en
         * Update the id of the reflection probe used for blending.
         * @param blendProbeId probe id of blend.
         */
        updateReflectionProbeBlendId(blendProbeId: number): void;
        /**
         * @zh
         * 更新混合权重。
         * @en
         * Update blending weight.
         * @param weight blending weight.
         */
        updateReflectionProbeBlendWeight(weight: number): void;
        protected _updateReflectionProbeTexture(): void;
        protected _updateModels(): void;
        protected _updateReceiveDirLight(): void;
        protected _createModel(): void;
        protected _attachToScene(): void;
        protected _updateModelParams(): void;
        protected _onUpdateLightingmap(): void;
        protected _onUpdateLocalShadowBiasAndProbeId(): void;
        protected _onUpdateLocalReflectionProbeData(): void;
        protected _onUpdateReflectionProbeDataMap(): void;
        protected _onMaterialModified(idx: number, material: Material | null): void;
        protected _onMeshChanged(old: Mesh | null): void;
        protected _clearMaterials(): void;
        protected _getBuiltinMaterial(): Material;
        protected _onVisibilityChange(val: number): void;
        protected _updateShadowBias(): void;
        protected _updateShadowNormalBias(): void;
        protected _updateCastShadow(): void;
        protected _updateReceiveShadow(): void;
        protected onMobilityChanged(): void;
        protected onLightProbeBakingChanged(): void;
        protected onUseLightProbeChanged(): void;
        protected onReflectionProbeChanged(): void;
        protected onBakeToReflectionProbeChanged(): void;
        protected _updateUseLightProbe(): void;
        protected _isBatchingEnabled(): boolean;
        protected _updateUseReflectionProbe(): void;
        protected _updateUseReflectionProbeType(): void;
        protected _updateBakeToReflectionProbe(): void;
    }
    export namespace MeshRenderer {
        /**
         * @en Shadow projection mode.
         * @zh 阴影投射方式。
         */
        export type ShadowCastingMode = __private.__types_globals__EnumAlias<typeof __private._cocos_3d_framework_mesh_renderer__ModelShadowCastingMode>;
        /**
         * @en Shadow receive mode.
         * @zh 阴影接收方式。
         */
        export type ShadowReceivingMode = __private.__types_globals__EnumAlias<typeof __private._cocos_3d_framework_mesh_renderer__ModelShadowReceivingMode>;
    }
    /**
     * @en The directional light component, only one real time directional light is permitted in one scene, it act as the main light of the scene.
     * @zh 平行光源组件，一个场景只允许存在一个实时的平行光源，作为场景的主光源存在。
     */
    export class DirectionalLight extends Light {
        /**
         * @en The light source intensity.
         * @zh 光源强度。
         */
        get illuminance(): number;
        set illuminance(val: number);
        /**
         * @en Whether activate real time shadow.
         * @zh 是否启用实时阴影？
         */
        get shadowEnabled(): boolean;
        set shadowEnabled(val: boolean);
        /**
         * @en The shadow pcf for real time shadow.
         * @zh 实时阴影计算中的阴影 pcf 等级。
         */
        get shadowPcf(): number;
        set shadowPcf(val: number);
        /**
         * @en The shadow map sampler offset for real time shadow.
         * @zh 实时阴影计算中的阴影纹理偏移值。
         */
        get shadowBias(): number;
        set shadowBias(val: number);
        /**
         * @en The global normal bias for real time shadow.
         * @zh 实时阴影计算中的法线偏移。
         */
        get shadowNormalBias(): number;
        set shadowNormalBias(val: number);
        /**
         * @en The shadow color saturation for real time shadow.
         * @zh 实时阴影计算中的阴影颜色饱和度。
         */
        get shadowSaturation(): number;
        set shadowSaturation(val: number);
        /**
         * @en The potential shadow distance from the camera for real time shadow.
         * @zh 实时阴影计算中潜在阴影产生的范围
         */
        get shadowDistance(): number;
        set shadowDistance(val: number);
        /**
         * @en The occlusion range for real time shadow.
         * @zh 实时阴影计算中剔除阴影的范围
         */
        get shadowInvisibleOcclusionRange(): number;
        set shadowInvisibleOcclusionRange(val: number);
        /**
         * @en get or set shadow CSM level
         * @zh 获取或者设置阴影层级
         */
        get csmLevel(): number;
        set csmLevel(val: number);
        /**
         * @en enable csm
         * @zh 开启或关闭 csm 模式
         */
        get enableCSM(): boolean;
        set enableCSM(val: boolean);
        /**
         * @en get or set shadow CSM level ratio
         * @zh 获取或者设置阴影层级系数
         */
        get csmLayerLambda(): number;
        set csmLayerLambda(val: number);
        /**
         * @en get or set shadow CSM performance optimization mode
         * @zh 获取或者设置级联阴影性能优化模式
         * @internal
         */
        get csmOptimizationMode(): number;
        set csmOptimizationMode(val: number);
        /**
         * @en Whether to use fixed area shadow in real time shadow.
         * @zh 实时阴影计算中是否使用固定区域阴影。
         */
        get shadowFixedArea(): boolean;
        set shadowFixedArea(val: boolean);
        /**
         * @en The near clip plane of the shadow camera for fixed area shadow
         * @zh 固定区域阴影设置中阴影相机近裁剪面
         */
        get shadowNear(): number;
        set shadowNear(val: number);
        /**
         * @en The far clip plane of the shadow camera for fixed area shadow.
         * @zh 固定区域阴影设置中阴影相机远裁剪面。
         */
        get shadowFar(): number;
        set shadowFar(val: number);
        /**
         * @en The orthogonal size of the shadow camera for fixed area shadow.
         * @zh 固定区域阴影设置中阴影相机的正交尺寸
         */
        get shadowOrthoSize(): number;
        set shadowOrthoSize(val: number);
        /**
         * @en Enabled shadow advanced options
         * @zh 是否启用高级选项？
         */
        get csmAdvancedOptions(): boolean;
        set csmAdvancedOptions(val: boolean);
        /**
         * @en Enabled csm layers transition
         * @zh 是否启用级联阴影层级过渡？
         */
        get csmLayersTransition(): boolean;
        set csmLayersTransition(val: boolean);
        /**
         * @en get or set csm layers transition range
         * @zh 获取或者设置级联阴影层级过渡范围？
         */
        get csmTransitionRange(): number;
        set csmTransitionRange(val: number);
        constructor();
        protected _createLight(): void;
        protected _onUpdateReceiveDirLight(): void;
    }
    /**
     * @en The base class of all light components, contains basic light settings for both real time light and baked light.
     * @zh 光源组件基类，包含实时光源和烘焙光源的基本配置信息。
     */
    export class Light extends Component {
        /**
         * @en The light type enumeration.
         * @zh 光源类型枚举。
         */
        static Type: typeof renderer.scene.LightType;
        /**
         * @en The physical term used for light.
         * @zh 光源所使用的物理计量单位。
         */
        static PhotometricTerm: {
            LUMINOUS_FLUX: number;
            LUMINANCE: number;
        };
        protected _color: math.Color;
        protected _useColorTemperature: boolean;
        protected _colorTemperature: number;
        protected _staticSettings: __private._cocos_3d_lights_light_component__StaticLightSettings;
        protected _visibility: number;
        protected _type: renderer.scene.LightType;
        protected _lightType: typeof renderer.scene.Light;
        protected _light: renderer.scene.Light | null;
        /**
         * @en The color of the light.
         * @zh 光源颜色。
         */
        get color(): Readonly<math.Color>;
        set color(val: Readonly<math.Color>);
        /**
         * @en
         * Whether to enable light color temperature.
         * @zh
         * 是否启用光源色温。
         */
        get useColorTemperature(): boolean;
        set useColorTemperature(enable: boolean);
        /**
         * @en
         * The light color temperature.
         * @zh
         * 光源色温。
         */
        get colorTemperature(): number;
        set colorTemperature(val: number);
        /**
         * @en
         * static light settings.
         * @zh
         * 静态灯光设置。
         */
        get staticSettings(): __private._cocos_3d_lights_light_component__StaticLightSettings;
        set staticSettings(val: __private._cocos_3d_lights_light_component__StaticLightSettings);
        /**
         * @en The light type.
         * @zh 光源类型。
         */
        get type(): renderer.scene.LightType;
        /**
         * @en Whether the light is baked
         * @zh 光源是否被烘焙
         */
        get baked(): boolean;
        set baked(val: boolean);
        /**
         * @en Visibility mask of the light, declaring a set of node layers that will be visible to this light.
         * @zh 光照的可见性掩码，声明在当前光照中可见的节点层级集合。
         */
        set visibility(vis: number);
        get visibility(): number;
        constructor();
        onLoad(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        protected _createLight(): void;
        protected _destroyLight(): void;
        protected _attachToScene(): void;
        protected _detachFromScene(): void;
        protected _onUpdateReceiveDirLight(): void;
    }
    export namespace Light {
        export type Type = __private.__types_globals__EnumAlias<typeof renderer.scene.LightType>;
        export type PhotometricTerm = __private.__types_globals__EnumAlias<typeof __private._cocos_3d_lights_light_component__PhotometricTerm>;
    }
    /**
     * @en The sphere light component, multiple sphere lights can be added to one scene.
     * @zh 球面光源组件，场景中可以添加多个球面光源。
     */
    export class SphereLight extends Light {
        /**
         * @en Luminous flux of the light.
         * @zh 光通量。
         */
        get luminousFlux(): number;
        set luminousFlux(val: number);
        /**
         * @en Luminance of the light.
         * @zh 光亮度。
         */
        get luminance(): number;
        set luminance(val: number);
        /**
         * @en The photometric term currently being used.
         * @zh 当前使用的光度学计量单位。
         */
        get term(): number;
        set term(val: number);
        /**
         * @en
         * Size of the light.
         * @zh
         * 光源大小。
         */
        get size(): number;
        set size(val: number);
        /**
         * @en
         * Range of the light.
         * @zh
         * 光源范围。
         */
        get range(): number;
        set range(val: number);
        constructor();
        protected _createLight(): void;
    }
    /**
     * @en The spot light component, multiple spot lights can be added to one scene.
     * @zh 聚光灯光源组件，场景中可以添加多个聚光灯光源。
     */
    export class SpotLight extends Light {
        /**
         * @en Luminous flux of the light.
         * @zh 光通量。
         */
        get luminousFlux(): number;
        set luminousFlux(val: number);
        /**
         * @en Luminance of the light.
         * @zh 光亮度。
         */
        get luminance(): number;
        set luminance(val: number);
        /**
         * @en The photometric term currently being used.
         * @zh 当前使用的光度学计量单位。
         */
        get term(): number;
        set term(val: number);
        /**
         * @en
         * Size of the light.
         * @zh
         * 光源大小。
         */
        get size(): number;
        set size(val: number);
        /**
         * @en
         * Range of the light.
         * @zh
         * 光源范围。
         */
        get range(): number;
        set range(val: number);
        /**
         * @en
         * The spot light cone angle.
         * @zh
         * 聚光灯锥角。
         */
        get spotAngle(): number;
        set spotAngle(val: number);
        /**
         * @en The angle attenuation strength of the spot light.
         * The larger the value, the softer the edge, and the smaller the value, the harder the edge.
         * @zh 聚光灯角度衰减强度。值越大，边缘越柔和，值越小，边缘越硬。
         */
        get angleAttenuationStrength(): number;
        set angleAttenuationStrength(val: number);
        /**
         * @en Whether activate shadow
         * @zh 是否启用阴影？
         */
        get shadowEnabled(): boolean;
        set shadowEnabled(val: boolean);
        /**
         * @en The pcf level of the shadow generation.
         * @zh 获取或者设置阴影 pcf 等级。
         */
        get shadowPcf(): number;
        set shadowPcf(val: number);
        /**
         * @en The depth offset of shadow to avoid moire pattern artifacts
         * @zh 阴影的深度偏移, 可以减弱跨像素导致的条纹状失真
         */
        get shadowBias(): number;
        set shadowBias(val: number);
        /**
         * @en The normal bias of the shadow map.
         * @zh 设置或者获取法线偏移。
         */
        get shadowNormalBias(): number;
        set shadowNormalBias(val: number);
        constructor();
        protected _createLight(): void;
    }
    /**
     * @en The point light component, multiple point lights can be added to one scene.
     * @zh 点光源组件，场景中可以添加多个点光源。
     */
    export class PointLight extends Light {
        /**
         * @en Luminous flux of the light.
         * @zh 光通量。
         */
        get luminousFlux(): number;
        set luminousFlux(val: number);
        /**
         * @en Luminance of the light.
         * @zh 光亮度。
         */
        get luminance(): number;
        set luminance(val: number);
        /**
         * @en The photometric term currently being used.
         * @zh 当前使用的光度学计量单位。
         */
        get term(): number;
        set term(val: number);
        /**
         * @en Range of the light.
         * @zh 光源范围。
         */
        get range(): number;
        set range(val: number);
        constructor();
        protected _createLight(): void;
    }
    /**
     * @en The ranged directional light component, Multiple ranged directional light sources are allowed in a scene.
     * @zh 范围平行光光源组件，一个场景允许存在多个范围平行光光源。
     */
    export class RangedDirectionalLight extends Light {
        /**
         * @en The light source intensity.
         * @zh 光源强度。
         */
        get illuminance(): number;
        set illuminance(val: number);
        constructor();
        protected _createLight(): void;
    }
    /**
     * @en The skinned mesh renderer component.
     * @zh 蒙皮网格渲染器组件。
     */
    export class SkinnedMeshRenderer extends MeshRenderer {
        protected _skeleton: Skeleton | null;
        protected _skinningRoot: Node | null;
        protected _clip: AnimationClip | null;
        /**
         * @en The skeleton asset.
         * @zh 骨骼资源。
         */
        get skeleton(): Skeleton | null;
        set skeleton(val: Skeleton | null);
        /**
         * @en The skinning root. (The node where the controlling Animation is located)
         * @zh 骨骼根节点的引用，对应控制此模型的动画组件所在节点。
         */
        get skinningRoot(): Node | null;
        set skinningRoot(value: Node | null);
        get model(): __private._cocos_3d_models_skinning_model__SkinningModel | __private._cocos_3d_models_baked_skinning_model__BakedSkinningModel | null;
        /**
         * Set associated animation.
         * @internal This method only friends to skeletal animation component.
         */
        associatedAnimation: SkeletalAnimation | null;
        constructor();
        onLoad(): void;
        onDestroy(): void;
        uploadAnimation(clip: AnimationClip | null): void;
        /**
         * Set if bake mode should be used.
         * @internal This method only friends to skeletal animation component.
         */
        setUseBakedAnimation(val?: boolean, force?: boolean): void;
        setSharedMaterial(material: Material | null, index: number): void;
        protected _updateModelParams(): void;
    }
    /**
     * @en The skinned mesh batch renderer component, batches multiple skeleton-sharing [[SkinnedMeshRenderer]].
     * @zh 蒙皮模型合批组件，用于合并绘制共享同一骨骼资源的所有蒙皮网格。
     */
    export class SkinnedMeshBatchRenderer extends SkinnedMeshRenderer {
        /**
         * @en Size of the generated texture atlas.
         * @zh 合图生成的最终图集的边长。
         */
        atlasSize: number;
        /**
         * @en
         * Texture properties that will be actually using the generated atlas.<br>
         * The first unit's texture will be used if not specified.
         * @zh
         * 材质中真正参与合图的贴图属性，不参与的属性统一使用第一个 unit 的贴图。
         */
        batchableTextureNames: string[];
        /**
         * @en Source skinning model components, containing all the data to be batched.
         * @zh 合批前的子蒙皮模型数组，最主要的数据来源。
         */
        units: SkinnedMeshUnit[];
        constructor();
        get mesh(): Mesh | null;
        set mesh(val: Mesh | null);
        get skeleton(): Skeleton | null;
        set skeleton(val: Skeleton | null);
        onLoad(): void;
        onDestroy(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _onMaterialModified(idx: number, material: Material | null): void;
        cook(): void;
        cookMaterials(): void;
        cookSkeletons(): void;
        cookMeshes(): void;
        protected cookTextures(target: Texture2D, prop: string, passIdx: number): void;
        protected createTexture(prop: string): Texture2D;
        protected resizeAtlases(): void;
    }
    export class SkinnedMeshUnit {
        /**
         * @en Skinned mesh of this unit.
         * @zh 子蒙皮模型的网格模型。
         */
        mesh: Mesh | null;
        /**
         * @en Skeleton of this unit.
         * @zh 子蒙皮模型的骨骼。
         */
        skeleton: Skeleton | null;
        /**
         * @en Skinning material of this unit.
         * @zh 子蒙皮模型使用的材质。
         */
        material: Material | null;
        /**
         * @en Local transform matrix
         * @zh 本地变换矩阵
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _localTransform: math.Mat4;
        /**
         * @en UV offset on texture atlas.
         * @zh 在图集中的 uv 坐标偏移。
         */
        set offset(offset: math.Vec2);
        get offset(): math.Vec2;
        /**
         * @en UV extent on texture atlas.
         * @zh 在图集中占的 UV 尺寸。
         */
        set size(size: math.Vec2);
        get size(): math.Vec2;
        /**
         * @en Convenient setter, copying all necessary information from target [[SkinnedMeshRenderer]] component.
         * @zh 复制目标 [[SkinnedMeshRenderer]] 的所有属性到本单元，方便快速配置。
         */
        set copyFrom(comp: SkinnedMeshRenderer | null);
        get copyFrom(): SkinnedMeshRenderer | null;
    }
    export class LOD {
        protected _screenUsagePercentage: number;
        protected _renderers: MeshRenderer[];
        constructor();
        /**
         * @en Minimum percentage of screen usage for the current lod in effect, range in [0, 1]
         * @zh 本层级生效时，占用屏幕的最小百分比, 取值范围[0, 1]
         */
        get screenUsagePercentage(): number;
        set screenUsagePercentage(val: number);
        /**
         * @en Get the list of [[MeshRenderer]] used by the current lod.
         * @zh 获取当前lod使用的 [[MeshRenderer]] 列表
         */
        get renderers(): readonly MeshRenderer[];
        /**
         * @en reset _renderers to meshList or [], LODData's model will be reset too.
         * @zh 重置 _renderers 为 meshList或空数组, LODData上的model也会被重置
         */
        set renderers(meshList: readonly MeshRenderer[]);
        /**
         * @en Get the number of LOD.
         * @zh 获取LOD的数量
         */
        get rendererCount(): number;
        /**
         * @en Insert a [[MeshRenderer]] before specific index position.
         * @zh 在指定的数组索引处插入一个[[MeshRenderer]]
         * @param index @en The rendering array is indexed from 0. If - 1 is passed, it will be added to the end of the list.
         * @zh renderers数组从0开始索引，若传递-1将会被添加到列表末尾。
         * @param renderer @en The mesh-renderer object. @zh [[MeshRenderer]] 对象
         * @returns @en The inserted [[MeshRenderer]] @zh 返回被插入的 [[MeshRenderer]] 对象
         */
        insertRenderer(index: number, renderer: MeshRenderer): MeshRenderer;
        /**
         * @en Delete the [[MeshRenderer]] at specific index position.
         * @zh 删除指定索引处的[[MeshRenderer]]
         * @param index @en 0 indexed position in renderer array, when -1 is specified, the last element will be deleted.
         * @zh _renderers从0开始索引，传递-1则最后一个元素会被删除。
         * @returns @en The deleted [[MeshRenderer]], or null if the specified index does not exist. @zh 如果指定索引处的对象存在，返回被删除对象否则返回null。
         */
        deleteRenderer(index: number): MeshRenderer | null;
        /**
         * @en Get the [[MeshRenderer]] at specific index position.
         * @zh 获取指定索引处的[[MeshRenderer]]
         * @param index @en Value range from 0 to _renderers's length. @zh 取值范围是[0, _renderers长度]
         * @return @en Returns the [[MeshRenderer]] at the specified index, or null if the specified index does not exist. @zh 返回指定索引处的对象，若不存在则返回null。
         */
        getRenderer(index: number): MeshRenderer | null;
        /**
         * @en Update the [[MeshRenderer]] at specific index position.
         * @zh 更新指定索引处的 [[MeshRenderer]]
         * @param index @en Value range from 0 to _renderers's length @zh 取值范围是 [0, _renderers数组长度]
         */
        setRenderer(index: number, renderer: MeshRenderer): void;
    }
    export class LODGroup extends Component {
        /**
         * @en Object reference point in local space, e.g. center of the bound volume for all LODs
         */
        protected _localBoundaryCenter: math.Vec3;
        /**
         * @en Object Size in local space, may be auto-calculated value from object bounding box or value from user input.
         */
        protected _objectSize: number;
        /**
         *@en The array of LODs
         */
        protected _LODs: LOD[];
        constructor();
        /**
         * @en Obtain LOD level numbers.
         * @zh 获取LOD层级数
         */
        get lodCount(): number;
        /**
         * @en Set current AABB's size.
         * @zh 设置当前包围盒的大小
         */
        set objectSize(val: number);
        /**
         * @en Get current AABB's size.
         * @zh 获取当前包围盒的大小
         */
        get objectSize(): number;
        /**
         * @en Get LOD array config.
         * @zh 获取 LOD 数组
         */
        get LODs(): readonly LOD[];
        /**
         * @en Reset current LODs to new value.
         * @ 重置 LODs 为当前新设置的值。
         */
        set LODs(valArray: readonly LOD[]);
        /**
         * @en Insert the [[LOD]] at specific index position, [[LOD]] will be inserted to the last position if index less than 0 or greater than lodCount.
         * @zh 在指定索引处插入 [[LOD]], 若索引为负或超过lodCount，则在末尾添加
         * @param index @en location where lod is added. @zh lod被插入的位置
         * @param screenUsagePercentage @en The minimum screen usage percentage that the currently set lod starts to use, range in[0, 1].
         * @zh lod生效时的最低屏幕显示百分比要求，取值范围[0, 1]
         * @param lod @en If this parameter is not set, it will be created by default. @zh 如果参数没传，则内部创建
         * @returns @en The new lod added. @zh 返回被添加的lod
         */
        insertLOD(index: number, screenUsagePercentage?: number, lod?: LOD): LOD;
        /**
         * @en Erase the [[LOD]] at specific index position.
         * @zh 删除指定索引处的 [[LOD]]
         * @param index @en Index of the erased lod, range in [0, lodCount]. @zh 被删除对象索引, 取值范围[0, lodCount]
         * @returns @en Erased lod. @zh 被删除的对象
         */
        eraseLOD(index: number): LOD | null;
        /**
         * @en Get [[LOD]] at specific index position.
         * @zh 获取指定索引处的 [[LOD]]
         * @param index @en Range in [0, lodCount]. @zh 取值范围[0, lodCount]
         * @returns @en Lod at specified index, or null. @zh 返回指定索引的lod或null
         */
        getLOD(index: number): LOD | null;
        /**
         * @en Update the [[LOD]] at specific index position.
         * @zh 更新指定索引处的 [[LOD]]
         * @param index, update lod at specified index.
         * @param lod, the updated lod.
         */
        setLOD(index: number, lod: LOD): void;
        /**
         * @en Recalculate the bounding box, and the interface will recalculate the localBoundaryCenter and objectSize
         * @zh 重新计算包围盒，该接口会更新 localBoundaryCenter 和 objectSize
         */
        recalculateBounds(): void;
        /**
         * @en reset current objectSize to 1, and recalculate screenUsagePercentage.
         * @zh 重置 objectSize 的大小为1，该接口会重新计算 screenUsagePercentage
         */
        resetObjectSize(): void;
        /**
         * @zh 强制使用某一级的LOD
         * @en Force LOD level to use.
         * lodLevel @en The LOD level to use. Passing lodLevel < 0 will return to standard LOD processing. @zh 要使用的LOD层级，为负数时使用标准的处理流程
         */
        forceLOD(lodLevel: number): void;
        /**
         * @en Force multi LOD level to use, This function is only called in editor.<br/>
         * @zh 强制使用某几级的LOD,该接口只会在编辑器下调用。
         * lodIndexArray @en The LOD level array. Passing [] will return to standard LOD processing. @zh 要使用的LOD层级数组，传[]时将使用标准的处理流程。
         */
        forceLODs(lodIndexArray: number[]): void;
        onLoad(): void;
        _onRemove(comp: Component): void;
        onRestore(): void;
        onEnable(): void;
        onDisable(): void;
    }
    export class ReflectionProbe extends Component {
        protected static readonly DEFAULT_CUBE_SIZE: Readonly<math.Vec3>;
        protected static readonly DEFAULT_PLANER_SIZE: Readonly<math.Vec3>;
        protected readonly _lastSize: math.Vec3;
        protected _resolution: number;
        protected _clearFlag: renderer.scene.ProbeClearFlag;
        protected _backgroundColor: math.Color;
        protected _visibility: number;
        protected _probeType: renderer.scene.ProbeType;
        protected _cubemap: TextureCube | null;
        protected readonly _size: math.Vec3;
        protected _sourceCamera: Camera | null;
        protected _probe: renderer.scene.ReflectionProbe | null;
        protected _previewSphere: Node | null;
        protected _previewPlane: Node | null;
        constructor();
        /**
         * @en
         * Gets or sets the size of the box
         * @zh
         * 获取或设置包围盒的大小。
         */
        set size(value: math.Vec3);
        get size(): math.Vec3;
        /**
         * @en Environment reflection or plane reflection.
         * @zh 设置探针类型，环境反射或者平面反射
         */
        set probeType(value: renderer.scene.ProbeType);
        get probeType(): renderer.scene.ProbeType;
        /**
         * @en set render texture size
         * @zh 设置渲染纹理大小
         */
        set resolution(value: number);
        get resolution(): number;
        /**
         * @en Clearing flags of the camera, specifies which part of the framebuffer will be actually cleared every frame.
         * @zh 相机的缓冲清除标志位，指定帧缓冲的哪部分要每帧清除。
         */
        set clearFlag(value: number);
        get clearFlag(): number;
        /**
         * @en Clearing color of the camera.
         * @zh 相机的颜色缓冲默认值。
         */
        set backgroundColor(val: math.Color);
        get backgroundColor(): math.Color;
        /**
         * @en Visibility mask, declaring a set of node layers that will be visible to this camera.
         * @zh 可见性掩码，声明在当前相机中可见的节点层级集合。
         */
        get visibility(): number;
        set visibility(val: number);
        /**
         * @en The camera to render planar reflections, specified by the user
         * @zh 需要渲染平面反射的相机，由用户指定
         */
        set sourceCamera(camera: Camera);
        get sourceCamera(): Camera;
        /**
         * @en fast bake no convolution.
         * @zh 快速烘焙不会进行卷积。
         */
        get fastBake(): boolean;
        set fastBake(val: boolean);
        set cubemap(val: TextureCube | null);
        get cubemap(): TextureCube | null;
        get probe(): renderer.scene.ReflectionProbe;
        /**
         * @en Reflection probe cube mode preview sphere
         * @zh 反射探针cube模式的预览小球
         */
        set previewSphere(val: Node | null);
        get previewSphere(): Node | null;
        /**
         * @en Reflection probe planar mode preview plane
         * @zh 反射探针Planar模式的预览平面
         */
        set previewPlane(val: Node);
        get previewPlane(): Node;
        onLoad(): void;
        onEnable(): void;
        onDisable(): void;
        start(): void;
        onDestroy(): void;
        update(dt: number): void;
        /**
         * @en Clear the baked cubemap.
         * @zh 清除烘焙的cubemap
         */
        clearBakedCubemap(): void;
    }
    /**
     * @en Use Reflection probe
     * @zh 使用反射探针。
     */
    export enum ReflectionProbeType {
        /**
         * @en Use the default skybox.
         * @zh 使用默认天空盒。
         */
        NONE = 0,
        /**
         * @en Cubemap generate by probe.
         * @zh Probe烘焙的cubemap。
         */
        BAKED_CUBEMAP = 1,
        /**
         * @en Realtime planar reflection.
         * @zh 实时平面反射。
         */
        PLANAR_REFLECTION = 2,
        /**
         * @en Mixing between reflection probe.
         * @zh 反射探针之间进行混合。
         */
        BLEND_PROBES = 3,
        /**
         * @en Mixing between reflection probe and skybox.
         * @zh 反射探针之间混合或反射探针和天空盒之间混合。
         */
        BLEND_PROBES_AND_SKYBOX = 4
    }
    /**
     * @zh 动画剪辑表示一段使用动画编辑器编辑的关键帧动画或是外部美术工具生产的骨骼动画。
     * 它的数据主要被分为几层：轨道、关键帧和曲线。
     * @en The animation clip represents a sequence of key frame animation created with the animation editor or skeletal animation other DCC tools.
     * The data is divided in different levels: tracks, key frames, curves.
     */
    export class AnimationClip extends Asset {
        static WrapMode: typeof __private._cocos_animation_types__WrapMode;
        /**
         * @en Crate clip with a set of sprite frames
         * @zh 使用一组序列帧图片来创建动画剪辑
         * @example
         * ```
         * import { AnimationClip } from 'cc';
         * const clip = AnimationClip.createWithSpriteFrames(spriteFrames, 10);
         * ```
         */
        static createWithSpriteFrames(spriteFrames: SpriteFrame[], sample: number): AnimationClip;
        /**
         * @zh 动画帧率，单位为帧/秒。注意此属性仅用于编辑器动画编辑。
         * @en Animation frame rate: frames per second.
         * Note this property is only used for animation editing in Editor.
         */
        sample: number;
        /**
         * @zh 动画的播放速度。
         * @en Animation playback speed.
         */
        speed: number;
        /**
         * @zh 动画的循环模式。
         * @en Animation loop mode.
         */
        wrapMode: __private._cocos_animation_types__WrapMode;
        /**
         * Sets if node TRS curves in this animation can be blended.
         * Normally this flag is enabled for model animation and disabled for other case.
         * @internal This is an internal slot. Never use it in your code.
         */
        enableTrsBlending: boolean;
        /**
         * @zh 动画的周期。
         * @en Animation duration.
         */
        get duration(): number;
        set duration(value: number);
        /**
         * @en
         * Gets the count of tracks this animation owns.
         * @zh
         * 获取此动画中的轨道数量。
         */
        get tracksCount(): number;
        /**
         * @en
         * Gets an iterable to tracks.
         * @zh
         * 获取可用于迭代轨道的对象。
         */
        get tracks(): Iterable<animation.Track>;
        get hash(): number;
        /**
         * @zh 动画包含的事件数据。
         * @en Associated event data.
         */
        get events(): AnimationClip.IEvent[];
        set events(value: AnimationClip.IEvent[]);
        get [exoticAnimationTag](): ExoticAnimation | null;
        set [exoticAnimationTag](value: ExoticAnimation | null);
        /**
         * Gets if this animation clip contains additive animation.
         * @experimental
         */
        get isAdditive_experimental(): boolean;
        /**
         * Accesses the additive animation settings.
         * @internal
         */
        get [additiveSettingsTag](): AnimationClipAdditiveSettings;
        onLoaded(): void;
        /**
         * @en
         * Counts the time range that the tracks within this animation span.
         * @zh
         * 获取此动画所有轨道占据的时间范围。
         * @returns The time range.
         */
        range(): __private._cocos_animation_tracks_utils__Range;
        /**
         * @en
         * Gets the specified track.
         * @zh
         * 获取指定的轨道。
         * @param index Index to the track.
         * @returns The track.
         */
        getTrack(index: number): animation.Track;
        /**
         * @en
         * Adds a track into this animation.
         * @zh
         * 添加一个轨道到此动画中。
         * @param track The track.
         * @returns Index to the track.
         */
        addTrack(track: animation.Track): number;
        /**
         * @en
         * Removes a track from this animation.
         * @zh
         * 移除此动画中的指定轨道。
         * @param index Index to the track.
         */
        removeTrack(index: number): void;
        /**
         * @en
         * Removes all tracks from this animation.
         * @zh
         * 移除此动画的所有轨道。
         */
        clearTracks(): void;
        /**
         * Returns if this clip has any event.
         * @internal Do not use this in your code.
         */
        containsAnyEvent(): boolean;
        /**
         * Creates an event evaluator for this animation.
         * @param targetNode Target node used to fire events.
         * @internal Do not use this in your code.
         */
        createEventEvaluator(targetNode: Node): __private._cocos_animation_animation_clip__EventEvaluator;
        /**
         * Returns if this clip has any embedded player.
         * @internal Do not use this in your code.
         */
        containsAnyEmbeddedPlayer(): boolean;
        /**
         * Creates an embedded player evaluator for this animation.
         * @param targetNode Target node.
         * @internal Do not use this in your code.
         */
        createEmbeddedPlayerEvaluator(targetNode: Node): __private._cocos_animation_animation_clip__EmbeddedPlayerEvaluation;
        /**
         * Creates an evaluator for this animation.
         * @param context The context.
         * @returns The evaluator.
         * @internal Do not use this in your code.
         */
        createEvaluator(context: __private._cocos_animation_animation_clip__AnimationClipEvalContext): __private._cocos_animation_animation_clip__AnimationClipEvaluation;
        destroy(): boolean;
        [__private._cocos_animation_internal_symbols__BAKE_SKELETON_CURVE_SYMBOL](start: number, samples: number, frames: number): __private._cocos_animation_animation_clip__SkeletonAnimationBakeInfo;
        /**
         * Convert all untyped tracks into typed ones and delete the original.
         * @param refine How to decide the type on specified path.
         * @internal DO NOT USE THIS IN YOUR CODE.
         */
        upgradeUntypedTracks(refine: __private._cocos_animation_tracks_untyped_track__UntypedTrackRefine): void;
        /**
         * @internal Export for test.
         */
        [__private._cocos_animation_animation_clip__searchForRootBonePathSymbol](): string;
        /**
         * @zh 曲线可引用的所有时间轴。
         * @en Frame keys referenced by curves.
         * @deprecated Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        get keys(): number[][];
        set keys(value: number[][]);
        /**
         * @zh 此动画包含的所有曲线。
         * @en Curves this animation contains.
         * @deprecated Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        get curves(): AnimationClip._legacy.LegacyClipCurve[];
        set curves(value: AnimationClip._legacy.LegacyClipCurve[]);
        /**
         * @deprecated Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        get commonTargets(): AnimationClip._legacy.LegacyCommonTarget[];
        set commonTargets(value: AnimationClip._legacy.LegacyCommonTarget[]);
        /**
         * @en
         * The animation's data.
         * @zh
         * 此动画的数据。
         * @deprecated Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        get data(): Uint8Array | null;
        /**
         * @deprecated Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        getPropertyCurves(): readonly AnimationClip._legacy.LegacyRuntimeCurve[];
        /**
         * @deprecated Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        get eventGroups(): readonly __private._cocos_animation_animation_clip__IAnimationEventGroup[];
        /**
         * @zh 提交事件数据的修改。
         * 当你修改了 `this.events` 时，必须调用 `this.updateEventDatas()` 使修改生效。
         * @en
         * Commit event data update.
         * You should call this function after you changed the `events` data to take effect.
         * @deprecated Since V3.3. Please Assign to `this.events`.
         */
        updateEventDatas(): void;
        /**
         * @zh 返回本动画是否包含事件数据。
         * @en Returns if this animation contains event data.
         * @protected
         */
        hasEvents(): boolean;
        /**
         * Migrates legacy data into tracks.
         * NOTE: This method tend to be used as internal purpose or patch.
         * DO NOT use it in your code since it might be removed for the future at any time.
         * @internal Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        syncLegacyData(): void;
        /**
         * @internal
         */
        get [embeddedPlayerCountTag](): number;
        /**
         * @internal
         */
        [getEmbeddedPlayersTag](): Iterable<EmbeddedPlayer>;
        /**
         * @internal
         */
        [addEmbeddedPlayerTag](embeddedPlayer: EmbeddedPlayer): void;
        /**
         * @internal
         */
        [removeEmbeddedPlayerTag](embeddedPlayer: EmbeddedPlayer): void;
        /**
         * @internal
         */
        [clearEmbeddedPlayersTag](): void;
        /**
         * @zh 获取此动画剪辑中的辅助曲线数量。
         * @en Gets the count of auxiliary curves within this animation clip.
         */
        get auxiliaryCurveCount_experimental(): number;
        /**
         * @zh 返回此动画剪辑中所有辅助曲线的名称。
         * @en Returns names of all auxiliary curves within this animation clip.
         */
        getAuxiliaryCurveNames_experimental(): readonly string[];
        /**
         * @zh 返回此动画剪辑中是否存在指定的辅助曲线。
         * @en Returns if the specified auxiliary curve exists in this animation clip.
         */
        hasAuxiliaryCurve_experimental(name: string): boolean;
        /**
         * @zh 添加一条辅助曲线。如果已存在同名的辅助曲线，则直接返回。
         * @en Adds an auxiliary curve. Directly return if there is already such named auxiliary curve.
         * @param name @zh 辅助曲线的名称。@en The auxiliary curve's name.
         * @returns @zh 新增或已存在的辅助曲线。 @en The newly created or existing auxiliary curve.
         * @experimental
         */
        addAuxiliaryCurve_experimental(name: string): RealCurve;
        /**
         * @zh 获取指定的辅助曲线。
         * @en Gets the specified auxiliary curve.
         * @param name @zh 辅助曲线的名称。@en The auxiliary curve's name.
         * @returns @zh 指定的辅助曲线。@en The specified auxiliary curve.
         * @experimental
         */
        getAuxiliaryCurve_experimental(name: string): RealCurve;
        /**
         * @zh 重命名指定的辅助曲线。
         * @en Renames the specified auxiliary curve.
         * @param name @zh 要重命名的辅助曲线的名称。@en Name of the auxiliary curve to rename.
         * @param newName @zh 新名称。@en New name.
         */
        renameAuxiliaryCurve_experimental(name: string, newName: string): void;
        /**
         * @zh 移除指定的辅助曲线。
         * @en Removes the specified auxiliary curve.
         * @param name @zh 辅助曲线的名称。@en The auxiliary curve's name.
         * @experimental
         */
        removeAuxiliaryCurve_experimental(name: string): void;
        /**
         * @internal
         */
        _trySyncLegacyData(): void;
    }
    export namespace AnimationClip {
        export interface IEvent {
            frame: number;
            func: string;
            params: string[];
        }
        export namespace _legacy {
            export class AnimationClipLegacyData {
                constructor(duration: number);
                get keys(): number[][];
                set keys(value: number[][]);
                get curves(): LegacyClipCurve[];
                set curves(value: LegacyClipCurve[]);
                get commonTargets(): LegacyCommonTarget[];
                set commonTargets(value: LegacyCommonTarget[]);
                /**
                 * 此动画的数据。
                 */
                get data(): Uint8Array | null;
                getPropertyCurves(): readonly LegacyRuntimeCurve[];
                toTracks(): animation.Track[];
                protected _createPropertyCurves(): void;
            }
            /**
             * Legacy curve uses time based bezier curve interpolation.
             * That's, interpolate time 'x'(time ratio between two frames, eg.[0, 1])
             * and then use the interpolated time to sample curve.
             * Now we need to compute the the end tangent of previous frame and the start tangent of the next frame.
             * @param timeBezierPoints Bezier points used for legacy time interpolation.
             * @param previousTime Time of the previous keyframe.
             * @param previousValue Value of the previous keyframe.
             * @param nextTime Time of the next keyframe.
             * @param nextValue Value of the next keyframe.
             */
            export function timeBezierToTangents(timeBezierPoints: BezierControlPoints, previousTime: number, previousKeyframe: RealKeyframeValue, nextTime: number, nextKeyframe: RealKeyframeValue): void;
            /**
             * 表示曲线值，曲线值可以是任意类型，但必须符合插值方式的要求。
             */
            export type LegacyCurveValue = any;
            /**
             * 表示曲线的目标对象。
             */
            export type LegacyCurveTarget = Record<string, any>;
            /**
             * 内置帧时间渐变方式名称。
             */
            export type LegacyEasingMethodName = keyof (typeof easing);
            /**
             * 帧时间渐变方式。可能为内置帧时间渐变方式的名称或贝塞尔控制点。
             */
            export type LegacyEasingMethod = LegacyEasingMethodName | BezierControlPoints;
            export type LegacyCompressedEasingMethods = Record<number, LegacyEasingMethod>;
            export type LegacyLerpFunction<T = any> = (from: T, to: T, t: number, dt: number) => T;
            export interface LegacyClipCurveData {
                /**
                 * 曲线使用的时间轴。
                 * @see {AnimationClip.keys}
                 */
                keys: number;
                /**
                 * 曲线值。曲线值的数量应和 `keys` 所引用时间轴的帧数相同。
                 */
                values: LegacyCurveValue[];
                /**
                 * 曲线任意两帧时间的渐变方式。仅当 `easingMethods === undefined` 时本字段才生效。
                 */
                easingMethod?: LegacyEasingMethod;
                /**
                 * 描述了每一帧时间到下一帧时间之间的渐变方式。
                 */
                easingMethods?: LegacyEasingMethod[] | LegacyCompressedEasingMethods;
                /**
                 * 是否进行插值。
                 * @default true
                 */
                interpolate?: boolean;
                /**
                 * For internal usage only.
                 */
                _arrayLength?: number;
            }
            export interface LegacyClipCurve {
                commonTarget?: number;
                modifiers: animation.TargetPath[];
                valueAdapter?: animation.IValueProxyFactory;
                data: LegacyClipCurveData;
            }
            export interface LegacyCommonTarget {
                modifiers: animation.TargetPath[];
                valueAdapter?: animation.IValueProxyFactory;
            }
            export type LegacyMaybeCompactCurve = Omit<LegacyClipCurve, "data"> & {
                data: Omit<LegacyClipCurveData, "values"> & {
                    values: any[] | CompactValueTypeArray;
                };
            };
            export type LegacyMaybeCompactKeys = Array<number[] | CompactValueTypeArray>;
            export type LegacyRuntimeCurve = Pick<LegacyClipCurve, "modifiers" | "valueAdapter" | "commonTarget"> & {
                /**
                 * 属性曲线。
                 */
                curve: AnimCurve;
                /**
                 * 曲线采样器。
                 */
                sampler: RatioSampler | null;
            };
            export interface LegacyObjectCurveData {
                [propertyName: string]: LegacyClipCurveData;
            }
            export interface LegacyComponentsCurveData {
                [componentName: string]: LegacyObjectCurveData;
            }
            export interface LegacyNodeCurveData {
                props?: LegacyObjectCurveData;
                comps?: LegacyComponentsCurveData;
            }
        }
        export type WrapMode = __private._cocos_animation_animation_clip__WrapMode_;
    }
    /**
     * @en
     * The AnimationState gives full control over animation playback process.
     * In most cases the Animation Component is sufficient and easier to use. Use the AnimationState if you need full control.
     * @zh
     * AnimationState 完全控制动画播放过程。<br/>
     * 大多数情况下 动画组件 是足够和易于使用的。如果您需要更多的动画控制接口，请使用 AnimationState。
     *
     */
    export class AnimationState extends __private._cocos_animation_playable__Playable {
        /**
         * @en The clip that is being played by this animation state.
         * @zh 此动画状态正在播放的剪辑。
         */
        get clip(): AnimationClip;
        /**
         * @en The name of the playing animation.
         * @zh 动画的名字。
         */
        get name(): string;
        get length(): number;
        /**
         * @en
         * Wrapping mode of the playing animation.
         * Notice : dynamic change wrapMode will reset time and repeatCount property
         * @zh
         * 动画循环方式。
         * 需要注意的是，动态修改 wrapMode 时，会重置 time 以及 repeatCount。
         * @default: WrapMode.Normal
         */
        get wrapMode(): __private._cocos_animation_types__WrapMode;
        set wrapMode(value: __private._cocos_animation_types__WrapMode);
        /**
         * @en The animation's iteration count property.
         *
         * A real number greater than or equal to zero (including positive infinity) representing the number of times
         * to repeat the animation node.
         *
         * Values less than zero and NaN values are treated as the value 1.0 for the purpose of timing model
         * calculations.
         *
         * @zh 迭代次数，指动画播放多少次后结束, normalize time。 如 2.5（2次半）。
         *
         * @default 1
         */
        get repeatCount(): number;
        set repeatCount(value: number);
        /**
         * @en The start delay which represents the number of seconds from an animation's start time to the start of
         * the active interval.
         * @zh 延迟多少秒播放。
         * @default 0
         */
        get delay(): number;
        set delay(value: number);
        /**
         * @en The iteration duration of this animation in seconds. (length)
         * @zh 单次动画的持续时间，秒。（动画长度）
         * @readOnly
         */
        duration: number;
        /**
         * @en
         * Gets or sets the playback range.
         * The `min` and `max` field of the range are measured in seconds.
         * While setting, the range object should be a valid range.
         * The actual playback range would be the inclusion of this field and [0, duration].
         * Set this field would reset the accumulated play time.
         * If `min === max`, the animation always play at `min`.
         * @zh
         * 获取或设置播放范围。
         * 范围的 `min`、`max` 字段都是以秒为单位的。
         * 设置时，应当指定一个有效的范围；实际的播放范围是该字段和 [0, 周期] 之间的交集。
         * 设置播放范围时将重置累计播放时间。
         * 如果 `min === max`，该动画将一直在 `min` 处播放。
         */
        get playbackRange(): Readonly<{
            min: number;
            max: number;
        }>;
        set playbackRange(value: Readonly<{
            min: number;
            max: number;
        }>);
        /**
         * @en The animation's playback speed. 1 is normal playback speed.
         * @zh 播放速率。
         * @default: 1.0
         */
        get speed(): number;
        set speed(value: number);
        /**
         * @en The current accumulated time of this animation in seconds.
         * @zh 动画当前**累计播放**的时间，单位为秒。
         * @default 0
         */
        time: number;
        /**
         * @en Gets the time progress, in seconds.
         * @zh 获取动画的时间进度，单位为秒。
         */
        get current(): number;
        /**
         * @en Gets the playback ratio.
         * @zh 获取动画播放的比例时间。
         */
        get ratio(): number;
        /**
         * @en
         * The weight of this animation state.
         * @zh
         * 此动画状态的权重。
         */
        get weight(): number;
        set weight(value: number);
        frameRate: number;
        /**
         * @internal This field is only visible from within internal.
         */
        protected _targetNode: Node | null;
        /**
         * @internal This field is only visible from within internal.
         */
        protected _curveLoaded: boolean;
        /**
         * @internal For internal usage. Really hack...
         */
        protected _doNotCreateEval: boolean;
        constructor(clip: AnimationClip, name?: string);
        /**
         * This method is used for internal purpose only.
         */
        get curveLoaded(): boolean;
        initialize(root: Node, blendStateBuffer?: __private._cocos_3d_skeletal_animation_skeletal_animation_blending__BlendStateBuffer, mask?: AnimationMask): void;
        destroy(): void;
        /**
         * @deprecated Since V1.1.1, animation states were no longer defined as event targets.
         * To process animation events, use `Animation` instead.
         */
        emit(...args: any[]): void;
        /**
         * @deprecated Since V1.1.1, animation states were no longer defined as event targets.
         * To process animation events, use `Animation` instead.
         */
        on(type: string, callback: Function, target?: any): void | null;
        /**
         * @deprecated Since V1.1.1, animation states were no longer defined as event targets.
         * To process animation events, use `Animation` instead.
         */
        once(type: string, callback: Function, target?: any): void | null;
        /**
         * @deprecated Since V1.1.1, animation states were no longer defined as event targets.
         * To process animation events, use `Animation` instead.
         */
        off(type: string, callback: Function, target?: any): void;
        /**
         * @zh
         * 是否允许触发 `LastFrame` 事件。
         * 该方法仅用作内部用途。
         * @en
         * Whether `LastFrame` should be triggered.
         * @param allowed True if the last frame events may be triggered.
         * This method is only used for internal purpose only.
         */
        allowLastFrameEvent(allowed: boolean): void;
        /**
         * This method is used for internal purpose only.
         * @internal
         */
        _setEventTarget(target: any): void;
        setTime(time: number): void;
        update(delta: number): void;
        sample(): __private._cocos_animation_types__WrappedInfo;
        protected onPlay(): void;
        protected onStop(): void;
        protected onResume(): void;
        protected onPause(): void;
        /**
         * @internal
         */
        protected _sampleCurves(time: number): void;
    }
    /**
     * @en
     * Animation component governs a group of animation states to control playback of the states.
     * For convenient, it stores a group of animation clips.
     * Each of those clips would have an associated animation state uniquely created.
     * Animation component is eventful, it dispatch a serials playback status events.
     * See [[EventType]].
     * @zh
     * 动画组件管理一组动画状态，控制它们的播放。
     * 为了方便，动画组件还存储了一组动画剪辑。
     * 每个剪辑都会独自创建一个关联的动画状态对象。
     * 动画组件具有事件特性，它会派发一系列播放状态相关的事件。
     * 参考 [[EventType]]
     */
    export class Animation extends __private._cocos_animation_animation_component__Animation_base {
        /**
         * @en
         * Gets or sets clips this component governs.
         * When set, associated animation state of each existing clip will be stopped.
         * If the existing default clip is not in the set of new clips, default clip will be reset to null.
         * @zh
         * 获取或设置此组件管理的剪辑。
         * 设置时，已有剪辑关联的动画状态将被停止；若默认剪辑不在新的动画剪辑中，将被重置为空。
         */
        get clips(): (AnimationClip | null)[];
        set clips(value: (AnimationClip | null)[]);
        /**
         * @en
         * Gets or sets the default clip.
         * Two clips that both have same non-empty UUID are treat as equivalent.
         * @zh
         * 获取或设置默认剪辑。
         * 设置时，若指定的剪辑不在 `this.clips` 中则会被自动添加至 `this.clips`。
         * 具有相同的非空 UUID 的两个动画剪辑将被视为是相同的。
         * @see [[playOnLoad]]
         */
        get defaultClip(): AnimationClip | null;
        set defaultClip(value: AnimationClip | null);
        static EventType: typeof __private._cocos_animation_animation_state__AnimationStateEventType;
        /**
         * @en
         * Whether the default clip should get into playing when this components starts.
         * Note, this field takes no effect if `crossFade()` or `play()` has been called before this component starts.
         * @zh
         * 是否在组件开始运行时自动播放默认剪辑。
         * 注意，若在组件开始运行前调用了 `crossFade` 或 `play()`，此字段将不会生效。
         */
        playOnLoad: boolean;
        /**
         * @internal
         */
        protected _crossFade: __private._cocos_animation_cross_fade__CrossFade;
        /**
         * @internal
         */
        protected _nameToState: Record<string, AnimationState>;
        /**
         * @internal
         */
        protected _clips: (AnimationClip | null)[];
        /**
         * @internal
         */
        protected _defaultClip: AnimationClip | null;
        onLoad(): void;
        start(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en
         * Switch to play specified animation state, without fading.
         * @zh
         * 立即切换到指定动画状态。
         * @param name The name of the animation to be played, if absent, the default clip will be played
         */
        play(name?: string): void;
        /**
         * @en
         * Smoothly switch to play specified animation state.
         * @zh
         * 平滑地切换到指定动画状态。
         * @param name The name of the animation to switch to
         * @param duration The duration of the cross fade, default value is 0.3s
         */
        crossFade(name: string, duration?: number): void;
        /**
         * @en
         * Pause all animation states and all switching.
         * @zh
         * 暂停所有动画状态，并暂停所有切换。
         */
        pause(): void;
        /**
         * @en
         * Resume all animation states and all switching.
         * @zh
         * 恢复所有动画状态，并恢复所有切换。
         */
        resume(): void;
        /**
         * @en
         * Stop all animation states and all switching.
         * @zh
         * 停止所有动画状态，并停止所有切换。
         */
        stop(): void;
        /**
         * @en
         * Get specified animation state.
         * @zh
         * 获取指定的动画状态。
         * @param name The name of the animation
         * @returns If no animation found, return null, otherwise the correspond animation state is returned
         */
        getState(name: string): AnimationState;
        /**
         * @en
         * Creates a state for specified clip.
         * If there is already a clip with same name, the existing animation state will be stopped and overridden.
         * @zh
         * 使用指定的动画剪辑创建一个动画状态。
         * 若指定名称的动画状态已存在，已存在的动画状态将先被设为停止并被覆盖。
         * @param clip The animation clip
         * @param name The animation state name, if absent, the default clip's name will be used
         * @returns The animation state created
         */
        createState(clip: AnimationClip, name?: string): AnimationState;
        /**
         * @en
         * Stops and removes specified clip.
         * @zh
         * 停止并移除指定的动画状态。
         * @param name The name of the animation state
         */
        removeState(name: string): void;
        /**
         * @zh
         * 添加一个动画剪辑到 `this.clips`中并以此剪辑创建动画状态。
         * @en
         * Adds an animation clip into this component and creates a animation state for this clip.
         * @param clip The animation clip
         * @param name The animation state name, if absent, the default clip's name will be used
         * @returns The created animation state
         */
        addClip(clip: AnimationClip, name?: string): AnimationState;
        /**
         * @en
         * Remove clip from the animation list. This will remove the clip and any animation states based on it.<br>
         * If there are animation states depend on the clip are playing or clip is defaultClip, it will not delete the clip.<br>
         * But if force is true, then will always remove the clip and any animation states based on it. If clip is defaultClip,
         * defaultClip will be reset to null
         * @zh
         * 从动画列表中移除指定的动画剪辑，<br/>
         * 如果依赖于 clip 的 AnimationState 正在播放或者 clip 是 defaultClip 的话，默认是不会删除 clip 的。<br/>
         * 但是如果 force 参数为 true，则会强制停止该动画，然后移除该动画剪辑和相关的动画。这时候如果 clip 是 defaultClip，defaultClip 将会被重置为 null。<br/>
         * @param force - If force is true, then will always remove the clip and any animation states based on it.
         */
        removeClip(clip: AnimationClip, force?: boolean): void;
        /**
         * @en
         * Register animation event callback.<bg>
         * The event arguments will provide the AnimationState which emit the event.<bg>
         * When play an animation, will auto register the event callback to the AnimationState,<bg>
         * and unregister the event callback from the AnimationState when animation stopped.
         * @zh
         * 注册动画事件回调。<bg>
         * 回调的事件里将会附上发送事件的 AnimationState。<bg>
         * 当播放一个动画时，会自动将事件注册到对应的 AnimationState 上，停止播放时会将事件从这个 AnimationState 上取消注册。
         * @param type The event type to listen to
         * @param callback The callback when event triggered
         * @param target The callee when invoke the callback, could be absent
         * @return The registered callback
         * @example
         * ```ts
         * onPlay: function (type, state) {
         *     // callback
         * }
         *
         * // register event to all animation
         * animation.on('play', this.onPlay, this);
         * ```
         */
        on<TFunction extends (...any: any[]) => void>(type: __private._cocos_animation_animation_state__AnimationStateEventType, callback: TFunction, thisArg?: any, once?: boolean): TFunction;
        once<TFunction extends (...any: any[]) => void>(type: __private._cocos_animation_animation_state__AnimationStateEventType, callback: TFunction, thisArg?: any): TFunction;
        /**
         * @en
         * Unregister animation event callback.
         * @zh
         * 取消注册动画事件回调。
         * @param {String} type The event type to unregister
         * @param {Function} callback The callback to unregister
         * @param {Object} target The callee of the callback, could be absent
         * @example
         * ```ts
         * // unregister event to all animation
         * animation.off('play', this.onPlay, this);
         * ```
         */
        off(type: __private._cocos_animation_animation_state__AnimationStateEventType, callback?: (...any: any[]) => void, thisArg?: any): void;
        /**
         * @internal
         */
        protected _createState(clip: AnimationClip, name?: string): AnimationState;
        /**
         * @internal
         */
        protected _doCreateState(clip: AnimationClip, name: string): AnimationState;
        /**
         * @internal This method only friends to skeletal animation component.
         */
        protected doPlayOrCrossFade(state: AnimationState, duration: number): void;
    }
    export namespace Animation {
        export type EventType = __private._cocos_animation_animation_component__EventType_;
    }
    export namespace animation {
        /**
         * @en
         * Represents variable's value.
         * @zh
         * 表示变量的值。
         */
        export type Value_experimental = Value | Readonly<math.Vec3> | Readonly<math.Quat>;
        /**
         * @en
         * Represents animation graph variable types.
         * @zh
         * 表示动画图变量的类型。
         */
        export enum VariableType {
            /**
             * @en
             * A floating.
             * @zh
             * 浮点数。
             */
            FLOAT = 0,
            /**
             * @en
             * A boolean.
             * @zh
             * 布尔值。
             */
            BOOLEAN = 1,
            /**
             * @en
             * A trigger.
             * @zh
             * 触发器。
             */
            TRIGGER = 2,
            /**
             * @en
             * An integer.
             * @zh
             * 整数。
             */
            INTEGER = 3,
            /**
             * @zh
             * 三维向量。
             * @en
             * Vector 3d.
             */
            VEC3_experimental = 4,
            /**
             * @zh
             * 四元数。
             * @en
             * Quaternion.
             */
            QUAT_experimental = 5
        }
        /**
         * @en
         * Value proxy factory for setting uniform on material target.
         * @zh
         * 用于设置材质目标上指定 Uniform 的曲线值代理工厂。
         */
        export class UniformProxyFactory implements IValueProxyFactory {
            /**
             * @en Pass index.
             * @zh Pass 索引。
             */
            passIndex: number;
            /**
             * @en Uniform name.
             * @zh Uniform 名称。
             */
            uniformName: string;
            /**
             * @en
             * Specify the aimed channel of the uniform.
             * Use this when you're aiming at a single channel of the uniform instead of who uniform.
             * For example, only green(1) channel of a color uniform.
             * @zh
             * 指定目标 Uniform 的通道。
             * 当你希望设置 Uniform 单独的通道而非整个 Uniform 时应该当使用此字段。
             * 例如，仅设置颜色 Uniform 的红色通道。
             */
            channelIndex: number | undefined;
            constructor(uniformName?: string, passIndex?: number);
            forTarget(target: unknown): IValueProxy | undefined;
        }
        /**
         * @en
         * Value proxy factory for setting morph weights of specified sub-mesh on model component target.
         * @zh
         * 用于设置模型组件目标上指定子网格的指定形状的形变权重的曲线值代理工厂。
         */
        export class MorphWeightValueProxy implements IValueProxyFactory {
            /**
             * @en Sub mesh index.
             * @zh 子网格索引。
             */
            subMeshIndex: number;
            /**
             * @en Shape Index.
             * @zh 形状索引。
             */
            shapeIndex: number;
            forTarget(target: MeshRenderer): {
                set: (value: number) => void;
            };
        }
        /**
         * @en
         * Value proxy factory for setting morph weights of specified sub-mesh on model component target.
         * @zh
         * 用于设置模型组件目标上指定子网格形变权重的曲线值代理工厂。
         */
        export class MorphWeightsValueProxy implements IValueProxyFactory {
            /**
             * @en Sub-mesh index.
             * @zh 子网格索引。
             */
            subMeshIndex: number;
            forTarget(target: MeshRenderer): {
                set: (value: number[]) => void;
            };
        }
        /**
         * @en
         * Value proxy factory for setting morph weights of each sub-mesh on model component target.
         * @zh
         * 用于设置模型组件目标上所有子网格形变权重的曲线值代理工厂。
         */
        export class MorphWeightsAllValueProxy implements IValueProxyFactory {
            forTarget(target: MeshRenderer): {
                set: (value: number[]) => void;
            };
        }
        /**
         * @en
         * A track describes how to trace the target and how to animate it.
         * It's the basic unit of animation clip.
         * @zh
         * 轨道描述了动画目标的路径和动画的方式。它是动画剪辑的基础单元。
         */
        export abstract class Track {
            /**
             * @en Track path.
             * @zh 轨道路径。
             */
            get path(): Readonly<TrackPath>;
            set path(value: Readonly<TrackPath>);
            /**
             * @en Value proxy for the target.
             * @zh 目标的值代理。
             */
            get proxy(): IValueProxyFactory | undefined;
            set proxy(value: IValueProxyFactory | undefined);
            /**
             * @internal
             */
            get [__private._cocos_animation_tracks_track__trackBindingTag](): __private._cocos_animation_tracks_track__TrackBinding;
            /**
             * @en Channels on this track.
             * @zh 此轨道上的通道。
             * @returns Iterator to the channels.
             */
            channels(): Iterable<__private._cocos_animation_tracks_track__Channel>;
            /**
             * @en Time range of this track.
             * @zh 此轨道的时间范围。
             * @returns The time range.
             */
            range(): __private._cocos_animation_tracks_utils__Range;
            /**
             * @internal
             */
            abstract [__private._cocos_animation_define__createEvalSymbol](): __private._cocos_animation_tracks_track__TrackEval<any>;
        }
        /**
         * @en Describes how to find the animation target.
         * @zh 描述怎样寻址动画目标。
         */
        export class TrackPath {
            /**
             * @en The length of the path.
             * @zh 此路径的段数。
             */
            get length(): number;
            /**
             * @en Appends a property path.
             * @zh 附加一段属性路径。
             * @param name The property's name.
             * @returns `this`
             */
            toProperty(name: string): TrackPath;
            /**
             * @en Appends an array element path.
             * @zh 附加一段数组元素路径。
             * @param index The element's index.
             * @returns `this`
             */
            toElement(index: number): TrackPath;
            /**
             * @en Appends a hierarchy path.
             * @zh 附加一段层级路径。
             * @param nodePath Path to the children.
             * @returns `this`
             */
            toHierarchy(nodePath: string): TrackPath;
            /**
             * @en Appends a component path.
             * @zh 附加一段组件路径。
             * @param constructor @en The constructor of the component. @zh 组件的构造函数。
             * @returns `this`
             */
            toComponent<T extends Component>(constructor: __private.__types_globals__Constructor<T> | string): TrackPath;
            /**
             * @internal Reserved for backward compatibility. DO NOT USE IT IN YOUR CODE.
             */
            toCustomized(resolver: __private._cocos_animation_tracks_track__CustomizedTrackPathResolver): TrackPath;
            /**
             * @en Appends paths to this path.
             * @zh 附加指定路径到此路径后。
             * @param trackPaths Paths to append.
             * @returns `this`.
             */
            append(...trackPaths: TrackPath[]): TrackPath;
            /**
             * @zh 判断指定路径段是否是属性路径。
             * @en Decides if the specific path segment is property path.
             * @param index Index to the segment。
             * @returns The judgement result.
             */
            isPropertyAt(index: number): boolean;
            /**
             * @zh 将指定路径段视为属性路径，获取其描述的属性。
             * @en Treats the path segment as a property path. Obtains the property it describes.
             * @param index Index to the segment。
             * @returns The property.
             */
            parsePropertyAt(index: number): string;
            /**
             * @zh 判断指定路径段是否是数组元素路径。
             * @en Decides if the specific path segment is an array element path.
             * @param index Index to the segment。
             * @returns The judgement result.
             */
            isElementAt(index: number): boolean;
            /**
             * @zh 将指定路径段视为数组元素路径，获取其描述的数组元素。
             * @en Treats the path segment as an array element path. Obtains the element index it describes.
             * @param index Index to the segment。
             * @returns The element index.
             */
            parseElementAt(index: number): number;
            /**
             * @zh 判断指定路径段是否是层级路径。
             * @en Decides if the specific path segment is a hierarchy path.
             * @param index Index to the segment。
             * @returns The judgement result.
             */
            isHierarchyAt(index: number): boolean;
            /**
             * @zh 将指定路径段视为层级路径，获取其描述的层级路径。
             * @en Treats the path segment as a hierarchy path. Obtains the hierarchy path it describes.
             * @param index Index to the segment。
             * @returns The hierarchy path.
             */
            parseHierarchyAt(index: number): string;
            /**
             * @zh 判断指定路径段是否是组件路径。
             * @en Decides if the specific path segment is a component path.
             * @param index Index to the segment。
             * @returns The judgement result.
             */
            isComponentAt(index: number): boolean;
            /**
             * @zh 将指定路径段视为组件路径，获取其描述的组件路径。
             * @en Treats the path segment as a hierarchy path. Obtains the component path it describes.
             * @param index Index to the segment。
             * @returns The component path.
             */
            parseComponentAt(index: number): string;
            /**
             * @en Slices a interval of the path.
             * @zh 分割指定区段上的路径。
             * @param beginIndex Begin index to the segment. Default to 0.
             * @param endIndex End index to the segment. Default to the last segment.
             * @returns The new path.
             */
            slice(beginIndex?: number, endIndex?: number): TrackPath;
            /**
             * @internal
             */
            trace(object: unknown, beginIndex?: number, endIndex?: number): unknown;
            /**
             * @internal
             */
            [__private._cocos_animation_tracks_track__parseTrsPathTag](): {
                node: string;
                property: "position" | "scale" | "rotation" | "eulerAngles";
            } | null;
            /**
             * @internal
             */
            [__private._cocos_animation_tracks_track__normalizedFollowTag](root: unknown, beginIndex: number, endIndex: number): unknown;
        }
        /**
         * @en
         * A real track animates a scalar attribute of target.
         * @zh
         * 实数轨道描述目标上某个标量属性的动画。
         */
        export class RealTrack extends __private._cocos_animation_tracks_track__SingleChannelTrack<RealCurve> {
            /**
             * @internal
             */
            protected createCurve(): RealCurve;
        }
        /**
         * @en
         * A vector track animates a vector(in 2, 3, 4 dimension) attribute of target.
         * @zh
         * 向量轨道描述目标上某个（二、三、四维）向量属性的动画。
         */
        export class VectorTrack extends Track {
            constructor();
            /**
             * @en Gets or sets the count of components(dimension) available while evaluating of this track.
             * @zh 获取或设置此轨道在求值时有效的分量数（维度）。
             */
            get componentsCount(): number;
            set componentsCount(value: number);
            /**
             * @en The four channel of the track.
             * @zh 返回此轨道的四条通道。
             * @returns An readonly four length array in which
             * the element at n denotes the channel of n-th vector component.
             */
            channels(): [
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel
            ];
            /**
             * @internal
             */
            [__private._cocos_animation_define__createEvalSymbol](): __private._cocos_animation_tracks_vector_track__Vec2TrackEval | __private._cocos_animation_tracks_vector_track__Vec3TrackEval | __private._cocos_animation_tracks_vector_track__Vec4TrackEval;
        }
        /**
         * @en
         * A quaternion track animates a quaternion(rotation) attribute of target.
         * @zh
         * 四元数轨道描述目标上某个四元数（旋转）属性的动画。
         */
        export class QuatTrack extends __private._cocos_animation_tracks_track__SingleChannelTrack<QuatCurve> {
            /**
             * @internal
             */
            protected createCurve(): QuatCurve;
            /**
             * @internal
             */
            [__private._cocos_animation_define__createEvalSymbol](): __private._cocos_animation_tracks_quat_track__QuatTrackEval;
        }
        /**
         * @en
         * A color track animates a color attribute of target.
         * @zh
         * 颜色轨道描述目标上某个颜色属性的动画。
         */
        export class ColorTrack extends Track {
            constructor();
            /**
             * @en The four channel of the track.
             * @zh 返回此轨道的四条通道。
             * @returns An readonly four length array in which
             * the element at n denotes the channel of n-th(in order of RGBA) color component(in form of integer within 0-255).
             */
            channels(): [
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel
            ];
            /**
             * @internal
             */
            [__private._cocos_animation_define__createEvalSymbol](): __private._cocos_animation_tracks_color_track__ColorTrackEval;
        }
        /**
         * @en
         * A size track animates a size attribute of target.
         * @zh
         * 尺寸轨道描述目标上某个尺寸属性的动画。
         */
        export class SizeTrack extends Track {
            constructor();
            /**
             * @en The width channel and the height channel of the track.
             * @zh 返回此轨道的宽度通道和高度通道。
             * @returns An readonly array in which
             * the first element is the width channel and the second element is the height channel.
             */
            channels(): [
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel
            ];
            /**
             * @internal
             */
            [__private._cocos_animation_define__createEvalSymbol](): __private._cocos_animation_tracks_size_track__SizeTrackEval;
        }
        /**
         * @en
         * An object track animates an object of attribute of target.
         * @zh
         * 对象轨道描述目标上某个对象类型的属性的动画。
         */
        export class ObjectTrack<T> extends __private._cocos_animation_tracks_track__SingleChannelTrack<ObjectCurve<T>> {
            /**
             * @internal
             */
            protected createCurve(): ObjectCurve<T>;
        }
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export function isPropertyPath(path: TargetPath): path is PropertyPath;
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export function isCustomPath<T extends ICustomTargetPath>(path: TargetPath, constructor: __private.__types_globals__Constructor<T>): path is T;
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export type PropertyPath = string | number;
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export interface ICustomTargetPath {
            /**
             * @en
             * Gets next target from current target.
             * If errors are encountered, `null` should be returned.
             * @zh
             * 从当前目标中获取下一个目标。
             * 若错误发生，应返回 `null`。
             * @param target
             */
            get(target: any): any;
        }
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export type TargetPath = PropertyPath | ICustomTargetPath;
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export class HierarchyPath implements ICustomTargetPath {
            path: string;
            constructor(path?: string);
            get(target: Node): Node | null;
        }
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export class ComponentPath implements ICustomTargetPath {
            component: string;
            constructor(component?: string);
            get(target: Node): Component | null;
        }
        /**
         * @en
         * Value proxies are used to set curve value to target. They are "generalized assignment".
         * Every value proxy associates with a target object.
         * @zh
         * 曲线值代理用来设置曲线值到目标，是广义的赋值。
         * 每个曲线值代理都关联着一个目标对象。
         */
        export interface IValueProxy {
            /**
             * @en
             * Gets the value from the target.
             * This method is used for implementing component-wise animation in certain circumstance.
             * @zh
             * 从目标中获取值。某些情况下可能需要这个接口来实现分量动画。
             */
            get?: () => any;
            /**
             * @en
             * Sets a value.
             * @zh
             * 设置曲线值到目标对象上。
             */
            set: (value: any) => void;
        }
        export interface IValueProxyFactory {
            /**
             * @en
             * Returns a value proxy for specific target.
             * @zh
             * 返回指定目标的曲线值代理。
             * @param target The target acquiring the value proxy.
             * @returns The value proxy, or undefined if the proxy could not be created.
             * In later case, a warn should be given before returning.
             */
            forTarget(target: any): IValueProxy | undefined;
        }
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const CubicSplineVec2Value: __private._cocos_animation_cubic_spline_value__CubicSplineValueConstructor<math.Vec2>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export type CubicSplineVec2Value = __private._cocos_animation_cubic_spline_value__ICubicSplineValue<math.Vec2>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const CubicSplineVec3Value: __private._cocos_animation_cubic_spline_value__CubicSplineValueConstructor<math.Vec3>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export type CubicSplineVec3Value = __private._cocos_animation_cubic_spline_value__ICubicSplineValue<math.Vec3>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const CubicSplineVec4Value: __private._cocos_animation_cubic_spline_value__CubicSplineValueConstructor<math.Vec4>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export type CubicSplineVec4Value = __private._cocos_animation_cubic_spline_value__ICubicSplineValue<math.Vec4>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const CubicSplineQuatValue: __private._cocos_animation_cubic_spline_value__CubicSplineValueConstructor<math.Quat>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export class CubicSplineNumberValue implements __private._cocos_animation_cubic_spline_value__ICubicSplineValue<number> {
            dataPoint: number;
            inTangent: number;
            outTangent: number;
            constructor(dataPoint: number, inTangent: number, outTangent: number);
            lerp(to: CubicSplineNumberValue, t: number, dt: number): number;
            getNoLerp(): number;
        }
        /**
         * @en
         * An opacity type which denotes what the animation graph seems like outside the engine.
         * @zh
         * 一个非透明的类型，它是动画图在引擎外部的表示。
         */
        export interface AnimationGraphRunTime {
            /**
             * @internal
             */
            readonly __brand: "AnimationGraph";
        }
        /**
         * @en
         * An opacity type which denotes what the animation graph variant seems like outside the engine.
         * @zh
         * 一个非透明的类型，它是动画图变体在引擎外部的表示。
         */
        export interface AnimationGraphVariantRunTime {
            /**
             * @internal
             */
            readonly __brand: "AnimationGraphVariant";
        }
        /**
         * @en
         * The animation controller component applies an animation graph
         * to the node which it's attached to.
         * When the controller starts, the animation graph is instantiated.
         * Then you may set variables or query the running statuses of the animation graph instance.
         * @zh
         * 将动画图应用到动画控制器组件所挂载的节点上。
         * 当动画控制器开始运行时，动画图会被实例化。然后便可以设置动画图实例中的变量或者查询动画图的运行状况。
         */
        export class AnimationController extends Component {
            /**
             * @zh
             * 动画控制器所关联的动画图。
             * @en
             * The animation graph associated with the animation controller.
             */
            get graph(): AnimationGraphRunTime | AnimationGraphVariantRunTime | null;
            set graph(value: AnimationGraphRunTime | AnimationGraphVariantRunTime | null);
            /**
             * @zh 获取动画图的层级数量。如果控制器没有指定动画图，则返回 0。
             * @en Gets the count of layers in the animation graph.
             * If no animation graph is specified, 0 is returned.
             */
            get layerCount(): number;
            __preload(): void;
            onDestroy(): void;
            update(deltaTime: number): void;
            /**
             * @zh 获取动画图中的所有变量。
             * @en Gets all the variables in the animation graph.
             * @returns The iterator to the variables.
             * @example
             * ```ts
             * for (const [name, { type }] of animationController.getVariables()) {
             *   log(`Name: ${name}, Type: ${type}`);
             * }
             * ```
             */
            getVariables(): Iterable<readonly [
                string,
                Readonly<{
                    type: VariableType;
                }>
            ]>;
            /**
             * @zh 设置动画图实例中变量的值。
             * @en Sets the value of the variable in the animation graph instance.
             * @param name @en Variable's name. @zh 变量的名称。
             * @param value @en Variable's value. @zh 变量的值。
             * @example
             * ```ts
             * animationController.setValue('speed', 3.14);
             * animationController.setValue('crouching', true);
             * animationController.setValue('attack', true);
             * ```
             */
            setValue(name: string, value: Value): void;
            /**
             * @zh 设置动画图实例中变量的值。
             * @en Sets the value of the variable in the animation graph instance.
             * @param name @en Variable's name. @zh 变量的名称。
             * @param value @en Variable's value. @zh 变量的值。
             * @example
             * ```ts
             * animationController.setValue('speed', 3.14);
             * animationController.setValue('crouching', true);
             * animationController.setValue('attack', true);
             * ```
             * @experimental
             */
            setValue_experimental(name: string, value: Value_experimental): void;
            /**
             * @zh 获取动画图实例中变量的值。
             * @en Gets the value of the variable in the animation graph instance.
             * @param name @en Variable's name. @zh 变量的名称。
             * @returns @en Variable's value. @zh 变量的值。
             */
            getValue(name: string): Value | undefined;
            /**
             * @zh 获取动画图实例中变量的值。
             * @en Gets the value of the variable in the animation graph instance.
             * @param name @en Variable's name. @zh 变量的名称。
             * @returns @en Variable's value. @zh 变量的值。
             */
            getValue_experimental(name: string): Value_experimental | undefined;
            /**
             * @zh 获取动画图实例中当前状态的运行状况。
             * @en Gets the running status of the current state in the animation graph instance.
             * @param layer @en Index of the layer. @zh 层级索引。
             * @returns @en The running status of the current state. `null` is returned if current state is not a motion state.
             *          @zh 当前的状态运作状态对象。如果当前的状态不是动作状态，则返回 `null`。
             */
            getCurrentStateStatus(layer: number): Readonly<MotionStateStatus> | null;
            /**
             * @zh 获取动画图实例中当前状态上包含的所有动画剪辑的运行状况。
             * @en Gets the running status of all the animation clips added on the current state in the animation graph instance.
             * @param layer @en Index of the layer. @zh 层级索引。
             * @returns @en Iterable to the animation clip statuses on current state.
             *              An empty iterable is returned if current state is not a motion state.
             *          @zh 到动画剪辑运作状态的迭代器。若当前状态不是动画状态，则返回一个空的迭代器。
             */
            getCurrentClipStatuses(layer: number): Iterable<Readonly<ClipStatus>>;
            /**
             * @zh 获取动画图实例中当前正在进行的过渡的运行状况。
             * @en Gets the running status of the transition currently in progress in the animation graph instance.
             * @param layer @en Index of the layer. @zh 层级索引。
             * @returns @en Current transition status. `null` is returned in case of no transition.
             *          @zh 当前正在进行的过渡，若没有进行任何过渡，则返回 `null`。
             */
            getCurrentTransition(layer: number): Readonly<TransitionStatus> | null;
            /**
             * @zh 获取动画图实例中下一个状态的运行状况。
             * @en Gets the running status of the next state in the animation graph instance.
             * @param layer @en Index of the layer. @zh 层级索引。
             * @returns @en The running status of the next state. `null` is returned in case of no transition or if next state is not a motion state.
             *          @zh 下一状态运作状态对象，若未在进行过渡或下一状态不是动画状态，则返回 `null`。
             */
            getNextStateStatus(layer: number): Readonly<MotionStateStatus> | null;
            /**
             * @zh 获取动画图实例中下一个状态上添加的所有动画剪辑的运行状况。
             * @en Gets the running status of all the animation clips added on the next state in the animation graph instance.
             * @param layer @en Index of the layer. @zh 层级索引。
             * @returns @en Iterable to the animation clip statuses on next state.
             *              An empty iterable is returned in case of no transition or next state is not a motion state.
             *          @zh 到下一状态上包含的动画剪辑运作状态的迭代器，若未在进行过渡或下一状态不是动画状态，则返回一个空的迭代器。
             */
            getNextClipStatuses(layer: number): Iterable<Readonly<ClipStatus>>;
            /**
             * @zh 获取层级权重。
             * @en Gets the weight of specified layer.
             * @param layer @en Index of the layer. @zh 层级索引。
             */
            getLayerWeight(layer: number): number;
            /**
             * @zh 设置层级权重。
             * @en Sets the weight of specified layer.
             * @param layer @en Index of the layer. @zh 层级索引。
             */
            setLayerWeight(layer: number, weight: number): void;
            /**
             * @zh 覆盖动画图实例中的动画剪辑。
             * 对于每一对源剪辑、目标剪辑，
             * 动画图（实例）中的出现的所有源剪辑都会被替换为目标剪辑，就好像动画图中一开始就使用的是目标剪辑。
             * 不过，动画图当前的运转状态会依然保持不变，例如：
             *
             * - 若动作状态涉及的动画剪辑被替换，动作状态的播放进度百分比依然保持不变。
             *
             * - 若过渡的周期是相对的，即使在某一刻动画过渡的源头被替换，那么过渡的进度百分比也依然保持不变。
             *
             * 不管进行多少次覆盖，源剪辑应该一直指定为原始动画图中的动画剪辑。例如：
             *
             * ```ts
             * // `originalClip` 是原始动画图中的剪辑对象，第一次希望将原剪辑覆盖为 `newClip1`，第二次希望将原剪辑覆盖为 `newClip2`
             * animationController.overrideClips_experimental(new Map([ [originalClip, newClip1] ])); // 第一次覆盖
             * animationController.overrideClips_experimental(new Map([ [newClip1, newClip2] ])); // 错误：第二次覆盖
             * animationController.overrideClips_experimental(new Map([ [originalClip, newClip2] ])); // 正确：第二次覆盖
             * ```
             * @en Overrides the animation clips in animation graph instance.
             * TODO
             * @experimental
             */
            overrideClips_experimental(overrides: ___private._cocos_animation_marionette_clip_overriding__ReadonlyClipOverrideMap): void;
            /**
             * @zh 获取指定辅助曲线的当前值。
             * @en Gets the current value of specified auxiliary curve.
             * @param curveName @en Name of the auxiliary curve. @zh 辅助曲线的名字。
             * @returns @zh 指定辅助曲线的当前值，如果指定辅助曲线不存在或动画图为空则返回 0。
             * @en The current value of specified auxiliary curve,
             * or 0 if specified adjoint curve does not exist or if the animation graph is null.
             * @experimental
             */
            getAuxiliaryCurveValue_experimental(curveName: string): number;
        }
        /**
         * @en
         * Runtime clip status of a motion state.
         * @zh
         * 动作状态中包含的剪辑的运行状态。
         */
        export interface ClipStatus {
            /**
             * @en
             * The clip object.
             * @zh
             * 剪辑对象。
             */
            clip: AnimationClip;
            /**
             * @en
             * The clip's weight.
             * @zh
             * 剪辑的权重。
             */
            weight: number;
        }
        /**
         * @en
         * Runtime status of a transition.
         * @zh
         * 过渡的运行状态。
         */
        export interface TransitionStatus {
            /**
             * @en
             * The duration of the transition.
             * @zh
             * 过渡的周期。
             */
            duration: number;
            /**
             * @en
             * The progress of the transition.
             * @zh
             * 过渡的进度。
             */
            time: number;
        }
        /**
         * @en
         * Runtime status of a motion state.
         * @zh
         * 动作状态的运行状态。
         */
        export interface MotionStateStatus {
            /**
             * For testing.
             * TODO: remove it.
             * @internal
             */
            __DEBUG_ID__?: string;
            /**
             * @en
             * The normalized time of the state.
             * It would be the fraction part of `elapsed-time / duration` if elapsed time is non-negative,
             * and would be 1 plus the fraction part of `(elapsed-time / duration)` otherwise.
             * This is **NOT** the clip's progress if the state is not a clip motion or its wrap mode isn't loop.
             * @zh
             * 状态的规范化时间。
             * 如果流逝的时间是非负的，它就是 `流逝时间 / 周期` 的小数部分；否则，它是 `(流逝时间 / 周期)` 的小数部分加 1。
             * 它并不一定代表剪辑的进度，因为该状态可能并不是一个剪辑动作，或者它的循环模式并非循环。
             */
            progress: number;
        }
        /**
         * @en State machine component.
         * @zh 状态机组件。
         */
        export class StateMachineComponent {
            /**
             * @en
             * Called when a motion state right after it entered.
             * @zh
             * 在刚刚进入动作状态时调用。
             * @param controller The animation controller it within.
             * @param motionStateStatus The status of the motion.
             */
            onMotionStateEnter(controller: AnimationController, motionStateStatus: Readonly<MotionStateStatus>): void;
            /**
             * @en
             * Called when a motion state is going to be exited.
             * @zh
             * 在即将退出动作状态时调用。
             * @param controller The animation controller it within.
             * @param motionStateStatus The status of the motion.
             */
            onMotionStateExit(controller: AnimationController, motionStateStatus: Readonly<MotionStateStatus>): void;
            /**
             * @en
             * Called when a motion state updated except for the first and last frame.
             * @zh
             * 在动作状态更新时调用，但不会在第一次和最后一次时调用。
             * @param controller The animation controller it within.
             * @param motionStateStatus The status of the motion.
             */
            onMotionStateUpdate(controller: AnimationController, motionStateStatus: Readonly<MotionStateStatus>): void;
            /**
             * @en
             * Called when a state machine right after it entered.
             * @zh
             * 在刚刚进入状态机时调用。
             * @param controller The animation controller it within.
             */
            onStateMachineEnter(controller: AnimationController): void;
            /**
             * @en
             * Called when a state machine is going to be exited.
             * @zh
             * 在即将退出状态机时调用。
             * @param controller The animation controller it within.
             */
            onStateMachineExit(controller: AnimationController): void;
        }
        export type Value = number | string | boolean;
    }
    export interface ILerpable {
        /**
         * 在当前曲线值与目标曲线值之间插值。
         * @param to 目标曲线值。
         * @param t 插值比率。
         * @param dt 当前曲线值与目标曲线值的时间间隔，单位为秒。
         * @returns 插值结果。
         */
        lerp(to: any, t: number, dt: number): any;
        /**
         * 当直接使用曲线值作为采样结果时的结果值，它应该等同于插值比率为 0 时的插值结果。
         * @returns 插值比率为 0 时的插值结果。
         */
        getNoLerp?(): any;
    }
    /**
     * @zh
     * 采样动画曲线。
     * @en
     * Samples an animation curve.
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     * @param curve @zh 动画曲线。@en The curve.
     * @param sampler @zh 采样器。@en The sampler.
     * @param ratio @zh 采样比率。@en Sample ratio([0, 1]).
     */
    export function sampleAnimationCurve(curve: AnimCurve, sampler: RatioSampler, ratio: number): any;
    /**
     * @en
     * Compute a new ratio by curve type.
     * @zh
     * 根据曲线类型计算新的比例。
     * @param ratio - The origin ratio
     * @param type - If it's Array, then ratio will be computed with bezierByTime.
     * If it's string, then ratio will be computed with cc.easing function
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export function computeRatioByType(ratio: number, type: AnimationClip._legacy.LegacyEasingMethod): number;
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export class RatioSampler {
        ratios: number[];
        constructor(ratios: number[]);
        sample(ratio: number): number;
    }
    /**
     * @en
     * Animation curve.
     * @zh
     * 动画曲线。
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export class AnimCurve {
        static Linear: null;
        static Bezier(controlPoints: number[]): BezierControlPoints;
        types?: Array<(AnimationClip._legacy.LegacyEasingMethod | null)>;
        type?: AnimationClip._legacy.LegacyEasingMethod | null;
        constructor(propertyCurveData: Omit<AnimationClip._legacy.LegacyClipCurveData, "keys">, duration: number);
        hasLerp(): boolean;
        valueAt(index: number): any;
        valueBetween(ratio: number, from: number, fromRatio: number, to: number, toRatio: number): any;
        empty(): boolean;
        /**
         * Returns if this curve only yields constants.
         */
        constant(): boolean;
    }
    export class EventInfo {
        events: any[];
        /**
         * @param func event function
         * @param params event params
         */
        add(func: string, params: any[]): void;
    }
    export class AnimationManager extends System {
        get blendState(): __private._cocos_3d_skeletal_animation_skeletal_animation_blending__LegacyBlendStateBuffer;
        static ID: string;
        addCrossFade(crossFade: __private._cocos_animation_cross_fade__CrossFade): void;
        removeCrossFade(crossFade: __private._cocos_animation_cross_fade__CrossFade): void;
        update(dt: number): void;
        destruct(): void;
        addAnimation(anim: AnimationState): void;
        removeAnimation(anim: AnimationState): void;
        pushDelayEvent(fn: (...args: any[]) => void, thisArg: any, args: any[]): void;
        addSockets(root: Node, sockets: Socket[]): void;
        removeSockets(root: Node, sockets: Socket[]): void;
    }
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export function getPathFromRoot(target: Node | null, root: Node): string;
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export function getWorldTransformUntilRoot(target: Node, root: Node, outMatrix: math.Mat4): math.Mat4;
    /**
     * @en
     * The audio clip asset.
     * @zh
     * 音频片段资源。
     */
    export class AudioClip extends Asset {
        static AudioType: typeof __private._pal_audio_type__AudioType;
        protected _duration: number;
        protected _loadMode: __private._pal_audio_type__AudioType;
        protected _meta: __private._cocos_audio_audio_clip__AudioMeta | null;
        constructor();
        destroy(): boolean;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        set _nativeAsset(meta: __private._cocos_audio_audio_clip__AudioMeta | null);
        get _nativeAsset(): __private._cocos_audio_audio_clip__AudioMeta | null;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _nativeDep(): {
            uuid: string;
            audioLoadMode: __private._pal_audio_type__AudioType;
            ext: string;
            __isNative__: boolean;
        };
        get loadMode(): __private._pal_audio_type__AudioType;
        validate(): boolean;
        getDuration(): number;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.state instead.
         */
        get state(): __private._pal_audio_type__AudioState;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.getCurrentTime() instead.
         */
        getCurrentTime(): number;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.getVolume() instead.
         */
        getVolume(): number;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.getLoop() instead.
         */
        getLoop(): boolean;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.setCurrentTime() instead.
         */
        setCurrentTime(time: number): void;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.setVolume() instead.
         */
        setVolume(volume: number): void;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.setLoop() instead.
         */
        setLoop(loop: boolean): void;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.play() instead.
         */
        play(): void;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.pause() instead.
         */
        pause(): void;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.stop() instead.
         */
        stop(): void;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.playOneShot() instead.
         */
        playOneShot(volume?: number): void;
    }
    /**
     * @en
     * A representation of a single audio source, <br>
     * contains basic functionalities like play, pause and stop.
     * @zh
     * 音频组件，代表单个音源，提供播放、暂停、停止等基本功能。
     */
    export class AudioSource extends Component {
        static get maxAudioChannel(): number;
        static AudioState: typeof __private._pal_audio_type__AudioState;
        static EventType: typeof __private._cocos_audio_audio_source__AudioSourceEventType;
        protected _clip: AudioClip | null;
        protected _player: __private._pal_audio__AudioPlayer | null;
        protected _loop: boolean;
        protected _playOnAwake: boolean;
        protected _volume: number;
        constructor();
        /**
         * @en
         * The default AudioClip to be played for this audio source.
         * @zh
         * 设定要播放的音频。
         */
        set clip(val: AudioClip | null);
        get clip(): AudioClip | null;
        /**
         * @en
         * Is looping enabled for this audio source?
         * @zh
         * 是否循环播放音频？
         */
        set loop(val: boolean);
        get loop(): boolean;
        /**
         * @en
         * Is the autoplay enabled? <br>
         * Note that for most platform autoplay will only start <br>
         * after a user gesture is received, according to the latest autoplay policy: <br>
         * https://www.chromium.org/audio-video/autoplay
         * @zh
         * 是否启用自动播放。 <br>
         * 请注意，根据最新的自动播放策略，现在对大多数平台，自动播放只会在第一次收到用户输入后生效。 <br>
         * 参考：https://www.chromium.org/audio-video/autoplay
         */
        set playOnAwake(val: boolean);
        get playOnAwake(): boolean;
        /**
         * @en
         * The volume of this audio source (0.0 to 1.0).<br>
         * Note: Volume control may be ineffective on some platforms.
         * @zh
         * 音频的音量（大小范围为 0.0 到 1.0）。<br>
         * 请注意，在某些平台上，音量控制可能不起效。<br>
         */
        set volume(val: number);
        get volume(): number;
        onLoad(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en
         * Get PCM data from specified channel.
         * Currently it is only available in Native platform and Web Audio (including Web and ByteDance platforms).
         *
         * @zh
         * 通过指定的通道获取音频的 PCM data。
         * 目前仅在原生平台和 Web Audio（包括 Web 和 字节平台）中可用。
         *
         * @param channelIndex The channel index. 0 is left channel, 1 is right channel.
         * @returns A Promise to get the PCM data after audio is loaded.
         *
         * @example
         * ```ts
         * audioSource.getPCMData(0).then(dataView => {
         *   if (!dataView)  return;
         *   for (let i = 0; i < dataView.length; ++i) {
         *     console.log('data: ' + dataView.getData(i));
         *   }
         * });
         * ```
         */
        getPCMData(channelIndex: number): Promise<AudioPCMDataView | undefined>;
        /**
         * @en
         * Get the sample rate of audio.
         * Currently it is only available in Native platform and Web Audio (including Web and ByteDance platforms).
         *
         * @zh
         * 获取音频的采样率。
         * 目前仅在原生平台和 Web Audio（包括 Web 和 字节平台）中可用。
         *
         * @returns A Promise to get the sample rate after audio is loaded.
         */
        getSampleRate(): Promise<number>;
        /**
         * @en
         * Play the clip.<br>
         * Restart if already playing.<br>
         * Resume if paused.
         *
         * NOTE: On Web platforms, the Auto Play Policy bans auto playing audios at the first time, because the user gesture is required.
         * there are 2 ways to play audios at the first time:
         * - play audios in the callback of TOUCH_END or MOUSE_UP event
         * - play audios straightly, the engine will auto play audios at the next user gesture.
         *
         * @zh
         * 开始播放。<br>
         * 如果音频处于正在播放状态，将会重新开始播放音频。<br>
         * 如果音频处于暂停状态，则会继续播放音频。
         *
         * 注意:在 Web 平台，Auto Play Policy 禁止首次自动播放音频，因为需要发生用户交互之后才能播放音频。
         * 有两种方式实现音频首次自动播放：
         * - 在 TOUCH_END 或者 MOUSE_UP 的事件回调里播放音频。
         * - 直接播放音频，引擎会在下一次发生用户交互时自动播放。
         */
        play(): void;
        /**
         * @en
         * Pause the clip.
         * @zh
         * 暂停播放。
         */
        pause(): void;
        /**
         * @en
         * Stop the clip.
         * @zh
         * 停止播放。
         */
        stop(): void;
        /**
         * @en
         * Plays an AudioClip, and scales volume by volumeScale. The result volume is `audioSource.volume * volumeScale`. <br>
         * @zh
         * 以指定音量倍数播放一个音频一次。最终播放的音量为 `audioSource.volume * volumeScale`。 <br>
         * @param clip The audio clip to be played.
         * @param volumeScale volume scaling factor wrt. current value.
         */
        playOneShot(clip: AudioClip, volumeScale?: number): void;
        protected _syncStates(): void;
        /**
         * @en
         * Set current playback time, in seconds.
         * @zh
         * 以秒为单位设置当前播放时间。
         * @param num playback time to jump to.
         */
        set currentTime(num: number);
        /**
         * @en
         * Get the current playback time, in seconds.
         * @zh
         * 以秒为单位获取当前播放时间。
         */
        get currentTime(): number;
        /**
         * @en
         * Get the audio duration, in seconds.
         * @zh
         * 获取以秒为单位的音频总时长。
         */
        get duration(): number;
        /**
         * @en
         * Get current audio state.
         * @zh
         * 获取当前音频状态。
         */
        get state(): __private._pal_audio_type__AudioState;
        /**
         * @en
         * Is the audio currently playing?
         * @zh
         * 当前音频是否正在播放？
         */
        get playing(): boolean;
    }
    export class AudioPCMDataView {
        constructor(arrayBufferView: __private._pal_audio_type__AudioBufferView, normalizeFactor: number);
        constructor(arrayBuffer: ArrayBuffer, Ctor: __private.__types_globals__Constructor<__private._pal_audio_type__AudioBufferView>, normalizeFactor: number);
        get length(): number;
        getData(offset: number): number;
    }
    /**
     * @en The root manager of the renderer which manages all device resources and the render pipeline.
     * @zh 基础渲染器管理类，管理所有设备相关的资源创建以及渲染管线。
     */
    export class Root {
        /**
         * @en The GFX device
         * @zh GFX 设备
         */
        get device(): gfx.Device;
        /**
         * @en The main window
         * @zh 主窗口
         */
        get mainWindow(): renderer.RenderWindow | null;
        /**
         * @en The current active window
         * @zh 当前激活的窗口
         */
        set curWindow(window: renderer.RenderWindow | null);
        get curWindow(): renderer.RenderWindow | null;
        /**
         * @e The temporary window for data transmission
         * @zh 临时窗口（用于数据传输）
         * @internal
         */
        set tempWindow(window: renderer.RenderWindow | null);
        get tempWindow(): renderer.RenderWindow | null;
        /**
         * @en The windows list
         * @zh 窗口列表
         */
        get windows(): renderer.RenderWindow[];
        /**
         * @zh
         * 启用自定义渲染管线
         */
        get usesCustomPipeline(): boolean;
        /**
         * @en The render pipeline
         * @zh 渲染管线
         */
        get pipeline(): __private._cocos_rendering_custom_pipeline__PipelineRuntime;
        /**
         * @en The custom render pipeline
         * @zh 自定义渲染管线
         */
        get customPipeline(): rendering.BasicPipeline;
        /**
         * @en The pipeline events
         * @zh 渲染管线事件
         */
        get pipelineEvent(): __private._cocos_rendering_pipeline_event__IPipelineEvent;
        /**
         * @en The draw batch manager for 2D UI, for engine internal usage, user do not need to use this.
         * @zh 2D UI 渲染合批管理器，引擎内部使用，用户无需使用此接口
         */
        get batcher2D(): UI;
        /**
         * @en Render scenes list
         * @zh 渲染场景列表
         */
        get scenes(): renderer.RenderScene[];
        /**
         * @en The debug view manager for rendering
         * @zh 渲染调试管理器
         */
        get debugView(): DebugView;
        /**
         * @en The time cumulated in seconds since the game began running.
         * @zh 累计时间（秒）。
         */
        get cumulativeTime(): number;
        /**
         * @en The current frame time in seconds.
         * @zh 帧时间（秒）。
         */
        get frameTime(): number;
        /**
         * @en The frame count during the last second
         * @zh 一秒内的累计帧数
         */
        get frameCount(): number;
        /**
         * @en The recent frame rate for the last second
         * @zh 当前每秒帧率
         */
        get fps(): number;
        /**
         * @en The wanted frame rate set by user
         * @zh 每秒设定帧率
         */
        set fixedFPS(fps: number);
        get fixedFPS(): number;
        /**
         * @internal
         */
        get dataPoolManager(): __private._cocos_3d_skeletal_animation_data_pool_manager__DataPoolManager;
        /**
         * @en Whether the built-in deferred pipeline is used.
         * @zh 是否启用内置延迟渲染管线
         */
        get useDeferredPipeline(): boolean;
        get cameraList(): renderer.scene.Camera[];
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _createSceneFun: (root: Root) => renderer.RenderScene;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _createWindowFun: (root: Root) => renderer.RenderWindow;
        /**
         * @en The constructor of the root, user shouldn't create the root instance, it's managed by the [[Director]].
         * @zh 构造函数，用户不应该自己创建任何 Root 对象，它是由 [[Director]] 管理的。
         * @param device GFX device
         */
        constructor(device: gfx.Device);
        /**
         * @en The initialization function, user shouldn't initialize the root, it's managed by the [[Director]].
         * @zh 初始化函数，用户不应该自己初始化 Root，它是由 [[Director]] 管理的。
         * @param info Root initialization information
         */
        initialize(info: __private._cocos_root__IRootInfo): void;
        /**
         * @en Destroy the root, user shouldn't invoke this function, it will cause undefined behavior.
         * @zh 销毁 Root，用户不应该调用此方法，会造成未知行为。
         */
        destroy(): void;
        /**
         * @en Resize the on-screen render windows.
         * @zh 重置在屏窗口的大小。
         * @param width The new width of the window.
         * @param height The new height of the window.
         * @param windowId The system window ID, optional for now.
         */
        resize(width: number, height: number, windowId?: number): void;
        /**
         * @en Setup the render pipeline
         * @zh 设置渲染管线
         * @param rppl The render pipeline
         * @returns The setup is successful or not
         */
        setRenderPipeline(useCustomPipeline?: boolean): boolean;
        /**
         * @en Notify the pipeline and all scenes that the global pipeline state have been updated so that they can update their render data and states.
         * @zh 通知渲染管线和所有场景全局管线状态已更新，需要更新自身状态。
         */
        onGlobalPipelineStateChanged(): void;
        /**
         * @en Active the render window as the [[curWindow]]
         * @zh 激活指定窗口为当前窗口 [[curWindow]]
         * @param window The render window to be activated
         */
        activeWindow(window: renderer.RenderWindow): void;
        /**
         * @en Reset the time cumulated
         * @zh 重置累计时间
         */
        resetCumulativeTime(): void;
        /**
         * @en The entry function of the render process for every frame.
         * @zh 用于每帧执行渲染流程的入口函数
         * @param deltaTime @en The delta time since last update. @zh 距离上一帧间隔时间
         */
        frameMove(deltaTime: number): void;
        /**
         * @en Create a render window
         * @zh 创建一个新的窗口
         * @param info @en The window creation information @zh 窗口描述信息
         */
        createWindow(info: __private._cocos_render_scene_core_render_window__IRenderWindowInfo): renderer.RenderWindow | null;
        /**
         * @en Destroy a render window
         * @zh 销毁指定的窗口
         * @param window The render window to be destroyed
         */
        destroyWindow(window: renderer.RenderWindow): void;
        /**
         * @en Destroy all render windows
         * @zh 销毁全部窗口
         */
        destroyWindows(): void;
        /**
         * @en Create a render scene
         * @zh 创建渲染场景
         * @param info @en The creation information for render scene @zh 渲染场景描述信息
         */
        createScene(info: renderer.IRenderSceneInfo): renderer.RenderScene;
        /**
         * @en Destroy the given render scene
         * @zh 销毁指定的渲染场景
         * @param scene @en The render scene to be destroyed. @zh 要销毁的渲染场景
         */
        destroyScene(scene: renderer.RenderScene): void;
        /**
         * @en Destroy all render scenes.
         * @zh 销毁全部场景。
         */
        destroyScenes(): void;
        /**
         * @en Create a model
         * @zh 创建模型
         * @param ModelCtor @en The class of the model @zh 模型的类
         * @returns The model created
         */
        createModel<T extends renderer.scene.Model>(ModelCtor: typeof renderer.scene.Model): T;
        /**
         * @en Destroy the given model
         * @zh 销毁指定的模型
         * @param m @en The model to be destroyed @zh 要销毁的模型
         */
        destroyModel(m: renderer.scene.Model): void;
        /**
         * @en Create a camera
         * @zh 创建一个相机
         * @returns The camera created.
         */
        createCamera(): renderer.scene.Camera;
        /**
         * @en Create a light source
         * @zh 创建光源
         * @param LightCtor @en The class of the light @zh 光源的类
         * @returns The light created
         */
        createLight<T extends renderer.scene.Light>(LightCtor: new () => T): T;
        /**
         * @en Destroy the given light
         * @zh 销毁指定的光源
         * @param l @en The light to be destroyed @zh 要销毁的光源
         */
        destroyLight(l: renderer.scene.Light): void;
        /**
         * @en recycle the given light to light object pool
         * @zh 回收指定的光源到对象池
         * @param l @en The light to be recycled @zh 要回收的光源
         */
        recycleLight(l: renderer.scene.Light): void;
    }
    export namespace gfx {
        /**
         * @en GFX sampler.
         * @zh GFX 采样器。
         */
        export class Sampler extends GFXObject {
            get info(): Readonly<SamplerInfo>;
            get hash(): number;
            protected _info: SamplerInfo;
            protected _hash: number;
            constructor(info: Readonly<SamplerInfo>, hash: number);
            static computeHash(info: Readonly<SamplerInfo>): number;
            static unpackFromHash(hash: number): SamplerInfo;
        }
        export class SamplerInfo {
            minFilter: Filter;
            magFilter: Filter;
            mipFilter: Filter;
            addressU: Address;
            addressV: Address;
            addressW: Address;
            maxAnisotropy: number;
            cmpFunc: ComparisonFunc;
            constructor(minFilter?: Filter, magFilter?: Filter, mipFilter?: Filter, addressU?: Address, addressV?: Address, addressW?: Address, maxAnisotropy?: number, cmpFunc?: ComparisonFunc);
            copy(info: Readonly<SamplerInfo>): SamplerInfo;
        }
        /**
         * @en Get the memory size of the specified type.
         * @zh 得到 GFX 数据类型的大小。
         * @param type The target type.
         */
        export function GetTypeSize(type: Type): number;
        /**
         * @en GFX descriptor sets.
         * @zh GFX 描述符集组。
         */
        export abstract class DescriptorSet extends GFXObject {
            get layout(): DescriptorSetLayout;
            protected _layout: DescriptorSetLayout | null;
            protected _buffers: Buffer[];
            protected _textures: Texture[];
            protected _samplers: Sampler[];
            protected _isDirty: boolean;
            constructor();
            abstract initialize(info: Readonly<DescriptorSetInfo>): void;
            abstract destroy(): void;
            abstract update(): void;
            /**
             * @en Bind buffer to the specified descriptor.
             * @zh 在指定的描述符位置上绑定缓冲。
             * @param binding The target binding.
             * @param buffer The buffer to be bound.
             */
            bindBuffer(binding: number, buffer: Buffer, index?: number): void;
            /**
             * @en Bind sampler to the specified descriptor.
             * @zh 在指定的描述符位置上绑定采样器。
             * @param binding The target binding.
             * @param sampler The sampler to be bound.
             */
            bindSampler(binding: number, sampler: Sampler, index?: number): void;
            /**
             * @en Bind texture to the specified descriptor.
             * @zh 在指定的描述符位置上绑定纹理。
             * @param binding The target binding.
             * @param texture The texture to be bound.
             */
            bindTexture(binding: number, texture: Texture, index?: number, flags?: AccessFlagBit): void;
            /**
             * @en Get buffer from the specified binding location.
             * @zh 获取当前指定绑定位置上的缓冲。
             * @param binding The target binding.
             */
            getBuffer(binding: number, index?: number): Buffer;
            /**
             * @en Get sampler from the specified binding location.
             * @zh 获取当前指定绑定位置上的采样器。
             * @param binding The target binding.
             */
            getSampler(binding: number, index?: number): Sampler;
            /**
             * @en Get texture from the specified binding location.
             * @zh 获取当前指定绑定位置上的贴图。
             * @param binding The target binding.
             */
            getTexture(binding: number, index?: number): Texture;
        }
        /**
         * @en GFX buffer.
         * @zh GFX 缓冲。
         */
        export abstract class Buffer extends GFXObject {
            /**
             * @en Usage type of the buffer.
             * @zh 缓冲使用方式。
             */
            get usage(): BufferUsage;
            /**
             * @en Memory usage of the buffer.
             * @zh 缓冲的内存使用方式。
             */
            get memUsage(): MemoryUsage;
            /**
             * @en Size of the buffer.
             * @zh 缓冲大小。
             */
            get size(): number;
            /**
             * @en Stride of the buffer.
             * @zh 缓冲步长。
             */
            get stride(): number;
            /**
             * @en Count of the buffer wrt. stride.
             * @zh 缓冲条目数量。
             */
            get count(): number;
            get flags(): BufferFlags;
            protected _usage: BufferUsage;
            protected _memUsage: MemoryUsage;
            protected _size: number;
            protected _stride: number;
            protected _count: number;
            protected _flags: BufferFlags;
            protected _isBufferView: boolean;
            constructor();
            abstract initialize(info: Readonly<BufferInfo> | Readonly<BufferViewInfo>): void;
            abstract destroy(): void;
            /**
             * @en Resize the buffer.
             * @zh 重置缓冲大小。
             * @param size The new buffer size.
             */
            abstract resize(size: number): void;
            /**
             * @en Update the buffer data.
             * @zh 更新缓冲内容。
             * @param buffer The new buffer data.
             * @param size Size in bytes to be updated.
             */
            abstract update(buffer: Readonly<BufferSource>, size?: number): void;
        }
        /**
         * @en GFX command buffer.
         * @zh GFX 命令缓冲。
         */
        export abstract class CommandBuffer extends GFXObject {
            /**
             * @en Type of the command buffer.
             * @zh 命令缓冲类型。
             */
            get type(): CommandBufferType;
            /**
             * @en Type of the command buffer.
             * @zh 命令缓冲类型。
             */
            get queue(): Queue;
            /**
             * @en Number of draw calls currently recorded.
             * @zh 绘制调用次数。
             */
            get numDrawCalls(): number;
            /**
             * @en Number of instances currently recorded.
             * @zh 绘制 Instance 数量。
             */
            get numInstances(): number;
            /**
             * @en Number of triangles currently recorded.
             * @zh 绘制三角形数量。
             */
            get numTris(): number;
            protected _queue: Queue | null;
            protected _type: CommandBufferType;
            protected _numDrawCalls: number;
            protected _numInstances: number;
            protected _numTris: number;
            constructor();
            abstract initialize(info: Readonly<CommandBufferInfo>): void;
            abstract destroy(): void;
            /**
             * @en Begin recording commands.
             * @zh 开始记录命令。
             * @param renderPass [Secondary Command Buffer Only] The render pass the subsequent commands will be executed in
             * @param subpass [Secondary Command Buffer Only] The subpass the subsequent commands will be executed in
             * @param frameBuffer [Secondary Command Buffer Only, Optional] The framebuffer to be used in the subpass
             */
            abstract begin(renderPass?: RenderPass, subpass?: number, frameBuffer?: Framebuffer): void;
            /**
             * @en End recording commands.
             * @zh 结束记录命令。
             */
            abstract end(): void;
            /**
             * @en Begin render pass.
             * @zh 开始 RenderPass。
             * @param framebuffer The frame buffer used.
             * @param renderArea The target render area.
             * @param clearFlag The clear flags.
             * @param clearColors The clearing colors.
             * @param clearDepth The clearing depth.
             * @param clearStencil The clearing stencil.
             */
            abstract beginRenderPass(renderPass: RenderPass, framebuffer: Framebuffer, renderArea: Readonly<Rect>, clearColors: Readonly<Color[]>, clearDepth: number, clearStencil: number): void;
            /**
             * @en End render pass.
             * @zh 结束 RenderPass。
             */
            abstract endRenderPass(): void;
            /**
             * @en Bind pipeline state.
             * @zh 绑定 GFX 管线状态。
             * @param pipelineState The pipeline state to be bound.
             */
            abstract bindPipelineState(pipelineState: PipelineState): void;
            /**
             * @en Bind a descriptor set. Note that the corresponding PiplieneState has to be bound first
             * before calling this function, or the dynamic offset specified may be invalidated.
             * @zh 绑定 GFX 描述符集。注意在调用此函数前，必须先绑定对应的 PipelineState，否则 dynamic offset 可能无效。
             * @param set The target descriptor set index.
             * @param descriptorSet The descriptor set to be bound.
             * @param dynamicOffsets The offset numbers for dynamic bindings.
             */
            abstract bindDescriptorSet(set: number, descriptorSet: DescriptorSet, dynamicOffsets?: Readonly<number[]>): void;
            /**
             * @en Bind input assembler.
             * @zh 绑定 GFX 输入汇集器。
             * @param inputAssembler The input assembler to be bound.
             */
            abstract bindInputAssembler(inputAssembler: InputAssembler): void;
            /**
             * @en Set viewport.
             * @zh 设置视口。
             * @param viewport The new viewport.
             */
            abstract setViewport(viewport: Readonly<Viewport>): void;
            /**
             * @en Set scissor range.
             * @zh 设置剪裁区域。
             * @param scissor The new scissor range.
             */
            abstract setScissor(scissor: Readonly<Rect>): void;
            /**
             * @en Set line width.
             * @zh 设置线宽。
             * @param lineWidth The new line width.
             */
            abstract setLineWidth(lineWidth: number): void;
            /**
             * @en Set depth bias.
             * @zh 设置深度偏移。
             * @param depthBiasConstantFactor The new depth bias factor.
             * @param depthBiasClamp The new depth bias clamp threshold.
             * @param depthBiasSlopeFactor  The new depth bias slope factor.
             */
            abstract setDepthBias(depthBiasConstantFactor: number, depthBiasClamp: number, depthBiasSlopeFactor: number): void;
            /**
             * @en Set blend constants.
             * @zh 设置混合因子。
             * @param blendConstants The new blend constants.
             */
            abstract setBlendConstants(blendConstants: Readonly<Color>): void;
            /**
             * @en Set depth bound.
             * @zh 设置深度边界。
             * @param minDepthBounds The new minimum depth bound.
             * @param maxDepthBounds The new maximum depth bound.
             */
            abstract setDepthBound(minDepthBounds: number, maxDepthBounds: number): void;
            /**
             * @en Set stencil write mask.
             * @zh 设置模板写掩码。
             * @param face The effective triangle face.
             * @param writeMask The new stencil write mask.
             */
            abstract setStencilWriteMask(face: StencilFace, writeMask: number): void;
            /**
             * @en Set stencil compare mask.
             * @zh 设置模板比较掩码。
             * @param face The effective triangle face.
             * @param reference The new stencil reference constant.
             * @param compareMask The new stencil read mask.
             */
            abstract setStencilCompareMask(face: StencilFace, reference: number, compareMask: number): void;
            /**
             * @en Draw the specified primitives.
             * @zh 绘制。
             * @param infoOrAssembler The draw call information.
             */
            abstract draw(infoOrAssembler: Readonly<DrawInfo> | Readonly<InputAssembler>): void;
            /**
             * @en Update buffer.
             * @zh 更新缓冲。
             * @param buffer The buffer to be updated.
             * @param data The source data.
             * @param size Size in bytes to be updated.
             */
            abstract updateBuffer(buffer: Buffer, data: Readonly<ArrayBuffer>, size?: number): void;
            /**
             * @en Copy buffer to texture.
             * @zh 拷贝缓冲到纹理。
             * @param srcBuff The buffer to be copied.
             * @param dstTex The texture to copy to.
             * @param dstLayout The target texture layout.
             * @param regions The region descriptions.
             */
            abstract copyBuffersToTexture(buffers: Readonly<ArrayBufferView[]>, texture: Texture, regions: Readonly<BufferTextureCopy[]>): void;
            /**
             * @en Execute specified command buffers.
             * @zh 执行一组命令缓冲。
             * @param cmdBuffs The command buffers to be executed.
             * @param count The number of command buffers to be executed.
             */
            abstract execute(cmdBuffs: Readonly<CommandBuffer[]>, count: number): void;
            /**
             * @en Insert pipeline memory barriers.
             * @zh 插入管线内存屏障。
             * @param barrier The global memory barrier to apply.
             * @param textureBarriers The texture memory barriers to apply.
             */
            abstract pipelineBarrier(barrier: Readonly<GeneralBarrier> | null, bufferBarriers?: Readonly<__private._cocos_gfx_base_states_buffer_barrier__BufferBarrier[]>, buffers?: Readonly<Buffer[]>, textureBarriers?: Readonly<TextureBarrier[]>, textures?: Readonly<Texture[]>): void;
            /**
             * @en blit data from regions of source texture to regions of destination texture.
             * @zh 将数据从源纹理的区域拷贝到目标纹理的区域。
             *
             * @param srcTexture The source texture.
             * @param dstTexture The destination texture.
             * @param regions The region descriptions.
             * @param filter The filter to use.
             */
            abstract blitTexture(srcTexture: Readonly<Texture>, dstTexture: Texture, regions: Readonly<TextureBlit[]>, filter: Filter): void;
        }
        export function IsPowerOf2(x: number): boolean;
        /**
         * @en Get memory size of the specified fomat.
         * @zh 获取指定格式对应的内存大小。
         * @param format The target format.
         * @param width The target width.
         * @param height The target height.
         * @param depth The target depth.
         */
        export function FormatSize(format: Format, width: number, height: number, depth: number): number;
        /**
         * @en Get memory size of the specified surface.
         * @zh GFX 格式表面内存大小。
         * @param format The target format.
         * @param width The target width.
         * @param height The target height.
         * @param depth The target depth.
         * @param mips The target mip levels.
         */
        export function FormatSurfaceSize(format: Format, width: number, height: number, depth: number, mips: number): number;
        export function getTypedArrayConstructor(info: FormatInfo): __private.__types_globals__TypedArrayConstructor;
        export function formatAlignment(format: Format): FormatAlignment;
        export function alignTo(size: number, alignment: number): number;
        /**
         * ========================= !DO NOT CHANGE THE FOLLOWING SECTION MANUALLY! =========================
         * The following section is auto-generated from native/cocos/renderer/core/gfx/GFXDef-common.h
         * by the script native/tools/gfx-define-generator/generate.js.
         * Changes to these public interfaces should be made there first and synced back.
         * ========================= !DO NOT CHANGE THE FOLLOWING SECTION MANUALLY! =========================
         */
        /**
         * @en Graphics object type
         * @zh 图形API对象的类型
         */
        export enum ObjectType {
            UNKNOWN = 0,
            SWAPCHAIN = 1,
            BUFFER = 2,
            TEXTURE = 3,
            RENDER_PASS = 4,
            FRAMEBUFFER = 5,
            SAMPLER = 6,
            SHADER = 7,
            DESCRIPTOR_SET_LAYOUT = 8,
            PIPELINE_LAYOUT = 9,
            PIPELINE_STATE = 10,
            DESCRIPTOR_SET = 11,
            INPUT_ASSEMBLER = 12,
            COMMAND_BUFFER = 13,
            QUEUE = 14,
            QUERY_POOL = 15,
            GLOBAL_BARRIER = 16,
            TEXTURE_BARRIER = 17,
            BUFFER_BARRIER = 18,
            COUNT = 19
        }
        export enum Status {
            UNREADY = 0,
            FAILED = 1,
            SUCCESS = 2
        }
        export enum API {
            UNKNOWN = 0,
            GLES2 = 1,
            GLES3 = 2,
            METAL = 3,
            VULKAN = 4,
            NVN = 5,
            WEBGL = 6,
            WEBGL2 = 7,
            WEBGPU = 8
        }
        export enum SurfaceTransform {
            IDENTITY = 0,
            ROTATE_90 = 1,
            ROTATE_180 = 2,
            ROTATE_270 = 3
        }
        export enum Feature {
            ELEMENT_INDEX_UINT = 0,
            INSTANCED_ARRAYS = 1,
            MULTIPLE_RENDER_TARGETS = 2,
            BLEND_MINMAX = 3,
            COMPUTE_SHADER = 4,
            INPUT_ATTACHMENT_BENEFIT = 5,
            SUBPASS_COLOR_INPUT = 6,
            SUBPASS_DEPTH_STENCIL_INPUT = 7,
            RASTERIZATION_ORDER_NOCOHERENT = 8,
            MULTI_SAMPLE_RESOLVE_DEPTH_STENCIL = 9,
            COUNT = 10
        }
        export enum Format {
            UNKNOWN = 0,
            A8 = 1,
            L8 = 2,
            LA8 = 3,
            R8 = 4,
            R8SN = 5,
            R8UI = 6,
            R8I = 7,
            R16F = 8,
            R16UI = 9,
            R16I = 10,
            R32F = 11,
            R32UI = 12,
            R32I = 13,
            RG8 = 14,
            RG8SN = 15,
            RG8UI = 16,
            RG8I = 17,
            RG16F = 18,
            RG16UI = 19,
            RG16I = 20,
            RG32F = 21,
            RG32UI = 22,
            RG32I = 23,
            RGB8 = 24,
            SRGB8 = 25,
            RGB8SN = 26,
            RGB8UI = 27,
            RGB8I = 28,
            RGB16F = 29,
            RGB16UI = 30,
            RGB16I = 31,
            RGB32F = 32,
            RGB32UI = 33,
            RGB32I = 34,
            RGBA8 = 35,
            BGRA8 = 36,
            SRGB8_A8 = 37,
            RGBA8SN = 38,
            RGBA8UI = 39,
            RGBA8I = 40,
            RGBA16F = 41,
            RGBA16UI = 42,
            RGBA16I = 43,
            RGBA32F = 44,
            RGBA32UI = 45,
            RGBA32I = 46,
            R5G6B5 = 47,
            R11G11B10F = 48,
            RGB5A1 = 49,
            RGBA4 = 50,
            RGB10A2 = 51,
            RGB10A2UI = 52,
            RGB9E5 = 53,
            DEPTH = 54,
            DEPTH_STENCIL = 55,
            BC1 = 56,
            BC1_ALPHA = 57,
            BC1_SRGB = 58,
            BC1_SRGB_ALPHA = 59,
            BC2 = 60,
            BC2_SRGB = 61,
            BC3 = 62,
            BC3_SRGB = 63,
            BC4 = 64,
            BC4_SNORM = 65,
            BC5 = 66,
            BC5_SNORM = 67,
            BC6H_UF16 = 68,
            BC6H_SF16 = 69,
            BC7 = 70,
            BC7_SRGB = 71,
            ETC_RGB8 = 72,
            ETC2_RGB8 = 73,
            ETC2_SRGB8 = 74,
            ETC2_RGB8_A1 = 75,
            ETC2_SRGB8_A1 = 76,
            ETC2_RGBA8 = 77,
            ETC2_SRGB8_A8 = 78,
            EAC_R11 = 79,
            EAC_R11SN = 80,
            EAC_RG11 = 81,
            EAC_RG11SN = 82,
            PVRTC_RGB2 = 83,
            PVRTC_RGBA2 = 84,
            PVRTC_RGB4 = 85,
            PVRTC_RGBA4 = 86,
            PVRTC2_2BPP = 87,
            PVRTC2_4BPP = 88,
            ASTC_RGBA_4X4 = 89,
            ASTC_RGBA_5X4 = 90,
            ASTC_RGBA_5X5 = 91,
            ASTC_RGBA_6X5 = 92,
            ASTC_RGBA_6X6 = 93,
            ASTC_RGBA_8X5 = 94,
            ASTC_RGBA_8X6 = 95,
            ASTC_RGBA_8X8 = 96,
            ASTC_RGBA_10X5 = 97,
            ASTC_RGBA_10X6 = 98,
            ASTC_RGBA_10X8 = 99,
            ASTC_RGBA_10X10 = 100,
            ASTC_RGBA_12X10 = 101,
            ASTC_RGBA_12X12 = 102,
            ASTC_SRGBA_4X4 = 103,
            ASTC_SRGBA_5X4 = 104,
            ASTC_SRGBA_5X5 = 105,
            ASTC_SRGBA_6X5 = 106,
            ASTC_SRGBA_6X6 = 107,
            ASTC_SRGBA_8X5 = 108,
            ASTC_SRGBA_8X6 = 109,
            ASTC_SRGBA_8X8 = 110,
            ASTC_SRGBA_10X5 = 111,
            ASTC_SRGBA_10X6 = 112,
            ASTC_SRGBA_10X8 = 113,
            ASTC_SRGBA_10X10 = 114,
            ASTC_SRGBA_12X10 = 115,
            ASTC_SRGBA_12X12 = 116,
            COUNT = 117
        }
        export enum FormatType {
            NONE = 0,
            UNORM = 1,
            SNORM = 2,
            UINT = 3,
            INT = 4,
            UFLOAT = 5,
            FLOAT = 6
        }
        export enum Type {
            UNKNOWN = 0,
            BOOL = 1,
            BOOL2 = 2,
            BOOL3 = 3,
            BOOL4 = 4,
            INT = 5,
            INT2 = 6,
            INT3 = 7,
            INT4 = 8,
            UINT = 9,
            UINT2 = 10,
            UINT3 = 11,
            UINT4 = 12,
            FLOAT = 13,
            FLOAT2 = 14,
            FLOAT3 = 15,
            FLOAT4 = 16,
            MAT2 = 17,
            MAT2X3 = 18,
            MAT2X4 = 19,
            MAT3X2 = 20,
            MAT3 = 21,
            MAT3X4 = 22,
            MAT4X2 = 23,
            MAT4X3 = 24,
            MAT4 = 25,
            SAMPLER1D = 26,
            SAMPLER1D_ARRAY = 27,
            SAMPLER2D = 28,
            SAMPLER2D_ARRAY = 29,
            SAMPLER3D = 30,
            SAMPLER_CUBE = 31,
            SAMPLER = 32,
            TEXTURE1D = 33,
            TEXTURE1D_ARRAY = 34,
            TEXTURE2D = 35,
            TEXTURE2D_ARRAY = 36,
            TEXTURE3D = 37,
            TEXTURE_CUBE = 38,
            IMAGE1D = 39,
            IMAGE1D_ARRAY = 40,
            IMAGE2D = 41,
            IMAGE2D_ARRAY = 42,
            IMAGE3D = 43,
            IMAGE_CUBE = 44,
            SUBPASS_INPUT = 45,
            COUNT = 46
        }
        export enum BufferUsageBit {
            NONE = 0,
            TRANSFER_SRC = 1,
            TRANSFER_DST = 2,
            INDEX = 4,
            VERTEX = 8,
            UNIFORM = 16,
            STORAGE = 32,
            INDIRECT = 64
        }
        export enum BufferFlagBit {
            NONE = 0,
            ENABLE_STAGING_WRITE = 1
        }
        export enum MemoryAccessBit {
            NONE = 0,
            READ_ONLY = 1,
            WRITE_ONLY = 2,
            READ_WRITE = 3
        }
        export enum MemoryUsageBit {
            NONE = 0,
            DEVICE = 1,
            HOST = 2
        }
        export enum TextureType {
            TEX1D = 0,
            TEX2D = 1,
            TEX3D = 2,
            CUBE = 3,
            TEX1D_ARRAY = 4,
            TEX2D_ARRAY = 5
        }
        export enum TextureUsageBit {
            NONE = 0,
            TRANSFER_SRC = 1,
            TRANSFER_DST = 2,
            SAMPLED = 4,
            STORAGE = 8,
            COLOR_ATTACHMENT = 16,
            DEPTH_STENCIL_ATTACHMENT = 32,
            INPUT_ATTACHMENT = 64,
            SHADING_RATE = 128
        }
        export enum TextureFlagBit {
            NONE = 0,
            GEN_MIPMAP = 1,
            GENERAL_LAYOUT = 2,
            EXTERNAL_OES = 4,
            EXTERNAL_NORMAL = 8,
            LAZILY_ALLOCATED = 16,
            MUTABLE_VIEW_FORMAT = 64,
            MUTABLE_STORAGE = 128
        }
        export enum FormatFeatureBit {
            NONE = 0,
            RENDER_TARGET = 1,
            SAMPLED_TEXTURE = 2,
            LINEAR_FILTER = 4,
            STORAGE_TEXTURE = 8,
            VERTEX_ATTRIBUTE = 16,
            SHADING_RATE = 32
        }
        export enum SampleCount {
            X1 = 1,
            X2 = 2,
            X4 = 4,
            X8 = 8,
            X16 = 16,
            X32 = 32,
            X64 = 64
        }
        export enum VsyncMode {
            OFF = 0,
            ON = 1,
            RELAXED = 2,
            MAILBOX = 3,
            HALF = 4
        }
        export enum Filter {
            NONE = 0,
            POINT = 1,
            LINEAR = 2,
            ANISOTROPIC = 3
        }
        export enum Address {
            WRAP = 0,
            MIRROR = 1,
            CLAMP = 2,
            BORDER = 3
        }
        export enum ComparisonFunc {
            NEVER = 0,
            LESS = 1,
            EQUAL = 2,
            LESS_EQUAL = 3,
            GREATER = 4,
            NOT_EQUAL = 5,
            GREATER_EQUAL = 6,
            ALWAYS = 7
        }
        export enum StencilOp {
            ZERO = 0,
            KEEP = 1,
            REPLACE = 2,
            INCR = 3,
            DECR = 4,
            INVERT = 5,
            INCR_WRAP = 6,
            DECR_WRAP = 7
        }
        export enum BlendFactor {
            ZERO = 0,
            ONE = 1,
            SRC_ALPHA = 2,
            DST_ALPHA = 3,
            ONE_MINUS_SRC_ALPHA = 4,
            ONE_MINUS_DST_ALPHA = 5,
            SRC_COLOR = 6,
            DST_COLOR = 7,
            ONE_MINUS_SRC_COLOR = 8,
            ONE_MINUS_DST_COLOR = 9,
            SRC_ALPHA_SATURATE = 10,
            CONSTANT_COLOR = 11,
            ONE_MINUS_CONSTANT_COLOR = 12,
            CONSTANT_ALPHA = 13,
            ONE_MINUS_CONSTANT_ALPHA = 14
        }
        export enum BlendOp {
            ADD = 0,
            SUB = 1,
            REV_SUB = 2,
            MIN = 3,
            MAX = 4
        }
        export enum ColorMask {
            NONE = 0,
            R = 1,
            G = 2,
            B = 4,
            A = 8,
            ALL = 15
        }
        export enum ShaderStageFlagBit {
            NONE = 0,
            VERTEX = 1,
            CONTROL = 2,
            EVALUATION = 4,
            GEOMETRY = 8,
            FRAGMENT = 16,
            COMPUTE = 32,
            ALL = 63
        }
        export enum LoadOp {
            LOAD = 0,
            CLEAR = 1,
            DISCARD = 2
        }
        export enum StoreOp {
            STORE = 0,
            DISCARD = 1
        }
        export enum AccessFlagBit {
            NONE = 0,
            INDIRECT_BUFFER = 1,
            INDEX_BUFFER = 2,
            VERTEX_BUFFER = 4,
            VERTEX_SHADER_READ_UNIFORM_BUFFER = 8,
            VERTEX_SHADER_READ_TEXTURE = 16,
            VERTEX_SHADER_READ_OTHER = 32,
            FRAGMENT_SHADER_READ_UNIFORM_BUFFER = 64,
            FRAGMENT_SHADER_READ_TEXTURE = 128,
            FRAGMENT_SHADER_READ_COLOR_INPUT_ATTACHMENT = 256,
            FRAGMENT_SHADER_READ_DEPTH_STENCIL_INPUT_ATTACHMENT = 512,
            FRAGMENT_SHADER_READ_OTHER = 1024,
            COLOR_ATTACHMENT_READ = 2048,
            DEPTH_STENCIL_ATTACHMENT_READ = 4096,
            COMPUTE_SHADER_READ_UNIFORM_BUFFER = 8192,
            COMPUTE_SHADER_READ_TEXTURE = 16384,
            COMPUTE_SHADER_READ_OTHER = 32768,
            TRANSFER_READ = 65536,
            HOST_READ = 131072,
            PRESENT = 262144,
            VERTEX_SHADER_WRITE = 524288,
            FRAGMENT_SHADER_WRITE = 1048576,
            COLOR_ATTACHMENT_WRITE = 2097152,
            DEPTH_STENCIL_ATTACHMENT_WRITE = 4194304,
            COMPUTE_SHADER_WRITE = 8388608,
            TRANSFER_WRITE = 16777216,
            HOST_PREINITIALIZED = 33554432,
            HOST_WRITE = 67108864,
            SHADING_RATE = 134217728
        }
        export enum ResolveMode {
            NONE = 0,
            SAMPLE_ZERO = 1,
            AVERAGE = 2,
            MIN = 3,
            MAX = 4
        }
        export enum PipelineBindPoint {
            GRAPHICS = 0,
            COMPUTE = 1,
            RAY_TRACING = 2
        }
        export enum PrimitiveMode {
            POINT_LIST = 0,
            LINE_LIST = 1,
            LINE_STRIP = 2,
            LINE_LOOP = 3,
            LINE_LIST_ADJACENCY = 4,
            LINE_STRIP_ADJACENCY = 5,
            ISO_LINE_LIST = 6,
            TRIANGLE_LIST = 7,
            TRIANGLE_STRIP = 8,
            TRIANGLE_FAN = 9,
            TRIANGLE_LIST_ADJACENCY = 10,
            TRIANGLE_STRIP_ADJACENCY = 11,
            TRIANGLE_PATCH_ADJACENCY = 12,
            QUAD_PATCH_LIST = 13
        }
        export enum PolygonMode {
            FILL = 0,
            POINT = 1,
            LINE = 2
        }
        export enum ShadeModel {
            GOURAND = 0,
            FLAT = 1
        }
        export enum CullMode {
            NONE = 0,
            FRONT = 1,
            BACK = 2
        }
        export enum DynamicStateFlagBit {
            NONE = 0,
            LINE_WIDTH = 1,
            DEPTH_BIAS = 2,
            BLEND_CONSTANTS = 4,
            DEPTH_BOUNDS = 8,
            STENCIL_WRITE_MASK = 16,
            STENCIL_COMPARE_MASK = 32
        }
        export enum StencilFace {
            FRONT = 1,
            BACK = 2,
            ALL = 3
        }
        export enum DescriptorType {
            UNKNOWN = 0,
            UNIFORM_BUFFER = 1,
            DYNAMIC_UNIFORM_BUFFER = 2,
            STORAGE_BUFFER = 4,
            DYNAMIC_STORAGE_BUFFER = 8,
            SAMPLER_TEXTURE = 16,
            SAMPLER = 32,
            TEXTURE = 64,
            STORAGE_IMAGE = 128,
            INPUT_ATTACHMENT = 256
        }
        export enum QueueType {
            GRAPHICS = 0,
            COMPUTE = 1,
            TRANSFER = 2
        }
        export enum QueryType {
            OCCLUSION = 0,
            PIPELINE_STATISTICS = 1,
            TIMESTAMP = 2
        }
        export enum CommandBufferType {
            PRIMARY = 0,
            SECONDARY = 1
        }
        export enum ClearFlagBit {
            NONE = 0,
            COLOR = 1,
            DEPTH = 2,
            STENCIL = 4,
            DEPTH_STENCIL = 6,
            ALL = 7
        }
        export enum BarrierType {
            FULL = 0,
            SPLIT_BEGIN = 1,
            SPLIT_END = 2
        }
        export enum PassType {
            RASTER = 0,
            COMPUTE = 1,
            COPY = 2,
            MOVE = 3,
            RAYTRACE = 4,
            PRESENT = 5
        }
        export type BufferUsage = BufferUsageBit;
        export type BufferFlags = BufferFlagBit;
        export type MemoryAccess = MemoryAccessBit;
        export type MemoryUsage = MemoryUsageBit;
        export type TextureUsage = TextureUsageBit;
        export type TextureFlags = TextureFlagBit;
        export type FormatFeature = FormatFeatureBit;
        export type ShaderStageFlags = ShaderStageFlagBit;
        export type AccessFlags = AccessFlagBit;
        export type DynamicStateFlags = DynamicStateFlagBit;
        export type ClearFlags = ClearFlagBit;
        export class Size {
            x: number;
            y: number;
            z: number;
            constructor(x?: number, y?: number, z?: number);
            copy(info: Readonly<Size>): Size;
        }
        export class DeviceCaps {
            maxVertexAttributes: number;
            maxVertexUniformVectors: number;
            maxFragmentUniformVectors: number;
            maxTextureUnits: number;
            maxImageUnits: number;
            maxVertexTextureUnits: number;
            maxColorRenderTargets: number;
            maxShaderStorageBufferBindings: number;
            maxShaderStorageBlockSize: number;
            maxUniformBufferBindings: number;
            maxUniformBlockSize: number;
            maxTextureSize: number;
            maxCubeMapTextureSize: number;
            maxArrayTextureLayers: number;
            max3DTextureSize: number;
            uboOffsetAlignment: number;
            maxComputeSharedMemorySize: number;
            maxComputeWorkGroupInvocations: number;
            maxComputeWorkGroupSize: Size;
            maxComputeWorkGroupCount: Size;
            supportQuery: boolean;
            supportVariableRateShading: boolean;
            supportSubPassShading: boolean;
            clipSpaceMinZ: number;
            screenSpaceSignY: number;
            clipSpaceSignY: number;
            constructor(maxVertexAttributes?: number, maxVertexUniformVectors?: number, maxFragmentUniformVectors?: number, maxTextureUnits?: number, maxImageUnits?: number, maxVertexTextureUnits?: number, maxColorRenderTargets?: number, maxShaderStorageBufferBindings?: number, maxShaderStorageBlockSize?: number, maxUniformBufferBindings?: number, maxUniformBlockSize?: number, maxTextureSize?: number, maxCubeMapTextureSize?: number, maxArrayTextureLayers?: number, max3DTextureSize?: number, uboOffsetAlignment?: number, maxComputeSharedMemorySize?: number, maxComputeWorkGroupInvocations?: number, maxComputeWorkGroupSize?: Size, maxComputeWorkGroupCount?: Size, supportQuery?: boolean, supportVariableRateShading?: boolean, supportSubPassShading?: boolean, clipSpaceMinZ?: number, screenSpaceSignY?: number, clipSpaceSignY?: number);
            copy(info: Readonly<DeviceCaps>): DeviceCaps;
        }
        export class DeviceOptions {
            enableBarrierDeduce: boolean;
            constructor(enableBarrierDeduce?: boolean);
            copy(info: Readonly<DeviceOptions>): DeviceOptions;
        }
        export class Offset {
            x: number;
            y: number;
            z: number;
            constructor(x?: number, y?: number, z?: number);
            copy(info: Readonly<Offset>): Offset;
        }
        export class Rect {
            x: number;
            y: number;
            width: number;
            height: number;
            constructor(x?: number, y?: number, width?: number, height?: number);
            copy(info: Readonly<Rect>): Rect;
        }
        export class Extent {
            width: number;
            height: number;
            depth: number;
            constructor(width?: number, height?: number, depth?: number);
            copy(info: Readonly<Extent>): Extent;
        }
        export class TextureSubresLayers {
            mipLevel: number;
            baseArrayLayer: number;
            layerCount: number;
            constructor(mipLevel?: number, baseArrayLayer?: number, layerCount?: number);
            copy(info: Readonly<TextureSubresLayers>): TextureSubresLayers;
        }
        export class TextureSubresRange {
            baseMipLevel: number;
            levelCount: number;
            baseArrayLayer: number;
            layerCount: number;
            constructor(baseMipLevel?: number, levelCount?: number, baseArrayLayer?: number, layerCount?: number);
            copy(info: Readonly<TextureSubresRange>): TextureSubresRange;
        }
        export class TextureCopy {
            srcSubres: TextureSubresLayers;
            srcOffset: Offset;
            dstSubres: TextureSubresLayers;
            dstOffset: Offset;
            extent: Extent;
            constructor(srcSubres?: TextureSubresLayers, srcOffset?: Offset, dstSubres?: TextureSubresLayers, dstOffset?: Offset, extent?: Extent);
            copy(info: Readonly<TextureCopy>): TextureCopy;
        }
        export class TextureBlit {
            srcSubres: TextureSubresLayers;
            srcOffset: Offset;
            srcExtent: Extent;
            dstSubres: TextureSubresLayers;
            dstOffset: Offset;
            dstExtent: Extent;
            constructor(srcSubres?: TextureSubresLayers, srcOffset?: Offset, srcExtent?: Extent, dstSubres?: TextureSubresLayers, dstOffset?: Offset, dstExtent?: Extent);
            copy(info: Readonly<TextureBlit>): TextureBlit;
        }
        export class BufferTextureCopy {
            buffOffset: number;
            buffStride: number;
            buffTexHeight: number;
            texOffset: Offset;
            texExtent: Extent;
            texSubres: TextureSubresLayers;
            constructor(buffOffset?: number, buffStride?: number, buffTexHeight?: number, texOffset?: Offset, texExtent?: Extent, texSubres?: TextureSubresLayers);
            copy(info: Readonly<BufferTextureCopy>): BufferTextureCopy;
        }
        export class Viewport {
            left: number;
            top: number;
            width: number;
            height: number;
            minDepth: number;
            maxDepth: number;
            constructor(left?: number, top?: number, width?: number, height?: number, minDepth?: number, maxDepth?: number);
            copy(info: Readonly<Viewport>): Viewport;
            reset(): void;
        }
        export class Color {
            x: number;
            y: number;
            z: number;
            w: number;
            constructor(x?: number, y?: number, z?: number, w?: number);
            copy(info: Readonly<Color>): Color;
            set(x: number, y: number, z: number, w: number): Color;
            reset(): void;
        }
        export class MarkerInfo {
            name: string;
            color: Color;
            constructor(name?: string, color?: Color);
            copy(info: Readonly<MarkerInfo>): MarkerInfo;
        }
        export class BindingMappingInfo {
            maxBlockCounts: number[];
            maxSamplerTextureCounts: number[];
            maxSamplerCounts: number[];
            maxTextureCounts: number[];
            maxBufferCounts: number[];
            maxImageCounts: number[];
            maxSubpassInputCounts: number[];
            setIndices: number[];
            constructor(maxBlockCounts?: number[], maxSamplerTextureCounts?: number[], maxSamplerCounts?: number[], maxTextureCounts?: number[], maxBufferCounts?: number[], maxImageCounts?: number[], maxSubpassInputCounts?: number[], setIndices?: number[]);
            copy(info: Readonly<BindingMappingInfo>): BindingMappingInfo;
        }
        export class SwapchainInfo {
            windowId: number;
            windowHandle: HTMLCanvasElement;
            vsyncMode: VsyncMode;
            width: number;
            height: number;
            constructor(windowId?: number, windowHandle?: HTMLCanvasElement, vsyncMode?: VsyncMode, width?: number, height?: number);
            copy(info: Readonly<SwapchainInfo>): SwapchainInfo;
        }
        export class DeviceInfo {
            bindingMappingInfo: BindingMappingInfo;
            constructor(bindingMappingInfo?: BindingMappingInfo);
            copy(info: Readonly<DeviceInfo>): DeviceInfo;
        }
        export class BufferInfo {
            usage: BufferUsage;
            memUsage: MemoryUsage;
            size: number;
            stride: number;
            flags: BufferFlags;
            constructor(usage?: BufferUsage, memUsage?: MemoryUsage, size?: number, stride?: number, flags?: BufferFlags);
            copy(info: Readonly<BufferInfo>): BufferInfo;
        }
        export class BufferViewInfo {
            buffer: Buffer;
            offset: number;
            range: number;
            constructor(buffer?: Buffer, offset?: number, range?: number);
            copy(info: Readonly<BufferViewInfo>): BufferViewInfo;
        }
        export class DrawInfo {
            vertexCount: number;
            firstVertex: number;
            indexCount: number;
            firstIndex: number;
            vertexOffset: number;
            instanceCount: number;
            firstInstance: number;
            constructor(vertexCount?: number, firstVertex?: number, indexCount?: number, firstIndex?: number, vertexOffset?: number, instanceCount?: number, firstInstance?: number);
            copy(info: Readonly<DrawInfo>): DrawInfo;
        }
        export class DispatchInfo {
            groupCountX: number;
            groupCountY: number;
            groupCountZ: number;
            indirectBuffer: Buffer | null;
            indirectOffset: number;
            constructor(groupCountX?: number, groupCountY?: number, groupCountZ?: number, indirectBuffer?: Buffer | null, indirectOffset?: number);
            copy(info: Readonly<DispatchInfo>): DispatchInfo;
        }
        export class IndirectBuffer {
            drawInfos: DrawInfo[];
            constructor(drawInfos?: DrawInfo[]);
            copy(info: Readonly<IndirectBuffer>): IndirectBuffer;
        }
        export class TextureInfo {
            type: TextureType;
            usage: TextureUsage;
            format: Format;
            width: number;
            height: number;
            flags: TextureFlags;
            layerCount: number;
            levelCount: number;
            samples: SampleCount;
            depth: number;
            externalRes: number;
            constructor(type?: TextureType, usage?: TextureUsage, format?: Format, width?: number, height?: number, flags?: TextureFlags, layerCount?: number, levelCount?: number, samples?: SampleCount, depth?: number, externalRes?: number);
            copy(info: Readonly<TextureInfo>): TextureInfo;
        }
        export class TextureViewInfo {
            texture: Texture;
            type: TextureType;
            format: Format;
            baseLevel: number;
            levelCount: number;
            baseLayer: number;
            layerCount: number;
            basePlane: number;
            planeCount: number;
            constructor(texture?: Texture, type?: TextureType, format?: Format, baseLevel?: number, levelCount?: number, baseLayer?: number, layerCount?: number, basePlane?: number, planeCount?: number);
            copy(info: Readonly<TextureViewInfo>): TextureViewInfo;
        }
        export class Uniform {
            name: string;
            type: Type;
            count: number;
            constructor(name?: string, type?: Type, count?: number);
            copy(info: Readonly<Uniform>): Uniform;
        }
        export class UniformBlock {
            set: number;
            binding: number;
            name: string;
            members: Uniform[];
            count: number;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, members?: Uniform[], count?: number, flattened?: number);
            copy(info: Readonly<UniformBlock>): UniformBlock;
        }
        export class UniformSamplerTexture {
            set: number;
            binding: number;
            name: string;
            type: Type;
            count: number;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, type?: Type, count?: number, flattened?: number);
            copy(info: Readonly<UniformSamplerTexture>): UniformSamplerTexture;
        }
        export class UniformSampler {
            set: number;
            binding: number;
            name: string;
            count: number;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, count?: number, flattened?: number);
            copy(info: Readonly<UniformSampler>): UniformSampler;
        }
        export class UniformTexture {
            set: number;
            binding: number;
            name: string;
            type: Type;
            count: number;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, type?: Type, count?: number, flattened?: number);
            copy(info: Readonly<UniformTexture>): UniformTexture;
        }
        export class UniformStorageImage {
            set: number;
            binding: number;
            name: string;
            type: Type;
            count: number;
            memoryAccess: MemoryAccess;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, type?: Type, count?: number, memoryAccess?: MemoryAccess, flattened?: number);
            copy(info: Readonly<UniformStorageImage>): UniformStorageImage;
        }
        export class UniformStorageBuffer {
            set: number;
            binding: number;
            name: string;
            count: number;
            memoryAccess: MemoryAccess;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, count?: number, memoryAccess?: MemoryAccess, flattened?: number);
            copy(info: Readonly<UniformStorageBuffer>): UniformStorageBuffer;
        }
        export class UniformInputAttachment {
            set: number;
            binding: number;
            name: string;
            count: number;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, count?: number, flattened?: number);
            copy(info: Readonly<UniformInputAttachment>): UniformInputAttachment;
        }
        export class ShaderStage {
            stage: ShaderStageFlagBit;
            source: string;
            constructor(stage?: ShaderStageFlagBit, source?: string);
            copy(info: Readonly<ShaderStage>): ShaderStage;
        }
        export class Attribute {
            name: string;
            format: Format;
            isNormalized: boolean;
            stream: number;
            isInstanced: boolean;
            location: number;
            constructor(name?: string, format?: Format, isNormalized?: boolean, stream?: number, isInstanced?: boolean, location?: number);
            copy(info: Readonly<Attribute>): Attribute;
        }
        export class ShaderInfo {
            name: string;
            stages: ShaderStage[];
            attributes: Attribute[];
            blocks: UniformBlock[];
            buffers: UniformStorageBuffer[];
            samplerTextures: UniformSamplerTexture[];
            samplers: UniformSampler[];
            textures: UniformTexture[];
            images: UniformStorageImage[];
            subpassInputs: UniformInputAttachment[];
            hash: number;
            constructor(name?: string, stages?: ShaderStage[], attributes?: Attribute[], blocks?: UniformBlock[], buffers?: UniformStorageBuffer[], samplerTextures?: UniformSamplerTexture[], samplers?: UniformSampler[], textures?: UniformTexture[], images?: UniformStorageImage[], subpassInputs?: UniformInputAttachment[], hash?: number);
            copy(info: Readonly<ShaderInfo>): ShaderInfo;
        }
        export class InputAssemblerInfo {
            attributes: Attribute[];
            vertexBuffers: Buffer[];
            indexBuffer: Buffer | null;
            indirectBuffer: Buffer | null;
            constructor(attributes?: Attribute[], vertexBuffers?: Buffer[], indexBuffer?: Buffer | null, indirectBuffer?: Buffer | null);
            copy(info: Readonly<InputAssemblerInfo>): InputAssemblerInfo;
        }
        export class ColorAttachment {
            format: Format;
            sampleCount: SampleCount;
            loadOp: LoadOp;
            storeOp: StoreOp;
            barrier: GeneralBarrier;
            constructor(format?: Format, sampleCount?: SampleCount, loadOp?: LoadOp, storeOp?: StoreOp, barrier?: GeneralBarrier);
            copy(info: Readonly<ColorAttachment>): ColorAttachment;
        }
        export class DepthStencilAttachment {
            format: Format;
            sampleCount: SampleCount;
            depthLoadOp: LoadOp;
            depthStoreOp: StoreOp;
            stencilLoadOp: LoadOp;
            stencilStoreOp: StoreOp;
            barrier: GeneralBarrier;
            constructor(format?: Format, sampleCount?: SampleCount, depthLoadOp?: LoadOp, depthStoreOp?: StoreOp, stencilLoadOp?: LoadOp, stencilStoreOp?: StoreOp, barrier?: GeneralBarrier);
            copy(info: Readonly<DepthStencilAttachment>): DepthStencilAttachment;
        }
        export class SubpassInfo {
            inputs: number[];
            colors: number[];
            resolves: number[];
            preserves: number[];
            depthStencil: number;
            depthStencilResolve: number;
            shadingRate: number;
            depthResolveMode: ResolveMode;
            stencilResolveMode: ResolveMode;
            constructor(inputs?: number[], colors?: number[], resolves?: number[], preserves?: number[], depthStencil?: number, depthStencilResolve?: number, shadingRate?: number, depthResolveMode?: ResolveMode, stencilResolveMode?: ResolveMode);
            copy(info: Readonly<SubpassInfo>): SubpassInfo;
        }
        export class SubpassDependency {
            srcSubpass: number;
            dstSubpass: number;
            generalBarrier: GeneralBarrier;
            prevAccesses: AccessFlags;
            nextAccesses: AccessFlags;
            constructor(srcSubpass?: number, dstSubpass?: number, generalBarrier?: GeneralBarrier, prevAccesses?: AccessFlags, nextAccesses?: AccessFlags);
            copy(info: Readonly<SubpassDependency>): SubpassDependency;
        }
        export class RenderPassInfo {
            colorAttachments: ColorAttachment[];
            depthStencilAttachment: DepthStencilAttachment;
            depthStencilResolveAttachment: DepthStencilAttachment;
            subpasses: SubpassInfo[];
            dependencies: SubpassDependency[];
            constructor(colorAttachments?: ColorAttachment[], depthStencilAttachment?: DepthStencilAttachment, depthStencilResolveAttachment?: DepthStencilAttachment, subpasses?: SubpassInfo[], dependencies?: SubpassDependency[]);
            copy(info: Readonly<RenderPassInfo>): RenderPassInfo;
        }
        export class ResourceRange {
            width: number;
            height: number;
            depthOrArraySize: number;
            firstSlice: number;
            numSlices: number;
            mipLevel: number;
            levelCount: number;
            basePlane: number;
            planeCount: number;
            constructor(width?: number, height?: number, depthOrArraySize?: number, firstSlice?: number, numSlices?: number, mipLevel?: number, levelCount?: number, basePlane?: number, planeCount?: number);
            copy(info: Readonly<ResourceRange>): ResourceRange;
        }
        export class GeneralBarrierInfo {
            prevAccesses: AccessFlags;
            nextAccesses: AccessFlags;
            type: BarrierType;
            constructor(prevAccesses?: AccessFlags, nextAccesses?: AccessFlags, type?: BarrierType);
            copy(info: Readonly<GeneralBarrierInfo>): GeneralBarrierInfo;
        }
        export class TextureBarrierInfo {
            prevAccesses: AccessFlags;
            nextAccesses: AccessFlags;
            type: BarrierType;
            range: ResourceRange;
            discardContents: boolean;
            srcQueue: Queue | null;
            dstQueue: Queue | null;
            constructor(prevAccesses?: AccessFlags, nextAccesses?: AccessFlags, type?: BarrierType, range?: ResourceRange, discardContents?: boolean, srcQueue?: Queue | null, dstQueue?: Queue | null);
            copy(info: Readonly<TextureBarrierInfo>): TextureBarrierInfo;
        }
        export class BufferBarrierInfo {
            prevAccesses: AccessFlags;
            nextAccesses: AccessFlags;
            type: BarrierType;
            offset: number;
            size: number;
            discardContents: boolean;
            srcQueue: Queue | null;
            dstQueue: Queue | null;
            constructor(prevAccesses?: AccessFlags, nextAccesses?: AccessFlags, type?: BarrierType, offset?: number, size?: number, discardContents?: boolean, srcQueue?: Queue | null, dstQueue?: Queue | null);
            copy(info: Readonly<BufferBarrierInfo>): BufferBarrierInfo;
        }
        export class FramebufferInfo {
            renderPass: RenderPass;
            colorTextures: Texture[];
            depthStencilTexture: Texture | null;
            depthStencilResolveTexture: Texture | null;
            constructor(renderPass?: RenderPass, colorTextures?: Texture[], depthStencilTexture?: Texture | null, depthStencilResolveTexture?: Texture | null);
            copy(info: Readonly<FramebufferInfo>): FramebufferInfo;
        }
        export class DescriptorSetLayoutBinding {
            binding: number;
            descriptorType: DescriptorType;
            count: number;
            stageFlags: ShaderStageFlags;
            immutableSamplers: Sampler[];
            constructor(binding?: number, descriptorType?: DescriptorType, count?: number, stageFlags?: ShaderStageFlags, immutableSamplers?: Sampler[]);
            copy(info: Readonly<DescriptorSetLayoutBinding>): DescriptorSetLayoutBinding;
        }
        export class DescriptorSetLayoutInfo {
            bindings: DescriptorSetLayoutBinding[];
            constructor(bindings?: DescriptorSetLayoutBinding[]);
            copy(info: Readonly<DescriptorSetLayoutInfo>): DescriptorSetLayoutInfo;
        }
        export class DescriptorSetInfo {
            layout: DescriptorSetLayout;
            constructor(layout?: DescriptorSetLayout);
            copy(info: Readonly<DescriptorSetInfo>): DescriptorSetInfo;
        }
        export class PipelineLayoutInfo {
            setLayouts: DescriptorSetLayout[];
            constructor(setLayouts?: DescriptorSetLayout[]);
            copy(info: Readonly<PipelineLayoutInfo>): PipelineLayoutInfo;
        }
        export class InputState {
            attributes: Attribute[];
            constructor(attributes?: Attribute[]);
            copy(info: Readonly<InputState>): InputState;
        }
        export class CommandBufferInfo {
            queue: Queue;
            type: CommandBufferType;
            constructor(queue?: Queue, type?: CommandBufferType);
            copy(info: Readonly<CommandBufferInfo>): CommandBufferInfo;
        }
        export class QueueInfo {
            type: QueueType;
            constructor(type?: QueueType);
            copy(info: Readonly<QueueInfo>): QueueInfo;
        }
        export class QueryPoolInfo {
            type: QueryType;
            maxQueryObjects: number;
            forceWait: boolean;
            constructor(type?: QueryType, maxQueryObjects?: number, forceWait?: boolean);
            copy(info: Readonly<QueryPoolInfo>): QueryPoolInfo;
        }
        export class FormatInfo {
            name: string;
            size: number;
            count: number;
            type: FormatType;
            hasAlpha: boolean;
            hasDepth: boolean;
            hasStencil: boolean;
            isCompressed: boolean;
            constructor(name?: string, size?: number, count?: number, type?: FormatType, hasAlpha?: boolean, hasDepth?: boolean, hasStencil?: boolean, isCompressed?: boolean);
            copy(info: Readonly<FormatInfo>): FormatInfo;
        }
        export class MemoryStatus {
            bufferSize: number;
            textureSize: number;
            constructor(bufferSize?: number, textureSize?: number);
            copy(info: Readonly<MemoryStatus>): MemoryStatus;
        }
        export class DynamicStencilStates {
            writeMask: number;
            compareMask: number;
            reference: number;
            constructor(writeMask?: number, compareMask?: number, reference?: number);
            copy(info: Readonly<DynamicStencilStates>): DynamicStencilStates;
        }
        export class DynamicStates {
            viewport: Viewport;
            scissor: Rect;
            blendConstant: Color;
            lineWidth: number;
            depthBiasConstant: number;
            depthBiasClamp: number;
            depthBiasSlope: number;
            depthMinBounds: number;
            depthMaxBounds: number;
            stencilStatesFront: DynamicStencilStates;
            stencilStatesBack: DynamicStencilStates;
            constructor(viewport?: Viewport, scissor?: Rect, blendConstant?: Color, lineWidth?: number, depthBiasConstant?: number, depthBiasClamp?: number, depthBiasSlope?: number, depthMinBounds?: number, depthMaxBounds?: number, stencilStatesFront?: DynamicStencilStates, stencilStatesBack?: DynamicStencilStates);
            copy(info: Readonly<DynamicStates>): DynamicStates;
        }
        /**
         * ========================= !DO NOT CHANGE THE ABOVE SECTION MANUALLY! =========================
         * The above section is auto-generated from native/cocos/renderer/core/gfx/GFXDef-common.h
         * by the script native/tools/gfx-define-generator/generate.js.
         * Changes to these public interfaces should be made there first and synced back.
         * ========================= !DO NOT CHANGE THE ABOVE SECTION MANUALLY! =========================
         */
        /**
         * @en GFX base object.
         * @zh GFX 基类对象。
         */
        export class GFXObject extends __private._cocos_core_data_gc_object__GCObject {
            get objectType(): ObjectType;
            get objectID(): number;
            get typedID(): number;
            protected _objectType: ObjectType;
            protected _objectID: number;
            protected _typedID: number;
            constructor(objectType: ObjectType);
        }
        export interface ISwapchainTextureInfo {
            swapchain: Swapchain;
            format: Format;
            width: number;
            height: number;
        }
        export enum AttributeName {
            ATTR_POSITION = "a_position",
            ATTR_NORMAL = "a_normal",
            ATTR_TANGENT = "a_tangent",
            ATTR_BITANGENT = "a_bitangent",
            ATTR_WEIGHTS = "a_weights",
            ATTR_JOINTS = "a_joints",
            ATTR_COLOR = "a_color",
            ATTR_COLOR1 = "a_color1",
            ATTR_COLOR2 = "a_color2",
            ATTR_TEX_COORD = "a_texCoord",
            ATTR_TEX_COORD1 = "a_texCoord1",
            ATTR_TEX_COORD2 = "a_texCoord2",
            ATTR_TEX_COORD3 = "a_texCoord3",
            ATTR_TEX_COORD4 = "a_texCoord4",
            ATTR_TEX_COORD5 = "a_texCoord5",
            ATTR_TEX_COORD6 = "a_texCoord6",
            ATTR_TEX_COORD7 = "a_texCoord7",
            ATTR_TEX_COORD8 = "a_texCoord8",
            ATTR_BATCH_ID = "a_batch_id",
            ATTR_BATCH_UV = "a_batch_uv"
        }
        export const FormatInfos: readonly FormatInfo[];
        export const DESCRIPTOR_BUFFER_TYPE: number;
        export const DESCRIPTOR_SAMPLER_TYPE: number;
        export const DESCRIPTOR_DYNAMIC_TYPE: number;
        export const DRAW_INFO_SIZE = 28;
        export type BufferSource = ArrayBuffer | IndirectBuffer;
        export interface FormatAlignment {
            width: number;
            height: number;
        }
        export type TextureHandle = __private._cocos_gfx_base_define__GPUTexture | number;
        /**
         * @en GFX Device.
         * @zh GFX 设备。
         */
        export abstract class Device {
            /**
             * @en Current rendering API.
             * @zh 当前 GFX 使用的渲染 API。
             */
            get gfxAPI(): API;
            /**
             * @en GFX default queue.
             * @zh GFX 默认队列。
             */
            get queue(): Queue;
            /**
             * @en GFX default command buffer.
             * @zh GFX 默认命令缓冲。
             */
            get commandBuffer(): CommandBuffer;
            /**
             * @en The current format of the swapchain being used.
             * @zh 当前使用的swapchain的格式。
             */
            get swapchainFormat(): Format;
            /**
             * @en Renderer description.
             * @zh 渲染器描述。
             */
            get renderer(): string;
            /**
             * @en Vendor description.
             * @zh 厂商描述。
             */
            get vendor(): string;
            /**
             * @en Number of draw calls currently recorded.
             * @zh 绘制调用次数。
             */
            get numDrawCalls(): number;
            /**
             * @en Number of instances currently recorded.
             * @zh 绘制 Instance 数量。
             */
            get numInstances(): number;
            /**
             * @en Number of triangles currently recorded.
             * @zh 渲染三角形数量。
             */
            get numTris(): number;
            /**
             * @en Total memory size currently allocated.
             * @zh 内存状态。
             */
            get memoryStatus(): MemoryStatus;
            /**
             * @en Current device capabilities.
             * @zh 当前设备能力数据。
             */
            get capabilities(): DeviceCaps;
            /**
             * @en Current device binding mappings.
             * @zh 当前设备的绑定槽位映射关系。
             */
            get bindingMappingInfo(): BindingMappingInfo;
            protected _gfxAPI: API;
            protected _renderer: string;
            protected _vendor: string;
            protected _features: boolean[];
            protected _formatFeatures: FormatFeatureBit[];
            protected _queue: Queue | null;
            protected _cmdBuff: CommandBuffer | null;
            protected _numDrawCalls: number;
            protected _numInstances: number;
            protected _numTris: number;
            protected _memoryStatus: MemoryStatus;
            protected _caps: DeviceCaps;
            protected _bindingMappingInfo: BindingMappingInfo;
            protected _samplers: Map<number, Sampler>;
            protected _generalBarrierss: Map<number, GeneralBarrier>;
            protected _textureBarriers: Map<number, TextureBarrier>;
            protected _bufferBarriers: Map<number, __private._cocos_gfx_base_states_buffer_barrier__BufferBarrier>;
            protected _swapchainFormat: Format;
            static canvas: HTMLCanvasElement;
            abstract initialize(info: Readonly<DeviceInfo>): boolean | Promise<boolean>;
            abstract destroy(): void;
            /**
             * @en Acquire next swapchain image.
             * @zh 获取下一个交换链缓冲。
             */
            abstract acquire(swapchains: Readonly<Swapchain[]>): void;
            /**
             * @en Present current swapchain image.
             * @zh 上屏当前交换链缓冲。
             */
            abstract present(): void;
            /**
             * @en Flush the specified command buffers.
             * @zh 实际录制指定的命令缓冲。
             */
            abstract flushCommands(cmdBuffs: Readonly<CommandBuffer[]>): void;
            /**
             * @en Create command buffer.
             * @zh 创建命令缓冲。
             * @param info GFX command buffer description info.
             */
            abstract createCommandBuffer(info: Readonly<CommandBufferInfo>): CommandBuffer;
            /**
             * @en Create swapchain.
             * @zh 创建交换链。
             * @param info GFX swapchain description info.
             */
            abstract createSwapchain(info: Readonly<SwapchainInfo>): Swapchain;
            /**
             * @en Create buffer.
             * @zh 创建缓冲。
             * @param info GFX buffer description info.
             */
            abstract createBuffer(info: Readonly<BufferInfo> | BufferViewInfo): Buffer;
            /**
             * @en Create texture.
             * @zh 创建纹理。
             * @param info GFX texture description info.
             */
            abstract createTexture(info: Readonly<TextureInfo> | TextureViewInfo): Texture;
            /**
             * @en Create descriptor sets.
             * @zh 创建描述符集组。
             * @param info GFX descriptor sets description info.
             */
            abstract createDescriptorSet(info: Readonly<DescriptorSetInfo>): DescriptorSet;
            /**
             * @en Create shader.
             * @zh 创建着色器。
             * @param info GFX shader description info.
             */
            abstract createShader(info: Readonly<ShaderInfo>): Shader;
            /**
             * @en Create input assembler.
             * @zh 创建纹理。
             * @param info GFX input assembler description info.
             */
            abstract createInputAssembler(info: Readonly<InputAssemblerInfo>): InputAssembler;
            /**
             * @en Create render pass.
             * @zh 创建渲染过程。
             * @param info GFX render pass description info.
             */
            abstract createRenderPass(info: Readonly<RenderPassInfo>): RenderPass;
            /**
             * @en Create frame buffer.
             * @zh 创建帧缓冲。
             * @param info GFX frame buffer description info.
             */
            abstract createFramebuffer(info: Readonly<FramebufferInfo>): Framebuffer;
            /**
             * @en Create descriptor set layout.
             * @zh 创建描述符集布局。
             * @param info GFX descriptor set layout description info.
             */
            abstract createDescriptorSetLayout(info: Readonly<DescriptorSetLayoutInfo>): DescriptorSetLayout;
            /**
             * @en Create pipeline layout.
             * @zh 创建管线布局。
             * @param info GFX pipeline layout description info.
             */
            abstract createPipelineLayout(info: Readonly<PipelineLayoutInfo>): PipelineLayout;
            /**
             * @en Create pipeline state.
             * @zh 创建管线状态。
             * @param info GFX pipeline state description info.
             */
            abstract createPipelineState(info: Readonly<PipelineStateInfo>): PipelineState;
            /**
             * @en Create queue.
             * @zh 创建队列。
             * @param info GFX queue description info.
             */
            abstract createQueue(info: Readonly<QueueInfo>): Queue;
            /**
             * @en Create sampler.
             * @zh 创建采样器。
             * @param info GFX sampler description info.
             */
            abstract getSampler(info: Readonly<SamplerInfo>): Sampler;
            /**
             * @en Get swapchains.
             * @zh 获取交换链列表。
             */
            abstract getSwapchains(): Readonly<Swapchain[]>;
            /**
             * @en Create global barrier.
             * @zh 创建全局内存屏障。
             * @param info GFX global barrier description info.
             */
            abstract getGeneralBarrier(info: Readonly<GeneralBarrierInfo>): GeneralBarrier;
            /**
             * @en Create texture barrier.
             * @zh 创建贴图内存屏障。
             * @param info GFX texture barrier description info.
             */
            abstract getTextureBarrier(info: Readonly<TextureBarrierInfo>): TextureBarrier;
            /**
             * @en Create buffer barrier.
             * @zh 创建buffer内存屏障。
             * @param info GFX buffer barrier description info.
             */
            abstract getBufferBarrier(info: Readonly<BufferBarrierInfo>): __private._cocos_gfx_base_states_buffer_barrier__BufferBarrier;
            /**
             * @en Copy buffers to texture.
             * @zh 拷贝缓冲到纹理。
             * @param buffers The buffers to be copied.
             * @param texture The texture to copy to.
             * @param regions The region descriptions.
             */
            abstract copyBuffersToTexture(buffers: Readonly<ArrayBufferView[]>, texture: Texture, regions: Readonly<BufferTextureCopy[]>): void;
            /**
             * @en Copy texture to buffers
             * @zh 拷贝纹理到缓冲
             * @param texture The texture to be copied.
             * @param buffers The buffer to copy to.
             * @param regions The region descriptions
             */
            abstract copyTextureToBuffers(texture: Readonly<Texture>, buffers: ArrayBufferView[], regions: Readonly<BufferTextureCopy[]>): void;
            /**
             * @en Copy texture images to texture.
             * @zh 拷贝图像到纹理。
             * @param texImages The texture to be copied.
             * @param texture The texture to copy to.
             * @param regions The region descriptions.
             */
            abstract copyTexImagesToTexture(texImages: Readonly<TexImageSource[]>, texture: Texture, regions: Readonly<BufferTextureCopy[]>): void;
            /**
             * @en Whether the device has specific feature.
             * @zh 是否具备特性。
             * @param feature The GFX feature to be queried.
             */
            hasFeature(feature: Feature): boolean;
            /**
             * @en The extent a specific format is supported by the backend.
             * @zh 后端对特定格式的支持程度。
             * @param format The GFX format to be queried.
             */
            getFormatFeatures(format: Format): FormatFeature;
            /**
             * @en Enable automatically barrier deduction GFX inside, no effect on web.
             * @zh 是否开启自动GFX内部barrier推导，web无影响。
             * @param format The GFX format to be queried.
             */
            enableAutoBarrier(en: boolean): void;
            /**
             * @en Get maximum supported sample count.
             * @zh 获取最大可支持的 Samples 参数
             * @param format The GFX texture format.
             * @param usage The GFX texture usage.
             * @param flags The GFX texture create flags.
             */
            getMaxSampleCount(format: Format, usage: TextureUsage, flags: TextureFlags): SampleCount;
        }
        export class DefaultResource {
            constructor(device: Device);
            getTexture(type: TextureType): Texture | null;
        }
        /**
         * @en GFX Swapchain.
         * @zh GFX 交换链。
         */
        export abstract class Swapchain extends GFXObject {
            /**
             * @en The color texture of this swapchain.
             * @zh 当前交换链的颜色缓冲。
             */
            get colorTexture(): Texture;
            /**
             * @en The depth stencil texture of this swapchain.
             * @zh 当前交换链的深度模板缓冲。
             */
            get depthStencilTexture(): Texture;
            /**
             * @en The surface transform to be applied in projection matrices.
             * @zh 需要在投影矩阵中应用的表面变换。
             */
            get surfaceTransform(): SurfaceTransform;
            get width(): number;
            get height(): number;
            protected _transform: SurfaceTransform;
            protected _colorTexture: Texture;
            protected _depthStencilTexture: Texture;
            constructor();
            abstract initialize(info: Readonly<SwapchainInfo>): void;
            abstract resize(width: number, height: number, surfaceTransform: SurfaceTransform): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX frame buffer.
         * @zh GFX 帧缓冲。
         */
        export abstract class Framebuffer extends GFXObject {
            /**
             * @en Get current render pass.
             * @zh GFX 渲染过程。
             */
            get renderPass(): RenderPass;
            /**
             * @en Get current color views.
             * @zh 颜色纹理视图数组。
             */
            get colorTextures(): (Texture | null)[];
            /**
             * @en Get current depth stencil views.
             * @zh 深度模板纹理视图。
             */
            get depthStencilTexture(): Texture | null;
            get width(): number;
            get height(): number;
            get needRebuild(): boolean;
            protected _renderPass: RenderPass | null;
            protected _colorTextures: (Texture | null)[];
            protected _depthStencilTexture: Texture | null;
            protected _width: number;
            protected _height: number;
            constructor();
            abstract initialize(info: Readonly<FramebufferInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX input assembler.
         * @zh GFX 输入汇集器。
         */
        export abstract class InputAssembler extends GFXObject {
            /**
             * @en Get current attributes.
             * @zh 顶点属性数组。
             */
            get attributes(): Attribute[];
            /**
             * @en Get current vertex buffers.
             * @zh 顶点缓冲数组。
             */
            get vertexBuffers(): Buffer[];
            /**
             * @en Get current index buffer.
             * @zh 索引缓冲。
             */
            get indexBuffer(): Buffer | null;
            /**
             * @en Get the indirect buffer, if present.
             * @zh 间接绘制缓冲。
             */
            get indirectBuffer(): Buffer | null;
            /**
             * @en Get hash of current attributes.
             * @zh 获取顶点属性数组的哈希值。
             */
            get attributesHash(): number;
            /**
             * @en Get current vertex count.
             * @zh 顶点数量。
             */
            set vertexCount(count: number);
            get vertexCount(): number;
            /**
             * @en Get starting vertex.
             * @zh 起始顶点。
             */
            set firstVertex(first: number);
            get firstVertex(): number;
            /**
             * @en Get current index count.
             * @zh 索引数量。
             */
            set indexCount(count: number);
            get indexCount(): number;
            /**
             * @en Get starting index.
             * @zh 起始索引。
             */
            set firstIndex(first: number);
            get firstIndex(): number;
            /**
             * @en Get current vertex offset.
             * @zh 顶点偏移量。
             */
            set vertexOffset(offset: number);
            get vertexOffset(): number;
            /**
             * @en Get current instance count.
             * @zh 实例数量。
             */
            set instanceCount(count: number);
            get instanceCount(): number;
            /**
             * @en Get starting instance.
             * @zh 起始实例。
             */
            set firstInstance(first: number);
            get firstInstance(): number;
            /**
             * @en set the draw range
             * @zh 设置渲染范围
             */
            set drawInfo(info: DrawInfo);
            /**
             * @en get the draw range
             * @zh 获取渲染范围
             */
            get drawInfo(): DrawInfo;
            protected _attributes: Attribute[];
            protected _attributesHash: number;
            protected _vertexBuffers: Buffer[];
            protected _indexBuffer: Buffer | null;
            protected _indirectBuffer: Buffer | null;
            protected _drawInfo: DrawInfo;
            constructor();
            /**
             * @en Get the specified vertex buffer.
             * @zh 获取顶点缓冲。
             * @param stream The stream index of the vertex buffer.
             */
            getVertexBuffer(stream?: number): Buffer | null;
            protected computeAttributesHash(): number;
            abstract initialize(info: Readonly<InputAssemblerInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX descriptor sets layout.
         * @zh GFX 描述符集布局。
         */
        export abstract class DescriptorSetLayout extends GFXObject {
            get bindings(): DescriptorSetLayoutBinding[];
            get bindingIndices(): number[];
            get descriptorIndices(): number[];
            protected _bindings: DescriptorSetLayoutBinding[];
            protected _bindingIndices: number[];
            protected _descriptorIndices: number[];
            constructor();
            abstract initialize(info: Readonly<DescriptorSetLayoutInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX pipeline layout.
         * @zh GFX 管线布局。
         */
        export abstract class PipelineLayout extends GFXObject {
            get setLayouts(): DescriptorSetLayout[];
            protected _setLayouts: DescriptorSetLayout[];
            constructor();
            abstract initialize(info: Readonly<PipelineLayoutInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX blend state.
         * @zh GFX 混合状态。
         */
        export class BlendState {
            isA2C: boolean;
            isIndepend: boolean;
            blendColor: Color;
            targets: BlendTarget[];
            get native(): BlendState;
            constructor(isA2C?: boolean, isIndepend?: boolean, blendColor?: Color, targets?: BlendTarget[]);
            /**
             * @en Should use this function to set target, or it will not work
             * on native platforms, as native can not support this feature,
             * such as `blendState[i] = target;`.
             *
             * @param index The index to set target.
             * @param target The target to be set.
             */
            setTarget(index: number, target: BlendTarget): void;
            reset(): void;
            destroy(): void;
        }
        /**
         * @en GFX blend target.
         * @zh GFX 混合目标。
         */
        export class BlendTarget {
            blend: boolean;
            blendSrc: BlendFactor;
            blendDst: BlendFactor;
            blendEq: BlendOp;
            blendSrcAlpha: BlendFactor;
            blendDstAlpha: BlendFactor;
            blendAlphaEq: BlendOp;
            blendColorMask: ColorMask;
            constructor(blend?: boolean, blendSrc?: BlendFactor, blendDst?: BlendFactor, blendEq?: BlendOp, blendSrcAlpha?: BlendFactor, blendDstAlpha?: BlendFactor, blendAlphaEq?: BlendOp, blendColorMask?: ColorMask);
            reset(): void;
            assign(target: BlendTarget): void;
            destroy(): void;
        }
        /**
         * @en GFX rasterizer state.
         * @zh GFX 光栅化状态。
         */
        export class RasterizerState {
            isDiscard: boolean;
            polygonMode: PolygonMode;
            shadeModel: ShadeModel;
            cullMode: CullMode;
            isFrontFaceCCW: boolean;
            depthBiasEnabled: boolean;
            depthBias: number;
            depthBiasClamp: number;
            depthBiasSlop: number;
            isDepthClip: boolean;
            isMultisample: boolean;
            lineWidth: number;
            get native(): RasterizerState;
            constructor(isDiscard?: boolean, polygonMode?: PolygonMode, shadeModel?: ShadeModel, cullMode?: CullMode, isFrontFaceCCW?: boolean, depthBiasEnabled?: boolean, depthBias?: number, depthBiasClamp?: number, depthBiasSlop?: number, isDepthClip?: boolean, isMultisample?: boolean, lineWidth?: number);
            reset(): void;
            assign(rs: RasterizerState): void;
            destroy(): void;
        }
        /**
         * @en GFX depth stencil state.
         * @zh GFX 深度模板状态。
         */
        export class DepthStencilState {
            depthTest: boolean;
            depthWrite: boolean;
            depthFunc: ComparisonFunc;
            stencilTestFront: boolean;
            stencilFuncFront: ComparisonFunc;
            stencilReadMaskFront: number;
            stencilWriteMaskFront: number;
            stencilFailOpFront: StencilOp;
            stencilZFailOpFront: StencilOp;
            stencilPassOpFront: StencilOp;
            stencilRefFront: number;
            stencilTestBack: boolean;
            stencilFuncBack: ComparisonFunc;
            stencilReadMaskBack: number;
            stencilWriteMaskBack: number;
            stencilFailOpBack: StencilOp;
            stencilZFailOpBack: StencilOp;
            stencilPassOpBack: StencilOp;
            stencilRefBack: number;
            get native(): DepthStencilState;
            constructor(depthTest?: boolean, depthWrite?: boolean, depthFunc?: ComparisonFunc, stencilTestFront?: boolean, stencilFuncFront?: ComparisonFunc, stencilReadMaskFront?: number, stencilWriteMaskFront?: number, stencilFailOpFront?: StencilOp, stencilZFailOpFront?: StencilOp, stencilPassOpFront?: StencilOp, stencilRefFront?: number, stencilTestBack?: boolean, stencilFuncBack?: ComparisonFunc, stencilReadMaskBack?: number, stencilWriteMaskBack?: number, stencilFailOpBack?: StencilOp, stencilZFailOpBack?: StencilOp, stencilPassOpBack?: StencilOp, stencilRefBack?: number);
            reset(): void;
            assign(dss: DepthStencilState): void;
            destroy(): void;
        }
        export class PipelineStateInfo {
            shader: Shader;
            pipelineLayout: PipelineLayout;
            renderPass: RenderPass;
            inputState: InputState;
            rasterizerState: RasterizerState;
            depthStencilState: DepthStencilState;
            blendState: BlendState;
            primitive: PrimitiveMode;
            dynamicStates: DynamicStateFlags;
            bindPoint: PipelineBindPoint;
            constructor(shader?: Shader, pipelineLayout?: PipelineLayout, renderPass?: RenderPass, inputState?: InputState, rasterizerState?: RasterizerState, depthStencilState?: DepthStencilState, blendState?: BlendState, primitive?: PrimitiveMode, dynamicStates?: DynamicStateFlags, bindPoint?: PipelineBindPoint);
        }
        /**
         * @en GFX pipeline state.
         * @zh GFX 管线状态。
         */
        export abstract class PipelineState extends GFXObject {
            /**
             * @en Get current shader.
             * @zh GFX 着色器。
             */
            get shader(): Shader;
            /**
             * @en Get current pipeline layout.
             * @zh GFX 管线布局。
             */
            get pipelineLayout(): PipelineLayout;
            /**
             * @en Get current primitve mode.
             * @zh GFX 图元模式。
             */
            get primitive(): PrimitiveMode;
            /**
             * @en Get current rasterizer state.
             * @zh GFX 光栅化状态。
             */
            get rasterizerState(): RasterizerState;
            /**
             * @en Get current depth stencil state.
             * @zh GFX 深度模板状态。
             */
            get depthStencilState(): DepthStencilState;
            /**
             * @en Get current blend state.
             * @zh GFX 混合状态。
             */
            get blendState(): BlendState;
            /**
             * @en Get current input state.
             * @zh GFX 输入状态。
             */
            get inputState(): InputState;
            /**
             * @en Get current dynamic states.
             * @zh GFX 动态状态数组。
             */
            get dynamicStates(): DynamicStateFlags;
            /**
             * @en Get current render pass.
             * @zh GFX 渲染过程。
             */
            get renderPass(): RenderPass;
            protected _shader: Shader | null;
            protected _pipelineLayout: PipelineLayout | null;
            protected _primitive: PrimitiveMode;
            protected _is: InputState | null;
            protected _rs: RasterizerState;
            protected _dss: DepthStencilState;
            protected _bs: BlendState;
            protected _dynamicStates: DynamicStateFlags;
            protected _renderPass: RenderPass | null;
            constructor();
            abstract initialize(info: Readonly<PipelineStateInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX Queue.
         * @zh GFX 队列。
         */
        export abstract class Queue extends GFXObject {
            /**
             * @en Get current type.
             * @zh 队列类型。
             */
            get type(): number;
            protected _type: QueueType;
            constructor();
            abstract initialize(info: Readonly<QueueInfo>): void;
            abstract destroy(): void;
            /**
             * @en Submit command buffers.
             * @zh 提交命令缓冲数组。
             * @param cmdBuffs The command buffers to be submitted.
             * @param fence The syncing fence.
             */
            abstract submit(cmdBuffs: Readonly<CommandBuffer[]>): void;
        }
        /**
         * @en GFX render pass.
         * @zh GFX 渲染过程。
         */
        export abstract class RenderPass extends GFXObject {
            protected _colorInfos: ColorAttachment[];
            protected _depthStencilInfo: DepthStencilAttachment | null;
            protected _subpasses: SubpassInfo[];
            protected _hash: number;
            get colorAttachments(): Readonly<ColorAttachment[]>;
            get depthStencilAttachment(): Readonly<DepthStencilAttachment> | null;
            get subPasses(): Readonly<SubpassInfo[]>;
            get hash(): number;
            constructor();
            protected computeHash(): number;
            abstract initialize(info: Readonly<RenderPassInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX shader.
         * @zh GFX 着色器。
         */
        export abstract class Shader extends GFXObject {
            get name(): string;
            get attributes(): Attribute[];
            get blocks(): UniformBlock[];
            get samplers(): UniformSampler[];
            get stages(): ShaderStage[];
            protected _name: string;
            protected _stages: ShaderStage[];
            protected _attributes: Attribute[];
            protected _blocks: UniformBlock[];
            protected _samplers: UniformSampler[];
            constructor();
            abstract initialize(info: Readonly<ShaderInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX texture.
         * @zh GFX 纹理。
         */
        export abstract class Texture extends GFXObject {
            /**
             * @en Get texture type.
             * @zh 纹理类型。
             */
            get type(): TextureType;
            /**
             * @en Get texture usage.
             * @zh 纹理使用方式。
             */
            get usage(): TextureUsage;
            /**
             * @en Get texture format.
             * @zh 纹理格式。
             */
            get format(): Format;
            /**
             * @en Get texture width.
             * @zh 纹理宽度。
             */
            get width(): number;
            /**
             * @en Get texture height.
             * @zh 纹理高度。
             */
            get height(): number;
            /**
             * @en Get texture depth.
             * @zh 纹理深度。
             */
            get depth(): number;
            /**
             * @en Get texture array layer.
             * @zh 纹理数组层数。
             */
            get layerCount(): number;
            /**
             * @en Get texture mip level.
             * @zh 纹理 mip 层级数。
             */
            get levelCount(): number;
            /**
             * @en Get texture samples.
             * @zh 纹理采样数。
             */
            get samples(): SampleCount;
            /**
             * @en Get texture flags.
             * @zh 纹理标识位。
             */
            get flags(): TextureFlags;
            /**
             * @en Get texture size.
             * @zh 纹理大小。
             */
            get size(): number;
            /**
             * @en Get texture info.
             * @zh 纹理信息。
             */
            get info(): Readonly<TextureInfo>;
            /**
             * @en Get view info.
             * @zh 纹理视图信息。
             */
            get viewInfo(): Readonly<TextureViewInfo>;
            /**
             * @en Get texture type.
             * @zh 是否为纹理视图。
             */
            get isTextureView(): boolean;
            protected _info: TextureInfo;
            protected _viewInfo: TextureViewInfo;
            protected _isPowerOf2: boolean;
            protected _isTextureView: boolean;
            protected _size: number;
            constructor();
            abstract initialize(info: Readonly<TextureInfo> | Readonly<TextureViewInfo>): void;
            abstract destroy(): void;
            abstract getTextureHandle(): TextureHandle;
            /**
             * @en Resize texture.
             * @zh 重置纹理大小。
             * @param width The new width.
             * @param height The new height.
             */
            abstract resize(width: number, height: number): void;
            static getLevelCount(width: number, height: number): number;
        }
        /**
         * @en GFX global barrier.
         * @zh GFX 全局内存屏障。
         */
        export class GeneralBarrier extends GFXObject {
            get info(): Readonly<GeneralBarrierInfo>;
            get hash(): number;
            protected _info: GeneralBarrierInfo;
            protected _hash: number;
            constructor(info: Readonly<GeneralBarrierInfo>, hash: number);
            static computeHash(info: Readonly<GeneralBarrierInfo>): number;
        }
        /**
         * @en GFX texture barrier.
         * @zh GFX 贴图内存屏障。
         */
        export class TextureBarrier extends GFXObject {
            get info(): Readonly<TextureBarrierInfo>;
            get hash(): number;
            protected _info: TextureBarrierInfo;
            protected _hash: number;
            constructor(info: Readonly<TextureBarrierInfo>, hash: number);
            static computeHash(info: Readonly<TextureBarrierInfo>): number;
        }
        /**
         * @en
         * Sets the renderer type, only useful on web
         *
         * @zh
         * 渲染模式。
         * 设置渲染器类型，仅适用于 web 端
         * @internal
         */
        export enum LegacyRenderMode {
            /**
             * @en
             * Automatically chosen by engine.
             * @zh
             * 通过引擎自动选择。
             */
            AUTO = 0,
            /**
             * @en
             * Forced to use canvas renderer.
             * @zh
             * 强制使用 canvas 渲染。
             */
            CANVAS = 1,
            /**
             * @en
             * Forced to use WebGL renderer, but this will be ignored on mobile browsers.
             * @zh
             * 强制使用 WebGL 渲染，但是在部分 Android 浏览器中这个选项会被忽略。
             */
            WEBGL = 2,
            /**
             * @en
             * Use Headless Renderer, which is useful in test or server env, only for internal use by cocos team for now
             * @zh
             * 使用空渲染器，可以用于测试和服务器端环境，目前暂时用于 Cocos 内部测试使用。
             */
            HEADLESS = 3,
            /**
             * @en
             * Force WebGPU rendering, but this option will be ignored in some browsers.
             * @zh
             * 强制使用 WebGPU 渲染，但是在部分浏览器中这个选项会被忽略。
             */
            WEBGPU = 4
        }
        /**
         * @internal
         */
        export enum RenderType {
            UNKNOWN = "Bad expression <-1>",
            CANVAS = 0,
            WEBGL = 1,
            WEBGPU = 2,
            OPENGL = 3,
            HEADLESS = 4
        }
        /**
         * @internal
         */
        export class DeviceManager {
            get gfxDevice(): Device;
            get swapchain(): Swapchain;
            init(canvas: HTMLCanvasElement | null, bindingMappingInfo: BindingMappingInfo): boolean | Promise<boolean>;
        }
        /**
         * @internal
         */
        export const deviceManager: DeviceManager;
    }
    export namespace renderer {
        export function createIA(device: gfx.Device, data: primitives.IGeometry): gfx.InputAssembler | null;
        export const addStage: (name: any) => void;
        export interface IProgramInfo extends EffectAsset.IShaderInfo {
            effectName: string;
            defines: __private._cocos_render_scene_core_program_lib__IDefineRecord[];
            constantMacros: string;
            uber: boolean;
        }
        export interface ITemplateInfo {
            gfxAttributes: gfx.Attribute[];
            shaderInfo: gfx.ShaderInfo;
            blockSizes: number[];
            setLayouts: gfx.DescriptorSetLayout[];
            pipelineLayout: gfx.PipelineLayout;
            handleMap: Record<string, number>;
            bindings: gfx.DescriptorSetLayoutBinding[];
            samplerStartBinding: number;
        }
        export const programLib: __private._cocos_render_scene_core_program_lib__ProgramLib;
        export function getDeviceShaderVersion(device: gfx.Device): string;
        /**
         * @en The render window represents the render target, it could be an off screen frame buffer or the on screen buffer.
         * @zh 渲染窗口代表了一个渲染目标，可以是离屏的帧缓冲，也可以是屏幕缓冲
         */
        export class RenderWindow {
            /**
             * @en Get window width. Pre-rotated (i.e. rotationally invariant, always in identity/portrait mode) if possible.
             * If you want to get oriented size instead, you should use [[renderer.scene.Camera.width]] which corresponds to the current screen rotation.
             * @zh 获取窗口宽度。如果支持交换链预变换，返回值将始终处于单位旋转（竖屏）坐标系下。如果需要获取旋转后的尺寸，请使用 [[renderer.scene.Camera.width]]。
             */
            get width(): number;
            /**
             * @en Get window height. Pre-rotated (i.e. rotationally invariant, always in identity/portrait mode) if possible.
             * If you want to get oriented size instead, you should use [[renderer.scene.Camera.width]] which corresponds to the current screen rotation.
             * @zh 获取窗口高度。如果支持交换链预变换，返回值将始终处于单位旋转（竖屏）坐标系下。如果需要获取旋转后的尺寸，请使用 [[renderer.scene.Camera.height]]。
             */
            get height(): number;
            /**
             * @en Get the swapchain for this window, if there is one
             * @zh 如果存在的话，获取此窗口的交换链
             */
            get swapchain(): gfx.Swapchain;
            /**
             * @en Get window frame buffer.
             * @zh 帧缓冲对象。
             */
            get framebuffer(): gfx.Framebuffer;
            get cameras(): scene.Camera[];
            /**
             * @en Get render window Id.
             * Render windowd Id is used to identify the render window in the render pipeline.
             * @zh 获得渲染窗口Id。渲染窗口Id用于在渲染管线中标识渲染窗口。
             */
            get renderWindowId(): number;
            /**
             * @en Get the name of the color attachment.
             * The name is used to identify the color attachment in the render pipeline.
             * @zh 获取颜色附件的名称。用于自定义渲染管线中的资源注册。
             */
            get colorName(): string;
            /**
             * @en Get the name of the depth stencil attachment.
             * The name is used to identify the depth stencil attachment in the render pipeline.
             * @zh 获取深度模板附件的名称。用于自定义渲染管线中的资源注册。
             */
            get depthStencilName(): string;
            /**
             * @en The render pipeline should handle the resize event properly
             * @zh 渲染管线应该正确处理窗口大小变化事件
             */
            isRenderWindowResized(): boolean;
            /**
             * @en The render pipeline should set this value to false after handling the resize event
             * @zh 渲染管线应该在处理完窗口大小变化事件后将此值设置为 false
             */
            setRenderWindowResizeHandled(): void;
            protected _title: string;
            protected _width: number;
            protected _height: number;
            protected _swapchain: gfx.Swapchain;
            protected _renderPass: gfx.RenderPass | null;
            protected _colorTextures: gfx.Texture[];
            protected _depthStencilTexture: gfx.Texture | null;
            protected _cameras: scene.Camera[];
            protected _hasOnScreenAttachments: boolean;
            protected _hasOffScreenAttachments: boolean;
            protected _framebuffer: gfx.Framebuffer | null;
            protected _device: gfx.Device | null;
            protected _renderWindowId: number;
            protected _isResized: boolean;
            protected _colorName: string;
            protected _depthStencilName: string;
            /**
             * @private
             */
            static registerCreateFunc(root: Root): void;
            initialize(device: gfx.Device, info: __private._cocos_render_scene_core_render_window__IRenderWindowInfo): boolean;
            destroy(): void;
            /**
             * @en Resize window.
             * @zh 重置窗口大小。
             * @param width The new width.
             * @param height The new height.
             */
            resize(width: number, height: number): void;
            /**
             * @en Extract all render cameras attached to the render window to the output cameras list
             * @zh 将所有挂载到当前渲染窗口的摄像机存储到输出列表参数中
             * @param cameras @en The output cameras list, should be empty before invoke this function
             *                @zh 输出相机列表参数，传入时应该为空
             */
            extractRenderCameras(cameras: scene.Camera[]): void;
            /**
             * @en Attach a new camera to the render window
             * @zh 添加渲染相机
             * @param camera @en The camera to attach @zh 要挂载的相机
             */
            attachCamera(camera: scene.Camera): void;
            /**
             * @en Detach a camera from the render window
             * @zh 移除场景中的渲染相机
             * @param camera @en The camera to detach @zh 要移除的相机
             */
            detachCamera(camera: scene.Camera): void;
            /**
             * @en Clear all attached cameras
             * @zh 清空全部渲染相机
             */
            clearCameras(): void;
            /**
             * @en Sort all attached cameras with priority
             * @zh 按照优先级对所有挂载的相机排序
             */
            sortCameras(): void;
        }
        export namespace scene {
            /**
             * @en The enumeration type for the fixed axis of the camera.
             * The field of view along the corresponding axis would be fixed regardless of screen aspect changes.
             * @zh 相机视角的锁定轴向枚举，在对应轴上不会跟随屏幕长宽比例变化。
             */
            export enum CameraFOVAxis {
                /**
                 * @en Vertically fixed camera
                 * @zh 在垂直轴向上锁定的相机
                 */
                VERTICAL = 0,
                /**
                 * @en Horizontally fixed camera
                 * @zh 在水平轴向上锁定的相机
                 */
                HORIZONTAL = 1
            }
            /**
             * @en The projection type enumeration of the camera.
             * @zh 相机的投影类型枚举。
             */
            export enum CameraProjection {
                /**
                 * @en Orthogonal projection type
                 * @zh 正交投影类型
                 */
                ORTHO = 0,
                /**
                 * @en Perspective projection type
                 * @zh 透视投影类型
                 */
                PERSPECTIVE = 1
            }
            /**
             * @en The aperture enumeration of the camera, represent in f-number.
             * The smaller the value is, the bigger the aperture is, and more light it can capture, but less depth it supports.
             * @zh 相机的快门枚举，使用 f 值来表示。f 值越小，光圈就越大，进光量也越大，景深越浅。
             */
            export enum CameraAperture {
                /**
                 * f/1.8
                 */
                F1_8 = 0,
                /**
                 * f/2.0
                 */
                F2_0 = 1,
                /**
                 * f/2.2
                 */
                F2_2 = 2,
                /**
                 * f/2.5
                 */
                F2_5 = 3,
                /**
                 * f/2.8
                 */
                F2_8 = 4,
                /**
                 * f/3.2
                 */
                F3_2 = 5,
                /**
                 * f/3.5
                 */
                F3_5 = 6,
                /**
                 * f/4.0
                 */
                F4_0 = 7,
                /**
                 * f/4.5
                 */
                F4_5 = 8,
                /**
                 * f/5.0
                 */
                F5_0 = 9,
                /**
                 * f/5.6
                 */
                F5_6 = 10,
                /**
                 * f/6.3
                 */
                F6_3 = 11,
                /**
                 * f/7.1
                 */
                F7_1 = 12,
                /**
                 * f/8
                 */
                F8_0 = 13,
                /**
                 * f/9
                 */
                F9_0 = 14,
                /**
                 * f/10
                 */
                F10_0 = 15,
                /**
                 * f/11
                 */
                F11_0 = 16,
                /**
                 * f/13
                 */
                F13_0 = 17,
                /**
                 * f/14
                 */
                F14_0 = 18,
                /**
                 * f/16
                 */
                F16_0 = 19,
                /**
                 * f/18
                 */
                F18_0 = 20,
                /**
                 * f/20
                 */
                F20_0 = 21,
                /**
                 * f/22
                 */
                F22_0 = 22
            }
            /**
             * @en The ISO enumeration of the camera, lower ISO means the camera is less sensitive to light.
             * @zh 相机感光度枚举，越低的 ISO 数值表示相机对光更加不敏感。
             */
            export enum CameraISO {
                ISO100 = 0,
                ISO200 = 1,
                ISO400 = 2,
                ISO800 = 3
            }
            /**
             * @en Camera shutter enumeration, the value represents the speed of the shutter.
             * @zh 相机快门枚举，枚举值表示快门速度。
             */
            export enum CameraShutter {
                /**
                 * 1 second
                 */
                D1 = 0,
                /**
                 * 1/2 second
                 */
                D2 = 1,
                /**
                 * 1/4 second
                 */
                D4 = 2,
                /**
                 * 1/8 second
                 */
                D8 = 3,
                /**
                 * 1/15 second
                 */
                D15 = 4,
                /**
                 * 1/30 second
                 */
                D30 = 5,
                /**
                 * 1/60 second
                 */
                D60 = 6,
                /**
                 * 1/125 second
                 */
                D125 = 7,
                /**
                 * 1/250 second
                 */
                D250 = 8,
                /**
                 * 1/500 second
                 */
                D500 = 9,
                /**
                 * 1/1000 second
                 */
                D1000 = 10,
                /**
                 * 1/2000 second
                 */
                D2000 = 11,
                /**
                 * 1/4000 second
                 */
                D4000 = 12
            }
            /**
             * @en The type of the camera, mainly for marking different camera usage in XR, it determines the camera's viewport and parameters.
             * @zh 相机类型，主要服务于标记 XR 中的不同相机用途，影响渲染的视口和对应的参数。
             */
            export enum CameraType {
                /**
                 * @en Default camera type
                 * @zh 默认相机类型
                 */
                DEFAULT = "Bad expression <-1>",
                /**
                 * @en If a camera is set to be left eye, it will be used to render the left eye screen,
                 * otherwise, the left eye screen will be rendered using adjusted parameters based on XR main camera.
                 * @zh 如果设置了左眼相机，则在绘制左眼屏幕时使用，否则，就根据 XR 主相机的参数来计算左眼参数。
                 */
                LEFT_EYE = 0,
                /**
                 * @en If a camera is set to be right eye, it will be used to render the right eye screen,
                 * otherwise, the right eye screen will be rendered using adjusted parameters based on XR main camera.
                 * @zh 如果设置了右眼相机，则在绘制右眼屏幕时使用，否则，就根据 XR 主相机的参数来计算左眼参数。
                 */
                RIGHT_EYE = 1,
                /**
                 * @en The main camera, it could be used to calculate the parameters for both left eye and the right eye cameras.
                 * It could be converted from the default 3d camera.
                 * @zh XR 主相机，可以通过默认相机转换，也可以手动创建新的 XR 相机，可以计算出左右两个相机的相对参数。
                 */
                MAIN = 2
            }
            /**
             * @en The spatial tracking signal type used by the camera in XR.
             * @zh 相机使用的 XR 空间定位追踪信号类型。
             */
            export enum TrackingType {
                /**
                 * @en Camera without signal tracking in XR device.
                 * @zh 无追踪相机，不对 XR 设备的信号进行追踪。
                 */
                NO_TRACKING = 0,
                /**
                 * @en Camera tracking position and rotation signals from XR device.
                 * @zh 相机追踪 XR 设备移动位置和旋转角度信号。
                 */
                POSITION_AND_ROTATION = 1,
                /**
                 * @en Camera only tracking position signals from XR device.
                 * @zh 相机只追踪 XR 设备位置信号。
                 */
                POSITION = 2,
                /**
                 * @en Camera only tracking rotation signals from XR device.
                 * @zh 相机只追踪 XR 设备旋转角度信号。
                 */
                ROTATION = 3
            }
            /**
             * @en The usage of the camera, it's an engine internal marker enumeration.
             * @zh 相机的用途枚举，这是引擎内部使用的标记枚举。
             */
            export enum CameraUsage {
                /**
                 * @en Camera used in editor
                 * @zh 编辑器下使用的相机
                 */
                EDITOR = 0,
                /**
                 * @en Camera used in editor's game view.
                 * @zh 编辑器 GameView 视图下使用的相机。
                 */
                GAME_VIEW = 1,
                /**
                 * @en Camera used in editor's scene view.
                 * @zh 编辑器场景编辑器视图下使用的相机。
                 */
                SCENE_VIEW = 2,
                /**
                 * @en Camera used in editor's camera preview window.
                 * @zh 编辑器预览小窗视图下使用的相机。
                 */
                PREVIEW = 3,
                /**
                 * @en Camera used in game, normally user created cameras are all GAME type.
                 * @zh 游戏视图下使用的相机，一般情况下用户创建的相机都是 GAME 类型。
                 */
                GAME = 100
            }
            /**
             * @en The camera creation information struct
             * @zh 用来创建相机的结构体
             */
            export interface ICameraInfo {
                /**
                 * @en The name of the camera.
                 * @zh 相机命名。
                 */
                name: string;
                /**
                 * @en The node which the camera is attached to.
                 * @zh 相机挂载的节点。
                 */
                node: Node;
                /**
                 * @en The projection type of the camera.
                 * @zh 相机的投影类型。
                 */
                projection: CameraProjection;
                /**
                 * @en The id of the target display, if absent, it will be rendered on the default one.
                 * @zh 相机的目标屏幕，如果缺省，将会使用默认屏幕。
                 */
                targetDisplay?: number;
                /**
                 * @en The target render window of the camera, is absent, the camera won't be rendered.
                 * @zh 相机的目标渲染窗口，如果缺省，该相机不会执行渲染流程。
                 */
                window?: RenderWindow | null;
                /**
                 * @en Render priority of the camera. Cameras with higher depth are rendered after cameras with lower depth.
                 * @zh 相机的渲染优先级，值越小越优先渲染。
                 */
                priority: number;
                /**
                 * @internal
                 */
                pipeline?: string;
                /**
                 * @en The type of the camera, mainly for marking different camera usage in XR, it determines the camera's viewport and parameters.
                 * @zh 相机类型，主要服务于标记 XR 中的不同相机用途，影响渲染的视口和对应的参数。
                 */
                cameraType?: CameraType;
                /**
                 * @en The spatial tracking signal type used by the camera in XR.
                 * @zh 相机使用的 XR 空间定位追踪信号类型。
                 */
                trackingType?: TrackingType;
                /**
                 * @internal
                 */
                usage?: CameraUsage;
            }
            export enum SkyBoxFlagValue {
                VALUE = 8
            }
            export const SKYBOX_FLAG: SkyBoxFlagValue;
            /**
             * @en The render camera representation in the render scene, it's managed by [[Camera]]
             * @zh 渲染场景中的相机对象，由项目层的 [[Camera]] 管理。
             */
            export class Camera {
                /**
                 * @en This exposure value corresponding to default standard camera exposure parameters.
                 * @zh 默认相机的曝光值。
                 */
                static get standardExposureValue(): number;
                /**
                 * @en The luminance unit scale used by area lights.
                 * @zh 默认局部光源使用的亮度单位缩放。
                 */
                static get standardLightMeterScale(): number;
                /**
                 * @en The name of the camera
                 * @zh 相机的名称
                 */
                get name(): string | null;
                /**
                 * @en The render scene to which the camera is attached
                 * @zh 相机所挂载的场景
                 */
                get scene(): RenderScene | null;
                /**
                 * @en The node of the camera which determines its transform in world space.
                 * @zh 相机绑定的节点，决定了它在世界空间的变换矩阵
                 */
                set node(val: Node);
                get node(): Node;
                /**
                 * @en The unique ID of system window which the camera will render to.
                 * @zh 相机关联的渲染窗口ID
                 */
                get systemWindowId(): number;
                /**
                 * @en The render window of the camera
                 * @zh 相机关联的渲染窗口
                 */
                set window(val: RenderWindow);
                get window(): RenderWindow;
                /**
                 * @en Whether the camera is enabled, a disabled camera won't be processed in the render pipeline.
                 * @zh 相机是否启用，未启用的相机不会被渲染
                 */
                set enabled(val: boolean);
                get enabled(): boolean;
                /**
                 * @en Visibility mask of the camera, declaring a set of node layers that will be visible to this camera.
                 * @zh 相机的可见性掩码，声明在当前相机中可见的节点层级集合。
                 */
                set visibility(vis: number);
                get visibility(): number;
                /**
                 * @en Render priority of the camera. Cameras with higher depth are rendered after cameras with lower depth.
                 * @zh 相机的渲染优先级，值越小越优先渲染。
                 */
                get priority(): number;
                set priority(val: number);
                /**
                 * @en The width of the camera's view size
                 * @zh 相机的视图宽度
                 */
                get width(): number;
                /**
                 * @en The height of the camera's view size
                 * @zh 相机的视图高度
                 */
                get height(): number;
                /**
                 * @en The world position of the camera
                 * @zh 相机的世界坐标
                 */
                set position(val: math.Vec3);
                get position(): math.Vec3;
                /**
                 * @en The forward vector of the camera's look direction
                 * @zh 指向相机观察方向的向量
                 */
                set forward(val: math.Vec3);
                get forward(): math.Vec3;
                /**
                 * @en Camera aperture, controls the exposure parameter.
                 * @zh 相机光圈，影响相机的曝光参数。
                 */
                set aperture(val: CameraAperture);
                get aperture(): CameraAperture;
                /**
                 * @en Camera aperture value.
                 * @zh 相机光圈值。
                 */
                get apertureValue(): number;
                /**
                 * @en Camera shutter, controls the exposure parameter.
                 * @zh 相机快门，影响相机的曝光参数。
                 */
                set shutter(val: CameraShutter);
                get shutter(): CameraShutter;
                /**
                 * @en Camera shutter value.
                 * @zh 相机快门值。
                 */
                get shutterValue(): number;
                /**
                 * @en Camera ISO, controls the exposure parameter.
                 * @zh 相机感光度，影响相机的曝光参数。
                 */
                set iso(val: CameraISO);
                get iso(): CameraISO;
                /**
                 * @en Camera ISO value.
                 * @zh 相机感光度值。
                 */
                get isoValue(): number;
                /**
                 * @en The calculated exposure of the camera
                 * @zh 相机的曝光参数
                 */
                get exposure(): number;
                /**
                 * @en Clearing flags of the camera, specifies which part of the framebuffer will be actually cleared every frame.
                 * @zh 相机的缓冲清除标志位，指定帧缓冲的哪部分要每帧清除。
                 */
                get clearFlag(): gfx.ClearFlags;
                set clearFlag(flag: gfx.ClearFlags);
                /**
                 * @en Clearing color of the camera.
                 * @zh 相机的颜色缓冲默认值。
                 */
                set clearColor(val: math.IVec4Like);
                get clearColor(): math.IVec4Like;
                /**
                 * @en Clearing depth of the camera.
                 * @zh 相机的深度缓冲默认值。
                 */
                get clearDepth(): number;
                set clearDepth(depth: number);
                /**
                 * @en Clearing stencil of the camera.
                 * @zh 相机的模板缓冲默认值。
                 */
                get clearStencil(): number;
                set clearStencil(stencil: number);
                /**
                 * @en The projection type of the camera.
                 * @zh 相机的投影类型。
                 */
                set projectionType(val: CameraProjection);
                get projectionType(): CameraProjection;
                /**
                 * @en The aspect ratio of the camera
                 * @zh 相机视图的长宽比
                 */
                get aspect(): number;
                /**
                 * @en The viewport height of the orthogonal type camera.
                 * @zh 正交相机的视角高度。
                 */
                set orthoHeight(val: number);
                get orthoHeight(): number;
                /**
                 * @en The axis on which the FOV would be fixed regardless of screen aspect changes.
                 * @zh 指定视角的固定轴向，在此轴上不会跟随屏幕长宽比例变化。
                 */
                set fovAxis(axis: CameraFOVAxis);
                get fovAxis(): CameraFOVAxis;
                /**
                 * @en Field of view of the camera.
                 * @zh 相机的视角大小。
                 */
                set fov(fov: number);
                get fov(): number;
                /**
                 * @en Near clipping distance of the camera, should be as large as possible within acceptable range.
                 * @zh 相机的近裁剪距离，应在可接受范围内尽量取最大。
                 */
                set nearClip(nearClip: number);
                get nearClip(): number;
                /**
                 * @en Far clipping distance of the camera, should be as small as possible within acceptable range.
                 * @zh 相机的远裁剪距离，应在可接受范围内尽量取最小。
                 */
                set farClip(farClip: number);
                get farClip(): number;
                /**
                 * @en The viewport rect of the camera, pre-rotated (i.e. always in identity/portrait mode) if possible.
                 * @zh 相机的视口矩形，如果设备允许的话，这个视口会永远保持竖屏状态，由渲染流程保障旋转的正确。
                 */
                get viewport(): math.Rect;
                set viewport(val: math.Rect);
                /**
                 * @en The view frustum of the camera
                 * @zh 相机的视锥体
                 */
                set frustum(val: geometry.Frustum);
                get frustum(): geometry.Frustum;
                /**
                 * @en The view matrix of the camera
                 * @zh 相机的视图矩阵
                 */
                get matView(): math.Mat4;
                /**
                 * @en The projection matrix of the camera
                 * @zh 相机的投影矩阵
                 */
                get matProj(): math.Mat4;
                /**
                 * @en The inverse of the projection matrix of the camera
                 * @zh 相机的逆投影矩阵
                 */
                get matProjInv(): math.Mat4;
                /**
                 * @en The view projection matrix of the camera
                 * @zh 相机的视图投影矩阵
                 */
                get matViewProj(): math.Mat4;
                /**
                 * @en The inverse of the view projection matrix of the camera
                 * @zh 相机的逆视图投影矩阵
                 */
                get matViewProjInv(): math.Mat4;
                /**
                 * @en Whether the camera is fixed size or matching the window size.
                 * @zh 相机是固定尺寸还是跟随屏幕尺寸
                 */
                isWindowSize: boolean;
                /**
                 * @en Scale of the internal buffer size,
                 * set to 1 to keep the same with the canvas size.
                 * @zh 相机内部缓冲尺寸的缩放值, 1 为与 canvas 尺寸相同。
                 */
                screenScale: number;
                postProcess: postProcess.PostProcess | null;
                usePostProcess: boolean;
                pipeline: string;
                pipelineSettings: object | null;
                constructor(device: gfx.Device);
                /**
                 * @en Initialize the camera, normally you shouldn't invoke this function, it's managed automatically.
                 * @zh 初始化相机，开发者通常不应该使用这个方法，初始化流程是自动管理的。
                 */
                initialize(info: ICameraInfo): void;
                /**
                 * @en Destroy the camera, you shouldn't invoke this function, it's managed by the render scene.
                 * @zh 销毁相机，开发者不应该使用这个方法，销毁流程是由 RenderScene 管理的。
                 */
                destroy(): void;
                /**
                 * @en Attach the camera to the given render scene so that it will be rendered in it.
                 * @zh 将相机添加到相关的渲染场景中，以便可以被渲染器渲染。
                 * @param scene @en The render scene @zh 渲染场景
                 */
                attachToScene(scene: RenderScene): void;
                /**
                 * @en Detach the camera from previously attached render scene. It will no longer be rendered.
                 * @zh 将相机从之前设置的渲染场景移除，之后将不会再被渲染。
                 */
                detachFromScene(): void;
                /**
                 * @en Resize the view size of the camera.
                 * @zh 重置相机视图尺寸
                 * @param width The width of the view size
                 * @param height The height of the view size
                 */
                resize(width: number, height: number): void;
                /**
                 * @en Set a fixed size for the camera view.
                 * @zh 设置固定相机视图尺寸
                 * @param width The width of the view size
                 * @param height The height of the view size
                 */
                setFixedSize(width: number, height: number): void;
                /**
                 * Editor specific gizmo camera logic
                 * @internal
                 */
                syncCameraEditor(camera: any): void;
                /**
                 * @en Update the camera's builtin matrixes
                 * @zh 更新相机的视图、投影等矩阵
                 * @param forceUpdate If force update, then dirty flag will be ignored
                 */
                update(forceUpdate?: boolean): void;
                get surfaceTransform(): gfx.SurfaceTransform;
                /**
                 * @en Set the viewport in oriented space (equal to the actual screen rotation)
                 * @zh 在目标朝向空间（实际屏幕朝向）内设置相机视口
                 */
                setViewportInOrientedSpace(val: math.Rect): void;
                /**
                 * @en create geometry renderer for this camera
                 * @zh 创建这个摄像机的几何体渲染器
                 */
                initGeometryRenderer(): void;
                /**
                 * @en get geometry renderer of this camera
                 * @zh 获取这个摄像机的几何体渲染器
                 * @returns @en return the geometry renderer @zh 返回几何体渲染器
                 */
                get geometryRenderer(): GeometryRenderer | null;
                get cameraType(): CameraType;
                set cameraType(type: CameraType);
                get trackingType(): TrackingType;
                set trackingType(type: TrackingType);
                get cameraUsage(): CameraUsage;
                set cameraUsage(usage: CameraUsage);
                /**
                 * @en Change the target render window to another one
                 * @zh 修改相机的目标渲染窗口
                 * @param window The target render window, could be null
                 */
                changeTargetWindow(window?: RenderWindow | null): void;
                /**
                 * @en Detach camera from the render window
                 * @zh 将 camera 从渲染窗口移除
                 */
                detachCamera(): void;
                /**
                 * @en Transform a screen position (in oriented space) to a world space ray
                 * @zh 将一个屏幕空间（在实际朝向下）点转换到世界空间的射线
                 * @param out the resulting ray
                 * @param x the screen x of the position
                 * @param y the screen y of the position
                 * @returns the resulting ray
                 */
                screenPointToRay(out: geometry.Ray, x: number, y: number): geometry.Ray;
                /**
                 * @en Transform a screen position (in oriented space) to world space
                 * @zh 将一个屏幕空间（在实际朝向下）位置转换到世界空间
                 * @param out the resulting vector
                 * @param screenPos the screen position to be transformed
                 * @returns the resulting vector
                 */
                screenToWorld(out: math.Vec3, screenPos: math.Vec3): math.Vec3;
                /**
                 * @en Transform a world space position to screen space rendered by the camera
                 * @zh 将一个世界空间位置转换到相机渲染后的屏幕空间
                 * @param out the resulting vector
                 * @param worldPos the world position to be transformed
                 * @returns the resulting vector
                 */
                worldToScreen(out: math.Vec3, worldPos: math.Vec3 | Readonly<math.Vec3>): math.Vec3;
                /**
                 * @en Transform a world space matrix to screen space rendered by the camera
                 * @zh 将一个世界空间矩阵转换到相机渲染后的屏幕空间
                 * @param out the resulting matrix
                 * @param worldMatrix the world space matrix to be transformed
                 * @param width framebuffer width
                 * @param height framebuffer height
                 * @returns the resulting matrix
                 */
                worldMatrixToScreen(out: math.Mat4, worldMatrix: math.Mat4, width: number, height: number): math.Mat4;
                /**
                 * @en Calculate and set oblique view frustum projection matrix.
                 * @zh 计算并设置斜视锥体投影矩阵
                 * @param clipPlane clip plane in camera space
                 */
                calculateObliqueMat(viewSpacePlane: math.Vec4): void;
                getClipSpaceMinz(): number;
                /**
                 * @en Set exposure with actual value.
                 * @zh 设置相机的曝光值
                 * @param ev100
                 */
                protected setExposure(ev100: any): void;
            }
            export enum ModelType {
                DEFAULT = 0,
                SKINNING = 1,
                BAKED_SKINNING = 2,
                BATCH_2D = 3,
                PARTICLE_BATCH = 4,
                LINE = 5
            }
            /**
             * @en A representation of a model instance
             * The base model class, which is the core component of [[MeshRenderer]],
             * adds its own Model to the rendered scene for rendering submissions when [[MeshRenderer]] is enabled.
             * This type of object represents a rendering instance in a scene, and it can contain multiple sub models,
             * each of which corresponds to a material. These sub models share the same location and form a complete object.
             * Each sub model references a sub mesh resource, which provides vertex and index buffers for rendering.
             * @zh 代表一个模型实例
             * 基础模型类，它是 [[MeshRenderer]] 的核心组成部分，在 [[MeshRenderer]] 启用时会将自己的 Model 添加到渲染场景中用于提交渲染。
             * 此类型对象代表一个场景中的渲染实例，它可以包含多个子模型，每个子模型对应一个材质。这些子模型共享同样的位置，组成一个完整的物体。
             * 每个子模型引用一个子网格资源，后者提供渲染所用的顶点与索引缓冲。
             */
            export class Model {
                /**
                 * @en Sub models of the current model
                 * @zh 获取所有子模型
                 */
                get subModels(): SubModel[];
                /**
                 * @en Whether the model is initialized
                 * @zh 是否初始化
                 */
                get inited(): boolean;
                /**
                 * @en The axis-aligned bounding box of the model in the world space
                 * @zh 获取世界空间包围盒
                 */
                get worldBounds(): geometry.AABB | null;
                /**
                 * @en The axis-aligned bounding box of the model in the model space
                 * @zh 获取模型空间包围盒
                 */
                get modelBounds(): geometry.AABB | null;
                /**
                 * @en The ubo buffer of the model
                 * @zh 获取模型的 ubo 缓冲
                 */
                get localBuffer(): gfx.Buffer | null;
                /**
                 * @en The SH ubo buffer of the model
                 * @zh 获取模型的球谐 ubo 缓冲
                 */
                get localSHBuffer(): gfx.Buffer | null;
                /**
                 * @en The world bound ubo buffer
                 * @zh 获取世界包围盒 ubo 缓冲
                 */
                get worldBoundBuffer(): gfx.Buffer | null;
                /**
                 * @en The time stamp of last update
                 * @zh 获取上次更新时间戳
                 */
                get updateStamp(): number;
                /**
                 * @en Use LightProbe or not
                 * @zh 光照探针开关
                 */
                get useLightProbe(): boolean;
                set useLightProbe(val: boolean);
                /**
                 * @en located tetrahedron index
                 * @zh 模型所处的四面体索引
                 */
                get tetrahedronIndex(): number;
                set tetrahedronIndex(index: number);
                /**
                 * @en Model level shadow bias
                 * @zh 阴影偏移值
                 */
                get shadowBias(): number;
                set shadowBias(val: number);
                /**
                 * @en Model level shadow normal bias
                 * @zh 阴影法线偏移值
                 */
                get shadowNormalBias(): number;
                set shadowNormalBias(val: number);
                /**
                 * @en Whether the model should receive shadow
                 * @zh 是否接收阴影
                 */
                get receiveShadow(): boolean;
                set receiveShadow(val: boolean);
                /**
                 * @en Whether the model should cast shadow
                 * @zh 是否投射阴影
                 */
                get castShadow(): boolean;
                set castShadow(val: boolean);
                /**
                 * @en Gets or sets receive direction Light.
                 * @zh 获取或者设置接收平行光光照。
                 */
                get receiveDirLight(): boolean;
                set receiveDirLight(val: boolean);
                /**
                 * @en The node to which the model belongs
                 * @zh 模型所在的节点
                 */
                get node(): Node;
                set node(n: Node);
                /**
                 * @en Model's transform
                 * @zh 模型的变换
                 */
                get transform(): Node;
                set transform(n: Node);
                /**
                 * @en Model's visibility tag
                 * Model's visibility flags, it's different from [[Node.layer]],
                 * but it will also be compared with [[Camera.visibility]] during culling process.
                 * @zh 模型的可见性标志
                 * 模型的可见性标志与 [[Node.layer]] 不同，它会在剔除阶段与 [[Camera.visibility]] 进行比较
                 */
                get visFlags(): number;
                set visFlags(val: number);
                /**
                 * @en Whether the model is enabled in the render scene so that it will be rendered
                 * @zh 模型是否在渲染场景中启用并被渲染
                 */
                get enabled(): boolean;
                set enabled(val: boolean);
                /**
                 * @en Rendering priority in the transparent queue of model.
                 * @zh Model 在透明队列中的渲染排序优先级
                 */
                get priority(): number;
                set priority(val: number);
                /**
                 * @en Whether the model can be render by the reflection probe
                 * @zh 模型是否能被反射探针渲染
                 */
                get bakeToReflectionProbe(): boolean;
                set bakeToReflectionProbe(val: boolean);
                /**
                 * @en Reflection probe type
                 * @zh 反射探针类型。
                 */
                get reflectionProbeType(): ReflectionProbeType;
                set reflectionProbeType(val: ReflectionProbeType);
                /**
                 * @en sets or gets reflection probe id
                 * @zh 设置或获取反射探针id。
                 */
                get reflectionProbeId(): number;
                set reflectionProbeId(val: number);
                /**
                 * @en Sets or gets the reflection probe id for blend.
                 * @zh 设置或获取用于混合的反射探针id。
                 */
                get reflectionProbeBlendId(): number;
                set reflectionProbeBlendId(val: number);
                /**
                 * @en Sets or gets the reflection probe blend weight.
                 * @zh 设置或获取反射探针混合权重。
                 */
                get reflectionProbeBlendWeight(): number;
                set reflectionProbeBlendWeight(val: number);
                /**
                 * @en The type of the model
                 * @zh 模型类型
                 */
                type: ModelType;
                /**
                 * @en The render scene to which the model belongs
                 * @zh 模型所在的场景
                 */
                scene: RenderScene | null;
                /**
                 * @en Whether dynamic batching is enabled for model
                 * @zh 是否动态合批
                 */
                isDynamicBatching: boolean;
                /**
                 * @en The world axis-aligned bounding box
                 * @zh 世界空间包围盒
                 */
                protected _worldBounds: geometry.AABB | null;
                /**
                 * @en The model axis-aligned bounding box
                 * @zh 模型空间包围盒
                 */
                protected _modelBounds: geometry.AABB | null;
                /**
                 * @en Sub models
                 * @zh 子模型
                 */
                protected _subModels: SubModel[];
                /**
                 * @en The node to which the model belongs
                 * @zh 模型所在的节点
                 */
                protected _node: Node;
                /**
                 * @en Model's transform
                 * @zh 子模型的变换
                 */
                protected _transform: Node;
                /**
                 * @en Current gfx device
                 * @zh 当前 GFX 设备
                 */
                protected _device: gfx.Device;
                /**
                 * @en Whether the model is initialized
                 * @zh 是否初始化过
                 */
                protected _inited: boolean;
                /**
                 * @en Descriptor set count
                 * @zh 描述符集合个数
                 */
                protected _descriptorSetCount: number;
                /**
                 * @en Time stamp for last update
                 * @zh 更新时间戳
                 */
                protected _updateStamp: number;
                /**
                 * @en Local ubo data dirty flag
                 * @zh 本地 ubo 数据是否修改过
                 */
                protected _localDataUpdated: boolean;
                /**
                 * @en Local ubo data
                 * @zh 本地 ubo 数据
                 */
                protected _localData: Float32Array;
                /**
                 * @en Local ubo buffer
                 * @zh 本地 ubo 缓冲
                 */
                protected _localBuffer: gfx.Buffer | null;
                /**
                 * @en Local SH ubo data
                 * @zh 本地球谐 ubo 数据
                 */
                protected _localSHData: Float32Array | null;
                /**
                 * @en Local SH ubo buffer
                 * @zh 本地球谐 ubo 缓冲
                 */
                protected _localSHBuffer: gfx.Buffer | null;
                /**
                 * @en World AABB buffer
                 * @zh 世界空间包围盒缓冲
                 */
                protected _worldBoundBuffer: gfx.Buffer | null;
                /**
                 * @en Whether the model should receive shadow
                 * @zh 是否接收阴影
                 */
                protected _receiveShadow: boolean;
                /**
                 * @en Whether the model should cast shadow
                 * @zh 是否投射阴影
                 */
                protected _castShadow: boolean;
                /**
                 * @en Is received direction Light.
                 * @zh 是否接收平行光光照。
                 */
                protected _receiveDirLight: boolean;
                /**
                 * @en Shadow bias
                 * @zh 阴影偏移
                 */
                protected _shadowBias: number;
                /**
                 * @en Shadow normal bias
                 * @zh 阴影法线偏移
                 */
                protected _shadowNormalBias: number;
                /**
                 * @en Reflect probe Id
                 * @zh 使用第几个反射探针
                 */
                protected _reflectionProbeId: number;
                /**
                 * @en Use which probe to blend
                 * @zh 使用第几个反射探针进行混合
                 */
                protected _reflectionProbeBlendId: number;
                /**
                 * @en Reflection probe blend weight
                 * @zh 反射探针混合权重
                 */
                protected _reflectionProbeBlendWeight: number;
                /**
                 * @en Whether the model is enabled in the render scene so that it will be rendered
                 * @zh 模型是否在渲染场景中启用并被渲染
                 */
                protected _enabled: boolean;
                /**
                 * @en The visibility flags
                 * @zh 可见性标志位
                 */
                protected _visFlags: number;
                protected _priority: number;
                /**
                 * @en Whether the model can be render by the reflection probe
                 * @zh 模型是否能被反射探针渲染
                 */
                protected _bakeToReflectionProbe: boolean;
                /**
                 * @en Reflection probe type.
                 * @zh 反射探针类型。
                 */
                protected _reflectionProbeType: ReflectionProbeType;
                /**
                 * @internal
                 * @en native object
                 * @zh 原生对象
                 */
                /**
                 * @internal
                 * @en return native object
                 * @zh 返回原生对象
                 */
                /**
                 * @en Constructor to create an empty model
                 * @zh 创建一个空模型
                 */
                constructor();
                /**
                 * @en Initialize the model
                 * @zh 初始化模型
                 */
                initialize(): void;
                /**
                 * @en Destroy the model
                 * @zh 销毁模型
                 */
                destroy(): void;
                /**
                 * @en Attach the model to a [[renderer.RenderScene]]
                 * @zh 添加模型到渲染场景 [[renderer.RenderScene]] 中
                 * @param scene destination scene
                 */
                attachToScene(scene: RenderScene): void;
                /**
                 * @en Detach the model from its render scene
                 * @zh 移除场景中的模型
                 */
                detachFromScene(): void;
                /**
                 * @en Update the model's transform
                 * @zh 更新模型的变换
                 * @param stamp time stamp
                 */
                updateTransform(stamp: number): void;
                /**
                 * @en Update the model's world AABB
                 * @zh 更新模型的世界空间包围盒
                 */
                updateWorldBound(): void;
                /**
                 * @en Update the model's ubo
                 * @zh 更新模型的 ubo
                 * @param stamp time stamp
                 */
                updateUBOs(stamp: number): void;
                showTetrahedron(): boolean;
                /**
                 * @en Clear the model's SH ubo
                 * @zh 清除模型的球谐 ubo
                 */
                clearSHUBOs(): void;
                /**
                 * @en Update the model's SH ubo
                 * @zh 更新模型的球谐 ubo
                 */
                updateSHUBOs(): void;
                /**
                 * @en Create the model's AABB
                 * @zh 创建模型的包围盒
                 * @param minPos min position of the AABB
                 * @param maxPos max position of the AABB
                 */
                createBoundingShape(minPos?: math.Vec3, maxPos?: math.Vec3): void;
                /**
                 * @en Initialize a sub model with the sub mesh data and the material.
                 * @zh 用子网格数据和材质初始化一个子模型。
                 * @param idx sub model's index
                 * @param subMeshData sub mesh
                 * @param mat sub material
                 */
                initSubModel(idx: number, subMeshData: RenderingSubMesh, mat: Material): void;
                /**
                 * @en Set material for a given sub model
                 * @zh 为指定的子模型设置材质
                 * @param idx sub model's index
                 * @param subMesh sub mesh
                 */
                setSubModelMesh(idx: number, subMesh: RenderingSubMesh): void;
                /**
                 * @en Set a sub material
                 * @zh 设置一个子材质
                 * @param idx sub model's index
                 * @param mat sub material
                 */
                setSubModelMaterial(idx: number, mat: Material): void;
                /**
                 * @en Pipeline changed callback
                 * @zh 管线更新回调
                 */
                onGlobalPipelineStateChanged(): void;
                /**
                 * @en Shader macro changed callback
                 * @zh Shader 宏更新回调
                 */
                onMacroPatchesStateChanged(): void;
                onGeometryChanged(): void;
                /**
                 * @internal
                 * If the model has lighting map
                 * initialize lighting map info before model initializing
                 * because the lighting map will influence the shader
                 */
                initLightingmap(texture: Texture2D | null, uvParam: math.Vec4): void;
                /**
                 * @en Update the light map info
                 * @zh 更新光照贴图信息
                 * @param texture light map
                 * @param uvParam uv coordinate
                 */
                updateLightingmap(texture: Texture2D | null, uvParam: math.Vec4): void;
                /**
                 * @en Update the cube map of the reflection probe
                 * @zh 更新反射探针的立方体贴图
                 * @param texture probe cubemap
                 */
                updateReflectionProbeCubemap(texture: TextureCube | null): void;
                /**
                 * @en Update the cube map of the reflection probe for blend
                 * @zh 更新用于blend的反射探针立方体贴图
                 * @param texture probe cubemap
                 */
                updateReflectionProbeBlendCubemap(texture: TextureCube | null): void;
                /**
                 * @en Update the planar relflection map of the reflection probe
                 * @zh 更新反射探针的平面反射贴图
                 * @param texture planar relflection map
                 */
                updateReflectionProbePlanarMap(texture: gfx.Texture | null): void;
                /**
                 * @en Update the data map of the reflection probe
                 * @zh 更新反射探针的数据贴图
                 * @param texture data map
                 */
                updateReflectionProbeDataMap(texture: Texture2D | null): void;
                /**
                 * @en Update the shadow bias
                 * @zh 更新阴影偏移
                 */
                updateLocalShadowBias(): void;
                /**
                 * @en Update the id of reflection probe
                 * @zh 更新物体使用哪个反射探针
                 */
                updateReflectionProbeId(): void;
                /**
                 * @en Return shader's macro patches
                 * @zh 获取 shader 宏
                 * @param subModelIndex sub model's index
                 */
                getMacroPatches(subModelIndex: number): IMacroPatch[] | null;
                protected _updateAttributesAndBinding(subModelIndex: number): void;
                protected _updateInstancedAttributes(attributes: gfx.Attribute[], subModel: SubModel): void;
                protected _initLocalDescriptors(subModelIndex: number): void;
                protected _initLocalSHDescriptors(subModelIndex: number): void;
                protected _initWorldBoundDescriptors(subModelIndex: number): void;
                protected _updateLocalDescriptors(subModelIndex: number, descriptorSet: gfx.DescriptorSet): void;
                protected _updateLocalSHDescriptors(subModelIndex: number, descriptorSet: gfx.DescriptorSet): void;
                protected _updateWorldBoundDescriptors(subModelIndex: number, descriptorSet: gfx.DescriptorSet): void;
            }
            export interface IInstancedAttributeBlock {
                buffer: Uint8Array;
                views: __private.__types_globals__TypedArray[];
                attributes: gfx.Attribute[];
            }
            /**
             * @en A sub part of the model, it describes how to render a specific sub mesh.
             * It contains geometry information in [[RenderingSubMesh]] and all sort of rendering configuration like shaders, macro patches, passes etc.
             * @zh 组成模型对象的子模型，它用来描述如何渲染模型的一个子网格。
             * 它包含 [[RenderingSubMesh]] 代表的几何网格信息和所有渲染需要的数据，比如着色器程序，着色器宏定义，渲染 pass，等。
             */
            export class SubModel {
                protected _device: gfx.Device | null;
                protected _passes: Pass[] | null;
                protected _shaders: gfx.Shader[] | null;
                protected _subMesh: RenderingSubMesh | null;
                protected _patches: IMacroPatch[] | null;
                protected _priority: pipeline.RenderPriority;
                protected _inputAssembler: gfx.InputAssembler | null;
                protected _descriptorSet: gfx.DescriptorSet | null;
                protected _worldBoundDescriptorSet: gfx.DescriptorSet | null;
                protected _reflectionTex: gfx.Texture | null;
                protected _reflectionSampler: gfx.Sampler | null;
                protected _instancedAttributeBlock: IInstancedAttributeBlock;
                protected _instancedWorldMatrixIndex: number;
                protected _instancedSHIndex: number;
                protected _useReflectionProbeType: number;
                /**
                 * @en
                 * sub model's passes
                 * @zh
                 * 子模型的 passes
                 * @param passes @en The passes @zh 设置的 passes
                 */
                /**
                 * @en Render passes for the sub-model
                 * @zh 子模型的渲染 pass
                 */
                set passes(passes: Pass[]);
                get passes(): Pass[];
                /**
                 * @en Shaders for the sub-model, each shader corresponds to one of the [[passes]]
                 * @zh 子模型的着色器程序列表，每个着色器程序对应其中一个渲染 [[passes]]
                 */
                get shaders(): gfx.Shader[];
                /**
                 * @en The rendering sub mesh for the sub-model, each sub-model can only have one sub mesh.
                 * @zh 用于渲染的子网格对象，每个子模型只能包含一个子网格。
                 */
                set subMesh(subMesh: RenderingSubMesh);
                get subMesh(): RenderingSubMesh;
                /**
                 * @en The rendering priority of the sub-model
                 * @zh 子模型的渲染优先级
                 */
                set priority(val: pipeline.RenderPriority);
                get priority(): pipeline.RenderPriority;
                /**
                 * @en The low level input assembler which contains geometry data
                 * @zh 底层渲染用的输入汇集器，包含几何信息
                 */
                get inputAssembler(): gfx.InputAssembler;
                /**
                 * @en The descriptor set used for sub-model rendering
                 * @zh 底层渲染子模型用的描述符集组
                 */
                get descriptorSet(): gfx.DescriptorSet;
                /**
                 * @en The descriptor set for world bound
                 * @zh 用于存储世界包围盒的描述符集组
                 */
                get worldBoundDescriptorSet(): gfx.DescriptorSet | null;
                /**
                 * @en The macro patches for the shaders
                 * @zh 着色器程序所用的宏定义组合
                 */
                get patches(): Readonly<IMacroPatch[] | null>;
                /**
                 * @en The instance attribute block, access by sub model
                 * @zh 硬件实例化属性，通过子模型访问
                 */
                get instancedAttributeBlock(): IInstancedAttributeBlock;
                /**
                 * @en Get or set instance matrix id, access by sub model
                 * @zh 获取或者设置硬件实例化中的矩阵索引，通过子模型访问
                 */
                set instancedWorldMatrixIndex(val: number);
                get instancedWorldMatrixIndex(): number;
                /**
                 * @en Get or set instance SH id, access by sub model
                 * @zh 获取或者设置硬件实例化中的球谐索引，通过子模型访问
                 */
                set instancedSHIndex(val: number);
                get instancedSHIndex(): number;
                /**
                 * @en Gets or sets the type of reflection probe, Used to process instance
                 * @zh 获取或设置使用反射探针的类型，用于处理instance
                 */
                set useReflectionProbeType(val: number);
                get useReflectionProbeType(): number;
                /**
                 * @en
                 * init sub model
                 * @zh
                 * 子模型初始化
                 * @param subMesh @en The sub mesh @zh 子网格资源
                 * @param passes @en The passes @zh 渲染的 passes
                 * @param patches @en The shader's macro @zh 着色器的宏定义
                 */
                initialize(subMesh: RenderingSubMesh, passes: Pass[], patches?: IMacroPatch[] | null): void;
                /**
                 * @en
                 * destroy sub model
                 * @zh
                 * 销毁子模型
                 */
                destroy(): void;
                /**
                 * @en
                 * update sub model
                 * @zh
                 * 更新子模型
                 */
                update(): void;
                /**
                 * @en Pipeline changed callback
                 * @zh 管线更新回调
                 */
                onPipelineStateChanged(): void;
                /**
                 * @en Shader macro changed callback
                 * @zh Shader 宏更新回调
                 */
                onMacroPatchesStateChanged(patches: IMacroPatch[] | null): void;
                /**
                 * @en
                 * geometry changed callback
                 * @zh
                 * 几何数据改变后的回调
                 */
                onGeometryChanged(): void;
                /**
                 * @en
                 * get instanced attribute index
                 * @zh
                 * 获取硬件实例化相关索引
                 */
                /**
                 * @internal
                 */
                getInstancedAttributeIndex(name: string): number;
                /**
                 * @en
                 * update instancing related data, invoked by model
                 * @zh
                 * 更新硬件实例化相关数据，一般由model调用
                 */
                /**
                 * @internal
                 */
                updateInstancedWorldMatrix(mat: math.Mat4, idx: number): void;
                /**
                 * @en
                 * update instancing SH data, invoked by model
                 * @zh
                 * 更新硬件实例化球谐数据，一般由model调用
                 */
                /**
                 * @internal
                 */
                updateInstancedSH(data: Float32Array, idx: number): void;
                /**
                 * @en
                 * update instancing related data, invoked by model
                 * @zh
                 * 更新硬件实例化相关数据，一般由model调用
                 */
                /**
                 * @internal
                 */
                UpdateInstancedAttributes(attributes: gfx.Attribute[]): void;
                protected _flushPassInfo(): void;
            }
            /**
             * @en Ambient lighting representation in the render scene.
             * The initial data is setup in [[SceneGlobals.ambient]].
             * @zh 渲染场景中的环境光照设置。
             * 初始值是由 [[SceneGlobals.ambient]] 设置的。
             */
            export class Ambient {
                /**
                 * @en Default sun illuminance
                 * @zh 默认太阳亮度
                 */
                static SUN_ILLUM: number;
                /**
                 * @en Default sky illuminance
                 * @zh 默认天空亮度
                 */
                static SKY_ILLUM: number;
                /**
                 * @en Enable ambient
                 * @zh 是否开启环境光
                 */
                set enabled(val: boolean);
                get enabled(): boolean;
                /**
                 * @en Sky color
                 * @zh 天空颜色
                 */
                get skyColor(): math.Vec4;
                set skyColor(color: math.Vec4);
                /**
                 * @en Sky illuminance
                 * @zh 天空亮度
                 */
                get skyIllum(): number;
                set skyIllum(illum: number);
                /**
                 * @en Ground color
                 * @zh 地面颜色
                 */
                get groundAlbedo(): math.Vec4;
                set groundAlbedo(color: math.Vec4);
                protected _groundAlbedoHDR: math.Vec4;
                protected _skyColorHDR: math.Vec4;
                protected _skyIllumHDR: number;
                protected _groundAlbedoLDR: math.Vec4;
                protected _skyColorLDR: math.Vec4;
                protected _skyIllumLDR: number;
                protected _mipmapCount: number;
                protected _enabled: boolean;
                initialize(ambientInfo: AmbientInfo): void;
            }
            export enum EnvironmentLightingType {
                /**
                 * @zh
                 * 半球漫反射
                 * @en
                 * hemisphere diffuse
                 * @readonly
                 */
                HEMISPHERE_DIFFUSE = 0,
                /**
                 * @zh
                 * 半球漫反射和环境反射
                 * @en
                 * hemisphere diffuse and Environment reflection
                 * @readonly
                 */
                AUTOGEN_HEMISPHERE_DIFFUSE_WITH_REFLECTION = 1,
                /**
                 * @zh
                 * 漫反射卷积图和环境反射
                 * @en
                 * diffuse convolution map and environment reflection
                 * @readonly
                 */
                DIFFUSEMAP_WITH_REFLECTION = 2
            }
            /**
             * @en The skybox configuration of the render scene,
             * currently some rendering options like hdr and ibl lighting configuration is also here.
             * @zh 渲染场景的天空盒配置，目前一些渲染配置，比如 HDR 模式和环境光照配置也在 Skybox 中。
             */
            export class Skybox {
                /**
                 * @en The Model object of the skybox
                 * @zh 天空盒的 Model 对象
                 */
                get model(): Model | null;
                /**
                 * @en Whether activate skybox in the scene
                 * @zh 是否启用天空盒？
                 */
                get enabled(): boolean;
                set enabled(val: boolean);
                /**
                 * @en Whether HDR mode is enabled
                 * @zh 是否启用HDR？
                 */
                get useHDR(): boolean;
                set useHDR(val: boolean);
                /**
                 * @en Whether use image based lighting for PBR materials
                 * @zh 是否启用IBL？
                 */
                get useIBL(): boolean;
                set useIBL(val: boolean);
                /**
                 * @en Whether use diffuse convolution map lighting
                 * @zh 是否为IBL启用漫反射卷积图？
                 */
                get useDiffuseMap(): boolean;
                set useDiffuseMap(val: boolean);
                /**
                 * @en Whether enable RGBE data support in skybox shader
                 * @zh 是否需要开启 shader 内的 RGBE 数据支持？
                 */
                get isRGBE(): boolean;
                /**
                 * @en Whether to use offline baked convolutional maps
                 * @zh 是否使用离线烘焙的卷积图？
                 */
                get useConvolutionMap(): boolean;
                /**
                 * @en The texture cube used for the skybox
                 * @zh 使用的立方体贴图
                 */
                get envmap(): TextureCube | null;
                set envmap(val: TextureCube | null);
                /**
                 * @en The texture cube used diffuse convolution map
                 * @zh 使用的漫反射卷积图
                 */
                get diffuseMap(): TextureCube | null;
                set diffuseMap(val: TextureCube | null);
                get reflectionMap(): TextureCube | null;
                get editableMaterial(): MaterialInstance | null;
                protected _envmapLDR: TextureCube | null;
                protected _envmapHDR: TextureCube | null;
                protected _diffuseMapLDR: TextureCube | null;
                protected _diffuseMapHDR: TextureCube | null;
                protected _globalDSManager: __private._cocos_rendering_global_descriptor_set_manager__GlobalDSManager | null;
                protected _model: Model | null;
                protected _default: TextureCube | null;
                protected _enabled: boolean;
                protected _useIBL: boolean;
                protected _useHDR: boolean;
                protected _useDiffuseMap: boolean;
                protected _editableMaterial: MaterialInstance | null;
                protected _activated: boolean;
                protected _reflectionHDR: TextureCube | null;
                protected _reflectionLDR: TextureCube | null;
                protected _rotationAngle: number;
                initialize(skyboxInfo: SkyboxInfo): void;
                /**
                 * @en Set the environment maps for HDR and LDR mode
                 * @zh 为 HDR 和 LDR 模式设置环境贴图
                 * @param envmapHDR @en Environment map for HDR mode @zh HDR 模式下的环境贴图
                 * @param envmapLDR @en Environment map for LDR mode @zh LDR 模式下的环境贴图
                 */
                setEnvMaps(envmapHDR: TextureCube | null, envmapLDR: TextureCube | null): void;
                /**
                 * @en Set the diffuse maps
                 * @zh 设置环境光漫反射贴图
                 * @param diffuseMapHDR @en Diffuse map for HDR mode @zh HDR 模式下的漫反射贴图
                 * @param diffuseMapLDR  @en Diffuse map for LDR mode @zh LDR 模式下的漫反射贴图
                 */
                setDiffuseMaps(diffuseMapHDR: TextureCube | null, diffuseMapLDR: TextureCube | null): void;
                /**
                 * @en Set custom skybox material
                 * @zh 设置自定义的天空盒材质
                 * @param skyboxMat  @en Skybox material @zh 天空盒材质
                 */
                setSkyboxMaterial(skyboxMat: Material | null): void;
                /**
                 * @en Set the environment reflection convolution map
                 * @zh 设置环境反射卷积图
                 * @param reflectionHDR  @en Reflection convolution map for HDR mode @zh HDR 模式下的反射卷积图
                 * @param reflectionLDR  @en Reflection convolution map for LDR mode @zh LDR 模式下的反射卷积图
                 */
                setReflectionMaps(reflectionHDR: TextureCube | null, reflectionLDR: TextureCube | null): void;
                /**
                 * @en Set skybox rotation angle
                 * @zh 设置天空盒旋转角度
                 * @param angle  @en rotation angle @zh 旋转角度
                 */
                setRotationAngle(angle: number): void;
                getRotationAngle(): number;
                updateMaterialRenderInfo(): void;
                activate(): void;
                protected _updatePipeline(): void;
                protected _updateGlobalBinding(): void;
                protected _updateSubModes(): void;
            }
            /**
             * @zh 阴影贴图分辨率。
             * @en The shadow map size.
             * @static
             * @enum Shadows.ShadowSize
             */
            export const ShadowSize: {
                /**
                 * @zh 分辨率 256 * 256。
                 * @en shadow resolution 256 * 256.
                 * @readonly
                 */
                Low_256x256: number;
                /**
                 * @zh 分辨率 512 * 512。
                 * @en shadow resolution 512 * 512.
                 * @readonly
                 */
                Medium_512x512: number;
                /**
                 * @zh 分辨率 1024 * 1024。
                 * @en shadow resolution 1024 * 1024.
                 * @readonly
                 */
                High_1024x1024: number;
                /**
                 * @zh 分辨率 2048 * 2048。
                 * @en shadow resolution 2048 * 2048.
                 * @readonly
                 */
                Ultra_2048x2048: number;
            };
            /**
             * @zh 阴影类型。
             * @en The shadow type
             * @enum Shadows.ShadowType
             */
            export const ShadowType: {
                /**
                 * @zh 平面阴影。
                 * @en Planar shadow
                 * @property Planar
                 * @readonly
                 */
                Planar: number;
                /**
                 * @zh 阴影贴图。
                 * @en Shadow type
                 * @property ShadowMap
                 * @readonly
                 */
                ShadowMap: number;
            };
            /**
             * @zh pcf阴影等级。
             * @en The pcf type
             * @static
             * @enum Shadows.PCFType
             */
            export const PCFType: {
                /**
                 * @zh x1 次采样
                 * @en x1 times
                 * @readonly
                 */
                HARD: number;
                /**
                 * @zh x4 次采样
                 * @en x4 times
                 * @readonly
                 */
                SOFT: number;
                /**
                 * @zh x9 次采样
                 * @en x9 times
                 * @readonly
                 */
                SOFT_2X: number;
                /**
                 * @zh x16 次采样
                 * @en x16 times
                 * @readonly
                 */
                SOFT_4X: number;
            };
            /**
             * @zh 级联阴影贴图层级。
             * @en The CSM shadow level
             * @enum Shadows.CSMLevel
             */
            export const CSMLevel: {
                /**
                 * @zh 1 个层级
                 * @en level 1
                 * @readonly
                 */
                LEVEL_1: number;
                /**
                 * @zh 2 个层级
                 * @en level 2
                 * @readonly
                 */
                LEVEL_2: number;
                /**
                 * @zh 3 个层级
                 * @en level 3
                 * @readonly
                 */
                LEVEL_3: number;
                /**
                 * @zh 4 个层级
                 * @en level 4
                 * @readonly
                 */
                LEVEL_4: number;
            };
            /**
             * @zh 级联阴影性能优化模式。
             * @en The CSM performance optimization mode
             * @enum Shadows.CSMOptimizationMode
             */
            export const CSMOptimizationMode: {
                /**
                 * @zh 没有性能优化
                 * @en has no performance optimization
                 * @readonly
                 */
                NONE: number;
                /**
                 * @zh 剔除层与层之间重复物体
                 * @en Eliminate duplicate objects between layers
                 * @readonly
                 */
                RemoveDuplicates: number;
                /**
                 * @zh 取消稳抖
                 * @en Disable rotation fix
                 * @readonly
                 */
                DisableRotationFix: number;
            };
            /**
             * @en The global shadow's configuration of the render scene
             * @zh 渲染场景的全局阴影配置
             */
            export class Shadows {
                /**
                 * @en MAX_FAR. This is shadow camera max far.
                 * @zh 阴影相机的最远视距。
                 */
                static readonly MAX_FAR: number;
                /**
                 * @en EXPANSION_RATIO. This is shadow boundingBox Coefficient of expansion.
                 * @zh 阴影包围盒扩大系数。
                 */
                static readonly COEFFICIENT_OF_EXPANSION: number;
                /**
                 * @en Whether activate planar shadow.
                 * @zh 是否启用平面阴影？
                 */
                get enabled(): boolean;
                set enabled(val: boolean);
                /**
                 * @en Shadow type.
                 * @zh 阴影类型。
                 */
                get type(): number;
                set type(val: number);
                /**
                 * @en The normal of the plane which receives shadow.
                 * @zh 阴影接收平面的法线。
                 */
                get normal(): math.Vec3;
                set normal(val: math.Vec3);
                /**
                 * @en The distance from coordinate origin to the receiving plane.
                 * @zh 阴影接收平面与原点的距离。
                 */
                get distance(): number;
                set distance(val: number);
                /**
                 * @en Positional offset values in planar shading calculations.
                 * @zh 平面阴影计算中的位置偏移值。
                 */
                get planeBias(): number;
                set planeBias(val: number);
                /**
                 * @en Shadow color.
                 * @zh 阴影颜色。
                 */
                get shadowColor(): math.Color;
                set shadowColor(color: math.Color);
                /**
                 * @en get or set shadow camera orthoSize.
                 * @zh 获取或者设置阴影纹理大小。
                 */
                get size(): math.Vec2;
                set size(val: math.Vec2);
                /**
                 * @en shadow Map size has been modified.
                 * @zh 阴影贴图大小是否被修改。
                 */
                get shadowMapDirty(): boolean;
                set shadowMapDirty(val: boolean);
                /**
                 * @en The transform matrix of the light source
                 * @zh 光源的变换矩阵
                 */
                get matLight(): math.Mat4;
                get material(): Material;
                get instancingMaterial(): Material;
                /**
                 * @en The bounding sphere of the shadow map.
                 * @zh 用于计算固定区域阴影 Shadow map 的场景包围球.
                 */
                fixedSphere: geometry.Sphere;
                /**
                 * @en get or set shadow max received.
                 * @zh 阴影接收的最大灯光数量。
                 */
                maxReceived: number;
                protected _matLight: math.Mat4;
                protected _material: Material | null;
                protected _instancingMaterial: Material | null;
                protected _enabled: boolean;
                protected _type: number;
                protected _distance: number;
                protected _planeBias: number;
                protected _normal: math.Vec3;
                protected _shadowColor: math.Color;
                protected _size: math.Vec2;
                protected _shadowMapDirty: boolean;
                /**
                 * @en Get the shader for the planar shadow with macro patches
                 * @zh 通过指定宏获取平面阴影的 Shader 对象
                 * @param patches The macro patches for the shader
                 * @returns The shader for the planar shadow
                 */
                getPlanarShader(patches: Readonly<IMacroPatch[] | null>): gfx.Shader | null;
                initialize(shadowsInfo: ShadowsInfo): void;
                activate(): void;
                protected _updatePlanarInfo(): void;
                destroy(): void;
            }
            /**
             * @zh
             * 全局雾类型。
             * @en
             * The global fog type
             * @static
             * @enum FogInfo.FogType
             */
            export const FogType: {
                /**
                 * @zh
                 * 线性雾。
                 * @en
                 * Linear fog
                 * @readonly
                 */
                LINEAR: number;
                /**
                 * @zh
                 * 指数雾。
                 * @en
                 * Exponential fog
                 * @readonly
                 */
                EXP: number;
                /**
                 * @zh
                 * 指数平方雾。
                 * @en
                 * Exponential square fog
                 * @readonly
                 */
                EXP_SQUARED: number;
                /**
                 * @zh
                 * 层叠雾。
                 * @en
                 * Layered fog
                 * @readonly
                 */
                LAYERED: number;
            };
            export const FOG_TYPE_NONE: number;
            /**
             * @en The fog representation in the render scene.
             * @zh 渲染场景中的全局雾效配置
             */
            export class Fog {
                /**
                 * @zh 是否启用全局雾效
                 * @en Enable global fog
                 */
                set enabled(val: boolean);
                get enabled(): boolean;
                /**
                 * @zh 是否启用精确雾效(像素雾)计算
                 * @en Enable accurate fog (pixel fog)
                 */
                set accurate(val: boolean);
                get accurate(): boolean;
                /**
                 * @zh 全局雾颜色
                 * @en Global fog color
                 */
                set fogColor(val: Readonly<math.Color>);
                get fogColor(): math.Color;
                /**
                 * @zh 当前雾化类型。
                 * @en The current global fog type.
                 * @returns {FogType}
                 * Returns the current global fog type
                 * - -1:Disable global Fog
                 * - 0:Linear fog
                 * - 1:Exponential fog
                 * - 2:Exponential square fog
                 * - 3:Layered fog
                 */
                get type(): number;
                set type(val: number);
                /**
                 * @zh 全局雾浓度
                 * @en Global fog density
                 */
                get fogDensity(): number;
                set fogDensity(val: number);
                /**
                 * @zh 雾效起始位置，只适用于线性雾
                 * @en Global fog start position, only for linear fog
                 */
                get fogStart(): number;
                set fogStart(val: number);
                /**
                 * @zh 雾效结束位置，只适用于线性雾
                 * @en Global fog end position, only for linear fog
                 */
                get fogEnd(): number;
                set fogEnd(val: number);
                /**
                 * @zh 雾效衰减
                 * @en Global fog attenuation
                 */
                get fogAtten(): number;
                set fogAtten(val: number);
                /**
                 * @zh 雾效顶部范围，只适用于层级雾
                 * @en Global fog top range, only for layered fog
                 */
                get fogTop(): number;
                set fogTop(val: number);
                /**
                 * @zh 雾效范围，只适用于层级雾
                 * @en Global fog range, only for layered fog
                 */
                get fogRange(): number;
                set fogRange(val: number);
                get colorArray(): Readonly<math.Vec4>;
                protected _fogColor: math.Color;
                protected _colorArray: math.Vec4;
                protected _enabled: boolean;
                protected _accurate: boolean;
                protected _type: number;
                protected _fogDensity: number;
                protected _fogStart: number;
                protected _fogEnd: number;
                protected _fogAtten: number;
                protected _fogTop: number;
                protected _fogRange: number;
                protected _activated: boolean;
                initialize(fogInfo: FogInfo): void;
                activate(): void;
                protected _updatePipeline(): void;
            }
            /**
             * @en The octree culling configuration of the render scene
             * @zh 渲染场景的八叉树剔除配置
             */
            export class Octree {
                /**
                 * @en Whether octree culling is enabled in the render scene
                 * @zh 是否开启八叉树加速剔除
                 */
                set enabled(val: boolean);
                get enabled(): boolean;
                /**
                 * @en Minimum position of the scene's bounding box
                 * @zh 场景包围盒最小值
                 */
                get minPos(): math.Vec3;
                set minPos(val: math.Vec3);
                /**
                 * @en Maximum position of the scene's bounding box
                 * @zh 场景包围盒最大值
                 */
                get maxPos(): math.Vec3;
                set maxPos(val: math.Vec3);
                /**
                 * @en The depth of the octree
                 * @zh 八叉树深度
                 */
                get depth(): number;
                set depth(val: number);
                protected _enabled: boolean;
                protected _minPos: math.Vec3;
                protected _maxPos: math.Vec3;
                protected _depth: number;
                initialize(octreeInfo: OctreeInfo): void;
            }
            /**
             * @en Global skin in the render scene.
             * The initial data is setup in [[SceneGlobals.skip]].
             * @zh 渲染场景中的全局皮肤后处理设置。
             * 初始值是由 [[SceneGlobals.skin]] 设置的。
             */
            export class Skin {
                /**
                 * @en Enable skip.
                 * @zh 是否开启皮肤后效。
                 */
                set enabled(val: boolean);
                get enabled(): boolean;
                /**
                 * @en Getter/Setter sampler width.
                 * @zh 设置或者获取采样宽度。
                 */
                set blurRadius(val: number);
                get blurRadius(): number;
                /**
                 * @en Getter/Setter depth unit scale.
                 * @zh 设置或者获取深度单位比例。
                 */
                set sssIntensity(val: number);
                get sssIntensity(): number;
                protected _enabled: boolean;
                protected _blurRadius: number;
                protected _sssIntensity: number;
                initialize(skinInfo: SkinInfo): void;
            }
            export function ColorTemperatureToRGB(rgb: math.Vec3, kelvin: number): void;
            /**
             * @en The light type enumeration.
             * @zh 光源类型枚举。
             */
            export enum LightType {
                DIRECTIONAL = 0,
                SPHERE = 1,
                SPOT = 2,
                POINT = 3,
                RANGED_DIRECTIONAL = 4,
                UNKNOWN = 5
            }
            export const nt2lm: (size: number) => number;
            /**
             * @en The abstract light class of the render scene
             * @zh 渲染场景中的光源基类
             */
            export class Light {
                /**
                 * @en Whether it's a baked light source, baked light will be ignored in real time lighting pass
                 * @zh 是否是烘焙光源，烘焙光源会在实时光照计算中被忽略
                 */
                get baked(): boolean;
                set baked(val: boolean);
                /**
                 * @en The color of the light
                 * @zh 光源的颜色
                 */
                set color(color: math.Vec3);
                get color(): math.Vec3;
                /**
                 * @en Whether to use color temperature
                 * @zh 是否使用光源的色温
                 */
                set useColorTemperature(enable: boolean);
                get useColorTemperature(): boolean;
                /**
                 * @en The color temperature of the light
                 * @zh 光源的色温
                 */
                set colorTemperature(val: number);
                get colorTemperature(): number;
                /**
                 * @en The float RGB value of the color temperature, each channel is from 0 to 1
                 * @zh 色温的浮点数颜色值，每个通道都是从 0 到 1
                 */
                get colorTemperatureRGB(): math.Vec3;
                get finalColor(): Readonly<math.Vec3>;
                set node(n: Node | null);
                /**
                 * @en The node which owns the light source
                 * @zh 光源归属的节点
                 */
                get node(): Node | null;
                /**
                 * @en The type of the light source, e.g. directional light, spot light, etc
                 * @zh 光源的类型，比如方向光、聚光灯等
                 */
                get type(): LightType;
                /**
                 * @en The name of the light source
                 * @zh 光源的名字
                 */
                get name(): string | null;
                set name(n: string | null);
                /**
                 * @en The render scene which owns the current light
                 * @zh 光源所属的渲染场景
                 */
                get scene(): RenderScene | null;
                protected _baked: boolean;
                protected _color: math.Vec3;
                protected _colorTemp: number;
                protected _colorTempRGB: math.Vec3;
                protected _scene: RenderScene | null;
                protected _node: Node | null;
                protected _name: string | null;
                protected _useColorTemperature: boolean;
                protected _type: LightType;
                protected _visibility: number;
                initialize(): void;
                /**
                 * @en Attach the light to a render scene
                 * @zh 将光源挂载到渲染场景上
                 * @param scene @en The render scene @zh 渲染场景
                 */
                attachToScene(scene: RenderScene): void;
                /**
                 * @en Detach the light from the render scene
                 * @zh 将光源从渲染场景上移除
                 */
                detachFromScene(): void;
                destroy(): void;
                update(): void;
            }
            /**
             * @en The directional light representation in the render scene, it acts as the main light source in a scene.
             * As main light, only one directional light can be created in a scene, it can generate realtime shadows with configuration.
             * @zh 渲染场景中的方向光抽象，这是场景中的主光源。作为主光源，每个场景只能有一个方向光，它也包含阴影配置，用来生成实时阴影。
             */
            export class DirectionalLight extends Light {
                protected _dir: math.Vec3;
                protected _illuminanceHDR: number;
                protected _illuminanceLDR: number;
                protected _shadowEnabled: boolean;
                protected _shadowPcf: number;
                protected _shadowBias: number;
                protected _shadowNormalBias: number;
                protected _shadowSaturation: number;
                protected _shadowDistance: number;
                protected _shadowInvisibleOcclusionRange: number;
                protected _csmLevel: number;
                protected _csmNeedUpdate: boolean;
                protected _csmLayerLambda: number;
                protected _csmOptimizationMode: number;
                protected _csmLayersTransition: boolean;
                protected _csmTransitionRange: number;
                protected _shadowFixedArea: boolean;
                protected _shadowNear: number;
                protected _shadowFar: number;
                protected _shadowOrthoSize: number;
                /**
                 * @en The direction vector of the light
                 * @zh 光源的方向
                 */
                set direction(dir: math.Vec3);
                get direction(): math.Vec3;
                /**
                 * @en The illuminance of the light in Lux(lx)
                 * @zh 光源的辐照度，单位是 Lux(lx)
                 */
                get illuminance(): number;
                set illuminance(value: number);
                /**
                 * @en The illuminance of the light in HDR mode
                 * @zh HDR 模式下光源的辐照度
                 */
                get illuminanceHDR(): number;
                set illuminanceHDR(value: number);
                /**
                 * @en The illuminance of the light in LDR mode
                 * @zh LDR 模式下光源的辐照度
                 */
                get illuminanceLDR(): number;
                set illuminanceLDR(value: number);
                /**
                 * @en Whether activate shadow
                 * @zh 是否启用阴影？
                 */
                get shadowEnabled(): boolean;
                set shadowEnabled(val: boolean);
                /**
                 * @en get or set shadow pcf.
                 * @zh 获取或者设置阴影pcf等级。
                 */
                get shadowPcf(): number;
                set shadowPcf(val: number);
                /**
                 * @en get or set shadow map sampler offset
                 * @zh 获取或者设置阴影纹理偏移值
                 */
                get shadowBias(): number;
                set shadowBias(val: number);
                /**
                 * @en get or set normal bias.
                 * @zh 设置或者获取法线偏移。
                 */
                get shadowNormalBias(): number;
                set shadowNormalBias(val: number);
                /**
                 * @en Shadow color saturation
                 * @zh 阴影颜色饱和度
                 */
                get shadowSaturation(): number;
                set shadowSaturation(val: number);
                /**
                 * @en get or set shadow camera far
                 * @zh 获取或者设置潜在阴影产生的范围
                 */
                get shadowDistance(): number;
                set shadowDistance(val: number);
                /**
                 * @en get or set shadow camera far
                 * @zh 获取或者设置潜在阴影产生的范围
                 */
                get shadowInvisibleOcclusionRange(): number;
                set shadowInvisibleOcclusionRange(val: number);
                /**
                 * @en get or set shadow CSM level
                 * @zh 获取或者设置级联阴影层数
                 */
                get csmLevel(): number;
                set csmLevel(val: number);
                /**
                 * @en is CSM need update
                 * @zh 获取或者设置级联阴影是否需要更新
                 */
                get csmNeedUpdate(): boolean;
                set csmNeedUpdate(val: boolean);
                /**
                 * @en get or set shadow CSM level ratio
                 * @zh 获取或者设置级联阴影层数系数
                 */
                get csmLayerLambda(): number;
                set csmLayerLambda(val: number);
                /**
                 * @en get or set shadow CSM performance optimization mode
                 * @zh 获取或者设置级联阴影性能优化模式
                 */
                get csmOptimizationMode(): number;
                set csmOptimizationMode(val: number);
                /**
                 * @en get or set fixed area shadow
                 * @zh 是否是固定区域阴影
                 */
                get shadowFixedArea(): boolean;
                set shadowFixedArea(val: boolean);
                /**
                 * @en The near clip plane of the shadow camera
                 * @zh 获取或者设置阴影相机近裁剪面
                 */
                get shadowNear(): number;
                set shadowNear(val: number);
                /**
                 * @en The far clip plane of the shadow camera
                 * @zh 获取或者设置阴影相机远裁剪面
                 */
                get shadowFar(): number;
                set shadowFar(val: number);
                /**
                 * @en get or set shadow camera orthoSize
                 * @zh 获取或者设置阴影相机正交大小
                 */
                get shadowOrthoSize(): number;
                set shadowOrthoSize(val: number);
                /**
                 * @en Enabled csm layers transition
                 * @zh 是否启用级联阴影层级过渡？
                 */
                get csmLayersTransition(): boolean;
                set csmLayersTransition(val: boolean);
                /**
                 * @en get or set csm layers transition range
                 * @zh 获取或者设置级联阴影层级过渡范围？
                 */
                get csmTransitionRange(): number;
                set csmTransitionRange(val: number);
                constructor();
                initialize(): void;
                /**
                 * @en Update the direction
                 * @zh 更新方向
                 */
                update(): void;
            }
            /**
             * @en The sphere light representation in the render scene, it will light up a spherical area in the scene.
             * It doesn't support shadow generation currently.
             * @zh 渲染场景中的球面光抽象，可以照亮场景中的一个球形区域，目前还不支持生成阴影。
             */
            export class SphereLight extends Light {
                /**
                 * @en The world position of the light source
                 * @zh 光源中心点的世界坐标
                 */
                get position(): math.Vec3;
                /**
                 * @en The size of the light source
                 * @zh 球面光源的尺寸
                 */
                set size(size: number);
                get size(): number;
                /**
                 * @en The lighting range of the light source
                 * @zh 球面光源的光照范围
                 */
                set range(range: number);
                get range(): number;
                /**
                 * @en The luminance of the light source
                 * @zh 光源的亮度
                 */
                get luminance(): number;
                set luminance(value: number);
                /**
                 * @en The luminance of the light source in HDR mode
                 * @zh HDR 模式下光源的亮度
                 */
                get luminanceHDR(): number;
                set luminanceHDR(value: number);
                /**
                 * @en The luminance of the light source in LDR mode
                 * @zh LDR 模式下光源的亮度
                 */
                set luminanceLDR(value: number);
                /**
                 * @en The AABB bounding box of the lighting area
                 * @zh 受光源影响范围的 AABB 包围盒
                 */
                get aabb(): geometry.AABB;
                protected _needUpdate: boolean;
                protected _size: number;
                protected _range: number;
                protected _luminanceHDR: number;
                protected _luminanceLDR: number;
                protected _pos: math.Vec3;
                protected _aabb: geometry.AABB;
                constructor();
                initialize(): void;
                /**
                 * @en Update the lighting area
                 * @zh 更新光源影响范围
                 */
                update(): void;
            }
            /**
             * @en The spot light representation in the render scene, it will light up a cone area in the direction of the light, it supports shadow generation.
             * @zh 渲染场景中的聚光灯抽象，可以照亮光源方向上的一个锥形区域，支持生成阴影。
             */
            export class SpotLight extends Light {
                protected _dir: math.Vec3;
                protected _range: number;
                protected _spotAngle: number;
                protected _angleAttenuationStrength: number;
                protected _pos: math.Vec3;
                protected _aabb: geometry.AABB;
                protected _frustum: geometry.Frustum;
                /**
                 * @en User-specified full-angle radians.
                 * @zh 用户指定的全角弧度。
                 */
                protected _angle: number;
                protected _needUpdate: boolean;
                protected _size: number;
                protected _luminanceHDR: number;
                protected _luminanceLDR: number;
                protected _shadowEnabled: boolean;
                protected _shadowPcf: number;
                protected _shadowBias: number;
                protected _shadowNormalBias: number;
                /**
                 * @en The world position of the light source
                 * @zh 光源的世界坐标
                 */
                get position(): math.Vec3;
                /**
                 * @en The size of the spot light source
                 * @zh 聚光灯的光源尺寸
                 */
                set size(size: number);
                get size(): number;
                /**
                 * @en The lighting range of the spot light
                 * @zh 聚光灯的光照范围
                 */
                set range(range: number);
                get range(): number;
                /**
                 * @en The luminance of the light source
                 * @zh 光源的亮度
                 */
                get luminance(): number;
                set luminance(value: number);
                /**
                 * @en The luminance of the light source in HDR mode
                 * @zh HDR 模式下光源的亮度
                 */
                get luminanceHDR(): number;
                set luminanceHDR(value: number);
                /**
                 * @en The luminance of the light source in LDR mode
                 * @zh LDR 模式下光源的亮度
                 */
                get luminanceLDR(): number;
                set luminanceLDR(value: number);
                /**
                 * @en The direction of the spot light
                 * @zh 聚光灯的照明方向
                 */
                get direction(): math.Vec3;
                /**
                 * @en The setter will take the value as the cone angle,
                 * but the getter will give you the cosine value of the half cone angle: `cos(angle / 2)`.
                 * As the in-consistence is not acceptable for a property, please do not use it.
                 * @zh 赋值时这个属性会把输入值当做聚光灯光照区域的锥角，但是获取时返回的是 cos(angle / 2)。
                 * 由于这种不一致性，请不要使用这个属性。
                 * @internal
                 */
                get spotAngle(): number;
                set spotAngle(val: number);
                /**
                 * @en The angle attenuation strength of the spot light.
                 * The larger the value, the softer the edge, and the smaller the value, the harder the edge.
                 * @zh 聚光灯角度衰减强度。值越大，边缘越柔和，值越小，边缘越硬。
                 */
                get angleAttenuationStrength(): number;
                set angleAttenuationStrength(val: number);
                /**
                 * @en The cone angle of the lighting area
                 * @zh 聚光灯锥角
                 */
                get angle(): number;
                get aabb(): geometry.AABB;
                /**
                 * @en The frustum of the lighting area
                 * @zh 受光源影响范围的截椎体
                 */
                get frustum(): geometry.Frustum;
                /**
                 * @en Whether shadow casting is enabled
                 * @zh 是否启用阴影？
                 */
                get shadowEnabled(): boolean;
                set shadowEnabled(val: boolean);
                /**
                 * @en The pcf level of the shadow generation.
                 * @zh 获取或者设置阴影 pcf 等级。
                 */
                get shadowPcf(): number;
                set shadowPcf(val: number);
                /**
                 * @en The depth offset of shadow to avoid moire pattern artifacts
                 * @zh 阴影的深度偏移, 可以减弱跨像素导致的条纹状失真
                 */
                get shadowBias(): number;
                set shadowBias(val: number);
                /**
                 * @en The normal bias of the shadow map.
                 * @zh 设置或者获取法线偏移。
                 */
                get shadowNormalBias(): number;
                set shadowNormalBias(val: number);
                constructor();
                initialize(): void;
                update(): void;
            }
            /**
             * @en The point light representation in the render scene, it will light up a spherical area in the scene.
             * It doesn't support shadow generation currently.
             * @zh 渲染场景中的点光抽象，可以照亮场景中的一个球形区域，目前还不支持生成阴影。
             */
            export class PointLight extends Light {
                /**
                 * @en The world position of the light source.
                 * @zh 光源中心点的世界坐标。
                 */
                get position(): Readonly<math.Vec3>;
                /**
                 * @en The lighting range of the light source.
                 * @zh 点光源的光照范围。
                 */
                set range(range: number);
                get range(): number;
                /**
                 * @en The luminance of the light source.
                 * @zh 光源的亮度。
                 */
                get luminance(): number;
                set luminance(value: number);
                /**
                 * @en The luminance of the light source in HDR mode.
                 * @zh HDR 模式下光源的亮度。
                 */
                get luminanceHDR(): number;
                set luminanceHDR(value: number);
                /**
                 * @en The luminance of the light source in LDR mode.
                 * @zh LDR 模式下光源的亮度。
                 */
                set luminanceLDR(value: number);
                /**
                 * @en The AABB bounding box of the lighting area.
                 * @zh 受光源影响范围的 AABB 包围盒。
                 */
                get aabb(): geometry.AABB;
                constructor();
                initialize(): void;
                /**
                 * @en Update the lighting area.
                 * @zh 更新光源影响范围。
                 */
                update(): void;
            }
            /**
             * @en Render the abstraction of light in the scene, which is a ranged directional light source in the scene. Non main light source,
             * each scene is allowed to have multiple ranged directional light sources without shadows.
             * @zh 渲染场景中的光的抽象，这是场景中的范围平行光光源。非主光源，每个场景允许有多个范围平行光光源，不包含阴影。
             */
            export class RangedDirectionalLight extends Light {
                /**
                 * @en The direction vector of the light
                 * @zh 光源的方向
                 */
                get direction(): Readonly<math.Vec3>;
                /**
                 * @en The right vector of the light
                 * @zh 光源的右方向
                 */
                get right(): Readonly<math.Vec3>;
                /**
                 * @en The world position of the light source
                 * @zh 光源的世界坐标
                 */
                get position(): Readonly<math.Vec3>;
                /**
                 * @en The world scale of the light source
                 * @zh 光源的世界缩放
                 */
                get scale(): Readonly<math.Vec3>;
                /**
                 * @en The illuminance of the light in Lux(lx)
                 * @zh 光源的辐照度，单位是 Lux(lx)
                 */
                get illuminance(): number;
                set illuminance(value: number);
                /**
                 * @en The illuminance of the light in HDR mode
                 * @zh HDR 模式下光源的辐照度
                 */
                get illuminanceHDR(): number;
                set illuminanceHDR(value: number);
                /**
                 * @en The illuminance of the light in LDR mode
                 * @zh LDR 模式下光源的辐照度
                 */
                get illuminanceLDR(): number;
                set illuminanceLDR(value: number);
                constructor();
                initialize(): void;
                /**
                 * @en Update
                 * @zh 更新
                 */
                update(): void;
            }
            export enum ProbeClearFlag {
                SKYBOX = 14,
                SOLID_COLOR = 7
            }
            export enum ProbeType {
                CUBE = 0,
                PLANAR = 1
            }
            export class ReflectionProbe {
                bakedCubeTextures: RenderTexture[];
                realtimePlanarTexture: RenderTexture | null;
                protected _resolution: number;
                protected _clearFlag: number;
                protected _backgroundColor: math.Color;
                protected _visibility: number;
                protected _probeType: ProbeType;
                protected _cubemap: TextureCube | null;
                protected readonly _size: math.Vec3;
                /**
                 * @en Reflection probe cube pattern preview sphere
                 * @zh 反射探针cube模式的预览小球
                 */
                protected _previewSphere: Node | null;
                protected _previewPlane: Node | null;
                /**
                 * @en Set probe type,cube or planar.
                 * @zh 设置探针类型，cube或者planar
                 */
                set probeType(value: ProbeType);
                get probeType(): ProbeType;
                get resolution(): number;
                /**
                 * @en set render texture size
                 * @zh 设置渲染纹理大小
                 */
                set resolution(value: number);
                /**
                 * @en Clearing flags of the camera, specifies which part of the framebuffer will be actually cleared every frame.
                 * @zh 相机的缓冲清除标志位，指定帧缓冲的哪部分要每帧清除。
                 */
                set clearFlag(value: number);
                get clearFlag(): number;
                /**
                 * @en Clearing color of the camera.
                 * @zh 相机的颜色缓冲默认值。
                 */
                set backgroundColor(val: math.Color);
                get backgroundColor(): math.Color;
                /**
                 * @en Visibility mask, declaring a set of node layers that will be visible to this camera.
                 * @zh 可见性掩码，声明在当前相机中可见的节点层级集合。
                 */
                get visibility(): number;
                set visibility(val: number);
                /**
                 * @en Gets or sets the size of the box, in local space.
                 * @zh 获取或设置盒的大小。
                 */
                set size(value: math.Vec3);
                get size(): math.Vec3;
                set cubemap(val: TextureCube | null);
                get cubemap(): TextureCube | null;
                /**
                 * @en The node of the probe.
                 * @zh probe绑定的节点
                 */
                get node(): Node;
                get camera(): Camera;
                /**
                 * @en Refresh the objects that use this probe.
                 * @zh 刷新使用该probe的物体
                 */
                set needRefresh(value: boolean);
                get needRefresh(): boolean;
                set needRender(value: boolean);
                get needRender(): boolean;
                get boundingBox(): geometry.AABB | null;
                set cameraNode(node: Node);
                get cameraNode(): Node;
                /**
                 * @en Reflection probe planar mode preview plane
                 * @zh 反射探针Planar模式的预览平面
                 */
                set previewPlane(val: Node);
                get previewPlane(): Node;
                constructor(id: number);
                initialize(node: Node, cameraNode: Node): void;
                initBakedTextures(): void;
                captureCubemap(): void;
                /**
                 * @en Render real-time planar reflection textures
                 * @zh 渲染实时平面反射贴图
                 * @param sourceCamera render planar reflection for this camera
                 */
                renderPlanarReflection(sourceCamera: Camera): void;
                switchProbeType(type: ProbeType, sourceCamera: Camera | null): void;
                getProbeId(): number;
                updateProbeId(id: any): void;
                renderArea(): math.Vec2;
                isFinishedRendering(): boolean;
                validate(): boolean;
                destroy(): void;
                enable(): void;
                disable(): void;
                updateCameraDir(faceIdx: number): void;
                updateBoundingBox(): void;
                hasFrameBuffer(framebuffer: gfx.Framebuffer): boolean;
                isRGBE(): boolean;
            }
            export const ToneMappingType: {
                DEFAULT: number;
                LINEAR: number;
            };
            export class PostSettings {
                protected _toneMappingType: number;
                protected _activated: boolean;
                set toneMappingType(val: number);
                get toneMappingType(): number;
                initialize(postSettingsInfo: PostSettingsInfo): void;
                activate(): void;
                protected _updatePipeline(): void;
            }
        }
        export enum RenderQueue {
            OPAQUE = 0,
            TRANSPARENT = 1,
            OVERLAY = 2
        }
        export enum PassStage {
            DEFAULT = 1,
            FORWARD = 2,
            SHADOWCAST = 4
        }
        /**
         * @en Gets the default values for the given type of uniform
         * @zh 根据指定的 Uniform 类型来获取默认值
         * @param type The type of the uniform
         */
        export function getDefaultFromType(type: gfx.Type): readonly number[] | string;
        export function getStringFromType(type: gfx.Type): string;
        /**
         * @en Override the preprocess macros
         * @zh 覆写预处理宏
         * @param target Target preprocess macros to be overridden
         * @param source Preprocess macros used for override
         */
        export function overrideMacros(target: MacroRecord, source: MacroRecord): boolean;
        export const genHandle: (binding: number, type: gfx.Type, count: number, offset?: number) => number;
        export const getTypeFromHandle: (handle: number) => number;
        export const getBindingFromHandle: (handle: number) => number;
        export const getCountFromHandle: (handle: number) => number;
        export const getOffsetFromHandle: (handle: number) => number;
        export const customizeType: (handle: number, type: gfx.Type) => number;
        /**
         * @en Vector type uniforms
         * @zh 向量类型 uniform
         */
        export type MaterialProperty = number | math.Vec2 | math.Vec3 | math.Vec4 | math.Color | math.Mat3 | math.Mat4 | math.Quat;
        export const type2reader: {
            0: (a: Float32Array, v: number, idx?: number) => void;
            5: (a: Int32Array, v: number, idx?: number) => number;
            6: (a: Int32Array, v: math.IVec2Like, idx?: number) => math.IVec2Like;
            7: (a: Int32Array, v: math.IVec3Like, idx?: number) => math.IVec3Like;
            8: (a: Int32Array, v: math.IVec4Like, idx?: number) => math.IVec4Like;
            13: (a: Float32Array, v: number, idx?: number) => number;
            14: (a: Float32Array, v: math.IVec2Like, idx?: number) => math.IVec2Like;
            15: (a: Float32Array, v: math.IVec3Like, idx?: number) => math.IVec3Like;
            16: (a: Float32Array, v: math.IVec4Like, idx?: number) => math.IVec4Like;
            21: (a: Float32Array, v: math.IMat3Like, idx?: number) => math.IMat3Like;
            25: (a: Float32Array, v: math.IMat4Like, idx?: number) => math.IMat4Like;
        };
        export const type2writer: {
            0: (a: Float32Array, v: number, idx?: number) => void;
            5: (a: Int32Array, v: number, idx?: number) => number;
            6: (a: Int32Array, v: math.Vec2, idx?: number) => Int32Array;
            7: (a: Int32Array, v: math.Vec3, idx?: number) => Int32Array;
            8: (a: Int32Array, v: math.Vec4, idx?: number) => Int32Array;
            13: (a: Float32Array, v: number, idx?: number) => number;
            14: (a: Float32Array, v: math.Vec2, idx?: number) => Float32Array;
            15: (a: Float32Array, v: math.Vec3, idx?: number) => Float32Array;
            16: (a: Float32Array, v: math.Vec4, idx?: number) => Float32Array;
            21: (a: Float32Array, v: math.Mat3, idx?: number) => Float32Array;
            25: (a: Float32Array, v: math.Mat4, idx?: number) => Float32Array;
        };
        export const type2validator: {
            5: (v: number) => boolean;
            13: (v: number) => boolean;
            6: (v: math.Vec2) => boolean;
            14: (v: math.Vec2) => boolean;
            7: (v: math.Vec3) => boolean;
            15: (v: math.Vec3) => boolean;
            8: (v: math.Vec4) => boolean;
            16: (v: math.Vec4 | math.Color | math.Quat) => boolean;
            21: (v: math.Mat3) => boolean;
            25: (v: math.Mat4) => boolean;
        };
        /**
         * @en Combination of preprocess macros
         * @zh 预处理宏组合
         */
        export type MacroRecord = Record<string, number | boolean | string>;
        export interface IPassInfoFull extends EffectAsset.IPassInfo {
            passIndex: number;
            defines: MacroRecord;
            stateOverrides?: PassOverrides;
        }
        export type PassOverrides = __private.__types_globals__RecursivePartial<EffectAsset.IPassStates>;
        export interface IMacroPatch {
            name: string;
            value: boolean | number | string;
        }
        export enum BatchingSchemes {
            NONE = 0,
            INSTANCING = 1
        }
        /**
         * @en Render pass, store actual resources for the rendering process
         * @zh 渲染 pass，储存实际描述绘制过程的各项资源。
         */
        export class Pass {
            /**
             * @en Get the type of member in uniform buffer object with the handle
             * @zh 根据 handle 获取 uniform 的具体类型。
             */
            static getTypeFromHandle: (handle: number) => number;
            /**
             * @en Get the binding with handle
             * @zh 根据 handle 获取 binding。
             */
            static getBindingFromHandle: (handle: number) => number;
            /**
             * @en Get the array length with handle
             * @zh 根据 handle 获取数组长度。
             */
            static getCountFromHandle: (handle: number) => number;
            protected static getOffsetFromHandle: (handle: number) => number;
            /**
             * @en Fill a pass represented by the given pass handle with the given override info
             * @param hPass The pass handle point to the pass
             * @param info The pass override info
             */
            static fillPipelineInfo(pass: Pass, info: PassOverrides): void;
            /**
             * @en Get pass hash value by [[renderer.Pass]] hash information.
             * @zh 根据 [[renderer.Pass]] 的哈希信息获取哈希值。
             *
             * @param hPass Handle of the pass info used to compute hash value.
             */
            static getPassHash(pass: Pass): number;
            protected _rootBuffer: gfx.Buffer | null;
            protected _buffers: gfx.Buffer[];
            protected _descriptorSet: gfx.DescriptorSet;
            protected _pipelineLayout: gfx.PipelineLayout;
            protected _passIndex: number;
            protected _propertyIndex: number;
            protected _programName: string;
            protected _dynamics: __private._cocos_render_scene_core_pass__IPassDynamics;
            protected _propertyHandleMap: Record<string, number>;
            protected _rootBlock: ArrayBuffer | null;
            protected _blocksInt: Int32Array[];
            protected _blocks: Float32Array[];
            protected _shaderInfo: IProgramInfo;
            protected _defines: MacroRecord;
            protected _properties: Record<string, EffectAsset.IPropertyInfo>;
            protected _shader: gfx.Shader | null;
            protected _bs: gfx.BlendState;
            protected _dss: gfx.DepthStencilState;
            protected _rs: gfx.RasterizerState;
            protected _priority: pipeline.RenderPriority;
            protected _stage: pipeline.RenderPassStage;
            protected _phase: number;
            protected _passID: number;
            protected _subpassID: number;
            protected _phaseID: number;
            protected _primitive: gfx.PrimitiveMode;
            protected _batchingScheme: BatchingSchemes;
            protected _dynamicStates: gfx.DynamicStateFlagBit;
            protected _instancedBuffers: Record<number, InstancedBuffer>;
            protected _hash: number;
            protected _root: Root;
            protected _device: gfx.Device;
            protected _rootBufferDirty: boolean;
            constructor(root: Root);
            /**
             * @en Initialize the pass with given pass info, shader will be compiled in the init process
             * @zh 根据指定参数初始化当前 pass，shader 会在这一阶段就尝试编译。
             */
            initialize(info: IPassInfoFull): void;
            /**
             * @en Get the handle of a UBO member, or specific channels of it.
             * @zh 获取指定 UBO 成员，或其更具体分量的读写句柄。默认以成员自身的类型为目标读写类型（即读写时必须传入与成员类型相同的变量）。
             * @param name Name of the target UBO member.
             * @param offset Channel offset into the member.
             * @param targetType Target type of the handle, i.e. the type of data when read/write to it.
             * @example
             * ```
             * import { Vec3, gfx } from 'cc';
             * // say 'pbrParams' is a uniform vec4
             * const hParams = pass.getHandle('pbrParams'); // get the default handle
             * pass.setUniform(hAlbedo, new Vec3(1, 0, 0)); // wrong! pbrParams.w is NaN now
             *
             * // say 'albedoScale' is a uniform vec4, and we only want to modify the w component in the form of a single float
             * const hThreshold = pass.getHandle('albedoScale', 3, gfx.Type.FLOAT);
             * pass.setUniform(hThreshold, 0.5); // now, albedoScale.w = 0.5
             * ```
             */
            getHandle(name: string, offset?: number, targetType?: gfx.Type): number;
            /**
             * @en Gets the uniform binding with its name
             * @zh 获取指定 uniform 的 binding。
             * @param name The name of target uniform
             */
            getBinding(name: string): number;
            /**
             * @en Sets a vector type uniform value, if a uniform requires frequent update, please use this method.
             * @zh 设置指定普通向量类 uniform 的值，如果需要频繁更新请尽量使用此接口。
             * @param handle The handle for the target uniform
             * @param value New value
             */
            setUniform(handle: number, value: MaterialProperty): void;
            /**
             * @en Gets a uniform's value.
             * @zh 获取指定普通向量类 uniform 的值。
             * @param handle The handle for the target uniform
             * @param out The output property to store the result
             */
            getUniform<T extends MaterialProperty>(handle: number, out: T): T;
            /**
             * @en Sets an array type uniform value, if a uniform requires frequent update, please use this method.
             * @zh 设置指定数组类 uniform 的值，如果需要频繁更新请尽量使用此接口。
             * @param handle The handle for the target uniform
             * @param value New value
             */
            setUniformArray(handle: number, value: MaterialProperty[]): void;
            /**
             * @en Bind a GFX [[gfx.Texture]] the the given uniform binding
             * @zh 绑定实际 GFX [[gfx.Texture]] 到指定 binding。
             * @param binding The binding for target uniform of texture type
             * @param value Target texture
             */
            bindTexture(binding: number, value: gfx.Texture, index?: number): void;
            /**
             * @en Bind a GFX [[gfx.Sampler]] the the given uniform binding
             * @zh 绑定实际 GFX [[gfx.Sampler]] 到指定 binding。
             * @param binding The binding for target uniform of sampler type
             * @param value Target sampler
             */
            bindSampler(binding: number, value: gfx.Sampler, index?: number): void;
            /**
             * @en Sets the dynamic pipeline state property at runtime
             * @zh 设置运行时 pass 内可动态更新的管线状态属性。
             * @param state Target dynamic state
             * @param value Target value
             */
            setDynamicState(state: gfx.DynamicStateFlagBit, value: number): void;
            /**
             * @en Override all pipeline states with the given pass override info.
             * @zh 重载当前所有管线状态。
             * @param original The original pass info
             * @param value The override pipeline state info
             */
            overridePipelineStates(original: EffectAsset.IPassInfo, overrides: PassOverrides): void;
            /**
             * @en Update the current uniforms data.
             * @zh 更新当前 Uniform 数据。
             */
            update(): void;
            getInstancedBuffer(extraKey?: number): InstancedBuffer;
            /**
             * @en Destroy the current pass.
             * @zh 销毁当前 pass。
             */
            destroy(): void;
            /**
             * @en Resets the value of the given uniform by name to the default value in [[EffectAsset]].
             * This method does not support array type uniform.
             * @zh 重置指定（非数组） Uniform 为 [[EffectAsset]] 默认值。
             */
            resetUniform(name: string): void;
            /**
             * @en Resets the value of the given texture by name to the default value in [[EffectAsset]].
             * @zh 重置指定贴图为 [[EffectAsset]] 默认值。
             */
            resetTexture(name: string, index?: number): void;
            /**
             * @en Resets all uniform buffer objects to the default values in [[EffectAsset]]
             * @zh 重置所有 UBO 为默认值。
             */
            resetUBOs(): void;
            /**
             * @en Resets all textures and samplers to the default values in [[EffectAsset]]
             * @zh 重置所有 texture 和 sampler 为初始默认值。
             */
            resetTextures(): void;
            /**
             * @en Try to compile the shader and retrieve related resources references.
             * @zh 尝试编译 shader 并获取相关资源引用。
             */
            tryCompile(): boolean;
            /**
             * @en Gets the shader variant of the current pass and given macro patches
             * @zh 结合指定的编译宏组合获取当前 Pass 的 Shader Variant
             * @param patches The macro patches
             */
            getShaderVariant(patches?: Readonly<IMacroPatch[] | null>): gfx.Shader | null;
            protected get _isBlend(): boolean;
            /**
             * @private
             */
            beginChangeStatesSilently(): void;
            /**
             * @private
             */
            endChangeStatesSilently(): void;
            protected _doInit(info: IPassInfoFull, copyDefines?: boolean): void;
            protected _syncBatchingScheme(): void;
            get root(): Root;
            get device(): gfx.Device;
            get shaderInfo(): IProgramInfo;
            get localSetLayout(): gfx.DescriptorSetLayout;
            get program(): string;
            get properties(): Record<string, EffectAsset.IPropertyInfo>;
            get defines(): Record<string, string | number | boolean>;
            get passIndex(): number;
            get propertyIndex(): number;
            get dynamics(): __private._cocos_render_scene_core_pass__IPassDynamics;
            get blocks(): Float32Array[];
            get blocksInt(): Int32Array[];
            get rootBufferDirty(): boolean;
            get priority(): pipeline.RenderPriority;
            get primitive(): gfx.PrimitiveMode;
            get stage(): pipeline.RenderPassStage;
            get phase(): number;
            get passID(): number;
            get phaseID(): number;
            get rasterizerState(): gfx.RasterizerState;
            get depthStencilState(): gfx.DepthStencilState;
            get blendState(): gfx.BlendState;
            get dynamicStates(): gfx.DynamicStateFlags;
            get batchingScheme(): BatchingSchemes;
            get descriptorSet(): gfx.DescriptorSet;
            get hash(): number;
            get pipelineLayout(): gfx.PipelineLayout;
        }
        export namespace Pass {
            export type getTypeFromHandle = typeof Pass.getTypeFromHandle;
            export type getBindingFromHandle = typeof Pass.getBindingFromHandle;
            export type fillPipelineInfo = typeof Pass.fillPipelineInfo;
            export type getPassHash = typeof Pass.getPassHash;
            export type getCountFromHandle = typeof Pass.getCountFromHandle;
        }
        export function nearestPOT(num: number): number;
        export interface ITextureBuffer {
            texture: gfx.Texture;
            size: number;
            start: number;
            end: number;
        }
        export interface ITextureBufferHandle {
            chunkIdx: number;
            start: number;
            end: number;
            texture: gfx.Texture;
        }
        export interface ITextureBufferPoolInfo {
            format: gfx.Format;
            inOrderFree?: boolean;
            alignment?: number;
            roundUpFn?: (size: number, formatSize: number) => number;
        }
        export class TextureBufferPool {
            constructor(device: gfx.Device);
            initialize(info: ITextureBufferPoolInfo): void;
            destroy(): void;
            alloc(size: number, chunkIdx?: number): ITextureBufferHandle;
            free(handle: ITextureBufferHandle): void;
            createChunk(length: number): number;
            update(handle: ITextureBufferHandle, buffer: ArrayBuffer): void;
        }
        export interface IMaterialInstanceInfo {
            parent: Material;
            owner?: Renderer;
            subModelIdx?: number;
        }
        /**
         * @zh
         * 材质实例，当有材质修改需求时，根据材质资源创建的，可任意定制的实例。
         */
        export class MaterialInstance extends Material {
            get parent(): Material;
            get owner(): Renderer | null;
            protected _passes: PassInstance[];
            constructor(info: IMaterialInstanceInfo);
            recompileShaders(overrides: MacroRecord, passIdx?: number): void;
            overridePipelineStates(overrides: PassOverrides, passIdx?: number): void;
            destroy(): boolean;
            onPassStateChange(dontNotify: boolean): void;
            protected _createPasses(): PassInstance[];
        }
        /**
         * @en A pass instance defines an variant version of the [[renderer.Pass]]
         * @zh 表示 [[renderer.Pass]] 的一种特殊实例
         */
        export class PassInstance extends Pass {
            /**
             * @en The parent pass
             * @zh 相关联的原始 Pass
             */
            get parent(): Pass;
            constructor(parent: Pass, owner: MaterialInstance);
            /**
             * @en Override pipeline states with the given pass override info.
             * This won't affect the original pass
             * @zh 重载当前 Pass 的管线状态。这不会影响原始 Pass
             * @param original The original pass info
             * @param value The override pipeline state info
             */
            overridePipelineStates(original: EffectAsset.IPassInfo, overrides: PassOverrides): void;
            tryCompile(defineOverrides?: MacroRecord): boolean;
            /**
             * @en Prepare to change states of the pass and do not notify the material to rebuild the pipeline state object
             * @zh 开始静默修改 Pass 相关状态，不会通知材质去重新构建管线状态对象。
             */
            beginChangeStatesSilently(): void;
            /**
             * @en End the silent states changing process, all state changes will be notified.
             * @zh 结束静默状态修改，所有修改将会开始通知材质。
             */
            endChangeStatesSilently(): void;
            protected _syncBatchingScheme(): void;
            protected _onStateChange(): void;
        }
        export enum PoolType {
            NODE = 0,
            PASS = 1,
            AABB = 2,
            RENDER2D = 3
        }
        export const NULL_HANDLE: __private._cocos_render_scene_core_memory_pools__IHandle<any>;
        export type Render2dHandle = __private._cocos_render_scene_core_memory_pools__IHandle<PoolType.RENDER2D>;
        export enum Render2dView {
            POSITION = 0,
            UV = 3,
            COLOR = 5,
            COUNT = 9
        }
        export const Render2dPool: __private._cocos_render_scene_core_memory_pools__BufferPool<PoolType.RENDER2D, typeof Render2dView>;
        export type NodeHandle = __private._cocos_render_scene_core_memory_pools__IHandle<PoolType.NODE>;
        export enum NodeView {
            DIRTY_FLAG = 0,
            LAYER = 1,
            WORLD_SCALE = 2,
            WORLD_POSITION = 5,
            WORLD_ROTATION = 8,
            WORLD_MATRIX = 12,
            LOCAL_SCALE = 28,
            LOCAL_POSITION = 31,
            LOCAL_ROTATION = 34,
            COUNT = 38
        }
        export const NodePool: __private._cocos_render_scene_core_memory_pools__BufferPool<PoolType.NODE, typeof NodeView>;
        export type PassHandle = __private._cocos_render_scene_core_memory_pools__IHandle<PoolType.PASS>;
        export enum PassView {
            PRIORITY = 0,
            STAGE = 1,
            PHASE = 2,
            PRIMITIVE = 3,
            BATCHING_SCHEME = 4,
            DYNAMIC_STATE = 5,
            HASH = 6,
            COUNT = 7
        }
        export const PassPool: __private._cocos_render_scene_core_memory_pools__BufferPool<PoolType.PASS, typeof PassView>;
        export type AABBHandle = __private._cocos_render_scene_core_memory_pools__IHandle<PoolType.AABB>;
        export enum AABBView {
            CENTER = 0,
            HALFEXTENTS = 3,
            COUNT = 6
        }
        export const AABBPool: __private._cocos_render_scene_core_memory_pools__BufferPool<PoolType.AABB, typeof AABBView>;
        export interface IRenderSceneInfo {
            name: string;
        }
        export interface ISceneNodeInfo {
            name: string;
            isStatic?: boolean;
        }
        /**
         * @en The result of one raycast operation
         * @zh 一次射线检测的结果
         */
        export interface IRaycastResult {
            node: Node;
            distance: number;
        }
        /**
         * @en The render scene which is created by the [[Root]] and provides all basic render scene elements for the render process.
         * It manages:
         * 1. [[Camera]]s
         * 2. [[Light]]s
         * 3. Renderable objects: [[renderer.Model]]s and `DrawBatchs`
         * @zh 渲染场景，由 [[Root]] 创建，并提供用于渲染流程的所有场景基础元素。它管理：
         * 1. [[Camera]]s：相机
         * 2. [[Light]]s：光源
         * 3. 渲染元素：[[renderer.Model]]s 和 `DrawBatchs`
         */
        export class RenderScene {
            /**
             * @en The root manager of the renderer.
             * @zh 基础渲染管理器。
             */
            get root(): Root;
            /**
             * @en The name of the render scene.
             * @zh 渲染场景的名称。
             */
            get name(): string;
            /**
             * @en All cameras of the render scene.
             * @zh 渲染场景管理的所有相机。
             */
            get cameras(): scene.Camera[];
            /**
             * @en The main directional light source of the render scene.
             * @zh 渲染场景管理的主方向光源。
             */
            get mainLight(): scene.DirectionalLight | null;
            /**
             * @en All sphere light sources of the render scene.
             * @zh 渲染场景管理的所有球面光源。
             */
            get sphereLights(): Readonly<scene.SphereLight[]>;
            /**
             * @en All spot light sources of the render scene.
             * @zh 渲染场景管理的所有聚光灯光源。
             */
            get spotLights(): Readonly<scene.SpotLight[]>;
            /**
             * @en All point light sources of the render scene.
             * @zh 渲染场景管理的所有点光源。
             */
            get pointLights(): Readonly<scene.PointLight[]>;
            /**
             * @en All ranged directional light sources of the render scene.
             * @zh 渲染场景管理的所有范围平行光光源。
             */
            get rangedDirLights(): Readonly<scene.RangedDirectionalLight[]>;
            /**
             * @en All active models of the render scene.
             * @zh 渲染场景管理的所有模型。
             */
            get models(): scene.Model[];
            /**
             * @en All active 2d draw batches of the render scene.
             * @zh 渲染场景管理的所有 2D 渲染批次对象。
             */
            get batches(): __private._cocos_2d_renderer_draw_batch__DrawBatch2D[];
            /**
             * Register the creation function of the render scene to root.
             * @internal
             */
            static registerCreateFunc(root: Root): void;
            constructor(root: Root);
            /**
             * @en Initialize the render scene
             * @zh 初始化渲染场景
             * @returns Successful
             */
            initialize(info: IRenderSceneInfo): boolean;
            /**
             * @en The update process of the render scene, it updates all rendering related data for the lights and the models.
             * @zh 渲染场景的更新流程，会更新所有光源和模型的渲染相关数据。
             * @param stamp The update time stamp
             * @returns void
             */
            update(stamp: number): void;
            /**
             * @en Destroy the render scene, dangerous, please do not invoke manually.
             * @zh 销毁渲染场景，请不要手动销毁，会造成未知行为。
             */
            destroy(): void;
            isCulledByLod(camera: scene.Camera, model: scene.Model): boolean;
            /**
             * @en Attach a camera to the render scene
             * @zh 向渲染场景挂载一个相机
             */
            addCamera(cam: scene.Camera): void;
            /**
             * @en Detach a camera to the render scene
             * @zh 从渲染场景移除一个相机
             */
            removeCamera(camera: scene.Camera): void;
            /**
             * @en Detach all cameras to the render scene
             * @zh 从渲染场景移除所有相机
             */
            removeCameras(): void;
            /**
             * @en Sets the main light source for the render scene
             * @zh 给渲染场景设置主光源
             * @param dl The main directional light source
             */
            setMainLight(dl: scene.DirectionalLight | null): void;
            /**
             * @en Remove the main light source from the render scene
             * @zh 从渲染场景移除主光源
             * @param dl The main directional light source, if it's not the actual main light, nothing happens.
             */
            unsetMainLight(dl: scene.DirectionalLight): void;
            /**
             * @en Add a directional light source, only one directional light is active and act as the main light source.
             * @zh 增加一个方向光源，场景中只会有一个方向光是起效的，并且会作为主光源。
             * @param dl The directional light.
             */
            addDirectionalLight(dl: scene.DirectionalLight): void;
            /**
             * @en Remove a directional light source.
             * @zh 删除一个方向光源。
             * @param dl The directional light.
             */
            removeDirectionalLight(dl: scene.DirectionalLight): void;
            /**
             * @en Add a sphere light source.
             * @zh 增加一个球面光源。
             * @param pl The sphere light.
             */
            addSphereLight(pl: scene.SphereLight): void;
            /**
             * @en Remove a sphere light source.
             * @zh 删除一个球面光源。
             * @param pl The sphere light.
             */
            removeSphereLight(pl: scene.SphereLight): void;
            /**
             * @en Add a spot light source.
             * @zh 增加一个聚光灯光源。
             * @param sl The spot light.
             */
            addSpotLight(sl: scene.SpotLight): void;
            /**
             * @en Remove a spot light source.
             * @zh 删除一个聚光灯光源。
             * @param sl The spot light.
             */
            removeSpotLight(sl: scene.SpotLight): void;
            /**
             * @en Remove all sphere light sources.
             * @zh 删除所有球面光源。
             */
            removeSphereLights(): void;
            /**
             * @en Remove all spot light sources.
             * @zh 删除所有聚光灯光源。
             */
            removeSpotLights(): void;
            /**
             * @en Add a point light source.
             * @zh 增加一个点光源。
             * @param pl @en The point light. @zh 点光源。
             */
            addPointLight(pl: scene.PointLight): void;
            /**
             * @en Remove a sphere light source.
             * @zh 删除一个点光源。
             * @param pl @en The point light. @zh 点光源。
             */
            removePointLight(pl: scene.PointLight): void;
            /**
             * @en Remove all point light sources.
             * @zh 删除所有点光源。
             */
            removePointLights(): void;
            /**
             * @en Add a ranged directional light source.
             * @zh 增加一个范围平行光源。
             * @param l @en The ranged directional light. @zh 范围平行光。
             */
            addRangedDirLight(l: scene.RangedDirectionalLight): void;
            /**
             * @en Remove a ranged directional light source.
             * @zh 删除一个范围平行光源。
             * @param l @en The ranged directional light. @zh 范围平行光。
             */
            removeRangedDirLight(l: scene.RangedDirectionalLight): void;
            /**
             * @en Remove all ranged directional light sources.
             * @zh 删除所有范围平行光源。
             */
            removeRangedDirLights(): void;
            /**
             * @en Add a model, all models attached to the render scene will be submitted for rendering.
             * @zh 增加一个模型，渲染场景上挂载的所有模型都会被提交渲染。
             * @param m The model.
             */
            addModel(m: scene.Model): void;
            /**
             * @en Remove a model, model removed will no longer be submitted for rendering.
             * @zh 删除一个模型，移除的模型将不再被提交渲染。
             * @param m The model.
             */
            removeModel(model: scene.Model): void;
            /**
             * @en Remove all models.
             * @zh 删除所有模型。
             */
            removeModels(): void;
            /**
             * @en Add a draw batch of 2d objects, all draw batches attached to the render scene will be submitted for rendering.
             * @zh 增加一个 2D 渲染批次，渲染场景上挂载的所有 2D 渲染批次都会被提交渲染。
             * @param batch The draw batch.
             * @internal
             * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
             */
            addBatch(batch: __private._cocos_2d_renderer_draw_batch__DrawBatch2D): void;
            /**
             * @en Remove a draw batch of 2d objects, draw batch removed will no longer be submitted for rendering.
             * @zh 删除一个 2D 渲染批次，移除的 2D 渲染批次将不再被提交渲染。
             * @param batch The draw batch.
             * @internal
             * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
             */
            removeBatch(batch: __private._cocos_2d_renderer_draw_batch__DrawBatch2D): void;
            /**
             * @en Remove all 2d draw batches.
             * @zh 删除所有 2D 渲染批次。
             * @internal
             * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
             */
            removeBatches(): void;
            /**
             * @en Notify all models that the global pipeline state have been updated so that they can update their render data and states.
             * @zh 通知所有模型全局管线状态已更新，需要更新自身状态。
             */
            onGlobalPipelineStateChanged(): void;
            /**
             * @en Generate a new model id.
             * @zh 生成一个新的模型 ID
             * @returns The model id
             */
            generateModelId(): number;
        }
        export const CameraVisFlags: {};
        export const VisibilityFlags: {};
    }
    export type Constructor<T = unknown> = __private.__types_globals__Constructor<T>;
    export namespace math {
        export namespace bits {
            /**
             * @en Returns -1, 0, +1 depending on sign of x.
             * @zh 根据x的符号返回 -1，0，+1。
             */
            export function sign(v: number): number;
            /**
             * @en Computes absolute value of integer.
             * @zh 计算整数的绝对值。
             */
            export function abs(v: number): number;
            /**
             * @en Computes minimum of integers x and y.
             * @zh 计算整数x和y中的最小值。
             */
            export function min(x: number, y: number): number;
            /**
             * @en Computes maximum of integers x and y.
             * @zh 计算整数x和y中的最大值。
             */
            export function max(x: number, y: number): number;
            /**
             * @en Checks if a number is a power of two.
             * @zh 检查一个数字是否是2的幂。
             */
            export function isPow2(v: number): boolean;
            /**
             * @en Computes log base 2 of v.
             * @zh 计算以 2 为底的 v 的对数。
             */
            export function log2(v: number): number;
            /**
             * @en Computes log base 10 of v.
             * @zh 计算以 10 为底的 v 的对数。
             */
            export function log10(v: number): number;
            /**
             * @en Counts number of bits.
             * @zh 计算传入数字二进制表示中 1 的数量。
             */
            export function popCount(v: number): number;
            /**
             * @en Counts number of trailing zeros.
             * @zh 计算传入数字二进制表示尾随零的数量。
             */
            export function countTrailingZeros(v: number): number;
            /**
             * @en Rounds to next power of 2.
             * @zh 计算大于等于v的最小的二的整数次幂的数字。
             */
            export function nextPow2(v: number): number;
            /**
             * @en Rounds down to previous power of 2.
             * @zh 计算小于等于v的最小的二的整数次幂的数字。
             */
            export function prevPow2(v: number): number;
            /**
             * @en Computes parity of word.
             * @zh 奇偶校验。
             */
            export function parity(v: number): number;
            /**
             * @en Reverse bits in a 32 bit word.
             * @zh 翻转 32 位二进制数字。
             */
            export function reverse(v: number): number;
            /**
             * @en Interleave bits of 2 coordinates with 16 bits. Useful for fast quadtree codes.
             * @zh 将两个 16 位数字按位交错编码。有利于在快速四叉树中使用。
             */
            export function interleave2(x: number, y: number): number;
            /**
             * @en Extracts the nth interleaved component.
             * @zh 提取第 n 个交错分量。
             */
            export function deinterleave2(v: number, n: number): number;
            /**
             * @en Interleave bits of 3 coordinates, each with 10 bits.  Useful for fast octree codes.
             * @zh 将三个数字按位交错编码，每个数字占十位。有利于在八叉树中使用。
             */
            export function interleave3(x: number, y: number, z: number): number;
            /**
             * @en Extracts nth interleaved component of a 3-tuple.
             * @zh 提取三个数字中的第n个交错分量。
             */
            export function deinterleave3(v: number, n: number): number;
            /**
             * @en Compute the lexicographically next bit permutation
             * @zh 计算下一组字典序的比特排列
             */
            export function nextCombination(v: number): number;
            /**
             * Bit twiddling hacks for JavaScript.
             *
             * Author: Mikola Lysenko
             *
             * Ported from Stanford bit twiddling hack library:
             *    http://graphics.stanford.edu/~seander/bithacks.html
             */
            /**
             * @en
             * Number of bits in an integer
             * @zh
             * 整型类型的 bit 数
             */
            export const INT_BITS = 32;
            /**
             * @en
             * The maximal signed integer number
             * @zh
             * 最大有符号整型数
             */
            export const INT_MAX = 2147483647;
            /**
             * @en
             * The minimal signed integer number
             * @zh
             * 最小有符号整型数
             */
            export const INT_MIN: number;
        }
        /**
         * @en Representation of 2D vectors and points.
         * @zh 二维向量。
         */
        export class Vec2 extends ValueType {
            static ZERO: Readonly<Vec2>;
            static ONE: Readonly<Vec2>;
            static NEG_ONE: Readonly<Vec2>;
            static UNIT_X: Readonly<Vec2>;
            static UNIT_Y: Readonly<Vec2>;
            /**
             * @en Obtains a clone of the given vector object
             * @zh 获得指定向量的拷贝
             */
            static clone<Out extends IVec2Like>(a: Out): Vec2;
            /**
             * @en Copy the target vector and save the results to out vector object
             * @zh 复制目标向量
             */
            static copy<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Sets the out vector with the given x and y values
             * @zh 设置向量值
             */
            static set<Out extends IVec2Like>(out: Out, x: number, y: number): Out;
            /**
             * @en Element-wise vector addition and save the results to out vector object
             * @zh 逐元素向量加法
             */
            static add<Out extends IVec2Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Element-wise vector subtraction and save the results to out vector object
             * @zh 逐元素向量减法
             */
            static subtract<Out extends IVec2Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Element-wise vector multiplication and save the results to out vector object
             * @zh 逐元素向量乘法
             */
            static multiply<Out extends IVec2Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Element-wise vector division and save the results to out vector object
             * @zh 逐元素向量除法
             */
            static divide<Out extends IVec2Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Rounds up by elements of the vector and save the results to out vector object
             * @zh 逐元素向量向上取整
             */
            static ceil<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Element-wise rounds down of the current vector and save the results to the out vector
             * @zh 逐元素向量向下取整
             */
            static floor<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Calculates element-wise minimum values and save to the out vector
             * @zh 逐元素向量最小值
             */
            static min<Out extends IVec2Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Calculates element-wise maximum values and save to the out vector
             * @zh 逐元素向量最大值
             */
            static max<Out extends IVec2Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Calculates element-wise round results and save to the out vector
             * @zh 逐元素向量四舍五入取整
             */
            static round<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Vector scalar multiplication and save the results to out vector object
             * @zh 向量标量乘法
             */
            static multiplyScalar<Out extends IVec2Like>(out: Out, a: Out, b: number): Out;
            /**
             * @en Element-wise multiplication and addition with the equation: a + b * scale
             * @zh 逐元素向量乘加: A + B * scale
             */
            static scaleAndAdd<Out extends IVec2Like>(out: Out, a: Out, b: Out, scale: number): Out;
            /**
             * @en Calculates the euclidean distance of two vectors
             * @zh 求两向量的欧氏距离
             */
            static distance<Out extends IVec2Like>(a: Out, b: Out): number;
            /**
             * @en Calculates the squared euclidean distance of two vectors
             * @zh 求两向量的欧氏距离平方
             */
            static squaredDistance<Out extends IVec2Like>(a: Out, b: Out): number;
            /**
             * @en Calculates the length of the vector
             * @zh 求向量长度
             */
            static len<Out extends IVec2Like>(a: Out): number;
            /**
             * @en Calculates the squared length of the vector
             * @zh 求向量长度平方
             */
            static lengthSqr<Out extends IVec2Like>(a: Out): number;
            /**
             * @en Sets each element to its negative value
             * @zh 逐元素向量取负
             */
            static negate<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Sets each element to its inverse value, zero value will become Infinity
             * @zh 逐元素向量取倒数，接近 0 时返回 Infinity
             */
            static inverse<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Sets each element to its inverse value, zero value will remain zero
             * @zh 逐元素向量取倒数，接近 0 时返回 0
             */
            static inverseSafe<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Sets the normalized vector to the out vector, returns a zero vector if input is a zero vector.
             * @zh 归一化向量，输入零向量将会返回零向量。
             */
            static normalize<Out extends IVec2Like, Vec2Like extends IVec2Like>(out: Out, a: Vec2Like): Out;
            /**
             * @en Calculates the dot product of the vector
             * @zh 向量点积（数量积）
             */
            static dot<Out extends IVec2Like>(a: Out, b: Out): number;
            /**
             * @en Calculates the cross product of the vector
             * @zh 向量叉积（向量积），注意二维向量的叉积为与 Z 轴平行的三维向量
             * @override (a:Vec2, b:Vec2) => number
             * @override [deprecated] (out:Vec3, a:Vec2, b:Vec2) => Vec3
             */
            static cross(a: IVec2Like, b: IVec2Like): number;
            /**
             * @deprecated Consider use another overrides please.
             */
            static cross<Out extends IVec2Like>(out: Vec3, a: Out, b: Out): Vec3;
            /**
             * @en Calculates the linear interpolation between two vectors with a given ratio: A + t * (B - A)
             * @zh 逐元素向量线性插值： A + t * (B - A)
             */
            static lerp<Out extends IVec2Like>(out: Out, a: Out, b: Out, t: number): Out;
            /**
             * @en Generates a uniformly distributed random vector points from center to the surface of the unit sphere
             * @zh 生成一个在单位圆上均匀分布的随机向量
             * @param scale vector length
             */
            static random<Out extends IVec2Like>(out: Out, scale?: number): Out;
            /**
             * @en Vector and third order matrix multiplication, will complete the vector with a third value as one
             * @zh 向量与三维矩阵乘法，默认向量第三位为 1。
             */
            static transformMat3<Out extends IVec2Like, MatLike extends IMat3Like>(out: Out, a: Out, m: IMat3Like): Out;
            /**
             * @en Vector and third order matrix multiplication, will complete the vector with a third and a fourth element as one
             * @zh 向量与四维矩阵乘法，默认向量第三位为 0，第四位为 1。
             */
            static transformMat4<Out extends IVec2Like, MatLike extends IMat4Like>(out: Out, a: Out, m: IMat4Like): Out;
            /**
             * @en Gets the string representation of the given vector
             * @zh 返回向量的字符串表示
             */
            static str<Out extends IVec2Like>(a: Out): string;
            /**
             * @en Converts the given vector to an array
             * @zh 向量转数组
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, v: IVec2Like, ofs?: number): Out;
            /**
             * @en Converts the given array to a vector
             * @zh 数组转向量
             * @param ofs Array Start Offset
             */
            static fromArray<Out extends IVec2Like>(out: Out, arr: __private.__types_globals__IWritableArrayLike<number>, ofs?: number): Out;
            /**
             * @en Check the equality of the two given vectors
             * @zh 向量等价判断
             */
            static strictEquals<Out extends IVec2Like>(a: Out, b: Out): boolean;
            /**
             * @en Check whether the two given vectors are approximately equivalent
             * @zh 排除浮点数误差的向量近似等价判断
             */
            static equals<Out extends IVec2Like>(a: Out, b: Out, epsilon?: number): boolean;
            /**
             * @en Calculates the radian angle between two vectors, returns zero if either vector is a zero vector.
             * @zh 求两向量夹角弧度，任意一个向量是零向量则返回零。
             */
            static angle<Out extends IVec2Like>(a: Out, b: Out): number;
            /**
             * @en x component.
             * @zh x 分量。
             */
            x: number;
            /**
             * @en y component.
             * @zh y 分量。
             */
            y: number;
            constructor(other: Vec2);
            constructor(x?: number, y?: number);
            /**
             * @en clone a Vec2 value
             * @zh 克隆当前向量。
             */
            clone(): Vec2;
            /**
             * @en Set the current vector value with the given vector.
             * @zh 设置当前向量使其与指定向量相等。
             * @param other Specified vector
             * @return `this`
             */
            set(other: Vec2): Vec2;
            /**
             * @en Set the value of each component of the current vector.
             * @zh 设置当前向量的具体分量值。
             * @param x x value
             * @param y y value
             * @return `this`
             */
            set(x?: number, y?: number): Vec2;
            /**
             * @en Check whether the vector approximately equals another one.
             * @zh 判断当前向量是否在误差范围内与指定向量相等。
             * @param other Specified vector
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @return Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            equals(other: Vec2, epsilon?: number): boolean;
            /**
             * @en Check whether the vector approximately equals another one.
             * @zh 判断当前向量是否在误差范围内与指定分量的向量相等。
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @return Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            equals2f(x: number, y: number, epsilon?: number): boolean;
            /**
             * @en Check whether the current vector strictly equals another Vec2.
             * @zh 判断当前向量是否与指定向量相等。
             * @param other specified vector
             * @return Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            strictEquals(other: Vec2): boolean;
            /**
             * @en Check whether the current vector strictly equals another Vec2.
             * @zh 判断当前向量是否与指定分量的向量相等。
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @return Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            strictEquals2f(x: number, y: number): boolean;
            /**
             * @en Transform to string with vector information.
             * @zh 返回当前向量的字符串表示。
             * @returns The string with vector information
             */
            toString(): string;
            /**
             * @en Calculate linear interpolation result between this vector and another one with given ratio.
             * @zh 根据指定的插值比率，从当前向量到目标向量之间做插值。
             * @param to Target vector
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            lerp(to: Vec2, ratio: number): Vec2;
            /**
             * @en Clamp the vector between minInclusive and maxInclusive.
             * @zh 设置当前向量的值，使其各个分量都处于指定的范围内。
             * @param minInclusive Minimum value allowed
             * @param maxInclusive Maximum value allowed
             * @return `this`
             */
            clampf(minInclusive: Vec2, maxInclusive: Vec2): Vec2;
            /**
             * @en Adds the current vector with another one and return this
             * @zh 向量加法。将当前向量与指定向量的相加
             * @param other specified vector
             */
            add(other: Vec2): Vec2;
            /**
             * @en Adds the current vector with another one and return this
             * @zh 向量加法。将当前向量与指定分量的向量相加
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             */
            add2f(x: number, y: number): Vec2;
            /**
             * @en Subtracts one vector from this, and returns this.
             * @zh 向量减法。将当前向量减去指定向量
             * @param other specified vector
             */
            subtract(other: Vec2): Vec2;
            /**
             * @en Subtracts one vector from this, and returns this.
             * @zh 向量减法。将当前向量减去指定分量的向量
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             */
            subtract2f(x: number, y: number): Vec2;
            /**
             * @en Multiplies the current vector with a number, and returns this.
             * @zh 向量数乘。将当前向量数乘指定标量
             * @param scalar scalar number
             */
            multiplyScalar(scalar: number): Vec2;
            /**
             * @en Multiplies the current vector with another one and return this
             * @zh 向量乘法。将当前向量乘以与指定向量的结果赋值给当前向量。
             * @param other specified vector
             */
            multiply(other: Vec2): Vec2;
            /**
             * @en Multiplies the current vector with another one and return this
             * @zh 向量乘法。将当前向量与指定分量的向量相乘的结果赋值给当前向量。
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             */
            multiply2f(x: number, y: number): Vec2;
            /**
             * @en Element-wisely divides this vector with another one, and return this.
             * @zh 向量逐元素相除。将当前向量与指定分量的向量相除的结果赋值给当前向量。
             * @param other specified vector
             */
            divide(other: Vec2): Vec2;
            /**
             * @en Element-wisely divides this vector with another one, and return this.
             * @zh 向量逐元素相除。将当前向量与指定分量的向量相除的结果赋值给当前向量。
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             */
            divide2f(x: number, y: number): Vec2;
            /**
             * @en Sets each component of this vector with its negative value
             * @zh 将当前向量的各个分量取反
             */
            negative(): Vec2;
            /**
             * @en Calculates the dot product with another vector
             * @zh 向量点乘。
             * @param other specified vector
             * @return The result of calculates the dot product with another vector
             */
            dot(other: Vec2): number;
            /**
             * @en Calculates the cross product with another vector.
             * @zh 向量叉乘。
             * @param other specified vector
             * @return `out`
             */
            cross(other: Vec2): number;
            /**
             * @en Returns the length of this vector.
             * @zh 计算向量的长度（模）。
             * @return Length of vector
             */
            length(): number;
            /**
             * @en Returns the squared length of this vector.
             * @zh 计算向量长度（模）的平方。
             * @return the squared length of this vector
             */
            lengthSqr(): number;
            /**
             * @en Normalize the current vector.
             * @zh 将当前向量归一化。
             */
            normalize(): Vec2;
            /**
             * @en Calculates radian angle between two vectors, returns zero if either vector is a zero vector.
             * @zh 获取当前向量和指定向量之间的弧度，任意一个向量是零向量则返回零。
             * @param other specified vector.
             * @return The angle between the current vector and the specified vector.
             */
            angle(other: Vec2): number;
            /**
             * @en Get angle in radian between this and vector with direction.
             * @zh 获取当前向量和指定向量之间的有符号弧度。<br/>
             * 有符号弧度的取值范围为 (-PI, PI]，当前向量可以通过逆时针旋转有符号角度与指定向量同向。<br/>
             * @param other specified vector
             * @return The signed angle between the current vector and the specified vector (in radians);
             * if there is a zero vector in the current vector and the specified vector, 0 is returned.
             */
            signAngle(other: Vec2): number;
            /**
             * @en Rotates the current vector by an angle in radian value. Counterclockwise is the positive direction.
             * @zh 将当前向量进行旋转，逆时针为正方向。
             * @param radians radians of rotation.
             */
            rotate(radians: number): Vec2;
            /**
             * @en Projects the current vector on another one
             * @zh 计算当前向量在指定向量上的投影向量。
             * @param other specified vector
             */
            project(other: Vec2): Vec2;
            /**
             * @en Transforms the vec2 with a mat4. 3rd vector component is implicitly '0', 4th vector component is implicitly '1'
             * @zh 将当前向量视为 z 分量为 0、w 分量为 1 的四维向量，<br/>
             * 应用四维矩阵变换到当前矩阵<br/>
             * @param matrix matrix to transform with
             */
            transformMat4(matrix: Mat4): Vec2;
            /**
             * @en Converts the current Vec2 object to a Vec3 object by adding a z-component of 0.
             * @zh 将当前的Vec2对象转换为一个z分量为0的Vec3对象。
             * @returns Vec3 @en A new Vec3 object created from the current Vec2 object with z-component set to 0.
             * @zh 从当前的Vec2对象创建一个新的Vec3对象，其中z分量设置为0。
             */
            toVec3(): Vec3;
        }
        export function v2(other: Vec2): Vec2;
        export function v2(x?: number, y?: number): Vec2;
        /**
         * @en Representation of 3D vectors and points.
         * @zh 三维向量。
         */
        export class Vec3 extends ValueType {
            static UNIT_X: Readonly<Vec3>;
            static UNIT_Y: Readonly<Vec3>;
            static UNIT_Z: Readonly<Vec3>;
            static RIGHT: Readonly<Vec3>;
            static UP: Readonly<Vec3>;
            static FORWARD: Readonly<Vec3>;
            static ZERO: Readonly<Vec3>;
            static ONE: Readonly<Vec3>;
            static NEG_ONE: Readonly<Vec3>;
            /**
             * @en return a Vec3 object with x = 0, y = 0, z = 0.
             * @zh 将目标赋值为零向量
             */
            static zero<Out extends IVec3Like>(out: Out): Out;
            /**
             * @en Obtains a clone of the given vector object
             * @zh 获得指定向量的拷贝
             */
            static clone<Out extends IVec3Like>(a: Out): Vec3;
            /**
             * @en Copy the target vector and save the results to out vector object
             * @zh 复制目标向量
             */
            static copy<Out extends IVec3Like, Vec3Like extends IVec3Like>(out: Out, a: Vec3Like): Out;
            /**
             * @en Sets the out vector with the given x, y and z values
             * @zh 设置向量值
             */
            static set<Out extends IVec3Like>(out: Out, x: number, y: number, z: number): Out;
            /**
             * @en Element-wise vector addition and save the results to out vector object
             * @zh 逐元素向量加法
             */
            static add<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Element-wise vector subtraction and save the results to out vector object
             * @zh 逐元素向量减法
             */
            static subtract<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Element-wise vector multiplication and save the results to out vector object
             * @zh 逐元素向量乘法 (分量积)
             */
            static multiply<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Element-wise vector division and save the results to out vector object
             * @zh 逐元素向量除法
             */
            static divide<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Rounds up by elements of the vector and save the results to out vector object
             * @zh 逐元素向量向上取整
             */
            static ceil<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Element-wise rounds down of the current vector and save the results to the out vector
             * @zh 逐元素向量向下取整
             */
            static floor<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Calculates element-wise minimum values and save to the out vector
             * @zh 逐元素向量最小值
             */
            static min<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Calculates element-wise maximum values and save to the out vector
             * @zh 逐元素向量最大值
             */
            static max<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Calculates element-wise round results and save to the out vector
             * @zh 逐元素向量四舍五入取整
             */
            static round<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Vector scalar multiplication and save the results to out vector object
             * @zh 向量标量乘法
             */
            static multiplyScalar<Out extends IVec3Like, Vec3Like extends IVec3Like>(out: Out, a: Vec3Like, b: number): Out;
            /**
             * @en Element-wise multiplication and addition with the equation: a + b * scale
             * @zh 逐元素向量乘加: A + B * scale
             */
            static scaleAndAdd<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like, scale: number): Out;
            /**
             * @en Calculates the euclidean distance of two vectors
             * @zh 求两向量的欧氏距离
             */
            static distance(a: IVec3Like, b: IVec3Like): number;
            /**
             * @en Calculates the squared euclidean distance of two vectors
             * @zh 求两向量的欧氏距离平方
             */
            static squaredDistance(a: IVec3Like, b: IVec3Like): number;
            /**
             * @en Calculates the length of the vector
             * @zh 求向量长度
             */
            static len(a: IVec3Like): number;
            /**
             * @en Calculates the squared length of the vector
             * @zh 求向量长度平方
             */
            static lengthSqr(a: IVec3Like): number;
            /**
             * @en Sets each element to its negative value
             * @zh 逐元素向量取负
             */
            static negate<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Sets each element to its inverse value, zero value will become Infinity
             * @zh 逐元素向量取倒数，接近 0 时返回 Infinity
             */
            static invert<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Sets each element to its inverse value, zero value will remain zero
             * @zh 逐元素向量取倒数，接近 0 时返回 0
             */
            static invertSafe<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Sets the normalized vector to the out vector, returns a zero vector if input is a zero vector.
             * @zh 归一化向量，输入零向量将会返回零向量。
             */
            static normalize<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Calculates the dot product of the vector
             * @zh 向量点积（数量积）
             */
            static dot<Out extends IVec3Like>(a: Out, b: IVec3Like): number;
            /**
             * @en Calculates the cross product of the vector
             * @zh 向量叉积（向量积）
             */
            static cross<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Calculates the linear interpolation between two vectors with a given ratio: A + t * (B - A)
             * @zh 逐元素向量线性插值： A + t * (B - A)
             */
            static lerp<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like, t: number): Out;
            /**
             * @zh 球面线性插值。多用于插值两个方向向量。
             * @en Spherical linear interpolation. Commonly used in interpolation between directional vectors.
             * @param out @zh 输出向量。 @en Output vector.
             * @param from @zh 起点向量。 @en Start vector.
             * @param to @zh 终点向量。 @en Destination vector.
             * @param t @zh 插值参数。@en Interpolation parameter.
             * @returns `out`
             * @description
             * @zh
             * - 如果 `from`、`to` 中任何一个接近零向量，则结果就是 `from` 到 `to` 线性插值的结果；
             *
             * - 否则，如果 `from`、`to` 方向刚好接近相反，
             * 则结果向量是满足以下条件的一个向量：结果向量和两个输入向量的夹角之比是 `t`，其长度是 `from` 到 `to` 的长度线性插值的结果；
             *
             * - 否则，结果是从标准化后的 `from` 到 标准化后的 `to`
             * 进行球面线性插值的结果乘以 `from` 到 `to` 的长度线性插值后的长度。
             * @en
             * - If either `from` or `to` is close to zero vector,
             * the result would be the (non-spherical) linear interpolation result from `from` to `to`.
             *
             * - Otherwise, if `from` and `to` have almost opposite directions,
             * the result would be such a vector so that:
             * The angle ratio between result vector and input vectors is `t`,
             * the length of result vector is the linear interpolation of lengths from `from` to `to`.
             *
             * - Otherwise, the result would be the spherical linear interpolation result
             * from normalized `from` to normalized `to`,
             * then scaled by linear interpolation of lengths from `from` to `to`.
             */
            static slerp: <Out extends IVec3Like>(out: Out, from: Readonly<IVec3Like>, to: Readonly<IVec3Like>, t: number) => Out;
            /**
             * @en Generates a uniformly distributed random vector points from center to the surface of the unit sphere
             * @zh 生成一个在单位球体上均匀分布的随机向量
             * @param scale vector length
             */
            static random<Out extends IVec3Like>(out: Out, scale?: number): Out;
            /**
             * @en Vector and fourth order matrix multiplication, will complete the vector with a fourth value as one
             * @zh 向量与四维矩阵乘法，默认向量第四位为 1。
             */
            static transformMat4<Out extends IVec3Like>(out: Out, a: IVec3Like, m: IMat4Like): Out;
            /**
             * @en Vector and fourth order matrix multiplication, will complete the vector with a fourth element as one
             * @zh 向量与四维矩阵乘法，默认向量第四位为 0。
             */
            static transformMat4Normal<Out extends IVec3Like>(out: Out, a: IVec3Like, m: IMat4Like): Out;
            /**
             * @en Vector and third order matrix multiplication
             * @zh 向量与三维矩阵乘法
             */
            static transformMat3<Out extends IVec3Like>(out: Out, a: IVec3Like, m: IMat3Like): Out;
            /**
             * @en Affine transformation vector
             * @zh 向量仿射变换
             */
            static transformAffine<Out extends IVec3Like>(out: Out, v: IVec3Like, m: IMat4Like): Out;
            /**
             * @en Vector quaternion multiplication: q*a*q^{-1}.
             * @zh 向量四元数乘法：q*a*q^{-1}。
             */
            static transformQuat<Out extends IVec3Like>(out: Out, a: IVec3Like, q: IQuatLike): Out;
            /**
             * @en Transforms the current vector with given scale, rotation and translation in order
             * @zh 以缩放 -> 旋转 -> 平移顺序变换向量
             */
            static transformRTS<Out extends IVec3Like>(out: Out, a: IVec3Like, r: IQuatLike, t: IVec3Like, s: IVec3Like): Out;
            /**
             * @en Transforms the current vector with given scale, rotation and translation in reverse order
             * @zh 以平移 -> 旋转 -> 缩放顺序逆变换向量
             */
            static transformInverseRTS<Out extends IVec3Like>(out: Out, a: IVec3Like, r: IQuatLike, t: IVec3Like, s: IVec3Like): Out;
            /**
             * @en Rotates the vector with specified angle around X axis
             * @zh 绕 X 轴旋转向量指定弧度
             * @param v rotation vector
             * @param o center of rotation
             * @param a radiance of rotation
             */
            static rotateX<Out extends IVec3Like>(out: Out, v: IVec3Like, o: IVec3Like, a: number): Out;
            /**
             * @en Rotates the vector with specified angle around Y axis
             * @zh 绕 Y 轴旋转向量指定弧度
             * @param v rotation vector
             * @param o center of rotation
             * @param a radiance of rotation
             */
            static rotateY<Out extends IVec3Like>(out: Out, v: IVec3Like, o: IVec3Like, a: number): Out;
            /**
             * @en Rotates the vector with specified angle around Z axis
             * @zh 绕 Z 轴旋转向量指定弧度
             * @param v rotation vector
             * @param o center of rotation
             * @param a radiance of rotation
             */
            static rotateZ<Out extends IVec3Like>(out: Out, v: IVec3Like, o: IVec3Like, a: number): Out;
            /**
             * @en Rotates the vector with specified angle around any n axis
             * @zh 绕任意 n 轴旋转向量指定弧度
             * @param v rotation vector
             * @param o center of rotation
             * @param n axis of rotation
             * @param a radiance of rotation
             */
            static rotateN<Out extends IVec3Like>(out: Out, v: IVec3Like, o: IVec3Like, n: IVec3Like, a: number): Out;
            /**
             * @en Converts the given vector to an array
             * @zh 向量转数组
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, v: IVec3Like, ofs?: number): Out;
            /**
             * @en Converts the given array to a vector
             * @zh 数组转向量
             * @param ofs Array Start Offset
             */
            static fromArray<Out extends IVec3Like>(out: Out, arr: __private.__types_globals__IWritableArrayLike<number>, ofs?: number): Out;
            /**
             * @en Check the equality of the two given vectors
             * @zh 向量等价判断
             */
            static strictEquals(a: IVec3Like, b: IVec3Like): boolean;
            /**
             * @en Check whether the two given vectors are approximately equivalent
             * @zh 排除浮点数误差的向量近似等价判断
             */
            static equals(a: IVec3Like, b: IVec3Like, epsilon?: number): boolean;
            /**
             * @en Calculates the radian angle between two vectors
             * @zh 求两向量夹角弧度
             */
            static angle(a: IVec3Like, b: IVec3Like): number;
            /**
             * @zh 计算 `a`、`b` 两向量之间的有符号夹角。
             *
             * 不妨假设 `a`、`b` 是钟表上的两根指针，其中 `a` 指向 12 点整，`normal` 是任何从钟表正面指出的向量。
             * 当 `b` **逆时针** 从 12 点走到 6 点的过程中，它们的角度变化范围为 (0°, 180°)；
             * 当 `b` **顺时针** 从 12 点走到 6 点的过程中，它们的角度变化范围为 (0°, -180°)。
             *
             * 反之，如果 `normal` 是任何从钟表反面指出的向量，两种范围将对调。
             *
             * @en Calculates the signed angle between the two vectors `a`, `b`.
             *
             * Suppose that `a` and `b` are two hands on a clock, where pointing at 12 o'clock,
             * and `normal` is arbitrary vector pointing out from the dial side of the clock.
             * As `b` goes counterclockwise from 12 o'clock to 6 o'clock, their angle varies in the range (0°, 180°);
             * As `b` goes clockwise from 12 o'clock to 6 o'clock, their angle varies in the range (0°, -180°).
             *
             * Instead, if `normal` is arbitrary vector pointing out from the opposite side of the clock,
             * the two ranges would swap.
             *
             * @param a @zh 向量 `a`。 @en The vector `a`.
             * @param b @zh 向量 `b`。 @en The vector `b`.
             * @param normal @zh 参考向量。 @en The reference vector.
             * @returns @zh 向量 `a` 和 `b` 之间的有符号夹角。 @en The signed angle between `a`, `b`.
             */
            static signedAngle: (a: Readonly<IVec3Like>, b: Readonly<IVec3Like>, normal: Readonly<IVec3Like>) => number;
            /**
             * @en Calculates the projection vector on the specified plane
             * @zh 计算向量在指定平面上的投影
             * @param a projection vector
             * @param n the normal line of specified plane
             */
            static projectOnPlane<Out extends IVec3Like>(out: Out, a: IVec3Like, n: IVec3Like): Out;
            /**
             * @en Calculates the projection on the specified vector
             * @zh 计算向量在指定向量上的投影
             * @param a projection vector
             * @param b target vector
             */
            static project<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Calculates a new position from current to target no more than `maxStep` distance.
             * @zh 计算一个新位置从当前位置移动不超过 `maxStep` 距离到目标位置。
             * @param current current position
             * @param target target position
             * @param maxStep maximum moving distance
             */
            static moveTowards<Out extends IVec3Like>(out: Out, current: IVec3Like, target: IVec3Like, maxStep: number): Out;
            /**
             * @zh 生成指定向量的一个正交单位向量。如果指定的向量 **精确地** 是零向量，则返回 **精确的** 零向量。
             * @en Generates an unit vector orthogonal to specified vector.
             * If the specified vector is **strictly** zero vector, the result is **strict** zero vector.
             * @param out @zh 生成的向量。@en The generated vector.
             * @param n @zh 输入向量。该向量 **不必** 是标准化的。 @en The input vector. **Need not** to be normalized.
             * @returns `out`
             */
            static generateOrthogonal<Out extends IVec3Like>(out: Out, n: Readonly<IVec3Like>): Out;
            /**
             * @en x component.
             * @zh x 分量。
             */
            x: number;
            /**
             * @en y component.
             * @zh y 分量。
             */
            y: number;
            /**
             * @en z component.
             * @zh z 分量。
             */
            z: number;
            constructor(v: Vec3);
            constructor(x?: number, y?: number, z?: number);
            /**
             * @en clone a Vec3 value
             * @zh 克隆当前向量。
             */
            clone(): Vec3;
            /**
             * @en Set the current vector value with the given vector.
             * @zh 设置当前向量使其与指定向量相等。
             * @param other Specified vector
             * @returns `this`
             */
            set(other: Vec3): Vec3;
            /**
             * @en Set the value of each component of the current vector.
             * @zh 设置当前向量的具体分量值。
             * @param x x value
             * @param y y value
             * @param z z value
             * @returns `this`
             */
            set(x?: number, y?: number, z?: number): Vec3;
            /**
             * @en Check whether the vector approximately equals another one.
             * @zh 判断当前向量是否在误差范围内与指定向量相等。
             * @param other Specified vector
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            equals(other: Vec3, epsilon?: number): boolean;
            /**
             * @en Check whether the vector approximately equals another one.
             * @zh 判断当前向量是否在误差范围内与指定分量的向量相等。
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            equals3f(x: number, y: number, z: number, epsilon?: number): boolean;
            /**
             * @en Check whether the current vector strictly equals another Vec3.
             * @zh 判断当前向量是否与指定向量相等。
             * @param other specified vector
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            strictEquals(other: Vec3): boolean;
            /**
             * @en Check whether the current vector strictly equals another Vec3.
             * @zh 判断当前向量是否与指定分量的向量相等。
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            strictEquals3f(x: number, y: number, z: number): boolean;
            /**
             * @en Transform to string with vector information.
             * @zh 返回当前向量的字符串表示。
             * @returns The string with vector information
             */
            toString(): string;
            /**
             * @en Calculate linear interpolation result between this vector and another one with given ratio.
             * @zh 根据指定的插值比率，从当前向量到目标向量之间做插值。
             * @param to Target vector
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            lerp(to: Vec3, ratio: number): Vec3;
            /**
             * @en Adds the current vector with another one and return this
             * @zh 向量加法。将当前向量与指定向量的相加
             * @param other specified vector
             */
            add(other: Vec3): Vec3;
            /**
             * @en Adds the current vector with another one and return this
             * @zh 向量加法。将当前向量与指定分量的向量相加
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             */
            add3f(x: number, y: number, z: number): Vec3;
            /**
             * @en Subtracts one vector from this, and returns this.
             * @zh 向量减法。将当前向量减去指定向量的结果。
             * @param other specified vector
             */
            subtract(other: Vec3): Vec3;
            /**
             * @en Subtracts one vector from this, and returns this.
             * @zh 向量减法。将当前向量减去指定分量的向量
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             */
            subtract3f(x: number, y: number, z: number): Vec3;
            /**
             * @en Multiplies the current vector with a number, and returns this.
             * @zh 向量数乘。将当前向量数乘指定标量
             * @param scalar scalar number
             */
            multiplyScalar(scalar: number): Vec3;
            /**
             * @en Multiplies the current vector with another one and return this
             * @zh 向量乘法。将当前向量乘以与指定向量的结果赋值给当前向量。
             * @param other specified vector
             */
            multiply(other: Vec3): Vec3;
            /**
             * @en Multiplies the current vector with another one and return this
             * @zh 向量乘法。将当前向量与指定分量的向量相乘的结果赋值给当前向量。
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             */
            multiply3f(x: number, y: number, z: number): Vec3;
            /**
             * @en Element-wisely divides this vector with another one, and return this.
             * @zh 向量逐元素相除。将当前向量与指定分量的向量相除的结果赋值给当前向量。
             * @param other specified vector
             */
            divide(other: Vec3): Vec3;
            /**
             * @en Element-wisely divides this vector with another one, and return this.
             * @zh 向量逐元素相除。将当前向量与指定分量的向量相除的结果赋值给当前向量。
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             */
            divide3f(x: number, y: number, z: number): Vec3;
            /**
             * @en Sets each component of this vector with its negative value
             * @zh 将当前向量的各个分量取反
             */
            negative(): Vec3;
            /**
             * @en Clamp the vector between minInclusive and maxInclusive.
             * @zh 设置当前向量的值，使其各个分量都处于指定的范围内。
             * @param minInclusive Minimum value allowed
             * @param maxInclusive Maximum value allowed
             * @returns `this`
             */
            clampf(minInclusive: Vec3, maxInclusive: Vec3): Vec3;
            /**
             * @en Calculates the dot product with another vector
             * @zh 向量点乘。
             * @param other specified vector
             * @returns The result of calculates the dot product with another vector
             */
            dot(other: Vec3): number;
            /**
             * @en Calculates the cross product with another vector.
             * @zh 向量叉乘。将当前向量左叉乘指定向量
             * @param other specified vector
             */
            cross(other: Vec3): Vec3;
            /**
             * @en Returns the length of this vector.
             * @zh 计算向量的长度（模）。
             * @returns Length of vector
             */
            length(): number;
            /**
             * @en Returns the squared length of this vector.
             * @zh 计算向量长度（模）的平方。
             * @returns the squared length of this vector
             */
            lengthSqr(): number;
            /**
             * @en Normalize the current vector.
             * @zh 将当前向量归一化
             */
            normalize(): Vec3;
            /**
             * @en Transforms the vec3 with a mat4. 4th vector component is implicitly '1'
             * @zh 将当前向量视为 w 分量为 1 的四维向量，应用四维矩阵变换到当前矩阵
             * @param matrix matrix to transform with
             */
            transformMat4(matrix: Mat4): Vec3;
            /**
             * @en Converts the current Vec3 object to a Vec2 object by adding a z-component of 0.
             * @zh 将当前的Vec3对象转换为一个z分量为0的Vec3对象。
             * @returns Vec2 @en A new Vec2 object created from the current Vec3 object with z-component ignored.
             * @zh 从当前的Vec3对象创建一个新的Vec2对象，丢弃z分量。
             */
            toVec2(): Vec2;
        }
        export function v3(other: Vec3): Vec3;
        export function v3(x?: number, y?: number, z?: number): Vec3;
        /**
         * @en Representation of four-dimensional vectors.
         * @zh 四维向量。
         */
        export class Vec4 extends ValueType {
            static ZERO: Readonly<Vec4>;
            static ONE: Readonly<Vec4>;
            static NEG_ONE: Readonly<Vec4>;
            static UNIT_X: Readonly<Vec4>;
            static UNIT_Y: Readonly<Vec4>;
            static UNIT_Z: Readonly<Vec4>;
            static UNIT_W: Readonly<Vec4>;
            /**
             * @en Obtains a clone of the given vector object
             * @zh 获得指定向量的拷贝
             */
            static clone<Out extends IVec4Like>(a: Out): Vec4;
            /**
             * @en Copy the target vector and save the results to out vector object
             * @zh 复制目标向量
             */
            static copy<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Sets the out vector with the given x, y, z and w values
             * @zh 设置向量值
             */
            static set<Out extends IVec4Like>(out: Out, x: number, y: number, z: number, w: number): Out;
            /**
             * @en set value from color
             * @zh 从颜色值设置向量
             * @param out
             * @param color
             */
            static fromColor<Out extends IVec4Like>(out: Out, color: IColorLike): Out;
            /**
             * @en The angle between two vectors
             * @zh 两个向量之间的夹角
             */
            static angle<Out extends IVec4Like>(a: Out, b: Out): number;
            /**
             * @en Element-wise vector addition and save the results to out vector object
             * @zh 逐元素向量加法
             */
            static add<Out extends IVec4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Element-wise vector subtraction and save the results to out vector object
             * @zh 逐元素向量减法
             */
            static subtract<Out extends IVec4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Element-wise vector multiplication and save the results to out vector object
             * @zh 逐元素向量乘法
             */
            static multiply<Out extends IVec4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Element-wise vector division and save the results to out vector object
             * @zh 逐元素向量除法
             */
            static divide<Out extends IVec4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Rounds up by elements of the vector and save the results to out vector object
             * @zh 逐元素向量向上取整
             */
            static ceil<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Element-wise rounds down of the current vector and save the results to the out vector
             * @zh 逐元素向量向下取整
             */
            static floor<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Calculates the minimum values by elements of the vector and save the results to the out vector
             * @zh 逐元素向量最小值
             */
            static min<Out extends IVec4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Calculates the maximum values by elements of the vector and save the results to the out vector
             * @zh 逐元素向量最大值
             */
            static max<Out extends IVec4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Calculates element-wise round results and save to the out vector
             * @zh 逐元素向量四舍五入取整
             */
            static round<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Vector scalar multiplication and save the results to out vector object
             * @zh 向量标量乘法
             */
            static multiplyScalar<Out extends IVec4Like>(out: Out, a: Out, b: number): Out;
            /**
             * @en Element-wise multiplication and addition with the equation: a + b * scale
             * @zh 逐元素向量乘加: A + B * scale
             */
            static scaleAndAdd<Out extends IVec4Like>(out: Out, a: Out, b: Out, scale: number): Out;
            /**
             * @en Calculates the euclidean distance of two vectors
             * @zh 求两向量的欧氏距离
             */
            static distance<Out extends IVec4Like>(a: Out, b: Out): number;
            /**
             * @en Calculates the squared euclidean distance of two vectors
             * @zh 求两向量的欧氏距离平方
             */
            static squaredDistance<Out extends IVec4Like>(a: Out, b: Out): number;
            /**
             * @en Calculates the length of the vector
             * @zh 求向量长度
             */
            static len<Out extends IVec4Like>(a: Out): number;
            /**
             * @en Calculates the squared length of the vector
             * @zh 求向量长度平方
             */
            static lengthSqr<Out extends IVec4Like>(a: Out): number;
            /**
             * @en Sets each element to its negative value
             * @zh 逐元素向量取负
             */
            static negate<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Sets each element to its inverse value, zero value will become Infinity
             * @zh 逐元素向量取倒数，接近 0 时返回 Infinity
             */
            static inverse<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Sets each element to its inverse value, zero value will remain zero
             * @zh 逐元素向量取倒数，接近 0 时返回 0
             */
            static inverseSafe<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Sets the normalized vector to the out vector, returns a zero vector if input is a zero vector.
             * @zh 归一化向量，输入零向量将会返回零向量。
             */
            static normalize<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Calculates the dot product of the vector
             * @zh 向量点积（数量积）
             */
            static dot<Out extends IVec4Like>(a: Out, b: Out): number;
            /**
             * @en Calculates the linear interpolation between two vectors with a given ratio
             * @zh 逐元素向量线性插值： A + t * (B - A)
             */
            static lerp<Out extends IVec4Like>(out: Out, a: Out, b: Out, t: number): Out;
            /**
             * @en Scales all ell elements of this vector by the specified scalar value
             * @zh 逐元素向量缩放
             */
            static scale<Out extends IVec4Like>(out: Out, a: Out, b: number): Out;
            /**
             * @en Generates a uniformly distributed random vector points from center to the surface of the unit sphere
             * @zh 生成一个在单位球体上均匀分布的随机向量
             * @param scale vector length
             */
            static random<Out extends IVec4Like>(out: Out, scale?: number): Out;
            /**
             * @en Vector and fourth order matrix multiplication
             * @zh 向量与四维矩阵乘法
             */
            static transformMat4<Out extends IVec4Like, MatLike extends IMat4Like>(out: Out, a: Out, m: MatLike): Out;
            /**
             * @en Transform the vector with the given affine transformation
             * @zh 向量仿射变换
             */
            static transformAffine<Out extends IVec4Like, VecLike extends IVec4Like, MatLike extends IMat4Like>(out: Out, v: VecLike, m: MatLike): Out;
            /**
             * @en Vector quaternion multiplication
             * @zh 向量四元数乘法
             */
            static transformQuat<Out extends IVec4Like, QuatLike extends IQuatLike>(out: Out, a: Out, q: QuatLike): Out;
            /**
             * @en Converts the given vector to an array
             * @zh 向量转数组
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, v: IVec4Like, ofs?: number): Out;
            /**
             * @en Converts the given array to a vector
             * @zh 数组转向量
             * @param ofs Array Start Offset
             */
            static fromArray<Out extends IVec4Like>(out: Out, arr: __private.__types_globals__IWritableArrayLike<number>, ofs?: number): Out;
            /**
             * @en Check the equality of the two given vectors
             * @zh 向量等价判断
             */
            static strictEquals<Out extends IVec4Like>(a: Out, b: Out): boolean;
            /**
             * @en Check whether the two given vectors are approximately equivalent
             * @zh 排除浮点数误差的向量近似等价判断
             */
            static equals<Out extends IVec4Like>(a: Out, b: Out, epsilon?: number): boolean;
            /**
             * @en x component.
             * @zh x 分量。
             */
            x: number;
            /**
             * @en y component.
             * @zh y 分量。
             */
            y: number;
            /**
             * @en z component.
             * @zh z 分量。
             */
            z: number;
            /**
             * @en w component.
             * @zh w 分量。
             */
            w: number;
            constructor(other: Vec4);
            constructor(x?: number, y?: number, z?: number, w?: number);
            /**
             * @en clone the current Vec4 value.
             * @zh 克隆当前向量。
             */
            clone(): Vec4;
            /**
             * @en Set the current vector value with the given vector.
             * @zh 设置当前向量使其与指定向量相等。
             * @param other Specified vector
             * @returns `this`
             */
            set(other: Vec4): Vec4;
            /**
             * @en Set the value of each component of the current vector.
             * @zh 设置当前向量的具体分量值。
             * @param x x value
             * @param y y value
             * @param z z value
             * @param w w value
             * @returns `this`
             */
            set(x?: number, y?: number, z?: number, w?: number): Vec4;
            /**
             * @en Check whether the vector approximately equals another one.
             * @zh 判断当前向量是否在误差范围内与指定向量相等。
             * @param other Specified vector
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            equals(other: Vec4, epsilon?: number): boolean;
            /**
             * @en Check whether the vector approximately equals another one.
             * @zh 判断当前向量是否在误差范围内与指定分量的向量相等。
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param w The w value of specified vector
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            equals4f(x: number, y: number, z: number, w: number, epsilon?: number): boolean;
            /**
             * @en Check whether the current vector strictly equals another Vec4.
             * @zh 判断当前向量是否与指定向量相等。
             * @param other specified vector
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            strictEquals(other: Vec4): boolean;
            /**
             * @en Check whether the current vector strictly equals another Vec4.
             * @zh 判断当前向量是否与指定分量的向量相等。
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param w The w value of specified vector
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            strictEquals4f(x: number, y: number, z: number, w: number): boolean;
            /**
             * @en Calculate linear interpolation result between this vector and another one with given ratio.
             * @zh 根据指定的插值比率，从当前向量到目标向量之间做插值。
             * @param to Target vector
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            lerp(to: Vec4, ratio: number): Vec4;
            /**
             * @en Return the information of the vector in string
             * @zh 返回当前向量的字符串表示。
             * @returns The string with vector information
             */
            toString(): string;
            /**
             * @en Clamp the vector between minInclusive and maxInclusive.
             * @zh 设置当前向量的值，使其各个分量都处于指定的范围内。
             * @param minInclusive Minimum value allowed
             * @param maxInclusive Maximum value allowed
             * @returns `this`
             */
            clampf(minInclusive: Vec4, maxInclusive: Vec4): Vec4;
            /**
             * @en Adds the current vector with another one and return this
             * @zh 向量加法。将当前向量与指定向量的相加
             * @param other specified vector
             */
            add(other: Vec4): Vec4;
            /**
             * @en Adds the current vector with another one and return this
             * @zh 向量加法。将当前向量与指定分量的向量相加
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param w The w value of specified vector
             */
            add4f(x: number, y: number, z: number, w: number): Vec4;
            /**
             * @en Subtracts one vector from this, and returns this.
             * @zh 向量减法。将当前向量减去指定向量
             * @param other specified vector
             */
            subtract(other: Vec4): Vec4;
            /**
             * @en Subtracts one vector from this, and returns this.
             * @zh 向量减法。将当前向量减去指定分量的向量
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param w The w value of specified vector
             */
            subtract4f(x: number, y: number, z: number, w: number): Vec4;
            /**
             * @en Multiplies the current vector with a number, and returns this.
             * @zh 向量数乘。将当前向量数乘指定标量
             * @param scalar scalar number
             */
            multiplyScalar(scalar: number): Vec4;
            /**
             * @en Multiplies the current vector with another one and return this
             * @zh 向量乘法。将当前向量乘以指定向量
             * @param other specified vector
             */
            multiply(other: Vec4): Vec4;
            /**
             * @en Multiplies the current vector with another one and return this
             * @zh 向量乘法。将当前向量与指定分量的向量相乘的结果赋值给当前向量。
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param w The w value of specified vector
             */
            multiply4f(x: number, y: number, z: number, w: number): Vec4;
            /**
             * @en Element-wisely divides this vector with another one, and return this.
             * @zh 向量逐元素相除。将当前向量与指定分量的向量相除的结果赋值给当前向量。
             * @param other specified vector
             */
            divide(other: Vec4): Vec4;
            /**
             * @en Element-wisely divides this vector with another one, and return this.
             * @zh 向量逐元素相除。将当前向量与指定分量的向量相除的结果赋值给当前向量。
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param w The w value of specified vector
             */
            divide4f(x: number, y: number, z: number, w: number): Vec4;
            /**
             * @en Sets each component of this vector with its negative value
             * @zh 将当前向量的各个分量取反
             */
            negative(): Vec4;
            /**
             * @en Calculates the dot product with another vector
             * @zh 向量点乘。
             * @param other specified vector
             * @returns 当前向量与指定向量点乘的结果。
             */
            dot(vector: Vec4): number;
            /**
             * @en Calculates the cross product with another vector.
             * @zh 向量叉乘。视当前向量和指定向量为三维向量（舍弃 w 分量），将当前向量左叉乘指定向量
             * @param other specified vector
             *
             * @deprecated since v3.8 cross product only defined in 3D space, use [[Vec3.cross]] instead.
             */
            cross(vector: Vec4): Vec4;
            /**
             * @en Returns the length of this vector.
             * @zh 计算向量的长度（模）。
             * @returns Length of vector
             */
            length(): number;
            /**
             * @en Returns the squared length of this vector.
             * @zh 计算向量长度（模）的平方。
             * @returns the squared length of this vector
             */
            lengthSqr(): number;
            /**
             * @en Normalize the current vector.
             * @zh 将当前向量归一化
             */
            normalize(): Vec4;
            /**
             * @en Scales the current vector by a scalar number.
             * @zh 向量数乘。
             */
            scale(scalar: number): Vec4;
            /**
             * @en Transforms the vec4 with a mat4
             * @zh 应用四维矩阵变换到当前矩阵
             * @param matrix matrix to transform with
             */
            transformMat4(matrix: Mat4): Vec4;
        }
        export function v4(other: Vec4): Vec4;
        export function v4(x?: number, y?: number, z?: number, w?: number): Vec4;
        /**
         * @en quaternion
         * @zh 四元数
         */
        export class Quat extends ValueType {
            static IDENTITY: Readonly<Quat>;
            /**
             * @en Obtain a copy of the given quaternion
             * @zh 获得指定四元数的拷贝
             */
            static clone<Out extends IQuatLike>(a: Out): Quat;
            /**
             * @en Copy the given quaternion to the out quaternion
             * @zh 复制目标四元数
             */
            static copy<Out extends IQuatLike, QuatLike extends IQuatLike>(out: Out, a: QuatLike): Out;
            /**
             * @en Sets the out quaternion with values of each component
             * @zh 设置四元数值
             */
            static set<Out extends IQuatLike>(out: Out, x: number, y: number, z: number, w: number): Out;
            /**
             * @en Sets the out quaternion to an identity quaternion
             * @zh 将目标赋值为单位四元数
             */
            static identity<Out extends IQuatLike>(out: Out): Out;
            /**
             * @en Sets the out quaternion with the shortest path orientation between two vectors, considering both vectors normalized
             * @zh 设置四元数为两向量间的最短路径旋转，默认两向量都已归一化
             */
            static rotationTo<Out extends IQuatLike, VecLike extends IVec3Like>(out: Out, a: VecLike, b: VecLike): Out;
            /**
             * @en Gets the rotation axis and the arc of rotation from the quaternion
             * @zh 获取四元数的旋转轴和旋转弧度
             * @param outAxis output axis
             * @param q input quaternion
             * @return radian of rotation
             */
            static getAxisAngle<Out extends IQuatLike, VecLike extends IVec3Like>(outAxis: VecLike, q: Out): number;
            /**
             * @en Quaternion multiplication and save the results to out quaternion, that is a * b.
             * @zh 四元数乘法，即a * b。
             */
            static multiply<Out extends IQuatLike, QuatLike_1 extends IQuatLike, QuatLike_2 extends IQuatLike>(out: Out, a: QuatLike_1, b: QuatLike_2): Out;
            /**
             * @en Quaternion scalar multiplication and save the results to out quaternion
             * @zh 四元数标量乘法
             */
            static multiplyScalar<Out extends IQuatLike>(out: Out, a: Out, b: number): Out;
            /**
             * @en Quaternion multiplication and addition: A + B * scale
             * @zh 四元数乘加：A + B * scale
             */
            static scaleAndAdd<Out extends IQuatLike>(out: Out, a: Out, b: Out, scale: number): Out;
            /**
             * @en Sets the out quaternion to represent a radian rotation around x axis
             * @zh 绕 X 轴旋转指定四元数
             * @param rad radian of rotation
             */
            static rotateX<Out extends IQuatLike>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Sets the out quaternion to represent a radian rotation around y axis
             * @zh 绕 Y 轴旋转指定四元数
             * @param rad radian of rotation
             */
            static rotateY<Out extends IQuatLike>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Sets the out quaternion to represent a radian rotation around z axis
             * @zh 绕 Z 轴旋转指定四元数
             * @param rad radian of rotation
             */
            static rotateZ<Out extends IQuatLike>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Sets the out quaternion to represent a radian rotation around a given rotation axis in world space
             * @zh 绕世界空间下指定轴旋转四元数
             * @param axis axis of rotation, normalized by default
             * @param rad radian of rotation
             */
            static rotateAround<Out extends IQuatLike, VecLike extends IVec3Like>(out: Out, rot: Out, axis: VecLike, rad: number): Out;
            /**
             * @en Sets the out quaternion to represent a radian rotation around a given rotation axis in local space
             * @zh 绕本地空间下指定轴旋转四元数
             * @param axis axis of rotation
             * @param rad radian of rotation
             */
            static rotateAroundLocal<Out extends IQuatLike, VecLike extends IVec3Like>(out: Out, rot: Out, axis: VecLike, rad: number): Out;
            /**
             * @en Calculates the w component with xyz components, considering the given quaternion normalized
             * @zh 根据 xyz 分量计算 w 分量，默认已归一化
             */
            static calculateW<Out extends IQuatLike>(out: Out, a: Out): Out;
            /**
             * @en Quaternion dot product (scalar product)
             * @zh 四元数点积（数量积）
             */
            static dot<Out extends IQuatLike>(a: Out, b: Out): number;
            /**
             * @en Element by element linear interpolation: A + t * (B - A)
             * @zh 逐元素线性插值： A + t * (B - A)
             */
            static lerp<Out extends IQuatLike>(out: Out, a: Out, b: Out, t: number): Out;
            /**
             * @en Spherical quaternion interpolation
             * @zh 四元数球面插值
             */
            static slerp<Out extends IQuatLike, QuatLike_1 extends IQuatLike, QuatLike_2 extends IQuatLike>(out: Out, a: QuatLike_1, b: QuatLike_2, t: number): Out;
            /**
             * @en Spherical quaternion interpolation with two control points
             * @zh 带两个控制点的四元数球面插值
             * @param out the receiving quaternion
             * @param a the first operand
             * @param b the second operand
             * @param c the third operand
             * @param d the fourth operand
             * @param t interpolation amount, in the range [0-1], between the two inputs
             * @returns out
             */
            static sqlerp<Out extends IQuatLike>(out: Out, a: Out, b: Out, c: Out, d: Out, t: number): Out;
            /**
             * @en Sets the inverse of the given quaternion to out quaternion
             * @zh 四元数求逆
             */
            static invert<Out extends IQuatLike, QuatLike extends IQuatLike>(out: Out, a: QuatLike): Out;
            /**
             * @en Conjugating a quaternion, it's equivalent to the inverse of the unit quaternion, but more efficient
             * @zh 求共轭四元数，对单位四元数与求逆等价，但更高效
             */
            static conjugate<Out extends IQuatLike>(out: Out, a: Out): Out;
            /**
             * @en Calculates the length of the quaternion
             * @zh 求四元数长度
             */
            static len<Out extends IQuatLike>(a: Out): number;
            /**
             * @en Calculates the squared length of the quaternion
             * @zh 求四元数长度平方
             */
            static lengthSqr<Out extends IQuatLike>(a: Out): number;
            /**
             * @en Normalize the given quaternion, returns a zero quaternion if input is a zero quaternion.
             * @zh 归一化四元数，输入零四元数将会返回零四元数。
             */
            static normalize<Out extends IQuatLike>(out: Out, a: Out): Out;
            /**
             * @en Calculated the quaternion represents the given coordinates, considering all given vectors are normalized and mutually perpendicular
             * @zh 根据本地坐标轴朝向计算四元数，默认三向量都已归一化且相互垂直
             */
            static fromAxes<Out extends IQuatLike, VecLike extends IVec3Like>(out: Out, xAxis: VecLike, yAxis: VecLike, zAxis: VecLike): Out;
            /**
             * @en Calculates the quaternion with the up direction and the direction of the viewport
             * @zh 根据视口的前方向和上方向计算四元数
             * @param view The view direction, it`s must be normalized.
             * @param up The view up direction, it`s must be normalized, default value is (0, 1, 0).
             */
            static fromViewUp<Out extends IQuatLike, VecLike extends IVec3Like>(out: Out, view: VecLike, up?: Vec3): Out;
            /**
             * @en Calculates the quaternion from a given rotary shaft and a radian rotation around it.
             * @zh 根据旋转轴和旋转弧度计算四元数
             */
            static fromAxisAngle<Out extends IQuatLike, VecLike extends IVec3Like>(out: Out, axis: VecLike, rad: number): Out;
            /**
             * @en Calculates the quaternion with the three-dimensional transform matrix, considering no scale included in the matrix
             * @zh 根据三维矩阵信息计算四元数，默认输入矩阵不含有缩放信息
             */
            static fromMat3<Out extends IQuatLike>(out: Out, m: Mat3): Out;
            /**
             * @en Calculates the quaternion with Euler angles, the rotation order is YZX, first rotate around Y, then around Z, and finally around X.
             * @zh 根据欧拉角信息计算四元数，旋转顺序为 YZX，即先绕Y旋转，再绕Z，最后绕X旋转。
             */
            static fromEuler<Out extends IQuatLike>(out: Out, x: number, y: number, z: number): Out;
            /**
             * @en Calculates the quaternion with given 2D angle (0, 0, z).
             * @zh 根据 2D 角度（0, 0, z）计算四元数
             *
             * @param out Output quaternion
             * @param z Angle to rotate around Z axis in degrees.
             */
            static fromAngleZ<Out extends IQuatLike>(out: Out, z: number): Out;
            /**
             * @en This returns the X-axis vector of the quaternion
             * @zh 返回定义此四元数的坐标系 X 轴向量
             */
            static toAxisX(out: IVec3Like, q: IQuatLike): IVec3Like;
            /**
             * @en This returns the Y-axis vector of the quaternion
             * @zh 返回定义此四元数的坐标系 Y 轴向量
             */
            static toAxisY(out: IVec3Like, q: IQuatLike): IVec3Like;
            /**
             * @en This returns the Z-axis vector of the quaternion
             * @zh 返回定义此四元数的坐标系 Z 轴向量
             */
            static toAxisZ(out: IVec3Like, q: IQuatLike): IVec3Like;
            /**
             * @en Converts the quaternion to angles, result angle x, y in the range of [-180, 180], z in the range of [-90, 90] interval,
             * the rotation order is YZX, first rotate around Y, then around Z, and finally around X
             * @zh 根据四元数计算欧拉角，返回角度 x, y 在 [-180, 180] 区间内, z 默认在 [-90, 90] 区间内，旋转顺序为 YZX，即先绕Y旋转，再绕Z，最后绕X旋转。
             * @param outerZ change z value range to [-180, -90] U [90, 180]
             */
            static toEuler(out: IVec3Like, q: IQuatLike, outerZ?: boolean): IVec3Like;
            /**
             * @en Converts the quaternion to euler angles, result angle y, z in the range of [-180, 180], x in the range of [-90, 90],
             * the rotation order is YXZ, first rotate around Y, then around X, and finally around Z.
             * @zh 根据四元数计算欧拉角，返回角度 yz 在 [-180, 180], x 在 [-90, 90]，旋转顺序为 YXZ，即先绕Y旋转，再绕X，最后绕Z旋转。
             */
            static toEulerInYXZOrder(out: Vec3, q: IQuatLike): void;
            /**
             * @en Converts quaternion to an array
             * @zh 四元数转数组
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, q: IQuatLike, ofs?: number): Out;
            /**
             * @en Array to a quaternion
             * @zh 数组转四元数
             * @param ofs Array Start Offset
             */
            static fromArray(out: IQuatLike, arr: __private.__types_globals__IWritableArrayLike<number>, ofs?: number): IQuatLike;
            /**
             * @en Check whether two quaternions are equal
             * @zh 四元数等价判断
             */
            static strictEquals(a: IQuatLike, b: IQuatLike): boolean;
            /**
             * @en Check whether two quaternions are approximately equal
             * @zh 排除浮点数误差的四元数近似等价判断
             */
            static equals(a: IQuatLike, b: IQuatLike, epsilon?: number): boolean;
            /**
             * @en Gets the angular distance between two unit quaternions
             * @zh 获取两个单位四元数的夹角
             * @param a The first unit quaternion
             * @param b The second unit quaternion
             * @returns Angle between the two quaternions in radians
             */
            static angle(a: IQuatLike, b: IQuatLike): number;
            /**
             * @en Rotate a `from` unit quaternion towards `to` unit quaternion
             * @zh 将一个起始单位四元数旋转到一个目标单位四元数
             * @param from The first unit quaternion
             * @param to The second unit quaternion
             * @param maxStep The maximum angle of rotation in degrees
             * @returns new unit quaternion generated during rotation
             */
            static rotateTowards(out: IQuatLike, from: IQuatLike, to: IQuatLike, maxStep: number): IQuatLike;
            /**
             * @en x component.
             * @zh x 分量。
             */
            x: number;
            /**
             * @en y component.
             * @zh y 分量。
             */
            y: number;
            /**
             * @en z component.
             * @zh z 分量。
             */
            z: number;
            /**
             * @en w component.
             * @zh w 分量。
             */
            w: number;
            constructor(other: Quat);
            constructor(x?: number, y?: number, z?: number, w?: number);
            /**
             * @en clone the current Quat
             * @zh 克隆当前四元数。
             */
            clone(): Quat;
            /**
             * @en Set values with another quaternion
             * @zh 设置当前四元数使其与指定四元数相等。
             * @param other Specified quaternion
             * @returns `this`
             */
            set(other: Quat): Quat;
            /**
             * @en Set the value of each component of the current quaternion
             * @zh 设置当前四元数指定元素值。
             * @returns `this`
             */
            set(x?: number, y?: number, z?: number, w?: number): Quat;
            /**
             * @en Check whether the quaternion approximately equals another one
             * @zh 判断当前四元数是否在误差范围内与指定向量相等。
             * @param other Comparative quaternion
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @returns Returns `true' when the components of the two quaternions are equal within the specified error range; otherwise, returns `false'.
             */
            equals(other: Quat, epsilon?: number): boolean;
            /**
             * @en Check whether the current quaternion strictly equals other quaternion
             * @zh 判断当前四元数是否与指定四元数相等。
             * @param other Comparative quaternion
             * @returns Returns `true' when the components of the two quaternions are equal within the specified error range; otherwise, returns `false'.
             */
            strictEquals(other: Quat): boolean;
            /**
             * @en Convert quaternion to Euler angles
             * @zh 将当前四元数转化为欧拉角（x-y-z）并赋值给输出向量。
             * @param out the output vector
             */
            getEulerAngles(out: Vec3): IVec3Like;
            /**
             * @en Calculate the linear interpolation result between this quaternion and another one with given ratio
             * @zh 根据指定的插值比率，从当前四元数到目标四元数之间做线性插值。
             * @param to The target quaternion
             * @param ratio The interpolation coefficient. The range is [0,1].
             */
            lerp(to: Quat, ratio: number): Quat;
            /**
             * @en Calculates the spherical interpolation result between this quaternion and another one with the given ratio
             * @zh 根据指定的插值比率，从当前四元数到目标四元数之间做球面插值。
             * @param to The target quaternion
             * @param ratio The interpolation coefficient. The range is [0,1].
             */
            slerp(to: Quat, ratio: number): Quat;
            /**
             * @en Calculates the length of the quaternion
             * @zh 求四元数长度
             */
            length(): number;
            /**
             * @en Calculates the squared length of the quaternion
             * @zh 求四元数长度平方
             */
            lengthSqr(): number;
        }
        export function quat(other: Quat): Quat;
        export function quat(x?: number, y?: number, z?: number, w?: number): Quat;
        /**
         * @en Mathematical 3x3 matrix.
         * @zh 表示三维（3x3）矩阵。
         */
        export class Mat3 extends ValueType {
            static IDENTITY: Readonly<Mat3>;
            /**
             * @en Clone a matrix and save the results to out matrix
             * @zh 获得指定矩阵的拷贝
             */
            static clone<Out extends IMat3Like>(a: Out): Mat3;
            /**
             * @en Copy content of a matrix into another and save the results to out matrix
             * @zh 复制目标矩阵
             */
            static copy<Out extends IMat3Like>(out: Out, a: Out): Out;
            /**
             * @en Sets the elements of a matrix with the given values and save the results to out matrix
             * @zh 设置矩阵值
             */
            static set<Out extends IMat3Like>(out: Out, m00: number, m01: number, m02: number, m03: number, m04: number, m05: number, m06: number, m07: number, m08: number): Out;
            /**
             * @en Reset the out matrix to an identity matrix
             * @zh 将目标赋值为单位矩阵
             */
            static identity<Out extends IMat3Like>(out: Out): Out;
            /**
             * @en Transposes a matrix and save the results to out matrix
             * @zh 转置矩阵
             */
            static transpose<Out extends IMat3Like>(out: Out, a: Out): Out;
            /**
             * @en Inverts a matrix. When matrix is not invertible the matrix will be set to zeros.
             * @zh 矩阵求逆，注意，在矩阵不可逆时，会返回一个全为 0 的矩阵。
             */
            static invert<Out extends IMat3Like>(out: Out, a: Out): Out;
            /**
             * @en Calculates the determinant of a matrix
             * @zh 矩阵行列式
             */
            static determinant<Out extends IMat3Like>(a: Out): number;
            /**
             * @en Multiply two matrices explicitly and save the results to out matrix: a * b
             * @zh 矩阵乘法：a * b
             */
            static multiply<Out extends IMat3Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Take the first third order of the fourth order matrix and multiply by the third order matrix: a * b
             * @zh 取四阶矩阵的前三阶，与三阶矩阵相乘：a * b
             */
            static multiplyMat4<Out extends IMat3Like>(out: Out, a: Out, b: IMat4Like): Out;
            /**
             * @en Multiply a matrix with a translation vector given by a translation offset, first translate, then transform：a * T(v).
             * @zh 在给定矩阵变换基础上加入位移变换，先位移，再变换，即a * T(v)。
             */
            /**
             * @deprecated since v3.8.0, the function name is misleading, please use translate instead.
             */
            static transform<Out extends IMat3Like, VecLike extends IVec3Like>(out: Out, a: Out, v: VecLike): void;
            /**
             * @en Multiply a matrix with a translation vector given by a translation offset, first translate, then transform：a * T(v).
             * @zh 在给定矩阵变换基础上加入位移变换，先位移，再变换，即a * T(v)。
             */
            static translate<Out extends IMat3Like, VecLike extends IVec3Like>(out: Out, a: Out, v: VecLike): Out;
            /**
             * @en Multiply a matrix with a scale matrix given by a scale vector and save the results to out matrix, first scale, then transform：a * S(v).
             * @zh 在给定矩阵变换基础上加入新缩放变换，先缩放，再变换，即a * S(v)。
             */
            static scale<Out extends IMat3Like, VecLike extends IVec3Like>(out: Out, a: Out, v: VecLike): Out;
            /**
             * @en Rotates the transform by the given angle and save the results into the out matrix, first rotate, then transform：a * R(rad).
             * @zh 在给定矩阵变换基础上加入新旋转变换，先旋转，再变换，即a * R(rad)。
             * @param rad radian of rotation
             */
            static rotate<Out extends IMat3Like>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Copies the first third order matrix of a fourth order matrix to the out third order matrix
             * @zh 取四阶矩阵的前三阶
             */
            static fromMat4<Out extends IMat3Like>(out: Out, a: IMat4Like): Out;
            /**
             * @en Sets a third order matrix with view direction and up direction. Then save the results to out matrix
             * @zh 根据视口前方向和上方向计算矩阵
             * @param view The view direction, it`s must be normalized.
             * @param up The view up direction, it`s must be normalized, default value is (0, 1, 0).
             */
            static fromViewUp<Out extends IMat3Like, VecLike extends IVec3Like>(out: Out, view: VecLike, up?: Vec3): Out;
            /**
             * @en Sets the given matrix with a translation vector and save the results to out matrix
             * @zh 计算位移矩阵
             */
            static fromTranslation<Out extends IMat3Like, VecLike extends IVec2Like>(out: Out, v: VecLike): Out;
            /**
             * @en Sets the given matrix with a scale vector and save the results to out matrix
             * @zh 计算缩放矩阵
             */
            static fromScaling<Out extends IMat3Like, VecLike extends IVec2Like>(out: Out, v: VecLike): Out;
            /**
             * @en Sets the given matrix with a given angle and save the results to out matrix
             * @zh 计算旋转矩阵
             */
            static fromRotation<Out extends IMat3Like>(out: Out, rad: number): Out;
            /**
             * @en Sets the given matrix with the given quaternion and save the results to out matrix
             * @zh 根据四元数旋转信息计算矩阵
             */
            static fromQuat<Out extends IMat3Like>(out: Out, q: IQuatLike): Out;
            /**
             * @deprecated since v3.8.0, this function is too complicated, and should be split into several functions.
             */
            /**
             * @en Calculates the upper-left 3x3 matrix of a 4x4 matrix's inverse transpose
             * @zh 计算指定四维矩阵的逆转置三维矩阵
             */
            static inverseTransposeMat4<Out extends IMat3Like>(out: Out, a: IMat4Like): Out | null;
            /**
             * @en Transform a matrix object to a flat array
             * @zh 矩阵转数组
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, m: IMat3Like, ofs?: number): Out;
            /**
             * @en Generates or sets a matrix with a flat array
             * @zh 数组转矩阵
             * @param ofs Array Start Offset
             */
            static fromArray<Out extends IMat3Like>(out: Out, arr: __private.__types_globals__IWritableArrayLike<number>, ofs?: number): Out;
            /**
             * @en Adds two matrices and save the results to out matrix
             * @zh 逐元素矩阵加法
             */
            static add<Out extends IMat3Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Subtracts matrix b from matrix a and save the results to out matrix
             * @zh 逐元素矩阵减法
             */
            static subtract<Out extends IMat3Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Multiply each element of a matrix by a scalar number and save the results to out matrix
             * @zh 矩阵标量乘法
             */
            static multiplyScalar<Out extends IMat3Like>(out: Out, a: Out, b: number): Out;
            /**
             * @en Adds two matrices after multiplying each element of the second operand by a scalar number. And save the results to out matrix.
             * @zh 逐元素矩阵标量乘加: A + B * scale
             */
            static multiplyScalarAndAdd<Out extends IMat3Like>(out: Out, a: Out, b: Out, scale: number): Out;
            /**
             * @en Returns whether the specified matrices are equal.
             * @zh 矩阵等价判断
             */
            static strictEquals<Out extends IMat3Like>(a: Out, b: Out): boolean;
            /**
             * @en Returns whether the specified matrices are approximately equal.
             * @zh 排除浮点数误差的矩阵近似等价判断
             */
            static equals<Out extends IMat3Like>(a: Out, b: Out, epsilon?: number): boolean;
            /**
             * @en Convert Matrix to euler angle, resulting angle y, z in the range of [-PI, PI],
             *  x in the range of [-PI/2, PI/2], the rotation order is YXZ, first rotate around Y, then around X, and finally around Z.
             * @zh 将矩阵转换成欧拉角, 返回角度 y,z 在 [-PI, PI] 区间内, x 在 [-PI/2, PI/2] 区间内，旋转顺序为 YXZ，即先绕Y旋转，再绕X，最后绕Z旋转。
             */
            static toEuler<InType extends IMat3Like, VecLike extends IVec3Like>(matrix: InType, v: VecLike): boolean;
            /**
             * matrix layout
             * |m00  m03  m06|
             * |m01  m04  m07|
             * |m02  m05  m08|
             */
            /**
             * @en Value at column 0 row 0 of the matrix.
             * @zh 矩阵第 0 列第 0 行的元素。
             */
            m00: number;
            /**
             * @en Value at column 0 row 1 of the matrix.
             * @zh 矩阵第 0 列第 1 行的元素。
             */
            m01: number;
            /**
             * @en Value at column 0 row 2 of the matrix.
             * @zh 矩阵第 0 列第 2 行的元素。
             */
            m02: number;
            /**
             * @en Value at column 1 row 0 of the matrix.
             * @zh 矩阵第 1 列第 0 行的元素。
             */
            m03: number;
            /**
             * @en Value at column 1 row 1 of the matrix.
             * @zh 矩阵第 1 列第 1 行的元素。
             */
            m04: number;
            /**
             * @en Value at column 1 row 2 of the matrix.
             * @zh 矩阵第 1 列第 2 行的元素。
             */
            m05: number;
            /**
             * @en Value at column 2 row 0 of the matrix.
             * @zh 矩阵第 2 列第 0 行的元素。
             */
            m06: number;
            /**
             * @en Value at column 2 row 1 of the matrix.
             * @zh 矩阵第 2 列第 1 行的元素。
             */
            m07: number;
            /**
             * @en Value at column 2 row 2 of the matrix.
             * @zh 矩阵第 2 列第 2 行的元素。
             */
            m08: number;
            constructor(other: Mat3);
            constructor(m00?: number, m01?: number, m02?: number, m03?: number, m04?: number, m05?: number, m06?: number, m07?: number, m08?: number);
            /**
             * @en Clone a new matrix from the current matrix.
             * @zh 克隆当前矩阵。
             */
            clone(): Mat3;
            /**
             * @en Sets the matrix with another one's value.
             * @zh 设置当前矩阵使其与指定矩阵相等。
             * @param other Specified matrix
             * @return this
             */
            set(other: Mat3): Mat3;
            /**
             * @en Set the matrix with values of all elements
             * @zh 设置当前矩阵指定元素值。
             * @return this
             */
            set(m00?: number, m01?: number, m02?: number, m03?: number, m04?: number, m05?: number, m06?: number, m07?: number, m08?: number): Mat3;
            /**
             * @en Returns whether the specified matrices are approximately equal.
             * @zh 判断当前矩阵是否在误差范围内与指定矩阵相等。
             * @param other Comparative matrix
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @return Returns `true' when the elements of both matrices are equal; otherwise returns `false'.
             */
            equals(other: Mat3, epsilon?: number): boolean;
            /**
             * @en Returns whether the specified matrices are equal.
             * @zh 判断当前矩阵是否与指定矩阵相等。
             * @param other Comparative matrix
             * @return Returns `true' when the elements of both matrices are equal; otherwise returns `false'.
             */
            strictEquals(other: Mat3): boolean;
            /**
             * @en Returns a string representation of a matrix.
             * @zh 返回当前矩阵的字符串表示。
             * @return The string representation of this matrix
             */
            toString(): string;
            /**
             * @en set the current matrix to an identity matrix.
             * @zh 将当前矩阵设为单位矩阵。
             * @return `this`
             */
            identity(): Mat3;
            /**
             * @en Transposes the current matrix.
             * @zh 计算当前矩阵的转置矩阵。
             */
            transpose(): Mat3;
            /**
             * @en Inverts the current matrix. When matrix is not invertible the matrix will be set to zeros.
             * @zh 计算当前矩阵的逆矩阵。注意，在矩阵不可逆时，会返回一个全为 0 的矩阵。
             */
            invert(): Mat3;
            /**
             * @en Calculates the determinant of the current matrix.
             * @zh 计算当前矩阵的行列式。
             * @return 当前矩阵的行列式。
             */
            determinant(): number;
            /**
             * @en Adds the current matrix and another matrix to the current matrix.
             * @zh 矩阵加法。将当前矩阵与指定矩阵的相加，结果返回给当前矩阵。
             * @param mat the second operand
             */
            add(mat: Mat3): Mat3;
            /**
             * @en Subtracts another matrix from the current matrix.
             * @zh 计算矩阵减法。将当前矩阵减去指定矩阵的结果赋值给当前矩阵。
             * @param mat the second operand
             */
            subtract(mat: Mat3): Mat3;
            /**
             * @en Multiply the current matrix with another matrix.
             * @zh 矩阵乘法。将当前矩阵左乘指定矩阵的结果赋值给当前矩阵。
             * @param mat the second operand
             */
            multiply(mat: Mat3): Mat3;
            /**
             * @en Multiply each element of the current matrix by a scalar number.
             * @zh 矩阵数乘。将当前矩阵与指定标量的数乘结果赋值给当前矩阵。
             * @param scalar amount to scale the matrix's elements by
             */
            multiplyScalar(scalar: number): Mat3;
            /**
             * @en Multiply the current matrix with a scale matrix given by a scale vector, that is M * S(vec).
             * @zh 将当前矩阵左乘缩放矩阵的结果赋值给当前矩阵，缩放矩阵由各个轴的缩放给出，即M * S(vec)。
             * @param vec vector to scale by
             */
            scale(vec: Vec3): Mat3;
            /**
             * @en Rotates the current matrix by the given angle, that is M * R(rad).
             * @zh 将当前矩阵左乘旋转矩阵的结果赋值给当前矩阵，旋转矩阵由旋转轴和旋转角度给出，即M * R(rad)。
             * @param rad radian of rotation
             */
            rotate(rad: number): Mat3;
            /**
             * @en Resets the current matrix from the given quaternion.
             * @zh 重置当前矩阵的值，使其表示指定四元数表示的旋转变换。
             * @param q The quaternion.
             * @returns this
             */
            fromQuat(q: Quat): Mat3;
        }
        export class Mat4 extends ValueType {
            static IDENTITY: Readonly<Mat4>;
            /**
             * @en Clone a matrix and save the results to out matrix
             * @zh 获得指定矩阵的拷贝
             */
            static clone(a: IMat4Like): Mat4;
            /**
             * @en Copy a matrix into the out matrix
             * @zh 复制目标矩阵
             */
            static copy<Out extends IMat4Like>(out: Out, a: Out): Out;
            /**
             * @en Sets a matrix with the given values and save the results to out matrix
             * @zh 设置矩阵值
             *
             * @param out The receive matrix
             * @param m00 Component in column 0, row 0 position (index 0)
             * @param m01 Component in column 0, row 1 position (index 1)
             * @param m02 Component in column 0, row 2 position (index 2)
             * @param m03 Component in column 0, row 3 position (index 3)
             * @param m10 Component in column 1, row 0 position (index 4)
             * @param m11 Component in column 1, row 1 position (index 5)
             * @param m12 Component in column 1, row 2 position (index 6)
             * @param m13 Component in column 1, row 3 position (index 7)
             * @param m20 Component in column 2, row 0 position (index 8)
             * @param m21 Component in column 2, row 1 position (index 9)
             * @param m22 Component in column 2, row 2 position (index 10)
             * @param m23 Component in column 2, row 3 position (index 11)
             * @param m30 Component in column 3, row 0 position (index 12)
             * @param m31 Component in column 3, row 1 position (index 13)
             * @param m32 Component in column 3, row 2 position (index 14)
             * @param m33 Component in column 3, row 3 position (index 15)
             * @returns The receive matrix
             */
            static set<Out extends IMat4Like>(out: Out, m00: number, m01: number, m02: number, m03: number, m10: number, m11: number, m12: number, m13: number, m20: number, m21: number, m22: number, m23: number, m30: number, m31: number, m32: number, m33: number): Out;
            /**
             * @en return an identity matrix.
             * @zh 将目标赋值为单位矩阵
             */
            static identity<Out extends IMat4Like>(out: Out): Out;
            /**
             * @en return an zero matrix.
             * @zh 将目标赋值为0矩阵
             */
            static zero<Out extends IMat4Like>(out: Out): Out;
            /**
             * @en Transposes a matrix and save the results to out matrix
             * @zh 转置矩阵
             */
            static transpose<Out extends IMat4Like>(out: Out, a: Out): Out;
            /**
             * @en Inverts a matrix. When matrix is not invertible the matrix will be set to zeros.
             * @zh 矩阵求逆，注意，在矩阵不可逆时，会返回一个全为 0 的矩阵。
             */
            static invert<Out extends IMat4Like>(out: Out, a: Out): Out;
            /**
             * @en Calculates the determinant of a matrix
             * @zh 矩阵行列式
             */
            static determinant<InType extends IMat4Like>(a: InType): number;
            /**
             * @en Multiply two matrices and save the results to out matrix, (out = a * b)
             * @zh 矩阵乘法 (out = a * b)
             *
             * @param out The out matrix
             * @param a The first operand
             * @param b The second operand
             * @returns out matrix
             */
            static multiply<Out extends IMat4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Translate a matrix with the given vector and save results to the out matrix, the translate is applied before the matrix, i.e. (out = a * T)
             * @zh 在给定矩阵变换基础上加入平移变换，并将结果保存到 out 矩阵中，平移变换将应用在矩阵变换之前，即 (out = a * T)
             *
             * @param out The out matrix
             * @param a The matrix to translate
             * @param v The vector to translate with
             */
            static transform<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, a: Out, v: VecLike): Out;
            /**
             * @en Transform a matrix with the given translation vector and save results to the out matrix,
             * the translate is applied after the transformation, i.e. (out = T * a)
             * @zh 在给定矩阵变换基础上加入新位移变换，平移变换在变换之后应用，即 (out = T * a)
             *
             * @param out The out matrix
             * @param a The matrix to translate
             * @param v The vector to translate with
             * @deprecated Since 3.8.0, please use [[transform]] instead
             */
            static translate<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, a: Out, v: VecLike): Out;
            /**
             * @en Multiply a matrix with a scale matrix given by a scale vector and save the results into the out matrix,
             * the scale is applied before the matrix, i.e. (out = a * S)
             * @zh 在给定矩阵变换基础上加入新缩放变换，并将结果保存到 out 矩阵中，缩放变换将应用在矩阵变换之前，即 (out = a * S)
             */
            static scale<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, a: Out, v: VecLike): Out;
            /**
             * @en Rotates the transform by the given angle and save the results into the out matrix, the rotate is applied before
             * the matrix, i.e. (out = a * R)
             * @zh 在给定矩阵变换基础上加入新旋转变换, 并将结果保存到 out 矩阵中，旋转变换将应用在矩阵变换之前，即 (out = a * R)
             * @param rad Angle of rotation (in radians)
             * @param axis axis of rotation
             */
            static rotate<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, a: Out, rad: number, axis: VecLike): Out | null;
            /**
             * @en Transform a matrix with a given angle around X axis and save the results to the out matrix, the rotate is applied
             * before the matrix, i.e. (out = a * R)
             * @zh 在给定矩阵变换基础上加入绕 X 轴的旋转变换, 并将结果保存到 out 矩阵中，旋转变换将应用在矩阵变换之前，即 (out = a * R)
             * @param rad Angle of rotation (in radians)
             */
            static rotateX<Out extends IMat4Like>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Transform a matrix with a given angle around Y axis and save the results to the out matrix
             * @zh 在给定矩阵变换基础上加入绕 Y 轴的旋转变换
             * @param rad Angle of rotation (in radians)
             */
            static rotateY<Out extends IMat4Like>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Transform a matrix with a given angle around Z axis and save the results to the out matrix
             * @zh 在给定矩阵变换基础上加入绕 Z 轴的旋转变换
             * @param rad Angle of rotation (in radians)
             */
            static rotateZ<Out extends IMat4Like>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Sets the out matrix with a translation vector
             * @zh 计算位移矩阵
             */
            static fromTranslation<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, v: VecLike): Out;
            /**
             * @en Sets the out matrix with a scale vector
             * @zh 计算缩放矩阵
             */
            static fromScaling<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, v: VecLike): Out;
            /**
             * @en Sets the out matrix with rotation angle
             * @zh 计算旋转矩阵
             */
            static fromRotation<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, rad: number, axis: VecLike): Out | null;
            /**
             * @en Calculates the matrix representing a rotation around the X axis
             * @zh 计算绕 X 轴的旋转矩阵
             */
            static fromXRotation<Out extends IMat4Like>(out: Out, rad: number): Out;
            /**
             * @en Calculates the matrix representing a rotation around the Y axis
             * @zh 计算绕 Y 轴的旋转矩阵
             */
            static fromYRotation<Out extends IMat4Like>(out: Out, rad: number): Out;
            /**
             * @en Calculates the matrix representing a rotation around the Z axis
             * @zh 计算绕 Z 轴的旋转矩阵
             */
            static fromZRotation<Out extends IMat4Like>(out: Out, rad: number): Out;
            /**
             * @en Calculates the transform representing the combination of a rotation and a translation, and stores the result in out.
             * The order is rotation then translation.
             * @zh 根据旋转和位移信息计算矩阵
             */
            static fromRT<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, q: Quat, v: VecLike): Out;
            /**
             * @en Extracts the translation from the matrix, assuming it's composed in order of scale, rotation, translation
             * @zh 提取矩阵的位移信息, 默认矩阵中的变换以 S->R->T 的顺序应用
             */
            static getTranslation<InType extends IMat4Like, VecLike extends IVec3Like>(out: VecLike, mat: InType): VecLike;
            /**
             * @en Extracts the scale vector from the matrix, assuming it's composed in order of scale, rotation, translation
             * @zh 提取矩阵的缩放信息, 默认矩阵中的变换以 S->R->T 的顺序应用
             */
            static getScaling<InType extends IMat4Like, VecLike extends IVec3Like>(out: VecLike, mat: InType): VecLike;
            /**
             * @en Extracts the rotation from the matrix, assuming it's composed in order of scale, rotation, translation
             * @zh 提取矩阵的旋转信息, 默认输入矩阵不含有缩放信息，如考虑缩放应使用 `toRTS` 函数。
             */
            static getRotation<InType extends IMat4Like>(out: Quat, mat: InType): Quat;
            /**
             * @en Extracts the scale, rotation and translation from the matrix, assuming it's composed in order of scale, rotation, translation
             * @zh 提取旋转、位移、缩放信息， 默认矩阵中的变换以 S->R->T 的顺序应用
             *
             * @param m The input transform matrix
             * @param q The corresponding rotation quat
             * @param v The corresponding translate vector
             * @param s The corresponding scaling vector
             *
             * @deprecated Since 3.8.0, please use toSRT instead
             */
            static toRTS<InType extends IMat4Like, VecLike extends IVec3Like>(m: InType, q: Quat | null, v: VecLike | null, s: VecLike | null): void;
            /**
             * @en Extracts the scale, rotation and translation from the matrix, assuming it's composed in order of scale, rotation, translation
             * @zh 提取旋转、位移、缩放信息， 默认矩阵中的变换以 S->R->T 的顺序应用
             *
             * @param m The input transform matrix
             * @param q The corresponding rotation quat
             * @param v The corresponding translate vector
             * @param s The corresponding scaling vector
             */
            static toSRT<InType extends IMat4Like, VecLike extends IVec3Like>(m: InType, q: Quat | null, v: VecLike | null, s: VecLike | null): void;
            /**
             * @en Convert Matrix to euler angle, resulting angle y, z in the range of [-PI, PI],
             *  x in the range of [-PI/2, PI/2], the rotation order is YXZ.
             * @zh 将矩阵转换为欧拉角，结果角度 y, z 在 [-PI, PI] 范围内，x 在 [-PI/2, PI/2] 区间内，旋转顺序为 YXZ.
             */
            static toEuler<InType extends IMat4Like, VecLike extends IVec3Like>(m: InType, v: VecLike): boolean;
            /**
             * @en Compose a matrix from scale, rotation and translation, applied in order.
             * @zh 根据旋转、位移、缩放信息计算矩阵，以 S->R->T 的顺序应用
             * @deprecated Since 3.8.0, please use [[fromSRT]] instead.
             */
            static fromRTS<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, q: Quat, v: VecLike, s: VecLike): Out;
            /**
             * @en Compose a matrix from scale, rotation and translation, applied in order.
             * @zh 根据旋转、位移、缩放信息计算矩阵，以 S->R->T 的顺序应用
             * @param out The receiving matrix
             * @param q Rotation quaternion
             * @param v Translation vector
             * @param s Scaling vector
             * @returns The receiving matrix
             */
            static fromSRT<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, q: Quat, v: VecLike, s: VecLike): Out;
            /**
             * @en Compose a matrix from scale, rotation and translation, applied in order, from a given origin
             * @zh 根据指定的旋转、位移、缩放及变换中心信息计算矩阵，以 S->R->T 的顺序应用
             * @param q Rotation quaternion
             * @param v Translation vector
             * @param s Scaling vector
             * @param o transformation Center
             * @deprecated Please use [[fromSRTOrigin]] instead.
             */
            static fromRTSOrigin<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, q: Quat, v: VecLike, s: VecLike, o: VecLike): Out;
            /**
             * @en Compose a matrix from scale, rotation and translation, applied in order, from a given origin
             * @zh 根据指定的旋转、位移、缩放及变换中心信息计算矩阵，以 O^{-1}->S->R->O->T 的顺序应用
             * @param out The receiving matrix
             * @param q Rotation quaternion
             * @param v Translation vector
             * @param s Scaling vector
             * @param o transformation Center
             * @returns The receiving matrix
             */
            static fromSRTOrigin<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, q: Quat, v: VecLike, s: VecLike, o: VecLike): Out;
            /**
             * @en Sets the out matrix with the given quaternion
             * @zh 根据指定的旋转信息计算矩阵
             */
            static fromQuat<Out extends IMat4Like>(out: Out, q: Quat): Out;
            /**
             * @en Calculates the matrix representing the given frustum
             * @zh 根据指定的视锥体信息计算矩阵
             * @param out The receiving matrix.
             * @param left The X coordinate of the left side of the near projection plane in view space.
             * @param right The X coordinate of the right side of the near projection plane in view space.
             * @param bottom The Y coordinate of the bottom side of the near projection plane in view space.
             * @param top The Y coordinate of the top side of the near projection plane in view space.
             * @param near Z distance to the near plane from the origin in view space.
             * @param far Z distance to the far plane from the origin in view space.
             *
             * @return The receiving matrix.
             */
            static frustum<Out extends IMat4Like>(out: Out, left: number, right: number, bottom: number, top: number, near: number, far: number): Out;
            /**
             * @en Calculates perspective projection matrix
             * @zh 计算透视投影矩阵
             * @param out The receiving matrix.
             * @param fovy Vertical field-of-view in degrees.
             * @param aspect Aspect ratio
             * @param near Near depth clipping plane value.
             * @param far Far depth clipping plane value.
             * @param isFOVY Whether the fovy is based on the vertical field-of-view.
             * @param minClipZ The minimum value of the near clipping plane, e.g. -1 for OpenGL, 0 for Vulkan and Metal.
             * @param projectionSignY The sign of the Y axis of the projection matrix, which is used to flip the Y axis.
             * @param orientation The orientation of the projection matrix, which is used to rotate the projection matrix.
             *
             * @return The receiving matrix.
             */
            static perspective<Out extends IMat4Like>(out: Out, fov: number, aspect: number, near: number, far: number, isFOVY?: boolean, minClipZ?: number, projectionSignY?: number, orientation?: number): Out;
            /**
             * @en Calculates orthogonal projection matrix
             * @zh 计算正交投影矩阵
             * @param out The receiving matrix.
             * @param left Left-side x-coordinate.
             * @param right Right-side x-coordinate.
             * @param bottom Bottom y-coordinate.
             * @param top Top y-coordinate.
             * @param near Near depth clipping plane value.
             * @param far Far depth clipping plane value.
             * @param minClipZ The minimum value of the near clipping plane, e.g. -1 for OpenGL, 0 for Vulkan and Metal.
             * @param projectionSignY The sign of the Y axis of the projection matrix, which is used to flip the Y axis.
             * @param orientation The orientation of the projection matrix, which is used to rotate the projection matrix.
             *
             * @return The receiving matrix.
             */
            static ortho<Out extends IMat4Like>(out: Out, left: number, right: number, bottom: number, top: number, near: number, far: number, minClipZ?: number, projectionSignY?: number, orientation?: number): Out;
            /**
             * @en
             * Calculates the matrix with the view point information, given by eye position, target center and the up vector.
             * Note that center to eye vector can't be zero or parallel to the up vector
             * @zh
             * 计算视图矩阵，给定眼睛位置、目标中心和上向量。注意，中心到眼睛向量不能为零或与上向量平行。
             * @out The receiving matrix.
             * @param eye The source point.
             * @param center The target point.
             * @param up The vector describing the up direction.
             * @return The receiving matrix.
             */
            static lookAt<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, eye: VecLike, center: VecLike, up: VecLike): Out;
            /**
             * @en Calculates the inverse transpose of a matrix and save the results to out matrix
             * @zh 计算逆转置矩阵
             *
             * @deprecated This function is too complicated, and should be split into several functions.
             */
            static inverseTranspose<Out extends IMat4Like>(out: Out, a: Out): Out | null;
            /**
             * @en Transform a matrix object to a flat array
             * @zh 矩阵转数组
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, m: IMat4Like, ofs?: number): Out;
            /**
             * @en Generates or sets a matrix with a flat array
             * @zh 数组转矩阵
             * @param ofs Array Start Offset
             */
            static fromArray<Out extends IMat4Like>(out: Out, arr: __private.__types_globals__IWritableArrayLike<number>, ofs?: number): Out;
            /**
             * @en Adds two matrices and save the results to out matrix
             * @zh 逐元素矩阵加法
             */
            static add<Out extends IMat4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Subtracts matrix b from matrix a and save the results to out matrix
             * @zh 逐元素矩阵减法
             */
            static subtract<Out extends IMat4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Multiply each element of a matrix by a scalar number and save the results to out matrix
             * @zh 矩阵标量乘法
             */
            static multiplyScalar<Out extends IMat4Like>(out: Out, a: Out, b: number): Out;
            /**
             * @en Adds two matrices after multiplying each element of the second operand by a scalar number. And save the results to out matrix.
             * @zh 逐元素矩阵标量乘加: A + B * scale
             */
            static multiplyScalarAndAdd<Out extends IMat4Like>(out: Out, a: Out, b: Out, scale: number): Out;
            /**
             * @en Returns whether the specified matrices are equal.
             * @zh 矩阵等价判断
             */
            static strictEquals<InType extends IMat4Like>(a: InType, b: InType): boolean;
            /**
             * @en Returns whether the specified matrices are approximately equal.
             * @zh 排除浮点数误差的矩阵近似等价判断
             *
             * @param a The first matrix to be compared.
             * @param b The second matrix to be compared.
             * @param epsilon The tolerance value.
             * @return
             */
            static equals<InType extends IMat4Like>(a: InType, b: InType, epsilon?: number): boolean;
            /**
             * matrix layout
             * |m00  m04  m08 m12|
             * |m01  m05  m09 m13|
             * |m02  m06  m10 m14|
             * |m03  m07  m11 m15|
             */
            /**
             * @en Value at column 0 row 0 of the matrix.
             * @zh 矩阵第 0 列第 0 行的元素。
             */
            m00: number;
            /**
             * @en Value at column 0 row 1 of the matrix.
             * @zh 矩阵第 0 列第 1 行的元素。
             */
            m01: number;
            /**
             * @en Value at column 0 row 2 of the matrix.
             * @zh 矩阵第 0 列第 2 行的元素。
             */
            m02: number;
            /**
             * @en Value at column 0 row 3 of the matrix.
             * @zh 矩阵第 0 列第 3 行的元素。
             */
            m03: number;
            /**
             * @en Value at column 1 row 0 of the matrix.
             * @zh 矩阵第 1 列第 0 行的元素。
             */
            m04: number;
            /**
             * @en Value at column 1 row 1 of the matrix.
             * @zh 矩阵第 1 列第 1 行的元素。
             */
            m05: number;
            /**
             * @en Value at column 1 row 2 of the matrix.
             * @zh 矩阵第 1 列第 2 行的元素。
             */
            m06: number;
            /**
             * @en Value at column 1 row 3 of the matrix.
             * @zh 矩阵第 1 列第 3 行的元素。
             */
            m07: number;
            /**
             * @en Value at column 2 row 0 of the matrix.
             * @zh 矩阵第 2 列第 0 行的元素。
             */
            m08: number;
            /**
             * @en Value at column 2 row 1 of the matrix.
             * @zh 矩阵第 2 列第 1 行的元素。
             */
            m09: number;
            /**
             * @en Value at column 2 row 2 of the matrix.
             * @zh 矩阵第 2 列第 2 行的元素。
             */
            m10: number;
            /**
             * @en Value at column 2 row 3 of the matrix.
             * @zh 矩阵第 2 列第 3 行的元素。
             */
            m11: number;
            /**
             * @en Value at column 3 row 0 of the matrix.
             * @zh 矩阵第 3 列第 0 行的元素。
             */
            m12: number;
            /**
             * @en Value at column 3 row 1 of the matrix.
             * @zh 矩阵第 3 列第 1 行的元素。
             */
            m13: number;
            /**
             * @en Value at column 3 row 2 of the matrix.
             * @zh 矩阵第 3 列第 2 行的元素。
             */
            m14: number;
            /**
             * @en Value at column 3 row 3 of the matrix.
             * @zh 矩阵第 3 列第 3 行的元素。
             */
            m15: number;
            constructor(other: Mat4);
            constructor(m00?: number, m01?: number, m02?: number, m03?: number, m04?: number, m05?: number, m06?: number, m07?: number, m08?: number, m09?: number, m10?: number, m11?: number, m12?: number, m13?: number, m14?: number, m15?: number);
            /**
             * @en Clone a new matrix from the current matrix.
             * @zh 克隆当前矩阵。
             */
            clone(): Mat4;
            /**
             * @en Sets the matrix with another one's value.
             * @zh 设置当前矩阵使其与指定矩阵相等。
             * @param other Specified matrix.
             * @return this
             */
            set(other: Mat4): Mat4;
            /**
             * @en Set the matrix with values of all elements
             * @zh 设置当前矩阵指定元素值。
             *
             * @return this
             */
            set(m00?: number, m01?: number, m02?: number, m03?: number, m04?: number, m05?: number, m06?: number, m07?: number, m08?: number, m09?: number, m10?: number, m11?: number, m12?: number, m13?: number, m14?: number, m15?: number): Mat4;
            /**
             * @en Returns whether the specified matrices are approximately equal.
             * @zh 判断当前矩阵是否在误差范围内与指定矩阵相等。
             * @param other Comparative matrix
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @return Returns `true' when the elements of both matrices are equal; otherwise returns `false'.
             */
            equals(other: Mat4, epsilon?: number): boolean;
            /**
             * @en Returns whether the specified matrices are equal.
             * @zh 判断当前矩阵是否与指定矩阵相等。
             * @param other Comparative matrix
             * @return Returns `true' when the elements of both matrices are equal; otherwise returns `false'.
             */
            strictEquals(other: Mat4): boolean;
            /**
             * @en Returns a string representation of a matrix.
             * @zh 返回当前矩阵的字符串表示。
             * @return 当前矩阵的字符串表示。
             */
            toString(): string;
            /**
             * @en set the current matrix to an identity matrix.
             * @zh 将当前矩阵设为单位矩阵。
             * @return `this`
             */
            identity(): Mat4;
            /**
             * @en set the current matrix to an zero matrix.
             * @zh 将当前矩阵设为 0矩阵。
             * @return `this`
             */
            zero(): Mat4;
            /**
             * @en Transposes the current matrix.
             * @zh 计算当前矩阵的转置矩阵。
             */
            transpose(): Mat4;
            /**
             * @en Inverts the current matrix. When matrix is not invertible the matrix will be set to zeros.
             * @zh 计算当前矩阵的逆矩阵。注意，在矩阵不可逆时，会返回一个全为 0 的矩阵。
             */
            invert(): Mat4;
            /**
             * @en Calculates the determinant of the current matrix.
             * @zh 计算当前矩阵的行列式。
             * @return 当前矩阵的行列式。
             */
            determinant(): number;
            /**
             * @en Adds the current matrix and another matrix to the current matrix.
             * @zh 矩阵加法。将当前矩阵与指定矩阵的相加，结果返回给当前矩阵。
             * @param mat the second operand
             */
            add(mat: Mat4): Mat4;
            /**
             * @en Subtracts another matrix from the current matrix.
             * @zh 计算矩阵减法。将当前矩阵减去指定矩阵的结果赋值给当前矩阵。
             * @param mat the second operand
             */
            subtract(mat: Mat4): Mat4;
            /**
             * @en Multiply the current matrix with another matrix.
             * @zh 矩阵乘法。将当前矩阵左乘指定矩阵的结果赋值给当前矩阵。
             * @param mat the second operand
             */
            multiply(mat: Mat4): Mat4;
            /**
             * @en Multiply each element of the current matrix by a scalar number.
             * @zh 矩阵数乘。将当前矩阵与指定标量的数乘结果赋值给当前矩阵。
             * @param scalar amount to scale the matrix's elements by
             */
            multiplyScalar(scalar: number): Mat4;
            /**
             * @en Translate the current matrix by the given vector
             * @zh 将当前矩阵左乘位移矩阵的结果赋值给当前矩阵，位移矩阵由各个轴的位移给出。
             * @param vec vector to translate by
             *
             * @deprecated since v3.0, please use [[transform]] instead
             */
            translate(vec: Vec3): Mat4;
            /**
             * @en Translate the current matrix by the given vector
             * @zh 将当前矩阵左乘位移矩阵的结果赋值给当前矩阵，位移矩阵由各个轴的位移给出。
             * @param vec vector to translate by
             */
            transform(vec: Vec3): Mat4;
            /**
             * @en Multiply the current matrix with a scale vector.
             * @zh 将当前矩阵左乘缩放矩阵的结果赋值给当前矩阵，缩放矩阵由各个轴的缩放给出。
             * @param vec vector to scale by
             */
            scale(vec: Vec3): Mat4;
            /**
             * @en Rotates the current matrix by the given angle around the given axis
             * @zh 将当前矩阵左乘旋转矩阵的结果赋值给当前矩阵，旋转矩阵由旋转轴和旋转角度给出。
             * @param rad Angle of rotation (in radians)
             * @param axis Axis of rotation
             */
            rotate(rad: number, axis: Vec3): Mat4 | null;
            /**
             * @en Returns the translation vector component of a transformation matrix.
             * @zh 从当前矩阵中计算出位移变换的部分，并以各个轴上位移的形式赋值给输出向量。
             * @param out Vector to receive translation component.
             */
            getTranslation(out: Vec3): Vec3;
            /**
             * @en Returns the scale factor component of a transformation matrix
             * @zh 从当前矩阵中计算出缩放变换的部分，并以各个轴上缩放的形式赋值给输出向量。
             * @param out Vector to receive scale component
             */
            getScale(out: Vec3): Vec3;
            /**
             * @en Returns the rotation factor component of a transformation matrix
             * @zh 从当前矩阵中计算出旋转变换的部分，并以四元数的形式赋值给输出四元数。
             * @param out Vector to receive rotation component
             */
            getRotation(out: Quat): Quat;
            /**
             * @en Resets the matrix values by the given rotation quaternion, translation vector and scale vector
             * @zh 重置当前矩阵的值，使其表示指定的旋转、缩放、位移依次组合的变换。
             * @param q Rotation quaternion
             * @param v Translation vector
             * @param s Scaling vector
             * @return `this`
             *
             * @deprecated Since 3.8.0, please use [[fromSRT]] instead
             */
            fromRTS(q: Quat, v: Vec3, s: Vec3): Mat4;
            /**
             * @en Resets the matrix values by the given rotation quaternion, translation vector and scale vector
             * @zh 重置当前矩阵的值，使其表示指定的旋转、缩放、位移依次组合的变换。
             * @param q Rotation quaternion
             * @param v Translation vector
             * @param s Scaling vector
             * @return `this`
             */
            fromSRT(q: Quat, v: Vec3, s: Vec3): Mat4;
            /**
             * @en Resets the current matrix from the given quaternion.
             * @zh 重置当前矩阵的值，使其表示指定四元数表示的旋转变换。
             * @param q Rotation quaternion
             * @return `this`
             */
            fromQuat(q: Quat): Mat4;
        }
        export function mat4(other: Mat4): Mat4;
        export function mat4(m00?: number, m01?: number, m02?: number, m03?: number, m10?: number, m11?: number, m12?: number, m13?: number, m20?: number, m21?: number, m22?: number, m23?: number, m30?: number, m31?: number, m32?: number, m33?: number): Mat4;
        /**
         * @en `AffineTransform` class represent an affine transform matrix. It's composed basically by translation, rotation, scale transformations.
         * @zh 二维仿射变换矩阵，描述了平移、旋转和缩放。
         */
        export class AffineTransform {
            /**
             * @en Create an identity transformation matrix.
             * @zh 创建单位二维仿射变换矩阵，它不进行任何变换。
             */
            static identity(): AffineTransform;
            /**
             * @en Clone an `AffineTransform` object from the specified transform.
             * @zh 克隆指定的二维仿射变换矩阵。
             * @param affineTransform Specified `AffineTransform` objects
             */
            static clone(affineTransform: AffineTransform): AffineTransform;
            /**
             * @en Concatenate a transform matrix to another. The results are reflected in the out `AffineTransform`.
             * First apply t1, then t2: out * v = t2 * (t1 * v).
             * @zh 将两个矩阵相乘的结果赋值给输出矩阵，先应用t1再应用t2: out * v = t2 * (t1 * v)。
             * @param out Out object to store the concat result
             * @param t1 The first transform object.
             * @param t2 The transform object to concatenate.
             */
            static concat(out: AffineTransform, t1: AffineTransform, t2: AffineTransform): void;
            /**
             * @en Get the invert transform of an `AffineTransform` object.
             * @zh 将矩阵求逆的结果赋值给输出矩阵。
             * @param out Out object to store the invert result
             * @param t the input `AffineTransform` object
             */
            static invert(out: AffineTransform, t: AffineTransform): void;
            /**
             * @en Get an `AffineTransform` object from a given matrix 4x4.
             * @zh 将四维矩阵转换为二维仿射变换矩阵并赋值给输出矩阵。
             * @param out The output matrix to store the result
             * @param mat transform matrix.
             */
            static fromMat4(out: AffineTransform, mat: Mat4): void;
            /**
             * @en Apply the `AffineTransform` on a 2D vector.
             * @zh 应用二维仿射变换矩阵到二维向量上，并将结果赋值给输出向量。
             * @param out The output vector to store the result
             * @param point Vector to apply transform.
             * @param t transform matrix.
             */
            static transformVec2(out: Vec2, point: Vec2, t: AffineTransform): void;
            /**
             * @en Apply the `AffineTransform` on a 2D vector.
             * @zh 应用二维仿射变换矩阵到二维向量上，并将结果赋值给输出向量。
             * @param out The output vector to store the result
             * @param x x to apply transform.
             * @param y y to apply transform.
             * @param t transform matrix.
             */
            static transformVec2(out: Vec2, x: number, y: number, t: AffineTransform): void;
            /**
             * @en Apply the `AffineTransform` on a size.
             * @zh 应用二维仿射变换矩阵到二维尺寸上，并将结果赋值给输出尺寸。
             * @param out The output size to store the result
             * @param size The size to apply transform.
             * @param t transform matrix.
             */
            static transformSize(out: Size, size: Size, t: AffineTransform): void;
            /**
             * @en Apply the `AffineTransform` on a rect.
             * @zh 应用二维仿射变换矩阵到矩形上，并将结果赋值给输出矩形。
             * @param out The output rect object to store the result
             * @param rect The rect object to apply transform.
             * @param t transform matrix.
             */
            static transformRect(out: Rect, rect: Rect, t: AffineTransform): void;
            /**
             * @en Apply the `AffineTransform` on a rect, and turns to an Oriented Bounding Box.
             * This function does not allocate any memory, you should create the output vectors by yourself and manage their memory.
             * @zh 应用二维仿射变换矩阵到矩形上, 并转换为有向包围盒。
             * 这个函数不创建任何内存，你需要先创建包围盒的四个 Vector 对象用来存储结果，并作为前四个参数传入函数。
             * @param out_bl Output vector for storing the bottom left corner coordinates of the Obb object
             * @param out_tl Output vector for storing the top left corner coordinates of the Obb object
             * @param out_tr Output vector for storing the top right corner coordinates of the Obb object
             * @param out_br Output vector for storing the bottom right corner coordinates of the Obb object
             * @param rect The rect object to apply transform.
             * @param anAffineTransform transform matrix.
             */
            static transformObb(out_bl: Vec2, out_tl: Vec2, out_tr: Vec2, out_br: Vec2, rect: Rect, anAffineTransform: AffineTransform, flipY?: boolean): void;
            /**
             * matrix layout
             * |a  c  tx|
             * |b  d  ty|
             * |0  0  1 |
             */
            a: number;
            b: number;
            c: number;
            d: number;
            tx: number;
            ty: number;
            /**
             * @en constructor an `AffineTransform` object.
             * @zh 构造二维放射变换矩阵。
             * @param a a
             * @param b b
             * @param c c
             * @param d d
             * @param tx tx
             * @param ty ty
             */
            constructor(a?: number, b?: number, c?: number, d?: number, tx?: number, ty?: number);
        }
        /**
         * @en Two dimensional size type representing the width and height.
         * @zh 二维尺寸。
         */
        export class Size extends ValueType {
            static ZERO: Readonly<Size>;
            static ONE: Readonly<Size>;
            /**
             * @en Calculate the interpolation result between this size and another one with given ratio
             * @zh 根据指定的插值比率，从当前尺寸到目标尺寸之间做插值。
             * @param out Output Size.
             * @param from Original Size.
             * @param to Target Size.
             * @param ratio The interpolation coefficient.The range is [0,1].
             * @return A vector consisting of linear interpolation of the width and height of the current size
             *         to the width and height of the target size at a specified interpolation ratio, respectively.
             */
            static lerp<Out extends ISizeLike>(out: Out, from: Out, to: Out, ratio: number): Out;
            /**
             * @en Check whether `Size` a is equal to `Size` b.
             * @zh 判断两个尺寸是否相等。
             * @param a Size a.
             * @param b Size b.
             * @returns Returns `true' when both dimensions are equal in width and height; otherwise returns `false'.
             */
            static equals<InType extends ISizeLike>(a: InType, b: InType): boolean;
            set x(val: number);
            get x(): number;
            set y(val: number);
            get y(): number;
            width: number;
            height: number;
            /**
             * @en Constructor a size from another one.
             * @zh 构造与指定尺寸相等的尺寸。
             * @param other Specified Size.
             */
            constructor(other: Size);
            /**
             * @en Constructor a size with specified values.
             * @zh 构造具有指定宽度和高度的尺寸。
             * @param width width of the Size, default value is 0.
             * @param height height of the Size, default value is 0.
             */
            constructor(width?: number, height?: number);
            /**
             * @en clone the current `Size`.
             * @zh 克隆当前尺寸。
             */
            clone(): Size;
            /**
             * @en Set values with another `Size`.
             * @zh 设置当前尺寸使其与指定的尺寸相等。
             * @param other Specified Size.
             * @returns `this`
             */
            set(other: Size): any;
            /**
             * @en Set the value of each component of the current `Size`.
             * @zh 设置当前尺寸的具体参数。
             * @param width Specified width
             * @param height Specified height
             * @returns `this`
             */
            set(width?: number, height?: number): any;
            /**
             * @en Check whether the current `Size` equals another one.
             * @zh 判断当前尺寸是否与指定尺寸的相等。
             * @param other Specified Size
             * @returns Returns `true' when both dimensions are equal in width and height; otherwise returns `false'.
             */
            equals(other: Size): boolean;
            /**
             * @en Calculate the interpolation result between this size and another one with given ratio
             * @zh 根据指定的插值比率，从当前尺寸到目标尺寸之间做插值。
             * @param to Target Size.
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            lerp(to: Size, ratio: number): Size;
            /**
             * @en Return the information of the current size in string
             * @zh 返回当前尺寸的字符串表示。
             * @returns The information of the current size in string
             */
            toString(): string;
        }
        /**
         * @en Constructs a `Size` object.
         * @zh 等价于 `new Size(other)`。
         * @param other Specified Size.
         * @returns `new Size(other)`
         */
        export function size(other: Size): Size;
        /**
         * @en Constructs a `Size` object.
         * @zh 等价于 `new Size(x, y)`。
         * @param width Specified width
         * @param height Specified height
         * @returns `new Size(w, h)`
         */
        export function size(width?: number, height?: number): Size;
        /**
         * @en
         * A 2D rectangle defined by x, y position at the bottom-left corner and width, height.
         * All points inside the rectangle are greater than or equal to the minimum point and less than or equal to the maximum point.
         * The width is defined as xMax - xMin and the height is defined as yMax - yMin.
         * @zh
         * 该类表示一个二维矩形，由其左下角的 x、y 坐标以及宽度和高度组成。
         * 矩形内的所有点都大于等于矩形的最小点 (xMin, yMin) 并且小于等于矩形的最大点 (xMax, yMax)。
         * 矩形的宽度定义为 xMax - xMin；高度定义为 yMax - yMin。
         */
        export class Rect extends ValueType {
            /**
             * @en Creates a rectangle from two coordinate values.
             * @zh 由任意两个点创建一个矩形，目标矩形即是这两个点各向 x、y 轴作线所得到的矩形。
             * @param v1 Specified point 1.
             * @param v2 Specified point 2.
             * @returns Target rectangle.
             */
            static fromMinMax<Out extends IRectLike, VecLike extends IVec2Like>(out: Out, v1: VecLike, v2: VecLike): Out;
            /**
             * @en Calculate the interpolation result between this rect and another one with given ratio
             * @zh 根据指定的插值比率，从当前矩形到目标矩形之间做插值。
             * @param out Output rect.
             * @param from Original rect.
             * @param to Target rect.
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            static lerp<Out extends IRectLike>(out: Out, from: Out, to: Out, ratio: number): Out;
            /**
             * @en Returns the overlapping portion of 2 rectangles.
             * @zh 计算当前矩形与指定矩形重叠部分的矩形，将其赋值给输出矩形。
             * @param out Output Rect.
             * @param one One of the specify Rect.
             * @param other Another of the specify Rect.
             */
            static intersection<Out extends IRectLike>(out: Out, one: Out, other: Out): Out;
            /**
             * @en Returns the smallest rectangle that contains the current rect and the given rect.
             * @zh 创建同时包含当前矩形和指定矩形的最小矩形，将其赋值给输出矩形。
             * @param out Output Rect.
             * @param one One of the specify Rect.
             * @param other Another of the specify Rect.
             */
            static union<Out extends IRectLike>(out: Out, one: Out, other: Out): Out;
            /**
             * @en Returns whether rect a is equal to rect b.
             * @zh 判断两个矩形是否相等。
             * @param a The first rect to be compared.
             * @param b The second rect to be compared.
             * @returns Returns `true' when the minimum and maximum values of both rectangles are equal, respectively; otherwise, returns `false'.
             */
            static equals<InType extends IRectLike>(a: InType, b: InType): boolean;
            /**
             * @en The minimum x value.
             * @zh 获取或设置矩形在 x 轴上的最小值。
             */
            get xMin(): number;
            set xMin(value: number);
            /**
             * @en The minimum y value.
             * @zh 获取或设置矩形在 y 轴上的最小值。
             */
            get yMin(): number;
            set yMin(value: number);
            /**
             * @en The maximum x value.
             * @zh 获取或设置矩形在 x 轴上的最大值。
             */
            get xMax(): number;
            set xMax(value: number);
            /**
             * @en The maximum y value.
             * @zh 获取或设置矩形在 y 轴上的最大值。
             */
            get yMax(): number;
            set yMax(value: number);
            /**
             * @en The position of the center of the rectangle.
             * @zh 获取或设置矩形中心点的坐标。
             */
            get center(): Vec2;
            set center(value: Vec2);
            /**
             * @en Returns a new [[Vec2]] object representing the position of the rectangle
             * @zh 获取或设置矩形的 x 和 y 坐标。
             */
            get origin(): Vec2;
            set origin(value: Vec2);
            /**
             * @en Returns a new [[Size]] object represents the width and height of the rectangle
             * @zh 获取或设置矩形的尺寸。
             */
            get size(): Size;
            set size(value: Size);
            set z(val: number);
            get z(): number;
            set w(val: number);
            get w(): number;
            /**
             * @en The minimum x value.
             * @zh 矩形最小点的 x 坐标。
             */
            x: number;
            /**
             * @en The minimum y value.
             * @zh 矩形最小点的 y 坐标。
             */
            y: number;
            /**
             * @en The width of the Rect.
             * @zh 矩形的宽度。
             */
            width: number;
            /**
             * @en The height of the Rect.
             * @zh 矩形的高度。
             */
            height: number;
            /**
             * @en Constructs a Rect from another one.
             * @zh 构造与指定矩形相等的矩形。
             * @param other Specified Rect.
             */
            constructor(other: Rect);
            /**
             * @en Constructs a Rect with specified values.
             * @zh 构造具有指定的最小值和尺寸的矩形。
             * @param x The minimum X coordinate of the rectangle.
             * @param y The minimum Y coordinate of the rectangle.
             * @param width The width of the rectangle, measured from the X position.
             * @param height The height of the rectangle, measured from the Y position.
             */
            constructor(x?: number, y?: number, width?: number, height?: number);
            /**
             * @en clone the current Rect.
             * @zh 克隆当前矩形。
             */
            clone(): Rect;
            /**
             * @en Set values with another Rect.
             * @zh 设置当前矩形使其与指定矩形相等。
             * @param other Specified Rect.
             * @returns `this`
             */
            set(other: Rect): any;
            /**
             * @en Set the value of each component of the current Rect.
             * @zh 设置当前矩形使其与指定参数的矩形相等。
             * @param x The x parameter of the specified rectangle
             * @param y The y parameter of the specified rectangle
             * @param width The width parameter of the specified rectangle
             * @param height The height parameter of the specified rectangle
             * @returns `this`
             */
            set(x?: number, y?: number, width?: number, height?: number): any;
            /**
             * @en Check whether the current Rect equals another one.
             * @zh 判断当前矩形是否与指定矩形相等。
             * @param other Specified rectangles.
             * @returns Returns `true' when the minimum and maximum values of both rectangles are equal, respectively; otherwise, returns `false'.
             */
            equals(other: Rect): boolean;
            /**
             * @en Calculate the interpolation result between this Rect and another one with given ratio.
             * @zh 根据指定的插值比率，从当前矩形到目标矩形之间做插值。
             * @param to Target Rect.
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            lerp(to: Rect, ratio: number): Rect;
            /**
             * @en Return the information of the current rect in string
             * @zh 返回当前矩形的字符串表示。
             * @returns The information of the current rect in string
             */
            toString(): string;
            /**
             * @en Check whether the current rectangle intersects with the given one.
             * @zh 判断当前矩形是否与指定矩形相交。
             * @param other Specified rectangles.
             * @returns If intersected, return `true', otherwise return `false'.
             */
            intersects(other: Rect): boolean;
            /**
             * @en Check whether the current rect contains the given point.
             * @zh 判断当前矩形是否包含指定的点。
             * @param point Specified point.
             * @returns The specified point is included in the rectangle and returns `true', otherwise it returns `false'.
             */
            contains(point: Vec2): boolean;
            /**
             * @en Returns true if the other rect entirely inside this rectangle.
             * @zh 判断当前矩形是否包含指定矩形。
             * @param other Specified rectangles.
             * @returns Returns `true' if all the points of the specified rectangle are included in the current rectangle, `false' otherwise.
             */
            containsRect(other: Rect): boolean;
            /**
             * @en Apply matrix4 to the rect.
             * @zh
             * 应用矩阵变换到当前矩形：
             * 应用矩阵变换到当前矩形的最小点得到新的最小点，
             * 将当前矩形的尺寸视为二维向量应用矩阵变换得到新的尺寸；
             * 并将如此构成的新矩形。
             * @param matrix The matrix4
             */
            transformMat4(mat: Mat4): Rect;
            /**
             * @en
             * Applies a matrix transformation to the current rectangle and outputs the result to the four vertices.
             * @zh
             * 应用矩阵变换到当前矩形，并将结果输出到四个顶点上。
             *
             * @param mat The mat4 to apply
             * @param out_lb The left bottom point
             * @param out_lt The left top point
             * @param out_rb The right bottom point
             * @param out_rt The right top point
             */
            transformMat4ToPoints(mat: Mat4, out_lb: Vec2, out_lt: Vec2, out_rt: Vec2, out_rb: Vec2): void;
        }
        /**
         * @en The convenient method to create a new Rect.
         * @zh 构造与指定矩形相等的矩形。等价于 `new Rect(rect)`。
         * @param rect Specified Rect.
         * @returns `new Rect(rect)`
         */
        export function rect(rect: Rect): Rect;
        /**
         * @en The convenient method to create a new Rect.
         * @zh 构造具有指定的最小值和尺寸的矩形，等价于`new Rect(x, y, width, height)`。
         * @param x The minimum X coordinate of the rectangle.
         * @param y The minimum Y coordinate of the rectangle.
         * @param width The width of the rectangle, measured from the X position.
         * @param height The height of the rectangle, measured from the Y position.
         * @returns `new Rect(x, y, width, height)`
         */
        export function rect(x?: number, y?: number, width?: number, height?: number): Rect;
        /**
         * @en Representation of RGBA colors.<br/>
         * Each color component is an integer value with a range from 0 to 255.<br/>
         * @zh 通过 Red、Green、Blue 颜色通道表示颜色，并通过 Alpha 通道表示不透明度。<br/>
         * 每个通道都为取值范围 [0, 255] 的整数。<br/>
         */
        export class Color extends ValueType implements misc.Modifiable {
            static WHITE: Readonly<Color>;
            static GRAY: Readonly<Color>;
            static BLACK: Readonly<Color>;
            static TRANSPARENT: Readonly<Color>;
            static RED: Readonly<Color>;
            static GREEN: Readonly<Color>;
            static BLUE: Readonly<Color>;
            static CYAN: Readonly<Color>;
            static MAGENTA: Readonly<Color>;
            static YELLOW: Readonly<Color>;
            /**
             * @en Copy content of a color into another and save the results to out color.
             * @zh 获得指定颜色的拷贝
             */
            static clone<Out extends IColorLike>(a: Out): Color;
            /**
             * @en Clone a color and save the results to out color.
             * @zh 复制目标颜色
             */
            static copy<Out extends IColorLike>(out: Out, a: Out): Out;
            /**
             * @en Set the components of a color to the given values and save the results to out color.
             * @zh 设置颜色值
             */
            static set<Out extends IColorLike>(out: Out, r: number, g: number, b: number, a: number): Out;
            /**
             * @en Convert linear color from rgb8 0~255 to Vec4 0~1
             * @zh 将当前颜色转换为到 Vec4
             * @returns Vec4 as float color value
             * @example
             * ```
             * const color = Color.YELLOW;
             * color.toVec4();
             * ```
             */
            static toVec4(color: Color, out?: Vec4): Vec4;
            /**
             * @en Convert 8bit linear color from Vec4
             * @zh 使用 Vec4 设置 8 bit 颜色
             * @returns 8 Bit srgb value
             * @example
             * ```
             * color.fromVec4(new Vec4(1,1,1,1));
             * ```
             */
            static fromVec4(value: Vec4, out?: Color): Color;
            /**
             * @en Converts the hexadecimal formal color into rgb formal and save the results to out color.
             *   the argument `hex` could be hex-string or hex-number (8-digit or 6-digit).
             *   the hex-string should be like : '#12345678' '#123456', '123456', '12345678'.
             *   the hex-number should be like : 0x12345678, 0x123456 .
             * @zh 从十六进制颜色字符串中读入颜色到 out 中
             *   参数 hex 支持 16进制字符串 或者 16进制数值 (8位数字 或者 6位数字).
             *   16进制字符串的格式应该类似: '#12345678' '#123456', '123456', '12345678'.
             *   16进制数值的格式应该类似:  0x12345678, 0x123456 .
             */
            static fromHEX<Out extends IColorLike>(out: Out, hex: string | number): Out;
            /**
             * @en Add two colors by components. And save the results to out color.
             * @zh 逐通道颜色加法
             */
            static add<Out extends IColorLike>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Subtract each components of color b from each components of color a. And save the results to out color.
             * @zh 逐通道颜色减法
             */
            static subtract<Out extends IColorLike>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Multiply each components of two colors. And save the results to out color.
             * @zh 逐通道颜色乘法
             */
            static multiply<Out extends IColorLike>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Divide each components of color a by each components of color b. And save the results to out color.
             * @zh 逐通道颜色除法
             */
            static divide<Out extends IColorLike>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Multiply all channels in a color with the given scale factor, and save the results to out color.
             * @zh 全通道统一缩放颜色
             */
            static scale<Out extends IColorLike>(out: Out, a: Out, b: number): Out;
            /**
             * @en Performs a linear interpolation between two colors.
             * @zh 逐通道颜色线性插值：A + t * (B - A)
             */
            static lerp<Out extends IColorLike>(out: Out, from: Out, to: Out, ratio: number): Out;
            /**
             * @en Convert a color object to a RGBA array, and save the results to out color.
             * @zh 颜色转数组
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, a: IColorLike, ofs?: number): Out;
            /**
             * @en Sets the given color with RGBA values in an array, and save the results to out color.
             * @zh 数组转颜色
             * @param ofs Array Start Offset
             */
            static fromArray<Out extends IColorLike>(arr: __private.__types_globals__IWritableArrayLike<number>, out: Out, ofs?: number): Out;
            /**
             * @zh 从无符号 32 位整数构造颜色，高 8 位为 alpha 通道，次高 8 位为蓝色通道，次低 8 位为绿色通道，低 8 位为红色通道。
             * @en Construct color from a unsigned 32 bit integer, the highest 8 bits is for alpha channel, the second highest 8 bits is for blue channel,
             * the second lowest 8 bits is for green channel, and the lowest 8 bits if for red channel.
             *
             * @param out @en Output color object. @zh 输出的颜色对象。
             * @param uint32 @en The unsigned 32 bit integer @zh 32 位无符号整数
             * @returns @en The `out` object @zh `out` 对象
             */
            static fromUint32<Out extends IColorLike>(out: Out, uint32: number): Out;
            /**
             * @zh 转换当前颜色为无符号 32 位整数, 高 8 位为 alpha 通道，次高 8 位为蓝色通道，次低 8 位为绿色通道，低 8 位为红色通道。
             * @en Convert the current color to a unsigned 32 bit integer, the highest 8 bits is for alpha channel,
             * the second highest 8 bits is for blue channel, the second lowest 8 bits is for green channel, and the lowest 8 bits if for red channel.
             *
             * @param color @en The color. @zh 颜色。
             * @returns @en The converted unsigned 32 bit integer. @zh 32 位无符号整数。
             */
            static toUint32(color: IColorLike): number;
            /**
             * @en Check whether the two given colors are identical
             * @zh 颜色等价判断
             */
            static strictEquals<Out extends IColorLike>(a: Out, b: Out): boolean;
            /**
             * @en Check whether the two given colors are approximately equivalent. Difference of each channel is smaller that the epsilon.
             * @zh 排除浮点数误差的颜色近似等价判断
             */
            static equals<Out extends IColorLike>(a: Out, b: Out, epsilon?: number): boolean;
            /**
             * @en Convert the given color to a hex color value. And save the results to out color.
             * @zh 获取指定颜色的整型数据表示
             */
            static hex<Out extends IColorLike>(a: Out): number;
            /**
             * @en Get or set red channel value.
             * @zh 获取或设置当前颜色的 Red 通道。
             */
            get r(): number;
            set r(red: number);
            /**
             * @en Get or set green channel value.
             * @zh 获取或设置当前颜色的 Green 通道。
             */
            get g(): number;
            set g(green: number);
            /**
             * @en Get or set blue channel value.
             * @zh 获取或设置当前颜色的 Blue 通道。
             */
            get b(): number;
            set b(blue: number);
            /** @en Get or set alpha channel value.
             * @zh 获取或设置当前颜色的透明度通道。
             */
            get a(): number;
            set a(alpha: number);
            get x(): number;
            set x(value: number);
            get y(): number;
            set y(value: number);
            get z(): number;
            set z(value: number);
            get w(): number;
            set w(value: number);
            /**
             * @en Construct a same color from the given color
             * @zh 构造与指定颜色相等的颜色。
             * @param other Specified color
             */
            constructor(other: Readonly<Color>);
            /**
             * @en Construct a color form the hex color string
             * @zh 用十六进制颜色字符串中构造颜色。
             * @param hexString Hexadecimal color string.
             */
            constructor(hexString: string);
            /**
             * @en Construct a color
             * @zh 构造具有指定通道的颜色。
             * @param r red component of the color, default value is 0.
             * @param g green component of the color, default value is 0.
             * @param b blue component of the color, default value is 0.
             * @param a alpha component of the color, default value is 255.
             */
            constructor(r?: number, g?: number, b?: number, a?: number);
            /**
             * @en Clone a new color from the current color.
             * @zh 克隆当前颜色。
             */
            clone(): Color;
            /**
             * @en Check whether the current color is identical with the given color
             * @zh 判断当前颜色是否与指定颜色相等。
             * @param other Specified color
             * @returns Returns `true` when all channels of both colors are equal; otherwise returns `false`.
             */
            equals(other: Readonly<Color>): boolean;
            /**
             * @en Calculate linear interpolation result between this color and another one with given ratio。
             * @zh 根据指定的插值比率，从当前颜色到目标颜色之间做插值。
             * @param to Target color
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            lerp(to: Readonly<Color>, ratio: number): Color;
            /**
             * @en Convert to string with color information.
             * @zh 返回当前颜色的字符串表示。
             * @returns A string representation of the current color.
             */
            toString(): string;
            /**
             * @en Convert color to css format.
             * @zh 将当前颜色转换为 CSS 格式。
             * @param opt "rgba", "rgb", "#rgb" or "#rrggbb".
             * @returns CSS format for the current color.
             * @example
             * ```ts
             * let color = cc.Color.BLACK;
             * color.toCSS();          // "rgba(0,0,0,1.00)";
             * color.toCSS("rgba");    // "rgba(0,0,0,1.00)";
             * color.toCSS("rgb");     // "rgba(0,0,0)";
             * color.toCSS("#rgb");    // "#000";
             * color.toCSS("#rrggbb"); // "#000000";
             * ```
             */
            toCSS(opt?: ("rgba" | "rgb" | "#rrggbb" | "#rrggbbaa")): string;
            /**
             * @en Converts the hexadecimal formal color into rgb formal and save the results to current color object.
             *   the argument `hex` could be hex-string or hex-number (8-digit or 6-digit).
             *   the hex-string should be like : '#12345678' '#123456', '123456', '12345678'.
             *   the hex-number should be like : 0x12345678, 0x123456 .
             * @zh 从十六进制颜色字符串中读入颜色到 当前color对象中
             *   参数 hex 支持 16进制字符串 或者 16进制数值 (8位数字 或者 6位数字).
             *   16进制字符串的格式应该类似: '#12345678' '#123456', '123456', '12345678'.
             *   16进制数值的格式应该类似:  0x12345678, 0x123456 .
             * @param hex the hex-string or hex-number
             * @returns `this`
             */
            fromHEX(hex: string | number): Color;
            /**
             * @en convert Color to HEX color string.
             * @zh 转换当前颜色为十六进制颜色字符串。
             * @param fmt "#rrggbb" or "#rrggbbaa".
             * - `'#rrggbbaa'` obtains the hexadecimal value of the Red, Green, Blue,
             *   Alpha channels (**two**, high complement 0) and connects them sequentially.
             * - `'#rrggbb'` is similar to `'#rrggbbaa'` but does not include the Alpha channel.
             * @returns the Hex color string
             * @example
             * ```
             * const color = new Color(255, 14, 0, 255);
             * color.toHEX("#rgb");      // "f00";
             * color.toHEX("#rrggbbaa"); // "ff0e00ff"
             * color.toHEX("#rrggbb");   // "ff0e00"
             * ```
             */
            toHEX(fmt?: "#rgb" | "#rrggbb" | "#rrggbbaa"): string;
            /**
             * @en Convert to rgb value.
             * @zh 将当前颜色转换为 RGB 整数值。
             * @returns RGB integer value. Starting from the lowest valid bit, each 8 bits is the value of the Red, Green, and Blue channels respectively.
             * @example
             * ```
             * const color = Color.YELLOW;
             * color.toRGBValue();
             * ```
             */
            toRGBValue(): number;
            /**
             * @en Read HSV model color and convert to RGB color.
             * @zh 从 HSV 颜色中读入当前颜色。
             * @param h H value。
             * @param s S value。
             * @param v V value。
             * @returns `this`
             * @example
             * ```
             * const color = Color.YELLOW;
             * color.fromHSV(0, 0, 1); // Color {r: 255, g: 255, b: 255, a: 255};
             * ```
             */
            fromHSV(h: number, s: number, v: number): Color;
            /**
             * @en Transform to HSV model color.
             * @zh 转换当前颜色为 HSV 颜色。
             * @returns HSV format color
             * @example
             * ```
             * import { Color } from 'cc';
             * const color = Color.YELLOW;
             * color.toHSV(); // {h: 0.1533864541832669, s: 0.9843137254901961, v: 1}
             * ```
             */
            toHSV(): {
                h: number;
                s: number;
                v: number;
            };
            /**
             * @en Set the color.
             * @zh 设置当前颜色使其与指定颜色相等。
             * @param other The specified color.
             * @overload
             * @param [r=0] red component of the color, the range is [0-255]
             * @param [g=0] green component of the color
             * @param [b=0] blue component of the color
             * @param [a=255] alpha component of the color
             * @returns Current color.
             */
            set(other: Readonly<Color>): Color;
            set(r?: number, g?: number, b?: number, a?: number): Color;
            /**
             * @en Multiplies the current color by the specified color.
             * @zh 将当前颜色乘以与指定颜色
             * @param other The specified color.
             */
            multiply(other: Color): Color;
            /**
             * @en It is used in tween action. As can not modify this._data directly.
             * @zn 被 tween action 使用。因为不能直接修改 this._data，所以返回用于修改的属性。
             * @returns @en ['r', 'g', 'b', 'a'] @zh ['r', 'g', 'b', 'a']
             */
            getModifiableProperties(): string[];
        }
        export function color(other: Color | string): Color;
        export function color(r?: number, g?: number, b?: number, a?: number): Color;
        /**
         * @en Tests whether or not the arguments have approximately the same value, within an absolute<br/>
         * or relative tolerance of glMatrix.EPSILON (an absolute tolerance is used for values less<br/>
         * than or equal to 1.0, and a relative tolerance is used for larger values)
         * @zh 在glMatrix的绝对或相对容差范围内，测试参数是否具有近似相同的值。<br/>
         * EPSILON(小于等于1.0的值采用绝对公差，大于1.0的值采用相对公差)
         * @param a The first number to test.
         * @param b The second number to test.
         * @return True if the numbers are approximately equal, false otherwise.
         */
        export function equals(a: number, b: number): boolean;
        /**
         * @en Tests whether or not the arguments have approximately the same value by given maxDiff<br/>
         * @zh 通过给定的最大差异，测试参数是否具有近似相同的值。
         * @param a The first number to test.
         * @param b The second number to test.
         * @param maxDiff Maximum difference.
         * @return True if the numbers are approximately equal, false otherwise.
         */
        export function approx(a: number, b: number, maxDiff?: number): boolean;
        /**
         * @en Clamps a value between a minimum float and maximum float value.<br/>
         * @zh 返回最小浮点数和最大浮点数之间的一个数值。可以使用 clamp 函数将不断变化的数值限制在范围内。
         * @param val
         * @param min
         * @param max
         */
        export function clamp(val: number, min: number, max: number): number;
        /**
         * @en Clamps a value between 0 and 1.<br/>
         * @zh 将值限制在0和1之间。
         * @param val
         */
        export function clamp01(val: number): number;
        /**
         * @en Linear interpolation between two numbers
         * @zh 两个数之间的线性插值。
         * @param from - The starting number.
         * @param to - The ending number.
         * @param ratio - The interpolation coefficient, t should be in the range [0, 1].
         */
        export function lerp(from: number, to: number, ratio: number): number;
        /**
         * @en Convert Degree To Radian<br/>
         * @zh 把角度换算成弧度。
         * @param {Number} a Angle in Degrees
         */
        export function toRadian(a: number): number;
        /**
         * @en Convert Radian To Degree<br/>
         * @zh 把弧度换算成角度。
         * @param {Number} a Angle in Radian
         */
        export function toDegree(a: number): number;
        /**
         * @method random
         */
        export function random(): number;
        /**
         * @en Set a custom random number generator, default to Math.random
         * @zh 设置自定义随机数生成器，默认为 Math.random
         * @param func custom random number generator
         */
        export function setRandGenerator<TFunction extends (...any: any[]) => number>(func: TFunction): void;
        /**
         * @en Returns a floating-point random number between min (inclusive) and max (exclusive).<br/>
         * @zh 返回最小(包含)和最大(不包含)之间的浮点随机数。
         * @method randomRange
         * @param min
         * @param max
         * @return {Number} The random number.
         */
        export function randomRange(min: number, max: number): number;
        /**
         * @en Returns a random integer between min (inclusive) and max (exclusive).<br/>
         * @zh 返回最小(包含)和最大(不包含)之间的随机整数。
         * @param min
         * @param max
         * @return The random integer.
         */
        export function randomRangeInt(min: number, max: number): number;
        /**
         * @en
         * Linear congruence generator using Hull-Dobell Theorem.
         * @zh
         * 使用 Hull-Dobell 算法的线性同余生成器构造伪随机数
         *
         * @param seed The random seed.
         * @return The pseudo random.
         */
        export function pseudoRandom(seed: number): number;
        /**
         * @en
         * Returns a floating-point pseudo-random number between min (inclusive) and max (exclusive).
         * @zh
         * 返回一个在范围内的浮点伪随机数，注意，不包含边界值
         *
         * @param seed
         * @param min
         * @param max
         * @return The random number.
         */
        export function pseudoRandomRange(seed: number, min: number, max: number): number;
        /**
         * @en Returns a pseudo-random integer between min (inclusive) and max (exclusive).<br/>
         * @zh 返回最小(包含)和最大(不包含)之间的浮点伪随机数。
         * @param seed
         * @param min
         * @param max
         * @return The random integer.
         */
        export function pseudoRandomRangeInt(seed: number, min: number, max: number): number;
        /**
         * @en
         * Returns the next power of two for the value.<br/>
         * @zh
         * 返回下一个最接近的 2 的幂
         *
         * @param val
         * @return The the next power of two.
         */
        export function nextPow2(val: number): number;
        /**
         * @en Returns float remainder for t / length.<br/>
         * @zh 返回t / length的浮点余数。
         * @param t Time start at 0.
         * @param length Time of one cycle.
         * @return The Time wrapped in the first cycle.
         */
        export function repeat(t: number, length: number): number;
        /**
         * @en
         * Returns time wrapped in ping-pong mode.
         * @zh
         * 返回乒乓模式下的相对时间
         *
         * @param t Time start at 0.
         * @param length Time of one cycle.
         * @return The time wrapped in the first cycle.
         */
        export function pingPong(t: number, length: number): number;
        /**
         * @en Returns ratio of a value within a given range.<br/>
         * @zh 返回给定范围内的值的比率。
         * @param from Start value.
         * @param to End value.
         * @param value Given value.
         * @return The ratio between [from, to].
         */
        export function inverseLerp(from: number, to: number, value: number): number;
        /**
         * @en Compare the absolute values of all components and the component with the largest absolute value will be returned.
         * @zh 对所有分量的绝对值进行比较大小，返回绝对值最大的分量。
         * @param v vec3 like value
         * @returns max absolute component
         */
        export function absMaxComponent(v: IVec3Like): number;
        /**
         * @en Compare the absolute value of two values and return the value with the largest absolute value
         * @zh 对 a b 的绝对值进行比较大小，返回绝对值最大的值。
         * @param a number
         * @param b number
         */
        export function absMax(a: number, b: number): number;
        /**
         * @en
         * Make the attributes of the specified class available to be enumerated
         * @zh
         * 使指定类的特定属性可被枚举
         * @param prototype Inherit the prototype chain of the ValueType class
         * @param attrs List of attributes that need to be enumerated
         */
        export function enumerableProps(prototype: ValueType, attrs: string[]): void;
        export function floatToHalf(val: number): number;
        export function halfToFloat(val: number): number;
        export const HALF_PI: number;
        export const TWO_PI: number;
        export const EPSILON = 0.000001;
        export interface IColorLike {
            r: number;
            g: number;
            b: number;
            a: number;
        }
        export interface IMat3Like {
            m00: number;
            m01: number;
            m02: number;
            m03: number;
            m04: number;
            m05: number;
            m06: number;
            m07: number;
            m08: number;
        }
        export interface IMat4Like {
            m00: number;
            m01: number;
            m02: number;
            m03: number;
            m04: number;
            m05: number;
            m06: number;
            m07: number;
            m08: number;
            m09: number;
            m10: number;
            m11: number;
            m12: number;
            m13: number;
            m14: number;
            m15: number;
        }
        export interface IQuatLike {
            x: number;
            y: number;
            z: number;
            w: number;
        }
        export interface IRectLike {
            x: number;
            y: number;
            width: number;
            height: number;
        }
        export interface ISizeLike {
            width: number;
            height: number;
        }
        export interface IVec2Like {
            x: number;
            y: number;
        }
        export interface IVec3Like {
            x: number;
            y: number;
            z: number;
        }
        export interface IVec4Like {
            x: number;
            y: number;
            z: number;
            w: number;
        }
        export type FloatArray = Float64Array | Float32Array;
        export type IVec2 = IVec2Like | Readonly<IVec2Like>;
        export type IVec3 = IVec3Like | Readonly<IVec3Like>;
        export type IVec4 = IVec4Like | Readonly<IVec4Like>;
        export type IMat3 = IMat3Like | Readonly<IMat3Like>;
        export type IMat4 = IMat4Like | Readonly<IMat4Like>;
        export type IRect = IRectLike | Readonly<IRectLike>;
        export type IQuat = IQuatLike | Readonly<IQuatLike>;
        export type IColor = IColorLike | Readonly<IColorLike>;
        export const MATH_FLOAT_ARRAY: Float32ArrayConstructor | Float64ArrayConstructor;
        export class MathBase extends ValueType {
            static createFloatArray(size: number): Float64Array | Float32Array;
            /**
             * @en Get the internal array data.
             * @zh 获取内部 array 数据。
             */
            get array(): FloatArray;
            protected _array: FloatArray;
        }
    }
    export namespace memop {
        /**
         * @en Typed object pool.
         * It's a traditional design, you can get elements out of the pool or recycle elements by putting back into the pool.
         * @zh 支持类型的对象池。这是一个传统设计的对象池，你可以从对象池中取出对象或是放回不再需要对象来复用。
         * @see [[RecyclePool]]
         */
        export class Pool<T> extends __private._cocos_core_memop_scalable_container__ScalableContainer {
            /**
             * @en Constructor with the allocator of elements and initial pool size.
             * @zh 使用元素的构造器和初始大小的构造函数。
             * @param ctor @en The allocator of elements in pool, it's invoked directly without `new` in Pool.
             * @zh 元素的构造器，Pool 内部使用该构造器直接创建实例。
             * @param elementsPerBatch @en Initial pool size, this size will also be the incremental size when
             * the pool is overloaded.
             * @zh 对象池的初始大小。当对象池扩容时，也会使用该值。
             * @param dtor @en The finalizer of element, it's invoked when this Pool is destroyed or shrunk if
             * it is valid.
             * @zh 元素的析构器。如果存在的话，当对象池销毁或者缩容时，会使用该析构器。
             * @param shrinkThreshold @en The container is shrink only if the size of the container exceeds the shrinkThreshold,
             * and the size of the container after reduction is greater than or equal to the shrinkThreshold. The value equals elementsPerBatch
             * if not value is passed.
             * @zh 只有容器的数量大于 shrinkThreshold 时才缩容，缩减后的容器大小小于等于 shrinkThreshold。如果没有传入值，那么它的值和 elementsPerBatch 相同。
             */
            constructor(ctor: () => T, elementsPerBatch: number, dtor?: (obj: T) => void, shrinkThreshold?: number);
            /**
             * @en Take an object out of the object pool.
             * @zh 从对象池中取出一个对象。
             * @returns @en An object ready for use. This function always returns an object.
             * @zh 该函数总是返回一个可用的对象。
             */
            alloc(): T;
            /**
             * @en Put an object back into the object pool.
             * @zh 将一个对象放回对象池中。
             * @param obj @en The object to be put back into the pool.
             * @zh 放回对象池中的对象。
             */
            free(obj: T): void;
            /**
             * @en Put multiple objects back into the object pool.
             * @zh 将一组对象放回对象池中。
             * @param objs @en An array of objects to be put back into the pool.
             * @zh 放回对象池中的一组对象。
             */
            freeArray(objs: T[]): void;
            /**
             * @en Try to shrink the object pool to reduce memory usage.
             * @zh 尝试缩容对象池，以释放内存。
             */
            tryShrink(): void;
            /**
             * @en Destroy all elements and clear the pool.
             * @zh 释放对象池中所有资源并清空缓存池。
             */
            destroy(): void;
        }
        /**
         * @en Recyclable object pool. It's designed to be entirely reused each time.
         * There is no put and get method, each time you get the [[data]], you can use all elements as new.
         * You shouldn't simultaneously use the same RecyclePool in more than two overlapped logic.
         * Its size can be automatically incremented or manually resized.
         * @zh 循环对象池。这种池子被设计为每次使用都完整复用。
         * 它没有回收和提取的函数，通过获取 [[data]] 可以获取池子中所有元素，全部都应该被当做新对象来使用。
         * 开发者不应该在相互交叉的不同逻辑中同时使用同一个循环对象池。
         * 池子尺寸可以在池子满时自动扩充，也可以手动调整。
         * @see [[Pool]]
         */
        export class RecyclePool<T = any> extends __private._cocos_core_memop_scalable_container__ScalableContainer {
            /**
             * @en Constructor with the allocator of elements and initial pool size, all elements will be pre-allocated.
             * @zh 使用元素的构造器和初始大小的构造函数，所有元素都会被预创建。
             * @param fn The allocator of elements in pool, it's invoked directly without `new`
             * @param size Initial pool size
             * @param dtor The finalizer of element, it's invoked when this container is destroyed or shrunk
             */
            constructor(fn: () => T, size: number, dtor?: (obj: T) => void);
            /**
             * @en The length of the object pool.
             * @zh 对象池大小。
             */
            get length(): number;
            /**
             * @en The underlying array of all pool elements.
             * @zh 实际对象池数组。
             */
            get data(): T[];
            /**
             * @en Resets the object pool. Only changes the length to 0.
             * @zh 清空对象池。目前仅仅会设置尺寸为 0。
             */
            reset(): void;
            /**
             * @en Resize the object poo, and fills with new created elements.
             * @zh 设置对象池大小，并填充新的元素。
             * @param size @en The new size of the pool. @zh 新的对象池大小。
             */
            resize(size: number): void;
            /**
             * @en Adds a new element. If the capacity is insufficient, it will automatically expand to twice its original size.
             * @zh 添加一个新元素，如果容量不足，会自动扩充尺寸到原来的 2 倍。
             */
            add(): T;
            /**
             * @en Destroy the object pool. Please don't use it any more after it is destroyed.
             * @zh 销毁对象池。销毁后不能继续使用。
             */
            destroy(): void;
            /**
             * @en Try to shrink the object pool to free memory.
             * @zh 尝试回收没用的对象，释放内存。
             */
            tryShrink(): void;
            /**
             * @en Remove the element with the specified index from the object pool. This will decrease pool size.
             * @zh 移除对象池中指定索引的元素，会减小池子尺寸。
             * @param idx @en The index of the element to remove. @zh 被移除的元素的索引。
             */
            removeAt(idx: number): void;
        }
        /**
         * @en
         * Cached array is a data structure for objects cache, it's designed for persistent data.
         * Its content array length will keep grow.
         * @zh
         * 适用于对象缓存的数组类型封装，一般用于不易被移除的常驻数据。
         * 它的内部数组长度会持续增长，不会减少。
         */
        export class CachedArray<T> extends __private._cocos_core_memop_scalable_container__ScalableContainer {
            /**
             * @en
             * The array which stores actual content.
             * @zh
             * 实际存储数据内容的数组。
             */
            array: T[];
            /**
             * @en
             * The actual count of data object.
             * @zh
             * 实际存储的元素数量。
             */
            length: number;
            /**
             * @en Constructor. @zh 构造函数。
             * @param length @en Initial length of the CachedArray. @zh CachedArray 的初始长度。
             * @param compareFn @en Function used to determine the order of the elements. It is expected to return
             * a negative value if the first argument is less than the second argument, zero if they're equal, and a positive
             * value otherwise. If omitted, the elements are sorted in ascending, ASCII character order.
             * @zh 用来确定元素顺序的函数。如果第一个参数小于第二个参数，它应该返回一个负值，如果它们相等，则返回0，否则返回一个正值。
             * 如果省略，元素将按 ASCII 字符升序排序。
             */
            constructor(length: number, compareFn?: (a: T, b: T) => number);
            /**
             * @en
             * Push an element to the end of the array.
             * @zh
             * 向数组末尾添加一个元素。
             * @param item @en The item to be added. @zh 被添加到数组的元素。
             */
            push(item: T): void;
            /**
             * @en
             * Pop the last element in the array. The [[length]] will reduce, but the internal array will keep its size.
             * @zh
             * 弹出数组最后一个元素，CachedArray 的 [[length]] 会减少，但是内部数组的实际长度不变。
             * @returns @en The last element of this CachedArray. If CachedArray is empty, will return undefined.
             * @zh 数组的最后一个元素。如果数组为空，将返回 undefined。
             */
            pop(): T | undefined;
            /**
             * @en
             * Get the element at the specified index of the array.
             * @zh
             * 获取数组中指定位置的元素。
             * @param idx @en The index of the requested element. @zh 用于获取数组元素的索引。
             * @returns @en The element at given index. If idx not in [0, [[length]]) or array is empty, will return undefined.
             * @zh 数组下标对应的元素。如果 idx 超出 [0, [[length]]），或者数组是空的，将返回 undefined。
             */
            get(idx: number): T | undefined;
            /**
             * @en
             * Clear the cache. The [[length]] will be set to 0, but the internal array will keep its size.
             * @zh
             * 清空数组所有元素。[[length]] 会被设为 0，但内部数组的实际长度不变
             */
            clear(): void;
            /**
             * @en
             * Destroy the array. The [[length]] will be set to 0, and clear the internal array.
             * @zh
             * 销毁数组。[[length]] 会被设为 0，并且清空内部数组。
             */
            destroy(): void;
            /**
             * @en Requests the removal of unused capacity.
             * @zh 尝试释放多余的内存。
             */
            tryShrink(): void;
            /**
             * @en
             * Sort the existing elements in cache by [[compareFn]] passed in constructor.
             * If [[compareFn]] is not passed in, the elements are sorted in ascending, ASCII character order.
             * @zh
             * 使用构造函数传入的 [[compareFn]] 排序所有现有元素。如果没有传入比较函数，将按照 ASCII 升序排序。
             */
            sort(): void;
            /**
             * @en
             * Add all elements of a given array to the end of the current array.
             * @zh
             * 添加一个指定数组中的所有元素到当前数组末尾。
             * @param array @en The given array to be appended. @zh 被添加的数组。
             */
            concat(array: T[]): void;
            /**
             * @en Delete the element at the specified location and move the last element to that location.
             * @zh 删除指定位置的元素并将最后一个元素移动至该位置。
             * @param idx @en The index of the element to be deleted. If idx out of range [0, length), there is
             * not effect.
             *  @zh 希望被删除的索引。如果索引超出 [0, length)，将没有效果。
             */
            fastRemove(idx: number): void;
            /**
             * @en Returns the first index that compares equal to val.
             * @zh 返回在数组中找到的第一个和 val 相等的元素的索引。
             * @param val @en Value to search for. @zh 搜索的值。
             * @returns The index to the first element that compares equal to val. If no elements match, returns -1.
             * @zh 第一个和 val 相等的元素的索引。如果没找到，将返回 -1。
             */
            indexOf(val: T): number;
        }
    }
    export namespace geometry {
        /**
         * 几何工具模块
         * @module geometry
         */
        /**
         * @en
         * The enum type of basic geometry.
         * @zh
         * 形状的类型值。
         */
        export enum enums {
            SHAPE_RAY = 1,
            SHAPE_LINE = 2,
            SHAPE_SPHERE = 4,
            SHAPE_AABB = 8,
            SHAPE_OBB = 16,
            SHAPE_PLANE = 32,
            SHAPE_TRIANGLE = 64,
            SHAPE_FRUSTUM = 128,
            SHAPE_FRUSTUM_ACCURATE = 256,
            SHAPE_CAPSULE = 512,
            SHAPE_SPLINE = 1024
        }
        export namespace distance {
            /**
             * @en
             * Calculates the distance between a point and a plane.
             * @zh
             * 计算点和平面之间的距离。
             * @param point @en The target point. @zh 目标点。
             * @param plane @en The target plane. @zh 目标平面。
             * @returns @en The distance between the point and the plane. @zh 点和平面之间的距离。
             */
            export function point_plane(point: math.Vec3, plane_: Plane): number;
            /**
             * @en
             * Calculates the closest point on a plane to a given point.
             * @zh
             * 计算平面上最接近给定点的点。
             * @param out @en The closest point. @zh 最近点。
             * @param point @en The given point. @zh 给定点。
             * @param plane @en The target plane. @zh 平面。
             * @returns @en The result of the closest point, same as the `out` parameter. @zh 存储最近点的向量，与 `out` 参数为同一个对象。
             */
            export function pt_point_plane(out: math.Vec3, point: math.Vec3, plane_: Plane): math.Vec3;
            /**
             * @en
             * Calculates the closest point on an AABB to a given point.
             * @zh
             * 计算 AABB 上最接近给定点的点。
             * @param out @en The closest point. @zh 最近点。
             * @param point @en The given point @zh 给定点。
             * @param aabb @en The target AABB to calculate. @zh 参与计算的 AABB 实例。
             * @returns @en The result of the closest point, same as the `out` parameter. @zh 存储最近点的向量，与 `out` 参数为同一个对象。
             */
            export function pt_point_aabb(out: math.Vec3, point: math.Vec3, aabb_: AABB): math.Vec3;
            /**
             * @en
             * Calculates the closest point on an OBB to a given point.
             * @zh
             * 计算 OBB 上最接近给定点的点。
             * @param out @en The closest point. @zh 最近点。
             * @param point @en The given point. @zh 给定点。
             * @param obb @en The target OBB to calculate. @zh 参与计算的 OBB 实例。
             * @returns @en The result of the closest point, same as the `out` parameter. @zh 存储最近点的向量，与 `out` 参数为同一个对象。
             */
            export function pt_point_obb(out: math.Vec3, point: math.Vec3, obb_: OBB): math.Vec3;
            /**
             * @en
             * Calculates the closest point on the line, which is from A to B, to the given point.
             * @zh
             * 计算给定点距离线段 AB 上最近的一点。
             * @param out @en The closest point. @zh 最近点。
             * @param point @en The given point. @zh 给定点
             * @param linePointA @en Point A on the line. @zh 线上的某点 A。
             * @param linePointB @en Point B on the line. @zh 线上的某点 B。
             */
            export function pt_point_line(out: math.Vec3, point: math.Vec3, linePointA: math.Vec3, linePointB: math.Vec3): void;
        }
        /**
         * @en
         * Algorithm of intersect detect for basic geometry.
         * @zh
         * 基础几何的相交性检测算法。
         */
        export const intersect: {
            raySphere: (ray: Ray, sphere: Sphere) => number;
            rayAABB: (ray: Ray, aabb: AABB) => number;
            rayOBB: (ray: Ray, obb: OBB) => number;
            rayPlane: (ray: Ray, plane: Plane) => number;
            rayTriangle: (ray: Ray, triangle: Triangle, doubleSided?: boolean) => number;
            rayCapsule: (ray: Ray, capsule: Capsule) => number;
            raySubMesh: (ray: Ray, submesh: RenderingSubMesh, options?: IRaySubMeshOptions) => number;
            rayMesh: (ray: Ray, mesh: Mesh, options?: IRayMeshOptions) => number;
            rayModel: (r: Ray, model: renderer.scene.Model, options?: IRayModelOptions) => number;
            lineSphere: typeof __private._cocos_core_geometry_intersect__lineSphere;
            lineAABB: typeof __private._cocos_core_geometry_intersect__lineAABB;
            lineOBB: typeof __private._cocos_core_geometry_intersect__lineOBB;
            linePlane: (line: Line, plane: Plane) => number;
            lineTriangle: (line: Line, triangle: Triangle, outPt?: math.Vec3) => number;
            sphereWithSphere: (sphere0: Sphere, sphere1: Sphere) => boolean;
            sphereAABB: (sphere: Sphere, aabb: AABB) => boolean;
            sphereOBB: (sphere: Sphere, obb: OBB) => boolean;
            spherePlane: (sphere: Sphere, plane: Plane) => number;
            sphereFrustum: (sphere: Sphere, frustum: Frustum) => number;
            sphereFrustumAccurate: (sphere: Sphere, frustum: Frustum) => number;
            sphereCapsule: (sphere: Sphere, capsule: Capsule) => boolean;
            aabbWithAABB: (aabb1: AABB, aabb2: AABB) => boolean;
            aabbWithOBB: (aabb: AABB, obb: OBB) => number;
            aabbPlane: (aabb: AABB, plane: Plane) => number;
            aabbFrustum: (aabb: AABB, frustum: Readonly<Frustum>) => number;
            aabbFrustumAccurate: (aabb: AABB, frustum: Frustum) => number;
            obbWithOBB: (obb1: OBB, obb2: OBB) => number;
            obbPlane: (obb: OBB, plane: Plane) => number;
            obbFrustum: (obb: OBB, frustum: Frustum) => number;
            obbFrustumAccurate: (obb: OBB, frustum: Frustum) => number;
            obbPoint: (obb: OBB, point: math.Vec3) => boolean;
            obbCapsule: (obb: OBB, capsule: Capsule) => boolean | 1 | 0;
            aabbFrustumCompletelyInside: (aabb: AABB, frustum: Readonly<Frustum>) => number;
            capsuleWithCapsule: (capsuleA: Capsule, capsuleB: Capsule) => boolean;
            /**
             * @en Check intersection between two geometries, it accept all basic geometry types in [[geometry]] module.
             * @zh 两个几何体的相交性检测，可填入 [[geometry]] 模块中的基础几何形状。
             * @param g1 @en The first geometry. @zh 第一个几何体。
             * @param g2 @en The second geometry. @zh 第二个几何体。
             * @param outPt @en A 3d point to store the intersection point result, only part of the geometries support this.
             *              @zh 可选，用于保存相交点的输出对象。（注：仅部分形状的检测带有这个返回值）
             */
            resolve(g1: any, g2: any, outPt?: null): number;
        };
        /**
         * @en
         * Basic Geometry: Line.
         * @zh
         * 基础几何：直线。
         */
        export class Line {
            /**
             * @en
             * Creates a new line.
             * @zh
             * 创建一条新的直线。
             * @param sx @en The x coordinate of the start position. @zh 起点的 x 坐标。
             * @param sy @en The y coordinate of the start position. @zh 起点的 y 坐标。
             * @param sz @en The z coordinate of the start position. @zh 起点的 z 坐标。
             * @param ex @en The x coordinate of the end position. @zh 终点的 x 坐标。
             * @param ey @en The y coordinate of the end position. @zh 终点的 y 坐标。
             * @param ez @en the z coordinate of the end position. @zh 终点的 z 坐标。
             * @returns @en The created line. @zh 创建的直线。
             */
            static create(sx: number, sy: number, sz: number, ex: number, ey: number, ez: number): Line;
            /**
             * @en
             * Creates a new Line initialized with values from an existing Line.
             * @zh
             * 克隆一条新的直线。
             * @param a @en The line to clone from. @zh 克隆的来源 Line 对象。
             * @returns @en The cloned line. @zh 克隆出的新 Line 对象。
             */
            static clone(a: Line): Line;
            /**
             * @en
             * Copies the values from one Line to another.
             * @zh
             * 复制一条直线的值到另一条直线中。
             * @param out @en The output line to store the copied data. @zh 用来存储拷贝数据的 Line 对象。
             * @param a @en The line to copy from. @zh 从这个 Line 对象拷贝信息。
             * @returns @en The `out` parameter. @zh 传入的 `out` 对象。
             */
            static copy(out: Line, a: Line): Line;
            /**
             * @en
             * Creates a line from two points.
             * @zh
             * 用两个点创建一条直线。
             * @param out @en The output line. @zh 接受新数据的 Line 对象。
             * @param start @en The start point. @zh 起点。
             * @param end @en The end point. @zh 终点。
             * @returns @en The `out` parameter. @zh 传入的 out 对象。
             */
            static fromPoints(out: Line, start: math.Vec3, end: math.Vec3): Line;
            /**
             * @en
             * Sets the start point and the end point of a line with the given values.
             * @zh
             * 将给定线段的起点和终点设置为给定值。
             * @param out @en The output line to set properties. to @zh 接受新数据的 Line 对象。
             * @param sx @en The x coordinate of the start position. @zh 起点的 x 坐标。
             * @param sy @en The y coordinate of the start position. @zh 起点的 y 坐标。
             * @param sz @en The z coordinate of the start position. @zh 起点的 z 坐标。
             * @param ex @en The x coordinate of the end position. @zh 终点的 x 坐标。
             * @param ey @en The y coordinate of the end position. @zh 终点的 y 坐标。
             * @param ez @en the z coordinate of the end position. @zh 终点的 z 坐标。
             * @returns @en The `out` parameter. @zh 传入的 `out` 对象。
             */
            static set(out: Line, sx: number, sy: number, sz: number, ex: number, ey: number, ez: number): Line;
            /**
             * @en Calculates the length of the given line.
             * @zh 计算线的长度。
             * @param a @en The line to calculate length. @zh 用于计算长度的线段。
             * @returns @en The length of the given line. @zh 线段的长度。
             */
            static len(a: Line): number;
            /**
             * @en The start point.
             * @zh 起点。
             */
            s: math.Vec3;
            /**
             * @en The end point.
             * @zh 终点。
             */
            e: math.Vec3;
            /**
             * @en Gets the type of the shape. Always returns `ShapeType.SHAPE_LINE`.
             * @zh 获取形状的类型，总是返回 `ShapeType.SHAPE_LINE`。
             */
            get type(): number;
            /**
             * @en Constructs a line.
             * @zh 构造一条线。
             * @param sx @en The x coordinate of the start position. @zh 起点的 x 坐标。
             * @param sy @en The y coordinate of the start position. @zh 起点的 y 坐标。
             * @param sz @en The z coordinate of the start position. @zh 起点的 z 坐标。
             * @param ex @en The x coordinate of the end position. @zh 终点的 x 坐标。
             * @param ey @en The y coordinate of the end position. @zh 终点的 y 坐标。
             * @param ez @en the z coordinate of the end position. @zh 终点的 z 坐标。
             */
            constructor(sx?: number, sy?: number, sz?: number, ex?: number, ey?: number, ez?: number);
            /**
             * @en Calculates the length of the line.
             * @zh 计算线段的长度。
             * @returns @en The length of the line. @zh 线段的长度。
             */
            length(): number;
        }
        /**
         * @en
         * Basic Geometry: Plane.
         * Plane Equation: a*x + b*y + c*z - d = 0.
         * @zh
         * 基础几何：平面。
         * 平面方程: a*x + b*y + c*z - d = 0。
         */
        export class Plane {
            /**
             * @en
             * Creates a new plane.
             * @zh
             * 创建一个新的平面。
             * @param nx @en The x component of normal vector. @zh 法向量的 x 部分。
             * @param ny @en The y component of normal vector. @zh 法向量的 y 部分。
             * @param nz @en The z component of normal vector. @zh 法向量的 z 部分。
             * @param d  @en The distance between normal vector and the origin. @zh 与原点的距离。
             * @returns @en The created plane object. @zh 新创建的平面。
             */
            static create(nx: number, ny: number, nz: number, d: number): Plane;
            /**
             * @en
             * Clones a new plane.
             * @zh
             * 克隆一个新的平面。
             * @param p @en The Plane object to be cloned from. @zh 克隆的来源平面对象。
             * @returns @en The cloned Plane object @zh 克隆出的平面对象。
             */
            static clone(p: Plane): Plane;
            /**
             * @en
             * Copies the values from one plane to another.
             * @zh
             * 复制一个平面的值到另一个。
             * @param out @en The object to be operated on. @zh 接受操作的对象。
             * @param p @en The source of replication. @zh 复制的来源。
             * @returns @en The object to be operated on. @zh 接受操作的对象。
             */
            static copy(out: Plane, p: Plane): Plane;
            /**
             * @en
             * Creates a plane from three points
             * @zh
             * 用三个点创建一个平面。
             * @param out @en The Plane object to be operated on. @zh 接受操作的对象。
             * @param a @en The point a. @zh 点 a。
             * @param b @en The point b. @zh 点 b。
             * @param c @en The point c. @zh 点 c。
             * @returns @en The Plane object to be operated on, same as `out` parameter. @zh 接受操作的对象，与 `out` 相同。
             */
            static fromPoints(out: Plane, a: math.Vec3, b: math.Vec3, c: math.Vec3): Plane;
            /**
             * @en
             * Sets the components of a plane to the given values.
             * @zh
             * 将给定平面的属性设置为给定值。
             * @param out @en The Plane object to be operated on. @zh 接受操作的对象。
             * @param nx @en The x component of normal vector. @zh 法向量量的 x 部分。
             * @param ny @en The y component of normal vector. @zh 法向量的 y 部分。
             * @param nz @en The z component of normal vector. @zh 法向量的 z 部分。
             * @param d  @en The distance between normal vector and the origin. @zh 与原点的距离。
             * @returns @en The object to be operated on, same as the `out` parameter. @zh 接受操作的对象，与 `out` 参数相同。
             */
            static set(out: Plane, nx: number, ny: number, nz: number, d: number): Plane;
            /**
             * @en
             * Creates plane from normal and point.
             * @zh
             * 用一条法线和一个点创建平面。
             * @param out @en The object to be operated on. @zh 接受操作的对象。
             * @param normal @en The normal of the plane. @zh 平面的法线。
             * @param point @en A point in the plane. @zh 平面上的一点。
             * @returns @en The object to be operated on, same as the `out` parameter. @zh 接受操作的对象，与 `out` 参数相同。
             */
            static fromNormalAndPoint(out: Plane, normal: math.Vec3, point: math.Vec3): Plane;
            /**
             * @en
             * Normalizes a plane.
             * @zh
             * 归一化一个平面。
             * @param out @en The object to be operated on. @zh 接受操作的对象。
             * @param a @en Source data for the operation. @zh 操作的源数据。
             * @returns @en The object to be operated on, sames as the `out` parameter. @zh 接受操作的对象，与 `out` 相同。
             */
            static normalize(out: Plane, a: Plane): Plane;
            /**
             * @en
             * The normal of the plane.
             * @zh
             * 法线向量。
             */
            n: math.Vec3;
            /**
             * @en
             * The distance from the origin to the plane.
             * @zh
             * 原点到平面的距离。
             */
            d: number;
            /**
             * @en
             * Gets the type of the Plane, its value is `ShapeType.SHAPE_PLANE`.
             * @zh
             * 获取形状的类型，值为 `ShapeType.SHAPE_PLANE`。
             */
            get type(): number;
            set x(val: number);
            get x(): number;
            set y(val: number);
            get y(): number;
            set z(val: number);
            get z(): number;
            set w(val: number);
            get w(): number;
            protected readonly _type: number;
            /**
             * @en
             * Constructs a plane.
             * @zh
             * 构造一个平面。
             * @param nx @en The x component of normal vector. @zh 法向量的 x 部分。
             * @param ny @en The y component of normal vector. @zh 法向量的 y 部分。
             * @param nz @en The z component of normal vector. @zh 法向量的 z 部分。
             * @param d @en The distance between normal vector and the origin. @zh 与原点的距离。
             */
            constructor(nx?: number, ny?: number, nz?: number, d?: number);
            /**
             * @en
             * Transforms this plane by a 4x4 matrix.
             * @zh
             * 使用一个 4x4 矩阵变换此平面。
             * @param mat @en The 4x4 matrix for transformation @zh 用于变换的 4x4 矩阵。
             */
            transform(mat: math.Mat4): void;
        }
        /**
         * @en
         * Basic Geometry: Ray.
         * @zh
         * 基础几何：射线。
         */
        export class Ray {
            /**
             * @en
             * Creates a new ray.
             * @zh
             * 创建一条射线。
             * @param {number} ox @en The x component of start point. @zh 起点的 x 部分。
             * @param {number} oy @en The y component of start point. @zh 起点的 y 部分。
             * @param {number} oz @en The z component of start point. @zh 起点的 z 部分。
             * @param {number} dx @en The x component of direction point. @zh 方向的 x 部分。
             * @param {number} dy @en The y component of direction point. @zh 方向的 y 部分。
             * @param {number} dz @en The z component of direction point. @zh 方向的 z 部分。
             * @returns {Ray} @en The created ray object. @zh 新创建的射线。
             */
            static create(ox?: number, oy?: number, oz?: number, dx?: number, dy?: number, dz?: number): Ray;
            /**
             * @en
             * Creates a new ray initialized with the values from an existing ray.
             * @zh
             * 从一条射线克隆出一条新的射线。
             * @param a @en The Ray object to be cloned from. @zh 克隆的目标。
             * @returns @en The cloned Ray object. @zh 克隆出的新对象。
             */
            static clone(a: Ray): Ray;
            /**
             * @en
             * Copies the values from one ray to another.
             * @zh
             * 复制一个 Ray 的值到另一个 Ray 中。
             * @param out @en The Ray object to copy to. @zh 接受操作的射线。
             * @param a @en The Ray object to copy from. @zh 被复制的射线。
             * @returns @en The Ray object to copy to, same as the `out` parameter. @zh 接受操作的射线，与 `out` 参数相同。
             */
            static copy(out: Ray, a: Ray): Ray;
            /**
             * @en
             * Creates a ray from two points.
             * @zh
             * 用两个点创建一条射线。
             * @param out @en The Ray object. @zh 接受操作的射线。
             * @param origin @en The start point of the ray. @zh 射线的起点。
             * @param target @en The target point on the ray. @zh 射线上的一点。
             * @returns @en The Ray object, same as the `out` parameter. @zh 接受操作的射线，与 `out` 参数相同。
             */
            static fromPoints(out: Ray, origin: math.Vec3, target: math.Vec3): Ray;
            /**
             * @en
             * Sets the components of a ray to the given values.
             * @zh
             * 将给定射线的属性设置为给定的值。
             * @param out @en The Ray object to be modified @zh 接受操作的射线。
             * @param ox @en The x component of start point. @zh 起点的 x 部分。
             * @param oy @en The y component of start point. @zh 起点的 y 部分。
             * @param oz @en The z component of start point. @zh 起点的 z 部分。
             * @param dx @en The x component of direction point. @zh 方向的 x 部分。
             * @param dy @en The y component of direction point. @zh 方向的 y 部分。
             * @param dz @en The z component of direction point. @zh 方向的 z 部分。
             * @returns @en The Ray object, same as the `out` parameter. @zh 接受操作的射线，与 `out` 相同。
             */
            static set(out: Ray, ox: number, oy: number, oz: number, dx: number, dy: number, dz: number): Ray;
            /**
             * @en
             * The origin of the ray.
             * @zh
             * 起点。
             */
            o: math.Vec3;
            /**
             * @en
             * The direction of the ray.
             * @zh
             * 方向。
             */
            d: math.Vec3;
            /**
             * @en
             * Gets the type of the ray, its value is `ShapeType.SHAPE_RAY`.
             * @zh
             * 获取形状的类型，其值为`ShapeType.SHAPE_RAY`。
             */
            get type(): number;
            protected readonly _type: number;
            /**
             * @en
             * Constructs a ray.
             * @zh
             * 构造一条射线。
             * @param ox @en The x component of start point. @zh 起点的 x 部分。
             * @param oy @en The y component of start point. @zh 起点的 y 部分。
             * @param oz @en The z component of start point. @zh 起点的 z 部分。
             * @param dx @en The x component of direction point. @zh 方向的 x 部分。
             * @param dy @en The y component of direction point. @zh 方向的 y 部分。
             * @param dz @en The z component of direction point. @zh 方向的 z 部分。
             */
            constructor(ox?: number, oy?: number, oz?: number, dx?: number, dy?: number, dz?: number);
            /**
             * @en
             * Calculates a point on the ray with the specific distance from the origin point.
             * @zh
             * 根据给定的距离计算出射线上的一点。
             * @param out @en Another point on the ray. @zh 射线上的另一点。
             * @param distance @en The given distance. @zh 给定的距离。
             */
            computeHit(out: math.IVec3Like, distance: number): void;
        }
        /**
         * @en
         * Basic Geometry: Triangle.
         * @zh
         * 基础几何：三角形。
         */
        export class Triangle {
            /**
             * @en
             * Creates a new triangle instance.
             * @zh
             * 创建一个新的三角形。
             * @param ax @en The x component of point a @zh a 点的 x 部分。
             * @param ay @en The y component of point a @zh a 点的 y 部分。
             * @param az @en The z component of point a @zh a 点的 z 部分。
             * @param bx @en The x component of point b @zh b 点的 x 部分。
             * @param by @en The y component of point b @zh b 点的 y 部分。
             * @param bz @en The z component of point b @zh b 点的 z 部分。
             * @param cx @en The x component of point c @zh c 点的 x 部分。
             * @param cy @en The y component of point c @zh c 点的 y 部分。
             * @param cz @en The z component of point c @zh c 点的 z 部分。
             * @returns @en The created Triangle instance. @zh 创建出的三角形实例。
             */
            static create(ax?: number, ay?: number, az?: number, bx?: number, by?: number, bz?: number, cx?: number, cy?: number, cz?: number): Triangle;
            /**
             * @en
             * Clones a triangle instance.
             * @zh
             * 克隆一个新的三角形。
             * @param t @en The Triangle object to be cloned from. @zh 克隆的目标。
             * @returns @en The cloned triangle instance. @zh 克隆出的新对象。
             */
            static clone(t: Triangle): Triangle;
            /**
             * @en
             * Copies the values from one triangle to another.
             * @zh
             * 复制一个三角形的值到另一个三角形中。
             * @param out @en The target Triangle object to be copied to. @zh 接受操作的三角形。
             * @param t @en A Triangle object to be copied from. @zh 被复制的三角形。
             * @returns @en The target Triangle object to be copied to, same as the `out` parameter. @zh 接受操作的三角形，与 `out` 参数相同。
             */
            static copy(out: Triangle, t: Triangle): Triangle;
            /**
             * @en
             * Creates a triangle instance from three points.
             * @zh
             * 用三个点创建一个三角形。
             * @param out @en The Triangle object to be modified. @zh 接受操作的三角形。
             * @param a @en The point value to set out.a. @zh a 点。
             * @param b @en The point value to set out.b. @zh b 点。
             * @param c @en The point value to set out.c. @zh c 点。
             * @returns @en The Triangle object to be modified， same as the `out` parameter. @zh 接受操作的三角形，与 `out` 参数相同。
             */
            static fromPoints(out: Triangle, a: math.Vec3, b: math.Vec3, c: math.Vec3): Triangle;
            /**
             * @en
             * Sets the components of a triangle to the given values.
             * @zh
             * 将给定三角形的属性设置为给定值。
             * @param out @en The Triangle object to be set. @zh 接受操作的三角形。
             * @param ax @en The value to set out.a.x. @zh a 点的 x 部分。
             * @param ay @en The value to set out.a.y. @zh a 点的 y 部分。
             * @param az @en The value to set out.a.z. @zh a 点的 z 部分。
             * @param bx @en The value to set out.b.x. @zh b 点的 x 部分。
             * @param by @en The value to set out.b.y. @zh b 点的 y 部分。
             * @param bz @en The value to set out.b.z. @zh b 点的 z 部分。
             * @param cx @en The value to set out.c.x. @zh c 点的 x 部分。
             * @param cy @en The value to set out.c.y. @zh c 点的 y 部分。
             * @param cz @en The value to set out.c.z. @zh c 点的 z 部分。
             * @returns @en The Triangle object to be set, same as the `out` parameter. @zh 接受操作的三角形，与 `out` 参数相同。
             */
            static set(out: Triangle, ax: number, ay: number, az: number, bx: number, by: number, bz: number, cx: number, cy: number, cz: number): Triangle;
            /**
             * @en
             * Point a.
             * @zh
             * 点 a。
             */
            a: math.Vec3;
            /**
             * @en
             * Point b.
             * @zh
             * 点 b。
             */
            b: math.Vec3;
            /**
             * @en
             * Point c.
             * @zh
             * 点 c。
             */
            c: math.Vec3;
            /**
             * @en
             * Gets the type of the triangle, always returns `ShapeType.SHAPE_TRIANGLE`.
             * @zh
             * 获取此三角形的类型，固定返回 `ShapeType.SHAPE_TRIANGLE`。
             */
            get type(): number;
            protected readonly _type: number;
            /**
             * @en
             * Constructs a triangle.
             * @zh
             * 构造一个三角形。
             * @param ax @en x component of point a. @zh a 点的 x 部分。
             * @param ay @en y component of point a. @zh a 点的 y 部分。
             * @param az @en z component of point a. @zh a 点的 z 部分。
             * @param bx @en x component of point b. @zh b 点的 x 部分。
             * @param by @en y component of point b. @zh b 点的 y 部分。
             * @param bz @en z component of point b. @zh b 点的 z 部分。
             * @param cx @en x component of point c. @zh c 点的 x 部分。
             * @param cy @en y component of point c. @zh c 点的 y 部分。
             * @param cz @en z component of point c. @zh c 点的 z 部分。
             */
            constructor(ax?: number, ay?: number, az?: number, bx?: number, by?: number, bz?: number, cx?: number, cy?: number, cz?: number);
        }
        /**
         * @en
         * Basic Geometry: Sphere.
         * @zh
         * 基础几何：球。
         */
        export class Sphere {
            /**
             * @en
             * Creates a new sphere instance.
             * @zh
             * 创建一个新的球实例。
             * @param cx @en The X-Coordinate of the center point relative to the origin.  @zh 相对于原点的中心点的 X 坐标。
             * @param cy @en The Y-Coordinate of the center point relative to the origin.  @zh 相对于原点的中心点的 Y 坐标。
             * @param cz @en The Z-Coordinate of the center point relative to the origin.  @zh 相对于原点的中心点的 Z 坐标。
             * @param r @en The radius of the sphere. @zh 球体的半径
             * @returns @en A new sphere instance. @zh 一个新的球实例。
             */
            static create(cx: number, cy: number, cz: number, r: number): Sphere;
            /**
             * @en
             * Clones a sphere instance.
             * @zh
             * 克隆一个新的球实例。
             * @param p @en The sphere object to clone from. @zh 克隆的目标。
             * @returns @en The sphere object to clone to. @zh 克隆出的实例。
             */
            static clone(p: Sphere): Sphere;
            /**
             * @en
             * Copies the values from one sphere to another.
             * @zh
             * 复制一个球的值到另一个球中。
             * @param out @en The sphere object to copy to. @zh 接受操作的球实例。
             * @param a @en The sphere object to copy from. @zh 被复制的球实例。
             * @returns @en The sphere object to copy to. @zh 接受操作的球实例。
             */
            static copy(out: Sphere, p: Sphere): Sphere;
            /**
             * @en
             * Creates a new sphere instance from two points.
             * @zh
             * 从两个点创建一个新的球实例。
             * @param out - @en The sphere created from the two points. @zh 接受操作的球实例。
             * @param minPos - @en The lower point of the sphere. @zh 球的较小点。
             * @param maxPos - @en The upper point of the sphere. @zh 球的较大点。
             * @returns @en The created sphere, same as the `out` parameter. @zh 接受操作的球实例，与 `out` 参数相同。
             */
            static fromPoints(out: Sphere, minPos: math.Vec3, maxPos: math.Vec3): Sphere;
            /**
             * @en
             * Sets the components of a sphere to the given values
             * @zh
             * 将球体的属性设置为给定的值。
             * @param out @en The sphere to set values to. @zh 接受操作的球实例。
             * @param cx @en The X-Coordinate of the center point which relative to the origin.  @zh 相对于原点的中心点的 X 坐标。
             * @param cy @en The Y-Coordinate of the center point which relative to the origin.  @zh 相对于原点的中心点的 Y 坐标。
             * @param cz @en The Z-Coordinate of the center point which relative to the origin.  @zh 相对于原点的中心点的 Z 坐标。
             * @param r @en The radius of the sphere. @zh 要设置的球的半径。
             * @returns @en The sphere to set values to, same as the `out` parameter. @zh 接受操作的实例，与 `out` 相同。
             * @function
             */
            static set(out: Sphere, cx: number, cy: number, cz: number, r: number): Sphere;
            /**
             * @en
             * The center of this sphere.
             * @zh
             * 当前球在本地坐标中的中心点。
             */
            protected _center: math.Vec3;
            get center(): math.Vec3;
            set center(val: math.Vec3);
            /**
             * @en
             * The radius of this sphere.
             * @zh
             * 当前球的半径。
             */
            get radius(): number;
            set radius(val: number);
            /**
             * @en
             * Gets the type of the shape, always returns `ShapeType.SHAPE_SPHERE`.
             * @zh
             * 获取球的类型，固定返回 `ShapeType.SHAPE_SPHERE`。
             */
            get type(): number;
            protected readonly _type: number;
            /**
             * @en
             * Constructs a sphere instance.
             * @zh
             * 构造一个球。
             * @param cx @en The X-Coordinate of the sphere. @zh 该球的世界坐标的 X 坐标。
             * @param cy @en The Y-Coordinate of the sphere. @zh 该球的世界坐标的 Y 坐标。
             * @param cz @en The Z-Coordinate of the sphere. @zh 该球的世界坐标的 Z 坐标。
             * @param r @en The radius of the sphere. @zh 球的半径。
             */
            constructor(cx?: number, cy?: number, cz?: number, r?: number);
            destroy(): void;
            /**
             * @en
             * Clones a sphere instance.
             * @zh
             * 克隆一个球实例。
             * @returns @en The cloned sphere instance. @zh 克隆的球实例。
             */
            clone(): Sphere;
            /**
             * @en
             * Copies the values from a sphere to the current sphere.
             * @zh
             * 复制一个球的值到当前球实例中。
             * @param a @en The sphere to copy from. @zh 拷贝的目标。
             */
            copy(a: Sphere): Sphere;
            /**
             * @en
             * Gets the bounding points of this sphere.
             * @zh
             * 获取此球体的边界点。
             * @param minPos @en The point with maximum coordinates of the sphere. @zh 当前球实例的最小点。
             * @param maxPos @en The point with minimum coordinates of the sphere. @zh 当前球实例的最大点。
             */
            getBoundary(minPos: math.Vec3, maxPos: math.Vec3): void;
            /**
             * @en
             * Transforms this sphere by a 4x4 matrix and RTS and stores to the `out` parameter.
             * @zh
             * 用一个 4x4 矩阵和一组 RTS 变换此球体，并将结果存储在 `out` 参数中。
             * @param m @en The 4x4 transform matrix. @zh 4x4 变换矩阵。
             * @param pos @en The position part of the transform. @zh 变换的位置部分。
             * @param rot @en The rotation part of the transform. @zh 变换的旋转部分。
             * @param scale @en The scale part of the transform. @zh 变换的缩放部分。
             * @param out @en The sphere which the transform will be applied to. @zh 变换的目标。
             */
            transform(m: math.Mat4, pos: math.Vec3, rot: math.Quat, scale: math.Vec3, out: Sphere): void;
            /**
             * @en
             * Transforms this sphere by a 4x4 matrix and a quaternion, stores the result to the `out` parameter.
             * @zh
             * 使用一个 4x4 矩阵和一个四元数变换此球体，并将结果存储在 `out` 参数中。
             * @param m @en The 4x4 transform matrix. @zh 4x4 变换矩阵。
             * @param rot @en The rotation part of the transform. @zh 变换的旋转部分。
             * @param out @en The sphere which the transform will be applied to. @zh 变换的目标。
             */
            translateAndRotate(m: math.Mat4, rot: math.Quat, out: Sphere): void;
            /**
             * @en
             * Scales this sphere and stores the result to the `out` parameter.
             * @zh
             * 对当前球实例进行缩放处理，并将结果存储在 `out` 参数中。
             * @param scale @en The scale value. @zh 缩放值。
             * @param out @en The sphere which the scale will be applied to. @zh 缩放的目标。
             */
            setScale(scale: math.Vec3, out: Sphere): void;
            /**
             * @en Merges a point to this sphere.
             * @zh 合并一个点到当前球实例中。
             * @param point @en The point to be merged to this sphere. @zh 要合并到当前球实例的点。
             */
            mergePoint(point: math.Vec3): void;
            /**
             * @en Merges some points to this sphere.
             * @zh 合并一些点到当前球实例中。
             * @param points @en The points to be merged to this sphere. @zh 要合并到当前球实例的点列表。
             */
            mergePoints(points: math.Vec3[]): void;
            /**
             * @en Merges a AABB to this sphere.
             * @zh 合并一个 AABB 到当前球实例中。
             * @param a @en The AABB instance to be merged to this sphere. @zh 要合并到当前球实例的 AABB 实例。
             */
            mergeAABB(a: AABB): void;
        }
        /**
         * @en
         * Basic Geometry: Axis-aligned bounding box, using center and half extents structure.
         * It's a fairly computationally and memory efficient way of checking whether two 3D objects might be touching.
         * @zh
         * 基础几何：轴对齐包围盒，使用中心点和半长宽高的结构。
         * 这是检查两个 3D 对象是否相交的一种在计算和内存上效率都相当高的方法。
         */
        export class AABB {
            /**
             * @en
             * Creates a new AABB instance.
             * @zh
             * 创建一个新的 AABB 实例。
             * @param px @zh AABB 原点的 X 坐标。 @en The x coordinate of the origin of the AABB.
             * @param py @zh AABB 原点的 Y 坐标。 @en The y coordinate of the origin of the AABB.
             * @param pz @zh AABB 原点的 Z 坐标。 @en The z coordinate of the origin of the AABB.
             * @param hw @zh AABB 宽度的一半。 @en Half the width of the AABB.
             * @param hh @zh AABB 高度的一半。 @en Half the height of the AABB.
             * @param hl @zh AABB 长度的一半。 @en Half the length of the AABB.
             * @returns @zh 返回新创建的 AABB 实例。 @en A new instance of AABB.
             */
            static create(px?: number, py?: number, pz?: number, hw?: number, hh?: number, hl?: number): AABB;
            /**
             * @en
             * Clones an AABB, which will create a new AABB instance with the same value as the input parameter `a`. Note that each time `clone` is invoked,
             * a new AABB object will be created, so use `copy` method whenever it could to reduce GC pressure.
             * @zh
             * 克隆一个 AABB，其会创建出一个值跟输入参数`a`一样的 AABB 实例。注意，每次调用 `clone` 都会创建出新实例，尽可能使用 `copy` 方法以减小 GC 压力。
             * @param a @zh 克隆的目标。 @en The target object to be cloned.
             * @returns @zh 克隆出的 AABB 实例。@en The cloned AABB instance.
             * @deprecated since v3.8.4. Please use the corresponding instance method instead.
             */
            static clone(a: AABB | Readonly<AABB>): AABB;
            /**
             * @en
             * Copies the values from one AABB to another, the process will not generate temporary objects.
             * @zh
             * 将一个 AABB 的值复制到另一个 AABB 中，此过程将不会产生临时对象。
             * @param out @zh 接受操作的 AABB。 @en The output AABB which is the copy destination.
             * @param a @zh 被复制的 AABB，此为只读参数。 @en The source object of the copy operation, it's readonly.
             * @returns @zh 接受操作的 AABB `out` 的引用。 @en The reference to the first parameter `out`.
             * @deprecated since v3.8.4. Please use the corresponding instance method instead.
             */
            static copy(out: AABB, a: AABB | Readonly<AABB>): AABB;
            /**
             * @en
             * Constructs a new AABB from two corner points.
             * @zh
             * 从两个点创建一个新的 AABB。
             * @param out @zh 接受操作的 AABB。 @en The output AABB.
             * @param minPos @zh AABB 的最小点。 @en Minimum point of the AABB.
             * @param maxPos @zh AABB 的最大点。 @en Maximum point of the AABB.
             * @returns @zh 接受操作的 AABB `out` 的引用。 @en The reference to the first parameter `out`.
             */
            static fromPoints(out: AABB, minPos: math.IVec3, maxPos: math.IVec3): AABB;
            /**
             * @en
             * Sets the components of a AABB to the given values.
             * @zh
             * 将 AABB 的属性设置为给定的值。
             * @param @zh out 接受操作的 AABB。 @en The output AABB to set.
             * @param px @zh - AABB 原点的 X 坐标。 @en The x coordinate of the origin of the AABB.
             * @param py @zh - AABB 原点的 Y 坐标。 @en The y coordinate of the origin of the AABB.
             * @param pz @zh - AABB 原点的 Z 坐标。 @en The z coordinate of the origin of the AABB.
             * @param hw @zh - AABB 宽度的一半。 @en Half the width of the AABB.
             * @param hh @zh - AABB 高度的一半。 @en Half the height of the AABB.
             * @param hl @zh - AABB 长度的一半。 @en Half the length of the AABB.
             * @returns @zh 接受操作的 AABB `out` 的引用。 @en The reference fo the first parameter `out`.
             */
            static set(out: AABB, px: number, py: number, pz: number, hw: number, hh: number, hl: number): AABB;
            /**
             * @en
             * Merges two AABB instances into one.
             * @zh
             * 合并两个 AABB 到一个目标 AABB 中。
             * @param out @zh 接受操作的目标 AABB。 @en The output AABB to storage the merge result.
             * @param a @zh 第一个输入的 AABB，当其与 out 参数不同的时候，此函数内部不会修改其值。
             *          @en The first AABB to be merged, its value will not be modified if `a` is not equal to the `out` parameter.
             * @param b @zh 第二个输入的 AABB，当其与 out 参数不同的时候，此函数内部不会修改其值。
             *          @en The second AABB to be merged, its value will not be modified if `b` is not equal to the `out` parameter.
             * @returns @zh 接受操作的 AABB `out` 的引用。 @en The reference to the first parameter `out`.
             */
            static merge(out: AABB, a: AABB | Readonly<AABB>, b: AABB | Readonly<AABB>): AABB;
            /**
             * @en
             * Converts an AABB to a bounding sphere.
             * @zh
             * 包围盒转包围球
             * @param out @zh 接受操作的包围球。 @en The output bounding sphere.
             * @param a @zh 输入的 AABB，只读参数。 @en The input AABB，it's readonly.
             * @returns @zh 接受操作的包围球 `out` 的引用. @en The reference to the first parameter `out`.
             */
            static toBoundingSphere(out: Sphere, a: AABB | Readonly<AABB>): Sphere;
            /**
             * @en
             * Transforms an AABB by a 4x4 matrix and stores the result to the `out` parameter.
             * @zh
             * 使用一个 4 乘 4 矩阵变换一个 AABB 并将结果存储于 out 参数中。
             * @param out @zh 接受操作的 AABB。 @en The output AABB to store the result.
             * @param a @zh 输入的源 AABB，如果其与 out 参数不是同一个对象，那么 a 将不会被此函数修改。
             *          @en The input AABB, if it's different with the `out` parameter, then `a` will not be changed by this function.
             * @param matrix @zh 矩阵。 @en The transformation matrix.
             * @returns @zh 接受操作的 AABB `out` 的引用。 @en The reference of the first parameter `out`.
             */
            static transform(out: AABB, a: AABB | Readonly<AABB>, matrix: math.Mat4 | Readonly<math.Mat4>): AABB;
            /**
             * @en
             * The center point of this AABB.
             * @zh
             * 本地坐标的中心点。
             */
            center: math.Vec3;
            /**
             * @en
             * Half the size of this AABB.
             * @zh
             * 长宽高的一半。
             */
            halfExtents: math.Vec3;
            /**
             * @en
             * Gets the type of this shape.
             * @zh
             * 获取此形状的类型。
             */
            get type(): number;
            protected readonly _type: number;
            constructor(px?: number, py?: number, pz?: number, hw?: number, hh?: number, hl?: number);
            /**
             * @en
             * Gets the bounding points of this AABB.
             * @zh
             * 获取此 AABB 的最小点和最大点。
             * @param minPos @zh 存放此 AABB 最小点的向量。 @en The minimum position of the AABB to be stored to.
             * @param maxPos @zh 存放此 AABB 最大点的向量。 @en The maximum position of the AABB to be stored to.
             */
            getBoundary(minPos: math.IVec3Like, maxPos: math.IVec3Like): void;
            /**
             * @en
             * Transforms this AABB by a 4x4 matrix and stores the result to `out` parameter
             * @zh
             * 使用 4 乘 4 矩阵变换此 AABB 并将结果存储于 `out` 参数中。
             * @param m @zh 变换的矩阵。 @en The transform matrix.
             * @param pos @zh 变换的位置部分。 @en 3d-vector translation.
             * @param rot @zh 变换的旋转部分。 @en Quaternion rotation.
             * @param scale @zh 变换的缩放部分。 @en 3d-vector scale.
             * @param out @zh 存储结果的 AABB。 @en The output AABB.
             */
            transform(m: math.Mat4, pos: math.Vec3 | null, rot: math.Quat | null, scale: math.Vec3 | null, out: AABB): void;
            /**
             * @en
             * Clones this AABB, which will create a new AABB instance with the same value as this AABB. Note that each time `clone` is invoked,
             * a new AABB object will be created, so use `copy` method whenever it could to reduce GC pressure.
             * @zh
             * 克隆一个 AABB，其会创建出一个值跟当前 AABB 一样的实例。注意，每次调用 `clone` 都会创建出新实例，尽可能使用 `copy` 方法以减小 GC 压力。
             * @returns @zh 克隆出的 AABB 实例 @en The cloned AABB instance.
             */
            clone(): AABB;
            /**
             * @en
             * Copies the values from one AABB to this AABB, the process will not generate temporary objects.
             * @zh
             * 将一个 AABB 的值复制到当前 AABB 中，此过程将不会产生临时对象。
             * @param a @zh 被复制的 AABB，此为只读参数。 @en The source object of the copy operation, it's readonly.
             * @returns @zh 当前 AABB 的引用。 @en The reference of this AABB.
             */
            copy(a: AABB | Readonly<AABB>): AABB;
            /**
             * @en Merges a point to this AABB.
             * @zh 合并一个顶点到当前 AABB 中。
             * @param point @zh 3D 世界中某一个位置的顶点。 @en A point in 3D space.
             */
            mergePoint(point: math.IVec3): void;
            /**
             * @en Merges some points to this AABB.
             * @zh 合并一系列顶点到当前 AABB 中。
             * @param points @zh 3D 世界中的顶点列表。 @en A list of points in 3D space.
             */
            mergePoints(points: math.IVec3[]): void;
            /**
             * @en Merges all points in a frustum to this AABB.
             * @zh 合并一个截头锥体的所有顶点到此 AABB 中。
             * @param frustum @zh 输入的截头锥体 @en The frustum object.
             */
            mergeFrustum(frustum: Frustum | Readonly<Frustum>): void;
        }
        /**
         * @en
         * Basic Geometry: Oriented bounding box.
         * @zh
         * 基础几何：方向包围盒。
         */
        export class OBB {
            /**
             * @en
             * Creates a new OBB instance
             * @zh
             * 创建一个新的 OBB 实例。
             * @param cx @zh 形状的相对于原点的 X 坐标。 @en The x coordinate of origin.
             * @param cy @zh 形状的相对于原点的 Y 坐标。 @en The y coordinate of origin.
             * @param cz @zh 形状的相对于原点的 Z 坐标。 @en The z coordinate of origin.
             * @param hw @zh - OBB 宽度的一半。 @en Half the width of the OBB.
             * @param hh @zh - OBB 高度的一半。 @en Half the height of the OBB.
             * @param hl @zh - OBB 长度的一半。 @en Half the length of the OBB.
             * @param ox_1 @zh 方向矩阵参数，第 1 条轴的 x 分量。 @en The x component of the first axis of the OBB.
             * @param ox_2 @zh 方向矩阵参数，第 2 条轴的 x 分量。 @en The x component of the second axis of the OBB.
             * @param ox_3 @zh 方向矩阵参数，第 3 条轴的 x 分量。 @en The x component of the third axis of the OBB.
             * @param oy_1 @zh 方向矩阵参数，第 1 条轴的 y 分量。 @en The y component of the first axis of the OBB.
             * @param oy_2 @zh 方向矩阵参数，第 2 条轴的 y 分量。 @en The y component of the second axis of the OBB.
             * @param oy_3 @zh 方向矩阵参数，第 3 条轴的 y 分量。 @en The y component of the third axis of the OBB.
             * @param oz_1 @zh 方向矩阵参数，第 1 条轴的 z 分量。 @en The z component of the first axis of the OBB.
             * @param oz_2 @zh 方向矩阵参数，第 2 条轴的 z 分量。 @en The z component of the second axis of the OBB.
             * @param oz_3 @zh 方向矩阵参数，第 3 条轴的 z 分量。 @en The z component of the third axis of the OBB.
             * @returns @zh 返回新创建的 OBB 实例。 @en A new OBB instance.
             */
            static create(cx: number, cy: number, cz: number, hw: number, hh: number, hl: number, ox_1: number, ox_2: number, ox_3: number, oy_1: number, oy_2: number, oy_3: number, oz_1: number, oz_2: number, oz_3: number): OBB;
            /**
             * @en
             * Clones a new OBB instance.
             * @zh
             * 克隆一个 OBB 实例。
             * @param a @zh 克隆的目标。 @en The input OBB.
             * @returns @zh The cloned OBB instance.  @en 克隆出的新对象。
             */
            static clone(a: OBB): OBB;
            /**
             * @en
             * Copies the values from one OBB to another.
             * @zh
             * 复制一个 OBB 的值到另一个 OBB 中。
             * @param  out @zh 接受操作的 OBB。 @en The output OBB.
             * @param  a @zh 被复制的 OBB。 @en The input OBB.
             * @returns  @zh 接受操作的 OBB，与 `out` 参数相同。 @en The output OBB, same as the `out` parameter.
             */
            static copy(out: OBB, a: OBB): OBB;
            /**
             * @en
             * Creates a new OBB from two corner points.
             * @zh
             * 用两个点创建一个新的 OBB。
             * @param out @zh - 接受操作的 OBB。 @en The output OBB.
             * @param minPos @zh - OBB 的最小点。 @en The minimum position of the AABB.
             * @param maxPos @zh - OBB 的最大点。 @en The maximum position of the AABB.
             * @returns  @zh 接受操作的 OBB，与 `out` 参数相同。 @en The output OBB, same as the `out` parameter.
             */
            static fromPoints(out: OBB, minPos: math.Vec3, maxPos: math.Vec3): OBB;
            /**
             * @en
             * Sets the components of an OBB to the given values.
             * @zh
             * 将给定 OBB 的属性设置为给定的值。
             * @param out @zh 目标 OBB @en The output OBB instance.
             * @param cx @zh 形状的相对于原点的 X 坐标。 @en The x coordinate of origin.
             * @param cy @zh 形状的相对于原点的 Y 坐标。 @en The y coordinate of origin.
             * @param cz @zh 形状的相对于原点的 Z 坐标。 @en The z coordinate of origin.
             * @param hw @zh - obb 宽度的一半。 @en Half the width of the OBB.
             * @param hh @zh - obb 高度的一半。 @en Half the height of the OBB.
             * @param hl @zh - obb 长度的一半。 @en Half the length of the OBB.
             * @param ox_1 @zh 方向矩阵参数，第 1 条轴的 x 分量。 @en The x component of the first axis of the OBB.
             * @param ox_2 @zh 方向矩阵参数，第 2 条轴的 x 分量。 @en The x component of the second axis of the OBB.
             * @param ox_3 @zh 方向矩阵参数，第 3 条轴的 x 分量。 @en The x component of the third axis of the OBB.
             * @param oy_1 @zh 方向矩阵参数，第 1 条轴的 y 分量。 @en The y component of the first axis of the OBB.
             * @param oy_2 @zh 方向矩阵参数，第 2 条轴的 y 分量。 @en The y component of the second axis of the OBB.
             * @param oy_3 @zh 方向矩阵参数，第 3 条轴的 y 分量。 @en The y component of the third axis of the OBB.
             * @param oz_1 @zh 方向矩阵参数，第 1 条轴的 z 分量。 @en The z component of the first axis of the OBB.
             * @param oz_2 @zh 方向矩阵参数，第 2 条轴的 z 分量。 @en The z component of the second axis of the OBB.
             * @param oz_3 @zh 方向矩阵参数，第 3 条轴的 z 分量。 @en The z component of the third axis of the OBB.
             * @returns  @zh 接受操作的 OBB，与 `out` 参数相同。 @en The output OBB, same as the `out` parameter.
             */
            static set(out: OBB, cx: number, cy: number, cz: number, hw: number, hh: number, hl: number, ox_1: number, ox_2: number, ox_3: number, oy_1: number, oy_2: number, oy_3: number, oz_1: number, oz_2: number, oz_3: number): OBB;
            /**
             * @en
             * The center point of an OBB in local coordinate.
             * @zh
             * 本地坐标的中心点。
             */
            center: math.Vec3;
            /**
             * @en
             * Half the distance across the OBB in each local axis.
             * @zh
             * 长宽高的一半。
             */
            halfExtents: math.Vec3;
            /**
             * @en
             * Orientation matrix.
             * @zh
             * 方向矩阵。
             */
            orientation: math.Mat3;
            /**
             * @en
             * Gets the type of the OBB. Always returns `ShapeType.SHAPE_OBB`.
             * @zh
             * 获取形状的类型，固定返回 `ShapeType.SHAPE_OBB`。
             */
            get type(): number;
            protected readonly _type: number;
            /**
             * @param cx @zh 形状的相对于原点的 X 坐标。 @en The x coordinate of origin.
             * @param cy @zh 形状的相对于原点的 Y 坐标。 @en The y coordinate of origin.
             * @param cz @zh 形状的相对于原点的 Z 坐标。 @en The z coordinate of origin.
             * @param hw @zh - OBB 宽度的一半。 @en Half the width of the OBB.
             * @param hh @zh - OBB 高度的一半。 @en Half the height of the OBB.
             * @param hl @zh - OBB 长度的一半。 @en Half the length of the OBB.
             * @param ox_1 @zh 方向矩阵参数，第 1 条轴的 x 分量。 @en The x component of the first axis of the OBB.
             * @param ox_2 @zh 方向矩阵参数，第 2 条轴的 x 分量。 @en The x component of the second axis of the OBB.
             * @param ox_3 @zh 方向矩阵参数，第 3 条轴的 x 分量。 @en The x component of the third axis of the OBB.
             * @param oy_1 @zh 方向矩阵参数，第 1 条轴的 y 分量。 @en The y component of the first axis of the OBB.
             * @param oy_2 @zh 方向矩阵参数，第 2 条轴的 y 分量。 @en The y component of the second axis of the OBB.
             * @param oy_3 @zh 方向矩阵参数，第 3 条轴的 y 分量。 @en The y component of the third axis of the OBB.
             * @param oz_1 @zh 方向矩阵参数，第 1 条轴的 z 分量。 @en The z component of the first axis of the OBB.
             * @param oz_2 @zh 方向矩阵参数，第 2 条轴的 z 分量。 @en The z component of the second axis of the OBB.
             * @param oz_3 @zh 方向矩阵参数，第 3 条轴的 z 分量。 @en The z component of the third axis of the OBB.
             */
            constructor(cx?: number, cy?: number, cz?: number, hw?: number, hh?: number, hl?: number, ox_1?: number, ox_2?: number, ox_3?: number, oy_1?: number, oy_2?: number, oy_3?: number, oz_1?: number, oz_2?: number, oz_3?: number);
            /**
             * @en
             * Gets the bounding points of this OBB instance.
             * @zh
             * 获取此 OBB 的最小点和最大点。
             * @param minPos @zh 此 OBB 的最小点。 @en The out minimum position of the OBB.
             * @param maxPos @zh 此 OBB 的最大点。 @en The out maximum position of the OBB.
             */
            getBoundary(minPos: math.Vec3, maxPos: math.Vec3): void;
            /**
             * @en
             * Transforms this OBB and store the result to the `out` parameter.
             * @zh
             * 对当前 OBB 的数据进行变换，并存储结果到 `out` 参数中。
             * @param m @zh 变换的矩阵。 @en The transform matrix
             * @param pos @zh 变换的位置部分。 @en 3d-vector translation.
             * @param rot @zh 变换的旋转部分。 @en Quaternion rotation.
             * @param scale @zh 变换的缩放部分。 @en 3d-vector scale.
             * @param out @zh 变换结果的目标 OBB。 @en The output OBB.
             * @note @zh 此方法不会修改当前 OBB 的数据。 @en This method will not modify the data of current OBB.
             */
            transform(m: math.Mat4, pos: math.Vec3, rot: math.Quat, scale: math.Vec3, out: OBB): void;
            /**
             * @en
             * Transforms this OBB by a 4x4 matrix and a quaternion.
             * @zh
             * 根据一个 4x4 矩阵和一个四元数变换此 OBB。
             * @param m @zh 变换的矩阵。 @en The transform matrix.
             * @param rot @zh 变换的旋转部分。 @en The quaternion for rotation.
             * @param out @zh 变换的目标。 @en The output OBB.
             * @note @zh 此方法不会修改当前 OBB 的数据。 @en This method will not modify the data of current OBB.
             */
            translateAndRotate(m: math.Mat4, rot: math.Quat, out: OBB): void;
            /**
             * @en
             * Scales this OBB by a 3d-vector and store the result to the `out` parameter.
             * @zh
             * 根据 3D 向量对此 OBB 的数据进行缩放并将结果存储在 out 参数中。
             * @param scale @zh 缩放值。 @en 3d-vector scale.
             * @param out @zh 缩放的目标。 @en The output OBB.
             * @note @zh 此方法不会修改当前 OBB 的数据。 @en This method will not modify the data of current OBB.
             */
            setScale(scale: math.Vec3, out: OBB): void;
        }
        /**
         * @en
         * Basic Geometry: capsule.
         * @zh
         * 基础几何，胶囊体。
         */
        export class Capsule {
            /**
             * @en
             * Gets the type of this Capsule, always returns `ShapeType.SHAPE_CAPSULE`.
             * @zh
             * 获取此形状的类型，值固定为 `ShapeType.SHAPE_CAPSULE`。
             */
            get type(): number;
            protected readonly _type: number;
            /**
             * @en
             * The radius of the sphere in this capsule.
             * @zh
             * 胶囊体球部的半径。
             */
            radius: number;
            /**
             * @en
             * The distance between the center point of the capsule and the center of the sphere.
             * @zh
             * 胶囊体中心点和球部圆心的距离。
             */
            halfHeight: number;
            /**
             * @en
             * The local orientation of this capsule [0,1,2] => [x,y,z].
             * @zh
             * 胶囊体的本地朝向，映射关系 [0,1,2] => [x,y,z]。
             */
            axis: number;
            /**
             * @en
             * The origin of the capsule.
             * @zh
             * 胶囊体的原点。
             */
            readonly center: math.Vec3;
            /**
             * @en
             * The rotation of the capsule.
             * @zh
             * 胶囊体的旋转。
             */
            readonly rotation: math.Quat;
            /**
             * @internal
             * cache, local center of ellipse
             **/
            readonly ellipseCenter0: math.Vec3;
            /**
             * @internal
             */
            readonly ellipseCenter1: math.Vec3;
            /**
             * @en
             * Constructs a Capsule instance.
             * @zh
             * 构造一个胶囊体实例。
             * @param radius @en The radius of the sphere in this capsule. @zh 胶囊体球部的半径。
             * @param halfHeight @en The distance between the center point of the capsule and the center of the sphere. @zh 胶囊体中心点和球部圆心的距离。
             * @param axis @en The local orientation of this capsule [0,1,2] => [x,y,z]. @zh 胶囊体的本地朝向，映射关系 [0,1,2] => [x,y,z]。
             */
            constructor(radius?: number, halfHeight?: number, axis?: number);
            /**
             * @en
             * Transforms this capsule by a 4x4 matrix and RTS.
             * @zh
             * 使用 4x4 矩阵和 RTS 变换此胶囊体。
             */
            transform(m: math.Mat4, pos: math.IVec3Like, rot: math.IQuatLike, scale: math.IVec3Like, out: Capsule): void;
            /**
             * @en
             * Updates the cache.
             * @zh
             * 更新缓存。
             */
            updateCache(): void;
            /**
             * @en
             * Updates the center points.
             * @zh
             * 更新中心点信息。
             */
            updateLocalCenter(): void;
        }
        /**
         * @en
         * Basic Geometry: frustum.
         * @zh
         * 基础几何：视锥体。
         */
        export class Frustum {
            /**
             * @en Creates an orthographic frustum.
             * @zh 创建一个正交视锥体。
             * @param out @en The result orthographic frustum. @zh 输出的正交视锥体。
             * @param width @en The width of the frustum. @zh 正交视锥体的宽度。
             * @param height @en The height of the frustum. @zh 正交视锥体的高度。
             * @param near @en The near plane of the frustum. @zh 正交视锥体的近平面值。
             * @param far @en The far plane of the frustum. @zh 正交视锥体的远平面值。
             * @param transform @en The transform matrix of the frustum. @zh 正交视锥体的变换矩阵。
             * @returns @en The result frustum, same as the `out` parameter. @zh 存储结果的视锥体，与 `out` 参数为同一个对象。
             */
            static createOrthographic(out: Frustum, width: number, height: number, near: number, far: number, transform: math.Mat4): void;
            /**
             * @en Creates an orthographic frustum.
             * @zh 创建一个正交视锥体。
             * @param out @en The result orthographic frustum. @zh 输出的正交视锥体。
             * @param width @en The width of the frustum. @zh 正交视锥体的宽度。
             * @param height @en The height of the frustum. @zh 正交视锥体的高度。
             * @param near @en The near plane of the frustum. @zh 正交视锥体的近平面值。
             * @param far @en The far plane of the frustum. @zh 正交视锥体的远平面值。
             * @param transform @en The transform matrix of the frustum. @zh 正交视锥体的变换矩阵。
             * @returns @en The result frustum, same as the `out` parameter. @zh 存储结果的视锥体，与 `out` 参数为同一个对象。
             *
             * @deprecated since v3.8.0, please use [[createOrthographic]] instead.
             */
            static createOrtho(out: Frustum, width: number, height: number, near: number, far: number, transform: math.Mat4): void;
            /**
             * @en Creates a perspective frustum.
             * @zh 创建一个透视视锥体。
             * @param aspect @en The aspect ratio of the camera. @zh 相机视图的长宽比。
             * @param fov @en The field of view of the camera. @zh 相机的视角大小。
             * @param near @en The near plane of the frustum. @zh 视锥体的近平面值。
             * @param far @en The far plane of the frustum. @zh 视锥体的远平面值。
             * @param transform @en The transform matrix. @zh 变换矩阵。
             * @returns @en The result frustum, same as the `out` parameter. @zh 存储结果的视锥体，与 `out` 参数为同一个对象。
             */
            static createPerspective(out: Frustum, aspect: number, fov: number, near: number, far: number, transform: math.Mat4): void;
            /**
             * @en Creates a frustum from an AABB instance.
             * @zh 根据一个 AABB 实例创建一个视锥体。
             * @param out @en The result frustum. @zh 输出的视锥体对象。
             * @param aabb @en The AABB to create the result frustum. @zh 用于创建视锥体 AABB。
             * @returns @en The result frustum, same as the `out` parameter. @zh 存储结果的视锥体，与 `out` 参数为同一个对象。
             *
             * @deprecated since v3.8.0, please use [[createOrthographic]] instead.
             */
            static createFromAABB(out: Frustum, aabb: AABB | Readonly<AABB>): Frustum;
            /**
             * @en Calculates a split frustum.
             * @zh 计算出一个分割的视锥体。
             * @param start @en The split start position. @zh 分割开始位置。
             * @param end @en The split end position. @zh 分割末尾位置。
             * @param aspect @en The aspect ratio of the camera. @zh 相机视图的长宽比。
             * @param fov @en The field of view of the camera. @zh 相机的视角大小。
             * @param m @en The transform matrix. @zh 变换矩阵。
             *
             * @deprecated since v3.8.0, please use [[createPerspective]] instead.
             */
            split(start: number, end: number, aspect: number, fov: number, m: math.Mat4): void;
            /**
             * @en
             * Creates a new frustum.
             * @zh
             * 创建一个新的视椎体。
             * @returns @en An empty frustum. @zh 一个空视椎体。
             */
            static create(): Frustum;
            /**
             * @en
             * Clones a frustum.
             * @zh
             * 克隆一个视椎体。
             * @param f @en The frustum to clone from. @zh 用于克隆的视椎体。
             * @return @en The cloned frustum. @zh 克隆出的新视椎体。
             */
            static clone(f: Frustum): Frustum;
            /**
             * @en
             * Copies the values from one frustum to another.
             * @zh
             * 从一个视锥体拷贝到另一个视锥体。
             * @param out @en The result frustum @zh 用于存储拷贝数据的截锥体
             * @param f @en The frustum to copy from @zh 用于克隆的截锥体
             * @returns @en The result frustum, same as the `out` parameter. @zh 存储结果的视锥体，与 `out` 参数为同一个对象。
             */
            static copy(out: Frustum, f: Readonly<Frustum>): Frustum;
            /**
             * @en
             * Sets whether to use accurate intersection testing function on this frustum.
             * @zh
             * 设置是否在此截锥体上使用精确的相交测试函数。
             *
             * @deprecated since v3.8.0 no need to set accurate flag since it doesn't affect the calculation at all.
             */
            set accurate(b: boolean);
            /**
             * @en
             * Gets the type of the shape. The value may be `ShapeType.SHAPE_FRUSTUM_ACCURATE` or `ShapeType.SHAPE_FRUSTUM`.
             * @zh
             * 获取形状的类型。值可能为 `ShapeType.SHAPE_FRUSTUM_ACCURATE` 或 `ShapeType.SHAPE_FRUSTUM`。
             * @readonly
             */
            get type(): number;
            /**
             * @en
             * The 6 planes of the frustum.
             * @zh
             * 视椎体的 6 个面。
             */
            planes: Plane[];
            /**
             * @en
             * The 8 vertices of the frustum.
             * @zh
             * 视椎体的 8 个顶点。
             */
            vertices: math.Vec3[];
            protected _type: number;
            constructor();
            /**
             * @en
             * Updates the frustum information according to the given transform matrix.
             * Note that the resulting planes are not normalized under normal mode.
             * @zh
             * 根据给定的变换矩阵更新截锥体信息，注意得到的平面不是在标准模式下归一化的。
             * @param m @en The view-projection matrix. @zh 视图投影矩阵。
             * @param inv @en The inverse view-projection matrix. @zh 视图投影逆矩阵。
             */
            update(m: math.Mat4, inv: math.Mat4): void;
            /**
             * @en
             * Transforms this frustum.
             * @zh
             * 变换此视锥体。
             * @param mat @en The transform matrix. @zh 变换矩阵。
             */
            transform(mat: math.Mat4): void;
            /**
             * @en Makes the frustum empty, all vertices will be zero values.
             * @zh 置空此视锥体，所有顶点将被赋值为 0。
             */
            zero(): void;
            /**
             * @en Updates all six planes of the frustum.
             * @zh 更新视锥体的所有面数据。
             */
            updatePlanes(): void;
        }
        /**
         * @en
         * A key frame in the curve.
         * @zh
         * 曲线中的一个关键帧。
         */
        export class Keyframe {
            /**
             * @en Current frame time.
             * @zh 当前帧时间。
             */
            time: number;
            /**
             * @en Current frame value.
             * @zh 当前帧的值。
             */
            value: number;
            /**
             * @en In tangent value.
             * @zh 左切线。
             */
            inTangent: number;
            /**
             * @en Out tangent value.
             * @zh 右切线。
             */
            outTangent: number;
        }
        /**
         * @en
         * Describe a curve in which three times Hermite interpolation is used for each adjacent key frame.
         * @zh
         * 描述一条曲线，其中每个相邻关键帧采用三次hermite插值计算。
         */
        export class AnimationCurve {
            /**
             * For internal usage only.
             * @internal
             */
            get _internalCurve(): RealCurve;
            /**
             * @en
             * The key frame of the curve.
             * @zh
             * 曲线的关键帧。
             */
            get keyFrames(): Keyframe[];
            set keyFrames(value: Keyframe[]);
            /**
             * @en
             * Loop mode [[AnimationClip.WrapMode]] when the sampling time exceeds the left end.
             * @zh
             * 当采样时间超出左端时采用的循环模式[[AnimationClip.WrapMode]]。
             */
            get preWrapMode(): __private._cocos_core_geometry_curve__WrapModeMask;
            set preWrapMode(value: __private._cocos_core_geometry_curve__WrapModeMask);
            /**
             * @en
             * Cycle mode [[AnimationClip.WrapMode]] when the sampling time exceeds the right end.
             * @zh
             * 当采样时间超出右端时采用的循环模式[[AnimationClip.WrapMode]]。
             */
            get postWrapMode(): __private._cocos_core_geometry_curve__WrapModeMask;
            set postWrapMode(value: __private._cocos_core_geometry_curve__WrapModeMask);
            /**
             * @en Construct a curve with key frames
             * @zh 通过关键帧构造一条曲线。
             * @param keyFrames @zh 关键帧 @en Key frames
             */
            constructor(keyFrames?: Keyframe[] | null | RealCurve);
            /**
             * @en
             * Add a keyframe.
             * @zh
             * 添加一个关键帧。
             * @param keyFrame @en A keyframe. @zh 关键帧。
             */
            addKey(keyFrame: Keyframe | null): void;
            /**
             * @ignore
             * @param time
             */
            evaluate_slow(time: number): number;
            /**
             * @en
             * Calculate the curve interpolation at a given point in time.
             * @zh
             * 计算给定时间点的曲线插值。
             * @param time @en The time. @zh 时间。
             */
            evaluate(time: number): number;
            /**
             * @ignore
             * @param optKey
             * @param leftIndex
             * @param rightIndex
             */
            calcOptimizedKey(optKey: __private._cocos_core_geometry_curve__OptimizedKey, leftIndex: number, rightIndex: number): void;
        }
        export enum SplineMode {
            /**
             * @en
             * Broken line:
             * Each knot is connected with a straight line from the beginning to the end to form a curve. At least two knots.
             * @zh
             * 每个结从头到尾用一条直线相连，形成一条曲线。 至少存在两个结点。
             */
            LINEAR = 0,
            /**
             * @en
             * Piecewise Bezier curve:
             * Every four knots form a curve. Total knots number must be a multiple of 4.
             * Each curve passes only the first and fourth knots, and does not pass through the middle two control knots.
             *
             * If you need a whole continuous curve:
             * (1) Suppose the four knots of the previous curve are A, B, C, D
             * (2) The four knots of the next curve must be D, E, F, G
             * (3) C and E need to be symmetrical about D
             *
             * @zh
             * 分段贝塞尔曲线：
             * 每四个结形成一条曲线。 总节数必须是 4 的倍数。
             * 每条曲线只通过第一个和第四个结点，不通过中间两个控制结点。
             *
             * 如果你需要一条完整的连续曲线：
             * (1) 假设前面曲线的四个结点分别是 A, B, C, D
             * (2) 下一条曲线的四个结点必须是 D, E, F, G
             * (3) C 和 E 需要关于 D 对称
             */
            BEZIER = 1,
            /**
             * @en
             * Catmull Rom curve:
             * All knots(including start & end knots) form a whole continuous curve. At least two knots.
             * The whole curve passes through all knots.
             *
             * @zh
             * Catmull Rom 曲线：
             * 所有结点（包括起始结点和结束结点）形成一条完整的连续曲线。 至少存在两个结点。
             * 整条曲线穿过所有结点。
             */
            CATMULL_ROM = 2
        }
        /**
         * @en
         * Basic Geometry: Spline.
         * @zh
         * 基础几何：Spline。
         */
        export class Spline {
            /**
             * @en
             * Creates a spline instance.
             * @zh
             * 创建一个 Spline 实例。
             * @param mode @en The mode to create the Spline instance. @zh 用于创建 Spline 实例的模式。
             * @param knots @en The knots to create the Spline instance. @zh 用于创建 Spline 实例的结点列表。
             * @returns @en The created Spline instance. @zh 创建出的 Spline 实例。
             */
            static create(mode: SplineMode, knots?: math.Vec3[]): Spline;
            /**
             * @en
             * Clones a Spline instance.
             * @zh
             * 克隆一个 Spline 实例。
             * @param s @en The Spline instance to be cloned. @zh 用于克隆的 Spline 实例。
             * @returns @en The cloned Spline instance. @zh 克隆出的 Spline 实例。
             */
            static clone(s: Spline): Spline;
            /**
             * @en
             * Copies the values of a Spline instance to another.
             * @zh
             * 拷贝一个 Spline 实例的值到另一个中。
             * @param out @en The target Spline instance to copy to. @zh 拷贝目标 Spline 实例。
             * @param s @en The source Spline instance to copy from. @zh 拷贝源 Spline 实例。
             * @returns @en The target Spline instance to copy to, same as the `out` parameter. @zh 拷贝目标 Spline 实例，值与 `out` 参数相同。
             */
            static copy(out: Spline, s: Spline): Spline;
            /**
             * @en
             * Gets the type of this Spline instance, always returns `ShapeType.SHAPE_SPLINE`.
             * @zh
             * 获取此 Spline 的类型，固定返回 `ShapeType.SHAPE_SPLINE`
             */
            get type(): number;
            /**
             * @en
             * Gets the mode of this Spline instance.
             * @zh
             * 获取当前 Spline 实例的模式。
             */
            get mode(): SplineMode;
            /**
             * @en
             * Gets all knots of this Spline instance.
             * @zh
             * 获取当前 Spline 实例的所有结点。
             */
            get knots(): Readonly<math.Vec3[]>;
            /**
             * @en
             * Sets the mode and knots to this Spline instance.
             * @zh
             * 给当前 Spline 实例设置模式和结点。
             * @param mode @en The mode to be set to this Spline instance. @zh 要设置到当前 Spline 实例的模式。
             * @param knots @en The knots to be set to this spline instance. @zh 要设置到当前 Spline 实例的结点列表。
             */
            setModeAndKnots(mode: SplineMode, knots: math.Vec3[]): void;
            /**
             * @en
             * Clears all knots of this Spline instance.
             * @zh
             * 清空当前 Spline 实例的所有结点。
             */
            clearKnots(): void;
            /**
             * @en
             * Gets the knot count of this Spline instance.
             * @zh
             * 获取当前 Spline 实例的结点数量。
             * @returns @en The knot count of this Spline instance. @zh 当前 Spline 实例的结点数量。
             */
            getKnotCount(): number;
            /**
             * @en
             * Adds a knot to this Spline instance.
             * @zh
             * 给当前 Spline 实例添加一个结点。
             * @param knot @en The knot to add to this Spline instance. @zh 要添加到当前 Spline 实例的结点。
             */
            addKnot(knot: math.Vec3): void;
            /**
             * @en
             * Inserts a knot to the specified position of this Spline instance.
             * @zh
             * 插入一个结点到当前 Spline 实例的指定位置。
             * @param index @en The position of this Spline instance to be inserted. @zh 要插入到此 Spline 实例的位置。
             * @param knot @en The knot to be inserted. @zh 要插入的结点。
             */
            insertKnot(index: number, knot: math.Vec3): void;
            /**
             * @en
             * Removes a knot at the specified position of this Spline instance.
             * @zh
             * 移除当前 Spline 实例的指定位置的一个结点。
             * @param index
             */
            removeKnot(index: number): void;
            /**
             * @en
             * Sets a knot to the specified position of this Spline instance.
             * @zh
             * 为当前 Spline 实例的指定位置设置结点信息。
             * @param index @en The specified position of this Spline instance. @zh 要设置结点的指定位置。
             * @param knot @en The knot to be set to the specified position. @zh 要设置的结点。
             */
            setKnot(index: number, knot: math.Vec3): void;
            /**
             * @en
             * Gets the knot of the specified position of this Spline instance.
             * @zh
             * 获取当前 Spline 实例指定位置的结点。
             * @param index @en The specified position of this Spline instance. @zh 要设置结点的指定位置。
             * @returns @en The knot of the specified position of this Spline instance. @zh 当前 Spline 实例指定位置的结点。
             */
            getKnot(index: number): Readonly<math.Vec3>;
            /**
             * @en
             * Gets a point at t with repect to the `index` segment of curve or the whole curve.
             * @zh
             * 获取 t 处相对于某段或整条曲线的点。
             * @param t @en The factor with a range of [0.0, 1.0]. @zh 0.0 到 1.0 的因子。
             * @param index @en The knot index of this Spline instance, default value is the whole curve. @zh 当前 Spline 实例的某个结点索引，默认值为整条曲线。
             * @returns @en The point matches the input `t` factor and `index`. @zh 满足输入 `t` 参数和 `index` 参数的点。
             */
            getPoint(t: number, index?: number): math.Vec3;
            /**
             * @en
             * Gets points from 0 to 1 uniformly with repect to the `index` segment of curve or the whole curve.
             * @zh
             * 获取相对与某段或整条曲线上的 n 个数量的点信息。
             * @param num @en The count of points needed. @zh 需要的点的数量。
             * @param index @en The knot index of this Spline instance, default value is the whole curve. @zh 当前 Spline 实例的某个结点索引，默认值为整条曲线。
             * @returns @en The points with `num` size at the `index` segment or the whole curve. @zh 曲线某段或者整条曲线上的 `num` 个点。
             */
            getPoints(num: number, index?: number): math.Vec3[];
        }
        /**
         * @en
         * The raycast mode.
         * @zh
         * 射线检测模式。
         */
        export enum ERaycastMode {
            /**
             * @en
             * Detects and records all data.
             * @zh
             * 检测并记录所有的数据。
             */
            ALL = 0,
            /**
             * @en
             * Detects all data, but records only the most recent data.
             * @zh
             * 检测所有，但只记录最近的数据。
             */
            CLOSEST = 1,
            /**
             * @en
             * Once the test is successful, the test is stopped and the data is recorded only once.
             * @zh
             * 一旦检测成功就停止检测，只会记录一次数据。
             */
            ANY = 2
        }
        /**
         * @en
         * The storage structure of the raycast results.
         * @zh
         * 射线检测结果的存储结构。
         */
        export interface IRaySubMeshResult {
            /**
             * @en
             * The distance between the hit point and the ray.
             * @zh
             * 击中点和射线的距离。
             */
            distance: number;
            /**
             * @en
             * The index of the triangle vertex 0。
             * @zh
             * 三角形顶点0的索引。
             */
            vertexIndex0: number;
            /**
             * @en
             * The index of the triangle vertex 1。
             * @zh
             * 三角形顶点1的索引
             */
            vertexIndex1: number;
            /**
             * @en
             * The index of the triangle vertex 2。
             * @zh
             * 三角形顶点2的索引
             */
            vertexIndex2: number;
        }
        /**
         * @en
         * The optional param structure of the `raySubMesh`.
         * @zh
         * `raySubMesh`的可选参数结构。
         */
        export interface IRaySubMeshOptions {
            /**
             * @en
             * The raycast mode，`ANY` by default.
             * @zh
             * 射线检测模式：[0, 1, 2]=>[`ALL`, `CLOSEST`, `ANY`]
             */
            mode: ERaycastMode;
            /**
             * @en
             * The maximum distance of the raycast, `Infinity` by default.
             * @zh
             * 射线检测的最大距离，默认为`Infinity`。
             */
            distance: number;
            /**
             * @en
             * An array used to store the results of a ray detection.
             * @zh
             * 用于存储射线检测结果的数组。
             */
            result?: IRaySubMeshResult[];
            /**
             * @en
             * Whether to detect the double-sided or not，`false` by default.
             * @zh
             * 是否检测双面，默认为`false`。
             */
            doubleSided?: boolean;
        }
        /**
         * @en
         * The optional param structure of the `rayMesh`.
         * @zh
         * `rayMesh`的可选参数结构。
         */
        export interface IRayMeshOptions extends IRaySubMeshOptions {
            /**
             * @en
             * The index of the sub mesh.
             * @zh
             * 子网格的索引。
             */
            subIndices?: number[];
        }
        /**
         * @en
         * The optional parameter structure of the `rayModel`.
         * @zh
         * `rayModel`的可选参数结构。
         */
        export type IRayModelOptions = IRayMeshOptions;
        /**
         * @en
         * Alias of [[geometry.Line]]
         * @zh
         * [[geometry.Line]] 别名类
         *
         * @deprecated Since v3.0, please use Line instead
         */
        export class line extends Line {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.Plane]]
         *
         * @zh
         * [[geometry.Plane]] 别名类
         *
         * @deprecated Since v3.0, please use Plane instead
         */
        export class plane extends Plane {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.Ray]]
         * @zh
         * [[geometry.Ray]] 别名类
         * @deprecated Since v3.0, please use Ray instead
         */
        export class ray extends Ray {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.Triangle]]
         *
         * @zh
         * [[geometry.Triangle]] 别名类
         * @deprecated Since v3.0, please use Triangle instead
         */
        export class triangle extends Triangle {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.Sphere]]
         *
         * @zh
         * [[geometry.Sphere]] 别名类
         * @deprecated Since v3.0, please use Sphere instead
         */
        export class sphere extends Sphere {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.AABB]]
         *
         * @zh
         * [[geometry.AABB]] 别名类
         * @deprecated Since v3.0, please use AABB instead
         */
        export class aabb extends AABB {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.OBB]]
         *
         * @zh
         * [[geometry.OBB]] 别名类
         * @deprecated Since v3.0, please use OBB instead
         */
        export class obb extends OBB {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.Capsule]]
         *
         * @zh
         * [[geometry.Capsule]] 别名类
         * @deprecated Since v3.0, please use Capsule instead
         */
        export class capsule extends Capsule {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.Frustum]]
         *
         * @zh
         * [[geometry.Frustum]] 别名类
         * @deprecated Since v3.0, please use Frustum instead
         */
        export class frustum extends Frustum {
            constructor();
        }
    }
    export const VERSION = "3.8.5";
    /**
     * @en
     * The main namespace of Cocos engine, all engine core classes, functions, properties and constants are defined in this namespace.
     * @zh
     * Cocos引擎的主要命名空间，引擎代码中所有的类，函数，属性和常量都在这个命名空间中定义。
     * @deprecated
     */
    export const cclegacy: Record<string, any> & {
        _global: typeof globalThis;
    };
    /**
     * @en
     * Defines a BitMask type. The editor will display different inspector depending on this data type.  It may define some properties to the object.
     * The keys of new properties are the integer type values, and the values are corresponding keys. See the example below.
     * keys.
     * @zh
     * 定义一个位掩码类型。编辑器会根据这个数据类型显示不同的显示界面。它可能会在对象添加新属性。新属性的 key 是原来的整型 value，value 是对应的 key。参考下面的例子。
     * @param obj
     * @en A JavaScript literal object containing BitMask names and values.
     * @zh 包含 BitMask 名称和值的 JavaScript 文字对象。
     * @returns @en The defined BitMask type @zh 定义的位掩码类型。
     * @example
     * ```ts
     * // `type1` and `type2` are single-selected.
     * let obj = {
     *     type1: 0,
     *     type2: 1 << 2,
     * }
     *
     * // `type1` and `type2` are multiple-selected.
     * // New properties are added to obj, obj now is
     * // {
     * //     type1: 0,
     * //     type2: 1<< 2,
     * //     0: type1,
     * //     4: type2
     * // }
     * BitMask(obj);
     * ```
     */
    export function BitMask<T extends object>(obj: T): T;
    export namespace BitMask {
        export var isBitMask: (BitMaskType: any) => any;
        export var getList: (BitMaskDef: any) => any;
        export var update: (BitMaskDef: any) => any;
    }
    /**
     * @en
     * Define an enum type. <br/>
     * If a enum item has a value of -1, it will be given an Integer number according to it's order in the list.<br/>
     * Otherwise it will use the value specified by user who writes the enum definition.
     *
     * @zh
     * 定义一个枚举类型。<br/>
     * 用户可以把枚举值设为任意的整数，如果设为 -1，系统将会分配为上一个枚举值 + 1。
     *
     * @param obj
     * @en A JavaScript literal object containing enum names and values, or a TypeScript enum type.
     * @zh 包含枚举名和值的 JavaScript literal 对象，或者是一个 TypeScript enum 类型。
     * @return @en The defined enum type. @zh 定义的枚举类型。
     */
    export function Enum<T extends object>(obj: T): T;
    export namespace Enum {
        export var update: <T extends object>(obj: T) => T;
        export var isEnum: <EnumT extends object>(enumType: EnumT) => boolean;
        export var getList: <EnumT extends object>(enumType: EnumT) => readonly __private._cocos_core_value_types_enum__Enum.Enumerator<EnumT>[];
        export var sortList: <EnumT extends object>(enumType: EnumT, compareFn: (a: any, b: any) => number) => void;
    }
    /**
     * Make the enum type `enumType` as enumeration so that Creator may identify, operate on it.
     * Formally, as a result of invocation on this function with enum type `enumType`:
     * - `Enum.isEnum(enumType)` returns `true`;
     * - `Enum.getList(enumType)` returns the enumerators of `enumType`.
     * @param
     * @en enumType An enum type, eg, a kind of type with similar semantic defined by TypeScript.
     * @zh 枚举类型，例如 TypeScript 中定义的类型。
     */
    export function ccenum<EnumT extends object>(enumType: EnumT): void;
    /**
     * @en The base class of all value types.
     * @zh 所有值类型的基类。
     */
    export class ValueType {
        /**
         * @en
         * Clone the current object. The clone result of the object should be equal to the current object,
         * i.e. satisfy `this.equals(this, value.clone())`.
         * The base version of this method do nothing and returns `this'.
         * The derived class **must** rewrite this method and the returned object should not be `this`, i.e. satisfy `this !== this.clone()`.
         * @zh
         * 克隆当前值。克隆的结果值应与当前值相等，即满足 `this.equals(this, value.clone())`。
         * 本方法的基类版本简单地返回 `this`；
         * 派生类**必须**重写本方法，并且返回的对象不应当为 `this`，即满足 `this !== this.clone()`。
         * @returns @en The cloned object. @zh 克隆的对象。
         */
        clone(): ValueType;
        /**
         * @en
         * Check whether the current object is equal to the specified object.
         * This check should be interchangeable, i.e. satisfy `this.equals(other) === other.equals(this)`.
         * The base version of this method will returns `false'.
         * @zh
         * 判断当前值是否与指定值相等。此判断应当具有交换性，即满足 `this.equals(other) === other.equals(this)`。
         * 本方法的基类版本简单地返回 `false`。
         * @param other @en The other object @zh 指定值。
         * @returns @en `true` if equal, otherwise returns `false` @zh 如果相等，则返回 `true`，否则返回 `false`。
         */
        equals(other: this): boolean;
        /**
         * @en
         * Set the property values of the current object with the given object.
         * The base version of this method will returns `this' and the derived class **must** rewrite this method.
         * @zh
         * 赋值当前值使其与指定值相等。
         * 本方法的基类版本简单地返回 `this`，派生类**必须**重写本方法。
         * @param other @en The other object. @zh 指定值。
         */
        set(other: this): void;
        /**
         * @en
         * Convert the current object to a string.
         * The base version of this method will returns an empty string.
         * @zh
         * 返回当前值的字符串表示。
         * 本方法的基类版本返回空字符串。
         * @returns @en The string representation of the current value. @zh 当前值的字符串表示。
         */
        toString(): string;
    }
    export namespace js {
        /**
         * @en
         * ID generator for runtime.
         *
         * @zh
         * 运行时 ID 生成器。
         */
        export class IDGenerator {
            /**
             * @en
             * The global id generator might have a conflict problem once every 365 days,
             * if the game runs at 60 FPS and each frame 4760273 counts of new id are requested.
             *
             * @zh
             * 全局的 id 生成器，如果游戏以 60 FPS 运行，每帧获取 4760273 个新 id, 则可能在 365 天后发生冲突。
             */
            static global: IDGenerator;
            /**
             * @en A number to record current id. It may increase when invoke `getNewId()`. Should use
             * `getNewId()` to get a unique id.
             * @zh 记录当前 id 值。调用 `getNewId()` 时，它可能被加1。应该使用 `getNewId()` 获取唯一的 id。
             */
            id: number;
            /**
             * @en A string value indicates the category this IDGenerator belongs to. It will be an empty
             * string if not be assigned by passed parameter in constructor.
             * @zh 用于标识该 IDGenerator 所属的类别。如果构造函数没有传参数对它赋值的话，它将是一个空字符串。
             */
            prefix: string;
            /**
             * @en Construct a new id generator.
             * @zh 构造一个新的 id 生成器。
             *
             * @param category @en You can specify a unique category to avoid id collision with other instance of IdGenerator.
             * @zh 你能指定一个唯一的标识用于避免与其他 id 生成器冲突。
             */
            constructor(category?: string);
            /**
             * @en Gets a unique id. @zh 获取唯一的 id。
             * @returns @en The unique id. It has the form `prefix+id`, for example `scene55`, `scene` is `prefix`, `55` is `id`.
             * @zh 唯一的 id。它的形式是 `prefix+id`，比如 `scene55`，`scene` 是 prefix，`55` 是 `id`。
             */
            getNewId(): string;
        }
        /**
         * @en
         * A fixed-length object pool designed for general type.<br>
         * The implementation of this object pool is very simple.
         * It can help you to improve your game performance for objects which need frequent release and recreate operations.<br/>
         * @zh
         * 长度固定的对象缓存池，可以用来缓存各种对象类型。<br/>
         * 这个对象池的实现非常精简，它可以帮助您提高游戏性能，适用于优化对象的反复创建和销毁。
         * @class js.Pool
         * @example
         * ```
         *
         * Example 1:
         *
         * function Details () {
         *     this.uuidList = [];
         * };
         * Details.prototype.reset = function () {
         *     this.uuidList.length = 0;
         * };
         * Details.pool = new js.Pool(function (obj) {
         *     obj.reset();
         * }, 5);
         * Details.pool.get = function () {
         *     return this._get() || new Details();
         * };
         *
         * var detail = Details.pool.get();
         * ...
         * Details.pool.put(detail);
         *
         * Example 2:
         *
         * function Details (buffer) {
         *    this.uuidList = buffer;
         * };
         * ...
         * Details.pool.get = function (buffer) {
         *     var cached = this._get();
         *     if (cached) {
         *         cached.uuidList = buffer;
         *         return cached;
         *     }
         *     else {
         *         return new Details(buffer);
         *     }
         * };
         *
         * var detail = Details.pool.get( [] );
         * ...
         * ```
         */
        export class Pool<T> {
            /**
             * @en
             * The current number of available objects, the default is 0. It will gradually increase with the recycle of the object,
             * the maximum will not exceed the size specified when the constructor is called.
             * @zh
             * 当前可用对象数量，一开始默认是 0，随着对象的回收会逐渐增大，最大不会超过调用构造函数时指定的 size。
             * @default 0
             */
            count: number;
            /**
             * @en
             * Gets an object from pool.
             * @zh 从对象池中获取一个对象。
             * @returns @en An object or null if this pool doesn't contain any object.
             * @zh 获取的对象。如果对象池中没有对象，返回 null。
             */
            get(): T | null;
            /**
             * @en Constructor. @zh 构造函数。
             * @param cleanupFunc @en Callback method used to process the cleanup logic when the object is recycled.
             * @zh 当对象放入对象池时，用来执行清理逻辑的回调函数。
             * @param size @en Pool size. @zh 对象池大小。
             */
            constructor(cleanup: __private._cocos_core_utils_pool__CleanUpFunction<T>, size: number);
            /**
             * @en Constructor. @zh 构造函数。
             * @param size @en Pool size. @zh 对象池大小。
             */
            constructor(size: number);
            /**
             * @en
             * Gets an object from pool.
             * @zh 从对象池中获取一个对象。
             * @returns @en An object or null if this pool doesn't contain any object.
             * @zh 获取的对象。如果对象池中没有对象，返回 null。
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _get(): T | null;
            /**
             * @en Put an object into the pool.
             * @zh 向对象池返还一个不再需要的对象。
             */
            put(obj: T): void;
            /**
             * @en Resize the pool.
             * @zh 设置对象池容量。
             * @param length @en New pool size.
             * @zh 新对象池大小。
             */
            resize(length: number): void;
        }
        export namespace array {
            /**
             * @zh
             * 移除指定索引的数组元素。
             * @en
             * Removes the array item at the specified index.
             * @param array @zh 被操作的数组。@en The array to be operated.
             * @param index @zh 待移除元素的索引。@en The index of the element to be removed.
             */
            export function removeAt<T>(array: T[], index: number): void;
            /**
             * @zh
             * 移除指定索引的数组元素。
             * 此函数十分高效，但会改变数组的元素次序。
             * @en
             * Removes the array item at the specified index.
             * It's faster but the order of the array will be changed.
             * @param array @zh 被操作的数组。@en The array to be operated.
             * @param index @zh 待移除元素的索引。@en The index of the element to be removed.
             */
            export function fastRemoveAt<T>(array: T[], index: number): void;
            /**
             * @zh
             * 移除首个指定的数组元素。判定元素相等时相当于于使用了 `Array.prototype.indexOf`。
             * @en
             * Removes the first occurrence of a specific object from the array.
             * Decision of the equality of elements is similar to `Array.prototype.indexOf`.
             * @param array @zh 被操作的数组。@en The array to be operated.
             * @param value @zh 待移除元素。@en The value to be removed.
             */
            export function remove<T>(array: T[], value: T): boolean;
            /**
             * @zh
             * 移除首个指定的数组元素。判定元素相等时相当于于使用了 `Array.prototype.indexOf`。
             * 此函数十分高效，但会改变数组的元素次序。
             * @en
             * Removes the first occurrence of a specific object from the array.
             * Decision of the equality of elements is similar to `Array.prototype.indexOf`.
             * It's faster but the order of the array will be changed.
             * @param array @zh 被操作的数组。@en The array to be operated.
             * @param value @zh 待移除元素。@en The value to be removed.
             */
            export function fastRemove<T>(array: T[], value: T): void;
            /**
             * @zh
             * 移除首个使谓词满足的数组元素。
             * @en
             * Removes the first occurrence of a specific object from the array where `predicate` is `true`.
             * @param array @zh 被操作的数组。@en The array to be operated.
             * @param predicate @zh 一元谓词，如果要元素的话，需要返回 true。@en unary predicate which returns true if the element should be removed.
             */
            export function removeIf<T>(array: T[], predicate: (value: T) => boolean): T | undefined;
            /**
             * @zh
             * 验证数组的类型。
             * 此函数将用 `instanceof` 操作符验证每一个元素。
             * @en
             * Verify array's Type.
             * This function tests each element using `instanceof` operator.
             * @param array @zh 待验证的数组。@en The array to be verified.
             * @param type @zh 用来判断数组元素的数据类型。@en The type used to verify the element type.
             * @returns @zh 当每一个元素都是指定类型时返回 `true`，否则返回 `false`。@en Return true if all elements of the array is the same type, false others.
             */
            export function verifyType<T extends Function>(array: any[], type: T): array is T[];
            /**
             * @zh
             * 移除多个数组元素。
             * @en
             * Removes multiple array elements.
             * @param array @zh 被操作的数组。@en The array to be operated.
             * @param removals @zh 所有待移除的元素。此数组的每个元素所对应的首个源数组的元素都会被移除。
             *                 @en The values to be removed. If a value appears multiple times in the array, only the first math element will be removed.
             */
            export function removeArray<T>(array: T[], removals: T[]): void;
            /**
             * @zh
             * 在数组的指定索引上插入对象。
             * @en
             * Inserts some objects at specified index.
             * @param array @zh 被操作的数组。@en The array to be operated.
             * @param objects @zh 插入的所有对象。@en The objects to be inserted.
             * @param index @zh 插入的索引。@en The index to insert at.
             * @returns @zh 传入的 `array`。@en The passed in `array`.
             */
            export function appendObjectsAt<T>(array: T[], objects: T[], index: number): T[];
            /**
             * @zh
             * 返回数组是否包含指定的元素。
             * @en
             * Determines whether the array contains a specific element.
             * @param array @zh 被查询的数组 @en The array to be checked.
             * @param value @zh 用来查询的值 @en The value used to check for.
             * @returns @zh true 如果包含该元素，否则返回 false。@en true if contains the value, false else.
             */
            export function contains<T>(array: T[], value: T): boolean;
            /**
             * @zh
             * 拷贝数组。
             * @en
             * Copy an array.
             * @param array @zh 用来拷贝的数组。@en The array to be copied from.
             * @returns @zh 数组的副本。@en A new array has the same values as `array`.
             */
            export function copy<T>(array: T[]): T[];
            /**
             * @example
             * ```
             * import { js } from 'cc';
             * var array = [0, 1, 2, 3, 4];
             * var iterator = new js.array.MutableForwardIterator(array);
             * for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
             *     var item = array[iterator.i];
             *     ...
             * }
             * ```
             */
            export class MutableForwardIterator<T> {
                array: T[];
                i: number;
                constructor(array: T[]);
                get length(): number;
                set length(value: number);
                remove(value: T): void;
                removeAt(i: number): void;
                fastRemove(value: T): void;
                fastRemoveAt(i: number): void;
                push(item: T): void;
            }
        }
        /**
         * @deprecated since v3.7.0, `js.js` is deprecated, please access `js` directly instead.
         */
        export const js: {
            IDGenerator: typeof IDGenerator;
            Pool: typeof Pool;
            array: typeof array;
            isNumber: typeof isNumber;
            isString: typeof isString;
            isEmptyObject: typeof isEmptyObject;
            getPropertyDescriptor: typeof getPropertyDescriptor;
            addon: typeof addon;
            mixin: typeof mixin;
            extend: typeof extend;
            getSuper: typeof getSuper;
            isChildClassOf: typeof isChildClassOf;
            clear: typeof clear;
            value: (object: Record<string | number, any>, propertyName: string, value_: any, writable?: boolean | undefined, enumerable?: boolean | undefined) => void;
            getset: (object: Record<string | number, any>, propertyName: string, getter: __private.__types_globals__Getter, setter?: boolean | __private.__types_globals__Setter | undefined, enumerable?: boolean | undefined, configurable?: boolean | undefined) => void;
            get: (object: Record<string | number, any>, propertyName: string, getter: __private.__types_globals__Getter, enumerable?: boolean | undefined, configurable?: boolean | undefined) => void;
            set: (object: Record<string | number, any>, propertyName: string, setter: __private.__types_globals__Setter, enumerable?: boolean | undefined, configurable?: boolean | undefined) => void;
            unregisterClass: typeof unregisterClass;
            getClassName: typeof getClassName;
            setClassName: typeof setClassName;
            setClassAlias: typeof setClassAlias;
            getClassByName: typeof getClassByName;
            getClassById: typeof getClassById;
            /**
             * @en All classes registered in the engine, indexed by name.
             * @zh 引擎中已注册的所有类型，通过名称进行索引。
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             * @example
             * ```
             * import { js } from 'cc';
             * // save all registered classes before loading scripts
             * let builtinClassIds = js._registeredClassIds;
             * let builtinClassNames = js._registeredClassNames;
             * // load some scripts that contain CCClass
             * ...
             * // clear all loaded classes
             * js._registeredClassIds = builtinClassIds;
             * js._registeredClassNames = builtinClassNames;
             * ```
             *
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _registeredClassNames: Record<string, __private.__types_globals__Constructor<unknown>>;
            /**
             * @en All classes registered in the engine, indexed by ID.
             * @zh 引擎中已注册的所有类型，通过 ID 进行索引。
             * @example
             * ```
             * import { js } from 'cc';
             * // save all registered classes before loading scripts
             * let builtinClassIds = js._registeredClassIds;
             * let builtinClassNames = js._registeredClassNames;
             * // load some scripts that contain CCClass
             * ...
             * // clear all loaded classes
             * js._registeredClassIds = builtinClassIds;
             * js._registeredClassNames = builtinClassNames;
             * ```
             *
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _registeredClassIds: Record<string, __private.__types_globals__Constructor<unknown>>;
            /**
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _getClassId: typeof _getClassId;
            getClassId: typeof getClassId;
            /**
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _setClassId: (id: string, constructor: __private.__types_globals__Constructor<unknown>) => void;
            /**
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _getClassById: typeof _getClassById;
            obsolete: typeof obsolete;
            obsoletes: typeof obsoletes;
            formatStr: typeof formatStr;
            shiftArguments: typeof shiftArguments;
            createMap: typeof createMap;
        };
        /**
         * @en
         * Checks if an object is `number`.
         * @zh
         * 检查对象是否是 number 类型。
         * @param object @en The object to check. @zh 要检查的对象。
         * @returns @en True if it is a number primitive or a `Number` instance, false else.
         * @zh 如果该对象是基础数字类型或者是 `Number` 实例，返回 `true`；否则返回 `false`。
         * @example
         * ```ts
         * var obj = 10;
         * isNumber(obj); // returns true
         *
         * obj = new Number(10);
         * isNumber(obj); // returns true
         * ```
         */
        export function isNumber(object: any): boolean;
        /**
         * @en
         * Checks if an object is `string`.
         * @zh
         * 检查对象是否是 string 类型。
         * @param object @en The object to check. @zh 要检查的对象。
         * @returns @en True if it is a string primitive or a `String` instance, false else.
         * @zh 如果该对象是基础字符串类型或者是 `String` 实例，返回 `true`；否则返回 `false`。
         * @example
         * ```ts
         * var obj = "it is a string";
         * isString(obj); // returns true
         *
         * obj = new String("it is a string");
         * isString(obj); // returns true
         * ```
         */
        export function isString(object: any): boolean;
        /**
         * @en
         * Checks if an object is empty object. If an object does not have any enumerable property
         * (including properties inherits from prototype chains), then it is an empty object.
         * @zh
         * 检查对象是否为空对象。空对象的定义是：没有任何可被枚举的属性（包括从原型链继承的属性）的对象。
         * @param obj @en The object to check. @zh 要检查的对象。
         * @returns @en True if it is not an empty object or not an object, false else.
         * @zh 如果不是空对象或者不是一个对象，返回 `true`；否则返回 `false`。
         */
        export function isEmptyObject(obj: any): boolean;
        /**
         * @en
         * A simple wrapper of `Object.create(null)` which ensures the return object have no prototype (and thus no inherited members).
         * This eliminates the need to make `hasOwnProperty` judgments when we look for values by key on the object,
         * which is helpful for performance in this case.
         * @zh
         * 该方法是对 `Object.create(null)` 的简单封装。
         * `Object.create(null)` 用于创建无 prototype （也就无继承）的空对象。
         * 这样我们在该对象上查找属性时，就不用进行 `hasOwnProperty` 判断，此时对性能提升有帮助。
         *
         * @param forceDictMode @en Apply the delete operator to newly created map object. This will let V8 put the object in
         * "dictionary mode" and disables creation of hidden classes. This will improve the performance of objects that are
         * constantly changing shape.
         * @zh 对新创建的地图对象应用删除操作。这将让V8将对象置于 "字典模式"，并禁止创建隐藏类。这将提高那些不断变化形状对象的性能。
         * @returns @en A newly map object. @zh 一个新的 map 对象。
         */
        export function createMap(forceDictMode?: boolean): any;
        /**
         * @en
         * Gets class name of the object, if object is just a {} (and which class named 'Object'), it will return "".
         * (modified from <a href="http://stackoverflow.com/questions/1249531/how-to-get-a-javascript-objects-class">the code of stackoverflow post</a>)
         * @zh
         * 获取对象的类型名称，如果对象是 {} 字面量，将会返回 ""。参考了 stackoverflow 的代码实现：
         * <a href="http://stackoverflow.com/questions/1249531/how-to-get-a-javascript-objects-class">stackoverflow 的实现</a>
         * @param objOrCtor @en An object instance or constructor. @zh 类实例或者构造函数。
         * @returns @en The class name. @zh 类名。
         */
        export function getClassName(objOrCtor: any): string;
        /**
         * @en Deprecates a property. It will print waring message if the deprecated property is accessed.
         * The warning message includes new property name to use.
         * @zh 废弃一个属性。如果被废弃属性还在使用的话，会打印警告消息。警告消息包含新的属性名。
         * @param object @en The object or class of the property to deprecate.
         *               @zh 被废弃属性的对象或者类。
         * @param obsoleted @en The property name to deprecate. It could be a property name or `className.propertyName`.
         * @zh 要废弃的属性名。可以直接传属性名或者是 `类名.属性名` 的形式。
         * @param newExpr @en New property name to use. It could be a property name or `className.propertyName`.
         * @zh 新的属性名。可以直接传属性名或者是 `类名.属性名` 的形式。
         * @param writable @en Whether the property is writable. Default is false. @zh 该属性是否可写。默认不可写。
         */
        export function obsolete(object: any, obsoleted: string, newExpr: string, writable?: boolean): void;
        /**
         * @en Deprecates some properties. It will print waring message if any deprecated property is accessed.
         * The warning message includes new property name to use.
         * @zh 废弃一组属性。如果被废弃属性还在使用的话，会打印警告消息。警告消息包含新的属性名。
         * @param obj @en The object or class of these properties to deprecate.
         *            @zh 被废弃属性的对象或者类。
         * @param objName @en The object name or class name of these properties to deprecate.
         *                @zh 被废弃属性的对象名或者类名。
         * @param props @en The property names to deprecate. @zh 被废弃的一组属性名。
         * @param writable @en Whether these properties are writable. @zh 被废弃的属性是否可写。
         */
        export function obsoletes(obj: any, objName: any, props: any, writable: any): void;
        /**
         * @en
         * A string tool to construct a string with format string.
         * @zh
         * 根据格式字符串构造一个字符串。
         * @param msg @en A JavaScript string containing zero or more substitution strings (%s).
         * @zh 包含有 0 个或者多个格式符的字符串。
         * @param subst @en JavaScript objects with which to replace substitution strings within msg.
         * @zh 替换 `msg` 里格式符的表达式。
         * @returns @en A new formatted string. @zh 格式化后的新字符串。
         * @example
         * ```
         * import { js } from 'cc';
         * js.formatStr("a: %s, b: %s", a, b);
         * js.formatStr(a, b, c);
         * ```
         */
        export function formatStr(msg: string, ...subst: __private._cocos_core_platform_debug__StringSubstitution[]): string;
        /**
         * @en
         * A string tool to constructs a string from an arbitrary sequence of js object arguments.
         * @zh
         * 根据任意 js 对象参数序列构造一个字符串。
         * @returns @en A new formatted string. @zh 格式化后的新字符串。
         * @example
         * ```
         * import { js } from 'cc';
         * js.formatStr({}, null, undefined);  // [object Object] null undefined
         * ```
         */
        export function formatStr(...data: unknown[]): string;
        /**
         * @en Removes the first argument. @zh 移除第一个参数。
         * @returns @en An Array that contains all arguments except the first one.
         * @zh 新的参数数组，该数组不包含第一个参数。
         */
        export function shiftArguments(): any[];
        /**
         * @en Gets a property descriptor by property name of an object or its prototypes.
         * @zh 根据属性名从一个对象或者它的原型链中获取属性描述符。
         * @param object @en The object to get property descriptor. @zh 获取描述符的对象。
         * @param propertyName @en The property name to get property descriptor.
         * @zh 获取属性描述符的属性名。
         * @returns @en A `PropertyDescriptor` instance or null if not found.
         * @zh 属性描述符对象。如果没找到的话，返回 null。
         */
        export function getPropertyDescriptor(object: any, propertyName: string): PropertyDescriptor | null;
        /**
         * @en Copies all properties except those in `excepts` from `source` to `target`.
         * @zh 把 `source` 的所有属性，除了那些定义在 `excepts`的属性，拷贝到 `target`。
         * @param source @en Source object to copy from. @zh 拷贝的源对象。
         * @param target @en Target object to copy to. @zh 拷贝到目标对象。
         * @param excepts @en Properties are not copied. @zh 不拷贝到属性。
         */
        export function copyAllProperties(source: any, target: any, excepts: Array<string>): void;
        /**
         * @en Copies all the properties in "sources" that are not defined in object from "sources" to "object".
         * @zh 将 "sources" 中的所有没在 object 定义的属性从 "sources" 复制到 "object"。
         * @param object @en Object to copy properties to. @zh 拷贝的目标对象。
         * @param sources @en Source objects to copy properties from. @zh 拷贝到源对象数组。
         * @return @en The passing `object` or a new object if passing object is not valid.
         * @zh 传入的对象。如果传入的对象无效或者没传入，将返回一个新对象。
         */
        export function addon(object?: Record<string | number, any>, ...sources: any[]): Record<string | number, any>;
        /**
         * @en Copies all the properties in "sources" from "sources" to "object".
         * @zh 将 "sources" 中的所有属性从 "sources" 复制到 "object"。
         * @param object @en Object to copy properties to. @zh 拷贝的目标对象。
         * @param sources @en Source objects to copy properties from. @zh 拷贝到源对象数组。
         * @return @en The passing `object` or a new object if passing object is not valid.
         * @zh 传入的对象。如果传入的对象无效或者没传入，将返回一个新对象。
         */
        export function mixin(object?: Record<string | number, any>, ...sources: any[]): Record<string | number, any>;
        /**
         * @en
         * Makes a class inherit from the supplied base class.
         * @zh
         * 将一个类型继承另一个类型。
         * @param cls @en The class to inherit. @zh 要继承的类。
         * @param base @en The class to inherit from. @zh 被继承的类。
         * @returns @en Passed in `cls`. @zh 传入的 `cls`。
         */
        export function extend(cls: Function, base: Function): Function | undefined;
        /**
         * @en Get super class.
         * @zh 获取父类。
         * @param constructor @en The constructor to get super class.
         * @zh 要获取父类的构造函数。
         * @returns @en Super class. @zh 父类。
         */
        export function getSuper(constructor: Function): any;
        /**
         * @en
         * Checks whether a class is child of another class, or is the same type as another class.
         * @zh 判断一类型是否是另一类型的子类或本身。
         * @param subclass @en Sub class to check. @zh 子类类型。
         * @param superclass @en Super class to check. @zh 父类类型。
         * @return @en True if sub class is child of super class, or they are the same type. False else.
         * @zh 如果子类类型是父类类型的子类，或者二者是相同类型，那么返回 true，否则返回 false。
         */
        export function isChildClassOf<T extends __private.__types_globals__Constructor>(subclass: unknown, superclass: T): subclass is T;
        export function isChildClassOf(subclass: unknown, superclass: unknown): boolean;
        /**
         * @en Removes all enumerable properties from a object.
         * @zh 移除对象中所有可枚举属性.
         * @param object @en The object to remove enumerable properties from.
         * @zh 要删除可枚举属性的对象。
         */
        export function clear(object: Record<string | number, any>): void;
        /**
         * @en Registers a class by specified name manually.
         * @zh 通过指定的名称手动注册类型
         * @param className @en Class name to register. @zh 注册的类名。
         * @param constructor @en Constructor to register. @zh 注册的构造函数。
         */
        export function setClassName(className: string, constructor: __private.__types_globals__Constructor): void;
        /**
         * @en Sets an alias for a class.
         * After executing `setClassAlias(target, alias)`, `alias` will be a single way short cut for class `target`.
         * `js.getClassByName(alias)` and `getClassById(alias)` will return `target`. But `js.getClassName(target)`
         * will return the original class name of `target`, not the alias.
         * @zh 为类设置别名。执行 `setClassAlias(target, alias)` 后，`alias` 将作为类 `target` 的 “单向 ID” 和 “单向名称”。
         * 因此，`getClassById(alias)` 和 `getClassByName(alias)` 都会得到 `target`。这种映射是单向的，这意味着 `getClassName(target)`
         * 和 `getClassId(target)` 将不会返回 `alias`。
         * @param target @en Constructor of a class to set an alias. @zh 设置别名的类的构造函数。
         * @param alias @en Alias to set. The name shall not have been set as class name or alias of another class.
         * @zh 类的别名。别名不能重复，也不能是已有类的名字。
         */
        export function setClassAlias(target: __private.__types_globals__Constructor, alias: string): void;
        /**
         * @en
         * Unregister some classes from engine.
         * If you don't need a registered class anymore, you should unregister the class or engine will keep its reference.
         * Please note that it‘s your responsibility to remove other references to the class.
         * @zh
         * 取消注册类型。如果你不再需要一个注册的类，你应该取消注册这个类，否则引擎会还有对它的引用。
         * 请注意，你仍然有责任释放其他地方对该类的引用。
         *
         * @param ...constructor @en The classes to unregister. @zh 取消注册的类型列表。
         */
        export function unregisterClass(...constructors: Function[]): void;
        /**
         * @en Gets a registered class by id.
         * @zh 通过 id 获取已注册的类型。
         * @param classId @en An id to get class.
         * @return constructor
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         * Please use `getClassById()` instead.
         */
        export function _getClassById(classId: any): __private.__types_globals__Constructor<unknown>;
        /**
         * @en Gets the registered class by id.
         * @zh 通过 id 获取已注册的类型。
         * @param classId @en The class id used to get class. @zh 获取类的 id。
         * @returns @en The constructor of the registered class. @zh 注册的类构造函数。
         */
        export function getClassById(classId: any): __private.__types_globals__Constructor<unknown>;
        /**
         * @en
         * Gets the registered class by class name.
         * @zh
         * 通过类名获取已注册的类型。
         * @param classname @en The class name used to get class. @zh 获取类的类名。
         * @returns @en The constructor of the registered class. @zh 注册的类构造函数。
         */
        export function getClassByName(classname: any): __private.__types_globals__Constructor<unknown>;
        /**
         * @en
         * Get class id of the object
         * @zh
         * 获取对象的 class id
         * @param obj - instance or constructor
         * @param [allowTempId = true]   - can return temp id in editor
         * @return
         * @deprecated since v3.5.0. this is an engine private interface that will be removed in the future.
         * Please use `getClassId()` instead.
         */
        export function _getClassId(obj: any, allowTempId?: boolean): string;
        /**
         * @en
         * Gets class id of an object
         * @zh
         * 获取对象的 class id。
         * @param obj @en An object instance to get class id. @zh 获取类标识的对象。
         * @param allowTempId @en Whether allow to return a temple class id in editor.
         * @zh 在编辑器时，是否允许返回一个临时的类标识。
         * @returns @en Class id if found, empty string else.
         * @zh 找到的类标识。如果没找到的话，返回空字符串。
         */
        export function getClassId(obj: any, allowTempId?: boolean): string;
        /**
         * @en A helper function to add a property to an object, or modifies attributes
         * of an existing property. The property is configurable.
         * @zh 为对象添加属性或者修改已有属性的辅助函数。该属性是可配置的。
         * @param object @en The object to add or modify attributes. @zh 要添加或者修改属性的对象。
         * @param propertyName @en The property name to add or modify. @zh 要添加或修改的属性名。
         * @param value_ @en The property value to add or new value to replace a existing attribute.
         * @zh 要添加的属性值，或者取代现有属性的新值。
         * @param writable @en If the property is writable. @zh 属性是否可写。
         * @param enumerable @en If the property is enumerable. @zh 属性是否可枚举。
         */
        export const value: (object: Record<string | number, any>, propertyName: string, value_: any, writable?: boolean, enumerable?: boolean) => void;
        /**
         * @en A helper function to add or modify `get`, `set`, `enumerable` or `configurable` of a property.
         * @zh 添加或修改属性的 `get`, `set`, `enumerable` 或者 `configurable`。
         * @param object @en The object to add or modify attributes. @zh 要添加或者修改属性的对象。
         * @param propertyName @en The property name to add or modify. @zh 要添加或修改的属性名。
         * @param getter @en The getter of a property. @zh 属性的获取函数。
         * @param setter @en The setter of a property. @zh 属性的设置函数。
         * @param enumerable @en If the property is enumerable. @zh 属性是否可列举。
         * @param configurable @en If the property is configurable. @zh 属性是否可配置。
         */
        export const getset: (object: Record<string | number, any>, propertyName: string, getter: __private.__types_globals__Getter, setter?: __private.__types_globals__Setter | boolean, enumerable?: boolean, configurable?: boolean) => void;
        /**
         * @en A helper function to add or modify `get`, `enumerable` or `configurable` of a property.
         * @zh 添加或修改属性的 `get`, `enumerable` 或者 `configurable`。
         * @param object @en The object to add or modify attributes. @zh 要添加或者修改属性的对象。
         * @param propertyName @en The property name to add or modify. @zh 要添加或修改的属性名。
         * @param getter @en The getter of a property. @zh 属性的获取函数。
         * @param enumerable @en If the property is enumerable. @zh 属性是否可列举。
         * @param configurable @en If the property is configurable. @zh 属性是否可配置。
         */
        export const get: (object: Record<string | number, any>, propertyName: string, getter: __private.__types_globals__Getter, enumerable?: boolean, configurable?: boolean) => void;
        /**
         * @en A helper function to add or modify `get`, `enumerable` or `configurable` of a property.
         * @zh 添加或修改属性的 `get`, `enumerable` 或者 `configurable`。
         * @param object @en The object to add or modify attributes. @zh 要添加或者修改属性的对象。
         * @param propertyName @en The property name to add or modify. @zh 要添加或修改的属性名。
         * @param setter @en The setter of a property. @zh 属性的设置函数。
         * @param enumerable @en If the property is enumerable. @zh 属性是否可列举。
         * @param configurable @en If the property is configurable. @zh 属性是否可配置。
         */
        export const set: (object: Record<string | number, any>, propertyName: string, setter: __private.__types_globals__Setter, enumerable?: boolean, configurable?: boolean) => void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const _idToClass: Record<string, __private.__types_globals__Constructor>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const _nameToClass: Record<string, __private.__types_globals__Constructor>;
        /**
         * @en
         * Register the class by specified id, if its classname is not defined, the class name will also be set.
         * @zh
         * 通过 id 注册类型
         * @method _setClassId
         * @param classId
         * @param constructor
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const _setClassId: (id: string, constructor: __private.__types_globals__Constructor) => void;
    }
    export namespace misc {
        /**
         * @en Inserts a new element into a map. All values corresponding to the same key are stored in an array.
         * @zh 往 map 插入一个元素。同一个关键字对应的所有值存储在一个数组里。
         * @param map @en The map to insert element. @zh 插入元素的 map。
         * @param key @en The key of new element. @zh 新插入元素的关键字。
         * @param value @en The value of new element. @zh 新插入元素的值。
         * @param pushFront @en Whether to put new value in front of the vector if key exists.
         * @zh 如果关键字已经存在，是否把新插入的值放到数组第一个位置。
         */
        export function pushToMap(map: any, key: any, value: any, pushFront: any): void;
        /**
         * @en Checks whether a node is a descendant of a given node, that is the node itself, one of its direct
         * children (childNodes), one of the children's direct children, and so on.
         * @zh 检查节点是否是一个给定的节点的后代，即节点本身、它的一个直接子节点（childNodes）、该子节点的一个直接子节点，依此类推。
         * @param refNode @en The node to check. @zh 检查的节点。
         * @param otherNode @en The node to test with. @zh 用来测试的节点。
         * @returns @en True if otherNode is contained in refNode, false if not.
         * @zh 如果 refNode 包含 otherNode，返回 true；否则返回 false。
         */
        export function contains(refNode: any, otherNode: any): boolean;
        /**
         * @en Checks whether a node is a DOM node. @zh 检查一个节点是否是一个 DOM 节点。
         * @param node @en The node the check. @zh 被检查节点。
         * @returns @en True if node is a DOM node, false else.
         * @zh 如果 DOM 节点，返回 true；否则返回 false。
         */
        export function isDomNode(node: any): boolean;
        /**
         * @en Invoke a function in next frame. @zh 在下一帧执行传入的函数。
         * @param callback @en The function to be invoked next frame. @zh 下一帧要执行的函数。
         * @param p1 @en The first parameter passed to `callback`. @zh 传给回调函数的第一个参数。
         * @param p2 @en The seconde parameter passed to `callback`. @zh 传给回调函数的第二个参数。
         */
        export function callInNextTick<T extends any[]>(callback: (...args: T) => void, ...args: T): void;
        /**
         * @en Create a new function that will invoke `functionName` with try catch.
         * @zh 创建一个新函数，该函数会使用 try catch 机制调用 `functionName`.
         * @param funcName @en The function name to be invoked with try catch.
         * @zh 被 try catch 包裹的函数名。
         * @returns @en A new function that will invoke `functionName` with try catch.
         * @zh 使用 try catch 机制调用 `functionName` 的新函数.
         */
        export function tryCatchFunctor_EDITOR(funcName: string): (comp: Component) => void;
        /**
         * @en Checks whether an object is an empty object.
         * @zh 检查一个对象是否为空对象。
         * @param obj @en The object to check. @zh 要检查的对象。
         * @returns @en True if it is an empty object. False if it is not an empty object, not Object type, null or undefined.
         * @ 如果是空对象，返回 true。如果不是空对象，不是Object类型，空或未定义，则为假。
         */
        export function isPlainEmptyObj_DEV(obj: any): boolean;
        /**
         * @en Clamps a value between a min and a max value. </br>
         * If the original value is greater than max_inclusive, returns max_inclusive. </br>
         * If the original value is less than min_inclusive, returns min_inclusive. </br>
         * Else returns the original value.
         * @zh 限定浮点数的最大最小值。<br/>
         * 如果数值大于 max_inclusive 则返回 max_inclusive。<br/>
         * 如果数值小于 min_inclusive 则返回 min_inclusive。<br/>
         * 否则返回自身。
         * @param value @en Original value. @zh 初始值。
         * @param min_inclusive @en Minimum value in range. @zh 最小值。
         * @param max_inclusive @en Maximum value in range. @zh 最大值。
         * @returns @en The clamped value. @zh 目标值。
         * @example
         * var v1 = clampf(20, 0, 20); // 20;
         * var v2 = clampf(-1, 0, 20); //  0;
         * var v3 = clampf(10, 0, 20); // 10;
         */
        export function clampf(value: number, min_inclusive: number, max_inclusive: number): number;
        /**
         * @en Converts degree to radian.
         * @zh 将度数转换为弧度。
         * @param angle @en The degree to convert. @zh 角度。
         * @returns @en The radian. @zh 弧度。
         */
        export function degreesToRadians(angle: number): number;
        /**
         * @en Converts radian to degree.
         * @zh 将弧度转换为角度。
         * @param angle @en The radian to convert. @zh 弧度。
         * @returns @en The degree. @zh 角度。
         */
        export function radiansToDegrees(angle: any): number;
        export const BUILTIN_CLASSID_RE: RegExp;
        export interface Modifiable {
            getModifiableProperties(): string[];
        }
        export const BASE64_VALUES: number[];
    }
    export namespace path {
        /**
         * @en Joins strings to be a path.
         * @zh 拼接字符串为路径。
         * @param segments @en Strings to be joined. @zh 被拼接的字符串数组。
         * @returns @en The final path. @zh 拼接后的路径。
         * @example {@link cocos/core/utils/CCPath/join.js}
         */
        export function join(...segments: string[]): string;
        /**
         * @en Gets the extension name of a path including '.', like '.png'.
         * @zh 返回 Path 的扩展名，包括 '.'，例如 '.png'。
         * @param path @en A file path. @zh 文件路径。
         * @returns @en The extension name. @zh 扩展名。
         * @example {@link cocos/core/utils/CCPath/extname.js}
         */
        export function extname(path: string): string;
        /**
         * @en Gets the main name of a file name, exclude extension name.
         * @zh 获取文件名的主名称。
         * @deprecated
         */
        export function mainFileName(fileName: string): string;
        /**
         * @en Gets the file name of a file path, exclude extension name and directory name.
         * @zh 获取文件路径的文件名，不包含扩展名和目录名。
         * @param path @en A file path. @zh 文件路径。
         * @param extName @en File extension name. @zh 文件扩展名。
         * @returns @en The file name. @zh 文件名。
         * @example {@link cocos/core/utils/CCPath/basename.js}
         */
        export function basename(path: string, extName?: string): string;
        /**
         * @en Gets directory name of a file path.
         * @zh 获取文件路径的目录名。
         * @param path @en A file path. @zh 文件路径。
         * @returns @en Directory name. @zh 文件目录名。
         * @example {@link cocos/core/utils/CCPath/dirname.js}
         */
        export function dirname(path: string): string;
        /**
         * @en Changes file extension name.
         * @zh 更改文件的扩展名。
         * @param path @en A file path. @zh 文件路径。
         * @param extName @en New file extension name. @zh 新文件扩展名。
         * @returns @en New file path. @zh 新的文件路径。
         * @example {@link cocos/core/utils/CCPath/changeExtname.js}
         */
        export function changeExtname(path: string, extName?: string): string;
        /**
         * @en Changes file name of a file path.
         * @zh 更改文件路径的文件名。
         * @param path @en A file path. @zh 文件路径。
         * @param newBaseName @en New file name. @zh 新文件名。
         * @param keepExt @en Whether to keep extension name. @zh 是否保留扩展名。
         * @returns @en New file path. @zh 新文件路径。
         * @example {@link cocos/core/utils/CCPath/changeBasename.js}
         */
        export function changeBasename(path: string, newBaseName: string, keepExt?: boolean): string;
        export function _normalize(url: any): any;
        /**
         * @en Removes the last path separator('/' or '\') of a path if exist.
         * @zh 如果存在的话，删除文件路径的最后一个分隔符（'/' 或者 '\'）。
         * @param path @en A file path to modify. @zh 要修改的文件路径。
         * @returns @en A new file path without last file separator.
         * @zh 路径最后分隔符的新路径。
         */
        export function stripSep(path: string): string;
        /**
         * @en Gets file separator for different platforms. It is `/` on unix like platforms,
         * and `\` on windows.
         * @zh 获取不同平台的文件分割符。类 unix 系统是 `/`，windows 系统是 `\`。
         * @returns @en File separator. @zh 文件分割符。
         */
        export function getSeperator(): string;
    }
    /**
     * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
     */
    export function setDefaultLogTimes(times: number): void;
    /**
     * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
     */
    export let replaceProperty: (owner: object, ownerName: string, properties: __private._cocos_core_utils_x_deprecated__IReplacement[]) => void;
    /**
     * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
     */
    export let removeProperty: (owner: object, ownerName: string, properties: __private._cocos_core_utils_x_deprecated__IRemoveItem[]) => void;
    /**
     * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
     */
    export let markAsWarning: (owner: object, ownerName: string, properties: __private._cocos_core_utils_x_deprecated__IMarkItem[]) => void;
    /**
     * @en
     * Conversion of non-UI nodes to UI Node (Local) Space coordinate system.
     * @zh
     * 非 UI 节点转换到 UI 节点(局部) 空间坐标系。
     * @deprecated since Cocos Creator 3D v1.2, please use [[Camera.convertToUINode]]
     * @param mainCamera @en The main camera @zh 主相机
     * @param wpos @en The world space location. @zh 世界空间位置。
     * @param uiNode @en The UI node. @zh UI 节点。
     * @param out @en The output local position in UI @zh 返回 UI 节点局部坐标。
     */
    export function WorldNode3DToLocalNodeUI(mainCamera: Camera, wpos: math.Vec3, uiNode: Node, out?: math.Vec3): math.Vec3;
    /**
     * @en
     * Conversion of non-UI nodes to UI Node (World) Space coordinate system.
     * @zh
     * 非 UI 节点转换到 UI 节点(世界)空间坐标系。
     * @deprecated since Cocos Creator 3D v1.2, please use [[Camera.convertToUINode]]
     * @param mainCamera @en The main camera @zh 主相机
     * @param wpos @en The world space location. @zh 世界空间位置。
     * @param out @en The output world position in UI @zh 返回 UI 空间世界坐标。
     */
    export function WorldNode3DToWorldNodeUI(mainCamera: Camera, wpos: math.Vec3, out?: math.Vec3): math.Vec3;
    /**
     * @en It will be removed in v1.2. Please use [[Camera.convertToUINode]]。
     * @zh 将在 v1.2 移除，请使用 Camera 的 `convertToUINode`。
     * @deprecated since Cocos Creator 3D v1.2
     */
    export const convertUtils: {
        WorldNode3DToLocalNodeUI: typeof WorldNode3DToLocalNodeUI;
        WorldNode3DToWorldNodeUI: typeof WorldNode3DToWorldNodeUI;
    };
    export namespace _decorator {
        /**
         * @en
         * Marks the target class as "uniquely referenced" which means, in the aspect of serialization,
         * no more than one object should reference the same instance of that class.
         * When serializing references to objects of such class,
         * they're treated as different objects even if they point to actually the same.
         * While deserializing, these two references would point two distinct objects.
         * For example:
         * ```ts
         * import { _decorator } from 'cc';
         * @_decorator.ccclass
         * @_decorator.uniquelyReferenced
         * class Foo { }
         *
         * @_decorator.ccclass
         * class Bar {
         *   @_decorator.property
         *   public foo = new Foo();
         * }
         *
         * const bar1 = new Bar();
         * const bar2 = new Bar();
         * bar2.foo = bar1.foo; // Programmatically let them reference to the same
         * ```
         * `bar1` and `bar2` reference to the same `Foo` object.
         * However, after deserializing, `bar1.foo === bar2.foo` always evaluates to `false`.
         * @zh
         * 将目标类标记为“被唯一引用”的，其意味着就序列化而言，不会有多个对象引用该类的同一实例。
         * 当序列化到该类的对象引用时，即使它们明面上指向同一对象，也会被当作是不同对象；
         * 而当反序列化后，这两个引用将指向截然不同的两个对象。
         * 例如：
         * ```ts
         * import { _decorator } from 'cc';
         * @_decorator.ccclass
         * @_decorator.uniquelyReferenced
         * class Foo { }
         *
         * @_decorator.ccclass
         * class Bar {
         *   @_decorator.property
         *   public foo = new Foo();
         * }
         *
         * const bar1 = new Bar();
         * const bar2 = new Bar();
         * bar2.foo = bar1.foo; // 由程序逻辑让它们引用同一个对象
         * ```
         * `bar1` 和 `bar2` 引用同一个 `Foo` 对象。
         * 但在反序列化之后，`bar1.foo === bar2.foo` 永不成立。
         */
        export const uniquelyReferenced: ClassDecorator;
        /**
         * @en Declare a standard class as a CCClass, please refer to the [document](https://docs.cocos.com/creator3d/manual/en/scripting/ccclass.html)
         * @zh 将标准写法的类声明为 CC 类，具体用法请参阅[类型定义](https://docs.cocos.com/creator3d/manual/zh/scripting/ccclass.html)。
         * @param name - The class name used for serialization.
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass} = _decorator;
         *
         * // define a CCClass, omit the name
         *  @ccclass
         * class NewScript extends Component {
         *     // ...
         * }
         *
         * // define a CCClass with a name
         *  @ccclass('LoginData')
         * class LoginData {
         *     // ...
         * }
         * ```
         */
        export const ccclass: ((name?: string) => ClassDecorator) & ClassDecorator;
        /**
         * @en Declare as a CCClass property with options
         * @zh 声明属性为 CCClass 属性。
         * @param options property options
         */
        export function property(options?: __private._cocos_core_data_decorators_property__IPropertyOptions): __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        /**
         * @en Declare as a CCClass property with the property type
         * @zh 标注属性为 cc 属性。<br/>
         * 等价于`@property({type})`。
         * @param type A [[ccclass]] type or a [[ValueType]]
         */
        export function property(type: __private._cocos_core_data_decorators_property__PropertyType): __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        /**
         * @en Declare as a CCClass property
         * @zh 标注属性为 cc 属性。<br/>
         * 等价于`@property()`。
         */
        export function property(...args: Parameters<__private._cocos_core_data_decorators_utils__LegacyPropertyDecorator>): void;
        /**
         * @en Declare that the current component relies on another type of component.
         * If the required component doesn't exist, the engine will create a new empty instance of the required component and add it to the node.
         * @zh 为声明为 CCClass 的组件添加依赖的其它组件。当组件添加到节点上时，如果依赖的组件不存在，引擎将会自动将依赖组件添加到同一个节点，防止脚本出错。该设置在运行时同样有效。
         * @param requiredComponent The required component type
         * @example
         * ```ts
         * import {_decorator, Sprite, Component} from cc;
         * import {ccclass, requireComponent} from _decorator;
         *
         * @ccclass
         * @requireComponent(Sprite)
         * class SpriteCtrl extends Component {
         *     // ...
         * }
         * ```
         */
        export const requireComponent: (requiredComponent: Function | Function[]) => ClassDecorator;
        /**
         * @en Set the component priority, it decides at which order the life cycle functions of components will be invoked. Smaller priority gets invoked before larger priority.
         * This will affect `onLoad`, `onEnable`, `start`, `update` and `lateUpdate`, but `onDisable` and `onDestroy` won't be affected.
         * @zh 设置脚本生命周期方法调用的优先级。优先级小于 0 的组件将会优先执行，优先级大于 0 的组件将会延后执行。优先级仅会影响 onLoad, onEnable, start, update 和 lateUpdate，而 onDisable 和 onDestroy 不受影响。
         * @param priority - The execution order of life cycle methods for Component. Smaller priority gets invoked before larger priority.
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, executionOrder} = _decorator;
         *
         * @ccclass
         * @executionOrder(1)
         * class CameraCtrl extends Component {
         *     // ...
         * }
         * ```
         */
        export const executionOrder: (priority: number) => ClassDecorator;
        /**
         * @en Forbid adds multiple instances of the component to the same node.
         * @zh 防止多个相同类型（或子类型）的组件被添加到同一个节点。
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, disallowMultiple} = _decorator;
         *
         * @ccclass
         * @disallowMultiple
         * class CameraCtrl extends Component {
         *     // ...
         * }
         * ```
         */
        export const disallowMultiple: ClassDecorator & ((yes?: boolean) => ClassDecorator);
        /**
         * @en Makes a CCClass that inherits from component execute in edit mode.<br/>
         * By default, all components are only executed in play mode,<br/>
         * which means they will not have their callback functions executed while the Editor is in edit mode.<br/>
         * @zh 允许继承自 Component 的 CCClass 在编辑器里执行。<br/>
         * 默认情况下，所有 Component 都只会在运行时才会执行，也就是说它们的生命周期回调不会在编辑器里触发。
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, executeInEditMode} = _decorator;
         *
         *  @ccclass
         *  @executeInEditMode
         * class NewScript extends Component {
         *     // ...
         * }
         * ```
         */
        export const executeInEditMode: ClassDecorator & ((yes?: boolean) => ClassDecorator);
        /**
         * @en Add the current component to the specific menu path in `Add Component` selector of the inspector panel
         * @zh 将当前组件添加到组件菜单中，方便用户查找。例如 "Rendering/CameraCtrl"。
         * @param path - The path is the menu represented like a pathname. For example, the menu could be "Rendering/CameraCtrl".
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, menu} = _decorator;
         *
         * @ccclass
         * @menu("Rendering/CameraCtrl")
         * class NewScript extends Component {
         *     // ...
         * }
         * ```
         */
        export const menu: (path: string) => ClassDecorator;
        /**
         * @en When [[_decorator.executeInEditMode]] is set,
         * This decorator will make the editor run in high FPS mode when a node with the component is focused
         * @zh 当指定了 [[_decorator.executeInEditMode]] 以后，playOnFocus 可以在选中当前组件所在的节点时，提高编辑器的场景刷新频率到 60 FPS，否则场景就只会在必要的时候进行重绘。
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, playOnFocus, executeInEditMode} = _decorator;
         *
         * @ccclass
         * @executeInEditMode
         * @playOnFocus
         * class CameraCtrl extends Component {
         *     // ...
         * }
         * ```
         */
        export const playOnFocus: ClassDecorator & ((yes?: boolean) => ClassDecorator);
        /**
         * @en Use a customized inspector page in the **inspector**
         * @zh 自定义当前组件在 **属性检查器** 中渲染时所用的 UI 页面描述。
         * @param url The URL of the page definition in js
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, inspector} = _decorator;
         *
         * @ccclass
         * @inspector("packages://inspector/inspectors/comps/camera-ctrl.js")
         * class NewScript extends Component {
         *     // ...
         * }
         * ```
         */
        export const inspector: (url: string) => ClassDecorator;
        /**
         * @en Define the icon of the component.
         * @zh 自定义当前组件在编辑器中显示的图标 url。
         * @param url
         * @private
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, icon} = _decorator;
         *
         *  @ccclass
         *  @icon("xxxx.png")
         * class NewScript extends Component {
         *     // ...
         * }
         * ```
         */
        export const icon: (url: string) => ClassDecorator;
        /**
         * @en Define the help documentation URL,
         * if given, the component section in the **Inspector** will have a help documentation icon refers to the web page given.
         * @zh 指定当前组件的帮助文档的 url，设置过后，在 **属性检查器** 中就会出现一个帮助图标，用户点击将打开指定的网页。
         * @param url The URL of the help documentation
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, help} = _decorator;
         *
         * @ccclass
         * @help("app://docs/html/components/spine.html")
         * class NewScript extends Component {
         *     // ...
         * }
         * ```
         */
        export const help: (url: string) => ClassDecorator;
        /**
         * @en Declare the property as the given type
         * @zh 标记该属性的类型。
         * @param type
         */
        export function type(type: Function | [
            Function
        ] | any): __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        export function type<T>(type: __private._cocos_core_data_utils_attribute__PrimitiveType<T> | [
            __private._cocos_core_data_utils_attribute__PrimitiveType<T>
        ]): __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        /**
         * @en Declare the property as integer
         * @zh 将该属性标记为整数。
         */
        export const integer: __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        /**
         * @en Declare the property as float
         * @zh 将该属性标记为浮点数。
         */
        export const float: __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        /**
         * @en Declare the property as boolean
         * @zh 将该属性标记为布尔值。
         */
        export const boolean: __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        /**
         * @en Declare the property as string
         * @zh 将该属性标记为字符串。
         */
        export const string: __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
    }
    export function CCClass<TFunction>(options: {
        name?: string;
        extends: null | (Function & {
            __props__?: any;
            _sealed?: boolean;
        });
        ctor: TFunction;
        properties?: any;
        editor?: any;
    }): any;
    export namespace CCClass {
        export var _isCCClass: (constructor: any) => boolean;
        export var fastDefine: (className: any, constructor: any, serializableFields: any) => void;
        export var Attr: typeof __private._cocos_core_data_utils_attribute;
        export var attr: typeof __private._cocos_core_data_utils_attribute.attr;
        export var isCCClassOrFastDefined: typeof __private._cocos_core_data_class__isCCClassOrFastDefined;
        export var getInheritanceChain: (constructor: any) => any[];
        export var isArray: (defaultVal: any) => boolean;
        export var getDefault: (defaultVal: any) => any;
        export var escapeForJS: (s: any) => string;
        export var IDENTIFIER_RE: RegExp;
        export var getNewValueTypeCode: any;
    }
    /**
     * @en
     * The base class of most of all the objects in Fireball.
     * @zh
     * 大部分对象的基类。
     * @private
     */
    export class CCObject implements __private._cocos_core_data_editor_extras_tag__EditorExtendableObject {
        static _deferredDestroy(): void;
        /**
         * @internal
         */
        [editorExtrasTag]: unknown;
        /**
         * @internal
         */
        _objFlags: number;
        protected _name: string;
        constructor(name?: string);
        /**
         * @en The name of the object.
         * @zh 该对象的名称。
         * @default ""
         * @example
         * ```
         * obj.name = "New Obj";
         * ```
         */
        get name(): string;
        set name(value: string);
        /**
         * @en After inheriting CCObject objects, control whether you need to hide, lock, serialize, and other functions.
         * @zh 在继承 CCObject 对象后，控制是否需要隐藏，锁定，序列化等功能。
         */
        set hideFlags(hideFlags: CCObject.Flags);
        get hideFlags(): CCObject.Flags;
        /**
         * @en
         * Indicates whether the object is not yet destroyed. (It will not be available after being destroyed)<br>
         * When an object's `destroy` is called, it is actually destroyed after the end of this frame.
         * So `isValid` will return false from the next frame, while `isValid` in the current frame will still be true.
         * If you want to determine whether the current frame has called `destroy`, use `isValid(obj, true)`,
         * but this is often caused by a particular logical requirements, which is not normally required.
         *
         * @zh
         * 表示该对象是否可用（被 destroy 后将不可用）。<br>
         * 当一个对象的 `destroy` 调用以后，会在这一帧结束后才真正销毁。<br>
         * 因此从下一帧开始 `isValid` 就会返回 false，而当前帧内 `isValid` 仍然会是 true。<br>
         * 如果希望判断当前帧是否调用过 `destroy`，请使用 `isValid(obj, true)`，不过这往往是特殊的业务需求引起的，通常情况下不需要这样。
         * @default true
         * @readOnly
         * @example
         * ```ts
         * import { Node, log } from 'cc';
         * const node = new Node();
         * log(node.isValid);    // true
         * node.destroy();
         * log(node.isValid);    // true, still valid in this frame
         * // after a frame...
         * log(node.isValid);    // false, destroyed in the end of last frame
         * ```
         */
        get isValid(): boolean;
        /**
         * @en
         * Destroy this Object, and release all its own references to other objects.<br/>
         * Actual object destruction will delayed until before rendering.
         * From the next frame, this object is not usable any more.
         * You can use `isValid(obj)` to check whether the object is destroyed before accessing it.
         * @zh
         * 销毁该对象，并释放所有它对其它对象的引用。<br/>
         * 实际销毁操作会延迟到当前帧渲染前执行。从下一帧开始，该对象将不再可用。
         * 您可以在访问对象之前使用 `isValid(obj)` 来检查对象是否已被销毁。
         * @return whether it is the first time the destroy being called
         * @example
         * ```
         * obj.destroy();
         * ```
         */
        destroy(): boolean;
        /**
         * @en
         * Clear all references in the instance.
         *
         * NOTE: this method will not clear the getter or setter functions which defined in the instance of CCObject.
         *
         * @zh
         * 清理实例的所有引用
         * 注意：此方法不会清理实例上的 getter 与 setter 方法。
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         * @example
         * ```
         * // You can override the _destruct method if you need, for example:
         *       _destruct: function () {
         *           for (var key in this) {
         *               if (this.hasOwnProperty(key)) {
         *                   switch (typeof this[key]) {
         *                       case 'string':
         *                           this[key] = '';
         *                           break;
         *                       case 'object':
         *                       case 'function':
         *                           this[key] = null;
         *                           break;
         *               }
         *           }
         *       }
         * ```
         */
        _destruct(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _destroyImmediate(): void;
    }
    export namespace CCObject {
        export enum Flags {
            Destroyed,
            /**
             * @en The object will not be saved.
             * @zh 该对象将不会被保存。
             */
            DontSave,
            /**
             * @en The object will not be saved when building a player.
             * @zh 构建项目时，该对象将不会被保存。
             */
            EditorOnly,
            Dirty,
            /**
             * @en Dont destroy automatically when loading a new scene.
             * @zh 加载一个新场景时，不自动删除该对象。
             * @private
             */
            DontDestroy,
            /**
             * @en
             * @zh
             * @private
             */
            PersistentMask,
            /**
             * @en
             * @zh
             * @private
             */
            Destroying,
            /**
             * @en The node is deactivating.
             * @zh 节点正在反激活的过程中。
             * @private
             */
            Deactivating,
            /**
             * @en
             * Hide in game and hierarchy.
             * This flag is readonly, it can only be used as an argument of scene.addEntity() or Entity.createWithFlags().
             * @zh
             * 在游戏和层级中隐藏该对象。<br/>
             * 该标记只读，它只能被用作 scene.addEntity()的一个参数。
             */
            /**
             * @en The lock node, when the node is locked, cannot be clicked in the scene.
             * @zh 锁定节点，锁定后场景内不能点击。
             * @private
             */
            LockedInEditor,
            /**
             * @en Hide the object in editor.
             * @zh 在编辑器中隐藏该对象。
             */
            HideInHierarchy,
            /**
             * @en The object will not be saved and hide the object in editor,and lock node, when the node is locked,
             * cannot be clicked in the scene,and The object will not be saved when building a player.
             * @zh 该对象将不会被保存,构建项目时，该对象将不会被保存, 锁定节点，锁定后场景内不能点击, 在编辑器中隐藏该对象。
             */
            AllHideMasks,
            /**
             * @en
             * Hide in game view, hierarchy, and scene view... etc.
             * This flag is readonly, it can only be used as an argument of scene.addEntity() or Entity.createWithFlags().
             * @zh
             * 在游戏视图，层级，场景视图等等...中隐藏该对象。
             * 该标记只读，它只能被用作 scene.addEntity()的一个参数。
             */
            IsPreloadStarted,
            IsOnLoadStarted,
            IsOnLoadCalled,
            IsOnEnableCalled,
            IsStartCalled,
            IsEditorOnEnableCalled,
            IsPositionLocked,
            IsRotationLocked,
            IsScaleLocked,
            IsAnchorLocked,
            IsSizeLocked
        }
        export let __props__: string[];
        export let __values__: string[];
    }
    /**
     * @en
     * Indicates that the editor should treat this property or array element as an Integer value.
     * @zh
     * 指定编辑器以整数形式对待该属性或数组元素。
     * @example
     * ```ts
     * import { CCInteger, _decorator } from "cc";
     *
     * // in the class definition:
     *
     * @_decorator.property({type: CCInteger})
     * count = 0;
     *
     * @_decorator.property({type: [CCInteger]})
     * array = [];
     * ```
     */
    export const CCInteger: __private._cocos_core_data_utils_attribute__PrimitiveType<number>;
    /**
     * @en
     * Indicates that the editor should treat this property or array element as a Float value.
     * @zh
     * 指定编辑器以浮点数形式对待该属性或数组元素。
     * @example
     * ```ts
     * import { CCFloat, _decorator } from "cc";
     *
     * // in the class definition:
     *
     * @_decorator.property({type: CCFloat})
     * x = 0;
     *
     * @_decorator.property({type: [CCFloat]})
     * array = [];
     * ```
     */
    export const CCFloat: __private._cocos_core_data_utils_attribute__PrimitiveType<number>;
    /**
     * @en
     * Indicates that the editor should treat this property or array element as a Boolean value.
     * @zh
     * 指定编辑器以布尔值形式对待该属性或数组元素。
     *
     * @example
     * ```ts
     * import { CCBoolean, _decorator } from "cc";
     * // in the class definition
     * @_decorator.property({type: CCBoolean})
     * isTrue = false;
     *
     * @_decorator.property({type: [CCBoolean]})
     * array = [];
     * ```
     */
    export const CCBoolean: __private._cocos_core_data_utils_attribute__PrimitiveType<boolean>;
    /**
     * @en
     * Indicates that the editor should treat this property or array element as a String value.
     * @zh
     * 指定编辑器以字符串形式对待该属性或数组元素。
     * @example
     * ```ts
     * import { CCString, _decorator } from "cc";
     *
     * // in the class definition
     *
     * @_decorator.property({type: CCString})
     * name = '';
     *
     * @_decorator.property({type: [CCString]})
     * array = [];
     * ```
     */
    export const CCString: __private._cocos_core_data_utils_attribute__PrimitiveType<string>;
    /**
     * @deprecated Since V3.5.0.
     */
    export class CompactValueTypeArray {
        static StorageUnit: typeof __private._cocos_core_data_utils_compact_value_type_array__StorageUnit;
        static ElementType: typeof __private._cocos_core_data_utils_compact_value_type_array__ElementType;
        /**
         * Returns the length in bytes that a buffer needs to encode the specified value array in form of CVTA.
         * @param values The value array.
         * @param unit Target element type.
         */
        static lengthFor(values: any[], elementType: __private._cocos_core_data_utils_compact_value_type_array__ElementType, unit: __private._cocos_core_data_utils_compact_value_type_array__StorageUnit): number;
        /**
         * Compresses the specified value array in form of CVTA into target buffer.
         * @param values The value array.
         * @param unit Target element type.
         * @param arrayBuffer Target buffer.
         * @param byteOffset Offset into target buffer.
         */
        static compress(values: any[], elementType: __private._cocos_core_data_utils_compact_value_type_array__ElementType, unit: __private._cocos_core_data_utils_compact_value_type_array__StorageUnit, arrayBuffer: ArrayBuffer, byteOffset: number, presumedByteOffset: number): CompactValueTypeArray;
        /**
         * Decompresses this CVTA.
         * @param arrayBuffer The buffer this CVTA stored in.
         */
        decompress<T>(arrayBuffer: ArrayBuffer): T[];
    }
    /**
     * Tag to visit editor extras of an object. Never be concerned about its value, please.
     */
    export const editorExtrasTag = "__editorExtras__";
    /**
     * Tag to define the custom deserialization method.
     * @internal
     */
    export const deserializeTag: unique symbol;
    /**
     * Tag to define the custom serialization method.
     * @internal
     */
    export const serializeTag: unique symbol;
    export interface SerializationInput {
        /**
         * Reads a property from the input.
         * @param name Property name.
         * @returns The property's value, after deserialized.
         */
        readProperty(name: string): unknown;
        /**
         * Deserializes this object according to the original procedure.
         */
        readThis(): void;
        /**
         * Deserializes super according to the original procedure.
         */
        readSuper(): void;
    }
    export interface SerializationOutput {
        /**
         * Writes a property into output.
         * @param name Property name.
         * @param value Property value.
         */
        writeProperty(name: string, value: unknown): void;
        /**
         * Serialize this object according to the original procedure.
         */
        writeThis(): void;
        /**
         * Serialize super according to the original procedure.
         */
        writeSuper(): void;
    }
    export type SerializationContext = {
        /**
         * The main serializing asset or root node in the scene/prefab passed to the serialization procedure.
         */
        root: unknown;
        /**
         * True if the serialization procedure is targeting CCON.
         */
        toCCON: boolean;
        /**
         * Customized arguments passed to serialization procedure.
         */
        customArguments: Record<PropertyKey, unknown>;
    };
    export interface CustomSerializable {
        [serializeTag](output: SerializationOutput, context: SerializationContext): void;
        [deserializeTag]?(input: SerializationInput, context: __private._cocos_core_data_custom_serializable__DeserializationContext): void;
    }
    /**
     * @internal DO NOT USE IT IN YOUR CODES.
     * @param constructor
     * @returns
     */
    export function getSerializationMetadata(constructor: Function): SerializationMetadata | undefined;
    /**
     * @internal For internal usage only. DO NOT USE IT IN YOUR CODES.
     */
    export interface SerializationMetadata {
        uniquelyReferenced?: boolean;
    }
    /**
     * @en
     * EventTarget is an object to which an event is dispatched when something has occurred.
     * [[Node]]s are the most common event targets, but other objects can be event targets too.
     * If a class cannot extend from EventTarget, it can consider using [[Eventify]].
     *
     * @zh
     * 事件目标是具有注册监听器、派发事件能力的类，[[Node]] 是最常见的事件目标，
     * 但是其他类也可以继承自事件目标以获得管理监听器和派发事件的能力。
     * 如果无法继承自 EventTarget，也可以使用 [[Eventify]]
     */
    export const EventTarget: new (...args: any[]) => __private._cocos_core_event_event_target__Empty & __private._cocos_core_event_eventify__IEventified;
    export type EventTarget = InstanceType<typeof EventTarget>;
    /**
     * @en Generate a new class from the given base class, after polyfill all functionalities in [[IEventified]] as if it's extended from [[EventTarget]]
     * @zh 生成一个类，该类继承自指定的基类，并以和 [[EventTarget]] 等同的方式实现了 [[IEventified]] 的所有接口。
     * @param base The base class
     * @example
     * ```ts
     * class Base { say() { console.log('Hello!'); } }
     * class MyClass extends Eventify(Base) { }
     * function (o: MyClass) {
     *     o.say(); // Ok: Extend from `Base`
     *     o.emit('sing', 'The ghost'); // Ok: `MyClass` implements IEventified
     * }
     * ```
     */
    export function Eventify<TBase>(base: __private._cocos_core_event_eventify__Constructor<TBase>): __private._cocos_core_event_eventify__Constructor<TBase & __private._cocos_core_event_eventify__IEventified>;
    /**
     * @zh
     * Async Delegate 用于支持异步回调的代理，你可以新建一个异步代理，并注册异步回调，等到对应的时机触发代理事件。
     *
     * @en
     * Async Delegate is a delegate that supports asynchronous callbacks.
     * You can create a new AsyncDelegate, register the asynchronous callback, and wait until the corresponding time to dispatch the event.
     *
     * @example
     * ```ts
     * const ad = new AsyncDelegate();
     * ad.add(() => {
     *     return new Promise((resolve, reject) => {
     *        setTimeout(() => {
     *            console.log('hello world');
     *            resolve();
     *        }, 1000);
     *     })
     * });
     * await ad.dispatch();
     * ```
     */
    export class AsyncDelegate<T extends (...args: any) => (Promise<void> | void) = () => (Promise<void> | void)> {
        /**
         * @en
         * Add an async callback or sync callback.
         *
         * @zh
         * 添加一个异步回调或同步回调。
         *
         * @param callback
         * @en The callback to add, and will be invoked when this delegate is dispatching.
         * @zh 要添加的回调，并将在该委托调度时被调用。
         */
        add(callback: T): void;
        /**
         * @zh
         * 查询是否已注册某个回调。
         * @en
         * Queries if a callback has been registered.
         *
         * @param callback @en The callback to query. @zh 要查询的回调函数。
         * @returns @en Whether the callback has been added. @zh 是否已经添加了回调。
         */
        hasListener(callback: T): boolean;
        /**
         * @en
         * Remove the specific callback of this delegate.
         *
         * @zh
         * 移除此代理中某个具体的回调。
         *
         * @param callback @en The callback to remove. @zh 要移除的某个回调。
         */
        remove(callback: T): void;
        /**
         * @en
         * Dispatching the delegate event. This function will trigger all previously registered callbacks and does not guarantee execution order.
         *
         * @zh
         * 派发代理事件。此函数会触发所有之前注册的回调，并且不保证执行顺序。
         *
         * @param args @en The parameters to be transferred to callback. @zh 传递给回调函数的参数。
         * @returns @en The promise awaiting all async callback resolved. @zh 等待所有异步回调结束的 Promise 对象。
         */
        dispatch(...args: Parameters<T>): Promise<void[]>;
    }
    /**
     * @en Outputs a message at the "debug" log level.
     * @zh 输出一条“调试”日志等级的消息。
     * @param data @zh 输出的消息对象。 @en The output message object.
     */
    export function debug(...data: unknown[]): void;
    /**
     * @en Outputs a log message to the console.
     *     The message may be a single string (with optional substitution values), or it may be any one or more JavaScript objects.
     * @zh 向控制台输出一条日志信息。这条信息可能是单个字符串（包括可选的替代字符串），也可能是一个或多个对象。
     */
    export function log(...data: unknown[]): void;
    /**
     * @en Outputs an error message to the console.
     *     The message may be a single string (with optional substitution values), or it may be any one or more JavaScript objects.
     *     - In Cocos Creator, error is red.<br/>
     *     - In Chrome, error have a red icon along with red message text.<br/>
     * @zh 向控制台输出一条错误信息。这条信息可能是单个字符串（包括可选的替代字符串），也可能是一个或多个对象。
     *     - 在 Cocos Creator 中，错误信息显示是红色的。<br/>
     *     - 在 Chrome 中，错误信息有红色的图标以及红色的消息文本。<br/>
     */
    export function error(...data: unknown[]): void;
    /**
     * @en Outputs a warning message to the console.
     *     The message may be a single string (with optional substitution values), or it may be any one or more JavaScript objects.
     *     - In Cocos Creator, warning is yellow.
     *     - In Chrome, warning have a yellow warning icon with the message text.
     * @zh 向控制台输出一条警告信息。这条信息可能是单个字符串（包括可选的替代字符串），也可能是一个或多个对象。
     *     - 在 Cocos Creator 中，警告信息显示是黄色的。<br/>
     *     - 在 Chrome 中，警告信息有着黄色的图标以及黄色的消息文本。<br/>
     */
    export function warn(...data: unknown[]): void;
    /**
     * @en
     * Assert the condition and output error messages if the condition is not true.
     * @zh
     * 对检查测试条件进行检查，如果条件不为 true 则输出错误消息
     * @param condition @zh 需要检查的条件。 @en The condition to check on.
     * @param message @zh 包含零个或多个需要替换的JavaScript字符串。@en JavaScript objects to replace substitution strings in msg.
     * @param optionalParams  @zh 用来替换在message中需要替换的JavaScript对象。@en JavaScript objects with which to replace substitution strings within msg.
     * This gives you additional control over the format of the output.
     */
    export function assert(condition: boolean, message?: string, ...optionalParams: __private._cocos_core_platform_debug__StringSubstitution[]): asserts condition;
    export function debugID(id: number, ...optionalParams: __private._cocos_core_platform_debug__StringSubstitution[]): void;
    export function logID(id: number, ...optionalParams: __private._cocos_core_platform_debug__StringSubstitution[]): void;
    export function errorID(id: number, ...optionalParams: __private._cocos_core_platform_debug__StringSubstitution[]): void;
    export function warnID(id: number, ...optionalParams: __private._cocos_core_platform_debug__StringSubstitution[]): void;
    export function assertID(condition: boolean, id: number, ...optionalParams: __private._cocos_core_platform_debug__StringSubstitution[]): void;
    /**
     * @en Returns whether or not to display the FPS and debug information.
     * @zh 是否显示 FPS 信息和部分调试信息。
     * @deprecated @zh 从v3.6开始不再支持，请使用 profiler.isShowingStates。@en Since v3.6, Please use profiler.isShowingStates instead.
     */
    export function isDisplayStats(): boolean;
    /**
     * @en Sets whether display the FPS and debug informations on the bottom-left corner.
     * @zh 设置是否在左下角显示 FPS 和部分调试。
     * @deprecated @zh 从v3.6开始不再支持，请使用 profiler.showStats。@en Since v3.6, Please use profiler.showStats instead.
     */
    export function setDisplayStats(displayStats: boolean): void;
    /**
     * @en Gets error message with the error id and possible parameters.
     * @zh 通过 error id 和必要的参数来获取错误信息。
     * @param errorId @zh 错误的ID。@en Error id.
     * @param param @zh 输出日志。@en Output log.
     */
    export function getError(errorId: number, ...param: __private._cocos_core_platform_debug__StringSubstitution[]): string;
    /**
     * @en Enum for debug modes.
     * @zh 调试模式。
     */
    export enum DebugMode {
        /**
         * @en The debug mode none.
         * @zh 禁止模式，禁止显示任何日志消息。
         */
        NONE = 0,
        /**
         * @en The debug mode none.
         * @zh 调试模式，显示所有日志消息。
         */
        VERBOSE = 1,
        /**
         * @en Information mode, which display messages with level higher than "information" level.
         * @zh 信息模式，显示“信息”级别以上的日志消息。
         */
        INFO = 2,
        /**
         * @en Information mode, which display messages with level higher than "warning" level.
         * @zh 警告模式，显示“警告”级别以上的日志消息。
         */
        WARN = 3,
        /**
         * @en Information mode, which display only messages with "error" level.
         * @zh 错误模式，仅显示“错误”级别的日志消息。
         */
        ERROR = 4,
        /**
         * @en The debug mode info for web page.
         * @zh 信息模式（仅 WEB 端有效），在画面上输出所有信息。
         */
        INFO_FOR_WEB_PAGE = 5,
        /**
         * @en The debug mode warn for web page.
         * @zh 警告模式（仅 WEB 端有效），在画面上输出 warn 级别以上的（包含 error）信息。
         */
        WARN_FOR_WEB_PAGE = 6,
        /**
         * @en The debug mode error for web page.
         * @zh 错误模式（仅 WEB 端有效），在画面上输出 error 信息。
         */
        ERROR_FOR_WEB_PAGE = 7
    }
    export const screen: Screen;
    /**
     * @en The screen API provides an easy way to do some screen managing stuff.
     * @zh screen 单例对象提供简单的方法来做屏幕管理相关的工作。
     */
    export class Screen {
        /**
         * @internal
         */
        init(): void;
        /**
         * @en the ratio of the resolution in physical pixels to the resolution in CSS pixels for the current display device
         * NOTE: For performance reasons, the engine will limit the maximum value of DPR on some platforms.
         * This property returns the DPR after the engine limit.
         * @zh 当前显示设备的物理像素分辨率与 CSS 像素分辨率之比。
         * 注意：出于性能考虑，引擎在一些平台会限制 DPR 的最高值，这个属性返回的是引擎限制后的 DPR。
         */
        get devicePixelRatio(): number;
        /**
         * @en Get and set the size of current window in physical pixels.
         * NOTE:
         * - Setting window size is only supported on Web platform for now.
         * - On Web platform, if the ContainerStrategy is PROPORTIONAL_TO_FRAME, we set windowSize on game frame,
         *    and get windowSize from the game container after adaptation.
         * @zh 获取和设置当前窗口的物理像素尺寸。
         * 注意
         * - 设置窗口尺寸目前只在 Web 平台上支持。
         * - Web 平台上，如果 ContainerStrategy 为 PROPORTIONAL_TO_FRAME, 则设置 windowSize 作用于 game frame, 而从适配之后 game container 尺寸获取 windowSize.
         */
        get windowSize(): math.Size;
        set windowSize(size: math.Size);
        /**
         * @en Get the current resolution of game.
         * This is a readonly property.
         * @zh 获取当前游戏的分辨率。
         * 这是一个只读属性。
         *
         * @readonly
         */
        get resolution(): math.Size;
        /**
         * @en Whether it supports full screen.
         * @zh 是否支持全屏。
         * @returns {Boolean}
         */
        get supportsFullScreen(): boolean;
        /**
         * @en Return true if it's in full screen state now.
         * @zh 当前是否处在全屏状态下。
         * @returns {boolean}
         */
        fullScreen(): boolean;
        /**
         * @en Request to enter full screen mode with the given element.
         * Many browsers forbid to enter full screen mode without an user intended interaction.
         * If failed to request fullscreen, another attempt will be made to request fullscreen the next time a user interaction occurs.
         * @zh 尝试使当前节点进入全屏模式，很多浏览器不允许程序触发这样的行为，必须在一个用户交互回调中才会生效。
         * 如果进入全屏失败，会在下一次用户发生交互时，再次尝试进入全屏。
         * @param element @zh 请求全屏状态的html元素。 @en The element to request full screen state.
         * @param onFullScreenChange @zh 全屏状态改变的回调函数。 @en callback function when full screen state changed.
         * @param onFullScreenError @zh 全屏错误的回调函数。 @en callback function when full screen error.
         * @return {Promise|undefined}
         * @deprecated since v3.3, please use `screen.requestFullScreen(): Promise<void>` instead.
         */
        requestFullScreen(element: HTMLElement, onFullScreenChange?: (this: Document, ev: any) => any, onFullScreenError?: (this: Document, ev: any) => any): Promise<any> | undefined;
        /**
         * @en Request to enter full screen mode.
         * Many browsers forbid to enter full screen mode without an user intended interaction.
         * If failed to request fullscreen, another attempt will be made to request fullscreen the next time a user interaction occurs.
         * @zh 尝试使当前屏幕进入全屏模式，很多浏览器不允许程序触发这样的行为，必须在一个用户交互回调中才会生效。
         * 如果进入全屏失败，会在下一次用户发生交互时，再次尝试进入全屏。
         * @param element @zh 请求全屏状态的html元素。 @en The element to request full screen state.
         * @param onFullScreenChange @zh 全屏状态改变的回调函数。 @en callback function when full screen state changed.
         * @param onFullScreenError @zh 全屏错误的回调函数。 @en callback function when full screen error.
         * @return {Promise}
         */
        requestFullScreen(): Promise<void>;
        /**
         * @en Exit the full mode.
         * @zh 退出全屏模式。
         * @return {Promise}
         */
        exitFullScreen(): Promise<any>;
        /**
         * @en Automatically request full screen during the next touch/click event.
         * @zh 自动监听触摸、鼠标事件并在下一次事件触发时尝试进入全屏模式。
         * @param element @zh 请求全屏状态的html元素。 @en The element to request full screen state.
         * @param onFullScreenChange @zh 全屏状态改变的回调函数。 @en callback function when full screen state changed.
         *
         * @deprecated since v3.3, please use screen.requestFullScreen() instead.
         */
        autoFullScreen(element: HTMLElement, onFullScreenChange: (this: Document, ev: any) => any): void;
        /**
         * @param element
         * @deprecated since v3.3
         */
        disableAutoFullScreen(element: any): void;
        /**
         * @en
         * Register screen event callback.
         * @zh
         * 注册screen事件回调。
         */
        on(type: __private._pal_screen_adapter_enum_type_screen_event__PalScreenEvent, callback: (...args: any) => void, target?: any): void;
        /**
         * @en
         * Register a callback of a specific screen event type once.
         * @zh
         * 注册单次的screen事件回调。
         */
        once(type: __private._pal_screen_adapter_enum_type_screen_event__PalScreenEvent, callback: (...args: any) => void, target?: any): void;
        /**
         * @en
         * Unregister screen event callback.
         * @zh
         * 取消注册screen事件回调。
         */
        off(type: __private._pal_screen_adapter_enum_type_screen_event__PalScreenEvent, callback?: (...args: any) => void, target?: any): void;
    }
    /**
     * @en A set of system related variables.
     * @zh 一系列系统相关环境变量。
     */
    export const sys: {
        Feature: typeof __private._pal_system_info_enum_type_feature__Feature;
        /**
         * @en
         * Returns if the specified platform related feature is supported.
         * @zh
         * 返回指定的平台相关的特性是否支持。
         * @param feature @zh 系统的特性。 @en Feature of the system.
         */
        hasFeature(feature: sys.Feature): boolean;
        /**
         * @en
         * Network type enumeration.
         * @zh
         * 网络类型枚举。
         */
        NetworkType: typeof __private._pal_system_info_enum_type_network_type__NetworkType;
        /**
         * @en
         * LanguageCode type enumeration.
         * @zh
         * 语言码类型枚举。
         */
        Language: typeof __private._pal_system_info_enum_type_language__Language;
        /**
         * @en
         * OS type enumeration.
         * @zh
         * 操作系统类型枚举。
         */
        OS: typeof __private._pal_system_info_enum_type_operating_system__OS;
        /**
         * @en
         * Platform type enumeration.
         * @zh
         * 平台类型枚举。
         */
        Platform: typeof __private._pal_system_info_enum_type_platform__Platform;
        /**
         * @en
         * Browser type enumeration.
         * @zh
         * 浏览器类型枚举。
         */
        BrowserType: typeof __private._pal_system_info_enum_type_browser_type__BrowserType;
        /**
         * @en Whether the running platform is native app.
         * @zh 指示运行平台是否是原生平台。
         */
        isNative: boolean;
        /**
         * @en Whether the running platform is browser.
         * @zh 指示运行平台是否是浏览器。
         */
        isBrowser: boolean;
        /**
         * @en Indicate whether the current running context is a mobile system.
         * @zh 指示当前运行平台是否是移动端平台。
         */
        isMobile: boolean;
        /**
         * @en Whether the endianness of current platform is little endian.
         * @zh 当前平台字节顺序是否是小端序。
         */
        isLittleEndian: boolean;
        /**
         * @en The running platform.
         * @zh 当前运行平台或环境。
         */
        platform: __private._pal_system_info_enum_type_platform__Platform;
        /**
         * @en Indicate the current language of the running system.
         * @zh 指示当前运行环境的语言。
         */
        language: __private._pal_system_info_enum_type_language__Language;
        /**
         * @en
         * Get current language iso 639-1 code.
         * Examples of valid language codes include "zh-tw", "en", "en-us", "fr", "fr-fr", "es-es", etc.
         * The actual value totally depends on results provided by destination platform.
         * @zh
         * 指示当前运行环境的语言
         * 获取当前的语言iso 639-1代码。
         * 有效的语言代码包括 "zh-tw"、"en"、"en-us"、"fr"、"fr-fr"、"es-es "等。
         * 实际值完全取决于目的地平台提供的结果。
         */
        languageCode: string;
        /**
         * @en Indicate the running os name.
         * @zh 指示当前运行系统。
         */
        os: __private._pal_system_info_enum_type_operating_system__OS;
        /**
         * @en Indicate the running os version string.
         * @zh 指示当前运行系统版本字符串。
         */
        osVersion: string;
        /**
         * @en Indicate the running os main version.
         * @zh 指示当前系统主版本。
         */
        osMainVersion: number;
        /**
         * @en Indicate the running browser type.
         * @zh 指示当前运行的浏览器类型。
         */
        browserType: __private._pal_system_info_enum_type_browser_type__BrowserType;
        /**
         * @en Indicate the running browser version.
         * @zh 指示当前运行的浏览器版本。
         */
        browserVersion: string;
        /**
         * @en Whether the running platform is xr app.
         * @zh 指示运行平台是否是XR平台。
         */
        isXR: boolean;
        /**
         * @en Indicate the real pixel resolution of the whole game window.
         * @zh 指示游戏窗口的像素分辨率。
         *
         * @deprecated since v3.4.0, please use screen.windowSize instead.
         */
        windowPixelResolution: math.Size;
        /**
         * @en The capabilities of the current platform.
         * @zh 当前平台的功能可用性。
         *
         * @deprecated since v3.4.0, please use sys.hasFeature() instead.
         */
        capabilities: {
            canvas: boolean;
            opengl: boolean;
            webp: boolean;
            imageBitmap: boolean;
            touches: boolean;
            mouse: boolean;
            keyboard: boolean;
            accelerometer: boolean;
        };
        /**
         * @en It is a local storage component based on HTML5 localStorage API, on web platform, it's equal to window.localStorage.
         * @zh HTML5 标准中的 localStorage 的本地存储功能，在 Web 端等价于 window.localStorage。
         */
        localStorage: any;
        /**
         * @en Get the network type of current device, return `sys.NetworkType.LAN` if failure.
         * @zh 获取当前设备的网络类型, 如果网络类型无法获取，默认将返回 `sys.NetworkType.LAN`。
         * @return @zh 返回 LAN 或 WWAN。 @en LAN or WWAN.
         */
        getNetworkType(): __private._pal_system_info_enum_type_network_type__NetworkType;
        /**
         * @en Get the battery level of current device, return 1.0 if failure.
         * @zh 获取当前设备的电池电量，如果电量无法获取，默认将返回 1。
         * @return - 0.0 ~ 1.0
         */
        getBatteryLevel(): number;
        /**
         * @en Forces the garbage collection, only available in native platforms.
         * @zh 强制进行 JS 内存垃圾回收，尽在原生平台有效。
         */
        garbageCollect(): void;
        /**
         * @en Check whether an object is valid,
         * In web engine, it will return true if the object exist
         * In native engine, it will return true if the JS object and the correspond native object are both valid
         * @zh 检查一个对象是否非空或在原生平台有效，
         * 在 Web 平台，只要对象非空或非 Undefined 就会返回 true，在原生平台，我们会检查当前 JS 对象和其绑定的原生对象是否都有效。
         * @param obj @zh 校验的对象。@en The object to be checked.
         */
        isObjectValid(obj: any): boolean;
        /**
         * @en Dump systemInfo informations.
         * @zh 在控制台打印当前的主要系统信息。
         */
        dump(): void;
        /**
         * @en Try to open a url in browser, may not work in some platforms.
         * @zh 尝试打开一个 web 页面，并非在所有平台都有效。
         * @param url @zh 访问的链接。 @en Visited links.
         */
        openURL(url: string): void;
        /**
         * @en Get the current time in milliseconds.
         * @zh 获取当前时间（毫秒为单位）。
         */
        now(): number;
        /**
         * @en Restart the JS VM, only available in native platforms.
         * @zh 重启JS虚拟机，仅仅在原生平台有效。
         * @private
         */
        restartVM(): void;
        /**
         * @en
         * Returns the safe area of the screen (in design resolution) based on the game view coordinate system.
         * If the screen is not notched, this method returns a Rect of the same size as visibleSize by default.
         * Currently supports Android, iOS and WeChat, ByteDance Mini Game platform.
         * @zh
         * 返回基于游戏视图坐标系的手机屏幕安全区域（设计分辨率为单位），如果不是异形屏将默认返回一个和 visibleSize 一样大的 Rect。
         * 目前支持安卓、iOS 原生平台和微信、字节小游戏平台。
         * @method getSafeAreaRect
         * @param [symmetric=true] @zh 基于屏幕对称的 Rect。 @en Rect that is symmetric based on the screen.
         * @return {Rect}
         */
        getSafeAreaRect(symmetric?: boolean): math.Rect;
    };
    export namespace sys {
        /**
         * @en
         * Platform related feature enum type.
         * @zh
         * 平台相关的特性枚举类型。
         */
        export type Feature = __private.__types_globals__EnumAlias<typeof __private._pal_system_info_enum_type_feature__Feature>;
    }
    export interface ISchedulable {
        id?: string;
        uuid?: string;
        update?(dt: number): void;
    }
    /**
     * @en
     * Scheduler is responsible of triggering the scheduled callbacks.<br>
     * You should not use NSTimer. Instead use this class.<br>
     * <br>
     * There are 2 different types of callbacks (selectors):<br>
     *     - update callback: the 'update' callback will be called every frame. You can customize the priority.<br>
     *     - custom callback: A custom callback will be called every frame, or with a custom interval of time.<br>
     * <br>
     * The 'custom selectors' should be avoided when possible. It is faster,<br>
     * and consumes less memory to use the 'update callback'. *
     * @zh
     * Scheduler 是负责触发回调函数的类。<br>
     * 通常情况下，建议使用 `director.getScheduler()` 来获取系统定时器。<br>
     * 有两种不同类型的定时器：<br>
     *     - update 定时器：每一帧都会触发。您可以自定义优先级。<br>
     *     - 自定义定时器：自定义定时器可以每一帧或者自定义的时间间隔触发。<br>
     * 如果希望每帧都触发，应该使用 update 定时器，使用 update 定时器更快，而且消耗更少的内存。
     */
    export class Scheduler extends System {
        static ID: string;
        /**
         * @en This method should be called for any target which needs to schedule tasks, and this method should be called before any scheduler API usage.
         * This method will add a `id` property if it doesn't exist.
         * @zh 任何需要用 Scheduler 管理任务的对象主体都应该调用这个方法，并且应该在调用任何 Scheduler API 之前调用这个方法。
         * 这个方法会给对象添加一个 `id` 属性，如果这个属性不存在的话。
         * @param target
         * @en The target to enable, which type is ISchedulable.
         * @zh 所作用的对象。类型为ISchedulable。
         */
        static enableForTarget(target: ISchedulable): void;
        constructor();
        /**
         * @en
         * Modifies the time of all scheduled callbacks.<br>
         * You can use this property to create a 'slow motion' or 'fast forward' effect.<br>
         * Default is 1.0. To create a 'slow motion' effect, use values below 1.0.<br>
         * To create a 'fast forward' effect, use values higher than 1.0.<br>
         * Note：It will affect EVERY scheduled selector / action.
         * @zh
         * 设置时间间隔的缩放比例。<br>
         * 您可以使用这个方法来创建一个 “slow motion（慢动作）” 或 “fast forward（快进）” 的效果。<br>
         * 默认是 1.0。要创建一个 “slow motion（慢动作）” 效果,使用值低于 1.0。<br>
         * 要使用 “fast forward（快进）” 效果，使用值大于 1.0。<br>
         * 注意：它影响该 Scheduler 下管理的所有定时器。
         * @param timeScale
         */
        setTimeScale(timeScale: number): void;
        /**
         * @en Returns time scale of scheduler.
         * @zh 获取时间间隔的缩放比例。
         */
        getTimeScale(): number;
        /**
         * @en 'update' the scheduler. (You should NEVER call this method, unless you know what you are doing.)
         * @zh update 调度函数。(不应该直接调用这个方法，除非完全了解这么做的结果)
         * @param dt
         * @en delta time. The unit is seconds.
         * @zh 更新间隔时间, 单位是秒。
         */
        update(dt: number): void;
        /**
         * @en Specify the callback to schedule a new timer.
         * If the callback function is already scheduled, then only the interval parameter will be updated without re-scheduling it again.
         * @zh 指定回调函数来规划一个新的定时器。
         * 如果回调函数已经被定时器使用，那么只会更新之前定时器的时间间隔参数，不会设置新的定时器。
         * @param callback
         * @en The specified target.
         * @zh 所指定的调用对象。
         * @param target
         * @en The scheduled method will be called every 'interval' seconds.
         * If 'interval' is 0, it will be called every frame, but if so, it recommended to use 'scheduleUpdateForTarget:' instead.
         * @zh 当时间间隔达到指定值时，设置的回调函数将会被调用。
         * 如果 interval 值为 0，那么回调函数每一帧都会被调用，但如果是这样，建议使用 scheduleUpdateForTarget 代替。
         * @param interval
         * @en repeat let the action be repeated repeat + 1 times, use `macro.REPEAT_FOREVER` to let the action run continuously.
         * @zh repeat 值可以让定时器触发 repeat + 1 次，使用 `macro.REPEAT_FOREVER` 可以让定时器一直循环触发。
         * @param repeat
         * @en delay is the amount of time the action will wait before it'll start. Unit: s.
         * @zh delay 值指定延迟时间，定时器会在延迟指定的时间之后开始计时，单位: 秒。
         * @param delay
         * @en If paused is YES, then it won't be called until it is resumed.
         * @zh 如果 paused 值为 true，那么直到 resume 被调用才开始计时。
         * @param paused
         */
        schedule(callback: __private._cocos_core_scheduler__CallbackType, target: ISchedulable, interval: number, repeat?: number, delay?: number, paused?: boolean): void;
        /**
         * @en The specified target.
         * @zh 所指定的调用对象。
         * @param target
         * @en Specify the callback to schedule a new timer.
         * If the callback function is already scheduled, then only the interval parameter will be updated without re-scheduling it again.
         * @zh 指定回调函数来规划一个新的定时器。
         * 如果回调函数已经被定时器使用，那么只会更新之前定时器的时间间隔参数，不会设置新的定时器。
         * @param callback
         * @en The scheduled method will be called every 'interval' seconds.
         * If 'interval' is 0, it will be called every frame, but if so, it recommended to use 'scheduleUpdateForTarget:' instead.
         * @zh 当时间间隔达到指定值时，设置的回调函数将会被调用。
         * 如果 interval 值为 0，那么回调函数每一帧都会被调用，但如果是这样，建议使用 scheduleUpdateForTarget 代替。
         * @param interval
         * @en repeat let the action be repeated repeat + 1 times, use `macro.REPEAT_FOREVER` to let the action run continuously.
         * @zh repeat 值可以让定时器触发 repeat + 1 次，使用 `macro.REPEAT_FOREVER` 可以让定时器一直循环触发。
         * @param repeat
         * @en delay is the amount of time the action will wait before it'll start. Unit: s.
         * @zh delay 值指定延迟时间，定时器会在延迟指定的时间之后开始计时，单位: 秒。
         * @param delay
         * @en If paused is YES, then it won't be called until it is resumed.
         * @zh 如果 paused 值为 true，那么直到 resume 被调用才开始计时。
         * @param paused
         *
         * @deprecated since v3.8.0, please use `Scheduler.schedule(callback, target, interval)` instead.
         */
        schedule(target: ISchedulable, callback: __private._cocos_core_scheduler__CallbackType, interval: number, repeat?: number, delay?: number, paused?: boolean): void;
        /**
         * @en
         * Schedules the update callback for a given target,
         * During every frame after schedule started, the "update" function of target will be invoked.
         * @zh
         * 使用指定的优先级为指定的对象设置 update 定时器。<br>
         * update 定时器每一帧都会被触发，触发时自动调用指定对象的 "update" 函数。<br>
         * 优先级的值越低，定时器被触发的越早。
         * @param target
         * @en The target bound to the callback. @zh 回调所绑定的目标对象。
         * @param priority
         * @en The priority. @zh 优先级。
         * @param paused
         * @en Whether is paused. @zh 是否被暂停。
         */
        scheduleUpdate(target: ISchedulable, priority: number, paused: boolean): void;
        /**
         * @en
         * Unschedule a callback for a callback and a given target.
         * If you want to unschedule the "update", use `unscheduleUpdate()`
         * @zh
         * 取消指定对象定时器。
         * 如果需要取消 update 定时器，请使用 unscheduleUpdate()。
         * @param callback @en The callback to be unscheduled @zh 被取消调度的回调。
         * @param target @en The target bound to the callback. @zh 回调所绑定的目标对象。
         */
        unschedule(callback: __private.__types_globals__AnyFunction, target: ISchedulable): void;
        /**
         * @en Unschedule the update callback for a given target.
         * @zh 取消指定对象的 update 定时器。
         * @param target The target to be unscheduled.
         */
        unscheduleUpdate(target: ISchedulable): void;
        /**
         * @en
         * Unschedule all scheduled callbacks for a given target.
         * This also includes the "update" callback.
         * @zh 取消指定对象的所有定时器，包括 update 定时器。
         * @param target The target to be unscheduled.
         */
        unscheduleAllForTarget(target: ISchedulable): void;
        /**
         * @en
         * Unschedule all scheduled callbacks from all targets including the system callbacks.
         * You should NEVER call this method, unless you know what you are doing.
         * @zh
         * 取消所有对象的所有定时器，包括系统定时器。
         * 不要调用此函数，除非你确定你在做什么。
         */
        unscheduleAll(): void;
        /**
         * @en
         * Unschedule all callbacks from all targets with a minimum priority.
         * You should only call this with `PRIORITY_NON_SYSTEM_MIN` or higher.
         * @zh
         * 取消所有优先级的值大于指定优先级的定时器。
         * 你应该只取消优先级的值大于 PRIORITY_NON_SYSTEM_MIN 的定时器。
         * @param minPriority
         * @en The minimum priority of selector to be unscheduled.
         * Which means, all selectors which priority is higher than minPriority will be unscheduled.
         * @zh 要取消调度的选择器的最低优先级。
         * 这意味着，所有优先级高于 minPriority 的选择器将被取消调度。
         */
        unscheduleAllWithMinPriority(minPriority: number): void;
        /**
         * @en Checks whether a callback for a given target is scheduled.
         * @zh 检查指定的回调函数和回调对象组合是否存在定时器。
         * @param callback @en The callback to check. @zh 指定检测的回调。
         * @param target @en The target of the callback. @zh 回调的目标对象。
         * @returns @en True if the specified callback is invoked, false if not. @zh 返回true如果指定回调被调用, 否则返回false。
         */
        isScheduled(callback: __private.__types_globals__AnyFunction, target: ISchedulable): boolean;
        /**
         * @en
         * Pause all selectors from all targets.
         * You should NEVER call this method, unless you know what you are doing.
         * @zh
         * 暂停所有对象的所有定时器。
         * 不要调用这个方法，除非你知道你正在做什么。
         */
        pauseAllTargets(): ISchedulable[];
        /**
         * @en
         * Pause all selectors from all targets with a minimum priority.
         * You should only call this with kCCPriorityNonSystemMin or higher.
         * @zh
         * 暂停所有优先级的值大于指定优先级的定时器。
         * 你应该只暂停优先级的值大于 PRIORITY_NON_SYSTEM_MIN 的定时器。
         * @param minPriority @en the minimum priority. @zn 最小优先级。
         */
        pauseAllTargetsWithMinPriority(minPriority: number): ISchedulable[];
        /**
         * @en
         * Resume selectors on a set of targets.<br/>
         * This can be useful for undoing a call to pauseAllCallbacks.
         * @zh
         * 恢复指定数组中所有对象的定时器。<br/>
         * 这个函数是 pauseAllCallbacks 的逆操作。
         * @param targetsToResume
         */
        resumeTargets(targetsToResume: ISchedulable[]): void;
        /**
         * @en
         * Pauses the target.<br/>
         * All scheduled selectors/update for a given target won't be 'ticked' until the target is resumed.<br/>
         * If the target is not present, nothing happens.
         * @zh
         * 暂停指定对象的定时器。<br/>
         * 指定对象的所有定时器都会被暂停。<br/>
         * 如果指定的对象没有定时器，什么也不会发生。
         * @param target
         */
        pauseTarget(target: ISchedulable): void;
        /**
         * @en
         * Resumes the target.<br/>
         * The 'target' will be unpaused, so all schedule selectors/update will be 'ticked' again.<br/>
         * If the target is not present, nothing happens.
         * @zh
         * 恢复指定对象的所有定时器。<br/>
         * 指定对象的所有定时器将继续工作。<br/>
         * 如果指定的对象没有定时器，什么也不会发生。
         * @param target
         */
        resumeTarget(target: ISchedulable): void;
        /**
         * @en Returns whether or not the target is paused.
         * @zh 返回指定对象的定时器是否处于暂停状态。
         * @param target
         */
        isTargetPaused(target: ISchedulable): boolean;
    }
    /**
     * @en
     * Real curve.
     *
     * The real curve is a kind of keyframe curve.
     * When evaluating a real curve:
     * - If the input is just the time of a keyframe,
     *   keyframe value's numeric value is used as result.
     * - Otherwise, if the input is less than the time of the first keyframe or
     *   is greater than the time of the last keyframe time, it performs so-called extrapolation.
     * - Otherwise, the input falls between two keyframes and then it interpolates between the two keyframes.
     *
     * Every keyframe may specify an interpolation mode
     * to indicates how to perform the interpolation
     * from current keyframe to next keyframe.
     * Interpolation modes of keyframes may differ from each other.
     *
     * Real curve allows three interpolation modes: constant, linear and cubic.
     * The constant and linear mode is easy.
     * In case of cubic interpolation,
     * the interpolation algorithm is effectively equivalent to cubic bezier(or cubic hermite) interpolation.
     *
     * Related quantities related to cubic interpolation are:
     * - Keyframe times and numeric values.
     * - The tangent and tangent weight of the previous keyframe and next keyframe.
     *
     * While performing the cubic bezier interpolation,
     * The first control point is calculated from right tangent and right tangent weight of previous keyframe,
     * the second control point is calculated from left tangent and left tangent weight of next keyframe.
     *
     * In equivalent bezier representation,
     * the tangent is the line slope between sample point and control point
     * and the tangent weight is the distance between sample point and control point.
     * The tangent weight on either side can be marked as "not specified" through tangent weight mode.
     * If either side weight is not specified,
     * the tangent weight is treated at `sqrt(d_t^2 + (d_t * tangent)^2) * (1 / 3)`
     * where `d_t` is the difference between two keyframes 's time and `tangent` is the tangent of that side.
     *
     * Note, in some cases, tangent/tangent weight/tangent weight mode may be "meaningless".
     * The meaningless means that value can may not be stored(or serialized).
     * @zh
     * 实数曲线。
     *
     * 实数曲线是关键帧曲线的一种。
     * 在求值实数曲线时：
     * - 若输入正好就是关键帧上的时间，关键帧上的数值就作为结果。
     * - 否则，如果输入小于第一个关键帧上的时间或大于最后一个关键帧上的时间，它会进行所谓的外推。
     * - 否则，输入落于两帧之间，将通过插值两帧得到结果。
     *
     * 每个关键帧都可以指定插值模式，
     * 以表示从当前帧数值变化到下一帧数值所采用的插值算法，
     * 每个关键帧的插值模式都可以是各不相同的。
     *
     * 实数曲线允许三种插值模式：常量、线性和三次方的（也称立方）。
     * 常量和线性模式都比较简单。
     * 在三次插值的情况下，插值算法实质上等价于三次贝塞尔（或三次埃尔米特）插值。
     *
     * 三次插值的相关量有：
     * - 关键帧上的时间和数值；
     * - 前一关键帧和后一关键帧上的切线和切线权重。
     *
     * 当两帧之间进行三次贝塞尔曲线插值时，
     * 会取前一帧的右切线、右切线权重来计算出第一个控制点，
     * 会取后一帧的左切线、左切线权重来计算出第二个控制点。
     *
     * 在等效的贝塞尔表示中，
     * 切线就是样本点和控制点之间的切线斜率，而切线权重就是样本点和控制点之间的距离。
     * 任意一端的切线权重都可以通过切线权重模式来标记为“未指定的”。
     * 若任意一端的切线权重是未指定的，
     * 此端上的切线权重将被视为 `sqrt(d_t^2 + (d_t * tangent)^2) * (1 / 3)`，其中，
     * `d_t` 是两帧时间的差，`tangent` 是此端上的切线。
     *
     * 注意，切线/切线权重/切线权重模式在某些情况下可能是“无意义的”。
     * 无意义意味着这些值可能不会被存储或序列化。
     */
    export class RealCurve extends __private._cocos_core_curves_keyframe_curve__KeyframeCurve<RealKeyframeValue> {
        constructor();
        /**
         * @en
         * Gets or sets the pre-extrapolation-mode of this curve.
         * Defaults to `ExtrapolationMode.CLAMP`.
         * @zh
         * 获取或设置此曲线的前向外推模式。
         * 默认为 `ExtrapolationMode.CLAMP`。
         */
        preExtrapolation: ExtrapolationMode;
        /**
         * @en
         * Gets or sets the post-extrapolation-mode of this curve.
         * Defaults to `ExtrapolationMode.CLAMP`.
         * @zh
         * 获取或设置此曲线的后向外推模式。
         * 默认为 `ExtrapolationMode.CLAMP`。
         */
        postExtrapolation: ExtrapolationMode;
        /**
         * @en
         * Evaluates this curve at specified time.
         * @zh
         * 计算此曲线在指定时间上的值。
         * @param time Input time.
         * @returns Result value.
         */
        evaluate(time: number): number;
        /**
         * @en
         * Adds a keyframe into this curve.
         * @zh
         * 添加一个关键帧到此曲线。
         * @param time Time of the keyframe.
         * @param value Value of the keyframe.
         * @returns The index to the new keyframe.
         */
        addKeyFrame(time: number, value: __private._cocos_core_curves_curve__RealKeyframeValueParameters): number;
        /**
         * @en
         * Assigns all keyframes.
         * @zh
         * 赋值所有关键帧。
         * @param keyframes An iterable to keyframes. The keyframes should be sorted by their time.
         */
        assignSorted(keyframes: Iterable<[
            number,
            __private._cocos_core_curves_curve__RealKeyframeValueParameters
        ]>): void;
        /**
         * Assigns all keyframes.
         * @param times Times array. Should be sorted.
         * @param values Values array. Corresponding to each time in `times`.
         */
        assignSorted(times: readonly number[], values: __private._cocos_core_curves_curve__RealKeyframeValueParameters[]): void;
        /**
         * @en
         * Returns if this curve is constant.
         * @zh
         * 返回此曲线是否是常量曲线。
         * @param tolerance The tolerance.
         * @returns Whether it is constant.
         */
        isConstant(tolerance: number): boolean;
        /**
         * @internal
         */
        [serializeTag](output: SerializationOutput, context: SerializationContext): void;
        /**
         * @internal
         */
        [deserializeTag](input: SerializationInput, context: __private._cocos_core_data_custom_serializable__DeserializationContext): void;
    }
    /**
     * @en
     * The method used for interpolation method between value of a keyframe and its next keyframe.
     * @zh
     * 在某关键帧（前一帧）和其下一帧之间插值时使用的插值方式。
     */
    export enum RealInterpolationMode {
        /**
         * @en
         * Perform linear interpolation between previous keyframe value and next keyframe value.
         * @zh
         * 在前一帧和后一帧之间执行线性插值。
         */
        LINEAR = 0,
        /**
         * @en
         * Always use the value from this keyframe.
         * @zh
         * 永远使用前一帧的值。
         */
        CONSTANT = 1,
        /**
         * @en
         * Perform cubic(hermite) interpolation between previous keyframe value and next keyframe value.
         * @zh
         * 在前一帧和后一帧之间执行立方插值。
         */
        CUBIC = 2
    }
    /**
     * @en
     * Specifies how to extrapolate the value
     * if input time is underflow(less than the the first frame time) or
     * overflow(greater than the last frame time) when evaluating an curve.
     * @zh
     * 在求值曲线时，指定当输入时间下溢（小于第一帧的时间）或上溢（大于最后一帧的时间）时应该如何推断结果值。
     */
    export enum ExtrapolationMode {
        /**
         * @en
         * Compute the result
         * according to the first two frame's linear trend in the case of underflow and
         * according to the last two frame's linear trend in the case of overflow.
         * If there are less than two frames, fallback to `CLAMP`.
         * @zh
         * 下溢时，根据前两帧的线性趋势计算结果；上溢时，根据最后两帧的线性趋势计算结果。
         * 如果曲线帧数小于 2，回退到  `CLAMP`。
         */
        LINEAR = 0,
        /**
         * @en
         * Use first frame's value in the case of underflow,
         * use last frame's value in the case of overflow.
         * @zh
         * 下溢时，使用第一帧的值；上溢时，使用最后一帧的值。
         */
        CLAMP = 1,
        /**
         * @en
         * Computes the result as if the curve is infinitely and continuously looped.
         * @zh
         * 求值时将该曲线视作是无限连续循环的。
         */
        LOOP = 2,
        /**
         * @en
         * Computes the result as if the curve is infinitely and continuously looped in a ping-pong manner.
         * @zh
         * 求值时将该曲线视作是以“乒乓”的形式无限连续循环的。
         */
        PING_PONG = 3
    }
    /**
     * @en
     * Specifies both side tangent weight mode of a keyframe value.
     * @zh
     * 指定关键帧两侧的切线权重模式。
     */
    export enum TangentWeightMode {
        /**
         * @en
         * Neither side of the keyframe carries tangent weight information.
         * @zh
         * 关键帧的两侧都不携带切线权重信息。
         */
        NONE = 0,
        /**
         * @en
         * Only left side of the keyframe carries tangent weight information.
         * @zh
         * 仅关键帧的左侧携带切线权重信息。
         */
        LEFT = 1,
        /**
         * @en
         * Only right side of the keyframe carries tangent weight information.
         * @zh
         * 仅关键帧的右侧携带切线权重信息。
         */
        RIGHT = 2,
        /**
         * @en
         * Both sides of the keyframe carries tangent weight information.
         * @zh
         * 关键帧的两侧都携带切线权重信息。
         */
        BOTH = 3
    }
    /**
     * @en View to a real frame value.
     * Note, the view may be invalidated due to keyframe change/add/remove.
     * @zh 实数帧值的视图。
     * 注意，该视图可能因关键帧的添加、改变、移除而失效。
     */
    export class RealKeyframeValue extends __private._cocos_core_data_editor_extendable__EditorExtendable {
        constructor();
        /**
         * @en
         * When perform interpolation, the interpolation method should be taken
         * when for this keyframe is used as starting keyframe.
         * @zh
         * 在执行插值时，当以此关键帧作为起始关键帧时应当使用的插值方式。
         */
        get interpolationMode(): RealInterpolationMode;
        set interpolationMode(value: RealInterpolationMode);
        /**
         * @en
         * Tangent weight mode when perform cubic interpolation
         * This field is regarded if current interpolation mode is not cubic.
         * @zh
         * 当执行三次插值时，此关键帧使用的切线权重模式。
         * 若当前的插值模式不是三次插值时，该字段无意义。
         */
        get tangentWeightMode(): TangentWeightMode;
        set tangentWeightMode(value: TangentWeightMode);
        /**
         * @en
         * Value of the keyframe.
         * @zh
         * 该关键帧的值。
         */
        value: number;
        /**
         * @en
         * The tangent of this keyframe
         * when it's used as starting point during cubic interpolation.
         * Regarded otherwise.
         * @zh
         * 当此关键帧作为三次插值的起始点时，此关键帧的切线。其他情况下该字段无意义。
         */
        rightTangent: number;
        /**
         * @en
         * The tangent weight of this keyframe
         * when it's used as starting point during weighted cubic interpolation.
         * Regarded otherwise.
         * @zh
         * 当此关键帧作为三次插值的起始点时，此关键帧的切线权重。其他情况下该字段无意义。
         */
        rightTangentWeight: number;
        /**
         * @en
         * The tangent of this keyframe
         * when it's used as ending point during cubic interpolation.
         * Regarded otherwise.
         * @zh
         * 当此关键帧作为三次插值的目标点时，此关键帧的切线。其他情况下该字段无意义。
         */
        leftTangent: number;
        /**
         * @en
         * The tangent weight of this keyframe
         * when it's used as ending point during weighted cubic interpolation.
         * Regarded otherwise.
         * @zh
         * 当此关键帧作为三次插值的目标点时，此关键帧的切线权重。其他情况下该字段无意义。
         */
        leftTangentWeight: number;
        /**
         * @deprecated Reserved for backward compatibility. Will be removed in future.
         */
        get easingMethod(): __private._cocos_core_curves_easing_method__EasingMethod;
        set easingMethod(value: __private._cocos_core_curves_easing_method__EasingMethod);
    }
    /**
     * @en
     * Quaternion curve.
     * @zh
     * 四元数曲线
     */
    export class QuatCurve extends __private._cocos_core_curves_keyframe_curve__KeyframeCurve<QuatKeyframeValue> {
        constructor();
        /**
         * @en
         * Gets or sets the pre-extrapolation-mode of this curve.
         * Defaults to `ExtrapolationMode.CLAMP`.
         * @zh
         * 获取或设置此曲线的前向外推模式。
         * 默认为 `ExtrapolationMode.CLAMP`。
         */
        preExtrapolation: ExtrapolationMode;
        /**
         * @en
         * Gets or sets the post-extrapolation-mode of this curve.
         * Defaults to `ExtrapolationMode.CLAMP`.
         * @zh
         * 获取或设置此曲线的后向外推模式。
         * 默认为 `ExtrapolationMode.CLAMP`。
         */
        postExtrapolation: ExtrapolationMode;
        /**
         * @en
         * Evaluates this curve at specified time.
         * @zh
         * 计算此曲线在指定时间上的值。
         * @param time Input time.
         * @param quat If specified, this value will be filled and returned.
         * Otherwise a new quaternion object will be filled and returned.
         * @returns Result value.
         */
        evaluate(time: number, quat?: math.Quat): math.Quat;
        /**
         * Adds a keyframe into this curve.
         * @param time Time of the keyframe.
         * @param value Value of the keyframe.
         * @returns The index to the new keyframe.
         */
        addKeyFrame(time: number, value: __private._cocos_core_curves_quat_curve__QuatKeyframeValueParameters): number;
        /**
         * Assigns all keyframes.
         * @param keyframes An iterable to keyframes. The keyframes should be sorted by their time.
         */
        assignSorted(keyframes: Iterable<[
            number,
            __private._cocos_core_curves_quat_curve__QuatKeyframeValueParameters
        ]>): void;
        /**
         * Assigns all keyframes.
         * @param times Times array. Should be sorted.
         * @param values Values array. Corresponding to each time in `times`.
         */
        assignSorted(times: readonly number[], values: __private._cocos_core_curves_quat_curve__QuatKeyframeValueParameters[]): void;
        /**
         * @internal
         */
        [serializeTag](output: SerializationOutput, context: SerializationContext): void;
        /**
         * @internal
         */
        [deserializeTag](input: SerializationInput, context: __private._cocos_core_data_custom_serializable__DeserializationContext): void;
    }
    /**
     * @en
     * The method used for interpolation between values of a quaternion keyframe and its next keyframe.
     * @zh
     * 在某四元数关键帧（前一帧）和其下一帧之间插值时使用的插值方式。
     */
    export enum QuatInterpolationMode {
        /**
         * @en
         * Perform spherical linear interpolation between previous keyframe value and next keyframe value.
         * @zh
         * 在前一帧和后一帧之间执行球面线性插值。
         */
        SLERP = 0,
        /**
         * @en
         * Always use the value from this keyframe.
         * @zh
         * 永远使用前一帧的值。
         */
        CONSTANT = 1
    }
    /**
     * View to a quaternion frame value.
     * Note, the view may be invalidated due to keyframe change/add/remove.
     */
    export class QuatKeyframeValue {
        /**
         * @en
         * When perform interpolation, the interpolation method should be taken
         * when for this keyframe is used as starting keyframe.
         * @zh
         * 在执行插值时，当以此关键帧作为起始关键帧时应当使用的插值方式。
         */
        interpolationMode: QuatInterpolationMode;
        /**
         * @en
         * Value of the keyframe.
         * @zh
         * 该关键帧的值。
         */
        value: math.IQuatLike;
        /**
         * @internal Reserved for backward compatibility. Will be removed in future.
         */
        easingMethod: __private._cocos_core_curves_easing_method__EasingMethod | [
            number,
            number,
            number,
            number
        ];
        constructor({ value, interpolationMode, easingMethod, }?: Partial<QuatKeyframeValue>);
    }
    export class ObjectCurve<T> extends __private._cocos_core_curves_keyframe_curve__KeyframeCurve<ObjectCurveKeyframe<T>> {
        evaluate(time: number): T;
    }
    export type ObjectCurveKeyframe<T> = T;
    export class ColorKey {
        /**
         * @en Color value.
         * @zh 颜色值。
         */
        color: math.Color;
        /**
         * @en Time value.
         * @zh 时间值。
         */
        time: number;
    }
    export class AlphaKey {
        /**
         * @en Alpha value.
         * @zh 透明度。
         */
        alpha: number;
        /**
         * @en Time.
         * @zh 时间帧。
         */
        time: number;
    }
    /**
     * @en Gradient is a component that has a lot of color keys and alpha keys to get the interpolated color value.
     * @zh 渐变曲线控件包含了颜色关键帧和透明度关键帧，在关键帧中进行插值渐变返回最终的颜色值。
     */
    export class Gradient {
        /**
         * @en
         * There are 2 kind of mode:
         * Blend just interpolate the nearest 2 colors from keys.
         * Fixed get the nearest color from keys without interpolate.
         * @zh
         * 这个控件包含了两种取色模式：
         * 混合模式对取到的最近两个颜色帧进行插值计算。
         * 固定模式直接取最近的颜色帧返回，不进行插值。
         */
        static Mode: {
            Blend: number;
            Fixed: number;
        };
        /**
         * @en Array of color key.
         * @zh 颜色关键帧列表。
         */
        colorKeys: ColorKey[];
        /**
         * @en Array of alpha key.
         * @zh 透明度关键帧列表。
         */
        alphaKeys: AlphaKey[];
        /**
         * @en Blend mode.
         * @zh 混合模式。
         */
        mode: number;
        /**
         * @en Set color keys array and alpha keys array.
         * @zh 设置颜色和透明度的关键帧列表。
         * @param colorKeys @en Array of color keys @zh 颜色关键帧列表
         * @param alphaKeys @en Array of alpha keys @zh 透明度关键帧列表
         */
        setKeys(colorKeys: ColorKey[], alphaKeys: AlphaKey[]): void;
        /**
         * @en Sort color keys and alpha keys.
         * @zh 对颜色和透明度的关键帧进行排序。
         */
        sortKeys(): void;
        /**
         * @en Interpolate color and alpha from color and alpha keys.
         * @zh 根据颜色列表插值计算颜色和透明度。
         * @param time @en Normalized time to interpolate. @zh 用于插值的归一化时间。
         * @returns @en Interpolated color value. @zh 插值过后的颜色值。
         *
         * @deprecated since v3.8 please use [[evaluateFast]] instead.
         */
        evaluate(time: number): math.Color;
        /**
         * @en Interpolate color and alpha from color and alpha keys.
         * @zh 根据颜色列表插值计算颜色和透明度。
         * @param out @en Interpolated color value. @zh 插值过后的颜色值。
         * @param time @en Normalized time to interpolate. @zh 用于插值的归一化时间。
         * @returns @en Interpolated color value. @zh 插值过后的颜色值。
         */
        evaluateFast(out: math.Color, time: number): math.Color;
        /**
         * @en Generates a random color and alpha.
         * @zh 随机生成颜色和透明度。
         * @returns @en Randomized color. @zh 随机生成的颜色。
         * @deprecated since v3.8 please use [[getRandomColor]] instead.
         */
        randomColor(): math.Color;
        /**
         * @en Generates a random color and alpha.
         * @zh 随机生成颜色和透明度。
         * @param out @en Randomized color. @zh 随机生成的颜色。
         * @returns @en Randomized color. @zh 随机生成的颜色。
         */
        getRandomColor(out: math.Color): math.Color;
    }
    /**
     * @zh
     * Settings 中的默认分组，通常与模块一一对应。
     *
     * @en
     * The default grouping in Settings, which usually corresponds to the module.
     */
    export enum SettingsCategory {
        PATH = "path",
        ENGINE = "engine",
        ASSETS = "assets",
        SCRIPTING = "scripting",
        PHYSICS = "physics",
        RENDERING = "rendering",
        LAUNCH = "launch",
        SCREEN = "screen",
        SPLASH_SCREEN = "splashScreen",
        ANIMATION = "animation",
        PROFILING = "profiling",
        PLUGINS = "plugins",
        XR = "xr"
    }
    /**
     * @zh
     * 配置模块用于获取 settings.json 配置文件中的配置信息，同时你可以覆盖一些配置从而影响引擎的启动和运行，可参考 [game.init] 的参数选项说明。你可以通过 [settings] 访问此模块单例。
     * @en
     * The Settings module is used to get the configuration information in the settings.json configuration file,
     * and you can override some of the configuration to affect the launch and running of the engine, as described in the [game.init] parameter options.
     * You can access this single instance of the module via [settings].
     */
    export class Settings {
        static Category: typeof SettingsCategory;
        /**
         * Initialization
         * @internal
         */
        init(path?: string, overrides?: Record<string, any>): Promise<void>;
        /**
         * @zh
         * 覆盖一部分配置数据。
         *
         * @en
         * Override some configuration info in Settings module.
         *
         * @param category @en The category you want to override. @zh 想要覆盖的分组。
         * @param name @en The name of the configuration in the category you want to override. @zh 分组中想要覆盖的具体配置名称。
         * @param value @en The value of the configuration you want to override. @zh 想要覆盖的具体值。
         *
         * @example
         * ```ts
         * console.log(settings.querySettings(SettingsCategory.ASSETS, 'server')); // print https://www.cocos.com
         * settings.overrideSettings(SettingsCategory.ASSETS, 'server', 'http://www.test.com');
         * console.log(settings.querySettings(SettingsCategory.ASSETS, 'server')); // print http://www.test.com
         * ```
         */
        overrideSettings<T = any>(category: SettingsCategory | string, name: string, value: T): void;
        /**
         * @zh
         * 查询配置模块中具体分组中的具体配置值。
         *
         * @en
         * Query specific configuration values in specific category in the settings module.
         *
         * @param category @en The name of category to query. @zh 想要查询的分组名称。
         * @param name @en The name of configuration in category to query. @zh 分组中想要查询的具体的配置名称。
         * @returns @en The value of configuration to query. @zh 想要查询的具体配置值。
         *
         * @example
         * ```ts
         * console.log(settings.querySettings(SettingsCategory.ENGINE, 'debug')); // print false
         * ```
         */
        querySettings<T = any>(category: SettingsCategory | string, name: string): T | null;
    }
    export namespace Settings {
        export type Category = typeof SettingsCategory;
    }
    /**
     * @zh
     * Settings 模块单例，你能通过此单例访问 settings.json 中的配置数据。
     * @en
     * Settings module singleton, through this you can access the configuration data in settings.json.
     */
    export const settings: Settings;
    /**
     * @en Base class for all functional system managed by [[Director]].
     * @zh 功能系统的基类，由 [[Director]] 管理。
     */
    export class System implements ISchedulable {
        static Priority: {
            LOW: number;
            MEDIUM: number;
            HIGH: number;
            SCHEDULER: number;
        };
        protected _id: string;
        protected _priority: number;
        protected _executeInEditMode: boolean;
        set priority(value: number);
        get priority(): number;
        set id(id: string);
        get id(): string;
        /**
         * @en Sorting between different systems.
         * @zh 不同系统间排序。
         * @param a System a
         * @param b System b
         */
        static sortByPriority(a: System, b: System): number;
        /**
         * @en Init the system, will be invoked by [[Director]] when registered, should be implemented if needed.
         * @zh 系统初始化函数，会在注册时被 [[Director]] 调用，如果需要的话应该由子类实现
         */
        init(): void;
        /**
         * @en Update function of the system, it will be invoked between all components update phase and late update phase.
         * @zh 系统的帧更新函数，它会在所有组件的 update 和 lateUpdate 之间被调用
         * @param dt Delta time after the last frame
         */
        update(dt: number): void;
        /**
         * @en Post update function of the system, it will be invoked after all components late update phase and before the rendering process.
         * @zh 系统的帧后处理函数，它会在所有组件的 lateUpdate 之后以及渲染之前被调用
         * @param dt Delta time after the last frame
         */
        postUpdate(dt: number): void;
        destroy(): void;
    }
    export namespace easing {
        /**
         * @en Not any easing effect.
         * @zh 没有任何缓动效果。
         */
        export function constant(): number;
        /**
         * @en A linear function, `f(k) = k`. Result correlates to input value one to one.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 线性函数，`f(k) = k`。返回值和输入值一一对应。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function linear(k: number): number;
        /**
         * @en A quadratic function, f(k) = k * k. The interpolation starts slowly, then progressively speeds up until the end,
         * at which point it stops abruptly. Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 一个二次方的函数，f(k) = k * k。插值开始时很慢，然后逐渐加快，直到结束，并突然停止。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function quadIn(k: number): number;
        /**
         * @en A quadratic function, f(k) = k * (2-k). The interpolation starts abruptly and then progressively slows down towards the end. Refer to
         * [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 一个二次方的函数，f(k) = k * (2-k)。插值开始时很突然，然后在接近尾声时逐渐减慢。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function quadOut(k: number): number;
        /**
         * @en The interpolation starts slowly, speeds up, and then slows down towards the end. Refer to
         * [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) graphic feature.
         * @zh 插值开始时很慢，接着加快，然后在接近尾声时减慢。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function quadInOut(k: number): number;
        /**
         * @en Starts slowly and accelerates. Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 启动慢，加速快。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function cubicIn(k: number): number;
        /**
         * @en Starts quickly and decelerates.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 起动迅速，减速慢。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function cubicOut(k: number): number;
        /**
         * @en Accelerates the animation at the beginning, and decelerates the animation at the end.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 在开始时加速动画，在结束时减慢动画的速度。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function cubicInOut(k: number): number;
        /**
         * @en Starts slowly and accelerates. Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 启动慢，加速快。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function quartIn(k: number): number;
        /**
         * @en Starts quickly and decelerates.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 起动迅速，减速慢。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function quartOut(k: number): number;
        /**
         * @en Accelerates the animation at the beginning, and decelerates the animation at the end.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 在开始时加速动画，在结束时减慢动画的速度。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function quartInOut(k: number): number;
        /**
         * @en Starts slowly and accelerates. Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 启动慢，加速快。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function quintIn(k: number): number;
        /**
         * @en Starts quickly and decelerates.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 起动迅速，减速慢。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function quintOut(k: number): number;
        /**
         * @en Accelerates the animation at the beginning, and decelerates the animation at the end.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 在开始时加速动画，在结束时减慢动画的速度。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function quintInOut(k: number): number;
        /**
         * @en Smoothly accelerates the animation.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 平滑地加速动画。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function sineIn(k: number): number;
        /**
         * @en Smoothly decelerates the animation.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 平滑地使动画降速。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function sineOut(k: number): number;
        /**
         * @en Smoothly accelerates the animation at the beginning, and smoothly decelerates the animation at the end.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 在开始时平滑地加速动画，在结束时平滑地减速动画。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function sineInOut(k: number): number;
        /**
         * @en Starts slowly and accelerates. Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 启动慢，加速快。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function expoIn(k: number): number;
        /**
         * @en Starts quickly and decelerates.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 起动迅速，减速慢。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function expoOut(k: number): number;
        /**
         * @en Accelerates the animation at the beginning, and decelerates the animation at the end.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 在开始时加速动画，在结束时减慢动画的速度。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function expoInOut(k: number): number;
        /**
         * @en Starts slowly and accelerates. Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 启动慢，加速快。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function circIn(k: number): number;
        /**
         * @en Starts quickly and decelerates.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 起动迅速，减速慢。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function circOut(k: number): number;
        /**
         * @en Accelerates the animation at the beginning, and decelerates the animation at the end.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 在开始时加速动画，在结束时减慢动画的速度。具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function circInOut(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function elasticIn(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function elasticOut(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function elasticInOut(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function backIn(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function backOut(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function backInOut(k: number): number;
        export function bounceIn(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function bounceOut(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function bounceInOut(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function smooth(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export function fade(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export const quadOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export const cubicOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export const quartOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export const quintOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export const sineOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export const expoOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export const circOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export const elasticOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export const backOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh 具体效果可以参考[该文档](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)。
         */
        export const bounceOutIn: (k: number) => number;
    }
    export function bezier(C1: number, C2: number, C3: number, C4: number, t: number): number;
    export function bezierByTime(controlPoints: BezierControlPoints, x: number): number;
    export type BezierControlPoints = [
        number,
        number,
        number,
        number
    ];
    export function setPropertyEnumType(objectOrConstructor: object, propertyName: string, enumType: __private._cocos_core_value_types_enum__EnumType): void;
    export function setPropertyEnumTypeOnAttrs(attrs: Record<string, any>, propertyName: string, enumType: __private._cocos_core_value_types_enum__EnumType): void;
    export function isCCObject(object: any): object is CCObject;
    export function isValid(value: any, strictMode?: boolean): boolean;
    export namespace pipeline {
        export enum SetIndex {
            GLOBAL = 0,
            MATERIAL = 1,
            LOCAL = 2,
            COUNT = 3
        }
        /**
         * @en The predefined render priorities
         * @zh 预设的渲染优先级。
         */
        export enum RenderPriority {
            MIN = 0,
            MAX = 255,
            DEFAULT = 128
        }
        /**
         * @internal This method only used to init localDescriptorSetLayout.layouts[UBOSkinning.NAME]
         */
        export function localDescriptorSetLayout_ResizeMaxJoints(maxCount: number): void;
        /**
         * @en Does the device support single-channeled half float texture? (for both color attachment and sampling)
         * @zh 当前设备是否支持单通道半浮点贴图？（颜色输出和采样）
         */
        export function supportsR16HalfFloatTexture(device: gfx.Device): boolean;
        export function getDefaultShadowTexture(device: gfx.Device): gfx.Texture;
        /**
         * @en Does the device support single-channeled float texture? (for both color attachment and sampling)
         * @zh 当前设备是否支持单通道浮点贴图？（颜色输出和采样）
         */
        export function supportsR32FloatTexture(device: gfx.Device): boolean;
        /**
         * @en Does the device support 4-channeled float texture? (for both color attachment and sampling)
         * @zh 当前设备是否支持4通道浮点贴图？（颜色输出和采样）
         */
        export function supportsRGBA16HalfFloatTexture(device: gfx.Device): boolean;
        /**
         * @en Does the device support 4-channeled float texture? (for both color attachment and sampling)
         * @zh 当前设备是否支持4通道浮点贴图？（颜色输出和采样）
         */
        export function supportsRGBA32FloatTexture(device: gfx.Device): boolean;
        export function isEnableEffect(): boolean;
        export const PIPELINE_FLOW_MAIN = "MainFlow";
        export const PIPELINE_FLOW_FORWARD = "ForwardFlow";
        export const PIPELINE_FLOW_SHADOW = "ShadowFlow";
        export const PIPELINE_FLOW_SMAA = "SMAAFlow";
        export const PIPELINE_FLOW_TONEMAP = "ToneMapFlow";
        /**
         * @en The predefined render pass stage ids
         * @zh 预设的渲染阶段。
         */
        export enum RenderPassStage {
            DEFAULT = 100,
            UI = 200
        }
        /**
         * @en Render object interface
         * @zh 渲染对象接口。
         */
        export interface IRenderObject {
            model: renderer.scene.Model;
            depth: number;
        }
        export interface IRenderPass {
            priority: number;
            hash: number;
            depth: number;
            shaderId: number;
            subModel: renderer.scene.SubModel;
            passIdx: number;
        }
        /**
         * @en Render batch interface
         * @zh 渲染批次接口。
         */
        export interface IRenderBatch {
            pass: renderer.Pass;
        }
        /**
         * @en Render queue descriptor
         * @zh 渲染队列描述。
         */
        export interface IRenderQueueDesc {
            isTransparent: boolean;
            phases: number;
            sortFunc: (a: IRenderPass, b: IRenderPass) => number;
        }
        export interface IDescriptorSetLayoutInfo {
            bindings: gfx.DescriptorSetLayoutBinding[];
            layouts: Record<string, gfx.UniformBlock | gfx.UniformSamplerTexture | gfx.UniformStorageImage | gfx.UniformStorageBuffer>;
        }
        export const globalDescriptorSetLayout: IDescriptorSetLayoutInfo;
        export const localDescriptorSetLayout: IDescriptorSetLayoutInfo;
        /**
         * @en The uniform bindings
         * @zh Uniform 参数绑定。
         */
        export enum PipelineGlobalBindings {
            UBO_GLOBAL = 0,
            UBO_CAMERA = 1,
            UBO_SHADOW = 2,
            UBO_CSM = 3,
            SAMPLER_SHADOWMAP = 4,
            SAMPLER_ENVIRONMENT = 5,
            SAMPLER_SPOT_SHADOW_MAP = 6,
            SAMPLER_DIFFUSEMAP = 7,
            COUNT = 8
        }
        export enum ModelLocalBindings {
            UBO_LOCAL = 0,
            UBO_FORWARD_LIGHTS = 1,
            UBO_SKINNING_ANIMATION = 2,
            UBO_SKINNING_TEXTURE = 3,
            UBO_MORPH = 4,
            UBO_UI_LOCAL = 5,
            UBO_SH = 6,
            SAMPLER_JOINTS = 7,
            SAMPLER_MORPH_POSITION = 8,
            SAMPLER_MORPH_NORMAL = 9,
            SAMPLER_MORPH_TANGENT = 10,
            SAMPLER_LIGHTMAP = 11,
            SAMPLER_SPRITE = 12,
            SAMPLER_REFLECTION = 13,
            STORAGE_REFLECTION = 14,
            SAMPLER_REFLECTION_PROBE_CUBE = 15,
            SAMPLER_REFLECTION_PROBE_PLANAR = 16,
            SAMPLER_REFLECTION_PROBE_DATA_MAP = 17,
            SAMPLER_REFLECTION_PROBE_BLEND_CUBE = 18,
            COUNT = 19
        }
        export const bindingMappingInfo: gfx.BindingMappingInfo;
        export enum UBOGlobalEnum {
            TIME_OFFSET = 0,
            SCREEN_SIZE_OFFSET = 4,
            NATIVE_SIZE_OFFSET = 8,
            PROBE_INFO_OFFSET = 12,
            DEBUG_VIEW_MODE_OFFSET = 16,
            COUNT = 20,
            SIZE = 80
        }
        /**
         * @en The global uniform buffer object
         * @zh 全局 UBO。
         */
        export class UBOGlobal {
            static readonly TIME_OFFSET: UBOGlobalEnum;
            static readonly SCREEN_SIZE_OFFSET: UBOGlobalEnum;
            static readonly NATIVE_SIZE_OFFSET: UBOGlobalEnum;
            static readonly PROBE_INFO_OFFSET: UBOGlobalEnum;
            static readonly DEBUG_VIEW_MODE_OFFSET: UBOGlobalEnum;
            static readonly COUNT: UBOGlobalEnum;
            static readonly SIZE: UBOGlobalEnum;
            static readonly NAME = "CCGlobal";
            static readonly BINDING = PipelineGlobalBindings.UBO_GLOBAL;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export enum UBOCameraEnum {
            MAT_VIEW_OFFSET = 0,
            MAT_VIEW_INV_OFFSET = 16,
            MAT_PROJ_OFFSET = 32,
            MAT_PROJ_INV_OFFSET = 48,
            MAT_VIEW_PROJ_OFFSET = 64,
            MAT_VIEW_PROJ_INV_OFFSET = 80,
            CAMERA_POS_OFFSET = 96,
            SURFACE_TRANSFORM_OFFSET = 100,
            SCREEN_SCALE_OFFSET = 104,
            EXPOSURE_OFFSET = 108,
            MAIN_LIT_DIR_OFFSET = 112,
            MAIN_LIT_COLOR_OFFSET = 116,
            AMBIENT_SKY_OFFSET = 120,
            AMBIENT_GROUND_OFFSET = 124,
            GLOBAL_FOG_COLOR_OFFSET = 128,
            GLOBAL_FOG_BASE_OFFSET = 132,
            GLOBAL_FOG_ADD_OFFSET = 136,
            NEAR_FAR_OFFSET = 140,
            VIEW_PORT_OFFSET = 144,
            COUNT = 148,
            SIZE = 592
        }
        /**
         * @en The global camera uniform buffer object
         * @zh 全局相机 UBO。
         */
        export class UBOCamera {
            static readonly MAT_VIEW_OFFSET: UBOCameraEnum;
            static readonly MAT_VIEW_INV_OFFSET: UBOCameraEnum;
            static readonly MAT_PROJ_OFFSET: UBOCameraEnum;
            static readonly MAT_PROJ_INV_OFFSET: UBOCameraEnum;
            static readonly MAT_VIEW_PROJ_OFFSET: UBOCameraEnum;
            static readonly MAT_VIEW_PROJ_INV_OFFSET: UBOCameraEnum;
            static readonly CAMERA_POS_OFFSET: UBOCameraEnum;
            static readonly SURFACE_TRANSFORM_OFFSET: UBOCameraEnum;
            static readonly SCREEN_SCALE_OFFSET: UBOCameraEnum;
            static readonly EXPOSURE_OFFSET: UBOCameraEnum;
            static readonly MAIN_LIT_DIR_OFFSET: UBOCameraEnum;
            static readonly MAIN_LIT_COLOR_OFFSET: UBOCameraEnum;
            static readonly AMBIENT_SKY_OFFSET: UBOCameraEnum;
            static readonly AMBIENT_GROUND_OFFSET: UBOCameraEnum;
            static readonly GLOBAL_FOG_COLOR_OFFSET: UBOCameraEnum;
            static readonly GLOBAL_FOG_BASE_OFFSET: UBOCameraEnum;
            static readonly GLOBAL_FOG_ADD_OFFSET: UBOCameraEnum;
            static readonly NEAR_FAR_OFFSET: UBOCameraEnum;
            static readonly VIEW_PORT_OFFSET: UBOCameraEnum;
            static readonly COUNT: UBOCameraEnum;
            static readonly SIZE: UBOCameraEnum;
            static readonly NAME = "CCCamera";
            static readonly BINDING = PipelineGlobalBindings.UBO_CAMERA;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export enum UBOShadowEnum {
            MAT_LIGHT_VIEW_OFFSET = 0,
            MAT_LIGHT_VIEW_PROJ_OFFSET = 16,
            SHADOW_INV_PROJ_DEPTH_INFO_OFFSET = 32,
            SHADOW_PROJ_DEPTH_INFO_OFFSET = 36,
            SHADOW_PROJ_INFO_OFFSET = 40,
            SHADOW_NEAR_FAR_LINEAR_SATURATION_INFO_OFFSET = 44,
            SHADOW_WIDTH_HEIGHT_PCF_BIAS_INFO_OFFSET = 48,
            SHADOW_LIGHT_PACKING_NBIAS_NULL_INFO_OFFSET = 52,
            SHADOW_COLOR_OFFSET = 56,
            PLANAR_NORMAL_DISTANCE_INFO_OFFSET = 60,
            COUNT = 64,
            SIZE = 256
        }
        /**
         * @en The uniform buffer object for 'cast shadow(fixed || csm)' && 'dir fixed area shadow' && 'spot shadow' && 'sphere shadow' && 'planar shadow'
         * @zh 这个 UBO 仅仅只给 'cast shadow(fixed || csm)' && 'dir fixed area shadow' && 'spot shadow' && 'sphere shadow' && 'planar shadow' 使用
         */
        export class UBOShadow {
            static readonly MAT_LIGHT_VIEW_OFFSET: UBOShadowEnum;
            static readonly MAT_LIGHT_VIEW_PROJ_OFFSET: UBOShadowEnum;
            static readonly SHADOW_INV_PROJ_DEPTH_INFO_OFFSET: UBOShadowEnum;
            static readonly SHADOW_PROJ_DEPTH_INFO_OFFSET: UBOShadowEnum;
            static readonly SHADOW_PROJ_INFO_OFFSET: UBOShadowEnum;
            static readonly SHADOW_NEAR_FAR_LINEAR_SATURATION_INFO_OFFSET: UBOShadowEnum;
            static readonly SHADOW_WIDTH_HEIGHT_PCF_BIAS_INFO_OFFSET: UBOShadowEnum;
            static readonly SHADOW_LIGHT_PACKING_NBIAS_NULL_INFO_OFFSET: UBOShadowEnum;
            static readonly SHADOW_COLOR_OFFSET: UBOShadowEnum;
            static readonly PLANAR_NORMAL_DISTANCE_INFO_OFFSET: UBOShadowEnum;
            static readonly COUNT: UBOShadowEnum;
            static readonly SIZE: UBOShadowEnum;
            static readonly NAME = "CCShadow";
            static readonly BINDING = PipelineGlobalBindings.UBO_SHADOW;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export enum UBOCSMEnum {
            CSM_LEVEL_COUNT = 4,
            CSM_VIEW_DIR_0_OFFSET = 0,
            CSM_VIEW_DIR_1_OFFSET = 16,
            CSM_VIEW_DIR_2_OFFSET = 32,
            CSM_ATLAS_OFFSET = 48,
            MAT_CSM_VIEW_PROJ_OFFSET = 64,
            CSM_PROJ_DEPTH_INFO_OFFSET = 128,
            CSM_PROJ_INFO_OFFSET = 144,
            CSM_SPLITS_INFO_OFFSET = 160,
            COUNT = 164,
            SIZE = 656
        }
        /**
         * @en The uniform buffer object only for dir csm shadow(level: 1 ~ 4)
         * @zh 级联阴影使用的UBO
         */
        export class UBOCSM {
            static readonly CSM_LEVEL_COUNT: UBOCSMEnum;
            static readonly CSM_VIEW_DIR_0_OFFSET: UBOCSMEnum;
            static readonly CSM_VIEW_DIR_1_OFFSET: UBOCSMEnum;
            static readonly CSM_VIEW_DIR_2_OFFSET: UBOCSMEnum;
            static readonly CSM_ATLAS_OFFSET: UBOCSMEnum;
            static readonly MAT_CSM_VIEW_PROJ_OFFSET: UBOCSMEnum;
            static readonly CSM_PROJ_DEPTH_INFO_OFFSET: UBOCSMEnum;
            static readonly CSM_PROJ_INFO_OFFSET: UBOCSMEnum;
            static readonly CSM_SPLITS_INFO_OFFSET: UBOCSMEnum;
            static readonly COUNT: number;
            static readonly SIZE: UBOCSMEnum;
            static readonly NAME = "CCCSM";
            static readonly BINDING = PipelineGlobalBindings.UBO_CSM;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export const UNIFORM_SHADOWMAP_BINDING = PipelineGlobalBindings.SAMPLER_SHADOWMAP;
        export const UNIFORM_ENVIRONMENT_BINDING = PipelineGlobalBindings.SAMPLER_ENVIRONMENT;
        export const UNIFORM_DIFFUSEMAP_BINDING = PipelineGlobalBindings.SAMPLER_DIFFUSEMAP;
        export const UNIFORM_SPOT_SHADOW_MAP_TEXTURE_BINDING = PipelineGlobalBindings.SAMPLER_SPOT_SHADOW_MAP;
        export enum UBOLocalEnum {
            MAT_WORLD_OFFSET = 0,
            MAT_WORLD_IT_OFFSET = 16,
            LIGHTINGMAP_UVPARAM = 32,
            LOCAL_SHADOW_BIAS = 36,
            REFLECTION_PROBE_DATA1 = 40,
            REFLECTION_PROBE_DATA2 = 44,
            REFLECTION_PROBE_BLEND_DATA1 = 48,
            REFLECTION_PROBE_BLEND_DATA2 = 52,
            COUNT = 56,
            SIZE = 224
        }
        /**
         * @en The local uniform buffer object
         * @zh 本地 UBO。
         */
        export class UBOLocal {
            static readonly MAT_WORLD_OFFSET: UBOLocalEnum;
            static readonly MAT_WORLD_IT_OFFSET: UBOLocalEnum;
            static readonly LIGHTINGMAP_UVPARAM: UBOLocalEnum;
            static readonly LOCAL_SHADOW_BIAS: UBOLocalEnum;
            static readonly REFLECTION_PROBE_DATA1: UBOLocalEnum;
            static readonly REFLECTION_PROBE_DATA2: UBOLocalEnum;
            static readonly REFLECTION_PROBE_BLEND_DATA1: UBOLocalEnum;
            static readonly REFLECTION_PROBE_BLEND_DATA2: UBOLocalEnum;
            static readonly COUNT: UBOLocalEnum;
            static readonly SIZE: UBOLocalEnum;
            static readonly NAME = "CCLocal";
            static readonly BINDING = ModelLocalBindings.UBO_LOCAL;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        /**
         * @en The world bound uniform buffer object
         * @zh 世界空间包围盒 UBO。
         */
        export class UBOWorldBound {
            static readonly WORLD_BOUND_CENTER = 0;
            static readonly WORLD_BOUND_HALF_EXTENTS: number;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCWorldBound";
            static readonly BINDING = ModelLocalBindings.UBO_LOCAL;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export const INST_MAT_WORLD = "a_matWorld0";
        export const INST_SH = "a_sh_linear_const_r";
        export class UBOLocalBatched {
            static readonly BATCHING_COUNT = 10;
            static readonly MAT_WORLDS_OFFSET = 0;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCLocalBatched";
            static readonly BINDING = ModelLocalBindings.UBO_LOCAL;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export enum UBOForwardLightEnum {
            LIGHTS_PER_PASS = 1,
            LIGHT_POS_OFFSET = 0,
            LIGHT_COLOR_OFFSET = 4,
            LIGHT_SIZE_RANGE_ANGLE_OFFSET = 8,
            LIGHT_DIR_OFFSET = 12,
            LIGHT_BOUNDING_SIZE_VS_OFFSET = 16,
            COUNT = 20,
            SIZE = 80
        }
        /**
         * @en The uniform buffer object for forward lighting
         * @zh 前向灯光 UBO。
         */
        export class UBOForwardLight {
            static readonly LIGHTS_PER_PASS: UBOForwardLightEnum;
            static readonly LIGHT_POS_OFFSET: UBOForwardLightEnum;
            static readonly LIGHT_COLOR_OFFSET: UBOForwardLightEnum;
            static readonly LIGHT_SIZE_RANGE_ANGLE_OFFSET: UBOForwardLightEnum;
            static readonly LIGHT_DIR_OFFSET: UBOForwardLightEnum;
            static readonly LIGHT_BOUNDING_SIZE_VS_OFFSET: UBOForwardLightEnum;
            static readonly COUNT: UBOForwardLightEnum;
            static readonly SIZE: UBOForwardLightEnum;
            static readonly NAME = "CCForwardLight";
            static readonly BINDING = ModelLocalBindings.UBO_FORWARD_LIGHTS;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export class UBODeferredLight {
            static readonly LIGHTS_PER_PASS = 10;
        }
        export const JOINT_UNIFORM_CAPACITY = 30;
        /**
         * @en The uniform buffer object for skinning texture
         * @zh 骨骼贴图 UBO。
         */
        export class UBOSkinningTexture {
            static readonly JOINTS_TEXTURE_INFO_OFFSET = 0;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCSkinningTexture";
            static readonly BINDING = ModelLocalBindings.UBO_SKINNING_TEXTURE;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export class UBOSkinningAnimation {
            static readonly JOINTS_ANIM_INFO_OFFSET = 0;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCSkinningAnimation";
            static readonly BINDING = ModelLocalBindings.UBO_SKINNING_ANIMATION;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export const INST_JOINT_ANIM_INFO = "a_jointAnimInfo";
        export class UBOSkinning {
            static get JOINT_UNIFORM_CAPACITY(): number;
            static get COUNT(): number;
            static get SIZE(): number;
            static readonly NAME = "CCSkinning";
            static readonly BINDING = ModelLocalBindings.UBO_SKINNING_TEXTURE;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
            /**
             * @internal This method only used init UBOSkinning configure.
             */
            static initLayout(capacity: number): void;
        }
        export enum UBOMorphEnum {
            MAX_MORPH_TARGET_COUNT = 60,
            OFFSET_OF_WEIGHTS = 0,
            OFFSET_OF_DISPLACEMENT_TEXTURE_WIDTH = 240,
            OFFSET_OF_DISPLACEMENT_TEXTURE_HEIGHT = 244,
            OFFSET_OF_VERTICES_COUNT = 248,
            COUNT_BASE_4_BYTES = 64,
            SIZE = 256
        }
        /**
         * @en The uniform buffer object for morph setting
         * @zh 形变配置的 UBO
         */
        export class UBOMorph {
            static readonly MAX_MORPH_TARGET_COUNT: UBOMorphEnum;
            static readonly OFFSET_OF_WEIGHTS: UBOMorphEnum;
            static readonly OFFSET_OF_DISPLACEMENT_TEXTURE_WIDTH: UBOMorphEnum;
            static readonly OFFSET_OF_DISPLACEMENT_TEXTURE_HEIGHT: UBOMorphEnum;
            static readonly OFFSET_OF_VERTICES_COUNT: UBOMorphEnum;
            static readonly COUNT_BASE_4_BYTES: UBOMorphEnum;
            static readonly SIZE: UBOMorphEnum;
            static readonly NAME = "CCMorph";
            static readonly BINDING = ModelLocalBindings.UBO_MORPH;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export class UBOUILocal {
            static readonly NAME = "CCUILocal";
            static readonly BINDING = ModelLocalBindings.UBO_UI_LOCAL;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export enum UBOSHEnum {
            SH_LINEAR_CONST_R_OFFSET = 0,
            SH_LINEAR_CONST_G_OFFSET = 4,
            SH_LINEAR_CONST_B_OFFSET = 8,
            SH_QUADRATIC_R_OFFSET = 12,
            SH_QUADRATIC_G_OFFSET = 16,
            SH_QUADRATIC_B_OFFSET = 20,
            SH_QUADRATIC_A_OFFSET = 24,
            COUNT = 28,
            SIZE = 112
        }
        /**
         * @en The SH uniform buffer object
         * @zh 球谐 UBO。
         */
        export class UBOSH {
            static readonly SH_LINEAR_CONST_R_OFFSET: UBOSHEnum;
            static readonly SH_LINEAR_CONST_G_OFFSET: UBOSHEnum;
            static readonly SH_LINEAR_CONST_B_OFFSET: UBOSHEnum;
            static readonly SH_QUADRATIC_R_OFFSET: UBOSHEnum;
            static readonly SH_QUADRATIC_G_OFFSET: UBOSHEnum;
            static readonly SH_QUADRATIC_B_OFFSET: UBOSHEnum;
            static readonly SH_QUADRATIC_A_OFFSET: UBOSHEnum;
            static readonly COUNT: UBOSHEnum;
            static readonly SIZE: UBOSHEnum;
            static readonly NAME = "CCSH";
            static readonly BINDING = ModelLocalBindings.UBO_SH;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export const UNIFORM_JOINT_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_JOINTS;
        export const UNIFORM_REALTIME_JOINT_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_JOINTS;
        export const UNIFORM_POSITION_MORPH_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_MORPH_POSITION;
        export const UNIFORM_NORMAL_MORPH_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_MORPH_NORMAL;
        export const UNIFORM_TANGENT_MORPH_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_MORPH_TANGENT;
        export const UNIFORM_LIGHTMAP_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_LIGHTMAP;
        export const UNIFORM_SPRITE_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_SPRITE;
        export const UNIFORM_REFLECTION_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_REFLECTION;
        export const UNIFORM_REFLECTION_STORAGE_BINDING = ModelLocalBindings.STORAGE_REFLECTION;
        export const UNIFORM_REFLECTION_PROBE_CUBEMAP_BINDING = ModelLocalBindings.SAMPLER_REFLECTION_PROBE_CUBE;
        export const UNIFORM_REFLECTION_PROBE_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_REFLECTION_PROBE_PLANAR;
        export const UNIFORM_REFLECTION_PROBE_DATA_MAP_BINDING = ModelLocalBindings.SAMPLER_REFLECTION_PROBE_DATA_MAP;
        export const UNIFORM_REFLECTION_PROBE_BLEND_CUBEMAP_BINDING = ModelLocalBindings.SAMPLER_REFLECTION_PROBE_BLEND_CUBE;
        export const CAMERA_DEFAULT_MASK: number;
        export const CAMERA_EDITOR_MASK: number;
        export const MODEL_ALWAYS_MASK: number;
    }
    export class PipelineSceneData {
        /**
         * @en Is open HDR.
         * @zh 是否开启 HDR。
         * @readonly
         */
        get isHDR(): boolean;
        set isHDR(val: boolean);
        get shadingScale(): number;
        set shadingScale(val: number);
        get csmSupported(): boolean;
        set csmSupported(val: boolean);
        get skinMaterialModel(): renderer.scene.Model;
        set skinMaterialModel(val: renderer.scene.Model);
        fog: renderer.scene.Fog;
        ambient: renderer.scene.Ambient;
        skybox: renderer.scene.Skybox;
        shadows: renderer.scene.Shadows;
        csmLayers: __private._cocos_rendering_shadow_csm_layers__CSMLayers;
        octree: renderer.scene.Octree;
        skin: renderer.scene.Skin;
        postSettings: renderer.scene.PostSettings;
        lightProbes: LightProbes;
        /**
         * @en The list for valid punctual Lights, only available after the scene culling of the current frame.
         * @zh 场景中精确的有效光源，仅在当前帧的场景剔除完成后有效。
         */
        validPunctualLights: renderer.scene.Light[];
        /**
         * @en The list for render objects, only available after the scene culling of the current frame.
         * @zh 渲染对象数组，仅在当前帧的场景剔除完成后有效。
         */
        renderObjects: pipeline.IRenderObject[];
        shadowFrameBufferMap: Map<renderer.scene.Light, gfx.Framebuffer>;
        protected _device: gfx.Device;
        protected _geometryRendererMaterials: Material[];
        protected _geometryRendererPasses: renderer.Pass[];
        protected _geometryRendererShaders: gfx.Shader[];
        protected _occlusionQueryVertexBuffer: gfx.Buffer | null;
        protected _occlusionQueryIndicesBuffer: gfx.Buffer | null;
        protected _occlusionQueryInputAssembler: gfx.InputAssembler | null;
        protected _occlusionQueryMaterial: Material | null;
        protected _occlusionQueryShader: gfx.Shader | null;
        protected _isHDR: boolean;
        protected _shadingScale: number;
        protected _csmSupported: boolean;
        constructor();
        activate(device: gfx.Device): boolean;
        initGeometryRendererMaterials(): void;
        get geometryRendererPasses(): renderer.Pass[];
        get geometryRendererShaders(): gfx.Shader[];
        initOcclusionQuery(): void;
        getOcclusionQueryPass(): renderer.Pass | null;
        updatePipelineSceneData(): void;
        destroy(): void;
    }
    export class InstancedBuffer {
        instances: __private._cocos_rendering_instanced_buffer__IInstancedItem[];
        pass: renderer.Pass;
        hasPendingModels: boolean;
        dynamicOffsets: number[];
        constructor(pass: renderer.Pass);
        destroy(): void;
        merge(subModel: renderer.scene.SubModel, passIdx: number, shaderImplant?: gfx.Shader | null): void;
        uploadBuffers(cmdBuff: gfx.CommandBuffer): void;
        clear(): void;
    }
    export class PipelineStateManager {
        static getOrCreatePipelineState(device: gfx.Device, pass: renderer.Pass, shader: gfx.Shader, renderPass: gfx.RenderPass, ia: gfx.InputAssembler): gfx.PipelineState;
    }
    export class PipelineEventProcessor extends EventTarget implements __private._cocos_rendering_pipeline_event__IPipelineEvent {
        eventTargetOn: <TFunction extends (...args: any[]) => void>(type: string | number, callback: TFunction, thisArg?: any, once?: boolean | undefined) => TFunction;
        eventTargetOnce: <TFunction extends (...args: any[]) => void>(type: string | number, callback: TFunction, thisArg?: any) => TFunction;
        constructor();
        on<TFunction extends __private._cocos_rendering_pipeline_event__PipelineEventCallback>(type: PipelineEventType, callback: TFunction, target?: any, once?: boolean): typeof callback;
        once<TFunction extends __private._cocos_rendering_pipeline_event__PipelineEventCallback>(type: PipelineEventType, callback: TFunction, target?: any): typeof callback;
    }
    export enum PipelineEventType {
        /**
         * @en
         * The event type for render frame begin event
         *
         * @zh
         * 帧渲染开始事件。
         */
        RENDER_FRAME_BEGIN = "render-frame-begin",
        /**
         * @en
         * The event type for render frame end event
         *
         * @zh
         * 帧渲染结束事件。
         */
        RENDER_FRAME_END = "render-frame-end",
        /**
         * @en
         * The event type for render camera begin event
         *
         * @zh
         * 相机渲染开始事件。
         */
        RENDER_CAMERA_BEGIN = "render-camera-begin",
        /**
         * @en
         * The event type for render camera end event
         *
         * @zh
         * 相机渲染结束事件。
         */
        RENDER_CAMERA_END = "render-camera-end",
        /**
         * @en
         * FBO attachment texture zoom event
         *
         * @zh
         * FBO附件纹理缩放事件。
         */
        ATTACHMENT_SCALE_CAHNGED = "attachment-scale-changed"
    }
    /**
     * @en Rendering debug view control class
     * @zh 渲染调试控制类
     */
    export class DebugView {
        /**
         * @en Toggle rendering single debug mode.
         * @zh 设置渲染单项调试模式。
         */
        get singleMode(): __private._cocos_rendering_debug_view__DebugViewSingleType;
        set singleMode(val: __private._cocos_rendering_debug_view__DebugViewSingleType);
        /**
         * @en Toggle normal / pure lighting mode.
         * @zh 切换正常光照和仅光照模式。
         */
        get lightingWithAlbedo(): boolean;
        set lightingWithAlbedo(val: boolean);
        /**
         * @en Toggle CSM layer coloration mode.
         * @zh 切换级联阴影染色调试模式。
         */
        get csmLayerColoration(): boolean;
        set csmLayerColoration(val: boolean);
        get debugViewType(): __private._cocos_rendering_debug_view__RenderingDebugViewType;
        protected _singleMode: __private._cocos_rendering_debug_view__DebugViewSingleType;
        protected _compositeModeValue: number;
        protected _lightingWithAlbedo: boolean;
        protected _csmLayerColoration: boolean;
        constructor();
        /**
         * @en Whether enabled with specified rendering composite debug mode.
         * @zh 获取指定的渲染组合调试模式是否开启。
         * @param Specified composite type.
         */
        isCompositeModeEnabled(val: number): boolean;
        /**
         * @en Toggle specified rendering composite debug mode.
         * @zh 开关指定的渲染组合调试模式。
         * @param Specified composite type, enable or disable.
         */
        enableCompositeMode(val: __private._cocos_rendering_debug_view__DebugViewCompositeType, enable: boolean): void;
        /**
         * @en Toggle all rendering composite debug mode.
         * @zh 开关所有的渲染组合调试模式。
         */
        enableAllCompositeMode(enable: boolean): void;
        /**
         * @en Get rendering debug view on / off state.
         * @zh 查询当前是否开启了渲染调试模式。
         */
        isEnabled(): boolean;
        /**
         * @en Disable all debug view modes, reset to standard rendering mode.
         * @zh 关闭所有的渲染调试模式，恢复到正常渲染。
         */
        reset(): void;
        /**
         * @internal
         */
        protected _activate(): void;
        protected _updatePipeline(): void;
    }
    export const getPhaseID: (phaseName: string | number) => number;
    export class PipelineInputAssemblerData {
        quadIB: gfx.Buffer | null;
        quadVB: gfx.Buffer | null;
        quadIA: gfx.InputAssembler | null;
    }
    /**
     * @zh
     * 场景树中的基本节点，基本特性有：
     * * 具有层级关系
     * * 持有各类组件
     * * 维护空间变换（坐标、旋转、缩放）信息
     */
    /**
     * @en
     * Class of all entities in Cocos Creator scenes.
     * Basic functionalities include:
     * * Hierarchy management with parent and children
     * * Components management
     * * Coordinate system with position, scale, rotation in 3d space
     * @zh
     * Cocos Creator 场景中的所有节点类。
     * 基本特性有：
     * * 具有层级关系
     * * 持有各类组件
     * * 维护 3D 空间左边变换（坐标、旋转、缩放）信息
     */
    export class Node extends CCObject implements ISchedulable, CustomSerializable {
        /**
         * @en Gets all components attached to this node.
         * @zh 获取附加到此节点的所有组件。
         */
        get components(): ReadonlyArray<Component>;
        /**
         * @en If true, the node is an persist node which won't be destroyed during scene transition.
         * If false, the node will be destroyed automatically when loading a new scene. Default is false.
         * @zh 如果为true，则该节点是一个常驻节点，不会在场景转换期间被销毁。
         * 如果为false，节点将在加载新场景时自动销毁。默认为 false。
         * @default false
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _persistNode(): boolean;
        set _persistNode(value: boolean);
        /**
         * @en Name of node.
         * @zh 该节点名称。
         */
        get name(): string;
        set name(value: string);
        /**
         * @en The uuid for editor, will be stripped after building project.
         * @zh 主要用于编辑器的 uuid，在编辑器下可用于持久化存储，在项目构建之后将变成自增的 id。
         * @readOnly
         */
        get uuid(): string;
        /**
         * @en All children nodes.
         * @zh 节点的所有子节点。
         * @readOnly
         */
        get children(): Node[];
        /**
         * @en
         * The local active state of this node.
         * Note that a Node may be inactive because a parent is not active, even if this returns true.
         * Use [[activeInHierarchy]]
         * if you want to check if the Node is actually treated as active in the scene.
         * @zh
         * 当前节点的自身激活状态。
         * 值得注意的是，一个节点的父节点如果不被激活，那么即使它自身设为激活，它仍然无法激活。
         * 如果你想检查节点在场景中实际的激活状态可以使用 [[activeInHierarchy]]
         * @default true
         */
        get active(): boolean;
        set active(isActive: boolean);
        /**
         * @en Indicates whether this node is active in the scene.
         * @zh 表示此节点是否在场景中激活。
         */
        get activeInHierarchy(): boolean;
        /**
         * @en The parent node
         * @zh 父节点
         */
        get parent(): Node | null;
        set parent(value: Node | null);
        /**
         * @en Which scene this node belongs to.
         * @zh 此节点属于哪个场景。
         * @readonly
         */
        get scene(): Scene;
        /**
         * @en The event processor of the current node, it provides EventTarget ability.
         * @zh 当前节点的事件处理器，提供 EventTarget 能力。
         * @readonly
         *
         * @deprecated since v3.4.0
         */
        get eventProcessor(): __private._cocos_scene_graph_node_event_processor__NodeEventProcessor;
        /**
         * @internal
         */
        protected static idGenerator: js.IDGenerator;
        /**
         * for walk
         * @internal
         */
        protected static _stacks: Array<Array<(Node | null)>>;
        /**
         * @internal
         */
        protected static _stackId: number;
        /**
         * Call `_updateScene` of specified node.
         * @internal
         * @param node The node.
         */
        protected static _setScene(node: Node): void;
        protected static _findComponent<T extends Component>(node: Node, constructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): T | null;
        protected static _findComponents<T extends Component>(node: Node, constructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>, components: Component[]): void;
        protected static _findChildComponent<T extends Component>(children: Node[], constructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): T | null;
        protected static _findChildComponents<T extends Component>(children: Node[], constructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>, components: Component[]): void;
        protected _parent: this | null;
        protected _children: this[];
        protected _active: boolean;
        protected _components: Component[];
        /**
         * TODO(PP_Pro): this property should be exported to editor only, we should support editorOnly tag.
         * Tracking issue: https://github.com/cocos/cocos-engine/issues/14613
         */
        protected _prefab: Prefab._utils.PrefabInfo | null;
        protected _scene: Scene;
        protected _activeInHierarchy: boolean;
        protected _id: string;
        protected _eventProcessor: __private._cocos_scene_graph_node_event_processor__NodeEventProcessor;
        protected _eventMask: number;
        protected _siblingIndex: number;
        /**
         * @en
         * record scene's id when set this node as persist node
         * @zh
         * 当设置节点为常驻节点时记录场景的 id
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _originalSceneId: string;
        /**
         * Set `_scene` field of this node.
         * The derived `Scene` overrides this method to behavior differently.
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        protected _updateScene(): void;
        /**
         * @en
         * Properties configuration function.
         * All properties in attrs will be set to the node,
         * when the setter of the node is available,
         * the property will be set via setter function.
         * @zh 属性配置函数。在 attrs 的所有属性将被设置为节点属性。
         * @param attrs - Properties to be set to node
         * @example
         * ```
         * var attrs = { name: 'New Name', active: false };
         * node.attr(attrs);
         * ```
         */
        attr(attrs: unknown): void;
        /**
         * @en Get parent of the node.
         * @zh 获取该节点的父节点。
         */
        getParent(): Node | null;
        /**
         * @en Set parent of the node.
         * @zh 设置该节点的父节点。
         * @param value Parent node
         * @param keepWorldTransform Whether keep node's current world transform unchanged after this operation
         */
        setParent(value: Node | null, keepWorldTransform?: boolean): void;
        /**
         * @en Returns a child with the same uuid.
         * @zh 通过 uuid 获取节点的子节点。
         * @param uuid - The uuid to find the child node.
         * @return a Node whose uuid equals to the input parameter
         */
        getChildByUuid(uuid: string): Node | null;
        /**
         * @en Returns a child with the same name.
         * @zh 通过名称获取节点的子节点。
         * @param name - A name to find the child node.
         * @return a CCNode object whose name equals to the input parameter
         * @example
         * ```
         * var child = node.getChildByName("Test Node");
         * ```
         */
        getChildByName(name: string): Node | null;
        /**
         * @en Returns a child with the given path.
         * @zh 通过路径获取节点的子节点。
         * @param path - A path to find the child node.
         * @return a Node object whose path equals to the input parameter
         * @example
         * ```
         * var child = node.getChildByPath("subNode/Test Node");
         * ```
         */
        getChildByPath(path: string): Node | null;
        /**
         * @en Add a child to the current node.
         * @zh 添加一个子节点。
         * @param child - the child node to be added
         */
        addChild(child: Node): void;
        /**
         * @en Inserts a child to the node at a specified index.
         * @zh 插入子节点到指定位置
         * @param child - the child node to be inserted
         * @param siblingIndex - the sibling index to place the child in
         * @example
         * ```
         * node.insertChild(child, 2);
         * ```
         */
        insertChild(child: Node, siblingIndex: number): void;
        /**
         * @en Get the sibling index of the current node in its parent's children array.
         * @zh 获取当前节点在父节点的 children 数组中的位置。
         */
        getSiblingIndex(): number;
        /**
         * @en Set the sibling index of the current node in its parent's children array.
         * @zh 设置当前节点在父节点的 children 数组中的位置。
         */
        setSiblingIndex(index: number): void;
        /**
         * @en Walk though the sub children tree of the current node.
         * Each node, including the current node, in the sub tree will be visited two times,
         * before all children and after all children.
         * This function call is not recursive, it's based on stack.
         * Please don't walk any other node inside the walk process.
         * @zh 遍历该节点的子树里的所有节点并按规则执行回调函数。
         * 对子树中的所有节点，包含当前节点，会执行两次回调，preFunc 会在访问它的子节点之前调用，postFunc 会在访问所有子节点之后调用。
         * 这个函数的实现不是基于递归的，而是基于栈展开递归的方式。
         * 请不要在 walk 过程中对任何其他的节点嵌套执行 walk。
         * @param preFunc The callback to process node when reach the node for the first time
         * @param postFunc The callback to process node when re-visit the node after walked all children in its sub tree
         * @example
         * ```
         * node.walk(function (target) {
         *     console.log('Walked through node ' + target.name + ' for the first time');
         * }, function (target) {
         *     console.log('Walked through node ' + target.name + ' after walked all children in its sub tree');
         * });
         * ```
         */
        walk(preFunc: (target: this) => void, postFunc?: (target: this) => void): void;
        /**
         * @en
         * Remove itself from its parent node.
         * If the node have no parent, then nothing happens.
         * @zh
         * 从父节点中删除该节点。
         * 如果这个节点是一个孤立节点，那么什么都不会发生。
         */
        removeFromParent(): void;
        /**
         * @en Removes a child from the container.
         * @zh 移除节点中指定的子节点。
         * @param child - The child node which will be removed.
         */
        removeChild(child: this | Node): void;
        /**
         * @en Removes all children from the container.
         * @zh 移除节点所有的子节点。
         */
        removeAllChildren(): void;
        /**
         * @en Is this node a child of the given node?
         * @zh 是否是指定节点的子节点？
         * @return True if this node is a child, deep child or identical to the given node.
         */
        isChildOf(parent: this | Scene | null): boolean;
        /**
         * @en
         * Returns the component of supplied type if the node has one attached, null if it doesn't.
         * You can also get component in the node by passing in the name of the script.
         * @zh
         * 获取节点上指定类型的组件，如果节点有附加指定类型的组件，则返回，如果没有则为空。
         * 传入参数也可以是脚本的名称。
         * @param classConstructor The class of the target component
         * @example
         * ```
         * // get sprite component.
         * var sprite = node.getComponent(Sprite);
         * ```
         */
        getComponent<T extends Component>(classConstructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): T | null;
        /**
         * @en
         * Returns the component of supplied type if the node has one attached, null if it doesn't.
         * You can also get component in the node by passing in the name of the script.
         * @zh
         * 获取节点上指定类型的组件，如果节点有附加指定类型的组件，则返回，如果没有则为空。
         * 传入参数也可以是脚本的名称。
         * @param className The class name of the target component
         * @example
         * ```
         * // get custom test class.
         * var test = node.getComponent("Test");
         * ```
         */
        getComponent(className: string): Component | null;
        /**
         * @en Returns all components of given type in the node.
         * @zh 返回节点上指定类型的所有组件。
         * @param classConstructor The class of the target component
         */
        getComponents<T extends Component>(classConstructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): T[];
        /**
         * @en Returns all components of given type in the node.
         * @zh 返回节点上指定类型的所有组件。
         * @param className The class name of the target component
         */
        getComponents(className: string): Component[];
        /**
         * @en Returns the component of given type in any of its children using depth first search.
         * @zh 递归查找所有子节点中第一个匹配指定类型的组件。
         * @param classConstructor The class of the target component
         * @example
         * ```
         * var sprite = node.getComponentInChildren(Sprite);
         * ```
         */
        getComponentInChildren<T extends Component>(classConstructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): T | null;
        /**
         * @en Returns the component of given type in any of its children using depth first search.
         * @zh 递归查找所有子节点中第一个匹配指定类型的组件。
         * @param className The class name of the target component
         * @example
         * ```
         * var Test = node.getComponentInChildren("Test");
         * ```
         */
        getComponentInChildren(className: string): Component | null;
        /**
         * @en Returns all components of given type in self or any of its children.
         * @zh 递归查找自身或所有子节点中指定类型的组件
         * @param classConstructor The class of the target component
         * @example
         * ```
         * var sprites = node.getComponentsInChildren(Sprite);
         * ```
         */
        getComponentsInChildren<T extends Component>(classConstructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): T[];
        /**
         * @en Returns all components of given type in self or any of its children.
         * @zh 递归查找自身或所有子节点中指定类型的组件
         * @param className The class name of the target component
         * @example
         * ```
         * var tests = node.getComponentsInChildren("Test");
         * ```
         */
        getComponentsInChildren(className: string): Component[];
        /**
         * @en Adds a component class to the node. You can also add component to node by passing in the name of the script.
         * @zh 向节点添加一个指定类型的组件类，你还可以通过传入脚本的名称来添加组件。
         * @param classConstructor The class of the component to add
         * @throws `TypeError` if the `classConstructor` does not specify a cc-class constructor extending the `Component`.
         * @example
         * ```
         * var sprite = node.addComponent(Sprite);
         * ```
         */
        addComponent<T extends Component>(classConstructor: __private.__types_globals__Constructor<T>): T;
        /**
         * @en Adds a component class to the node. You can also add component to node by passing in the name of the script.
         * @zh 向节点添加一个指定类型的组件类，你还可以通过传入脚本的名称来添加组件。
         * @param className The class name of the component to add
         * @throws `TypeError` if the `className` does not specify a cc-class constructor extending the `Component`.
         * @example
         * ```
         * var test = node.addComponent("Test");
         * ```
         */
        addComponent(className: string): Component;
        /**
         * @en
         * Removes a component identified by the given name or removes the component object given.
         * You can also use component.destroy() if you already have the reference.
         * @zh
         * 删除节点上的指定组件，传入参数可以是一个组件构造函数或组件名，也可以是已经获得的组件引用。
         * 如果你已经获得组件引用，你也可以直接调用 component.destroy()
         * @param classConstructor The class of the component to remove
         * @deprecated please destroy the component to remove it.
         * @example
         * ```
         * node.removeComponent(Sprite);
         * ```
         */
        removeComponent<T extends Component>(classConstructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): void;
        /**
         * @en
         * Removes a component identified by the given name or removes the component object given.
         * You can also use component.destroy() if you already have the reference.
         * @zh
         * 删除节点上的指定组件，传入参数可以是一个组件构造函数或组件名，也可以是已经获得的组件引用。
         * 如果你已经获得组件引用，你也可以直接调用 component.destroy()
         * @param classNameOrInstance The class name of the component to remove or the component instance to be removed
         * @deprecated please destroy the component to remove it.
         * @example
         * ```
         * import { Sprite } from 'cc';
         * const sprite = node.getComponent(Sprite);
         * if (sprite) {
         *     node.removeComponent(sprite);
         * }
         * node.removeComponent('Sprite');
         * ```
         */
        removeComponent(classNameOrInstance: string | Component): void;
        /**
         * @en
         * Register a callback of a specific event type on Node.
         * Use this method to register touch or mouse event permit propagation based on scene graph,
         * These kinds of event are triggered with dispatchEvent, the dispatch process has three steps:
         * 1. Capturing phase: dispatch in capture targets, e.g. parents in node tree, from root to the real target
         * 2. At target phase: dispatch to the listeners of the real target
         * 3. Bubbling phase: dispatch in bubble targets, e.g. parents in node tree, from the real target to root
         * In any moment of the dispatching process, it can be stopped via `event.stopPropagation()` or `event.stopPropagationImmediate()`.
         * You can also register custom event and use `emit` to trigger custom event on Node.
         * For such events, there won't be capturing and bubbling phase,
         * your event will be dispatched directly to its listeners registered on the same node.
         * You can also pass event callback parameters with `emit` by passing parameters after `type`.
         * @zh
         * 在节点上注册指定类型的回调函数，也可以设置 target 用于绑定响应函数的 this 对象。
         * 鼠标或触摸事件会被系统调用 dispatchEvent 方法触发，触发的过程包含三个阶段：
         * 1. 捕获阶段：派发事件给捕获目标，比如，节点树中注册了捕获阶段的父节点，从根节点开始派发直到目标节点。
         * 2. 目标阶段：派发给目标节点的监听器。
         * 3. 冒泡阶段：派发事件给冒泡目标，比如，节点树中注册了冒泡阶段的父节点，从目标节点开始派发直到根节点。
         * 同时您可以将事件派发到父节点或者通过调用 stopPropagation 拦截它。
         * 你也可以注册自定义事件到节点上，并通过 emit 方法触发此类事件，对于这类事件，不会发生捕获冒泡阶段，只会直接派发给注册在该节点上的监听器
         * 你可以通过在 emit 方法调用时在 type 之后传递额外的参数作为事件回调的参数列表
         * @param type - A string representing the event type to listen for.<br>See [[Node.EventType.POSITION_CHANGED]] for all builtin events.
         * @param callback - The callback that will be invoked when the event is dispatched.
         * The callback is ignored if it is a duplicate (the callbacks are unique).
         * @param target - The target (this object) to invoke the callback, can be null
         * @param useCapture - When set to true, the listener will be triggered at capturing phase which is ahead of the final target emit,
         * otherwise it will be triggered during bubbling phase.
         * @return - Just returns the incoming callback so you can save the anonymous function easier.
         * @example
         * ```ts
         * this.node.on(NodeEventType.TOUCH_START, this.memberFunction, this);  // if "this" is component and the "memberFunction" declared in CCClass.
         * node.on(NodeEventType.TOUCH_START, callback, this);
         * node.on(NodeEventType.TOUCH_MOVE, callback, this);
         * node.on(NodeEventType.TOUCH_END, callback, this);
         * ```
         */
        on(type: string | NodeEventType, callback: __private.__types_globals__AnyFunction, target?: unknown, useCapture?: boolean): void;
        /**
         * @en
         * Removes the callback previously registered with the same type, callback, target and or useCapture.
         * This method is merely an alias to removeEventListener.
         * @zh 删除之前与同类型，回调，目标或 useCapture 注册的回调。
         * @param type - A string representing the event type being removed.
         * @param callback - The callback to remove.
         * @param target - The target (this object) to invoke the callback, if it's not given, only callback without target will be removed
         * @param useCapture - When set to true, the listener will be triggered at capturing phase
         * which is ahead of the final target emit, otherwise it will be triggered during bubbling phase.
         * @example
         * ```ts
         * this.node.off(NodeEventType.TOUCH_START, this.memberFunction, this);
         * node.off(NodeEventType.TOUCH_START, callback, this.node);
         * ```
         */
        off(type: string, callback?: __private.__types_globals__AnyFunction, target?: unknown, useCapture?: boolean): void;
        /**
         * @en
         * Register an callback of a specific event type on the Node,
         * the callback will remove itself after the first time it is triggered.
         * @zh
         * 注册节点的特定事件类型回调，回调会在第一时间被触发后删除自身。
         *
         * @param type - A string representing the event type to listen for.
         * @param callback - The callback that will be invoked when the event is dispatched.
         *                              The callback is ignored if it is a duplicate (the callbacks are unique).
         * @param target - The target (this object) to invoke the callback, can be null
         */
        once(type: string, callback: __private.__types_globals__AnyFunction, target?: unknown, useCapture?: boolean): void;
        /**
         * @en
         * Trigger an event directly with the event name and necessary arguments.
         * @zh
         * 通过事件名发送自定义事件
         * @param type - event type
         * @param arg1 - First argument in callback
         * @param arg2 - Second argument in callback
         * @param arg3 - Third argument in callback
         * @param arg4 - Fourth argument in callback
         * @param arg5 - Fifth argument in callback
         * @example
         * ```ts
         * eventTarget.emit('fire', event);
         * eventTarget.emit('fire', message, emitter);
         * ```
         */
        emit(type: string, arg0?: any, arg1?: any, arg2?: any, arg3?: any, arg4?: any): void;
        /**
         * @en
         * Dispatches an event into the event flow.
         * The event target is the EventTarget object upon which the dispatchEvent() method is called.
         * @zh 分发事件到事件流中。
         * @param event - The Event object that is dispatched into the event flow
         */
        dispatchEvent(event: Event): void;
        /**
         * @en Checks whether the EventTarget object has any callback registered for a specific type of event.
         * @zh 检查事件目标对象是否有为特定类型的事件注册的回调。
         * @param type - The type of event.
         * @param callback - The callback function of the event listener, if absent all event listeners for the