import { TWEEN } from "./Tween";

const { ccclass, property, menu, disallowMultiple } = cc._decorator;

/**
 * 用于tween.js更新的组件，绑在Canvas上保证全局有且只有一个
 */
@ccclass
@menu('自定义组件/TweenCmpt')
@disallowMultiple
export default class TweenCmpt extends cc.Component {
  protected onDestroy() {
    TWEEN.removeAll();
  }

  protected update(dt: number) {
    TWEEN.update();
  }
}