
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/AudioCtr.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'ac5a9bXH9hFYZE61PDgKN5g', 'AudioCtr');
// script/AudioCtr.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SFX_TYPE = void 0;
var Tween_1 = require("./tween/Tween");
/**
 * 音效类型
 */
var SFX_TYPE;
(function (SFX_TYPE) {
    SFX_TYPE[SFX_TYPE["NORMAL"] = 0] = "NORMAL";
    SFX_TYPE[SFX_TYPE["UI"] = 1] = "UI";
})(SFX_TYPE = exports.SFX_TYPE || (exports.SFX_TYPE = {}));
/**
 * 音频管理类
 * => 暂停游戏时调低bgm音量，暂停游戏内音效，不影响ui音效
 */
var AudioCtr = /** @class */ (function () {
    function AudioCtr() {
    }
    Object.defineProperty(AudioCtr, "bgmVolume", {
        /** 全局bgm音量 */
        get: function () {
            return this._bgmVolume;
        },
        set: function (volume) {
            var _this = this;
            if (this._bgmVolume === volume) {
                return;
            }
            this._bgmVolume = cc.misc.clampf(volume, 0, 1);
            this._bgmMap.forEach(function (audioData, clip) {
                cc.audioEngine.setVolume(audioData.id, _this._bgmVolume * audioData.volume);
            });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AudioCtr, "sfxVolume", {
        /** 全局sfx音量 */
        get: function () {
            return this._sfxVolume;
        },
        set: function (volume) {
            var _this = this;
            if (this._sfxVolume === volume) {
                return;
            }
            this._sfxVolume = cc.misc.clampf(volume, 0, 1);
            this._normalSfxMap.forEach(function (data, clip) {
                data.audioList.forEach(function (audioData) {
                    cc.audioEngine.setVolume(audioData.id, _this._sfxVolume * audioData.volume);
                });
            });
            this._uiSfxMap.forEach(function (data, clip) {
                data.audioList.forEach(function (audioData) {
                    cc.audioEngine.setVolume(audioData.id, _this._sfxVolume * audioData.volume);
                });
            });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AudioCtr, "bgmOff", {
        /** bgm是否关闭 */
        get: function () {
            return this._bgmOff;
        },
        set: function (isOff) {
            if (this._bgmOff === isOff) {
                return;
            }
            this._bgmOff = isOff;
            if (this._bgmOff) {
                this._bgmMap.forEach(function (audioData, clip) {
                    audioData.tween && audioData.tween.stop();
                    audioData.tween = null;
                    cc.audioEngine.stop(audioData.id);
                });
                this._bgmMap.clear();
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AudioCtr, "sfxOff", {
        /** sfx是否关闭 */
        get: function () {
            return this._sfxOff;
        },
        set: function (isOff) {
            if (this._sfxOff === isOff) {
                return;
            }
            this._sfxOff = isOff;
            if (this._sfxOff) {
                this._normalSfxMap.forEach(function (data, clip) {
                    data.audioList.forEach(function (audioData) {
                        cc.audioEngine.stop(audioData.id);
                    });
                    data.audioList.length = 0;
                });
                this._uiSfxMap.forEach(function (data, clip) {
                    data.audioList.forEach(function (audioData) {
                        cc.audioEngine.stop(audioData.id);
                    });
                    data.audioList.length = 0;
                });
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AudioCtr, "bgmPause", {
        /** bgm是否暂停 */
        get: function () {
            return this._bgmPause;
        },
        set: function (isPause) {
            var _this = this;
            if (this.bgmOff || this._bgmPause === isPause) {
                return;
            }
            this._bgmPause = isPause;
            this._bgmMap.forEach(function (data, clip) {
                if (_this._bgmPause) {
                    data.tween && data.tween.pause();
                    cc.audioEngine.pause(data.id);
                }
                else {
                    data.tween && data.tween.resume();
                    cc.audioEngine.resume(data.id);
                }
            });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AudioCtr, "sfxPause", {
        /** sfx是否暂停，暂停时不暂停ui音效 */
        get: function () {
            return this._sfxPause;
        },
        set: function (isPause) {
            if (this.sfxOff || this._sfxPause === isPause) {
                return;
            }
            this._sfxPause = isPause;
            if (this._sfxPause) {
                this._normalSfxMap.forEach(function (data, clip) {
                    data.audioList.forEach(function (audioData) {
                        cc.audioEngine.pause(audioData.id);
                    });
                });
            }
            else {
                this._normalSfxMap.forEach(function (data, clip) {
                    data.audioList.forEach(function (audioData) {
                        cc.audioEngine.resume(audioData.id);
                    });
                });
            }
        },
        enumerable: false,
        configurable: true
    });
    /**
     * 音量渐变
     * @param data
     * @param duration 音量渐变时长 单位ms
     * @param from 音量初始值
     * @param to 音量目标值
     * @param call 渐变结束的回调
     */
    AudioCtr.volumeFade = function (data, duration, from, to, call) {
        var _this = this;
        data.tween && data.tween.stop();
        data.volume = from;
        data.tween = new Tween_1.Tween(data)
            .to({ volume: to }, duration)
            .onUpdate(function () {
            cc.audioEngine.setVolume(data.id, data.volume * _this.bgmVolume);
        })
            .onComplete(function () {
            data.tween = null;
            if (call) {
                call();
            }
        })
            .start();
    };
    /**
     * 播放音频并返回AudioData
     */
    AudioCtr.play = function (clip, loop, volume, finishCall, audioData) {
        if (finishCall === void 0) { finishCall = null; }
        if (audioData === void 0) { audioData = null; }
        if (audioData) {
            audioData.id = cc.audioEngine.play(clip, loop, volume);
            audioData.volume = 1;
            if (audioData.tween) {
                audioData.tween.stop();
                audioData.tween = null;
            }
        }
        else {
            audioData = {
                id: cc.audioEngine.play(clip, loop, volume),
                volume: 1,
                tween: null
            };
        }
        if (finishCall) {
            cc.audioEngine.setFinishCallback(audioData.id, finishCall);
        }
        return audioData;
    };
    /**
     * 播放bgm
     * @param clip
     * @param loop 是否循环
     * @param fadeDuration 音量渐变时长 单位ms
     * @param finishCall 正常播放结束时的回调
     */
    AudioCtr.playBgm = function (clip, loop, fadeDuration, finishCall) {
        if (loop === void 0) { loop = true; }
        if (fadeDuration === void 0) { fadeDuration = 0; }
        if (finishCall === void 0) { finishCall = null; }
        if (this.bgmOff) {
            return;
        }
        var audioData = this._bgmMap.get(clip);
        if (audioData === undefined) {
            audioData = this.play(clip, loop, this.bgmVolume, finishCall);
            this._bgmMap.set(clip, audioData);
        }
        else {
            cc.audioEngine.stop(audioData.id);
            this.play(clip, loop, this.bgmVolume, finishCall, audioData);
        }
        if (fadeDuration > 0) {
            this.volumeFade(audioData, fadeDuration, 0, 1);
        }
    };
    /**
     * 播放sfx
     * @param clip
     * @param type 音效类型
     * @param finishCall 正常播放结束时的回调
     */
    AudioCtr.playSfx = function (clip, type, finishCall) {
        if (type === void 0) { type = SFX_TYPE.NORMAL; }
        if (finishCall === void 0) { finishCall = null; }
        if (this.sfxOff) {
            return;
        }
        var sfxData = type === SFX_TYPE.NORMAL ? this._normalSfxMap.get(clip) : this._uiSfxMap.get(clip);
        var audioData = null;
        if (sfxData === undefined) {
            sfxData = this.setSfxData(clip, type);
            audioData = this.play(clip, false, this.sfxVolume, finishCall);
            sfxData.audioList.push(audioData);
        }
        else {
            // 剔除不处于播放状态的音频
            while (sfxData.audioList.length > 0 && cc.audioEngine.getState(sfxData.audioList[0].id) !== cc.audioEngine.AudioState.PLAYING) {
                cc.audioEngine.stop(sfxData.audioList.shift().id);
            }
            // 已达到最大数量则剔除最先(第一个)缓存的音频
            while (sfxData.overStop && sfxData.audioList.length >= sfxData.maxNum) {
                cc.audioEngine.stop(sfxData.audioList.shift().id);
            }
            // 缓存新的音频
            if (sfxData.audioList.length < sfxData.maxNum) {
                audioData = this.play(clip, false, this.sfxVolume, finishCall);
                sfxData.audioList.push(audioData);
            }
        }
    };
    /**
     * 设置音效数据(用于控制某些短时间内同时大量播放的音效)
     * @param clip
     * @param type 音效类型
     * @param maxNum 此音效最大同时播放的数量
     * @param overStop 超过最大数量时是否stop未播完的音效并缓存新的音效
     */
    AudioCtr.setSfxData = function (clip, type, maxNum, overStop) {
        if (type === void 0) { type = SFX_TYPE.NORMAL; }
        if (maxNum === void 0) { maxNum = 8; }
        if (overStop === void 0) { overStop = false; }
        maxNum = Math.max(maxNum, 1);
        var map = type === SFX_TYPE.NORMAL ? this._normalSfxMap : this._uiSfxMap;
        var sfxData = map.get(clip);
        if (sfxData === undefined) {
            sfxData = {
                audioList: [],
                maxNum: maxNum,
                overStop: overStop
            };
            map.set(clip, sfxData);
        }
        else {
            sfxData.maxNum = maxNum;
            sfxData.overStop = overStop;
        }
        return sfxData;
    };
    /**
     * 停止bgm
     * @param clip 需停止的音频，clip返回值为false则停止所有
     * @param fadeDuration 音量渐变时长 单位ms
     */
    AudioCtr.stopBgm = function (clip, fadeDuration) {
        var _this = this;
        if (clip === void 0) { clip = null; }
        if (fadeDuration === void 0) { fadeDuration = 0; }
        if (this.bgmOff) {
            return;
        }
        if (clip) {
            var audioData_1 = this._bgmMap.get(clip);
            if (audioData_1 === undefined) {
                return;
            }
            audioData_1.tween && audioData_1.tween.stop();
            audioData_1.tween = null;
            if (fadeDuration <= 0) {
                cc.audioEngine.stop(audioData_1.id);
                this._bgmMap.delete(clip);
            }
            else {
                this.volumeFade(audioData_1, fadeDuration, 1, 0, function () {
                    cc.audioEngine.stop(audioData_1.id);
                    _this._bgmMap.delete(clip);
                });
            }
        }
        else {
            if (fadeDuration <= 0) {
                this._bgmMap.forEach(function (audioData, clip) {
                    audioData.tween && audioData.tween.stop();
                    audioData.tween = null;
                    cc.audioEngine.stop(audioData.id);
                });
                this._bgmMap.clear();
            }
            else {
                this._bgmMap.forEach(function (audioData, clip) {
                    audioData.tween && audioData.tween.stop();
                    audioData.tween = null;
                    _this.volumeFade(audioData, fadeDuration, 1, 0, function () {
                        cc.audioEngine.stop(audioData.id);
                        _this._bgmMap.delete(clip);
                    });
                });
            }
        }
    };
    /**
     * 停止sfx
     * @param clip 需停止的音频，clip返回值为false则停止所有
     * @param type 音效类型
     */
    AudioCtr.stopSfx = function (clip, type) {
        if (clip === void 0) { clip = null; }
        if (type === void 0) { type = SFX_TYPE.NORMAL; }
        if (this.sfxOff) {
            return;
        }
        if (clip) {
            var data = type === SFX_TYPE.NORMAL ? this._normalSfxMap.get(clip) : this._uiSfxMap.get(clip);
            if (data === undefined || data.audioList.length <= 0) {
                return;
            }
            data.audioList.forEach(function (audioData) {
                cc.audioEngine.stop(audioData.id);
            });
            data.audioList.length = 0;
        }
        else {
            this._normalSfxMap.forEach(function (data, clip) {
                data.audioList.forEach(function (audioData) {
                    cc.audioEngine.stop(audioData.id);
                });
                data.audioList.length = 0;
            });
            this._uiSfxMap.forEach(function (data, clip) {
                data.audioList.forEach(function (audioData) {
                    cc.audioEngine.stop(audioData.id);
                });
                data.audioList.length = 0;
            });
        }
    };
    /**
     * 停止所有音频
     */
    AudioCtr.stopAll = function () {
        this.stopBgm();
        this.stopSfx();
    };
    /**
     * 暂停所有音频
     */
    AudioCtr.pauseAll = function () {
        this.bgmPause = true;
        this.sfxPause = true;
    };
    /**
     * 恢复所有音频
     */
    AudioCtr.resumeAll = function () {
        this.bgmPause = false;
        this.sfxPause = false;
    };
    /** 缓存的bgm数据 */
    AudioCtr._bgmMap = new Map();
    /** 缓存的普通音效数据 */
    AudioCtr._normalSfxMap = new Map();
    /** 缓存的ui音效数据 */
    AudioCtr._uiSfxMap = new Map();
    AudioCtr._bgmVolume = 1;
    AudioCtr._sfxVolume = 1;
    AudioCtr._bgmOff = false;
    AudioCtr._sfxOff = false;
    AudioCtr._bgmPause = false;
    AudioCtr._sfxPause = false;
    return AudioCtr;
}());
exports.default = AudioCtr;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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