
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/tween/Tween.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}(function (process){
"use strict";
cc._RF.push(module, '965f5ztwxdGKrvyyGl1B8Jn', 'Tween');
// script/tween/Tween.js

'use strict'; // Object.defineProperty(exports, '__esModule', { value: true });

/**
 * The Ease class provides a collection of easing functions for use with tween.js.
 */

var Easing = {
  Linear: {
    None: function None(amount) {
      return amount;
    }
  },
  Quadratic: {
    In: function In(amount) {
      return amount * amount;
    },
    Out: function Out(amount) {
      return amount * (2 - amount);
    },
    InOut: function InOut(amount) {
      if ((amount *= 2) < 1) {
        return 0.5 * amount * amount;
      }

      return -0.5 * (--amount * (amount - 2) - 1);
    }
  },
  Cubic: {
    In: function In(amount) {
      return amount * amount * amount;
    },
    Out: function Out(amount) {
      return --amount * amount * amount + 1;
    },
    InOut: function InOut(amount) {
      if ((amount *= 2) < 1) {
        return 0.5 * amount * amount * amount;
      }

      return 0.5 * ((amount -= 2) * amount * amount + 2);
    }
  },
  Quartic: {
    In: function In(amount) {
      return amount * amount * amount * amount;
    },
    Out: function Out(amount) {
      return 1 - --amount * amount * amount * amount;
    },
    InOut: function InOut(amount) {
      if ((amount *= 2) < 1) {
        return 0.5 * amount * amount * amount * amount;
      }

      return -0.5 * ((amount -= 2) * amount * amount * amount - 2);
    }
  },
  Quintic: {
    In: function In(amount) {
      return amount * amount * amount * amount * amount;
    },
    Out: function Out(amount) {
      return --amount * amount * amount * amount * amount + 1;
    },
    InOut: function InOut(amount) {
      if ((amount *= 2) < 1) {
        return 0.5 * amount * amount * amount * amount * amount;
      }

      return 0.5 * ((amount -= 2) * amount * amount * amount * amount + 2);
    }
  },
  Sinusoidal: {
    In: function In(amount) {
      return 1 - Math.cos(amount * Math.PI / 2);
    },
    Out: function Out(amount) {
      return Math.sin(amount * Math.PI / 2);
    },
    InOut: function InOut(amount) {
      return 0.5 * (1 - Math.cos(Math.PI * amount));
    }
  },
  Exponential: {
    In: function In(amount) {
      return amount === 0 ? 0 : Math.pow(1024, amount - 1);
    },
    Out: function Out(amount) {
      return amount === 1 ? 1 : 1 - Math.pow(2, -10 * amount);
    },
    InOut: function InOut(amount) {
      if (amount === 0) {
        return 0;
      }

      if (amount === 1) {
        return 1;
      }

      if ((amount *= 2) < 1) {
        return 0.5 * Math.pow(1024, amount - 1);
      }

      return 0.5 * (-Math.pow(2, -10 * (amount - 1)) + 2);
    }
  },
  Circular: {
    In: function In(amount) {
      return 1 - Math.sqrt(1 - amount * amount);
    },
    Out: function Out(amount) {
      return Math.sqrt(1 - --amount * amount);
    },
    InOut: function InOut(amount) {
      if ((amount *= 2) < 1) {
        return -0.5 * (Math.sqrt(1 - amount * amount) - 1);
      }

      return 0.5 * (Math.sqrt(1 - (amount -= 2) * amount) + 1);
    }
  },
  Elastic: {
    In: function In(amount) {
      if (amount === 0) {
        return 0;
      }

      if (amount === 1) {
        return 1;
      }

      return -Math.pow(2, 10 * (amount - 1)) * Math.sin((amount - 1.1) * 5 * Math.PI);
    },
    Out: function Out(amount) {
      if (amount === 0) {
        return 0;
      }

      if (amount === 1) {
        return 1;
      }

      return Math.pow(2, -10 * amount) * Math.sin((amount - 0.1) * 5 * Math.PI) + 1;
    },
    InOut: function InOut(amount) {
      if (amount === 0) {
        return 0;
      }

      if (amount === 1) {
        return 1;
      }

      amount *= 2;

      if (amount < 1) {
        return -0.5 * Math.pow(2, 10 * (amount - 1)) * Math.sin((amount - 1.1) * 5 * Math.PI);
      }

      return 0.5 * Math.pow(2, -10 * (amount - 1)) * Math.sin((amount - 1.1) * 5 * Math.PI) + 1;
    }
  },
  Back: {
    In: function In(amount) {
      var s = 1.70158;
      return amount * amount * ((s + 1) * amount - s);
    },
    Out: function Out(amount) {
      var s = 1.70158;
      return --amount * amount * ((s + 1) * amount + s) + 1;
    },
    InOut: function InOut(amount) {
      var s = 1.70158 * 1.525;

      if ((amount *= 2) < 1) {
        return 0.5 * (amount * amount * ((s + 1) * amount - s));
      }

      return 0.5 * ((amount -= 2) * amount * ((s + 1) * amount + s) + 2);
    }
  },
  Bounce: {
    In: function In(amount) {
      return 1 - Easing.Bounce.Out(1 - amount);
    },
    Out: function Out(amount) {
      if (amount < 1 / 2.75) {
        return 7.5625 * amount * amount;
      } else if (amount < 2 / 2.75) {
        return 7.5625 * (amount -= 1.5 / 2.75) * amount + 0.75;
      } else if (amount < 2.5 / 2.75) {
        return 7.5625 * (amount -= 2.25 / 2.75) * amount + 0.9375;
      } else {
        return 7.5625 * (amount -= 2.625 / 2.75) * amount + 0.984375;
      }
    },
    InOut: function InOut(amount) {
      if (amount < 0.5) {
        return Easing.Bounce.In(amount * 2) * 0.5;
      }

      return Easing.Bounce.Out(amount * 2 - 1) * 0.5 + 0.5;
    }
  }
};
var now; // Include a performance.now polyfill.
// In node.js, use process.hrtime.
// eslint-disable-next-line
// @ts-ignore

if (typeof self === 'undefined' && typeof process !== 'undefined' && process.hrtime) {
  now = function now() {
    // eslint-disable-next-line
    // @ts-ignore
    var time = process.hrtime(); // Convert [seconds, nanoseconds] to milliseconds.

    return time[0] * 1000 + time[1] / 1000000;
  };
} // In a browser, use self.performance.now if it is available.
else if (typeof self !== 'undefined' && self.performance !== undefined && self.performance.now !== undefined) {
    // This must be bound, because directly assigning this function
    // leads to an invocation exception in Chrome.
    now = self.performance.now.bind(self.performance);
  } // Use Date.now if it is available.
  else if (Date.now !== undefined) {
      now = Date.now;
    } // Otherwise, use 'new Date().getTime()'.
    else {
        now = function now() {
          return new Date().getTime();
        };
      }

var now$1 = now;
/**
 * Controlling groups of tweens
 *
 * Using the TWEEN singleton to manage your tweens can cause issues in large apps with many components.
 * In these cases, you may want to create your own smaller groups of tween
 */

var Group =
/** @class */
function () {
  function Group() {
    this._tweens = {};
    this._tweensAddedDuringUpdate = {};
  }

  Group.prototype.getAll = function () {
    var _this = this;

    return Object.keys(this._tweens).map(function (tweenId) {
      return _this._tweens[tweenId];
    });
  };

  Group.prototype.removeAll = function () {
    this._tweens = {};
  };

  Group.prototype.add = function (tween) {
    this._tweens[tween.getId()] = tween;
    this._tweensAddedDuringUpdate[tween.getId()] = tween;
  };

  Group.prototype.remove = function (tween) {
    delete this._tweens[tween.getId()];
    delete this._tweensAddedDuringUpdate[tween.getId()];
  };

  Group.prototype.update = function (time, preserve) {
    if (time === void 0) {
      time = now$1();
    }

    if (preserve === void 0) {
      preserve = false;
    }

    var tweenIds = Object.keys(this._tweens);

    if (tweenIds.length === 0) {
      return false;
    } // Tweens are updated in "batches". If you add a new tween during an
    // update, then the new tween will be updated in the next batch.
    // If you remove a tween during an update, it may or may not be updated.
    // However, if the removed tween was added during the current batch,
    // then it will not be updated.


    while (tweenIds.length > 0) {
      this._tweensAddedDuringUpdate = {};

      for (var i = 0; i < tweenIds.length; i++) {
        var tween = this._tweens[tweenIds[i]];
        var autoStart = !preserve;

        if (tween && tween.update(time, autoStart) === false && !preserve) {
          delete this._tweens[tweenIds[i]];
        }
      }

      tweenIds = Object.keys(this._tweensAddedDuringUpdate);
    }

    return true;
  };

  return Group;
}();
/**
 *
 */


var Interpolation = {
  Linear: function Linear(v, k) {
    var m = v.length - 1;
    var f = m * k;
    var i = Math.floor(f);
    var fn = Interpolation.Utils.Linear;

    if (k < 0) {
      return fn(v[0], v[1], f);
    }

    if (k > 1) {
      return fn(v[m], v[m - 1], m - f);
    }

    return fn(v[i], v[i + 1 > m ? m : i + 1], f - i);
  },
  Bezier: function Bezier(v, k) {
    var b = 0;
    var n = v.length - 1;
    var pw = Math.pow;
    var bn = Interpolation.Utils.Bernstein;

    for (var i = 0; i <= n; i++) {
      b += pw(1 - k, n - i) * pw(k, i) * v[i] * bn(n, i);
    }

    return b;
  },
  CatmullRom: function CatmullRom(v, k) {
    var m = v.length - 1;
    var f = m * k;
    var i = Math.floor(f);
    var fn = Interpolation.Utils.CatmullRom;

    if (v[0] === v[m]) {
      if (k < 0) {
        i = Math.floor(f = m * (1 + k));
      }

      return fn(v[(i - 1 + m) % m], v[i], v[(i + 1) % m], v[(i + 2) % m], f - i);
    } else {
      if (k < 0) {
        return v[0] - (fn(v[0], v[0], v[1], v[1], -f) - v[0]);
      }

      if (k > 1) {
        return v[m] - (fn(v[m], v[m], v[m - 1], v[m - 1], f - m) - v[m]);
      }

      return fn(v[i ? i - 1 : 0], v[i], v[m < i + 1 ? m : i + 1], v[m < i + 2 ? m : i + 2], f - i);
    }
  },
  Utils: {
    Linear: function Linear(p0, p1, t) {
      return (p1 - p0) * t + p0;
    },
    Bernstein: function Bernstein(n, i) {
      var fc = Interpolation.Utils.Factorial;
      return fc(n) / fc(i) / fc(n - i);
    },
    Factorial: function () {
      var a = [1];
      return function (n) {
        var s = 1;

        if (a[n]) {
          return a[n];
        }

        for (var i = n; i > 1; i--) {
          s *= i;
        }

        a[n] = s;
        return s;
      };
    }(),
    CatmullRom: function CatmullRom(p0, p1, p2, p3, t) {
      var v0 = (p2 - p0) * 0.5;
      var v1 = (p3 - p1) * 0.5;
      var t2 = t * t;
      var t3 = t * t2;
      return (2 * p1 - 2 * p2 + v0 + v1) * t3 + (-3 * p1 + 3 * p2 - 2 * v0 - v1) * t2 + v0 * t + p1;
    }
  }
};
/**
 * Utils
 */

var Sequence =
/** @class */
function () {
  function Sequence() {}

  Sequence.nextId = function () {
    return Sequence._nextId++;
  };

  Sequence._nextId = 0;
  return Sequence;
}();

var mainGroup = new Group();
/**
 * Tween.js - Licensed under the MIT license
 * https://github.com/tweenjs/tween.js
 * ----------------------------------------------
 *
 * See https://github.com/tweenjs/tween.js/graphs/contributors for the full list of contributors.
 * Thank you all, you're awesome!
 */

var Tween =
/** @class */
function () {
  function Tween(_object, _group) {
    if (_group === void 0) {
      _group = mainGroup;
    }

    this._object = _object;
    this._group = _group;
    this._isPaused = false;
    this._pauseStart = 0;
    this._valuesStart = {};
    this._valuesEnd = {};
    this._valuesStartRepeat = {};
    this._duration = 1000;
    this._initialRepeat = 0;
    this._repeat = 0;
    this._yoyo = false;
    this._isPlaying = false;
    this._reversed = false;
    this._delayTime = 0;
    this._startTime = 0;
    this._easingFunction = Easing.Linear.None;
    this._interpolationFunction = Interpolation.Linear;
    this._chainedTweens = [];
    this._onStartCallbackFired = false;
    this._id = Sequence.nextId();
    this._isChainStopped = false;
    this._goToEnd = false;
  }

  Tween.prototype.getId = function () {
    return this._id;
  };

  Tween.prototype.isPlaying = function () {
    return this._isPlaying;
  };

  Tween.prototype.isPaused = function () {
    return this._isPaused;
  };

  Tween.prototype.to = function (properties, duration) {
    // TODO? restore this, then update the 07_dynamic_to example to set fox
    // tween's to on each update. That way the behavior is opt-in (there's
    // currently no opt-out).
    // for (const prop in properties) this._valuesEnd[prop] = properties[prop]
    this._valuesEnd = Object.create(properties);

    if (duration !== undefined) {
      this._duration = duration;
    }

    return this;
  };

  Tween.prototype.duration = function (d) {
    this._duration = d;
    return this;
  };

  Tween.prototype.start = function (time) {
    if (this._isPlaying) {
      return this;
    } // eslint-disable-next-line


    this._group && this._group.add(this);
    this._repeat = this._initialRepeat;

    if (this._reversed) {
      // If we were reversed (f.e. using the yoyo feature) then we need to
      // flip the tween direction back to forward.
      this._reversed = false;

      for (var property in this._valuesStartRepeat) {
        this._swapEndStartRepeatValues(property);

        this._valuesStart[property] = this._valuesStartRepeat[property];
      }
    }

    this._isPlaying = true;
    this._isPaused = false;
    this._onStartCallbackFired = false;
    this._isChainStopped = false;
    this._startTime = time !== undefined ? typeof time === 'string' ? now$1() + parseFloat(time) : time : now$1();
    this._startTime += this._delayTime;

    this._setupProperties(this._object, this._valuesStart, this._valuesEnd, this._valuesStartRepeat);

    return this;
  };

  Tween.prototype._setupProperties = function (_object, _valuesStart, _valuesEnd, _valuesStartRepeat) {
    for (var property in _valuesEnd) {
      var startValue = _object[property];
      var startValueIsArray = Array.isArray(startValue);
      var propType = startValueIsArray ? 'array' : typeof startValue;
      var isInterpolationList = !startValueIsArray && Array.isArray(_valuesEnd[property]); // If `to()` specifies a property that doesn't exist in the source object,
      // we should not set that property in the object

      if (propType === 'undefined' || propType === 'function') {
        continue;
      } // Check if an Array was provided as property value


      if (isInterpolationList) {
        var endValues = _valuesEnd[property];

        if (endValues.length === 0) {
          continue;
        } // handle an array of relative values


        endValues = endValues.map(this._handleRelativeValue.bind(this, startValue)); // Create a local copy of the Array with the start value at the front

        _valuesEnd[property] = [startValue].concat(endValues);
      } // handle the deepness of the values


      if ((propType === 'object' || startValueIsArray) && startValue && !isInterpolationList) {
        _valuesStart[property] = startValueIsArray ? [] : {}; // eslint-disable-next-line

        for (var prop in startValue) {
          // eslint-disable-next-line
          // @ts-ignore FIXME?
          _valuesStart[property][prop] = startValue[prop];
        }

        _valuesStartRepeat[property] = startValueIsArray ? [] : {}; // TODO? repeat nested values? And yoyo? And array values?
        // eslint-disable-next-line
        // @ts-ignore FIXME?

        this._setupProperties(startValue, _valuesStart[property], _valuesEnd[property], _valuesStartRepeat[property]);
      } else {
        // Save the starting value, but only once.
        if (typeof _valuesStart[property] === 'undefined') {
          _valuesStart[property] = startValue;
        }

        if (!startValueIsArray) {
          // eslint-disable-next-line
          // @ts-ignore FIXME?
          _valuesStart[property] *= 1.0; // Ensures we're using numbers, not strings
        }

        if (isInterpolationList) {
          // eslint-disable-next-line
          // @ts-ignore FIXME?
          _valuesStartRepeat[property] = _valuesEnd[property].slice().reverse();
        } else {
          _valuesStartRepeat[property] = _valuesStart[property] || 0;
        }
      }
    }
  };

  Tween.prototype.stop = function () {
    if (!this._isChainStopped) {
      this._isChainStopped = true;
      this.stopChainedTweens();
    }

    if (!this._isPlaying) {
      return this;
    } // eslint-disable-next-line


    this._group && this._group.remove(this);
    this._isPlaying = false;
    this._isPaused = false;

    if (this._onStopCallback) {
      this._onStopCallback(this._object);
    }

    return this;
  };

  Tween.prototype.end = function () {
    this._goToEnd = true;
    this.update(Infinity);
    return this;
  };

  Tween.prototype.pause = function (time) {
    if (time === void 0) {
      time = now$1();
    }

    if (this._isPaused || !this._isPlaying) {
      return this;
    }

    this._isPaused = true;
    this._pauseStart = time; // eslint-disable-next-line

    this._group && this._group.remove(this);
    return this;
  };

  Tween.prototype.resume = function (time) {
    if (time === void 0) {
      time = now$1();
    }

    if (!this._isPaused || !this._isPlaying) {
      return this;
    }

    this._isPaused = false;
    this._startTime += time - this._pauseStart;
    this._pauseStart = 0; // eslint-disable-next-line

    this._group && this._group.add(this);
    return this;
  };

  Tween.prototype.stopChainedTweens = function () {
    for (var i = 0, numChainedTweens = this._chainedTweens.length; i < numChainedTweens; i++) {
      this._chainedTweens[i].stop();
    }

    return this;
  };

  Tween.prototype.group = function (group) {
    this._group = group;
    return this;
  };

  Tween.prototype.delay = function (amount) {
    this._delayTime = amount;
    return this;
  };

  Tween.prototype.repeat = function (times) {
    this._initialRepeat = times;
    this._repeat = times;
    return this;
  };

  Tween.prototype.repeatDelay = function (amount) {
    this._repeatDelayTime = amount;
    return this;
  };

  Tween.prototype.yoyo = function (yoyo) {
    this._yoyo = yoyo;
    return this;
  };

  Tween.prototype.easing = function (easingFunction) {
    this._easingFunction = easingFunction;
    return this;
  };

  Tween.prototype.interpolation = function (interpolationFunction) {
    this._interpolationFunction = interpolationFunction;
    return this;
  };

  Tween.prototype.chain = function () {
    var tweens = [];

    for (var _i = 0; _i < arguments.length; _i++) {
      tweens[_i] = arguments[_i];
    }

    this._chainedTweens = tweens;
    return this;
  };

  Tween.prototype.onStart = function (callback) {
    this._onStartCallback = callback;
    return this;
  };

  Tween.prototype.onUpdate = function (callback) {
    this._onUpdateCallback = callback;
    return this;
  };

  Tween.prototype.onRepeat = function (callback) {
    this._onRepeatCallback = callback;
    return this;
  };

  Tween.prototype.onComplete = function (callback) {
    this._onCompleteCallback = callback;
    return this;
  };

  Tween.prototype.onStop = function (callback) {
    this._onStopCallback = callback;
    return this;
  };
  /**
   * @returns true if the tween is still playing after the update, false
   * otherwise (calling update on a paused tween still returns true because
   * it is still playing, just paused).
   */


  Tween.prototype.update = function (time, autoStart) {
    if (time === void 0) {
      time = now$1();
    }

    if (autoStart === void 0) {
      autoStart = true;
    }

    if (this._isPaused) return true;
    var property;
    var elapsed;
    var endTime = this._startTime + this._duration;

    if (!this._goToEnd && !this._isPlaying) {
      if (time > endTime) return false;
      if (autoStart) this.start(time);
    }

    this._goToEnd = false;

    if (time < this._startTime) {
      return true;
    }

    if (this._onStartCallbackFired === false) {
      if (this._onStartCallback) {
        this._onStartCallback(this._object);
      }

      this._onStartCallbackFired = true;
    }

    elapsed = (time - this._startTime) / this._duration;
    elapsed = this._duration === 0 || elapsed > 1 ? 1 : elapsed;

    var value = this._easingFunction(elapsed); // properties transformations


    this._updateProperties(this._object, this._valuesStart, this._valuesEnd, value);

    if (this._onUpdateCallback) {
      this._onUpdateCallback(this._object, elapsed);
    }

    if (elapsed === 1) {
      if (this._repeat > 0) {
        if (isFinite(this._repeat)) {
          this._repeat--;
        } // Reassign starting values, restart by making startTime = now


        for (property in this._valuesStartRepeat) {
          if (!this._yoyo && typeof this._valuesEnd[property] === 'string') {
            this._valuesStartRepeat[property] = // eslint-disable-next-line
            // @ts-ignore FIXME?
            this._valuesStartRepeat[property] + parseFloat(this._valuesEnd[property]);
          }

          if (this._yoyo) {
            this._swapEndStartRepeatValues(property);
          }

          this._valuesStart[property] = this._valuesStartRepeat[property];
        }

        if (this._yoyo) {
          this._reversed = !this._reversed;
        }

        if (this._repeatDelayTime !== undefined) {
          this._startTime = time + this._repeatDelayTime;
        } else {
          this._startTime = time + this._delayTime;
        }

        if (this._onRepeatCallback) {
          this._onRepeatCallback(this._object);
        }

        return true;
      } else {
        if (this._onCompleteCallback) {
          this._onCompleteCallback(this._object);
        }

        for (var i = 0, numChainedTweens = this._chainedTweens.length; i < numChainedTweens; i++) {
          // Make the chained tweens start exactly at the time they should,
          // even if the `update()` method was called way past the duration of the tween
          this._chainedTweens[i].start(this._startTime + this._duration);
        }

        this._isPlaying = false;
        return false;
      }
    }

    return true;
  };

  Tween.prototype._updateProperties = function (_object, _valuesStart, _valuesEnd, value) {
    for (var property in _valuesEnd) {
      // Don't update properties that do not exist in the source object
      if (_valuesStart[property] === undefined) {
        continue;
      }

      var start = _valuesStart[property] || 0;
      var end = _valuesEnd[property];
      var startIsArray = Array.isArray(_object[property]);
      var endIsArray = Array.isArray(end);
      var isInterpolationList = !startIsArray && endIsArray;

      if (isInterpolationList) {
        _object[property] = this._interpolationFunction(end, value);
      } else if (typeof end === 'object' && end) {
        // eslint-disable-next-line
        // @ts-ignore FIXME?
        this._updateProperties(_object[property], start, end, value);
      } else {
        // Parses relative end values with start as base (e.g.: +10, -3)
        end = this._handleRelativeValue(start, end); // Protect against non numeric properties.

        if (typeof end === 'number') {
          // eslint-disable-next-line
          // @ts-ignore FIXME?
          _object[property] = start + (end - start) * value;
        }
      }
    }
  };

  Tween.prototype._handleRelativeValue = function (start, end) {
    if (typeof end !== 'string') {
      return end;
    }

    if (end.charAt(0) === '+' || end.charAt(0) === '-') {
      return start + parseFloat(end);
    } else {
      return parseFloat(end);
    }
  };

  Tween.prototype._swapEndStartRepeatValues = function (property) {
    var tmp = this._valuesStartRepeat[property];
    var endValue = this._valuesEnd[property];

    if (typeof endValue === 'string') {
      this._valuesStartRepeat[property] = this._valuesStartRepeat[property] + parseFloat(endValue);
    } else {
      this._valuesStartRepeat[property] = this._valuesEnd[property];
    }

    this._valuesEnd[property] = tmp;
  };

  return Tween;
}();

var VERSION = '18.6.4';
/**
 * Tween.js - Licensed under the MIT license
 * https://github.com/tweenjs/tween.js
 * ----------------------------------------------
 *
 * See https://github.com/tweenjs/tween.js/graphs/contributors for the full list of contributors.
 * Thank you all, you're awesome!
 */

var nextId = Sequence.nextId;
/**
 * Controlling groups of tweens
 *
 * Using the TWEEN singleton to manage your tweens can cause issues in large apps with many components.
 * In these cases, you may want to create your own smaller groups of tweens.
 */

var TWEEN = mainGroup; // This is the best way to export things in a way that's compatible with both ES
// Modules and CommonJS, without build hacks, and so as not to break the
// existing API.
// https://github.com/rollup/rollup/issues/1961#issuecomment-423037881

var getAll = TWEEN.getAll.bind(TWEEN);
var removeAll = TWEEN.removeAll.bind(TWEEN);
var add = TWEEN.add.bind(TWEEN);
var remove = TWEEN.remove.bind(TWEEN);
var update = TWEEN.update.bind(TWEEN);
var exports$1 = {
  Easing: Easing,
  Group: Group,
  Interpolation: Interpolation,
  now: now$1,
  Sequence: Sequence,
  nextId: nextId,
  Tween: Tween,
  VERSION: VERSION,
  getAll: getAll,
  removeAll: removeAll,
  add: add,
  remove: remove,
  update: update,
  TWEEN: TWEEN
};
module.exports.Easing = Easing;
module.exports.Group = Group;
module.exports.Interpolation = Interpolation;
module.exports.Sequence = Sequence;
module.exports.Tween = Tween;
module.exports.VERSION = VERSION;
module.exports.add = add;
module.exports["default"] = exports$1;
module.exports.getAll = getAll;
module.exports.nextId = nextId;
module.exports.now = now$1;
module.exports.remove = remove;
module.exports.removeAll = removeAll;
module.exports.update = update;
module.exports.TWEEN = TWEEN;

cc._RF.pop();

}).call(this,require("../../../../../../../../../../Applications/CocosCreator/Creator/2.4.3/CocosCreator.app/Contents/Resources/app.asar/node_modules/process/browser.js"))
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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