"use strict";
cc._RF.push(module, 'ac5a9bXH9hFYZE61PDgKN5g', 'AudioCtr');
// script/AudioCtr.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SFX_TYPE = void 0;
var Tween_1 = require("./tween/Tween");
/**
 * 音效类型
 */
var SFX_TYPE;
(function (SFX_TYPE) {
    SFX_TYPE[SFX_TYPE["NORMAL"] = 0] = "NORMAL";
    SFX_TYPE[SFX_TYPE["UI"] = 1] = "UI";
})(SFX_TYPE = exports.SFX_TYPE || (exports.SFX_TYPE = {}));
/**
 * 音频管理类
 * => 暂停游戏时调低bgm音量，暂停游戏内音效，不影响ui音效
 */
var AudioCtr = /** @class */ (function () {
    function AudioCtr() {
    }
    Object.defineProperty(AudioCtr, "bgmVolume", {
        /** 全局bgm音量 */
        get: function () {
            return this._bgmVolume;
        },
        set: function (volume) {
            var _this = this;
            if (this._bgmVolume === volume) {
                return;
            }
            this._bgmVolume = cc.misc.clampf(volume, 0, 1);
            this._bgmMap.forEach(function (audioData, clip) {
                cc.audioEngine.setVolume(audioData.id, _this._bgmVolume * audioData.volume);
            });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AudioCtr, "sfxVolume", {
        /** 全局sfx音量 */
        get: function () {
            return this._sfxVolume;
        },
        set: function (volume) {
            var _this = this;
            if (this._sfxVolume === volume) {
                return;
            }
            this._sfxVolume = cc.misc.clampf(volume, 0, 1);
            this._normalSfxMap.forEach(function (data, clip) {
                data.audioList.forEach(function (audioData) {
                    cc.audioEngine.setVolume(audioData.id, _this._sfxVolume * audioData.volume);
                });
            });
            this._uiSfxMap.forEach(function (data, clip) {
                data.audioList.forEach(function (audioData) {
                    cc.audioEngine.setVolume(audioData.id, _this._sfxVolume * audioData.volume);
                });
            });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AudioCtr, "bgmOff", {
        /** bgm是否关闭 */
        get: function () {
            return this._bgmOff;
        },
        set: function (isOff) {
            if (this._bgmOff === isOff) {
                return;
            }
            this._bgmOff = isOff;
            if (this._bgmOff) {
                this._bgmMap.forEach(function (audioData, clip) {
                    audioData.tween && audioData.tween.stop();
                    audioData.tween = null;
                    cc.audioEngine.stop(audioData.id);
                });
                this._bgmMap.clear();
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AudioCtr, "sfxOff", {
        /** sfx是否关闭 */
        get: function () {
            return this._sfxOff;
        },
        set: function (isOff) {
            if (this._sfxOff === isOff) {
                return;
            }
            this._sfxOff = isOff;
            if (this._sfxOff) {
                this._normalSfxMap.forEach(function (data, clip) {
                    data.audioList.forEach(function (audioData) {
                        cc.audioEngine.stop(audioData.id);
                    });
                    data.audioList.length = 0;
                });
                this._uiSfxMap.forEach(function (data, clip) {
                    data.audioList.forEach(function (audioData) {
                        cc.audioEngine.stop(audioData.id);
                    });
                    data.audioList.length = 0;
                });
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AudioCtr, "bgmPause", {
        /** bgm是否暂停 */
        get: function () {
            return this._bgmPause;
        },
        set: function (isPause) {
            var _this = this;
            if (this.bgmOff || this._bgmPause === isPause) {
                return;
            }
            this._bgmPause = isPause;
            this._bgmMap.forEach(function (data, clip) {
                if (_this._bgmPause) {
                    data.tween && data.tween.pause();
                    cc.audioEngine.pause(data.id);
                }
                else {
                    data.tween && data.tween.resume();
                    cc.audioEngine.resume(data.id);
                }
            });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AudioCtr, "sfxPause", {
        /** sfx是否暂停，暂停时不暂停ui音效 */
        get: function () {
            return this._sfxPause;
        },
        set: function (isPause) {
            if (this.sfxOff || this._sfxPause === isPause) {
                return;
            }
            this._sfxPause = isPause;
            if (this._sfxPause) {
                this._normalSfxMap.forEach(function (data, clip) {
                    data.audioList.forEach(function (audioData) {
                        cc.audioEngine.pause(audioData.id);
                    });
                });
            }
            else {
                this._normalSfxMap.forEach(function (data, clip) {
                    data.audioList.forEach(function (audioData) {
                        cc.audioEngine.resume(audioData.id);
                    });
                });
            }
        },
        enumerable: false,
        configurable: true
    });
    /**
     * 音量渐变
     * @param data
     * @param duration 音量渐变时长 单位ms
     * @param from 音量初始值
     * @param to 音量目标值
     * @param call 渐变结束的回调
     */
    AudioCtr.volumeFade = function (data, duration, from, to, call) {
        var _this = this;
        data.tween && data.tween.stop();
        data.volume = from;
        data.tween = new Tween_1.Tween(data)
            .to({ volume: to }, duration)
            .onUpdate(function () {
            cc.audioEngine.setVolume(data.id, data.volume * _this.bgmVolume);
        })
            .onComplete(function () {
            data.tween = null;
            if (call) {
                call();
            }
        })
            .start();
    };
    /**
     * 播放音频并返回AudioData
     */
    AudioCtr.play = function (clip, loop, volume, finishCall, audioData) {
        if (finishCall === void 0) { finishCall = null; }
        if (audioData === void 0) { audioData = null; }
        if (audioData) {
            audioData.id = cc.audioEngine.play(clip, loop, volume);
            audioData.volume = 1;
            if (audioData.tween) {
                audioData.tween.stop();
                audioData.tween = null;
            }
        }
        else {
            audioData = {
                id: cc.audioEngine.play(clip, loop, volume),
                volume: 1,
                tween: null
            };
        }
        if (finishCall) {
            cc.audioEngine.setFinishCallback(audioData.id, finishCall);
        }
        return audioData;
    };
    /**
     * 播放bgm
     * @param clip
     * @param loop 是否循环
     * @param fadeDuration 音量渐变时长 单位ms
     * @param finishCall 正常播放结束时的回调
     */
    AudioCtr.playBgm = function (clip, loop, fadeDuration, finishCall) {
        if (loop === void 0) { loop = true; }
        if (fadeDuration === void 0) { fadeDuration = 0; }
        if (finishCall === void 0) { finishCall = null; }
        if (this.bgmOff) {
            return;
        }
        var audioData = this._bgmMap.get(clip);
        if (audioData === undefined) {
            audioData = this.play(clip, loop, this.bgmVolume, finishCall);
            this._bgmMap.set(clip, audioData);
        }
        else {
            cc.audioEngine.stop(audioData.id);
            this.play(clip, loop, this.bgmVolume, finishCall, audioData);
        }
        if (fadeDuration > 0) {
            this.volumeFade(audioData, fadeDuration, 0, 1);
        }
    };
    /**
     * 播放sfx
     * @param clip
     * @param type 音效类型
     * @param finishCall 正常播放结束时的回调
     */
    AudioCtr.playSfx = function (clip, type, finishCall) {
        if (type === void 0) { type = SFX_TYPE.NORMAL; }
        if (finishCall === void 0) { finishCall = null; }
        if (this.sfxOff) {
            return;
        }
        var sfxData = type === SFX_TYPE.NORMAL ? this._normalSfxMap.get(clip) : this._uiSfxMap.get(clip);
        var audioData = null;
        if (sfxData === undefined) {
            sfxData = this.setSfxData(clip, type);
            audioData = this.play(clip, false, this.sfxVolume, finishCall);
            sfxData.audioList.push(audioData);
        }
        else {
            // 剔除不处于播放状态的音频
            while (sfxData.audioList.length > 0 && cc.audioEngine.getState(sfxData.audioList[0].id) !== cc.audioEngine.AudioState.PLAYING) {
                cc.audioEngine.stop(sfxData.audioList.shift().id);
            }
            // 已达到最大数量则剔除最先(第一个)缓存的音频
            while (sfxData.overStop && sfxData.audioList.length >= sfxData.maxNum) {
                cc.audioEngine.stop(sfxData.audioList.shift().id);
            }
            // 缓存新的音频
            if (sfxData.audioList.length < sfxData.maxNum) {
                audioData = this.play(clip, false, this.sfxVolume, finishCall);
                sfxData.audioList.push(audioData);
            }
        }
    };
    /**
     * 设置音效数据(用于控制某些短时间内同时大量播放的音效)
     * @param clip
     * @param type 音效类型
     * @param maxNum 此音效最大同时播放的数量
     * @param overStop 超过最大数量时是否stop未播完的音效并缓存新的音效
     */
    AudioCtr.setSfxData = function (clip, type, maxNum, overStop) {
        if (type === void 0) { type = SFX_TYPE.NORMAL; }
        if (maxNum === void 0) { maxNum = 8; }
        if (overStop === void 0) { overStop = false; }
        maxNum = Math.max(maxNum, 1);
        var map = type === SFX_TYPE.NORMAL ? this._normalSfxMap : this._uiSfxMap;
        var sfxData = map.get(clip);
        if (sfxData === undefined) {
            sfxData = {
                audioList: [],
                maxNum: maxNum,
                overStop: overStop
            };
            map.set(clip, sfxData);
        }
        else {
            sfxData.maxNum = maxNum;
            sfxData.overStop = overStop;
        }
        return sfxData;
    };
    /**
     * 停止bgm
     * @param clip 需停止的音频，clip返回值为false则停止所有
     * @param fadeDuration 音量渐变时长 单位ms
     */
    AudioCtr.stopBgm = function (clip, fadeDuration) {
        var _this = this;
        if (clip === void 0) { clip = null; }
        if (fadeDuration === void 0) { fadeDuration = 0; }
        if (this.bgmOff) {
            return;
        }
        if (clip) {
            var audioData_1 = this._bgmMap.get(clip);
            if (audioData_1 === undefined) {
                return;
            }
            audioData_1.tween && audioData_1.tween.stop();
            audioData_1.tween = null;
            if (fadeDuration <= 0) {
                cc.audioEngine.stop(audioData_1.id);
                this._bgmMap.delete(clip);
            }
            else {
                this.volumeFade(audioData_1, fadeDuration, 1, 0, function () {
                    cc.audioEngine.stop(audioData_1.id);
                    _this._bgmMap.delete(clip);
                });
            }
        }
        else {
            if (fadeDuration <= 0) {
                this._bgmMap.forEach(function (audioData, clip) {
                    audioData.tween && audioData.tween.stop();
                    audioData.tween = null;
                    cc.audioEngine.stop(audioData.id);
                });
                this._bgmMap.clear();
            }
            else {
                this._bgmMap.forEach(function (audioData, clip) {
                    audioData.tween && audioData.tween.stop();
                    audioData.tween = null;
                    _this.volumeFade(audioData, fadeDuration, 1, 0, function () {
                        cc.audioEngine.stop(audioData.id);
                        _this._bgmMap.delete(clip);
                    });
                });
            }
        }
    };
    /**
     * 停止sfx
     * @param clip 需停止的音频，clip返回值为false则停止所有
     * @param type 音效类型
     */
    AudioCtr.stopSfx = function (clip, type) {
        if (clip === void 0) { clip = null; }
        if (type === void 0) { type = SFX_TYPE.NORMAL; }
        if (this.sfxOff) {
            return;
        }
        if (clip) {
            var data = type === SFX_TYPE.NORMAL ? this._normalSfxMap.get(clip) : this._uiSfxMap.get(clip);
            if (data === undefined || data.audioList.length <= 0) {
                return;
            }
            data.audioList.forEach(function (audioData) {
                cc.audioEngine.stop(audioData.id);
            });
            data.audioList.length = 0;
        }
        else {
            this._normalSfxMap.forEach(function (data, clip) {
                data.audioList.forEach(function (audioData) {
                    cc.audioEngine.stop(audioData.id);
                });
                data.audioList.length = 0;
            });
            this._uiSfxMap.forEach(function (data, clip) {
                data.audioList.forEach(function (audioData) {
                    cc.audioEngine.stop(audioData.id);
                });
                data.audioList.length = 0;
            });
        }
    };
    /**
     * 停止所有音频
     */
    AudioCtr.stopAll = function () {
        this.stopBgm();
        this.stopSfx();
    };
    /**
     * 暂停所有音频
     */
    AudioCtr.pauseAll = function () {
        this.bgmPause = true;
        this.sfxPause = true;
    };
    /**
     * 恢复所有音频
     */
    AudioCtr.resumeAll = function () {
        this.bgmPause = false;
        this.sfxPause = false;
    };
    /** 缓存的bgm数据 */
    AudioCtr._bgmMap = new Map();
    /** 缓存的普通音效数据 */
    AudioCtr._normalSfxMap = new Map();
    /** 缓存的ui音效数据 */
    AudioCtr._uiSfxMap = new Map();
    AudioCtr._bgmVolume = 1;
    AudioCtr._sfxVolume = 1;
    AudioCtr._bgmOff = false;
    AudioCtr._sfxOff = false;
    AudioCtr._bgmPause = false;
    AudioCtr._sfxPause = false;
    return AudioCtr;
}());
exports.default = AudioCtr;

cc._RF.pop();