import { _decorator, Component, screen, find, macro, math, Node, ResolutionPolicy, sys, view } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('NewComponent')
export class NewComponent extends Component {

    orientationCount: number = 0;

    start() {
        view.off("canvas-resize", this.resize, this);
        view.on("canvas-resize", this.resize, this);

        this.scheduleOnce(()=>{
            this.resize();
        },5)
    }

    resize() {
        if (this.orientationCount >= 3) return;
        this.orientationCount += 1;
        let fSize = view.getFrameSize();
        view.setOrientation(macro.ORIENTATION_LANDSCAPE);
        screen.windowSize = new math.Size(Math.max(fSize.width, fSize.height), Math.min(fSize.width, fSize.height));
        view.setDesignResolutionSize(1280, 720, ResolutionPolicy.ContentStrategy.FIXED_HEIGHT);

        this.scheduleOnce(() => {
            window.dispatchEvent(new Event('resize'))
        })
    }

}


