
import { _decorator, Component, Node, sp, resources, TextAsset, Texture2D } from 'cc';
const { ccclass, type } = _decorator;

@ccclass('Begin')
export class Begin extends Component {
    @type(sp.Skeleton)
    skeleton:sp.Skeleton = null!;
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    start () {
        resources.load('1149atk_atlas', TextAsset, (err, atlasAsset) => {
            resources.load('1149atk_json', TextAsset, (err, jsonStrAsset) => {
                resources.load('1149atk/texture', Texture2D, (err, texture) => {
                    let atlas = atlasAsset.text;
                    let json = JSON.parse(jsonStrAsset.text);
                    let textures:Texture2D[] = [texture];
                    let textureNames:string[] = ['1149atk.png'];
                    let sd = new sp.SkeletonData();
                    sd.skeletonJson = json;
                    sd.atlasText = atlas;
                    sd.textures = textures;
                    sd.textureNames = textureNames;
                    this.skeleton.skeletonData = sd;
                    this.skeleton.setAnimation(0, '1', true);
                });
            })
        })
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.0/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.0/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.0/manual/en/scripting/life-cycle-callbacks.html
 */
