const { ccclass, property, executeInEditMode } = cc._decorator;

@ccclass
@executeInEditMode
export default class AnimaAtlas2D extends cc.Component {

    @property({
        type: cc.Integer,
        tooltip: "水平方向帧数",
        min: 1
    })
    set Hframes(v) {
        this._Hframes = v;
        this.splitTexture();
    }
    get Hframes() {
        return this._Hframes;
    }
    _Hframes = 1;

    @property({
        type: cc.Integer,
        tooltip: "垂直方向帧数",
        min: 1
    })
    set Vframes(v) {
        this._Vframes = v;
        this.splitTexture();
    }
    get Vframes() {
        return this._Vframes;
    }
    _Vframes = 1;

    private _frame = 0;

    @property({ type: cc.Integer })
    get frame() {
        return this._frame;
    }
    set frame(v) {
        const max = this.Hframes * this.Vframes - 1;
        this._frame = cc.misc.clampf(v, 0, max);
        this.updateFrame();

    }

    @property({ type: cc.Sprite })
    sprite: cc.Sprite = null;

    @property({ type: cc.SpriteFrame })
    set m_spriteFrame(v) {
        this._spriteFrame = v;
        
    }
    get m_spriteFrame() {
        return this._spriteFrame;
    }
    _spriteFrame: cc.SpriteFrame = null;

    private spriteFrames: cc.SpriteFrame[] = [];

    frameWidth: number = 0;
    frameHeight: number = 0;


    onLoad() {
        if (!this.sprite) this.sprite = this.getComponent(cc.Sprite);
    }

    private splitTexture() {
        if (!this.sprite || !this._spriteFrame) return;
        
        const original = this._spriteFrame;
        const tex = original.getTexture();
        const rect = original.getRect();
        //console.log(tex.width, tex.height);
        this.frameWidth = tex.width / this.Hframes;
        this.frameHeight = tex.height / this.Vframes;

        this.spriteFrames = [];
        
        for (let row = 0; row < this.Vframes; row++) {
            for (let col = 0; col < this.Hframes; col++) {
                const sf = new cc.SpriteFrame();
                sf.setTexture(tex);
                sf.setRect(cc.rect(
                    col * this.frameWidth,
                    row * this.frameHeight,
                    this.frameWidth,
                    this.frameHeight
                ));
                sf.setOffset(original.getOffset());
                this.spriteFrames.push(sf);
            }
        }
        
        this.updateFrame();
    }

    private updateFrame() {
        //console.log(this._frame);
        if (!this.sprite || this.spriteFrames.length === 0) return;
        if (this._frame >= this.spriteFrames.length) return;
        this._frame = Math.floor(this._frame);
        this.sprite.spriteFrame = null;
        this.sprite.spriteFrame = this.spriteFrames[this._frame];

    }

    // 编辑器属性变化回调
    public onPropertyChange() {
    }
}