"use strict";
cc._RF.push(module, '683eeSb9JZAM5DeCezVtZ3e', 'AnimaAtlas2D');
// scripts/AnimaAtlas2D.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, executeInEditMode = _a.executeInEditMode;
var AnimaAtlas2D = /** @class */ (function (_super) {
    __extends(AnimaAtlas2D, _super);
    function AnimaAtlas2D() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._Hframes = 1;
        _this._Vframes = 1;
        _this._frame = 0;
        _this.sprite = null;
        _this._spriteFrame = null;
        _this.spriteFrames = [];
        _this.frameWidth = 0;
        _this.frameHeight = 0;
        return _this;
    }
    Object.defineProperty(AnimaAtlas2D.prototype, "Hframes", {
        get: function () {
            return this._Hframes;
        },
        set: function (v) {
            this._Hframes = v;
            this.splitTexture();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AnimaAtlas2D.prototype, "Vframes", {
        get: function () {
            return this._Vframes;
        },
        set: function (v) {
            this._Vframes = v;
            this.splitTexture();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AnimaAtlas2D.prototype, "frame", {
        get: function () {
            return this._frame;
        },
        set: function (v) {
            var max = this.Hframes * this.Vframes - 1;
            this._frame = cc.misc.clampf(v, 0, max);
            this.updateFrame();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AnimaAtlas2D.prototype, "m_spriteFrame", {
        get: function () {
            return this._spriteFrame;
        },
        set: function (v) {
            this._spriteFrame = v;
        },
        enumerable: false,
        configurable: true
    });
    AnimaAtlas2D.prototype.onLoad = function () {
        if (!this.sprite)
            this.sprite = this.getComponent(cc.Sprite);
    };
    AnimaAtlas2D.prototype.splitTexture = function () {
        if (!this.sprite || !this._spriteFrame)
            return;
        var original = this._spriteFrame;
        var tex = original.getTexture();
        var rect = original.getRect();
        //console.log(tex.width, tex.height);
        this.frameWidth = tex.width / this.Hframes;
        this.frameHeight = tex.height / this.Vframes;
        this.spriteFrames = [];
        for (var row = 0; row < this.Vframes; row++) {
            for (var col = 0; col < this.Hframes; col++) {
                var sf = new cc.SpriteFrame();
                sf.setTexture(tex);
                sf.setRect(cc.rect(col * this.frameWidth, row * this.frameHeight, this.frameWidth, this.frameHeight));
                sf.setOffset(original.getOffset());
                this.spriteFrames.push(sf);
            }
        }
        this.updateFrame();
    };
    AnimaAtlas2D.prototype.updateFrame = function () {
        //console.log(this._frame);
        if (!this.sprite || this.spriteFrames.length === 0)
            return;
        if (this._frame >= this.spriteFrames.length)
            return;
        this._frame = Math.floor(this._frame);
        this.sprite.spriteFrame = null;
        this.sprite.spriteFrame = this.spriteFrames[this._frame];
    };
    // 编辑器属性变化回调
    AnimaAtlas2D.prototype.onPropertyChange = function () {
    };
    __decorate([
        property({
            type: cc.Integer,
            tooltip: "水平方向帧数",
            min: 1
        })
    ], AnimaAtlas2D.prototype, "Hframes", null);
    __decorate([
        property({
            type: cc.Integer,
            tooltip: "垂直方向帧数",
            min: 1
        })
    ], AnimaAtlas2D.prototype, "Vframes", null);
    __decorate([
        property({ type: cc.Integer })
    ], AnimaAtlas2D.prototype, "frame", null);
    __decorate([
        property({ type: cc.Sprite })
    ], AnimaAtlas2D.prototype, "sprite", void 0);
    __decorate([
        property({ type: cc.SpriteFrame })
    ], AnimaAtlas2D.prototype, "m_spriteFrame", null);
    AnimaAtlas2D = __decorate([
        ccclass,
        executeInEditMode
    ], AnimaAtlas2D);
    return AnimaAtlas2D;
}(cc.Component));
exports.default = AnimaAtlas2D;

cc._RF.pop();