
import { _decorator, Component, Node, resources, Prefab, instantiate } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Test')
export class Test extends Component {
    @property({ type: Node })
    pNode: Node = null!;

    pf: Prefab | null = null;

    start() {
        // [3]
    }

    onAddBtn() {
        console.log(".............");
        resources.load('Node', Prefab, (err, prefab) => {
            prefab.addRef();
            this.pf = prefab;
            var node: Node = instantiate(prefab);
            node.parent = this.pNode;
        })
    }
    onDeleteBtn() {
        if (this.pf) {
            this.pNode.removeAllChildren();
            this.pf?.decRef();
            this.pf = null;
        }
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.0/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.0/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.0/manual/en/scripting/life-cycle-callbacks.html
 */
