/******************************框架通用枚举，不需要改动******************************/
//互推预制件
enum RecommendPrefab {
    item = "RecommendItem",                 //基础类型的互推游戏节点
    drawer = "RecommendDrawer",             //矩阵抽屉
    banner = "RecommendBanner",
    matrix = "RecommendMatrix",
    primary = "RecommendPrimary",
    primary_tt = "RecommendPrimary_TT",
    btnCenter_tt = "RecommendBtnCenter_TT", //头条平台正中间的互推按钮
    btnSide_tt = "RecommendBtnSide_TT",     //头条平台靠边的互推按钮
}
//互推游戏节点类型
enum RecommendItemType {
    /**包含游戏icon，游戏名称，背景图的互推节点 */
    iconNameBg = "RecommendItem_iconNameBg",
    /**包含游戏icon，游戏名称的互推节点 */
    // iconName = "RecommendItem_iconName",
    /**包含游戏icon的互推节点 */
    icon = "RecommendItem_icon",
    /**包含游戏icon，背景图的互推节点 */
    // iconBg = "RecommendItem_iconBg",
}
//互推矩阵抽屉类型
enum RecommendDrawerType {
    left = 1,       //从左侧进入的抽屉
    right,          //从右侧进入的抽屉
}
//互推banner类型
enum RecommendBannerType {
    pingpong = 1,   //来回滚动
    left,           //永远向左滚动
    right,          //永远向右滚动
}

/**游戏流程节点 */
enum GameFlowStep {
    /**初始场景 */
    initScene = "InitScene",
    /**广告位弹窗 */
    recommendDialog = "RecommendDialog",
    /**游戏首页 */
    lobby = "GameLobby",
    /**游戏中 */
    level = "Level",
    /**奖励领取界面 */
    award = "AwardUI",
    /**胜利界面 */
    win = "WinUI",
    /**失败界面 */
    lose = "LoseUI",

}
/**游戏流程中穿插的导流节点类型 */
enum RecommendFlowStep {
    /**观看视频 */
    video = "shipin",
    /**banner误触页 */
    touchBannerUI = "zadan",
    /**插屏广告 */
    insertAd = "chaping",
    /**大全导页 */
    bigPage = "daquandao",
    /**中全导页 */
    middlePage = "zhongquandao",
    /**小全导页 */
    littlePage = "xiaoquandao",
}
/**导流节点的后台开关属性 */
enum RecommendFlowConfig {
    /**是否开启，值：1-开启，0-关闭 */
    visible = "kaiguan",
    /**导出模式，值：1-正常模式，相当于开关关闭；2-导流模式，正常显示广告位；3-banner模式，即开启误触，误触条件达成时显示banner */
    mode = "daochumode",
    /**节点出现次数 */
    count = "cishu",

    /**误触页出现banner需要的按钮点击次数范围 */
    touchBannerClickCount = "chuxian",

    /**结算页显示后，banner经过多长时间显示，单位：秒 */
    resultBannerShowDelay = "chuxian",
    /**结算页显示后，被banner遮挡的按钮经过多长时间移动，单位：秒 */
    resultBtnMoveDelay = "yidong",

    /**全导页显示后，banner经过多长时间显示，单位：秒 */
    recommendBannerShowDelay = "chuxian",
    /**全导页banner显示后，经过多长时间隐藏，单位：秒 */
    recommendBannerHideDelay = "xiaoshi",

    //闪屏误触banner：
    /**按钮预点击次数：开始延迟显示banner之前需要点击按钮的次数，为固定次数或范围 */
    preClickCount = "diaochu",
    /**点击按钮达到指定次数后，延迟显示banenr的时间，单位：秒 */
    shanPinShowBannerDelay = "chuxian",
    /**banner显示后自动隐藏的延迟时间，单位：秒 */
    shanPinHideBannerDelay = "yidong",

}
/**后台配置全局开关 */
enum GameFlowGlobalConfig {
    /**广点通过审开关 */
    guoshen = "gdtguoshenkaiguan",
    /**砸蛋页是否必须点击banner才能继续游戏 */
    mustTouchBanner = "zadanbidiankaiguan",
    /**游戏中误触次数 */
    levelTouchBanner = "playingwuchucishu",
}
/**banner误触位置的展示模式：展示banner还是广告位，是否开启误触 */
enum BannerTouchMode {
    /**正常模式，相当于后台开关关闭 */
    normal = 1,
    /**导流模式，正常显示广告位 */
    recommend = 2,
    /**banner模式，即开启误触，误触条件达成时显示banner */
    banner = 3,
    /**延迟显示banner并移动按钮的模式 */
    delayShowBanner = 4,
}

/**banner误触类型 */
enum BannerTouchType {
    /**基类，用于错误提醒 */
    base,
    /**闪屏方式：按钮点击N次后，延迟X秒出现banner，延迟Y秒隐藏banner，再次点击按钮生效 */
    shanpin,
    /**闪屏方式：按钮点击N次后，延迟X秒出现banner，延迟Y秒隐藏banner，再次点击按钮生效；开关关闭时，直接显示banner，按钮显示在其他位置 */
    shanpin_moveBtn,
    /**移动按钮的方式：点击按钮后，延迟X秒出现banner，延迟Y秒按钮移动到banner上方，移动完成后点击按钮生效 */
    weiyi,
    /**延迟显示banner方式：按钮显示在banner位置，延迟2秒后显示banner，同时按钮移动到正常位置 */
    delayShowBanner,
}

/**触摸控制器状态 */
enum CtrlState {
    none = 1,
    touched,    //按住状态
}

/**用于数据统计的视频事件 */
enum VideoSubType {
    showVideoBtn = 7,       //曝光，比如复活时看到观看视频按钮
    openVideoWindow = 0,    //主动触发打开视频窗口
    closeVideoWindow = 1,   //看到视频窗口后主动关闭
    clickBtnVideo = 2,      //点击播放视频
    videoQuit = 3,          //视频中途关闭视频
    videoSuc = 4,           //观看结束
    getAward = 5,           //获得奖励
    videoFail = 6,          //没有可观看的广告
}

/*****************框架通用枚举，可能需要根据实际游戏添加枚举值，添加后放到其他游戏中照样能正常运行*****************/
/**资源路径，可为本地路径或远程路径 */
enum UrlPath {
    //皮肤资源：
    /**皮肤资源根路径 */
    skinRootUrl = "myGame/Img/Skin/",
    /**皮肤贴图文件夹名 */
    skinTextureDir = "Textures",
    /**皮肤在商城的商品项显示图片的文件夹名 */
    skinItemDir = "Item",
    /**皮肤商品选中时在展示台显示的图片的文件夹名 */
    skinDisplayDir = "Display",
}
/**UI类型，枚举值与对应UI预制件、脚本名称相同 */
enum UI {
    lobby = "GameLobby",                //首页

    configSetting = "ConfigSettingUI",  //设置面板

    playerAssetBar = "PlayerAssetBar",  //玩家资产信息条
    getPower = "GetPowerUI",            //获取体力界面
    tipPower = "TipPowerUI",            //体力不足提示界面

    shop = "ShopUI",                    //商城界面
    chooseLevel = "ChooseLevelUI",      //关卡选择页面 

    levelInfo = "LevelInfoUI",          //关卡信息
    levelController = "LevelController",//关卡操作面板
    pauseLevel = "PauseLevelUI",        //关卡暂停面板
    trySkin = "TrySkinUI",              //皮肤试用界面
    levelTeach = "TeachAnim",           //关卡教学界面
    awardUI = "AwardUI",                //奖励领取界面
    winUI = "WinUI",                    //胜利界面
    loseUI = "LoseUI",                  //失败界面
    resurgence = "ResurgenceUI",        //复活界面

    assembleScene = "AssembleScene",    //组装界面
    enterFightLoading = "EnterFightLoading",//进入战斗过渡界面
    fightScene = "FightScene",          //战斗界面

    touchBanner = "TouchBannerUI",      //砸蛋页面

    littlePage = "Recommend_littlePage",//小全导页
    middlePage = "Recommend_middlePage",//中全导页
    bigPage = "Recommend_bigPage",      //大全导页
    recommendDialog = "RecommendDialog",//互推弹窗
}
/**游戏数据类型 */
enum GameDataType {
    /**关卡数据 */
    levelData = "LevelData",
    playerSkin = "PlayerSkin",
    RobotData = "RobotData",
}
/**商店中商品项的类型 */
enum GoodsType {
    /**主角皮肤 */
    playerSkin = "PlayerSkin",
}
//音效文件
enum AudioClip {
    clickBtn = "clickBtn",
    win = "win",
    lose = "lose",
    BGM = "BGM1",

    boom = "boom",
    power = "power",
    assembled = "assembled",
    change = "change",
    collGood = "collGood",
    go = "GO",
    help = "help",

}
/**关卡状态 */
enum LevelState {
    inited = 1,     //关卡已初始化完成，但还未开始游戏
    playing,        //关卡进行中
    win,            //玩家已胜利
    lose,           //玩家已失败
    lobby,          //显示首页中
    playerEntering, //玩家登场动画
    playerRunning,  //玩家前进
    playerExiting,  //关卡结束，玩家离开动画
    playerDead,     //玩家失败死亡动画
}

/**游戏所处流程 */
enum DirectState {
    lobby,
    level,

    /**机器组装 */
    assembleBody,
    /**进入战斗过渡页 */
    fightLoading,
    /**战斗 */
    fighting,
}

/**后台开关配置 */
enum AdvertSwitchType {

    /**延迟显示banner的界面中，需要先点击按钮指定次数后，才会开始延迟显示banner，值：次数（例如1），或次数范围（例如1-3） */
    preClickCount = "chufajishi",

    /**是否必须点击banner才能继续游戏 */
    mustTouchBanner = "zadan",

    /**在场景值屏蔽下的用户是否显示导流页 */
    recommendEnableInGameSceneId = "guanggao_limit",

    /**首次进入游戏是否显示全导页 */
    enterGameShowRecommend = "jyxquandao_open",
    /**点击开始游戏，视频观看成功/失败/中途退出后，是否进入砸蛋页 */
    touchBannerAfterStartGameVideoComplate = "shipingzadan_limit",

    /**点开始游戏后，观看视频，值：次数 */
    showVideoOnBtnStartGame = "shipin_open",

    /**砸蛋页面banner出现的点击次数，值：次数范围/具体次数 */
    touchBannerClickCount = "cishu_limit",
    /**点开始游戏观看视频后进入砸蛋页，值：次数 */
    touchBannerAfterStartGameVideo = "zadan_limit",
    /**从结算页返回首页时是否进入砸蛋页，值：次数 */
    showZaDanBeforLobby = "xiuche_limit",
    /**结算流程中砸蛋页面出现的位置，值：0：关闭大全导之后，1：关闭小全导之后 */
    levelFinishTouchBannerShowStep = "weizhi_limit",

    /**小全导页延迟显示继续游戏按钮 */
    littlePageDelayShowBtnContinueGame = "",
    /**小全导页自动延迟显示banner，值：延迟时间，秒 */
    littlePageDelayShowBanner = "xiaodaoliu_xianshi",
    /**小全导页延迟隐藏banner，值：延迟时间，秒 */
    littlePageDelayHideBanner = "xiaodaoliu_shichang",

    /**大全导页延迟显示继续游戏按钮 */
    bigPageDelayShowBtnContinueGame = "",
    /**大全导页点击继续按钮后延迟显示banner，值：延迟时间，秒 */
    bigPageDelayShowBanner = "dadaoliu_xianshi",
    /**大全导页延迟隐藏banner，值：延迟时间，秒 */
    bigPageDelayHideBanner = "dadaoliu_shichang",

    /**关卡结束后先弹出全导页 */
    showBigPageAfterLevel = "",

    /**结算页按钮误触：自动延迟显示banner、移动按钮到正常位置，值：延迟时间，秒 */
    awardUIShowBtnForTouchBanner = "wudian_limit",
    /**成功页按钮误触：自动延迟显示banner、移动按钮到正常位置，值：延迟时间，秒 */
    winUIShowBtnForTouchBanner = "wudian_limit",
    /**失败页按钮误触：自动延迟显示banner、移动按钮到正常位置，值：延迟时间，秒 */
    loseUIShowBtnForTouchBanner = "wudian_limit",
    /**覆盖按钮的banner显示后，延迟隐藏的时间，单位：秒 */
    hideBannerForBtnContinue = "banner_sx",


}


/**********************根据实际游戏设置的枚举值，由子类定义，这里仅作示例，不会包含到导出的类中**********************/
/**通过全局对象池管理的预制件名称与对应的脚本名称，这里仅作示例，不会包含到导出的类中，需在子类中定义 */
enum LevelPrefab {
    goldIcon = "GoldIcon",
}

/**
 * 定义全部通用的枚举值
 * 
 * 注：LevelPrefab 枚举类型必须在子类中定义
 */
export class CommonEnum {
    static RecommendPrefab = RecommendPrefab;
    static RecommendItemType = RecommendItemType;
    static RecommendDrawerType = RecommendDrawerType;
    static RecommendBannerType = RecommendBannerType;
    static GameFlowStep = GameFlowStep;
    static RecommendFlowStep = RecommendFlowStep;
    static RecommendFlowConfig = RecommendFlowConfig;
    static GameFlowGlobalConfig = GameFlowGlobalConfig;
    static CtrlState = CtrlState;
    static VideoSubType = VideoSubType;
    static UrlPath = UrlPath;
    static UI = UI;
    static GameDataType = GameDataType;
    static GoodsType = GoodsType;
    static AudioClip = AudioClip;
    static LevelState = LevelState;
    static DirectState = DirectState;
    static AdvertSwitchType = AdvertSwitchType;
    static BannerTouchType = BannerTouchType;
    static BannerTouchMode = BannerTouchMode;
}
