import CommonEventType from "../Common/CommonEventType";
/**与游戏玩法相关的游戏过程中的事件 */
enum LevelEvent {
    startIndex = 100000,
    levelSceneLoadFinish,       //在首页中作为背景时所需的预制件已全部加载完毕
    resurgence,                 //观看视频成功，复活
    cancelResurgence,           //取消复活

    /**添加一个图块 */
    addTile,
    /**移除图块（被彻底炸毁） */
    removeTile,
    /**在指定位置爆炸 */
    baoZha,

    testWin,                    //测试用，直接判定为关卡胜利
    testLose,                   //测试用，直接判定为关卡失败

    choseLevelItem,             //选择关卡选项
    //皮肤商城
    clickSkinItem,              //点击皮肤项
    chooseSkin,                 //选择皮肤
    updateSkinItem,             //刷新皮肤状态

    //游戏操作
    moveJoy,                    //移动摇杆，开始移动
    stopJoy,                    //松开摇杆，停止移动
    clickSkill,                 //点击了技能按钮
    playerPosChanged,           //玩家位置发生变化
    playerUseSkill,             //玩家释放了技能
    updatePlayerSkillCool,            //更新玩家技能冷却状态

    playerEntered,              //玩家入场动画结束
    playerExited,               //玩家离场动画结束
    playerEnabled,              //玩家激活，开始游戏
    playerDeadAnimFinished,     //玩家死亡动画结束

    cameraEnabled,              //关卡主相机激活
    cameraMove,                 //关卡主相机移动


    //关卡变化
    killPlayer,                 //怪物击杀玩家
    enemyDead,                  //怪物被玩家击杀
    getCollection,              //收集到道具

    playerAddLife,              //玩家增加生命值
    playerSubLife,              //玩家减少生命值

    showLockPersonAnim,         //显示锁定人物动画
    enterSlowMotion,            //进入慢镜头状态
    rescuePerson,               //成功救援一个角色
    hideLockPersonAnim,         //隐藏锁定人物动画
    exitSlowMotion,             //退出慢镜头状态
    shakeScreen,                //碰撞到障碍物，震屏

    //关卡进度
    updateLevelTime,            //关卡经历时间变化

    addEnemyBullet,             //添加敌人攻击特效
    removeEnemyBullet,          //移除敌人攻击特效

    addPlayerBullet,            //添加玩家攻击特效
    removePlayerBullet,         //移除玩家攻击特效

    addEffect,                  //播放特效
    removeEffect,               //移除特效
    addParticle,                //添加粒子特效
    removeParticle,             //移除粒子特效
    showPlayerShadow,           //显示玩家阴影
    hidePlayerShadow,           //隐藏玩家阴影

}

/**编辑器专用的事件 */
enum EditorEvent {
    startIndex = 101000,

    addNewLevel,    //新建关卡
    createLevel,    //
    chooseLevel,    //选择要编辑的关卡
    removeLevel,    //移除关卡

    mapPosChanged,      //关卡地图位置变更
    mapLenChanged,      //关卡地图长度变更
    mapPersonChanged,   //更新可救援角色数量


    choseItem,      //选择关卡元素

    dragItemOnMap,       //拖动已存在的物体
    dragItemStart,  //开始拖动物体
    dragItemMove,   //更新正在拖动的物体坐标
    dragItemEnd,    //松开拖动的物体
}
export class EventType extends CommonEventType {
    static LevelEvent = LevelEvent;
    static EditorEvent = EditorEvent;
}
