import { CommonEnum } from "../Common/CommonEnum";

/**通过全局对象池管理的预制件名称与对应的脚本名称 */
enum LevelPrefab {
    goldIcon = "GoldIcon",

    player = "Player",
    car1 = "Car1",

    standRole = "StandRole",
    walkRole = "WalkRole",
    toiletDoor = "ToiletDoor",

    shi = "Shi",
    shiParticle = "ShiParticle",
}
/**视频广告位名称 */
enum VideoName {
    /**胜利多倍领取 */
    getGoldWin,
    /**失败多倍领取 */
    getGoldLose,
    /**观看视频获取金币 */
    getGold,
    /**试用皮肤 */
    trySkin,
    /**复活 */
    fuHuo,
    /**试用剑神模式 */
    tryJianShen,
    /**道具-磁铁 */
    ciTie,
    /**道具-护盾 */
    huDun,
    /**道具-暴走 */
    baoZou,
}

/**机器组装的区域 */
enum FitArea {
    layer1 = "layer1",
    layer2 = "layer2",
    layer3 = "layer3",
    layer4 = "layer4",
    layer5 = "layer5",

    innerBottom = "innerBottom",
    innerTop = "innerTop",
    outerBottom = "outerBottom",
    outerTop = "outerTop",
}

/**战斗角色的运行状态 */
enum FighterState {
    /**初始化完毕 */
    inited,

    /**入场动画 */
    entering,
    /**离场动画 */
    exiting,

    stand,
    moving,
    atking,
    /**被击僵直 */
    beHitting,
    /**被击退 */
    beatBack,

    /**死亡动画 */
    dead,
}

/**玩家动画剪辑名称 */
enum FighterAnim {
    /**站立待机 */
    stand = "stand",
    /**移动 */
    move = "move",
    /**攻击，仅占用枚举值，不作为实际动画名称，需根据具体技能播放对应动画 */
    atk = "atk",
    /**被击僵直 */
    beHit = "beHit",
    /**被击退 */
    beatBack = "beatBack",
    /**死亡 */
    dead = "dead",

}

/**可收集物类型 */
enum CollectionType {
    /**能量道具 */
    power,
    /**生命值道具 */
    heath,
}

export class GlobalEnum extends CommonEnum {
    static LevelPrefab = LevelPrefab;
    static VideoName = VideoName;
    static FitArea = FitArea;
    static FighterState = FighterState;
    static FighterAnim = FighterAnim;
    static CollectionType = CollectionType;
}
