// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import Tile from "../LevelScene/Script/Tile";
import GlobalPool from "../Script/Common/GlobalPool";
import yyComponent from "../Script/Common/yyComponent";
import { EventType } from "../Script/GameSpecial/GameEventType";

const { ccclass, property } = cc._decorator;

@ccclass
export default class test extends yyComponent {

    onLoad() {
        cc.director.getPhysicsManager().enabled = true;
        cc.director.getPhysicsManager().debugDrawFlags = cc.PhysicsManager.DrawBits.e_shapeBit;
        console.log(cc.director.getPhysicsManager().gravity);
        GlobalPool.createPool(this.prefab.name, this.prefab, this.prefab.name);

        this.tile.init();
        this.on(EventType.LevelEvent.addTile, this.addItem, this);
        this.on(EventType.LevelEvent.removeTile, this.onRemoveTile, this);
        this.node.on("touchstart", this.onClick, this);
    }

    @property(Tile)
    protected tile: Tile = null;

    @property(cc.Prefab)
    protected prefab: cc.Prefab = null;

    protected addItem(name, data) {
        let node = GlobalPool.get(name, data);
        this.node.addChild(node);
    }

    protected onClick(e: cc.Event.EventTouch) {
        let p = e.getLocation();
        this.emit(EventType.LevelEvent.baoZha, { p: p, radius: 50 });
    }

    protected onRemoveTile(tile) {
        GlobalPool.put(tile.node);

    }
}
