const { ccclass, property } = cc._decorator;
@ccclass
export class ItemCalendarDay extends cc.Component {
    @property(cc.Label)
    private lblDay: cc.Label = null;

    @property(cc.Sprite)
    private bgTouch: cc.Sprite = null;

    private _date: ICalendarCell = null;
    private _isSelected: boolean = false;

    protected onEnable(): void {
        this._addEvent();
    }

    protected onDisable(): void {
        this._removeEvent();
    }

    private _addEvent() {
        this.bgTouch.node.on(cc.Node.EventType.TOUCH_END, this._onTonchCell, this);
    }

    private _removeEvent() {
        this.bgTouch.node.off(cc.Node.EventType.TOUCH_END, this._onTonchCell, this);
    }

    protected _onTonchCell() {
        cc.director.getScene().emit("event_select_cell_day", this._date);
    }

    public set date(date: ICalendarCell) {
        this._date = date;
    }

    public set isSelected(isSelected: boolean) {
        this._isSelected = isSelected;
    }

    public updateView() {
        if (!this._date) {
            cc.error(`[updateView] 必须先设置date`);
            return;
        }

        if (this._date.isCurrentMonth) {
            this.lblDay.string = this._date.day.toString();
            this.lblDay.node.color = cc.Color.BLACK;
            this.bgTouch.enabled = false;

            this.bgTouch.node.active = true;
        } else {
            this.lblDay.string = "";
            this.bgTouch.node.active = false;
        }

        if (this._isSelected) {
            this.bgTouch.enabled = this._isSelected;
            this.lblDay.node.color = cc.Color.WHITE;
            this.bgTouch.enabled = true;
        }
    }
}
