const { ccclass, property } = cc._decorator;

@ccclass
export default class App extends cc.Component {

    @property(cc.Sprite)
    private sprite: cc.Sprite = null
    @property(cc.Label)
    private label0: cc.Label = null
    @property(cc.Node)
    private root: cc.Node = null
    @property(cc.Label)
    private label1: cc.Label = null


    start() {
        this.scheduleOnce(() => this.load(), 2)
    }

    private async load() {
        let now = Date.now()
        await this.loadSprite()
        this.label0.string = '加载第一个精灵资源 用时：' + (Date.now() - now) + 'ms'
        now = Date.now()
        await this.loadPrefab()
        this.label1.string = '加载第二个预制体资源 用时：' + (Date.now() - now) + 'ms'
    }

    private async loadSprite() {
        return new Promise<void>(resolve => {
            cc.resources.load('a', cc.SpriteFrame, (err, assets) => {
                if (assets) {
                    this.sprite.spriteFrame = assets as cc.SpriteFrame
                }
                resolve()
            })
        })
    }

    private async loadPrefab() {
        return new Promise<void>(resolve => {
            cc.resources.load('Item', cc.Prefab, (err, assets) => {
                if (assets) {
                    cc.instantiate(assets as cc.Prefab).parent = this.root
                }
                resolve()
            })
        })
    }
}
