﻿
var logMsg = new Array();
var curLayers = [];
function create(info) {
   logMsg.length = 0;
   curLayers.length = 0;
   const _result = getSelectedLayerItemIndex();
   const _exWdith = info.exWidth || 0;
   const _exHeight = info.exHeight || 0;
   const _layerSet = createLayerSet();
   copyChooseLayers(_layerSet, _result);
   const _sizeArray = getNumPicSize();
   _sizeArray[0] += _exWdith * 2;
   _sizeArray[1] += _exHeight * 2;
   createBgLayer(_layerSet, _sizeArray, _result.length);
   try {
      moveCopyedLayers(_sizeArray);
   } catch (error) {
      return logMsg.join(error);
   }
   return logMsg.join('\n');
}
function copyChooseLayers(layerSet, choosedLayerIDs) {
   var layer = null;
   try {
      for (var i = 0; i < choosedLayerIDs.length; i++) {
         layer = getArtLayerByItemIndex(choosedLayerIDs[i]);
         curLayers.push(layer.duplicate(layerSet));
      }
   } catch (error) {
      return logMsg.push('copy layers error:' + error);
   }
   logMsg.push('创建艺术字成功!');
}
function createLayerSet() {
   const _layerSet = app.activeDocument.layerSets.add();
   _layerSet.name = '艺术数字' + Date.now();
   return _layerSet;
}

function getNumPicSize() {
   const _widthArray = [];
   const _heightArray = [];
   var _maxWidth = 0;
   var _maxHeight = 0;
   for (var i = 0; i < curLayers.length; i++) {
      _widthArray.push(curLayers[i].bounds[2] - curLayers[i].bounds[0]);
      _heightArray.push(curLayers[i].bounds[3] - curLayers[i].bounds[1]);
   }
   _maxWidth = _widthArray.sort(function (a, b) { b - a })[0];
   _maxHeight = _heightArray.sort(function (a, b) { b - a })[0];
   return [_maxWidth, _maxHeight];
}

function createBgLayer(layerSet, sizeArray, amount) {
   logMsg.push('艺术数字参数:');
   logMsg.push('ItemWidth:' + sizeArray[0]);
   logMsg.push('ItemHeight:' + sizeArray[1]);
   logMsg.push('StartChar:0' );
   const _layer = app.activeDocument.artLayers.add();
   _layer.name = 'bg';
   _layer.move(layerSet, ElementPlacement.PLACEATEND);
   app.activeDocument.selection.select([[0, 0], [sizeArray[0] * amount, 0], [sizeArray[0] * amount, sizeArray[1]], [0, sizeArray[1]]], SelectionType.REPLACE, 0, false);
   const _color = new SolidColor();
   _color.rgb.hexValue = 'ff0000';
   app.activeDocument.selection.fill(_color);
   app.activeDocument.selection.deselect();
   _layer.opacity = 100;
   _layer.fillOpacity = 1;
   layerSet.name='ItemWidth:'+sizeArray[0]+';ItemHeigth:'+sizeArray[1];
}

function moveCopyedLayers(sizeArray) {
   const _w = sizeArray[0] / 2;
   const _h = sizeArray[1] / 2;
   for (var i = 0; i < curLayers.length; i++) {
      var _layer = curLayers[i];
      var _horiMid = (_layer.bounds[2] + _layer.bounds[0]) / 2;
      var _vertMid = (_layer.bounds[3] + _layer.bounds[1]) / 2;
      _layer.translate(((2 * i + 1) * _w - _horiMid), (_h - _vertMid));
   }
}



//取得所有被选择中的图层的 ItemIndex 。
function getSelectedLayerItemIndex() {
   var resultLayerItemIndexs = []; //存放结果的数组

   //取选中的图层：
   var ref = new ActionReference();
   var args = new ActionDescriptor();
   ref.putProperty(charIDToTypeID('Prpr'), stringIDToTypeID("targetLayers"));
   ref.putEnumerated(charIDToTypeID('Dcmn'), charIDToTypeID('Ordn'), charIDToTypeID('Trgt'));
   args.putReference(charIDToTypeID('null'), ref);
   var resultDesc = executeAction(charIDToTypeID('getd'), args, DialogModes.NO);

   //只选中了一个图层：
   if (!resultDesc.hasKey(stringIDToTypeID("targetLayers"))) {
      resultLayerItemIndexs.push(app.activeDocument.activeLayer.itemIndex);
      return resultLayerItemIndexs;
   }

   //选中了多个图层：
   var selIndexList = resultDesc.getList(stringIDToTypeID("targetLayers"));

   for (i = 0; i < selIndexList.count; ++i) {
      //ItemIndex 是从 1 开始，而 PS 内部序号是从 0 开始，所以这里需要 + 1。
      resultLayerItemIndexs.push(selIndexList.getReference(i).getIndex(charIDToTypeID('Lyr ')) + 1);
   }

   return resultLayerItemIndexs;
}
//根据图层 ItemIndex 获取图层名称
function layerItemIndexToName(ItemIndex) {
   // 判断背景图层是否存在。背景图层无论存在与否始终占有是 0  位，所如果背景图层不存在，第一个图层就是内部序号就是 1 而不是 0 ，所以要 + 1。
   backgroundIndexOffset = 1;
   try {
      if (app.activeDocument.backgroundLayer)
         backgroundIndexOffset = 0;
   }
   catch (err) { }

   var ref = new ActionReference();
   ref.putProperty(app.charIDToTypeID('Prpr'), stringIDToTypeID("name"));
   //ItemIndex 是从 1 开始，而 PS 内部序号是从 0 开始，所以这里需要 - 1。
   ref.putIndex(charIDToTypeID('Lyr '), ItemIndex - 1 + backgroundIndexOffset);
   var resultDesc = executeActionGet(ref);
   return resultDesc.getString(stringIDToTypeID("name"));
}
function getArtLayerByItemIndex(ItemIndex) {
   //要找的图层不在根目录，遍历所有图层组去寻找
   return findInLayers(app.activeDocument.layers);//遍历图层

   function findInLayers(layers) {
      for (var i = 0; i < layers.length; i++) {
         if (layers[i].typename == "LayerSet")//判断是否是图层组
         {
            //要找到图层图层就是本图层组，直接返回结果：
            if (layers[i].itemIndex == ItemIndex) {
               return layers[i];
            }
            //要找到图层不是本图层组，寻找图层组中的图层，找到就返回结果。如果没有找到这执行 catch ，如果找到多个同名图层则忽略 catch：
            try {
               var tryF = layers[i].layers.getByName(layerItemIndexToName(ItemIndex))
               if (tryF.itemIndex == ItemIndex) { return tryF; }
            }
            catch (err) {
               //要找的图层不是图层组中的图层，接着寻找本图层组中的图层组：
               var r = findInLayers(layers[i].layerSets);
               if (r != undefined) { return r; }
               continue;
            }

            //找到多个同名图层, 比较每个图层的 ItemIndex ：
            var r = findInLayers(layers[i].artLayers);

            if (r != undefined) { return r; }
         }

         else {
            // 比较图层 ItemIndex ：
            if (layers[i].itemIndex == ItemIndex) {
               return layers[i];
            }
         }
      }

   }
}