"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.unload = exports.load = exports.methods = void 0;
const fs_1 = require("fs");
const promises_1 = require("fs/promises");
let pluginsConfig = {};
let pluginsi18n = {};
let changedPlugins = [];
/**
 * @en Registration method for the main process of Extension
 * @zh 为扩展的主进程的注册方法
 */
exports.methods = {
    /**
     * @en A method that can be triggered by message
     * @zh 通过 message 触发的方法
     */
    showLog() {
        let packages = Editor.Package.getPackages();
        for (let i = 0; i < packages.length; i++) {
            const packageDetails = packages[i];
            if (packageDetails.name == "plugin-editor") {
                let packageInfo = packageDetails.info;
                console.log("plugin-editor: ", JSON.stringify(packageInfo.panels, null, 4));
            }
        }
    },
    toggle() {
        Editor.Package.disable("E:\\Coding\\3.8.0\\ccc-plugin-test\\extensions\\plugin-editor");
        setTimeout(() => {
            Editor.Package.enable("E:\\Coding\\3.8.0\\ccc-plugin-test\\extensions\\plugin-editor");
        }, 1000);
    },
    async refreshPlugins() {
        // await getPluginsConfig();
        // changedPlugins = getChangedPlugins();
        // // console.log('refresh: ', changedPlugins);
        // if (changedPlugins.length) {
        //     for (let i = 0; i < changedPlugins.length; i++) {
        //         const plugin = changedPlugins[i];
        //         if (plugin.name == "plugin-bridge") {
        //             continue;
        //         }
        //         console.log("disable plugin: ", plugin.path);
        //         Editor.Package.disable(plugin.path);
        //     }
        // }
    },
    onPluginDisable(params) {
        // for (let i = 0; i < changedPlugins.length; i++) {
        //     const plugin = changedPlugins[i];
        //     if (plugin.name == "plugin-bridge") {
        //         continue;
        //     }
        //     console.log("enable plugin: ", plugin.path);
        //     Editor.Package.enable(plugin.path);
        // }
        // changedPlugins = [];
        // getPluginsi18n();
    },
};
/**
 * @en Method Triggered on Extension Startup
 * @zh 扩展启动时触发的方法
 */
async function load() {
    // await getPluginsConfig();
    // await getPluginsi18n();
}
exports.load = load;
/**
 * @en Method triggered when uninstalling the extension
 * @zh 卸载扩展时触发的方法
 */
function unload() { }
exports.unload = unload;
function getChangedPlugins() {
    let plugins = [];
    let info = Editor.Package.getPackages();
    // console.log(JSON.stringify(info));
    for (const key in pluginsConfig) {
        if (Object.prototype.hasOwnProperty.call(pluginsConfig, key)) {
            const config = pluginsConfig[key].config;
            for (let j = 0; j < info.length; j++) {
                const packageInfo = info[j].info;
                // if (packageInfo.name == "plugin-editor") {
                //     console.log(packageInfo.panels);
                // }
                if (packageInfo.name == config.name) {
                    // console.log(packageInfo.name, packageInfo, config);
                    if (isPluginDifferent(packageInfo, config) || isi18nChange(info[j])) {
                        plugins.push(info[j]);
                    }
                }
            }
        }
    }
    return plugins;
}
function isPluginDifferent(packageInfo, config) {
    if (packageInfo.description != config.description) {
        console.log("config change: description");
        return true;
    }
    // if (packageInfo.panels && !config.panels) {
    //     console.log("config change: panels");
    //     return true;
    // };
    // if (!packageInfo.panels && config.panels) {
    //     console.log("config change: panels");
    //     return true
    // };
    if (isExistDifferent(packageInfo.panels, config.panels)) {
        let info = Editor.Package.getPackages();
        for (let i = 0; i < info.length; i++) {
            const element = info[i];
            if (element.name == "plugin-editor") {
                console.log("plugin-editor: ", JSON.stringify(element, null, 4));
            }
        }
        console.log("config change: panels 1", packageInfo.panels, config.panels);
        return true;
    }
    if (packageInfo.panels && config.panels) {
        if (isObjectKeysDifferent(packageInfo.panels, config.panels)) {
            console.log("config change: panels 2");
            return true;
        }
        for (const key in packageInfo.panels) {
            if (isObjectChildDiffrent(packageInfo.panels[key], config.panels[key], ["title", "type", "size"])) {
                console.log("config change: panels 3");
                return true;
            }
        }
    }
    // if (packageInfo.panels) {
    //     for (const panel in packageInfo.panels) {
    //         if (Object.prototype.hasOwnProperty.call(config.panels, panel)) {
    //             if (packageInfo.panels[panel].title != config.panels[panel].title) {
    //                 console.log("config change: panels title");
    //                 return true;
    //             }
    //             if (packageInfo.panels[panel].type != config.panels[panel].type) {
    //                 console.log("config change: panels type");
    //                 return true;
    //             }
    //             if (packageInfo.panels[panel].size["min-width"] != config.panels[panel].size["min-width"]) {
    //                 console.log("config change: panels min-width");
    //                 return true;
    //             }
    //             if (packageInfo.panels[panel].size["min-height"] != config.panels[panel].size["min-height"]) {
    //                 console.log("config change: panels min-height");
    //                 return true;
    //             }
    //             if (packageInfo.panels[panel].size["width"] != config.panels[panel].size["width"]) {
    //                 console.log("config change: panels width");
    //                 return true;
    //             }
    //             if (packageInfo.panels[panel].size["height"] != config.panels[panel].size["height"]) {
    //                 console.log("config change: panels height");
    //                 return true;
    //             }
    //         }
    //     }
    // }
    // if (packageInfo.contributions && !config.contributions) {
    //     console.log("config change: contributions");
    //     return true;
    // };
    // if (!packageInfo.contributions && config.contributions) {
    //     console.log("config change: contributions");
    //     return true;
    // };
    if (isExistDifferent(packageInfo.contributions, config.contributions)) {
        console.log("config change: contributions");
        return true;
    }
    if (packageInfo.contributions && config.contributions) {
        if (isObjectKeysDifferent(packageInfo.contributions, config.contributions)) {
            console.log("config change: panels");
            return true;
        }
        // if (packageInfo.contributions.menu && !config.contributions.menu) {
        //     console.log("config change: contributions menu");
        //     return true;
        // };
        // if (!packageInfo.contributions.menu && config.contributions.menu) {
        //     console.log("config change: contributions menu");
        //     return true;
        // };
        if (isExistDifferent(packageInfo.contributions.menu, config.contributions.menu)) {
            console.log("config change: contributions.menu");
            return true;
        }
        if (packageInfo.contributions.menu && config.contributions.menu) {
            if (packageInfo.contributions.menu.length != config.contributions.menu.length) {
                console.log("config change: contributions.menu");
                return true;
            }
            for (let i = 0; i < packageInfo.contributions.menu.length; i++) {
                const menu = packageInfo.contributions.menu[i];
                if (menu.path != config.contributions.menu[i].path) {
                    console.log("config change: contributions menu path");
                    return true;
                }
                if (menu.label != config.contributions.menu[i].label) {
                    console.log("config change: contributions menu label");
                    return true;
                }
                if (menu.message && menu.message.name != config.contributions.menu[i].message) {
                    console.log("config change: contributions menu message");
                    return true;
                }
            }
        }
        // if (packageInfo.contributions.messages && !config.contributions.messages) {
        //     console.log("config change: contributions messages");
        //     return true;
        // };
        // if (!packageInfo.contributions.messages && config.contributions.messages) {
        //     console.log("config change: contributions messages");
        //     return true;
        // };
        if (isExistDifferent(packageInfo.contributions.messages, config.contributions.messages)) {
            console.log("config change: contributions.messages");
            return true;
        }
        if (packageInfo.contributions.messages && config.contributions.messages) {
            if (isValueDifferent(packageInfo.contributions.messages, config.contributions.messages)) {
                console.log("config change: contributions.messages", packageInfo.contributions.messages, config.contributions.messages);
                return true;
            }
            // if (!isArraySame(Object.keys(packageInfo.contributions.messages), Object.keys(config.contributions.messages))) {
            //     return true;
            // }
            // for (const k in packageInfo.contributions.messages) {
            //     if (Object.prototype.hasOwnProperty.call(packageInfo.contributions.messages, k)) {
            //         const packageMessage = packageInfo.contributions.messages[k];
            //         if (Object.prototype.hasOwnProperty.call(config.contributions.messages, k)) {
            //             const configMessage = config.contributions.messages[k];
            //             if (packageMessage.methods && !configMessage.methods) {
            //                 console.log("config change: contributions messages methods");
            //                 return true;
            //             };
            //             if (!packageMessage.methods && configMessage.methods) {
            //                 console.log("config change: contributions messages methods");
            //                 return true;
            //             };
            //             if (packageMessage.methods) {
            //                 if (!isArraySame(packageMessage.methods, configMessage.methods)) {
            //                     console.log("config change: contributions messages methods");
            //                     return true;
            //                 }
            //             }
            //         }
            //     }
            // }
        }
    }
}
async function getPluginsConfig() {
    const files = await (0, promises_1.readdir)(Editor.Project.path + "/extensions");
    for (let i = 0; i < files.length; i++) {
        const file = files[i];
        const stats = await (0, promises_1.stat)(Editor.Project.path + "/extensions/" + file);
        if (stats.isDirectory() && (0, fs_1.existsSync)(Editor.Project.path + "/extensions/" + file + "/package.json")) {
            // let config = require(Editor.Project.path + "/extensions/" + file + "/package.json");
            let configFile = (0, fs_1.readFileSync)(Editor.Project.path + "/extensions/" + file + "/package.json", "utf-8");
            let config = JSON.parse(configFile);
            pluginsConfig[config.name] = { path: Editor.Project.path + "/extensions/" + file, config: config };
        }
    }
    // console.log("getPluginsConfig: ", pluginsConfig);
}
async function getPluginsi18n() {
    const files = await (0, promises_1.readdir)(Editor.Project.path + "/extensions");
    for (let i = 0; i < files.length; i++) {
        const file = files[i];
        const stats = await (0, promises_1.stat)(Editor.Project.path + "/extensions/" + file);
        if (stats.isDirectory() && (0, fs_1.existsSync)(Editor.Project.path + "/extensions/" + file + "/package.json")) {
            // let config = require(Editor.Project.path + "/extensions/" + file + "/package.json");
            let configFile = (0, fs_1.readFileSync)(Editor.Project.path + "/extensions/" + file + "/package.json", "utf-8");
            let config = JSON.parse(configFile);
            pluginsi18n[config.name] = {};
            if ((0, fs_1.existsSync)(Editor.Project.path + "/extensions/" + file + "/i18n/en.js")) {
                let en = (0, fs_1.readFileSync)(Editor.Project.path + "/extensions/" + file + "/i18n/" + "en.js", "utf-8");
                pluginsi18n[config.name].en = en;
            }
            if ((0, fs_1.existsSync)(Editor.Project.path + "/extensions/" + file + "/i18n/zh.js")) {
                let zh = (0, fs_1.readFileSync)(Editor.Project.path + "/extensions/" + file + "/i18n/" + "zh.js", "utf-8");
                pluginsi18n[config.name].zh = zh;
            }
        }
    }
    // console.log("getPluginsi18n: ", pluginsi18n);
}
function isi18nChange(packageDetails) {
    if ((0, fs_1.existsSync)(packageDetails.path + "/i18n/en.js")) {
        let en = (0, fs_1.readFileSync)(packageDetails.path + "/i18n/en.js", "utf-8");
        if (pluginsi18n[packageDetails.name].en != en) {
            return true;
        }
    }
    if ((0, fs_1.existsSync)(packageDetails.path + "/i18n/zh.js")) {
        let zh = (0, fs_1.readFileSync)(packageDetails.path + "/i18n/zh.js", "utf-8");
        if (pluginsi18n[packageDetails.name].zh != zh) {
            return true;
        }
    }
}
function isArraySame(a, b) {
    if (a.length != b.length) {
        return false;
    }
    for (let i = 0; i < a.length; i++) {
        if (a[i] != b[i]) {
            return false;
        }
    }
    return true;
}
function isExistDifferent(a, b) {
    if (a == undefined && b != undefined) {
        return true;
    }
    if (a != undefined && b == undefined) {
        return true;
    }
    if (a == null && b != null) {
        return true;
    }
    if (a != null && b == null) {
        return true;
    }
}
function isObjectKeysDifferent(a, b) {
    if (Object.keys(a).length != Object.keys(b).length) {
        return true;
    }
    for (const key in a) {
        if (!b.hasOwnProperty(key)) {
            return true;
        }
    }
    for (const key in b) {
        if (!a.hasOwnProperty(key)) {
            return true;
        }
    }
}
function isObjectChildDiffrent(a, b, keys) {
    for (const key of keys) {
        if (isValueDifferent(a[key], b[key])) {
            return true;
        }
    }
}
function isValueDifferent(a, b) {
    if (typeof a !== typeof b)
        return true;
    if (typeof a === 'object') {
        if (a === null && b !== null)
            return true;
        if (a !== null && b === null)
            return true;
        if (a === null && b === null) {
            return false;
        }
        if (isObjectKeysDifferent(a, b)) {
            return true;
        }
        for (const key in a) {
            if (isValueDifferent(a[key], b[key])) {
                console.log("isValueDifferent: ", a[key], b[key], isValueDifferent(a[key], b[key]));
                return true;
            }
        }
    }
    else if (typeof a == "number" || typeof a === 'string' || typeof a === 'boolean') {
        if (a != b) {
            return true;
        }
    }
    else {
        if (a === undefined && b !== undefined)
            return true;
        if (a !== undefined && b === undefined)
            return true;
    }
    return false;
}
//# sourceMappingURL=data:application/json;base64,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