import { _decorator, Component, Node, Texture2D, gfx, SpriteFrame, find, Sprite } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('NewComponent_001')
export class NewComponent_001 extends Component {
    start() {
        this.readPixels(0,0,500,500,find('Canvas/Sprite').getComponent(Sprite).spriteFrame.texture)
    }
    public readPixels(x = 0, y = 0, width: number, height: number, tex: any) {
        width = width;
        height = height;
        const gfxTexture = tex.getGFXTexture();
        if (!gfxTexture) {
            return null;
        }
        const needSize = 4 * width * height;
        let buffer = new Uint8Array(needSize);


        const gfxDevice = tex._getGFXDevice();

        const bufferViews: ArrayBufferView[] = [];
        const regions: gfx.BufferTextureCopy[] = [];

        const region0 = new gfx.BufferTextureCopy();
        region0.texOffset.x = x;
        region0.texOffset.y = y;
        region0.texExtent.width = width;
        region0.texExtent.height = height;
        regions.push(region0);

        bufferViews.push(buffer);
        gfxDevice?.copyTextureToBuffers(gfxTexture, bufferViews, regions);
        // return buffer;
        let dstTexture = new Texture2D();
        dstTexture.reset({
            width: 500,
            height: 500,
            format: Texture2D.PixelFormat.RGBA8888,
            mipmapLevel: 0
        });
        dstTexture.uploadData(buffer);
        let sp = new SpriteFrame();
        sp.texture = dstTexture;
        find('Canvas/test').getComponent(Sprite).spriteFrame = sp;
    }
    update(deltaTime: number) {

    }
}

