import { sp } from "cc";

//临时修复spine渲染可能错乱的问题,后续引擎版本更新后若修复了此问题则移除此文件

//@ts-ignore
const updateRenderData = sp.Skeleton.prototype.updateRenderData;
//@ts-ignore
sp.Skeleton.prototype.updateRenderData = function () {
    const floatStride = (this.useTint ? 28 : 24) / Float32Array.BYTES_PER_ELEMENT;
    let model = updateRenderData.call(this);
    let rd = this.renderData;
    let vc = model.vCount;
    let ic = model.iCount;
    if (!rd || vc < 1 || ic < 1) return model;

    if (rd.vertexCount !== vc || rd.indexCount !== ic) {
        rd.resize(vc, ic);
        rd.indices = new Uint16Array(ic);
        if (!this.isAnimationCached()) {
            this._vLength = vc * Float32Array.BYTES_PER_ELEMENT * floatStride;
            this._vBuffer = new Uint8Array(rd.chunk.vb.buffer, rd.chunk.vb.byteOffset, this._vLength);
            this._iLength = Uint16Array.BYTES_PER_ELEMENT * ic;
            this._iBuffer = new Uint8Array(rd.indices.buffer);
        }
    }
    return model;
}