import { VirtualItem } from "../VirtualItem";

const { ccclass, property } = cc._decorator;

@ccclass('ChatIItem')
export class ChatIItem extends VirtualItem {
    @property(cc.Label)
    text: cc.Label;

    @property(cc.Sprite)
    emoji: cc.Sprite;

    @property(cc.Node)
    bubble: cc.Node;

    @property()
    paddingLeft = 10;

    @property()
    paddingRight = 10;

    @property()
    paddingTop = 10;

    @property()
    paddingBottom = 10;

    maxWidth = 300;

    setData(index: number, data: { self: boolean, emoji: string, text: string }) {
        if (data.text) {
            this.text.overflow = cc.Label.Overflow.NONE;
            this.text.string = data.text;
            if (data.self) {
                this.text.horizontalAlign = cc.Label.HorizontalAlign.RIGHT;
            }
            this.text._forceUpdateRenderData(true);
            if (this.text.node.width > this.maxWidth) {
                this.text.horizontalAlign = cc.Label.HorizontalAlign.LEFT;
                this.text.overflow = cc.Label.Overflow.RESIZE_HEIGHT;
                this.text.node.width = this.maxWidth;
                this.text._forceUpdateRenderData(true);
            }
            this.bubble.width = this.text.node.width + this.paddingLeft + this.paddingRight;
            this.bubble.height = this.text.node.height + this.paddingTop + this.paddingBottom;
            if (data.self) {
                this.text.node.x = -this.paddingRight;
            } else {
                this.text.node.x = this.paddingLeft;
            }
            this.text.node.y = -this.paddingTop;
        }
    }
}


