import { VirtualList } from '../VirtualList';
import { ChatIItem } from './ChatIItem';
const { ccclass, property } = cc._decorator;

@ccclass('ChatView')
export class ChatView extends cc.Component {
    @property(VirtualList)
    list: VirtualList = null!;

    @property(cc.Button)
    btnSend: cc.Button = null!;

    @property(cc.Button)
    btnEmoji: cc.Button = null!;

    @property(cc.EditBox)
    input: cc.EditBox = null!;

    data: { self: boolean, emoji: string, text: string }[] = [];

    start() {
        this.list.itemRender = this.onItemRender.bind(this);
        this.list.getItemResIndex = this.getItemResIndex.bind(this);
        this.btnSend.node.on("click", this.onSendClick, this);
        this.btnEmoji.node.on("click", this.onClickEmoji, this);
    }

    private onItemRender(index: number, node: cc.Node) {
        let chatInfo = this.data[index];
        node.getComponent(ChatIItem).setData(index, chatInfo);
    }

    private getItemResIndex(index: number) {
        let chatInfo = this.data[index];
        if (chatInfo.self) {
            return chatInfo.emoji ? 2 : 0;
        } else {
            return chatInfo.emoji ? 3 : 1;
        }
    }

    private isSelf = true;
    private onSendClick() {
        let text = this.input.string;
        if (!text) {
            return;
        }
        this.data.push({ self: this.isSelf, text: text, emoji: "" });
        this.list.setData(this.data);
        this.list.scrollToBottom();
        this.input.string = "";
        this.isSelf = !this.isSelf;
    }

    private onClickEmoji() {
        this.data.push({ self: this.isSelf, text: "", emoji: "emoji" });
        this.list.setData(this.data);
        this.list.scrollToBottom();
        this.isSelf = !this.isSelf;
    }
}


