import { VirtualList } from './VirtualList';
const { ccclass, property } = cc._decorator;

@ccclass('main')
export class main extends cc.Component {

    @property(VirtualList)
    list: VirtualList = null!;
    data: { type: number }[] = [];

    start() {
        this.list.itemRender = this.onItemRender.bind(this);
        this.list.getItemResIndex = this.getItemResIndex.bind(this);
        this.list.onItemClick = this.onItemClick.bind(this);
        for (let i = 0; i < 500; i++) {
            this.data.push({ type: Math.floor(Math.random() * this.list.itemPrefabs.length) })
        }
        this.list.setData(this.data);
    }

    private onItemRender(index: number, node: cc.Node) {
        node.getChildByName("Label").getComponent(cc.Label).string = index.toString();
    }

    private getItemResIndex(index: number) {
        return this.data[index].type;
    }

    private onItemClick(index: number, node: Node) {
        console.log("点击下标:" + index);
    }
}


