"use strict";
cc._RF.push(module, '0f6a81C2TBD0ptqoatdYbwm', 'VirtualList');
// scrollview/VirtualList.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualList = void 0;
var VirtualItem_1 = require("./VirtualItem");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var VirtualList = /** @class */ (function (_super) {
    __extends(VirtualList, _super);
    function VirtualList() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.scrollView = null;
        _this.content = null;
        _this.itemPrefabs = [];
        /**是否垂直滑动 */
        _this.vertical = true;
        /**是否水平滑动 */
        _this.horizontal = false;
        _this.layoutType = cc.Layout.Type.VERTICAL;
        _this.paddingLeft = 0;
        _this.paddingRight = 0;
        _this.paddingTop = 0;
        _this.paddingBottom = 0;
        _this.spacingX = 0;
        _this.spacingY = 0;
        _this.verticalDirection = cc.Layout.VerticalDirection.TOP_TO_BOTTOM;
        _this.horizontalDirection = cc.Layout.HorizontalDirection.LEFT_TO_RIGHT;
        _this.autoSizeItem = false;
        /**
         * 自定义渲染绑定函数 item可以不用挂载组件
         * @param index 数据索引
         * @param node 当前渲染的节点
         */
        _this.itemRender = function () { };
        /**
         * 外部绑定的查找 index 的方法  默认0
         */
        _this.getItemResIndex = function () { return 0; };
        _this.dataList = [];
        _this.itemMap = new Map();
        _this.itemPool = new Map();
        _this.itemPositions = [];
        /**item 与预制体不一致时记录下来 */
        _this.itemSizes = [];
        _this.columnCount = 1;
        return _this;
    }
    VirtualList.prototype.onLoad = function () {
        this.content = this.scrollView.content;
        if (!this.vertical && !this.horizontal) {
            console.error("请设置水平或竖直滑动");
        }
        this.scrollView.vertical = this.vertical;
        this.scrollView.horizontal = this.horizontal;
        this.scrollView.node.on('scrolling', this.onScrolling, this);
        this.initAnchor();
    };
    /**初始化content 锚点  也可以在属性面板手动设置 */
    VirtualList.prototype.initAnchor = function () {
        if (this.vertical) {
            this.content.anchorX = 0.5;
            if (this.verticalDirection == cc.Layout.VerticalDirection.TOP_TO_BOTTOM) {
                this.content.anchorY = 1;
            }
            else {
                this.content.anchorY = 0;
            }
        }
        else if (this.horizontal) {
            this.content.anchorY = 0.5;
            if (this.horizontalDirection == cc.Layout.HorizontalDirection.LEFT_TO_RIGHT) {
                this.content.anchorX = 0;
            }
            else {
                this.content.anchorX = 1;
            }
        }
    };
    VirtualList.prototype.onDestroy = function () {
        this.dataList = null;
        this.itemMap.forEach(function (item) {
            item.destroy();
        });
        this.itemMap.clear();
        this.itemPool.forEach(function (pool) {
            pool.forEach(function (item) {
                item.destroy();
            });
        });
        this.itemPool.clear();
    };
    VirtualList.prototype.getItemPrefabIndex = function (index) {
        var _a;
        return ((_a = this.getItemResIndex) === null || _a === void 0 ? void 0 : _a.call(this, index)) || 0;
    };
    /**通过数据下标获取对应预制体*/
    VirtualList.prototype.getItemPrefabByIndex = function (index) {
        var prefabIndex = this.getItemPrefabIndex(index);
        var prefab = this.itemPrefabs[prefabIndex];
        if (!prefab) {
            console.error("VirtualList 预制体数组中没有对应索引的预制体");
        }
        return prefab;
    };
    /**
     * 设置数据
     */
    VirtualList.prototype.setData = function (dataList) {
        this.recycle();
        this.dataList = dataList;
        if (this.layoutType == cc.Layout.Type.GRID) {
            this.calcGridLayout();
        }
        else if (this.layoutType == cc.Layout.Type.VERTICAL) {
            if (this.autoSizeItem) {
                this.calculateAutoItem();
            }
            else {
                this.calcVerticalLayout();
            }
        }
        else if (this.layoutType == cc.Layout.Type.HORIZONTAL) {
            this.calcHorizontalLayout();
        }
        this.onScrolling();
    };
    /**
     * 网格布局计算
     */
    VirtualList.prototype.calcGridLayout = function () {
        var prefab = this.itemPrefabs[0];
        this.itemPositions = [];
        var contentWidth = this.content.width;
        var contentHeight = this.content.height;
        var itemW = prefab.data.width;
        var itemH = prefab.data.height;
        if (this.vertical) {
            this.columnCount = Math.max(1, Math.floor((contentWidth - this.paddingLeft - this.paddingRight + this.spacingX) / (itemW + this.spacingX)));
            var totalRows = Math.ceil(this.dataList.length / this.columnCount);
            var totalHeight = totalRows * itemH + (totalRows - 1) * this.spacingY + this.paddingTop + this.paddingBottom;
            this.content.height = Math.max(totalHeight, this.scrollView.node.height);
            var dir = this.verticalDirection == cc.Layout.VerticalDirection.TOP_TO_BOTTOM ? -1 : 1;
            for (var i = 0; i < this.dataList.length; i++) {
                var row = Math.floor(i / this.columnCount);
                var col = i % this.columnCount;
                var x = -contentWidth / 2 + this.paddingLeft + itemW / 2 + col * (itemW + this.spacingX);
                var y = -this.paddingTop - itemH / 2 - row * (itemH + this.spacingY);
                y *= -dir;
                this.itemPositions.push(new cc.Vec2(x, y));
            }
        }
        else {
            var rowCount = Math.max(1, Math.floor((contentHeight - this.paddingTop - this.paddingBottom + this.spacingY) / (itemH + this.spacingY)));
            var totalCols = Math.ceil(this.dataList.length / rowCount);
            var totalWidth = totalCols * itemW + (totalCols - 1) * this.spacingX + this.paddingLeft + this.paddingRight;
            this.content.width = Math.max(totalWidth, this.scrollView.node.width);
            var dir = this.horizontalDirection === cc.Layout.HorizontalDirection.LEFT_TO_RIGHT ? 1 : -1;
            for (var i = 0; i < this.dataList.length; i++) {
                var col = Math.floor(i / rowCount);
                var row = i % rowCount;
                var x = dir * (this.paddingLeft + itemW / 2 + col * (itemW + this.spacingX));
                var y = this.content.height / 2 + -this.paddingTop - itemH / 2 - row * (itemH + this.spacingY);
                this.itemPositions.push(new cc.Vec2(x, y));
            }
        }
    };
    /**垂直布局计算 */
    VirtualList.prototype.calcVerticalLayout = function () {
        this.itemPositions = [];
        var y = this.paddingTop;
        var lastY = 0;
        var dir = this.verticalDirection == cc.Layout.VerticalDirection.TOP_TO_BOTTOM ? -1 : 1;
        for (var i = 0; i < this.dataList.length; i++) {
            var prefab = this.getItemPrefabByIndex(i);
            var height = prefab.data.height;
            y += lastY / 2 + height / 2 + this.spacingY;
            lastY = height;
            this.itemPositions.push(new cc.Vec2(0, y * dir));
        }
        y += lastY / 2 + this.paddingBottom;
        this.content.height = Math.max(y, this.scrollView.node.height);
    };
    VirtualList.prototype.calcHorizontalLayout = function () {
        this.itemPositions = [];
        var x = this.paddingLeft;
        var lastX = 0;
        for (var i = 0; i < this.dataList.length; i++) {
            var prefab = this.getItemPrefabByIndex(i);
            ;
            var width = prefab.data.width;
            x += lastX / 2 + width / 2 + this.spacingX;
            lastX = width;
            var dir = this.horizontalDirection == cc.Layout.HorizontalDirection.LEFT_TO_RIGHT ? 1 : -1;
            this.itemPositions.push(new cc.Vec2(x * dir, 0));
        }
        x += lastX / 2 + this.paddingRight;
        this.content.width = Math.max(x, this.scrollView.node.width);
    };
    /**
     * 滚动时动态创建/回收节点
     */
    VirtualList.prototype.onScrolling = function () {
        var scrollVieWidth = this.scrollView.node.width;
        var scrollVieHeight = this.scrollView.node.height;
        var contentX = this.content.x;
        var contentY = this.content.y;
        //视图外缓冲区可见大小   可优化点,判断滚动方向, 如往下滚动时,当前item在滚动视图下方时且不在可视区,那么他后面的item也不再,可以直接跳出循环
        var buffer = 200;
        for (var i = 0; i < this.dataList.length; i++) {
            var itemWidth = 0;
            var itemHeight = 0;
            if (this.autoSizeItem) {
                itemWidth = this.itemSizes[i].width;
                itemHeight = this.itemSizes[i].height;
            }
            else {
                var item = this.getItemPrefabByIndex(i);
                itemWidth = item.data.width;
                itemHeight = item.data.height;
            }
            var pos = this.itemPositions[i];
            var localX = pos.x + contentX;
            var localY = pos.y + contentY;
            var outView = localX + itemWidth / 2 + buffer < -scrollVieWidth / 2
                || localX - itemWidth / 2 - buffer > scrollVieWidth / 2
                || localY + itemHeight / 2 + buffer < -scrollVieHeight / 2
                || localY - itemHeight / 2 - buffer > scrollVieHeight / 2;
            if (outView) {
                this.recycleItemByIndex(i);
            }
            else {
                this.updateItemByIndex(i);
            }
        }
    };
    VirtualList.prototype.updateItemByIndex = function (index) {
        var _a;
        var node = this.itemMap.get(index);
        if (!node) {
            //在列表的不需要更新
            var type = this.getItemResIndex(index);
            if (!this.itemPool.has(type))
                this.itemPool.set(type, []);
            var pool = this.itemPool.get(type);
            node = pool.length > 0 ? pool.pop() : this.instantiateByType(index);
            node.setParent(this.content);
            var pos = this.itemPositions[index];
            node.setPosition(pos);
            this.itemMap.set(index, node);
            (_a = this.itemRender) === null || _a === void 0 ? void 0 : _a.call(this, index, node);
        }
    };
    VirtualList.prototype.recycleItemByIndex = function (index) {
        var _a;
        var node = this.itemMap.get(index);
        if (!node) {
            return;
        }
        var type = ((_a = this.getItemResIndex) === null || _a === void 0 ? void 0 : _a.call(this, index)) || 0;
        this.itemMap.delete(index);
        node.removeFromParent();
        if (!this.itemPool.has(type))
            this.itemPool.set(type, []);
        this.itemPool.get(type).push(node);
    };
    VirtualList.prototype.recycle = function () {
        var _this = this;
        this.itemMap.forEach(function (node, index) {
            _this.recycleItemByIndex(index);
        });
        this.itemMap.clear();
        this.itemPositions = [];
        this.itemSizes = [];
        this.itemPool.forEach(function (pool) { return pool.forEach(function (n) { return n.removeFromParent(); }); });
    };
    VirtualList.prototype.instantiateByType = function (index) {
        var _a;
        var prefab = this.itemPrefabs[((_a = this.getItemResIndex) === null || _a === void 0 ? void 0 : _a.call(this, index)) || 0];
        var node = cc.instantiate(prefab);
        if (this.onItemClick) {
            node.on("click", this.clickItem, this);
        }
        return node;
    };
    /**
     * 获取指定 index 对应的 item 节点（在屏幕内时返回，不可见返回 null）
     */
    VirtualList.prototype.getItemNode = function (index) {
        var _a;
        return (_a = this.itemMap.get(index)) !== null && _a !== void 0 ? _a : null;
    };
    VirtualList.prototype.clickItem = function (button) {
        var _this = this;
        this.itemMap.forEach(function (node, index) {
            if (button.node == node) {
                _this.onItemClick(index, node);
            }
        });
    };
    /**
 * 滚动到指定 index 的 item（垂直/水平/网格皆适配）
 * @param index item 下标
 * @param duration 滚动动画时长（默认 0.3 秒）
 */
    VirtualList.prototype.scrollToIndex = function (index, duration) {
        if (duration === void 0) { duration = 0.3; }
        if (index < 0 || index >= this.itemPositions.length)
            return;
        var targetPos = this.itemPositions[index];
        var viewSize = this.scrollView.node;
        var contentSize = this.content;
        var offset;
        if (this.vertical) {
            var contentHeight = contentSize.height;
            var viewHeight = viewSize.height;
            var anchorOffset = contentHeight * (1 - contentSize.anchorY);
            var itemY = -targetPos.y + anchorOffset;
            // 中心偏移
            var scrollY = itemY - viewHeight / 2;
            var maxScrollY = contentHeight - viewHeight;
            var clampedY = Math.max(0, Math.min(scrollY, maxScrollY));
            offset = new cc.Vec2(0, clampedY);
        }
        else if (this.horizontal) {
            var contentWidth = contentSize.width;
            var viewWidth = viewSize.width;
            var anchorOffset = contentWidth * contentSize.anchorX;
            var itemX = targetPos.x + anchorOffset;
            var scrollX = itemX - viewWidth / 2;
            var maxScrollX = contentWidth - viewWidth;
            var clampedX = Math.max(0, Math.min(scrollX, maxScrollX));
            offset = new cc.Vec2(clampedX, 0);
        }
        this.scrollView.scrollToOffset(offset, duration);
    };
    VirtualList.prototype.calculateAutoItem = function () {
        this.itemPositions = [];
        var y = 0 + this.paddingTop;
        var lastY = 0;
        var dir = this.verticalDirection == cc.Layout.VerticalDirection.TOP_TO_BOTTOM ? -1 : 1;
        //创建item加入场景=>设置item数据,更新itemcc.Layout 回收
        for (var i = 0; i < this.dataList.length; i++) {
            var prefabIndex = this.getItemPrefabIndex(i);
            var node = null;
            var pool = this.itemPool.get(prefabIndex);
            if (!pool) {
                pool = [];
                this.itemPool.set(prefabIndex, pool);
            }
            if (pool.length) {
                node = pool.pop();
            }
            else {
                var prefab = this.getItemPrefabByIndex(i);
                node = cc.instantiate(prefab);
            }
            this.scrollView.node.parent.addChild(node);
            //手动更新渲染组件 获取大小 
            var comp = node.getComponent(VirtualItem_1.VirtualItem);
            if (!comp) {
                throw new Error("不固定大小的预制体请挂载组件 继承VirtualItem");
                return;
            }
            comp.setData(i, this.dataList[i]);
            node.getComponentsInChildren(cc.Label).forEach(function (e) {
                //@ts-ignore
                e._forceUpdateRenderData(true);
            });
            node.getComponentsInChildren(cc.Layout).forEach(function (e) {
                e.updateLayout();
            });
            node.getComponent(cc.Layout).updateLayout();
            var height = node.height;
            var width = node.width;
            this.itemSizes.push({ width: width, height: height });
            y += lastY / 2 + height / 2 + this.spacingY;
            lastY = height;
            this.itemPositions.push(new cc.Vec2(0, y * dir));
            node.removeFromParent();
            pool.push(node);
        }
        y += lastY / 2 + this.paddingBottom;
        this.content.height = Math.max(y, this.scrollView.node.height);
    };
    VirtualList.prototype.scrollToTop = function (timeInSconds) {
        this.scrollView.stopAutoScroll();
        this.scrollView.scrollToTop(timeInSconds);
        if (!timeInSconds) {
            this.onScrolling();
        }
    };
    VirtualList.prototype.scrollToBottom = function (timeInSconds) {
        this.scrollView.stopAutoScroll();
        this.scrollView.scrollToBottom(timeInSconds);
        if (!timeInSconds) {
            this.onScrolling();
        }
    };
    VirtualList.prototype.scrollToLeft = function (timeInSconds) {
        this.scrollView.stopAutoScroll();
        this.scrollView.scrollToLeft(timeInSconds);
        if (!timeInSconds) {
            this.onScrolling();
        }
    };
    VirtualList.prototype.scrollToRight = function (timeInSconds) {
        this.scrollView.stopAutoScroll();
        this.scrollView.scrollToRight(timeInSconds);
        if (!timeInSconds) {
            this.onScrolling();
        }
    };
    __decorate([
        property(cc.ScrollView)
    ], VirtualList.prototype, "scrollView", void 0);
    __decorate([
        property([cc.Prefab])
    ], VirtualList.prototype, "itemPrefabs", void 0);
    __decorate([
        property(Boolean)
    ], VirtualList.prototype, "vertical", void 0);
    __decorate([
        property(Boolean)
    ], VirtualList.prototype, "horizontal", void 0);
    __decorate([
        property({ type: cc.Layout.Type, tooltip: "布局类型  竖直,水平,网格 " })
    ], VirtualList.prototype, "layoutType", void 0);
    __decorate([
        property()
    ], VirtualList.prototype, "paddingLeft", void 0);
    __decorate([
        property()
    ], VirtualList.prototype, "paddingRight", void 0);
    __decorate([
        property()
    ], VirtualList.prototype, "paddingTop", void 0);
    __decorate([
        property()
    ], VirtualList.prototype, "paddingBottom", void 0);
    __decorate([
        property()
    ], VirtualList.prototype, "spacingX", void 0);
    __decorate([
        property()
    ], VirtualList.prototype, "spacingY", void 0);
    __decorate([
        property({
            type: cc.Layout.VerticalDirection,
            visible: function () {
                return this.vertical;
            }
        })
    ], VirtualList.prototype, "verticalDirection", void 0);
    __decorate([
        property({
            type: cc.Layout.HorizontalDirection,
            visible: function () {
                return this.horizontal;
            }
        })
    ], VirtualList.prototype, "horizontalDirection", void 0);
    __decorate([
        property({
            type: Boolean, tooltip: "item请继承VirtualItem， 暂时只实现竖直非网格排序,其他排序好像没有场景使用,自动适配item大小,如聊天item",
            visible: function () {
                return this.vertical;
            }
        })
    ], VirtualList.prototype, "autoSizeItem", void 0);
    VirtualList = __decorate([
        ccclass('VirtualList')
    ], VirtualList);
    return VirtualList;
}(cc.Component));
exports.VirtualList = VirtualList;

cc._RF.pop();