
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scrollview/VirtualList.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '0f6a81C2TBD0ptqoatdYbwm', 'VirtualList');
// scrollview/VirtualList.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualList = void 0;
var VirtualItem_1 = require("./VirtualItem");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var VirtualList = /** @class */ (function (_super) {
    __extends(VirtualList, _super);
    function VirtualList() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.scrollView = null;
        _this.content = null;
        _this.itemPrefabs = [];
        /**是否垂直滑动 */
        _this.vertical = true;
        /**是否水平滑动 */
        _this.horizontal = false;
        _this.layoutType = cc.Layout.Type.VERTICAL;
        _this.paddingLeft = 0;
        _this.paddingRight = 0;
        _this.paddingTop = 0;
        _this.paddingBottom = 0;
        _this.spacingX = 0;
        _this.spacingY = 0;
        _this.verticalDirection = cc.Layout.VerticalDirection.TOP_TO_BOTTOM;
        _this.horizontalDirection = cc.Layout.HorizontalDirection.LEFT_TO_RIGHT;
        _this.autoSizeItem = false;
        /**
         * 自定义渲染绑定函数 item可以不用挂载组件
         * @param index 数据索引
         * @param node 当前渲染的节点
         */
        _this.itemRender = function () { };
        /**
         * 外部绑定的查找 index 的方法  默认0
         */
        _this.getItemResIndex = function () { return 0; };
        _this.dataList = [];
        _this.itemMap = new Map();
        _this.itemPool = new Map();
        _this.itemPositions = [];
        /**item 与预制体不一致时记录下来 */
        _this.itemSizes = [];
        _this.columnCount = 1;
        return _this;
    }
    VirtualList.prototype.onLoad = function () {
        this.content = this.scrollView.content;
        if (!this.vertical && !this.horizontal) {
            console.error("请设置水平或竖直滑动");
        }
        this.scrollView.vertical = this.vertical;
        this.scrollView.horizontal = this.horizontal;
        this.scrollView.node.on('scrolling', this.onScrolling, this);
        this.initAnchor();
    };
    /**初始化content 锚点  也可以在属性面板手动设置 */
    VirtualList.prototype.initAnchor = function () {
        if (this.vertical) {
            this.content.anchorX = 0.5;
            if (this.verticalDirection == cc.Layout.VerticalDirection.TOP_TO_BOTTOM) {
                this.content.anchorY = 1;
            }
            else {
                this.content.anchorY = 0;
            }
        }
        else if (this.horizontal) {
            this.content.anchorY = 0.5;
            if (this.horizontalDirection == cc.Layout.HorizontalDirection.LEFT_TO_RIGHT) {
                this.content.anchorX = 0;
            }
            else {
                this.content.anchorX = 1;
            }
        }
    };
    VirtualList.prototype.onDestroy = function () {
        this.dataList = null;
        this.itemMap.forEach(function (item) {
            item.destroy();
        });
        this.itemMap.clear();
        this.itemPool.forEach(function (pool) {
            pool.forEach(function (item) {
                item.destroy();
            });
        });
        this.itemPool.clear();
    };
    VirtualList.prototype.getItemPrefabIndex = function (index) {
        var _a;
        return ((_a = this.getItemResIndex) === null || _a === void 0 ? void 0 : _a.call(this, index)) || 0;
    };
    /**通过数据下标获取对应预制体*/
    VirtualList.prototype.getItemPrefabByIndex = function (index) {
        var prefabIndex = this.getItemPrefabIndex(index);
        var prefab = this.itemPrefabs[prefabIndex];
        if (!prefab) {
            console.error("VirtualList 预制体数组中没有对应索引的预制体");
        }
        return prefab;
    };
    /**
     * 设置数据
     */
    VirtualList.prototype.setData = function (dataList) {
        this.recycle();
        this.dataList = dataList;
        if (this.layoutType == cc.Layout.Type.GRID) {
            this.calcGridLayout();
        }
        else if (this.layoutType == cc.Layout.Type.VERTICAL) {
            if (this.autoSizeItem) {
                this.calculateAutoItem();
            }
            else {
                this.calcVerticalLayout();
            }
        }
        else if (this.layoutType == cc.Layout.Type.HORIZONTAL) {
            this.calcHorizontalLayout();
        }
        this.onScrolling();
    };
    /**
     * 网格布局计算
     */
    VirtualList.prototype.calcGridLayout = function () {
        var prefab = this.itemPrefabs[0];
        this.itemPositions = [];
        var contentWidth = this.content.width;
        var contentHeight = this.content.height;
        var itemW = prefab.data.width;
        var itemH = prefab.data.height;
        if (this.vertical) {
            this.columnCount = Math.max(1, Math.floor((contentWidth - this.paddingLeft - this.paddingRight + this.spacingX) / (itemW + this.spacingX)));
            var totalRows = Math.ceil(this.dataList.length / this.columnCount);
            var totalHeight = totalRows * itemH + (totalRows - 1) * this.spacingY + this.paddingTop + this.paddingBottom;
            this.content.height = Math.max(totalHeight, this.scrollView.node.height);
            var dir = this.verticalDirection == cc.Layout.VerticalDirection.TOP_TO_BOTTOM ? -1 : 1;
            for (var i = 0; i < this.dataList.length; i++) {
                var row = Math.floor(i / this.columnCount);
                var col = i % this.columnCount;
                var x = -contentWidth / 2 + this.paddingLeft + itemW / 2 + col * (itemW + this.spacingX);
                var y = -this.paddingTop - itemH / 2 - row * (itemH + this.spacingY);
                y *= -dir;
                this.itemPositions.push(new cc.Vec2(x, y));
            }
        }
        else {
            var rowCount = Math.max(1, Math.floor((contentHeight - this.paddingTop - this.paddingBottom + this.spacingY) / (itemH + this.spacingY)));
            var totalCols = Math.ceil(this.dataList.length / rowCount);
            var totalWidth = totalCols * itemW + (totalCols - 1) * this.spacingX + this.paddingLeft + this.paddingRight;
            this.content.width = Math.max(totalWidth, this.scrollView.node.width);
            var dir = this.horizontalDirection === cc.Layout.HorizontalDirection.LEFT_TO_RIGHT ? 1 : -1;
            for (var i = 0; i < this.dataList.length; i++) {
                var col = Math.floor(i / rowCount);
                var row = i % rowCount;
                var x = dir * (this.paddingLeft + itemW / 2 + col * (itemW + this.spacingX));
                var y = this.content.height / 2 + -this.paddingTop - itemH / 2 - row * (itemH + this.spacingY);
                this.itemPositions.push(new cc.Vec2(x, y));
            }
        }
    };
    /**垂直布局计算 */
    VirtualList.prototype.calcVerticalLayout = function () {
        this.itemPositions = [];
        var y = this.paddingTop;
        var lastY = 0;
        var dir = this.verticalDirection == cc.Layout.VerticalDirection.TOP_TO_BOTTOM ? -1 : 1;
        for (var i = 0; i < this.dataList.length; i++) {
            var prefab = this.getItemPrefabByIndex(i);
            var height = prefab.data.height;
            y += lastY / 2 + height / 2 + this.spacingY;
            lastY = height;
            this.itemPositions.push(new cc.Vec2(0, y * dir));
        }
        y += lastY / 2 + this.paddingBottom;
        this.content.height = Math.max(y, this.scrollView.node.height);
    };
    VirtualList.prototype.calcHorizontalLayout = function () {
        this.itemPositions = [];
        var x = this.paddingLeft;
        var lastX = 0;
        for (var i = 0; i < this.dataList.length; i++) {
            var prefab = this.getItemPrefabByIndex(i);
            ;
            var width = prefab.data.width;
            x += lastX / 2 + width / 2 + this.spacingX;
            lastX = width;
            var dir = this.horizontalDirection == cc.Layout.HorizontalDirection.LEFT_TO_RIGHT ? 1 : -1;
            this.itemPositions.push(new cc.Vec2(x * dir, 0));
        }
        x += lastX / 2 + this.paddingRight;
        this.content.width = Math.max(x, this.scrollView.node.width);
    };
    /**
     * 滚动时动态创建/回收节点
     */
    VirtualList.prototype.onScrolling = function () {
        var scrollVieWidth = this.scrollView.node.width;
        var scrollVieHeight = this.scrollView.node.height;
        var contentX = this.content.x;
        var contentY = this.content.y;
        //视图外缓冲区可见大小   可优化点,判断滚动方向, 如往下滚动时,当前item在滚动视图下方时且不在可视区,那么他后面的item也不再,可以直接跳出循环
        var buffer = 200;
        for (var i = 0; i < this.dataList.length; i++) {
            var itemWidth = 0;
            var itemHeight = 0;
            if (this.autoSizeItem) {
                itemWidth = this.itemSizes[i].width;
                itemHeight = this.itemSizes[i].height;
            }
            else {
                var item = this.getItemPrefabByIndex(i);
                itemWidth = item.data.width;
                itemHeight = item.data.height;
            }
            var pos = this.itemPositions[i];
            var localX = pos.x + contentX;
            var localY = pos.y + contentY;
            var outView = localX + itemWidth / 2 + buffer < -scrollVieWidth / 2
                || localX - itemWidth / 2 - buffer > scrollVieWidth / 2
                || localY + itemHeight / 2 + buffer < -scrollVieHeight / 2
                || localY - itemHeight / 2 - buffer > scrollVieHeight / 2;
            if (outView) {
                this.recycleItemByIndex(i);
            }
            else {
                this.updateItemByIndex(i);
            }
        }
    };
    VirtualList.prototype.updateItemByIndex = function (index) {
        var _a;
        var node = this.itemMap.get(index);
        if (!node) {
            //在列表的不需要更新
            var type = this.getItemResIndex(index);
            if (!this.itemPool.has(type))
                this.itemPool.set(type, []);
            var pool = this.itemPool.get(type);
            node = pool.length > 0 ? pool.pop() : this.instantiateByType(index);
            node.setParent(this.content);
            var pos = this.itemPositions[index];
            node.setPosition(pos);
            this.itemMap.set(index, node);
            (_a = this.itemRender) === null || _a === void 0 ? void 0 : _a.call(this, index, node);
        }
    };
    VirtualList.prototype.recycleItemByIndex = function (index) {
        var _a;
        var node = this.itemMap.get(index);
        if (!node) {
            return;
        }
        var type = ((_a = this.getItemResIndex) === null || _a === void 0 ? void 0 : _a.call(this, index)) || 0;
        this.itemMap.delete(index);
        node.removeFromParent();
        if (!this.itemPool.has(type))
            this.itemPool.set(type, []);
        this.itemPool.get(type).push(node);
    };
    VirtualList.prototype.recycle = function () {
        var _this = this;
        this.itemMap.forEach(function (node, index) {
            _this.recycleItemByIndex(index);
        });
        this.itemMap.clear();
        this.itemPositions = [];
        this.itemSizes = [];
        this.itemPool.forEach(function (pool) { return pool.forEach(function (n) { return n.removeFromParent(); }); });
    };
    VirtualList.prototype.instantiateByType = function (index) {
        var _a;
        var prefab = this.itemPrefabs[((_a = this.getItemResIndex) === null || _a === void 0 ? void 0 : _a.call(this, index)) || 0];
        var node = cc.instantiate(prefab);
        if (this.onItemClick) {
            node.on("click", this.clickItem, this);
        }
        return node;
    };
    /**
     * 获取指定 index 对应的 item 节点（在屏幕内时返回，不可见返回 null）
     */
    VirtualList.prototype.getItemNode = function (index) {
        var _a;
        return (_a = this.itemMap.get(index)) !== null && _a !== void 0 ? _a : null;
    };
    VirtualList.prototype.clickItem = function (button) {
        var _this = this;
        this.itemMap.forEach(function (node, index) {
            if (button.node == node) {
                _this.onItemClick(index, node);
            }
        });
    };
    /**
 * 滚动到指定 index 的 item（垂直/水平/网格皆适配）
 * @param index item 下标
 * @param duration 滚动动画时长（默认 0.3 秒）
 */
    VirtualList.prototype.scrollToIndex = function (index, duration) {
        if (duration === void 0) { duration = 0.3; }
        if (index < 0 || index >= this.itemPositions.length)
            return;
        var targetPos = this.itemPositions[index];
        var viewSize = this.scrollView.node;
        var contentSize = this.content;
        var offset;
        if (this.vertical) {
            var contentHeight = contentSize.height;
            var viewHeight = viewSize.height;
            var anchorOffset = contentHeight * (1 - contentSize.anchorY);
            var itemY = -targetPos.y + anchorOffset;
            // 中心偏移
            var scrollY = itemY - viewHeight / 2;
            var maxScrollY = contentHeight - viewHeight;
            var clampedY = Math.max(0, Math.min(scrollY, maxScrollY));
            offset = new cc.Vec2(0, clampedY);
        }
        else if (this.horizontal) {
            var contentWidth = contentSize.width;
            var viewWidth = viewSize.width;
            var anchorOffset = contentWidth * contentSize.anchorX;
            var itemX = targetPos.x + anchorOffset;
            var scrollX = itemX - viewWidth / 2;
            var maxScrollX = contentWidth - viewWidth;
            var clampedX = Math.max(0, Math.min(scrollX, maxScrollX));
            offset = new cc.Vec2(clampedX, 0);
        }
        this.scrollView.scrollToOffset(offset, duration);
    };
    VirtualList.prototype.calculateAutoItem = function () {
        this.itemPositions = [];
        var y = 0 + this.paddingTop;
        var lastY = 0;
        var dir = this.verticalDirection == cc.Layout.VerticalDirection.TOP_TO_BOTTOM ? -1 : 1;
        //创建item加入场景=>设置item数据,更新itemcc.Layout 回收
        for (var i = 0; i < this.dataList.length; i++) {
            var prefabIndex = this.getItemPrefabIndex(i);
            var node = null;
            var pool = this.itemPool.get(prefabIndex);
            if (!pool) {
                pool = [];
                this.itemPool.set(prefabIndex, pool);
            }
            if (pool.length) {
                node = pool.pop();
            }
            else {
                var prefab = this.getItemPrefabByIndex(i);
                node = cc.instantiate(prefab);
            }
            this.scrollView.node.parent.addChild(node);
            //手动更新渲染组件 获取大小 
            var comp = node.getComponent(VirtualItem_1.VirtualItem);
            if (!comp) {
                throw new Error("不固定大小的预制体请挂载组件 继承VirtualItem");
                return;
            }
            comp.setData(i, this.dataList[i]);
            node.getComponentsInChildren(cc.Label).forEach(function (e) {
                //@ts-ignore
                e._forceUpdateRenderData(true);
            });
            node.getComponentsInChildren(cc.Layout).forEach(function (e) {
                e.updateLayout();
            });
            node.getComponent(cc.Layout).updateLayout();
            var height = node.height;
            var width = node.width;
            this.itemSizes.push({ width: width, height: height });
            y += lastY / 2 + height / 2 + this.spacingY;
            lastY = height;
            this.itemPositions.push(new cc.Vec2(0, y * dir));
            node.removeFromParent();
            pool.push(node);
        }
        y += lastY / 2 + this.paddingBottom;
        this.content.height = Math.max(y, this.scrollView.node.height);
    };
    VirtualList.prototype.scrollToTop = function (timeInSconds) {
        this.scrollView.stopAutoScroll();
        this.scrollView.scrollToTop(timeInSconds);
        if (!timeInSconds) {
            this.onScrolling();
        }
    };
    VirtualList.prototype.scrollToBottom = function (timeInSconds) {
        this.scrollView.stopAutoScroll();
        this.scrollView.scrollToBottom(timeInSconds);
        if (!timeInSconds) {
            this.onScrolling();
        }
    };
    VirtualList.prototype.scrollToLeft = function (timeInSconds) {
        this.scrollView.stopAutoScroll();
        this.scrollView.scrollToLeft(timeInSconds);
        if (!timeInSconds) {
            this.onScrolling();
        }
    };
    VirtualList.prototype.scrollToRight = function (timeInSconds) {
        this.scrollView.stopAutoScroll();
        this.scrollView.scrollToRight(timeInSconds);
        if (!timeInSconds) {
            this.onScrolling();
        }
    };
    __decorate([
        property(cc.ScrollView)
    ], VirtualList.prototype, "scrollView", void 0);
    __decorate([
        property([cc.Prefab])
    ], VirtualList.prototype, "itemPrefabs", void 0);
    __decorate([
        property(Boolean)
    ], VirtualList.prototype, "vertical", void 0);
    __decorate([
        property(Boolean)
    ], VirtualList.prototype, "horizontal", void 0);
    __decorate([
        property({ type: cc.Layout.Type, tooltip: "布局类型  竖直,水平,网格 " })
    ], VirtualList.prototype, "layoutType", void 0);
    __decorate([
        property()
    ], VirtualList.prototype, "paddingLeft", void 0);
    __decorate([
        property()
    ], VirtualList.prototype, "paddingRight", void 0);
    __decorate([
        property()
    ], VirtualList.prototype, "paddingTop", void 0);
    __decorate([
        property()
    ], VirtualList.prototype, "paddingBottom", void 0);
    __decorate([
        property()
    ], VirtualList.prototype, "spacingX", void 0);
    __decorate([
        property()
    ], VirtualList.prototype, "spacingY", void 0);
    __decorate([
        property({
            type: cc.Layout.VerticalDirection,
            visible: function () {
                return this.vertical;
            }
        })
    ], VirtualList.prototype, "verticalDirection", void 0);
    __decorate([
        property({
            type: cc.Layout.HorizontalDirection,
            visible: function () {
                return this.horizontal;
            }
        })
    ], VirtualList.prototype, "horizontalDirection", void 0);
    __decorate([
        property({
            type: Boolean, tooltip: "item请继承VirtualItem， 暂时只实现竖直非网格排序,其他排序好像没有场景使用,自动适配item大小,如聊天item",
            visible: function () {
                return this.vertical;
            }
        })
    ], VirtualList.prototype, "autoSizeItem", void 0);
    VirtualList = __decorate([
        ccclass('VirtualList')
    ], VirtualList);
    return VirtualList;
}(cc.Component));
exports.VirtualList = VirtualList;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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