
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scrollview/chatItem/ChatView.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '51ca9IXA1dNNZf8CVCe8WY9', 'ChatView');
// scrollview/chatItem/ChatView.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChatView = void 0;
var VirtualList_1 = require("../VirtualList");
var ChatIItem_1 = require("./ChatIItem");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var ChatView = /** @class */ (function (_super) {
    __extends(ChatView, _super);
    function ChatView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.list = null;
        _this.btnSend = null;
        _this.btnEmoji = null;
        _this.input = null;
        _this.data = [];
        _this.isSelf = true;
        return _this;
    }
    ChatView.prototype.start = function () {
        this.list.itemRender = this.onItemRender.bind(this);
        this.list.getItemResIndex = this.getItemResIndex.bind(this);
        this.btnSend.node.on("click", this.onSendClick, this);
        this.btnEmoji.node.on("click", this.onClickEmoji, this);
    };
    ChatView.prototype.onItemRender = function (index, node) {
        var chatInfo = this.data[index];
        node.getComponent(ChatIItem_1.ChatIItem).setData(index, chatInfo);
    };
    ChatView.prototype.getItemResIndex = function (index) {
        var chatInfo = this.data[index];
        if (chatInfo.self) {
            return chatInfo.emoji ? 2 : 0;
        }
        else {
            return chatInfo.emoji ? 3 : 1;
        }
    };
    ChatView.prototype.onSendClick = function () {
        var text = this.input.string;
        if (!text) {
            return;
        }
        this.data.push({ self: this.isSelf, text: text, emoji: "" });
        this.list.setData(this.data);
        this.list.scrollToBottom();
        this.input.string = "";
        this.isSelf = !this.isSelf;
    };
    ChatView.prototype.onClickEmoji = function () {
        this.data.push({ self: this.isSelf, text: "", emoji: "emoji" });
        this.list.setData(this.data);
        this.list.scrollToBottom();
        this.isSelf = !this.isSelf;
    };
    __decorate([
        property(VirtualList_1.VirtualList)
    ], ChatView.prototype, "list", void 0);
    __decorate([
        property(cc.Button)
    ], ChatView.prototype, "btnSend", void 0);
    __decorate([
        property(cc.Button)
    ], ChatView.prototype, "btnEmoji", void 0);
    __decorate([
        property(cc.EditBox)
    ], ChatView.prototype, "input", void 0);
    ChatView = __decorate([
        ccclass('ChatView')
    ], ChatView);
    return ChatView;
}(cc.Component));
exports.ChatView = ChatView;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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