"use strict";
cc._RF.push(module, '51ca9IXA1dNNZf8CVCe8WY9', 'ChatView');
// scrollview/chatItem/ChatView.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChatView = void 0;
var VirtualList_1 = require("../VirtualList");
var ChatIItem_1 = require("./ChatIItem");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var ChatView = /** @class */ (function (_super) {
    __extends(ChatView, _super);
    function ChatView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.list = null;
        _this.btnSend = null;
        _this.btnEmoji = null;
        _this.input = null;
        _this.data = [];
        _this.isSelf = true;
        return _this;
    }
    ChatView.prototype.start = function () {
        this.list.itemRender = this.onItemRender.bind(this);
        this.list.getItemResIndex = this.getItemResIndex.bind(this);
        this.btnSend.node.on("click", this.onSendClick, this);
        this.btnEmoji.node.on("click", this.onClickEmoji, this);
    };
    ChatView.prototype.onItemRender = function (index, node) {
        var chatInfo = this.data[index];
        node.getComponent(ChatIItem_1.ChatIItem).setData(index, chatInfo);
    };
    ChatView.prototype.getItemResIndex = function (index) {
        var chatInfo = this.data[index];
        if (chatInfo.self) {
            return chatInfo.emoji ? 2 : 0;
        }
        else {
            return chatInfo.emoji ? 3 : 1;
        }
    };
    ChatView.prototype.onSendClick = function () {
        var text = this.input.string;
        if (!text) {
            return;
        }
        this.data.push({ self: this.isSelf, text: text, emoji: "" });
        this.list.setData(this.data);
        this.list.scrollToBottom();
        this.input.string = "";
        this.isSelf = !this.isSelf;
    };
    ChatView.prototype.onClickEmoji = function () {
        this.data.push({ self: this.isSelf, text: "", emoji: "emoji" });
        this.list.setData(this.data);
        this.list.scrollToBottom();
        this.isSelf = !this.isSelf;
    };
    __decorate([
        property(VirtualList_1.VirtualList)
    ], ChatView.prototype, "list", void 0);
    __decorate([
        property(cc.Button)
    ], ChatView.prototype, "btnSend", void 0);
    __decorate([
        property(cc.Button)
    ], ChatView.prototype, "btnEmoji", void 0);
    __decorate([
        property(cc.EditBox)
    ], ChatView.prototype, "input", void 0);
    ChatView = __decorate([
        ccclass('ChatView')
    ], ChatView);
    return ChatView;
}(cc.Component));
exports.ChatView = ChatView;

cc._RF.pop();