
import { _decorator, Component, Node, Label } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = QScrollViewItem
 * DateTime = Tue Mar 01 2022 11:58:22 GMT+0800 (中国标准时间)
 * Author = IMI4197
 * FileBasename = QScrollViewItem.ts
 * FileBasenameNoExtension = QScrollViewItem
 * URL = db://assets/scripts/QScrollViewItem.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/zh/
 *
 */

export interface IQScrollViewItem_SetData {
    /** 问题索引 */
    index: number
    /** 问题简单描述 */
    desc: string
}

@ccclass('QScrollViewItem')
export class QScrollViewItem extends Component {
    /** 问题索引 */
    @property({ type: Label, tooltip: "问题索引" })
    labelIndex: Label = null

    /** 问题简单描述 */
    @property({ type: Label, tooltip: "问题简单描述" })
    labelDesc: Label = null

    private _clickCb: (data: IQScrollViewItem_SetData) => void

    private _data: IQScrollViewItem_SetData

    setData(data: IQScrollViewItem_SetData) {
        this._data = data
        this.labelIndex.string = data.index.toString()
        this.labelDesc.string = data.desc

        this.labelDesc.updateRenderData(true)
        this.node._uiProps.uiTransformComp.height = this.labelDesc.node._uiProps.uiTransformComp.height + 60
    }

    setClickCb(cb: (data: IQScrollViewItem_SetData) => void) {
        this._clickCb = cb
    }

    btnClick() {
        this._clickCb && this._clickCb(this._data)
    }
}
