
import { _decorator, Component, Node, MotionStreak, Color, Button, Prefab, instantiate, sp, labelAssembler, view, View, game, Socket, EventTouch, Label, Layers } from 'cc';
import { IQScrollViewItem_SetData, QScrollViewItem } from './QScrollViewItem';
import { TestItemForQ3 } from './TestItemForQ3';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = TestView
 * DateTime = Tue Mar 01 2022 10:03:48 GMT+0800 (中国标准时间)
 * Author = IMI4197
 * FileBasename = TestView.ts
 * FileBasenameNoExtension = TestView
 * URL = db://assets/scripts/TestView.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/zh/
 * 3.4.1 BUG反馈用测试类
 */

@ccclass('TestView')
export class TestView extends Component {
    /** 实例化的item父节点 */
    @property({ type: Node, tooltip: "实例化的item父节点" })
    itemParent: Node = null

    /** 跳转用预制体 */
    @property({ type: Prefab, tooltip: "跳转用预制体" })
    preItem: Prefab = null

    /** 当前打开的问题节点索引 */
    private _curQIndex: number = -1

    onLoad() {
        // 隐藏所有子节点 BUG应该通过点击滚动容器子节点来展示
        for (let i = 0; i < this.node.children.length; i++) {
            this.node.children[i].active = false
        }

        // 适配测试
        console.log("getVisibleSizeInPixel", view.getVisibleSizeInPixel())
        console.log("getVisibleSize", view.getVisibleSize())
        console.log("getScale", view.getScaleX(), view.getScaleY())
        console.log("getViewportRect", view.getViewportRect())
        console.log("screen", screen.width, screen.height)
        console.log("game.canvas", game.canvas.width, game.canvas.height)

        // console.log(Socket)
    }

    start() {
        let indexArr: number[] = [4]
        let qDescArr: string[] = [
            "MotionStreak.color设置失败", // 已修复
            "带有Widget组件的Button在active为true时 同一帧执行active=false active=true后无法响应点击", // 已修复
            "调用destroyRenderData报错chunk",
            "组件没有经历onLoad，不会触发onDestroy",
            "滚动容器+preventSwallow导致的事件丢失问题"
        ]

        for (let i = 0; i < indexArr.length; i++) {
            let index = indexArr[i]
            let item = instantiate(this.preItem)
            this.itemParent.addChild(item)
            let comp = item.getComponent(QScrollViewItem)
            comp.setClickCb(this._onQScrollViewItemClick.bind(this))
            comp.setData({ index: index, desc: qDescArr[index] })
        }
    }

    /**
     * 实例化的预制体被点击
     * @param data 
     */
    private _onQScrollViewItemClick(data: IQScrollViewItem_SetData) {
        let index = data.index
        this.updateQIndex(index)
    }

    /**
     * 更新需要显示的问题节点索引
     * @param index 
     * @returns 
     */
    updateQIndex(index: number) {
        if (this._curQIndex == index) {
            return
        }

        let children = this.node.children
        let openedNode = children[this._curQIndex]
        if (openedNode) {
            openedNode.active = false
        }
        this._curQIndex = index

        let waitToOpenNode = children[this._curQIndex]
        if (waitToOpenNode) {
            waitToOpenNode.active = true

            // 执行对应的测试方法
            if (this[`_q${this._curQIndex}`]) {
                console.log(`执行_q${this._curQIndex}方法`)
                this[`_q${this._curQIndex}`]()
            } else {
                console.warn(`没有_q${this._curQIndex}方法`)
            }
        } else {
            console.warn(`父节点没有索引为${this._curQIndex}的子节点`)
        }
    }

    //#region q4 滚动容器+preventSwallow导致的事件丢失问题
    /** 滚动容器content节点 */
    private _q4_content: Node = null

    private _q4() {
        let parent = this.node.children[4]
        let _q4_content = parent.getChildByName("ScrollView").getChildByName("view").getChildByName("content")

        // （1）
        // 操作步骤 
        // 先将鼠标移动到A区域并按住，将鼠标移动到A区域外（不松手），此时Console面板中会打印A1节点响应Cancel事件，但A0没有响应。
        // 将鼠标移动回A区域并松手，发现A0依旧没有响应任何事件。

        // （2）
        // 此时，若
        // 情况1：点击空白处，则A0响应Cancel事件
        // 情况2：点击A节点，则A1A0会响应Start和END事件。（再点击空白处A0不响应Cancel事件，事件丢失）
        // 情况3：若点击C节点，则C1C0会响应Start和END事件。（再点击空白处A0会响应Cancel事件）

        // （3）
        // 若按照（1）操作A节点和C节点之后，点击空白处两次，会依次响应C0的Cancel事件和A0的Cancel事件

        // （4）
        // 若正常操作，按住A节点之后，将鼠标移动到A区域外并松手，A1响应了两次Cancel事件

        // （5）
        // 仿照（1）操作C节点之后，点击A节点，会发现A1A0只响应了Start事件。点击空白处之后，A1A0响应Cancel事件。

        // 提问：看了scroll-view的源码，在处理Move事件时若发生滑动，会发送cancel事件给event.target。在这里，event.target是A1，但为啥这个事件没有穿透到A0？
        // 有什么影响？：我是仿Button做了个按钮组件，自己写了Scale的过渡效果，事件丢失导致我过渡效果表现不正常。

        let f = (key: string, x: number) => {
            for (let i = 0; i < 2; i++) {
                let node = new Node()
                node.setParent(_q4_content)
                node.setPosition(x, -50)
                node.layer = Layers.Enum.UI_2D
                let label = node.addComponent(Label)
                label.string = key

                let isPressed = false

                node.on(Node.EventType.TOUCH_START, (event: EventTouch) => {
                    if (i == 1) {
                        event.preventSwallow = true
                    }
                    isPressed = true
                    console.log("START", key, i)
                })
                node.on(Node.EventType.MOUSE_MOVE, (event: EventTouch) => {
                    if (i == 1) {
                        event.preventSwallow = true
                    }
                    if (!isPressed) {
                        return
                    }
                    // console.log("MOVE", key, i)
                })
                node.on(Node.EventType.TOUCH_END, (event: EventTouch) => {
                    if (i == 1) {
                        event.preventSwallow = true
                    }
                    if (!isPressed) {
                        return
                    }
                    isPressed = false
                    console.log("END", key, i)
                })
                node.on(Node.EventType.TOUCH_CANCEL, (event: EventTouch) => {
                    if (i == 1) {
                        event.preventSwallow = true
                    }
                    console.log("BEFORE CANCEL", key, i, isPressed)
                    if (!isPressed) {
                        return
                    }
                    isPressed = false
                    console.log("CANCEL", key, i)
                })
            }
        }


        f("A", -50)
        // f("B", 0)
        f("C", 50)
    }

    //#endregion

    //#region q3

    private _q3_beDestroyParent: Node = null

    /**
     * 组件没有经历onLoad，不会触发onDestroy
     */
    private _q3() {
        let node = this.node.children[3]
        this._q3_beDestroyParent = node.getChildByName("BeDestroyParent")
    }

    q3_showParentClick() {
        this._q3_beDestroyParent.active = true
    }

    q3_hideParentClick() {
        this._q3_beDestroyParent.active = false
    }

    q3_destroyNodeClick() {
        let node = new Node()
        node.addComponent(TestItemForQ3)
        this._q3_beDestroyParent.addChild(node)
        node.destroy()
    }

    //#endregion

    //#region q2
    private _q2_skeleton: sp.Skeleton = null

    /**
     * 调用destroyRenderData报错chunk
     */
    private _q2() {
        this._q2_skeleton = this.node.children[2].getChildByName("20000_body_2").getComponent(sp.Skeleton)
        this._q2_skeleton.paused = false;
        this._q2_skeleton.timeScale = 1;
    }

    q2_destroyRendenDataClick() {
        if (this._q2_skeleton) {
            this._q2_skeleton.paused = true;
            this._q2_skeleton.timeScale = 0;
            this._q2_skeleton.destroyRenderData()

        }
    }
    //#endregion

    //#region q1
    private _q1ButtonNode: Node = null

    /**
     * Button节点内如果有Widget组件 Button节点在同一帧执行active=false active=true 会导致节点无法监听点击事件
     * 如果不带Widget组件则无事 虽然正常情况下不会这么写逻辑 但窗体管理时可能会出现该情景
     */
    private _q1() {
        let parent = this.node.children[1]
        this._q1ButtonNode = parent.children[0]
    }

    q1_showButtonClick() {
        this._q1ButtonNode.active = true
    }

    q1_hideButtonClick() {
        this._q1ButtonNode.active = false
    }

    q1_hideAndShowButtonClick() {
        this._q1ButtonNode.active = false
        this._q1ButtonNode.active = true
    }
    //#endregion

    /** 
     * MotionStreak.color设置失败
     * 报错：this._assembler.updateColor
     */
    private _q0() {
        let parent = this.node.children[0]
        let motion = parent.children[0]
        motion.getComponent(MotionStreak).color = Color.BLACK
    }
}