
import { _decorator, Component, Node, Prefab, instantiate } from 'cc';
import { root } from './root';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = Canvas
 * DateTime = Tue Feb 08 2022 17:10:56 GMT+0800 (中国标准时间)
 * Author = 鄙人姓鄙
 * FileBasename = Canvas.ts
 * FileBasenameNoExtension = Canvas
 * URL = db://assets/Canvas.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/zh/
 *
 */
 
@ccclass('Canvas')
export class Canvas extends Component {
    // [1]
    // dummy = '';

    @property(Prefab)
    public item: Prefab | null = null;
    root: Node;

    start () {
        var node = instantiate(this.item);
        node.parent = this.node;
        this.root = node;
        // [3]
    }

    clickRefresh() {
        this.root.active = true;
        this.root.getComponent(root).refreshView();
    }

    clickClose(){
        this.root.active = false;
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/zh/scripting/decorator.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/zh/scripting/life-cycle-callbacks.html
 */
