
import { _decorator, Component, Node, NodePool, Prefab, instantiate, v3 } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = root
 * DateTime = Tue Feb 08 2022 16:03:35 GMT+0800 (中国标准时间)
 * Author = 鄙人姓鄙
 * FileBasename = root.ts
 * FileBasenameNoExtension = root
 * URL = db://assets/root.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/zh/
 *
 */

@ccclass('root')
export class root extends Component {
    @property(Node)
    public content: Node | null = null;
    @property(Prefab)
    public item: Prefab | null = null;

    pool: NodePool;

    onLoad() {
        this.pool = new NodePool('pool')
        this.refreshView();
    }

    refreshView() {

        var cells = [];
        for (var i = 0 , len = this.content.children.length; i < len; i++) {
            var obj = this.content.children[i];
            cells.push(obj);
        }

        if (cells.length > 0) {
            var t1 = cells[0];
            cells[0] = cells[2];
            cells[2] = t1;
        }

        for (var i = 0 , len = cells.length; i < len; i++) {
            var cell = cells[i];
            this.pool.put(cell);
        }

        var list = [1,2,3];
        var data = {
            prefab: this.item,
            list: list,
            content: this.content,
        };

        //NOTE: 只要不是同一帧内执行removeFromParent  setParent就不会有问题
        // setTimeout(() => {
        //     this.refreshContentView(data);
        // }, 0);


        this.refreshContentView(data);
        
    }

    refreshContentView(data: { prefab: Prefab; content: Node; list: any[]; scriptName?: string; ext?: any; ext2?: any; ext3?: any;  }) {
        var prefab = data.prefab;
        var content = data.content;
        var list = data.list;
        var scriptName = data.scriptName || prefab.data.name;
        var ext = data.ext;
        var ext2 = data.ext2;
        var ext3 = data.ext3;


        var result: any[] = [];
        for (var i = 0, len = list.length; i < len; i++) {
            var info = list[i];
            var item = content.children[i];
            if (!item) {
                item = this.getPool(prefab);
                item.parent = content;
            }

            item.position = v3((-300 + i * 200),item.position.y )
            var script = item.getComponent(scriptName);
            if (script && script.init) {
                script.init(i, info, ext, ext2, ext3);
            }
        }
    
        return result;
    }

    getPool(prefab) {
        var node =this.pool.get();
        if (!node) {
            node = instantiate(prefab);
        }
        return node
    }



    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/zh/scripting/decorator.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/zh/scripting/life-cycle-callbacks.html
 */
