
import { _decorator, Component, Node, Material, MeshRenderer, resources } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Set')
export class Set extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    @property({ type: MeshRenderer })
    target: MeshRenderer | null = null;


    start() {
        resources.load("material", Material, null, (error, asset) => {
            if (error) {

                return;
            }
            this.target!.material = asset;
        });
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.0/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.0/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.0/manual/en/scripting/life-cycle-callbacks.html
 */
