import { _decorator, Component, instantiate, Node, PhysicsSystem2D, Prefab, v2 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {

    @property(Prefab)
    itemPre: Prefab = null

    start() {
        PhysicsSystem2D.instance.enable = true;//开启物理引擎
        PhysicsSystem2D.instance.gravity = v2(0, -2000);//重力值

        for (let i = 0; i < 20; i++) {
            let item = instantiate(this.itemPre);
            item.parent = this.node;
            item.setPosition(0, -360 + i * 110, 0);
        }
    }

}


