import {_decorator,VideoClip,Component,VideoPlayer,Node,Button,Label,macro,sys,Slider,ProgressBar,systemEvent,SystemEventType,Touch} from "cc";
// import { Device } from "../Device/Device";
// import EventManager from "../EventManager/EventManager";
// import {ZFEventName} from "../ZFConfigManager";

const {ccclass, property} = _decorator;

export enum Enmu_VideoCtrlStage{
    // VSC_NoVideoPanel = 0,
    VCS_DisPlayPanel= 1,
    VCS_PausePanel= 2,
    VCS_ClosePanel =3,
}


@ccclass
export default class VideoManagerTest extends Component {
    private static instance:VideoManagerTest;

    constructor(){ //定义构造函数
        super();
    }

    public static getInstance(): VideoManagerTest {
        if (!VideoManagerTest.instance) {
            VideoManagerTest.instance = new VideoManagerTest();
        }
        return this.instance;
    }

    /**
     * 本地视频
     */
    @property(VideoClip)
    public videClip: VideoClip = null!;

    /**
     * 默认空置UI
     */
    @property(Node)
    private playVideoArea:Node = null;

     /**
     * 视频组件
     */
    @property(VideoPlayer)
    public videoPanel:VideoPlayer = null;

    // @property(Node)
    // private event_Mask:Node = null;

    @property(Button)
    private btn_videoReturn:Button = null;

    @property(Button)
    private btn_videoPause:Button = null;

    @property(Button)
    private btn_videoPlay:Button = null;

    @property(Node)
    private timeCtrl: Node = null;

    @property(Label)
    private lebTime:Label = null;

    @property(Node)
    private videoCtrlPanel:Node | null= null;

    @property
    private isAotoPlay:boolean = false;

    @property
    private playUrl:string = "";

    private upbg:Node;
    private downbg:Node;
    private bgmask:Node;

    @property(Node)         //testNode
    public stayOnBottomTips: Node = null!;



    private c_videoCtrlStage = Enmu_VideoCtrlStage.VCS_ClosePanel;


    isFirstPlay = false;
    isFristLoadAndroid=false;
    cur_stage=VideoPlayer.EventType.STOPPED;

    onLoad () {
        // console.log("-------------onLoad-------------");
        if(!VideoManagerTest.instance)
            VideoManagerTest.instance = this;
        macro.ENABLE_TRANSPARENT_CANVAS = true;
        this.upbg = this.videoCtrlPanel.getChildByName("ui_upbg");
        this.downbg = this.videoCtrlPanel.getChildByName("ui_downbg");
        this.bgmask = this.videoCtrlPanel.getChildByName("bgMask");


        this.videoPanel.stayOnBottom =true;
        // videoPanel.style.zIndex = 1;
        this.setVideoCtrlStage(Enmu_VideoCtrlStage.VCS_ClosePanel);
    }

    start () {
        // console.log("-------------start-------------");
        // if (sys.OS_ANDROID === sys.os||sys.OS_IOS === sys.os) {
        //     console.log("不是目标平台跳过——————————————————");
        //     return;
        // }
        // director.setClearColor(new Color(0,0,0,0));
        // let video0 = document.getElementsByClassName('cocosVideo')[0];
        // // console.log(video0);
        // video0.style.zIndex = 5;
        //
        // let gCanvas = document.getElementsByClassName('gameCanvas')[0];
        // // console.log(gCanvas);
        // gCanvas.style.position = 'relative';
        // gCanvas.style.zIndex = 10;
        // Camera.main.backgroundColor = color(0, 0, 0, 0);
        // this.videoPanel.keepAspectRatio = false;

        let self = this;
        // this.event_Mask.on(Node.EventType.TOUCH_START, function (event:any) {
        //     console.log("触摸事件——————————————");
        //     if(self.c_videoCtrlStage==Enmu_VideoCtrlStage.VSC_NoVideoPanel){
        //         return;
        //     }
        //     if(self.c_videoCtrlStage==Enmu_VideoCtrlStage.VCS_ClosePanel){
        //         self.setVideoCtrlStage(Enmu_VideoCtrlStage.VCS_DisPlayPanel);
        //     }else if(self.c_videoCtrlStage==Enmu_VideoCtrlStage.VCS_PausePanel){
        //         return;
        //     }
        //     else{
        //         self.setVideoCtrlStage(Enmu_VideoCtrlStage.VCS_ClosePanel);
        //     }
        // });

        this.bgmask.on(SystemEventType.TOUCH_START, function (touch:Touch) {
            self.onTouchScreen();
        }, this);


        // this.bgmask.on('click', this.eventClick.bind(this),this);
        this.setTimeCtrl(0);
        // this.videoPanel.node.on('ready-to-play', this.loadcallback, this);

        // Device.init();

        // if(Device.isWeb){

        // }else{
        //     if(this.playUrl)
        //         this.playURLVideo(this.playUrl);
        // }

        this.videoPanel.stayOnBottom = true;
        if(this.playUrl)
            this.playURLVideo(this.playUrl);
    }

    public onTouchScreen(){
        // console.log("触摸事件——————————————"+touch.getLocation());
        // if(self.c_videoCtrlStage==Enmu_VideoCtrlStage.VSC_NoVideoPanel){
        //     self.setVideoCtrlStage(Enmu_VideoCtrlStage.VCS_DisPlayPanel);
        //     return;
        // }
        if(this.c_videoCtrlStage==Enmu_VideoCtrlStage.VCS_ClosePanel){
            this.setVideoCtrlStage(Enmu_VideoCtrlStage.VCS_DisPlayPanel);
        }else if(this.c_videoCtrlStage==Enmu_VideoCtrlStage.VCS_PausePanel){
            return;
        }
        else{
            this.setVideoCtrlStage(Enmu_VideoCtrlStage.VCS_ClosePanel);
        }
    }


    // _touchStart(touch: Touch) {
    //     let content = `touch startLocation:  ${touch.getStartLocation()} \n`;
    //     content += `UI touch startLocation:  ${touch.getUIStartLocation()} \n`
    // }

    public loadVideoUrl(url:string){
        this.videoPanel.remoteURL = url;
        this.videoPanel.node.on('ready-to-play', this.loadcallback, this);
    }


    // public setLoadCallback(callback){
    //     this.videoPanel.node.on('ready-to-play', this.loadcallback.bind(this)(callback), this);
    // }

    private setTimeCtrl(progress:number){
        let slider = this.timeCtrl.getComponent(Slider);
        let progressbar = this.timeCtrl.getComponent(ProgressBar);
        slider.progress=progress;
        progressbar.progress = progress;
    }

    public setVideoCtrlStage(videoCtrlStage:Enmu_VideoCtrlStage){
        this.c_videoCtrlStage = videoCtrlStage;
        switch (this.c_videoCtrlStage){
            // case Enmu_VideoCtrlStage.VSC_NoVideoPanel:
            //     this.playVideoArea.active = true;
            //     this.btn_videoPause.node.active = false;
            //     this.btn_videoPlay.node.active = false;
            //     this.btn_videoReturn.node.active = false;
            //     this.timeCtrl.active = false;
            //     this.upbg.active =false;
            //     this.downbg.active =false;
            //     break;
            case Enmu_VideoCtrlStage.VCS_DisPlayPanel:
                this.playVideoArea.active = false;
                this.btn_videoPause.node.active = true;
                this.btn_videoPlay.node.active = false;
                this.btn_videoReturn.node.active = false;
                this.timeCtrl.active = true;
                this.upbg.active =true;
                this.downbg.active =true;
                break;
            case Enmu_VideoCtrlStage.VCS_PausePanel:
                this.playVideoArea.active = false;
                this.btn_videoPause.node.active = false;
                this.btn_videoPlay.node.active = true;
                this.btn_videoReturn.node.active = true;
                this.timeCtrl.active = true;
                this.upbg.active =false;
                this.downbg.active =false;
                break;
            case Enmu_VideoCtrlStage.VCS_ClosePanel:
                this.playVideoArea.active = false;
                this.btn_videoPause.node.active = false;
                this.btn_videoPlay.node.active =  false;
                this.btn_videoReturn.node.active = false;
                this.timeCtrl.active = false;
                this.upbg.active =false;
                this.downbg.active =false;
                // this.videoPanel.active = false;
                break;
        }
    }

    // private loadcallback(event,callback) {
    //     this.setVideoCtrlStage(Enmu_VideoCtrlStage.VCS_ClosePanel);
    //     if(this.isAotoPlay){
    //         this.videoPanel.play();
    //         if(callback)
    //             callback();
    //         console.log("载入完确定播放——————————————————");
    //     }
    // }

    private loadcallback(event:any) {
        this.setVideoCtrlStage(Enmu_VideoCtrlStage.VCS_ClosePanel);
        this.isFirstPlay = true;
        console.log("视频载入——————————————————");
        if(this.isAotoPlay){
            this.clickPause();
            console.log("改为Pause状态——————————————————");
        }
    }


    // bingCruxUI(playVideoArea,videoPanel,event_Mask,btn_return,btn_videoPause){
    //     this.playVideoArea=playVideoArea;
    //     this.videoPanel=videoPanel;
    //     this.event_Mask=event_Mask;
    //     this.btn_return=btn_return;
    //     this.btn_videoPause=this.btn_videoPause;
    // }

    public getStatus (event:any) {
        switch (event) {
            case VideoPlayer.EventType.PLAYING:
                return 'PLAYING';
            case VideoPlayer.EventType.PAUSED:
                return 'PAUSED';
            case VideoPlayer.EventType.STOPPED:
                return 'STOPPED';
            case VideoPlayer.EventType.COMPLETED:
                return 'COMPLETED';
            case VideoPlayer.EventType.META_LOADED:
                return 'META_LOADED';
            case VideoPlayer.EventType.CLICKED:
                return 'CLICKED';
            case VideoPlayer.EventType.READY_TO_PLAY:
                return 'READY_TO_PLAY';
            default:
                return 'NONE';
        }
    }

    private onVideoPlayerEvent(sender:any, event:any) {
       let statusLabel = '_________________Status: ' + this.getStatus(event);
       console.log(statusLabel);

        if (event === VideoPlayer.EventType.CLICKED) {
            if (this.videoPanel.isPlaying) {
                this.videoPanel.pause();
                this.btn_videoPause.node.active=true;
                console.log("这里暂停了——————————————————");
            } else {
                this.videoPanel.play();
                this.btn_videoPause.node.active=false;
            }
        }
        else if(event === VideoPlayer.EventType.META_LOADED){
            // this.playVideoArea.active = true;
        }
        else if (event === VideoPlayer.EventType.READY_TO_PLAY || event === VideoPlayer.EventType.META_LOADED) {
            this.playVideoArea.active = false;
            if (sys.OS_ANDROID === sys.os) {
                this.isFristLoadAndroid=false;
                this.videoPanel.play();
            }
        }
        else if (event === VideoPlayer.EventType.PLAYING) {
            this.playVideoArea.active = false;
            this.isFristLoadAndroid=true;
        }
        else if(event === VideoPlayer.EventType.COMPLETED){
            // NotificationCenter.getInstance().fire({type:"videoStage",message:"videoplayEnd"});
            // EventManager.getInstance().dispatchEvent(ZFEventName.VideoOver);
        }
        this.cur_stage=event;
        console.log("结束check"+statusLabel);
    }

    // androidAotoPlayLogic(){
    //     if (sys.OS_ANDROID === sys.os)
    //     {
    //         if(this.cur_stage==VideoPlayer.EventType.READY_TO_PLAY)
    //         {
    //             if(!this.isFristLoadAndroid){
    //                 this.event_Mask.emit('androidAotoPlay', 'pro');
    //                 console.log("我需要播放——————————————————");
    //             }
    //         }
    //     }
    // }

    public playURLVideo(url:string){
        this.videoPanel.resourceType = VideoPlayer.ResourceType.REMOTE;
        this.videoPanel.remoteURL = url;
        this.btn_videoPause.node.active=false;
        this.videoPanel.play();
    }

    public playLocalVideo(){
        this.videoPanel.resourceType = VideoPlayer.ResourceType.LOCAL;
        this.btn_videoPause.node.active=false;
        this.videoPanel.play();
    }


    public setFullsize(){
        // this.videoPanel.isFullscreen=true;
        this.videoPanel.fullScreenOnAwake = true;
    }

    clickBack(){
        console.log("-------------clickBack-------------");
        // director.loadScene('menu');
        let url = 'http://download.cocos.org/CocosTest/test-case/movie.mp4';
        this.playURLVideo(url)
    }

    clickPlay(){
        console.log("-------------clickPlay-------------");
        // if(this.isFirstPlay){
        //     EventManager.getInstance().dispatchEvent(EventName.VideoPlay);
        //     this.isFirstPlay = false;
        // }
        // EventManager.getInstance().dispatchEvent(ZFEventName.VideoPlay);
        if(this.videoPanel){
            this.videoPanel.play();
            this.setVideoCtrlStage(Enmu_VideoCtrlStage.VCS_ClosePanel);
        }else {
            this.reBindVideoPanel();
        }
    }

    clickPause(isDisStage=true){
        console.log("-------------clickPause-------------");
        if(this.videoPanel){
            // EventManager.getInstance().dispatchEvent(ZFEventName.VideoPause);
            this.videoPanel.pause();
            if(isDisStage)
                this.setVideoCtrlStage(Enmu_VideoCtrlStage.VCS_PausePanel);
        }else {
            this.reBindVideoPanel();
        }
    }

    clickStop(){
        console.log("-------------clickStop-------------");
        if(this.videoPanel){
            this.videoPanel.stop();
        }else {
            this.reBindVideoPanel();
        }
    }

    onSliderEvent (sender:any, eventType:any) {
        // @ts-ignore
        // let toTime = this.videoPanel.getDuration().toFixed(2)*sender.progress;
        let toTime = this.videoPanel.duration*sender.progress;
        this.setTimeCtrl(sender.progress);
        console.log("播放时间————————————————————"+toTime);
        this.videoPanel.currentTime = toTime;
        this.videoPanel.play();
    }

    update(){
        // this.androidAotoPlayLogic();
        if (this.videoPanel.currentTime >= 0) {
            let timeStr = this.videoPanel.currentTime.toFixed(2) + ' / ' + this.videoPanel.duration.toFixed(2);
            // console.log("播放时间————————————————————"+timeStr);
            this.lebTime.string = timeStr;
            let c_p = this.videoPanel.currentTime/this.videoPanel.duration;
            this.setTimeCtrl(c_p);
        }
    }

    public getCurrentTime(){
        return this.videoPanel.currentTime.toFixed(2);
    }

    public getVideoMaxTime(){
        // return this.videoPanel.getDuration().toFixed(2);
        return this.videoPanel.duration.toFixed(2);
    }

    public videoPause(){
        this.videoPanel.pause();
    }

    public videoPlay(){
        this.videoPanel.play();
    }

    private reBindVideoPanel(){
        console.log("重绑定VideoPanel_______________");
        let videopanel = this.node.getChildByName("viewVideo").getComponent(VideoPlayer);
        this.videoPanel = videopanel;
    }


    public onStayOnBottom () {
        this.videoPanel.stayOnBottom = !this.videoPanel.stayOnBottom;
        this.stayOnBottomTips.active = this.videoPanel.stayOnBottom;
    }







}

