'use strict';

module.exports = {
  load() {
    // execute when package loaded
    Editor.log('spine-previewer load succ');
    console.log('aaa bbb ccc')
  },

  unload() {
    // execute when package unloaded
  },

  // register your ipc messages here
  messages: {
    'open'() {
      // open entry panel registered in package.json
      Editor.Panel.open('spine-previewer');
    },
    'say-hello'() {
      Editor.log('Hello World!');
      // send ipc message to panel
      Editor.Ipc.sendToPanel('spine-previewer', 'spine-previewer:hello');
    },
    'clicked'() {
      Editor.log('Button clicked!');
    },

    'scene:animation-time-changed' (event) {
      Editor.log('scene:animation-time-changed', event)
    },

    'timeline:edit-event'(event) {
      Editor.log('timeline:edit-event', event)
    }
  },
};