module.exports = {
    env: {
        browser: true,
        node: true
    },
    extends: [
        'eslint:recommended',
        'plugin:@typescript-eslint/recommended'
    ],
    parser: '@typescript-eslint/parser',
    parserOptions: {
        sourceType: 'module'
    },
    plugins: [
        '@typescript-eslint'
    ],
    globals: {
        Editor: true,
        cc: true,
        CC_PHYSICS_BUILTIN: true,
        CC_PHYSICS_CANNON: true
    },
    rules: {
        '@typescript-eslint/ban-ts-comment': 0,
        '@typescript-eslint/ban-types': 0,
        '@typescript-eslint/explicit-module-boundary-types': 0,
        '@typescript-eslint/no-empty-function': 0,
        '@typescript-eslint/no-explicit-any': 0,
        '@typescript-eslint/no-var-requires': 0,
        '@typescript-eslint/semi': ['error', 'always'],
        '@typescript-eslint/quotes': ['error', 'single'],
        'space-before-function-paren': ['error', { 'anonymous': 'always', 'named': 'never', 'asyncArrow': 'always' }],
        '@typescript-eslint/object-curly-spacing': ['error', 'always'],
        'prefer-const': 0,
        'no-multiple-empty-lines': ['error', { max: 1, maxEOF: 1 }],
        'arrow-spacing': ['error', { before: true, after: true }],
        'space-infix-ops': 'error',
        'comma-spacing': 'error',
        '@typescript-eslint/no-inferrable-types': ['error', { ignoreParameters: true, ignoreProperties: true }]
    }
};
