import { _decorator, Component, sp } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('NewComponent')
export class NewComponent extends Component {


    spp: sp.Skeleton;

    start() {
        this.spp = this.getComponentInChildren(sp.Skeleton);


    }

    onClick(e, data) {
        if (data == "1") {
            this.setSpineSkins(this.spp, ["face/200807","hat/600106", "hair/600101", "lower/100003"]);
        } else {
            this.setSpineSkins(this.spp, ["face/500707", "hat/600206","hair/600201", "lower/503303"]);
        }
    }

    public setSpineSkins(spine: sp.Skeleton, skinNames: string[]) {
        if (!spine?.isValid) return;
        const skeleton = spine._skeleton;
        const runtimeData = spine.skeletonData.getRuntimeData();
        const newSkin = new sp.spine.Skin("newSkin");
        for (const skinName of skinNames) {
            let skin = runtimeData.findSkin(skinName);
            if (skin) {
                newSkin.addSkin(skin);
            } else {
                console.warn("皮肤未找到:" + skinName);
            }
        }
        skeleton.setSkin(newSkin);
        skeleton.setSlotsToSetupPose();
    }

}


