import { TextureCamera } from "./TextureCamera";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {
    start() {
        let board: cc.Node = this.node.getChildByName("board");
        let tex2D = TextureCamera.getInstance().GenerateTexture(cc.instantiate(board));
        let capturenode = this.node.getChildByName("capturenode");
        let sf = new cc.SpriteFrame(tex2D);
        capturenode.getComponent(cc.Sprite).spriteFrame = sf;
        let restart: cc.Node = this.node.getChildByName("restart");
        restart.on(cc.Node.EventType.TOUCH_END, () => {
            cc.game.restart();
        });
    }
}
