"use strict";
cc._RF.push(module, 'ce683R+qLtIW6ngub7H1pCh', 'TextureCamera');
// Script/TextureCamera.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextureCamera = void 0;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var TextureCamera = /** @class */ (function (_super) {
    __extends(TextureCamera, _super);
    function TextureCamera() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.textureCamera = null;
        return _this;
    }
    TextureCamera_1 = TextureCamera;
    TextureCamera.getInstance = function () {
        return this._instance;
    };
    TextureCamera.prototype.onLoad = function () {
        this.canvas = cc.find("Canvas");
        this.textureCamera = this.node.getComponent(cc.Camera);
        TextureCamera_1._instance = this;
    };
    TextureCamera.prototype.GenerateTexture = function (target) {
        var width = target.width;
        var height = target.height;
        // 挂载
        target.group = "TextureCapture";
        target.setPosition(cc.Vec2.ZERO);
        target.parent = this.canvas;
        // 生成纹理
        var texture = new cc.RenderTexture;
        texture.initWithSize(width, height);
        this.textureCamera.targetTexture = texture;
        this.textureCamera.render(target);
        // 卸载
        target.group = "default";
        target.parent = null;
        target.destroy();
        target = null;
        // 翻转
        var data = texture.readPixels();
        var length = data.length;
        var data2 = new Uint8Array(length);
        for (var i = 0; i < length; i++) {
            var row02 = parseInt(i / (4 * width) + "");
            var row01 = height - row02 - 1;
            var index = row01 * width * 4 + i % (4 * width);
            data2[i] = data[index];
        }
        var tex = new cc.RenderTexture();
        tex.initWithData(data2, texture.getPixelFormat(), width, height);
        //texture.destroy();
        return tex;
    };
    var TextureCamera_1;
    TextureCamera._instance = null;
    TextureCamera = TextureCamera_1 = __decorate([
        ccclass
    ], TextureCamera);
    return TextureCamera;
}(cc.Component));
exports.TextureCamera = TextureCamera;

cc._RF.pop();