import { _decorator, assetManager, Component, director, Prefab } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Test')
export class Test extends Component {

    @property({
        type: Prefab
    })
    private asset: Prefab = null!;


    protected start(): void {
        this.printRefCount();
        this.scheduleOnce(() => {
            director.loadScene('Test2', () => {
                console.log('跳转场景后');
                this.printRefCount();
            });
        }, 1);
    }

    private printRefCount() {
        assetManager.assets.forEach((item) => {
            if (item?.name === 'Asset') {
                console.log(item?.name, item?.refCount, item?.isValid);
            }
            if (item?.name === 'splash') {
                console.log(item?.name, item?.refCount, item?.isValid);
            }
        });
    }
}

